// third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_ROUTER_RULE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_ROUTER_RULE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared-internal.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class ServiceWorkerRouterRunningStatusConditionDataView;

class ServiceWorkerRouterRequestConditionDataView;

class ServiceWorkerRouterOrConditionDataView;

class ServiceWorkerRouterNotConditionDataView;

class ServiceWorkerRouterConditionDataView;

class ServiceWorkerRouterNetworkSourceDataView;

class ServiceWorkerRouterRaceSourceDataView;

class ServiceWorkerRouterFetchEventSourceDataView;

class ServiceWorkerRouterCacheSourceDataView;

class ServiceWorkerRouterRuleDataView;

class ServiceWorkerRouterRulesDataView;

class ServiceWorkerRouterSourceDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterRunningStatusConditionDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterRunningStatusCondition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterRequestConditionDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterRequestCondition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterOrConditionDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterOrCondition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterNotConditionDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterNotCondition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterConditionDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterCondition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterNetworkSourceDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterNetworkSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterRaceSourceDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterRaceSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterFetchEventSourceDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterFetchEventSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterCacheSourceDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterCacheSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterRuleDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterRule_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterRulesDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterRules_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRouterSourceDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRouterSource_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ServiceWorkerRouterRunningStatusEnum : int32_t {
  
  kRunning = 0,
  
  kNotRunning = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ServiceWorkerRouterRunningStatusEnum value);
inline bool IsKnownEnumValue(ServiceWorkerRouterRunningStatusEnum value) {
  return internal::ServiceWorkerRouterRunningStatusEnum_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ServiceWorkerRouterRaceSourceEnum : int32_t {
  
  kNetworkAndFetchHandler = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ServiceWorkerRouterRaceSourceEnum value);
inline bool IsKnownEnumValue(ServiceWorkerRouterRaceSourceEnum value) {
  return internal::ServiceWorkerRouterRaceSourceEnum_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServiceWorkerRouterRunningStatusConditionDataView {
 public:
  ServiceWorkerRouterRunningStatusConditionDataView() = default;

  ServiceWorkerRouterRunningStatusConditionDataView(
      internal::ServiceWorkerRouterRunningStatusCondition_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterRunningStatusEnum>(
        data_value, output);
  }
  ServiceWorkerRouterRunningStatusEnum status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerRouterRunningStatusEnum>(data_->status));
  }
 private:
  internal::ServiceWorkerRouterRunningStatusCondition_Data* data_ = nullptr;
};


class ServiceWorkerRouterRequestConditionDataView {
 public:
  ServiceWorkerRouterRequestConditionDataView() = default;

  ServiceWorkerRouterRequestConditionDataView(
      internal::ServiceWorkerRouterRequestCondition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `method` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMethod` instead "
    "of `ReadMethod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_mode() const {
    return data_->has_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::network::mojom::RequestMode>(
        data_value, output);
  }
  ::network::mojom::RequestMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestMode>(data_->mode));
  }
  bool has_destination() const {
    return data_->has_destination;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) const {
    auto data_value = data_->destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->destination));
  }
 private:
  internal::ServiceWorkerRouterRequestCondition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerRouterOrConditionDataView {
 public:
  ServiceWorkerRouterOrConditionDataView() = default;

  ServiceWorkerRouterOrConditionDataView(
      internal::ServiceWorkerRouterOrCondition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConditionsDataView(
      mojo::ArrayDataView<ServiceWorkerRouterConditionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConditions(UserType* output) {
    
    auto* pointer = data_->conditions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerRouterConditionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerRouterOrCondition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerRouterNotConditionDataView {
 public:
  ServiceWorkerRouterNotConditionDataView() = default;

  ServiceWorkerRouterNotConditionDataView(
      internal::ServiceWorkerRouterNotCondition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConditionDataView(
      ServiceWorkerRouterConditionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCondition(UserType* output) {
    
    auto* pointer = data_->condition.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterConditionDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerRouterNotCondition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerRouterConditionDataView {
 public:
  ServiceWorkerRouterConditionDataView() = default;

  ServiceWorkerRouterConditionDataView(
      internal::ServiceWorkerRouterCondition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlPatternDataView(
      ::blink::mojom::SafeUrlPatternDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlPattern(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SafeUrlPatternDataView, UserType>(),
    "Attempting to read the optional `url_pattern` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrlPattern` instead "
    "of `ReadUrlPattern if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url_pattern.Get();
    return mojo::internal::Deserialize<::blink::mojom::SafeUrlPatternDataView>(
        pointer, output, message_);
  }
  inline void GetRequestDataView(
      ServiceWorkerRouterRequestConditionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerRouterRequestConditionDataView, UserType>(),
    "Attempting to read the optional `request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequest` instead "
    "of `ReadRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterRequestConditionDataView>(
        pointer, output, message_);
  }
  inline void GetRunningStatusDataView(
      ServiceWorkerRouterRunningStatusConditionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRunningStatus(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerRouterRunningStatusConditionDataView, UserType>(),
    "Attempting to read the optional `running_status` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRunningStatus` instead "
    "of `ReadRunningStatus if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->running_status.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterRunningStatusConditionDataView>(
        pointer, output, message_);
  }
  inline void GetOrConditionDataView(
      ServiceWorkerRouterOrConditionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrCondition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerRouterOrConditionDataView, UserType>(),
    "Attempting to read the optional `or_condition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOrCondition` instead "
    "of `ReadOrCondition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->or_condition.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterOrConditionDataView>(
        pointer, output, message_);
  }
  inline void GetNotConditionDataView(
      ServiceWorkerRouterNotConditionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNotCondition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerRouterNotConditionDataView, UserType>(),
    "Attempting to read the optional `not_condition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNotCondition` instead "
    "of `ReadNotCondition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->not_condition.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterNotConditionDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerRouterCondition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerRouterNetworkSourceDataView {
 public:
  ServiceWorkerRouterNetworkSourceDataView() = default;

  ServiceWorkerRouterNetworkSourceDataView(
      internal::ServiceWorkerRouterNetworkSource_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ServiceWorkerRouterNetworkSource_Data* data_ = nullptr;
};


class ServiceWorkerRouterRaceSourceDataView {
 public:
  ServiceWorkerRouterRaceSourceDataView() = default;

  ServiceWorkerRouterRaceSourceDataView(
      internal::ServiceWorkerRouterRaceSource_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTarget(UserType* output) const {
    auto data_value = data_->target;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterRaceSourceEnum>(
        data_value, output);
  }
  ServiceWorkerRouterRaceSourceEnum target() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerRouterRaceSourceEnum>(data_->target));
  }
 private:
  internal::ServiceWorkerRouterRaceSource_Data* data_ = nullptr;
};


class ServiceWorkerRouterFetchEventSourceDataView {
 public:
  ServiceWorkerRouterFetchEventSourceDataView() = default;

  ServiceWorkerRouterFetchEventSourceDataView(
      internal::ServiceWorkerRouterFetchEventSource_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ServiceWorkerRouterFetchEventSource_Data* data_ = nullptr;
};


class ServiceWorkerRouterCacheSourceDataView {
 public:
  ServiceWorkerRouterCacheSourceDataView() = default;

  ServiceWorkerRouterCacheSourceDataView(
      internal::ServiceWorkerRouterCacheSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCacheNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cache_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCacheName` instead "
    "of `ReadCacheName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cache_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerRouterCacheSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerRouterRuleDataView {
 public:
  ServiceWorkerRouterRuleDataView() = default;

  ServiceWorkerRouterRuleDataView(
      internal::ServiceWorkerRouterRule_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConditionDataView(
      ServiceWorkerRouterConditionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCondition(UserType* output) {
    
    auto* pointer = data_->condition.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterConditionDataView>(
        pointer, output, message_);
  }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<ServiceWorkerRouterSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerRouterSourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerRouterRule_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerRouterRulesDataView {
 public:
  ServiceWorkerRouterRulesDataView() = default;

  ServiceWorkerRouterRulesDataView(
      internal::ServiceWorkerRouterRules_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRulesDataView(
      mojo::ArrayDataView<ServiceWorkerRouterRuleDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRules(UserType* output) {
    
    auto* pointer = data_->rules.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerRouterRuleDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerRouterRules_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerRouterSourceDataView {
 public:
  using Tag = internal::ServiceWorkerRouterSource_Data::ServiceWorkerRouterSource_Tag;

  ServiceWorkerRouterSourceDataView() = default;

  ServiceWorkerRouterSourceDataView(
      internal::ServiceWorkerRouterSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_network_source() const { return data_->tag == Tag::kNetworkSource; }
  inline void GetNetworkSourceDataView(
      ServiceWorkerRouterNetworkSourceDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkSource(UserType* output) const {
    
    CHECK(is_network_source());
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterNetworkSourceDataView>(
        data_->data.f_network_source.Get(), output, message_);
  }
  bool is_race_source() const { return data_->tag == Tag::kRaceSource; }
  inline void GetRaceSourceDataView(
      ServiceWorkerRouterRaceSourceDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRaceSource(UserType* output) const {
    
    CHECK(is_race_source());
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterRaceSourceDataView>(
        data_->data.f_race_source.Get(), output, message_);
  }
  bool is_fetch_event_source() const { return data_->tag == Tag::kFetchEventSource; }
  inline void GetFetchEventSourceDataView(
      ServiceWorkerRouterFetchEventSourceDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFetchEventSource(UserType* output) const {
    
    CHECK(is_fetch_event_source());
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterFetchEventSourceDataView>(
        data_->data.f_fetch_event_source.Get(), output, message_);
  }
  bool is_cache_source() const { return data_->tag == Tag::kCacheSource; }
  inline void GetCacheSourceDataView(
      ServiceWorkerRouterCacheSourceDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCacheSource(UserType* output) const {
    
    CHECK(is_cache_source());
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerRouterCacheSourceDataView>(
        data_->data.f_cache_source.Get(), output, message_);
  }

 private:
  internal::ServiceWorkerRouterSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::ServiceWorkerRouterRunningStatusEnum>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ServiceWorkerRouterRunningStatusEnum> {};

template <>
struct hash<::blink::mojom::ServiceWorkerRouterRaceSourceEnum>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ServiceWorkerRouterRaceSourceEnum> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterRunningStatusEnum, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ServiceWorkerRouterRunningStatusEnum, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ServiceWorkerRouterRunningStatusEnum>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterRaceSourceEnum, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ServiceWorkerRouterRaceSourceEnum, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ServiceWorkerRouterRaceSourceEnum>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterRunningStatusConditionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterRunningStatusConditionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterRunningStatusCondition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRunningStatusEnum>(
        Traits::status(input), &fragment->status);
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterRunningStatusCondition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterRunningStatusConditionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterRequestConditionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterRequestConditionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterRequestCondition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method, method_fragment);
    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());
    fragment->has_mode = Traits::has_mode(input);
    mojo::internal::Serialize<::network::mojom::RequestMode>(
        Traits::mode(input), &fragment->mode);
    fragment->has_destination = Traits::has_destination(input);
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::destination(input), &fragment->destination);
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterRequestCondition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterRequestConditionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterOrConditionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterOrConditionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterOrCondition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::conditions(input)) in_conditions = Traits::conditions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->conditions)::BaseType>
        conditions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& conditions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerRouterConditionDataView>>(
        in_conditions, conditions_fragment, &conditions_validate_params);
    fragment->conditions.Set(
        conditions_fragment.is_null() ? nullptr : conditions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->conditions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conditions in ServiceWorkerRouterOrCondition struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterOrCondition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterOrConditionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterNotConditionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterNotConditionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterNotCondition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::condition(input)) in_condition = Traits::condition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->condition)::BaseType> condition_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterConditionDataView>(
        in_condition, condition_fragment);
    fragment->condition.Set(
        condition_fragment.is_null() ? nullptr : condition_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->condition.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null condition in ServiceWorkerRouterNotCondition struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterNotCondition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterNotConditionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterConditionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterConditionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterCondition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url_pattern(input)) in_url_pattern = Traits::url_pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_pattern)::BaseType> url_pattern_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::SafeUrlPatternDataView>(
        in_url_pattern, url_pattern_fragment);
    fragment->url_pattern.Set(
        url_pattern_fragment.is_null() ? nullptr : url_pattern_fragment.data());
    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRequestConditionDataView>(
        in_request, request_fragment);
    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());
    decltype(Traits::running_status(input)) in_running_status = Traits::running_status(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->running_status)::BaseType> running_status_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRunningStatusConditionDataView>(
        in_running_status, running_status_fragment);
    fragment->running_status.Set(
        running_status_fragment.is_null() ? nullptr : running_status_fragment.data());
    decltype(Traits::or_condition(input)) in_or_condition = Traits::or_condition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->or_condition)::BaseType> or_condition_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterOrConditionDataView>(
        in_or_condition, or_condition_fragment);
    fragment->or_condition.Set(
        or_condition_fragment.is_null() ? nullptr : or_condition_fragment.data());
    decltype(Traits::not_condition(input)) in_not_condition = Traits::not_condition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->not_condition)::BaseType> not_condition_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterNotConditionDataView>(
        in_not_condition, not_condition_fragment);
    fragment->not_condition.Set(
        not_condition_fragment.is_null() ? nullptr : not_condition_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterCondition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterConditionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterNetworkSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterNetworkSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterNetworkSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterNetworkSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterNetworkSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterRaceSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterRaceSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterRaceSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRaceSourceEnum>(
        Traits::target(input), &fragment->target);
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterRaceSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterRaceSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterFetchEventSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterFetchEventSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterFetchEventSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterFetchEventSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterFetchEventSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterCacheSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterCacheSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterCacheSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::cache_name(input)) in_cache_name = Traits::cache_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cache_name)::BaseType> cache_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_cache_name, cache_name_fragment);
    fragment->cache_name.Set(
        cache_name_fragment.is_null() ? nullptr : cache_name_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterCacheSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterCacheSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterRuleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterRuleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterRule_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::condition(input)) in_condition = Traits::condition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->condition)::BaseType> condition_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterConditionDataView>(
        in_condition, condition_fragment);
    fragment->condition.Set(
        condition_fragment.is_null() ? nullptr : condition_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->condition.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null condition in ServiceWorkerRouterRule struct");
    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerRouterSourceDataView>>(
        in_sources, sources_fragment, &sources_validate_params);
    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sources.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sources in ServiceWorkerRouterRule struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterRule_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterRuleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterRulesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRouterRulesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerRouterRules_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::rules(input)) in_rules = Traits::rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rules)::BaseType>
        rules_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServiceWorkerRouterRuleDataView>>(
        in_rules, rules_fragment, &rules_validate_params);
    fragment->rules.Set(
        rules_fragment.is_null() ? nullptr : rules_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rules.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rules in ServiceWorkerRouterRules struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterRules_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterRulesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRouterSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::ServiceWorkerRouterSourceDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::ServiceWorkerRouterSource_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::ServiceWorkerRouterSourceDataView::Tag::kNetworkSource: {
        decltype(Traits::network_source(input))
            in_network_source = Traits::network_source(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_network_source)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterNetworkSourceDataView>(
            in_network_source, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null network_source in ServiceWorkerRouterSource union");
        fragment->data.f_network_source.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::ServiceWorkerRouterSourceDataView::Tag::kRaceSource: {
        decltype(Traits::race_source(input))
            in_race_source = Traits::race_source(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_race_source)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRaceSourceDataView>(
            in_race_source, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null race_source in ServiceWorkerRouterSource union");
        fragment->data.f_race_source.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::ServiceWorkerRouterSourceDataView::Tag::kFetchEventSource: {
        decltype(Traits::fetch_event_source(input))
            in_fetch_event_source = Traits::fetch_event_source(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_fetch_event_source)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterFetchEventSourceDataView>(
            in_fetch_event_source, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null fetch_event_source in ServiceWorkerRouterSource union");
        fragment->data.f_fetch_event_source.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::ServiceWorkerRouterSourceDataView::Tag::kCacheSource: {
        decltype(Traits::cache_source(input))
            in_cache_source = Traits::cache_source(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_cache_source)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterCacheSourceDataView>(
            in_cache_source, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null cache_source in ServiceWorkerRouterSource union");
        fragment->data.f_cache_source.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRouterSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRouterSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void ServiceWorkerRouterRequestConditionDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ServiceWorkerRouterOrConditionDataView::GetConditionsDataView(
    mojo::ArrayDataView<ServiceWorkerRouterConditionDataView>* output) {
  auto pointer = data_->conditions.Get();
  *output = mojo::ArrayDataView<ServiceWorkerRouterConditionDataView>(pointer, message_);
}


inline void ServiceWorkerRouterNotConditionDataView::GetConditionDataView(
    ServiceWorkerRouterConditionDataView* output) {
  auto pointer = data_->condition.Get();
  *output = ServiceWorkerRouterConditionDataView(pointer, message_);
}


inline void ServiceWorkerRouterConditionDataView::GetUrlPatternDataView(
    ::blink::mojom::SafeUrlPatternDataView* output) {
  auto pointer = data_->url_pattern.Get();
  *output = ::blink::mojom::SafeUrlPatternDataView(pointer, message_);
}
inline void ServiceWorkerRouterConditionDataView::GetRequestDataView(
    ServiceWorkerRouterRequestConditionDataView* output) {
  auto pointer = data_->request.Get();
  *output = ServiceWorkerRouterRequestConditionDataView(pointer, message_);
}
inline void ServiceWorkerRouterConditionDataView::GetRunningStatusDataView(
    ServiceWorkerRouterRunningStatusConditionDataView* output) {
  auto pointer = data_->running_status.Get();
  *output = ServiceWorkerRouterRunningStatusConditionDataView(pointer, message_);
}
inline void ServiceWorkerRouterConditionDataView::GetOrConditionDataView(
    ServiceWorkerRouterOrConditionDataView* output) {
  auto pointer = data_->or_condition.Get();
  *output = ServiceWorkerRouterOrConditionDataView(pointer, message_);
}
inline void ServiceWorkerRouterConditionDataView::GetNotConditionDataView(
    ServiceWorkerRouterNotConditionDataView* output) {
  auto pointer = data_->not_condition.Get();
  *output = ServiceWorkerRouterNotConditionDataView(pointer, message_);
}








inline void ServiceWorkerRouterCacheSourceDataView::GetCacheNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cache_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ServiceWorkerRouterRuleDataView::GetConditionDataView(
    ServiceWorkerRouterConditionDataView* output) {
  auto pointer = data_->condition.Get();
  *output = ServiceWorkerRouterConditionDataView(pointer, message_);
}
inline void ServiceWorkerRouterRuleDataView::GetSourcesDataView(
    mojo::ArrayDataView<ServiceWorkerRouterSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<ServiceWorkerRouterSourceDataView>(pointer, message_);
}


inline void ServiceWorkerRouterRulesDataView::GetRulesDataView(
    mojo::ArrayDataView<ServiceWorkerRouterRuleDataView>* output) {
  auto pointer = data_->rules.Get();
  *output = mojo::ArrayDataView<ServiceWorkerRouterRuleDataView>(pointer, message_);
}


inline void ServiceWorkerRouterSourceDataView::GetNetworkSourceDataView(
    ServiceWorkerRouterNetworkSourceDataView* output) const {
  CHECK(is_network_source());
  *output = ServiceWorkerRouterNetworkSourceDataView(data_->data.f_network_source.Get(), message_);
}
inline void ServiceWorkerRouterSourceDataView::GetRaceSourceDataView(
    ServiceWorkerRouterRaceSourceDataView* output) const {
  CHECK(is_race_source());
  *output = ServiceWorkerRouterRaceSourceDataView(data_->data.f_race_source.Get(), message_);
}
inline void ServiceWorkerRouterSourceDataView::GetFetchEventSourceDataView(
    ServiceWorkerRouterFetchEventSourceDataView* output) const {
  CHECK(is_fetch_event_source());
  *output = ServiceWorkerRouterFetchEventSourceDataView(data_->data.f_fetch_event_source.Get(), message_);
}
inline void ServiceWorkerRouterSourceDataView::GetCacheSourceDataView(
    ServiceWorkerRouterCacheSourceDataView* output) const {
  CHECK(is_cache_source());
  *output = ServiceWorkerRouterCacheSourceDataView(data_->data.f_cache_source.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ServiceWorkerRouterRunningStatusEnum> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ServiceWorkerRouterRunningStatusEnum value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ServiceWorkerRouterRaceSourceEnum> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ServiceWorkerRouterRaceSourceEnum value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_ROUTER_RULE_MOJOM_SHARED_H_