// third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT IntrinsicSizingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IntrinsicSizingInfo, T>::value>;
  using DataView = IntrinsicSizingInfoDataView;
  using Data_ = internal::IntrinsicSizingInfo_Data;

  template <typename... Args>
  static IntrinsicSizingInfoPtr New(Args&&... args) {
    return IntrinsicSizingInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IntrinsicSizingInfoPtr From(const U& u) {
    return mojo::TypeConverter<IntrinsicSizingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IntrinsicSizingInfo>::Convert(*this);
  }


  IntrinsicSizingInfo();

  IntrinsicSizingInfo(
      const ::gfx::SizeF& size,
      const ::gfx::SizeF& aspect_ratio,
      bool has_width,
      bool has_height);


  ~IntrinsicSizingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IntrinsicSizingInfoPtr>
  IntrinsicSizingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IntrinsicSizingInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IntrinsicSizingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IntrinsicSizingInfo_UnserializedMessageContext<
            UserType, IntrinsicSizingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IntrinsicSizingInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IntrinsicSizingInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IntrinsicSizingInfo_UnserializedMessageContext<
            UserType, IntrinsicSizingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IntrinsicSizingInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::SizeF size;
  
  ::gfx::SizeF aspect_ratio;
  
  bool has_width;
  
  bool has_height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IntrinsicSizingInfoPtr IntrinsicSizingInfo::Clone() const {
  return New(
      mojo::Clone(size),
      mojo::Clone(aspect_ratio),
      mojo::Clone(has_width),
      mojo::Clone(has_height)
  );
}

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>*>
bool IntrinsicSizingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->aspect_ratio, other_struct.aspect_ratio))
    return false;
  if (!mojo::Equals(this->has_width, other_struct.has_width))
    return false;
  if (!mojo::Equals(this->has_height, other_struct.has_height))
    return false;
  return true;
}

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.aspect_ratio < rhs.aspect_ratio)
    return true;
  if (rhs.aspect_ratio < lhs.aspect_ratio)
    return false;
  if (lhs.has_width < rhs.has_width)
    return true;
  if (rhs.has_width < lhs.has_width)
    return false;
  if (lhs.has_height < rhs.has_height)
    return true;
  if (rhs.has_height < lhs.has_height)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IntrinsicSizingInfo::DataView,
                                         ::blink::mojom::IntrinsicSizingInfoPtr> {
  static bool IsNull(const ::blink::mojom::IntrinsicSizingInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IntrinsicSizingInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IntrinsicSizingInfo::size)& size(
      const ::blink::mojom::IntrinsicSizingInfoPtr& input) {
    return input->size;
  }

  static const decltype(::blink::mojom::IntrinsicSizingInfo::aspect_ratio)& aspect_ratio(
      const ::blink::mojom::IntrinsicSizingInfoPtr& input) {
    return input->aspect_ratio;
  }

  static decltype(::blink::mojom::IntrinsicSizingInfo::has_width) has_width(
      const ::blink::mojom::IntrinsicSizingInfoPtr& input) {
    return input->has_width;
  }

  static decltype(::blink::mojom::IntrinsicSizingInfo::has_height) has_height(
      const ::blink::mojom::IntrinsicSizingInfoPtr& input) {
    return input->has_height;
  }

  static bool Read(::blink::mojom::IntrinsicSizingInfo::DataView input, ::blink::mojom::IntrinsicSizingInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_H_