// third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class WebBluetoothLeScanFilterDataView;

class WebBluetoothCompanyDataView;

class WebBluetoothDataFilterDataView;

class WebBluetoothRequestDeviceOptionsDataView;

class WebBluetoothRequestLEScanOptionsDataView;

class WebBluetoothDeviceIdDataView;

class WebBluetoothDeviceDataView;

class WebBluetoothRemoteGATTServiceDataView;

class WebBluetoothRemoteGATTCharacteristicDataView;

class WebBluetoothAdvertisingEventDataView;

class WebBluetoothRemoteGATTDescriptorDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothLeScanFilterDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothLeScanFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothCompanyDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothCompany_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothDataFilterDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothDataFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRequestDeviceOptionsDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRequestDeviceOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRequestLEScanOptionsDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRequestLEScanOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothDeviceIdDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothDeviceId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothDeviceDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothDevice_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRemoteGATTServiceDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRemoteGATTService_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRemoteGATTCharacteristic_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothAdvertisingEventDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothAdvertisingEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView> {
  using Data = ::blink::mojom::internal::WebBluetoothRemoteGATTDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class WebBluetoothResult : int32_t {
  
  SUCCESS = 0,
  
  WATCH_ADVERTISEMENTS_ABORTED = 1,
  
  GATT_INVALID_ATTRIBUTE_LENGTH = 2,
  
  CONNECT_INVALID_ARGS = 3,
  
  SERVICE_NO_LONGER_EXISTS = 4,
  
  CHARACTERISTIC_NO_LONGER_EXISTS = 5,
  
  PROMPT_CANCELED = 6,
  
  CONNECT_DOES_NOT_EXIST = 7,
  
  CONNECT_ALREADY_IN_PROGRESS = 8,
  
  CONNECT_AUTH_CANCELED = 9,
  
  CONNECT_AUTH_FAILED = 10,
  
  CONNECT_AUTH_REJECTED = 11,
  
  CONNECT_AUTH_TIMEOUT = 12,
  
  CONNECT_UNKNOWN_ERROR = 13,
  
  CONNECT_UNKNOWN_FAILURE = 14,
  
  CONNECT_UNSUPPORTED_DEVICE = 15,
  
  DEVICE_NO_LONGER_IN_RANGE = 16,
  
  GATT_NOT_PAIRED = 17,
  
  GATT_OPERATION_IN_PROGRESS = 18,
  
  CONNECT_CONN_FAILED = 19,
  
  CONNECT_NOT_READY = 20,
  
  CONNECT_ALREADY_CONNECTED = 21,
  
  CONNECT_ALREADY_EXISTS = 22,
  
  CONNECT_NOT_CONNECTED = 23,
  
  CONNECT_NON_AUTH_TIMEOUT = 24,
  
  CONNECT_NO_MEMORY = 25,
  
  CONNECT_JNI_ENVIRONMENT = 26,
  
  CONNECT_JNI_THREAD_ATTACH = 27,
  
  CONNECT_WAKELOCK = 28,
  
  CONNECT_UNEXPECTED_STATE = 29,
  
  CONNECT_SOCKET_ERROR = 30,
  
  NO_BLUETOOTH_ADAPTER = 31,
  
  CHOSEN_DEVICE_VANISHED = 32,
  
  CHOOSER_CANCELLED = 33,
  
  CHOOSER_NOT_SHOWN_API_GLOBALLY_DISABLED = 34,
  
  CHOOSER_NOT_SHOWN_API_LOCALLY_DISABLED = 35,
  
  CHOOSER_NOT_SHOWN_USER_DENIED_PERMISSION_TO_SCAN = 36,
  
  SERVICE_NOT_FOUND = 37,
  
  NO_SERVICES_FOUND = 38,
  
  CHARACTERISTIC_NOT_FOUND = 39,
  
  NO_CHARACTERISTICS_FOUND = 40,
  
  DESCRIPTOR_NOT_FOUND = 41,
  
  NO_DESCRIPTORS_FOUND = 42,
  
  WEB_BLUETOOTH_NOT_SUPPORTED = 43,
  
  BLUETOOTH_LOW_ENERGY_NOT_AVAILABLE = 44,
  
  GATT_UNKNOWN_ERROR = 45,
  
  GATT_UNKNOWN_FAILURE = 46,
  
  GATT_NOT_PERMITTED = 47,
  
  GATT_NOT_SUPPORTED = 48,
  
  GATT_UNTRANSLATED_ERROR_CODE = 49,
  
  GATT_NOT_AUTHORIZED = 50,
  
  BLOCKLISTED_DESCRIPTOR_UUID = 51,
  
  BLOCKLISTED_CHARACTERISTIC_UUID = 52,
  
  BLOCKLISTED_READ = 53,
  
  BLOCKLISTED_WRITE = 54,
  
  NOT_ALLOWED_TO_ACCESS_ANY_SERVICE = 55,
  
  NOT_ALLOWED_TO_ACCESS_SERVICE = 56,
  
  REQUEST_DEVICE_WITH_BLOCKLISTED_UUID_OR_MANUFACTURER_DATA = 57,
  
  DESCRIPTOR_NO_LONGER_EXISTS = 58,
  
  PERMISSIONS_POLICY_VIOLATION = 59,
  
  SCANNING_BLOCKED = 60,
  kMinValue = 0,
  kMaxValue = 60,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebBluetoothResult value);
inline bool IsKnownEnumValue(WebBluetoothResult value) {
  return internal::WebBluetoothResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebBluetoothGATTQueryQuantity : int32_t {
  
  SINGLE = 0,
  
  MULTIPLE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebBluetoothGATTQueryQuantity value);
inline bool IsKnownEnumValue(WebBluetoothGATTQueryQuantity value) {
  return internal::WebBluetoothGATTQueryQuantity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebBluetoothWriteType : int32_t {
  
  kWriteDefaultDeprecated = 0,
  
  kWriteWithResponse = 1,
  
  kWriteWithoutResponse = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, WebBluetoothWriteType value);
inline bool IsKnownEnumValue(WebBluetoothWriteType value) {
  return internal::WebBluetoothWriteType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class WebBluetoothServiceInterfaceBase {};

using WebBluetoothServicePtrDataView =
    mojo::InterfacePtrDataView<WebBluetoothServiceInterfaceBase>;
using WebBluetoothServiceRequestDataView =
    mojo::InterfaceRequestDataView<WebBluetoothServiceInterfaceBase>;
using WebBluetoothServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBluetoothServiceInterfaceBase>;
using WebBluetoothServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBluetoothServiceInterfaceBase>;
class WebBluetoothServerClientInterfaceBase {};

using WebBluetoothServerClientPtrDataView =
    mojo::InterfacePtrDataView<WebBluetoothServerClientInterfaceBase>;
using WebBluetoothServerClientRequestDataView =
    mojo::InterfaceRequestDataView<WebBluetoothServerClientInterfaceBase>;
using WebBluetoothServerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBluetoothServerClientInterfaceBase>;
using WebBluetoothServerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBluetoothServerClientInterfaceBase>;
class WebBluetoothCharacteristicClientInterfaceBase {};

using WebBluetoothCharacteristicClientPtrDataView =
    mojo::InterfacePtrDataView<WebBluetoothCharacteristicClientInterfaceBase>;
using WebBluetoothCharacteristicClientRequestDataView =
    mojo::InterfaceRequestDataView<WebBluetoothCharacteristicClientInterfaceBase>;
using WebBluetoothCharacteristicClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBluetoothCharacteristicClientInterfaceBase>;
using WebBluetoothCharacteristicClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBluetoothCharacteristicClientInterfaceBase>;
class WebBluetoothAdvertisementClientInterfaceBase {};

using WebBluetoothAdvertisementClientPtrDataView =
    mojo::InterfacePtrDataView<WebBluetoothAdvertisementClientInterfaceBase>;
using WebBluetoothAdvertisementClientRequestDataView =
    mojo::InterfaceRequestDataView<WebBluetoothAdvertisementClientInterfaceBase>;
using WebBluetoothAdvertisementClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebBluetoothAdvertisementClientInterfaceBase>;
using WebBluetoothAdvertisementClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebBluetoothAdvertisementClientInterfaceBase>;


class WebBluetoothLeScanFilterDataView {
 public:
  WebBluetoothLeScanFilterDataView() = default;

  WebBluetoothLeScanFilterDataView(
      internal::WebBluetoothLeScanFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServicesDataView(
      mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServices(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>, UserType>(),
    "Attempting to read the optional `services` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServices` instead "
    "of `ReadServices if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->services.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNamePrefixDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNamePrefix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name_prefix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNamePrefix` instead "
    "of `ReadNamePrefix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name_prefix.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetManufacturerDataDataView(
      mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<WebBluetoothDataFilterDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManufacturerData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<::blink::mojom::WebBluetoothDataFilterDataView>>, UserType>(),
    "Attempting to read the optional `manufacturer_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadManufacturerData` instead "
    "of `ReadManufacturerData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->manufacturer_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<::blink::mojom::WebBluetoothDataFilterDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothLeScanFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothCompanyDataView {
 public:
  WebBluetoothCompanyDataView() = default;

  WebBluetoothCompanyDataView(
      internal::WebBluetoothCompany_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t id() const {
    return data_->id;
  }
 private:
  internal::WebBluetoothCompany_Data* data_ = nullptr;
};


class WebBluetoothDataFilterDataView {
 public:
  WebBluetoothDataFilterDataView() = default;

  WebBluetoothDataFilterDataView(
      internal::WebBluetoothDataFilter_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t data() const {
    return data_->data;
  }
  uint8_t mask() const {
    return data_->mask;
  }
 private:
  internal::WebBluetoothDataFilter_Data* data_ = nullptr;
};


class WebBluetoothRequestDeviceOptionsDataView {
 public:
  WebBluetoothRequestDeviceOptionsDataView() = default;

  WebBluetoothRequestDeviceOptionsDataView(
      internal::WebBluetoothRequestDeviceOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFiltersDataView(
      mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>, UserType>(),
    "Attempting to read the optional `filters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFilters` instead "
    "of `ReadFilters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        pointer, output, message_);
  }
  inline void GetExclusionFiltersDataView(
      mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExclusionFilters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>, UserType>(),
    "Attempting to read the optional `exclusion_filters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExclusionFilters` instead "
    "of `ReadExclusionFilters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->exclusion_filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        pointer, output, message_);
  }
  inline void GetOptionalServicesDataView(
      mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalServices(UserType* output) {
    
    auto* pointer = data_->optional_services.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        pointer, output, message_);
  }
  inline void GetOptionalManufacturerDataDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalManufacturerData(UserType* output) {
    
    auto* pointer = data_->optional_manufacturer_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  bool accept_all_devices() const {
    return data_->accept_all_devices;
  }
 private:
  internal::WebBluetoothRequestDeviceOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothRequestLEScanOptionsDataView {
 public:
  WebBluetoothRequestLEScanOptionsDataView() = default;

  WebBluetoothRequestLEScanOptionsDataView(
      internal::WebBluetoothRequestLEScanOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFiltersDataView(
      mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>, UserType>(),
    "Attempting to read the optional `filters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFilters` instead "
    "of `ReadFilters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        pointer, output, message_);
  }
  bool keep_repeated_devices() const {
    return data_->keep_repeated_devices;
  }
  bool accept_all_advertisements() const {
    return data_->accept_all_advertisements;
  }
 private:
  internal::WebBluetoothRequestLEScanOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothDeviceIdDataView {
 public:
  WebBluetoothDeviceIdDataView() = default;

  WebBluetoothDeviceIdDataView(
      internal::WebBluetoothDeviceId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothDeviceId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothDeviceDataView {
 public:
  WebBluetoothDeviceDataView() = default;

  WebBluetoothDeviceDataView(
      internal::WebBluetoothDevice_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      WebBluetoothDeviceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothDevice_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothRemoteGATTServiceDataView {
 public:
  WebBluetoothRemoteGATTServiceDataView() = default;

  WebBluetoothRemoteGATTServiceDataView(
      internal::WebBluetoothRemoteGATTService_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInstanceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceId(UserType* output) {
    
    auto* pointer = data_->instance_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothRemoteGATTService_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothRemoteGATTCharacteristicDataView {
 public:
  WebBluetoothRemoteGATTCharacteristicDataView() = default;

  WebBluetoothRemoteGATTCharacteristicDataView(
      internal::WebBluetoothRemoteGATTCharacteristic_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInstanceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceId(UserType* output) {
    
    auto* pointer = data_->instance_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  uint32_t properties() const {
    return data_->properties;
  }
 private:
  internal::WebBluetoothRemoteGATTCharacteristic_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothAdvertisingEventDataView {
 public:
  WebBluetoothAdvertisingEventDataView() = default;

  WebBluetoothAdvertisingEventDataView(
      internal::WebBluetoothAdvertisingEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceDataView(
      WebBluetoothDeviceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebBluetoothDeviceDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidsDataView(
      mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuids(UserType* output) {
    
    auto* pointer = data_->uuids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        pointer, output, message_);
  }
  bool appearance_is_set() const {
    return data_->appearance_is_set;
  }
  uint16_t appearance() const {
    return data_->appearance;
  }
  bool tx_power_is_set() const {
    return data_->tx_power_is_set;
  }
  uint8_t tx_power() const {
    return data_->tx_power;
  }
  bool rssi_is_set() const {
    return data_->rssi_is_set;
  }
  uint8_t rssi() const {
    return data_->rssi;
  }
  inline void GetManufacturerDataDataView(
      mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManufacturerData(UserType* output) {
    
    auto* pointer = data_->manufacturer_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetServiceDataDataView(
      mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceData(UserType* output) {
    
    auto* pointer = data_->service_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothAdvertisingEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBluetoothRemoteGATTDescriptorDataView {
 public:
  WebBluetoothRemoteGATTDescriptorDataView() = default;

  WebBluetoothRemoteGATTDescriptorDataView(
      internal::WebBluetoothRemoteGATTDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInstanceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceId(UserType* output) {
    
    auto* pointer = data_->instance_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUuidDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebBluetoothRemoteGATTDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::WebBluetoothResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebBluetoothResult> {};

template <>
struct hash<::blink::mojom::WebBluetoothGATTQueryQuantity>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebBluetoothGATTQueryQuantity> {};

template <>
struct hash<::blink::mojom::WebBluetoothWriteType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::WebBluetoothWriteType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebBluetoothResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebBluetoothResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothGATTQueryQuantity, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebBluetoothGATTQueryQuantity, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebBluetoothGATTQueryQuantity>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothWriteType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::WebBluetoothWriteType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::WebBluetoothWriteType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothLeScanFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothLeScanFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothLeScanFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::services(input)) in_services = Traits::services(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->services)::BaseType>
        services_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& services_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        in_services, services_fragment, &services_validate_params);
    fragment->services.Set(
        services_fragment.is_null() ? nullptr : services_fragment.data());
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    decltype(Traits::name_prefix(input)) in_name_prefix = Traits::name_prefix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name_prefix)::BaseType> name_prefix_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name_prefix, name_prefix_fragment);
    fragment->name_prefix.Set(
        name_prefix_fragment.is_null() ? nullptr : name_prefix_fragment.data());
    decltype(Traits::manufacturer_data(input)) in_manufacturer_data = Traits::manufacturer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manufacturer_data)::BaseType>
        manufacturer_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<::blink::mojom::WebBluetoothDataFilterDataView>>>(
        in_manufacturer_data, manufacturer_data_fragment, &manufacturer_data_validate_params);
    fragment->manufacturer_data.Set(
        manufacturer_data_fragment.is_null() ? nullptr : manufacturer_data_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothLeScanFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothLeScanFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothCompanyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothCompanyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothCompany_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothCompany_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothCompanyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothDataFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothDataFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothDataFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->data = Traits::data(input);
    fragment->mask = Traits::mask(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothDataFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothDataFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRequestDeviceOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRequestDeviceOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRequestDeviceOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::filters(input)) in_filters = Traits::filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters)::BaseType>
        filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        in_filters, filters_fragment, &filters_validate_params);
    fragment->filters.Set(
        filters_fragment.is_null() ? nullptr : filters_fragment.data());
    decltype(Traits::exclusion_filters(input)) in_exclusion_filters = Traits::exclusion_filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exclusion_filters)::BaseType>
        exclusion_filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& exclusion_filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        in_exclusion_filters, exclusion_filters_fragment, &exclusion_filters_validate_params);
    fragment->exclusion_filters.Set(
        exclusion_filters_fragment.is_null() ? nullptr : exclusion_filters_fragment.data());
    decltype(Traits::optional_services(input)) in_optional_services = Traits::optional_services(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->optional_services)::BaseType>
        optional_services_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& optional_services_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        in_optional_services, optional_services_fragment, &optional_services_validate_params);
    fragment->optional_services.Set(
        optional_services_fragment.is_null() ? nullptr : optional_services_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->optional_services.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null optional_services in WebBluetoothRequestDeviceOptions struct");
    decltype(Traits::optional_manufacturer_data(input)) in_optional_manufacturer_data = Traits::optional_manufacturer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->optional_manufacturer_data)::BaseType>
        optional_manufacturer_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& optional_manufacturer_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
        in_optional_manufacturer_data, optional_manufacturer_data_fragment, &optional_manufacturer_data_validate_params);
    fragment->optional_manufacturer_data.Set(
        optional_manufacturer_data_fragment.is_null() ? nullptr : optional_manufacturer_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->optional_manufacturer_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null optional_manufacturer_data in WebBluetoothRequestDeviceOptions struct");
    fragment->accept_all_devices = Traits::accept_all_devices(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRequestDeviceOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRequestDeviceOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRequestLEScanOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRequestLEScanOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRequestLEScanOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::filters(input)) in_filters = Traits::filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters)::BaseType>
        filters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& filters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebBluetoothLeScanFilterDataView>>(
        in_filters, filters_fragment, &filters_validate_params);
    fragment->filters.Set(
        filters_fragment.is_null() ? nullptr : filters_fragment.data());
    fragment->keep_repeated_devices = Traits::keep_repeated_devices(input);
    fragment->accept_all_advertisements = Traits::accept_all_advertisements(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRequestLEScanOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRequestLEScanOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothDeviceIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothDeviceIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothDeviceId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_id)::BaseType>
        device_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
        mojo::internal::GetArrayValidator<16, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_device_id, device_id_fragment, &device_id_validate_params);
    fragment->device_id.Set(
        device_id_fragment.is_null() ? nullptr : device_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->device_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_id in WebBluetoothDeviceId struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothDeviceId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothDeviceIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothDeviceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothDeviceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothDevice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceIdDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in WebBluetoothDevice struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothDevice_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothDeviceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRemoteGATTServiceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRemoteGATTServiceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRemoteGATTService_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_instance_id, instance_id_fragment);
    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->instance_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instance_id in WebBluetoothRemoteGATTService struct");
    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
        in_uuid, uuid_fragment);
    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->uuid.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in WebBluetoothRemoteGATTService struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRemoteGATTService_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRemoteGATTServiceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRemoteGATTCharacteristic_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_instance_id, instance_id_fragment);
    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->instance_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instance_id in WebBluetoothRemoteGATTCharacteristic struct");
    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
        in_uuid, uuid_fragment);
    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->uuid.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in WebBluetoothRemoteGATTCharacteristic struct");
    fragment->properties = Traits::properties(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRemoteGATTCharacteristic_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRemoteGATTCharacteristicDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothAdvertisingEventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothAdvertisingEventDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothAdvertisingEvent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::device(input)) in_device = Traits::device(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device)::BaseType> device_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::WebBluetoothDeviceDataView>(
        in_device, device_fragment);
    fragment->device.Set(
        device_fragment.is_null() ? nullptr : device_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->device.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device in WebBluetoothAdvertisingEvent struct");
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    decltype(Traits::uuids(input)) in_uuids = Traits::uuids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuids)::BaseType>
        uuids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& uuids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
        in_uuids, uuids_fragment, &uuids_validate_params);
    fragment->uuids.Set(
        uuids_fragment.is_null() ? nullptr : uuids_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->uuids.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuids in WebBluetoothAdvertisingEvent struct");
    fragment->appearance_is_set = Traits::appearance_is_set(input);
    fragment->appearance = Traits::appearance(input);
    fragment->tx_power_is_set = Traits::tx_power_is_set(input);
    fragment->tx_power = Traits::tx_power(input);
    fragment->rssi_is_set = Traits::rssi_is_set(input);
    fragment->rssi = Traits::rssi(input);
    decltype(Traits::manufacturer_data(input)) in_manufacturer_data = Traits::manufacturer_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manufacturer_data)::BaseType>
        manufacturer_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>>(
        in_manufacturer_data, manufacturer_data_fragment, &manufacturer_data_validate_params);
    fragment->manufacturer_data.Set(
        manufacturer_data_fragment.is_null() ? nullptr : manufacturer_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->manufacturer_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null manufacturer_data in WebBluetoothAdvertisingEvent struct");
    decltype(Traits::service_data(input)) in_service_data = Traits::service_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_data)::BaseType>
        service_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& service_data_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>>(
        in_service_data, service_data_fragment, &service_data_validate_params);
    fragment->service_data.Set(
        service_data_fragment.is_null() ? nullptr : service_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->service_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_data in WebBluetoothAdvertisingEvent struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothAdvertisingEvent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothAdvertisingEventDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebBluetoothRemoteGATTDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_instance_id, instance_id_fragment);
    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->instance_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null instance_id in WebBluetoothRemoteGATTDescriptor struct");
    decltype(Traits::uuid(input)) in_uuid = Traits::uuid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uuid)::BaseType> uuid_fragment(
            fragment.message());
    mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
        in_uuid, uuid_fragment);
    fragment->uuid.Set(
        uuid_fragment.is_null() ? nullptr : uuid_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->uuid.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uuid in WebBluetoothRemoteGATTDescriptor struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebBluetoothRemoteGATTDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebBluetoothRemoteGATTDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void WebBluetoothLeScanFilterDataView::GetServicesDataView(
    mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output) {
  auto pointer = data_->services.Get();
  *output = mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>(pointer, message_);
}
inline void WebBluetoothLeScanFilterDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothLeScanFilterDataView::GetNamePrefixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name_prefix.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothLeScanFilterDataView::GetManufacturerDataDataView(
    mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<WebBluetoothDataFilterDataView>>* output) {
  auto pointer = data_->manufacturer_data.Get();
  *output = mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<WebBluetoothDataFilterDataView>>(pointer, message_);
}






inline void WebBluetoothRequestDeviceOptionsDataView::GetFiltersDataView(
    mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output) {
  auto pointer = data_->filters.Get();
  *output = mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>(pointer, message_);
}
inline void WebBluetoothRequestDeviceOptionsDataView::GetExclusionFiltersDataView(
    mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output) {
  auto pointer = data_->exclusion_filters.Get();
  *output = mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>(pointer, message_);
}
inline void WebBluetoothRequestDeviceOptionsDataView::GetOptionalServicesDataView(
    mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output) {
  auto pointer = data_->optional_services.Get();
  *output = mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>(pointer, message_);
}
inline void WebBluetoothRequestDeviceOptionsDataView::GetOptionalManufacturerDataDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->optional_manufacturer_data.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}


inline void WebBluetoothRequestLEScanOptionsDataView::GetFiltersDataView(
    mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>* output) {
  auto pointer = data_->filters.Get();
  *output = mojo::ArrayDataView<WebBluetoothLeScanFilterDataView>(pointer, message_);
}


inline void WebBluetoothDeviceIdDataView::GetDeviceIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void WebBluetoothDeviceDataView::GetIdDataView(
    WebBluetoothDeviceIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = WebBluetoothDeviceIdDataView(pointer, message_);
}
inline void WebBluetoothDeviceDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebBluetoothRemoteGATTServiceDataView::GetInstanceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothRemoteGATTServiceDataView::GetUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}


inline void WebBluetoothRemoteGATTCharacteristicDataView::GetInstanceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothRemoteGATTCharacteristicDataView::GetUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}


inline void WebBluetoothAdvertisingEventDataView::GetDeviceDataView(
    WebBluetoothDeviceDataView* output) {
  auto pointer = data_->device.Get();
  *output = WebBluetoothDeviceDataView(pointer, message_);
}
inline void WebBluetoothAdvertisingEventDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothAdvertisingEventDataView::GetUuidsDataView(
    mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>* output) {
  auto pointer = data_->uuids.Get();
  *output = mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>(pointer, message_);
}
inline void WebBluetoothAdvertisingEventDataView::GetManufacturerDataDataView(
    mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->manufacturer_data.Get();
  *output = mojo::MapDataView<WebBluetoothCompanyDataView, mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void WebBluetoothAdvertisingEventDataView::GetServiceDataDataView(
    mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->service_data.Get();
  *output = mojo::MapDataView<::bluetooth::mojom::UUIDDataView, mojo::ArrayDataView<uint8_t>>(pointer, message_);
}


inline void WebBluetoothRemoteGATTDescriptorDataView::GetInstanceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebBluetoothRemoteGATTDescriptorDataView::GetUuidDataView(
    ::bluetooth::mojom::UUIDDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = ::bluetooth::mojom::UUIDDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebBluetoothResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebBluetoothResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebBluetoothGATTQueryQuantity> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebBluetoothGATTQueryQuantity value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::WebBluetoothWriteType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::WebBluetoothWriteType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_SHARED_H_