// services/viz/public/mojom/compositing/offset_tag.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_OFFSET_TAG_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_OFFSET_TAG_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/offset_tag.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/offset_tag.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/token.mojom-blink.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {










class BLINK_PLATFORM_EXPORT OffsetTag {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OffsetTag, T>::value>;
  using DataView = OffsetTagDataView;
  using Data_ = internal::OffsetTag_Data;

  template <typename... Args>
  static OffsetTagPtr New(Args&&... args) {
    return OffsetTagPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OffsetTagPtr From(const U& u) {
    return mojo::TypeConverter<OffsetTagPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OffsetTag>::Convert(*this);
  }


  OffsetTag();

  explicit OffsetTag(
      const ::base::Token& token);


  ~OffsetTag();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OffsetTagPtr>
  OffsetTagPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OffsetTag::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OffsetTag::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OffsetTag::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OffsetTag::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OffsetTag::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OffsetTag_UnserializedMessageContext<
            UserType, OffsetTag::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OffsetTag::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OffsetTag::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OffsetTag_UnserializedMessageContext<
            UserType, OffsetTag::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OffsetTag::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Token token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OffsetTag::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OffsetTag::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OffsetTag::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OffsetTag::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT OffsetTagValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OffsetTagValue, T>::value>;
  using DataView = OffsetTagValueDataView;
  using Data_ = internal::OffsetTagValue_Data;

  template <typename... Args>
  static OffsetTagValuePtr New(Args&&... args) {
    return OffsetTagValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OffsetTagValuePtr From(const U& u) {
    return mojo::TypeConverter<OffsetTagValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OffsetTagValue>::Convert(*this);
  }


  OffsetTagValue();

  OffsetTagValue(
      OffsetTagPtr tag,
      const ::gfx::Vector2dF& offset);

OffsetTagValue(const OffsetTagValue&) = delete;
OffsetTagValue& operator=(const OffsetTagValue&) = delete;

  ~OffsetTagValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OffsetTagValuePtr>
  OffsetTagValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OffsetTagValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OffsetTagValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OffsetTagValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OffsetTagValue::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OffsetTagValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OffsetTagValue_UnserializedMessageContext<
            UserType, OffsetTagValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OffsetTagValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OffsetTagValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OffsetTagValue_UnserializedMessageContext<
            UserType, OffsetTagValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OffsetTagValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  OffsetTagPtr tag;
  
  ::gfx::Vector2dF offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OffsetTagValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OffsetTagValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OffsetTagValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OffsetTagValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT OffsetTagDefinition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OffsetTagDefinition, T>::value>;
  using DataView = OffsetTagDefinitionDataView;
  using Data_ = internal::OffsetTagDefinition_Data;

  template <typename... Args>
  static OffsetTagDefinitionPtr New(Args&&... args) {
    return OffsetTagDefinitionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OffsetTagDefinitionPtr From(const U& u) {
    return mojo::TypeConverter<OffsetTagDefinitionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OffsetTagDefinition>::Convert(*this);
  }


  OffsetTagDefinition();

  OffsetTagDefinition(
      OffsetTagPtr tag,
      ::viz::mojom::blink::SurfaceRangePtr provider,
      const ::gfx::Vector2dF& min_offset,
      const ::gfx::Vector2dF& max_offset);

OffsetTagDefinition(const OffsetTagDefinition&) = delete;
OffsetTagDefinition& operator=(const OffsetTagDefinition&) = delete;

  ~OffsetTagDefinition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OffsetTagDefinitionPtr>
  OffsetTagDefinitionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OffsetTagDefinition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OffsetTagDefinition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OffsetTagDefinition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OffsetTagDefinition::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OffsetTagDefinition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OffsetTagDefinition_UnserializedMessageContext<
            UserType, OffsetTagDefinition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OffsetTagDefinition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OffsetTagDefinition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OffsetTagDefinition_UnserializedMessageContext<
            UserType, OffsetTagDefinition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OffsetTagDefinition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  OffsetTagPtr tag;
  
  ::viz::mojom::blink::SurfaceRangePtr provider;
  
  ::gfx::Vector2dF min_offset;
  
  ::gfx::Vector2dF max_offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OffsetTagDefinition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OffsetTagDefinition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OffsetTagDefinition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OffsetTagDefinition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OffsetTagPtr OffsetTag::Clone() const {
  return New(
      mojo::Clone(token)
  );
}

template <typename T, OffsetTag::EnableIfSame<T>*>
bool OffsetTag::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  return true;
}

template <typename T, OffsetTag::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  return false;
}
template <typename StructPtrType>
OffsetTagValuePtr OffsetTagValue::Clone() const {
  return New(
      mojo::Clone(tag),
      mojo::Clone(offset)
  );
}

template <typename T, OffsetTagValue::EnableIfSame<T>*>
bool OffsetTagValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tag, other_struct.tag))
    return false;
  if (!mojo::Equals(this->offset, other_struct.offset))
    return false;
  return true;
}

template <typename T, OffsetTagValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tag < rhs.tag)
    return true;
  if (rhs.tag < lhs.tag)
    return false;
  if (lhs.offset < rhs.offset)
    return true;
  if (rhs.offset < lhs.offset)
    return false;
  return false;
}
template <typename StructPtrType>
OffsetTagDefinitionPtr OffsetTagDefinition::Clone() const {
  return New(
      mojo::Clone(tag),
      mojo::Clone(provider),
      mojo::Clone(min_offset),
      mojo::Clone(max_offset)
  );
}

template <typename T, OffsetTagDefinition::EnableIfSame<T>*>
bool OffsetTagDefinition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tag, other_struct.tag))
    return false;
  if (!mojo::Equals(this->provider, other_struct.provider))
    return false;
  if (!mojo::Equals(this->min_offset, other_struct.min_offset))
    return false;
  if (!mojo::Equals(this->max_offset, other_struct.max_offset))
    return false;
  return true;
}

template <typename T, OffsetTagDefinition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tag < rhs.tag)
    return true;
  if (rhs.tag < lhs.tag)
    return false;
  if (lhs.provider < rhs.provider)
    return true;
  if (rhs.provider < lhs.provider)
    return false;
  if (lhs.min_offset < rhs.min_offset)
    return true;
  if (rhs.min_offset < lhs.min_offset)
    return false;
  if (lhs.max_offset < rhs.max_offset)
    return true;
  if (rhs.max_offset < lhs.max_offset)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::OffsetTag::DataView,
                                         ::viz::mojom::blink::OffsetTagPtr> {
  static bool IsNull(const ::viz::mojom::blink::OffsetTagPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::OffsetTagPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::OffsetTag::token)& token(
      const ::viz::mojom::blink::OffsetTagPtr& input) {
    return input->token;
  }

  static bool Read(::viz::mojom::blink::OffsetTag::DataView input, ::viz::mojom::blink::OffsetTagPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::OffsetTagValue::DataView,
                                         ::viz::mojom::blink::OffsetTagValuePtr> {
  static bool IsNull(const ::viz::mojom::blink::OffsetTagValuePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::OffsetTagValuePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::OffsetTagValue::tag)& tag(
      const ::viz::mojom::blink::OffsetTagValuePtr& input) {
    return input->tag;
  }

  static const decltype(::viz::mojom::blink::OffsetTagValue::offset)& offset(
      const ::viz::mojom::blink::OffsetTagValuePtr& input) {
    return input->offset;
  }

  static bool Read(::viz::mojom::blink::OffsetTagValue::DataView input, ::viz::mojom::blink::OffsetTagValuePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::OffsetTagDefinition::DataView,
                                         ::viz::mojom::blink::OffsetTagDefinitionPtr> {
  static bool IsNull(const ::viz::mojom::blink::OffsetTagDefinitionPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::OffsetTagDefinitionPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::OffsetTagDefinition::tag)& tag(
      const ::viz::mojom::blink::OffsetTagDefinitionPtr& input) {
    return input->tag;
  }

  static const decltype(::viz::mojom::blink::OffsetTagDefinition::provider)& provider(
      const ::viz::mojom::blink::OffsetTagDefinitionPtr& input) {
    return input->provider;
  }

  static const decltype(::viz::mojom::blink::OffsetTagDefinition::min_offset)& min_offset(
      const ::viz::mojom::blink::OffsetTagDefinitionPtr& input) {
    return input->min_offset;
  }

  static const decltype(::viz::mojom::blink::OffsetTagDefinition::max_offset)& max_offset(
      const ::viz::mojom::blink::OffsetTagDefinitionPtr& input) {
    return input->max_offset;
  }

  static bool Read(::viz::mojom::blink::OffsetTagDefinition::DataView input, ::viz::mojom::blink::OffsetTagDefinitionPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_OFFSET_TAG_MOJOM_BLINK_H_