// services/viz/public/mojom/compositing/frame_sink_bundle.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-blink-import-headers.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "gpu/ipc/common/mailbox_holder_mojom_traits.h"
#include "gpu/ipc/common/mailbox_mojom_traits.h"
#include "gpu/ipc/common/sync_token_mojom_traits.h"
#include "ipc/ipc_message_utils.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_metadata_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_render_pass_id_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_render_pass_mojom_traits.h"
#include "services/viz/public/cpp/compositing/filter_operation_mojom_traits.h"
#include "services/viz/public/cpp/compositing/filter_operations_mojom_traits.h"
#include "services/viz/public/cpp/compositing/quads_mojom_traits.h"
#include "services/viz/public/cpp/compositing/selection_mojom_traits.h"
#include "services/viz/public/cpp/compositing/shared_quad_state_mojom_traits.h"
#include "services/viz/public/cpp/compositing/transferable_resource_mojom_traits.h"
#include "ui/gfx/mojom/selection_bound_mojom_traits.h"
#include "ui/gfx/mojom/transform_mojom_traits.h"
#include "ui/latency/mojom/latency_info_mojom_traits.h"


namespace viz::mojom::blink {
BundledFrameSubmission::BundledFrameSubmission()
    : sink_id(),
      data() {}

BundledFrameSubmission::BundledFrameSubmission(
    uint32_t sink_id_in,
    BundledFrameSubmissionDataPtr data_in)
    : sink_id(std::move(sink_id_in)),
      data(std::move(data_in)) {}

BundledFrameSubmission::~BundledFrameSubmission() = default;

void BundledFrameSubmission::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BundledFrameSubmissionDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundledFrameSubmission::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundledCompositorFrame::BundledCompositorFrame()
    : local_surface_id(),
      frame(),
      hit_test_region_list(),
      submit_time() {}

BundledCompositorFrame::BundledCompositorFrame(
    const ::viz::LocalSurfaceId& local_surface_id_in,
    ::viz::CompositorFrame frame_in,
    std::optional<::viz::HitTestRegionList> hit_test_region_list_in,
    uint64_t submit_time_in)
    : local_surface_id(std::move(local_surface_id_in)),
      frame(std::move(frame_in)),
      hit_test_region_list(std::move(hit_test_region_list_in)),
      submit_time(std::move(submit_time_in)) {}

BundledCompositorFrame::~BundledCompositorFrame() = default;

void BundledCompositorFrame::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "local_surface_id"), this->local_surface_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::LocalSurfaceId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::CompositorFrame>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_test_region_list"), this->hit_test_region_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::viz::HitTestRegionList>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submit_time"), this->submit_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundledCompositorFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundledReturnedResources::BundledReturnedResources()
    : sink_id(),
      resources() {}

BundledReturnedResources::BundledReturnedResources(
    uint32_t sink_id_in,
    WTF::Vector<::viz::ReturnedResource> resources_in)
    : sink_id(std::move(sink_id_in)),
      resources(std::move(resources_in)) {}

BundledReturnedResources::~BundledReturnedResources() = default;

void BundledReturnedResources::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources"), this->resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<::viz::ReturnedResource>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BundledReturnedResources::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BeginFrameInfo::BeginFrameInfo()
    : sink_id(),
      args(),
      details(),
      frame_ack(),
      resources() {}

BeginFrameInfo::BeginFrameInfo(
    uint32_t sink_id_in,
    const ::viz::BeginFrameArgs& args_in,
    const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>& details_in,
    bool frame_ack_in,
    WTF::Vector<::viz::ReturnedResource> resources_in)
    : sink_id(std::move(sink_id_in)),
      args(std::move(args_in)),
      details(std::move(details_in)),
      frame_ack(std::move(frame_ack_in)),
      resources(std::move(resources_in)) {}

BeginFrameInfo::~BeginFrameInfo() = default;

void BeginFrameInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sink_id"), this->sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "args"), this->args,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::BeginFrameArgs&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_ack"), this->frame_ack,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources"), this->resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<::viz::ReturnedResource>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BeginFrameInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BundledFrameSubmissionData::BundledFrameSubmissionData() : tag_(Tag::kFrame) {
  data_.frame = new BundledCompositorFramePtr;
}

BundledFrameSubmissionData::~BundledFrameSubmissionData() {
  DestroyActive();
}


void BundledFrameSubmissionData::set_frame(
    BundledCompositorFramePtr frame) {
  if (tag_ == Tag::kFrame) {
    *(data_.frame) = std::move(frame);
  } else {
    DestroyActive();
    tag_ = Tag::kFrame;
    data_.frame = new BundledCompositorFramePtr(
        std::move(frame));
  }
}
void BundledFrameSubmissionData::set_did_not_produce_frame(
    const ::viz::BeginFrameAck& did_not_produce_frame) {
  if (tag_ == Tag::kDidNotProduceFrame) {
    *(data_.did_not_produce_frame) = std::move(did_not_produce_frame);
  } else {
    DestroyActive();
    tag_ = Tag::kDidNotProduceFrame;
    data_.did_not_produce_frame = new ::viz::BeginFrameAck(
        std::move(did_not_produce_frame));
  }
}

void BundledFrameSubmissionData::DestroyActive() {
  switch (tag_) {

    case Tag::kFrame:

      delete data_.frame;
      break;
    case Tag::kDidNotProduceFrame:

      delete data_.did_not_produce_frame;
      break;
  }
}

bool BundledFrameSubmissionData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char FrameSinkBundle::Name_[] = "viz.mojom.FrameSinkBundle";

FrameSinkBundle::IPCStableHashFunction FrameSinkBundle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkBundle>(message.name())) {
    case messages::FrameSinkBundle::kInitializeCompositorFrameSinkType: {
      return &FrameSinkBundle::InitializeCompositorFrameSinkType_Sym::IPCStableHash;
    }
    case messages::FrameSinkBundle::kSetNeedsBeginFrame: {
      return &FrameSinkBundle::SetNeedsBeginFrame_Sym::IPCStableHash;
    }
    case messages::FrameSinkBundle::kSetWantsBeginFrameAcks: {
      return &FrameSinkBundle::SetWantsBeginFrameAcks_Sym::IPCStableHash;
    }
    case messages::FrameSinkBundle::kSubmit: {
      return &FrameSinkBundle::Submit_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkBundle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkBundle>(message.name())) {
      case messages::FrameSinkBundle::kInitializeCompositorFrameSinkType:
            return "Receive viz::mojom::FrameSinkBundle::InitializeCompositorFrameSinkType";
      case messages::FrameSinkBundle::kSetNeedsBeginFrame:
            return "Receive viz::mojom::FrameSinkBundle::SetNeedsBeginFrame";
      case messages::FrameSinkBundle::kSetWantsBeginFrameAcks:
            return "Receive viz::mojom::FrameSinkBundle::SetWantsBeginFrameAcks";
      case messages::FrameSinkBundle::kSubmit:
            return "Receive viz::mojom::FrameSinkBundle::Submit";
    }
  } else {
    switch (static_cast<messages::FrameSinkBundle>(message.name())) {
      case messages::FrameSinkBundle::kInitializeCompositorFrameSinkType:
            return "Receive reply viz::mojom::FrameSinkBundle::InitializeCompositorFrameSinkType";
      case messages::FrameSinkBundle::kSetNeedsBeginFrame:
            return "Receive reply viz::mojom::FrameSinkBundle::SetNeedsBeginFrame";
      case messages::FrameSinkBundle::kSetWantsBeginFrameAcks:
            return "Receive reply viz::mojom::FrameSinkBundle::SetWantsBeginFrameAcks";
      case messages::FrameSinkBundle::kSubmit:
            return "Receive reply viz::mojom::FrameSinkBundle::Submit";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkBundle::InitializeCompositorFrameSinkType_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkBundle::InitializeCompositorFrameSinkType");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkBundle::SetNeedsBeginFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkBundle::SetNeedsBeginFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkBundle::SetWantsBeginFrameAcks_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkBundle::SetWantsBeginFrameAcks");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkBundle::Submit_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkBundle::Submit");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameSinkBundleProxy::FrameSinkBundleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkBundleProxy::InitializeCompositorFrameSinkType(
    uint32_t in_sink_id, ::viz::mojom::blink::CompositorFrameSinkType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkBundle::InitializeCompositorFrameSinkType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::viz::mojom::blink::CompositorFrameSinkType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkBundle::kInitializeCompositorFrameSinkType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundle::Name_);
  message.set_method_name("InitializeCompositorFrameSinkType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkBundleProxy::SetNeedsBeginFrame(
    uint32_t in_sink_id, bool in_needs_begin_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkBundle::SetNeedsBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_begin_frame"), in_needs_begin_frame,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkBundle::kSetNeedsBeginFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundle_SetNeedsBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  params->needs_begin_frame = in_needs_begin_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundle::Name_);
  message.set_method_name("SetNeedsBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkBundleProxy::SetWantsBeginFrameAcks(
    uint32_t in_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkBundle::SetWantsBeginFrameAcks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkBundle::kSetWantsBeginFrameAcks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundle::Name_);
  message.set_method_name("SetWantsBeginFrameAcks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkBundleProxy::Submit(
    WTF::Vector<BundledFrameSubmissionPtr> in_submissions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkBundle::Submit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("submissions"), in_submissions,
                        "<value of type WTF::Vector<BundledFrameSubmissionPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkBundle::kSubmit), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundle_Submit_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->submissions)::BaseType>
      submissions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& submissions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::BundledFrameSubmissionDataView>>(
      in_submissions, submissions_fragment, &submissions_validate_params);
  params->submissions.Set(
      submissions_fragment.is_null() ? nullptr : submissions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->submissions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null submissions in FrameSinkBundle.Submit request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundle::Name_);
  message.set_method_name("Submit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameSinkBundleStubDispatch::Accept(
    FrameSinkBundle* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkBundle>(message->header()->name)) {
    case messages::FrameSinkBundle::kInitializeCompositorFrameSinkType: {
      DCHECK(message->is_serialized());
      internal::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkBundle.0
      bool success = true;
      uint32_t p_sink_id{};
      ::viz::mojom::blink::CompositorFrameSinkType p_type{};
      FrameSinkBundle_InitializeCompositorFrameSinkType_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundle::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeCompositorFrameSinkType(        
        std::move(p_sink_id), 
        std::move(p_type));
      return true;
    }
    case messages::FrameSinkBundle::kSetNeedsBeginFrame: {
      DCHECK(message->is_serialized());
      internal::FrameSinkBundle_SetNeedsBeginFrame_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundle_SetNeedsBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkBundle.1
      bool success = true;
      uint32_t p_sink_id{};
      bool p_needs_begin_frame{};
      FrameSinkBundle_SetNeedsBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success)
        p_needs_begin_frame = input_data_view.needs_begin_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundle::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsBeginFrame(        
        std::move(p_sink_id), 
        std::move(p_needs_begin_frame));
      return true;
    }
    case messages::FrameSinkBundle::kSetWantsBeginFrameAcks: {
      DCHECK(message->is_serialized());
      internal::FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkBundle.2
      bool success = true;
      uint32_t p_sink_id{};
      FrameSinkBundle_SetWantsBeginFrameAcks_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundle::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWantsBeginFrameAcks(        
        std::move(p_sink_id));
      return true;
    }
    case messages::FrameSinkBundle::kSubmit: {
      DCHECK(message->is_serialized());
      internal::FrameSinkBundle_Submit_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundle_Submit_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkBundle.3
      bool success = true;
      WTF::Vector<BundledFrameSubmissionPtr> p_submissions{};
      FrameSinkBundle_Submit_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubmissions(&p_submissions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundle::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Submit(        
        std::move(p_submissions));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkBundleStubDispatch::AcceptWithResponder(
    FrameSinkBundle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkBundle>(message->header()->name)) {
    case messages::FrameSinkBundle::kInitializeCompositorFrameSinkType: {
      break;
    }
    case messages::FrameSinkBundle::kSetNeedsBeginFrame: {
      break;
    }
    case messages::FrameSinkBundle::kSetWantsBeginFrameAcks: {
      break;
    }
    case messages::FrameSinkBundle::kSubmit: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkBundleValidationInfo[] = {
    {base::to_underlying(messages::FrameSinkBundle::kInitializeCompositorFrameSinkType),
     { &internal::FrameSinkBundle_InitializeCompositorFrameSinkType_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkBundle::kSetNeedsBeginFrame),
     { &internal::FrameSinkBundle_SetNeedsBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkBundle::kSetWantsBeginFrameAcks),
     { &internal::FrameSinkBundle_SetWantsBeginFrameAcks_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkBundle::kSubmit),
     { &internal::FrameSinkBundle_Submit_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkBundleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::FrameSinkBundle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkBundleValidationInfo);
}

const char FrameSinkBundleClient::Name_[] = "viz.mojom.FrameSinkBundleClient";

FrameSinkBundleClient::IPCStableHashFunction FrameSinkBundleClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkBundleClient>(message.name())) {
    case messages::FrameSinkBundleClient::kFlushNotifications: {
      return &FrameSinkBundleClient::FlushNotifications_Sym::IPCStableHash;
    }
    case messages::FrameSinkBundleClient::kOnBeginFramePausedChanged: {
      return &FrameSinkBundleClient::OnBeginFramePausedChanged_Sym::IPCStableHash;
    }
    case messages::FrameSinkBundleClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      return &FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkBundleClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkBundleClient>(message.name())) {
      case messages::FrameSinkBundleClient::kFlushNotifications:
            return "Receive viz::mojom::FrameSinkBundleClient::FlushNotifications";
      case messages::FrameSinkBundleClient::kOnBeginFramePausedChanged:
            return "Receive viz::mojom::FrameSinkBundleClient::OnBeginFramePausedChanged";
      case messages::FrameSinkBundleClient::kOnCompositorFrameTransitionDirectiveProcessed:
            return "Receive viz::mojom::FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed";
    }
  } else {
    switch (static_cast<messages::FrameSinkBundleClient>(message.name())) {
      case messages::FrameSinkBundleClient::kFlushNotifications:
            return "Receive reply viz::mojom::FrameSinkBundleClient::FlushNotifications";
      case messages::FrameSinkBundleClient::kOnBeginFramePausedChanged:
            return "Receive reply viz::mojom::FrameSinkBundleClient::OnBeginFramePausedChanged";
      case messages::FrameSinkBundleClient::kOnCompositorFrameTransitionDirectiveProcessed:
            return "Receive reply viz::mojom::FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkBundleClient::FlushNotifications_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkBundleClient::FlushNotifications");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkBundleClient::OnBeginFramePausedChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkBundleClient::OnBeginFramePausedChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameSinkBundleClientProxy::FrameSinkBundleClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkBundleClientProxy::FlushNotifications(
    WTF::Vector<BundledReturnedResourcesPtr> in_acks, WTF::Vector<BeginFrameInfoPtr> in_begin_frames, WTF::Vector<BundledReturnedResourcesPtr> in_reclaimed_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkBundleClient::FlushNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("acks"), in_acks,
                        "<value of type WTF::Vector<BundledReturnedResourcesPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("begin_frames"), in_begin_frames,
                        "<value of type WTF::Vector<BeginFrameInfoPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reclaimed_resources"), in_reclaimed_resources,
                        "<value of type WTF::Vector<BundledReturnedResourcesPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkBundleClient::kFlushNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundleClient_FlushNotifications_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->acks)::BaseType>
      acks_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& acks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::BundledReturnedResourcesDataView>>(
      in_acks, acks_fragment, &acks_validate_params);
  params->acks.Set(
      acks_fragment.is_null() ? nullptr : acks_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->acks.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null acks in FrameSinkBundleClient.FlushNotifications request");
  mojo::internal::MessageFragment<
      typename decltype(params->begin_frames)::BaseType>
      begin_frames_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& begin_frames_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::BeginFrameInfoDataView>>(
      in_begin_frames, begin_frames_fragment, &begin_frames_validate_params);
  params->begin_frames.Set(
      begin_frames_fragment.is_null() ? nullptr : begin_frames_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->begin_frames.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null begin_frames in FrameSinkBundleClient.FlushNotifications request");
  mojo::internal::MessageFragment<
      typename decltype(params->reclaimed_resources)::BaseType>
      reclaimed_resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& reclaimed_resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::BundledReturnedResourcesDataView>>(
      in_reclaimed_resources, reclaimed_resources_fragment, &reclaimed_resources_validate_params);
  params->reclaimed_resources.Set(
      reclaimed_resources_fragment.is_null() ? nullptr : reclaimed_resources_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->reclaimed_resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reclaimed_resources in FrameSinkBundleClient.FlushNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundleClient::Name_);
  message.set_method_name("FlushNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkBundleClientProxy::OnBeginFramePausedChanged(
    uint32_t in_sink_id, bool in_paused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkBundleClient::OnBeginFramePausedChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("paused"), in_paused,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkBundleClient::kOnBeginFramePausedChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  params->paused = in_paused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundleClient::Name_);
  message.set_method_name("OnBeginFramePausedChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkBundleClientProxy::OnCompositorFrameTransitionDirectiveProcessed(
    uint32_t in_sink_id, uint32_t in_sequence_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkBundleClient::OnCompositorFrameTransitionDirectiveProcessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_id"), in_sequence_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkBundleClient::kOnCompositorFrameTransitionDirectiveProcessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data> params(
          message);
  params.Allocate();
  params->sink_id = in_sink_id;
  params->sequence_id = in_sequence_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkBundleClient::Name_);
  message.set_method_name("OnCompositorFrameTransitionDirectiveProcessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameSinkBundleClientStubDispatch::Accept(
    FrameSinkBundleClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkBundleClient>(message->header()->name)) {
    case messages::FrameSinkBundleClient::kFlushNotifications: {
      DCHECK(message->is_serialized());
      internal::FrameSinkBundleClient_FlushNotifications_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundleClient_FlushNotifications_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkBundleClient.0
      bool success = true;
      WTF::Vector<BundledReturnedResourcesPtr> p_acks{};
      WTF::Vector<BeginFrameInfoPtr> p_begin_frames{};
      WTF::Vector<BundledReturnedResourcesPtr> p_reclaimed_resources{};
      FrameSinkBundleClient_FlushNotifications_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAcks(&p_acks))
        success = false;
      if (success && !input_data_view.ReadBeginFrames(&p_begin_frames))
        success = false;
      if (success && !input_data_view.ReadReclaimedResources(&p_reclaimed_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundleClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushNotifications(        
        std::move(p_acks), 
        std::move(p_begin_frames), 
        std::move(p_reclaimed_resources));
      return true;
    }
    case messages::FrameSinkBundleClient::kOnBeginFramePausedChanged: {
      DCHECK(message->is_serialized());
      internal::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkBundleClient.1
      bool success = true;
      uint32_t p_sink_id{};
      bool p_paused{};
      FrameSinkBundleClient_OnBeginFramePausedChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success)
        p_paused = input_data_view.paused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundleClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFramePausedChanged(        
        std::move(p_sink_id), 
        std::move(p_paused));
      return true;
    }
    case messages::FrameSinkBundleClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      DCHECK(message->is_serialized());
      internal::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data* params =
          reinterpret_cast<internal::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkBundleClient.2
      bool success = true;
      uint32_t p_sink_id{};
      uint32_t p_sequence_id{};
      FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sink_id = input_data_view.sink_id();
      if (success)
        p_sequence_id = input_data_view.sequence_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkBundleClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompositorFrameTransitionDirectiveProcessed(        
        std::move(p_sink_id), 
        std::move(p_sequence_id));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkBundleClientStubDispatch::AcceptWithResponder(
    FrameSinkBundleClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkBundleClient>(message->header()->name)) {
    case messages::FrameSinkBundleClient::kFlushNotifications: {
      break;
    }
    case messages::FrameSinkBundleClient::kOnBeginFramePausedChanged: {
      break;
    }
    case messages::FrameSinkBundleClient::kOnCompositorFrameTransitionDirectiveProcessed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkBundleClientValidationInfo[] = {
    {base::to_underlying(messages::FrameSinkBundleClient::kFlushNotifications),
     { &internal::FrameSinkBundleClient_FlushNotifications_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkBundleClient::kOnBeginFramePausedChanged),
     { &internal::FrameSinkBundleClient_OnBeginFramePausedChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkBundleClient::kOnCompositorFrameTransitionDirectiveProcessed),
     { &internal::FrameSinkBundleClient_OnCompositorFrameTransitionDirectiveProcessed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkBundleClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::FrameSinkBundleClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkBundleClientValidationInfo);
}



}  // viz::mojom::blink


namespace mojo {


// static
bool StructTraits<::viz::mojom::blink::BundledFrameSubmission::DataView, ::viz::mojom::blink::BundledFrameSubmissionPtr>::Read(
    ::viz::mojom::blink::BundledFrameSubmission::DataView input,
    ::viz::mojom::blink::BundledFrameSubmissionPtr* output) {
  bool success = true;
  ::viz::mojom::blink::BundledFrameSubmissionPtr result(::viz::mojom::blink::BundledFrameSubmission::New());
  
      if (success)
        result->sink_id = input.sink_id();
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::BundledCompositorFrame::DataView, ::viz::mojom::blink::BundledCompositorFramePtr>::Read(
    ::viz::mojom::blink::BundledCompositorFrame::DataView input,
    ::viz::mojom::blink::BundledCompositorFramePtr* output) {
  bool success = true;
  ::viz::mojom::blink::BundledCompositorFramePtr result(::viz::mojom::blink::BundledCompositorFrame::New());
  
      if (success && !input.ReadLocalSurfaceId(&result->local_surface_id))
        success = false;
      if (success && !input.ReadFrame(&result->frame))
        success = false;
      if (success && !input.ReadHitTestRegionList(&result->hit_test_region_list))
        success = false;
      if (success)
        result->submit_time = input.submit_time();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::BundledReturnedResources::DataView, ::viz::mojom::blink::BundledReturnedResourcesPtr>::Read(
    ::viz::mojom::blink::BundledReturnedResources::DataView input,
    ::viz::mojom::blink::BundledReturnedResourcesPtr* output) {
  bool success = true;
  ::viz::mojom::blink::BundledReturnedResourcesPtr result(::viz::mojom::blink::BundledReturnedResources::New());
  
      if (success)
        result->sink_id = input.sink_id();
      if (success && !input.ReadResources(&result->resources))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::BeginFrameInfo::DataView, ::viz::mojom::blink::BeginFrameInfoPtr>::Read(
    ::viz::mojom::blink::BeginFrameInfo::DataView input,
    ::viz::mojom::blink::BeginFrameInfoPtr* output) {
  bool success = true;
  ::viz::mojom::blink::BeginFrameInfoPtr result(::viz::mojom::blink::BeginFrameInfo::New());
  
      if (success)
        result->sink_id = input.sink_id();
      if (success && !input.ReadArgs(&result->args))
        success = false;
      if (success && !input.ReadDetails(&result->details))
        success = false;
      if (success)
        result->frame_ack = input.frame_ack();
      if (success && !input.ReadResources(&result->resources))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::blink::BundledFrameSubmissionData::DataView, ::viz::mojom::blink::BundledFrameSubmissionDataPtr>::Read(
    ::viz::mojom::blink::BundledFrameSubmissionData::DataView input,
    ::viz::mojom::blink::BundledFrameSubmissionDataPtr* output) {
  using UnionType = ::viz::mojom::blink::BundledFrameSubmissionData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFrame: {
      ::viz::mojom::blink::BundledCompositorFramePtr result_frame;
      if (!input.ReadFrame(&result_frame))
        return false;

      *output = UnionType::NewFrame(
          std::move(result_frame));
      break;
    }
    case Tag::kDidNotProduceFrame: {
      ::viz::BeginFrameAck result_did_not_produce_frame;
      if (!input.ReadDidNotProduceFrame(&result_did_not_produce_frame))
        return false;

      *output = UnionType::NewDidNotProduceFrame(
          std::move(result_did_not_produce_frame));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom::blink {


void FrameSinkBundleInterceptorForTesting::InitializeCompositorFrameSinkType(uint32_t sink_id, ::viz::mojom::blink::CompositorFrameSinkType type) {
  GetForwardingInterface()->InitializeCompositorFrameSinkType(
    std::move(sink_id)
    , 
    std::move(type)
    );
}
void FrameSinkBundleInterceptorForTesting::SetNeedsBeginFrame(uint32_t sink_id, bool needs_begin_frame) {
  GetForwardingInterface()->SetNeedsBeginFrame(
    std::move(sink_id)
    , 
    std::move(needs_begin_frame)
    );
}
void FrameSinkBundleInterceptorForTesting::SetWantsBeginFrameAcks(uint32_t sink_id) {
  GetForwardingInterface()->SetWantsBeginFrameAcks(
    std::move(sink_id)
    );
}
void FrameSinkBundleInterceptorForTesting::Submit(WTF::Vector<BundledFrameSubmissionPtr> submissions) {
  GetForwardingInterface()->Submit(
    std::move(submissions)
    );
}
FrameSinkBundleAsyncWaiter::FrameSinkBundleAsyncWaiter(
    FrameSinkBundle* proxy) : proxy_(proxy) {}

FrameSinkBundleAsyncWaiter::~FrameSinkBundleAsyncWaiter() = default;




void FrameSinkBundleClientInterceptorForTesting::FlushNotifications(WTF::Vector<BundledReturnedResourcesPtr> acks, WTF::Vector<BeginFrameInfoPtr> begin_frames, WTF::Vector<BundledReturnedResourcesPtr> reclaimed_resources) {
  GetForwardingInterface()->FlushNotifications(
    std::move(acks)
    , 
    std::move(begin_frames)
    , 
    std::move(reclaimed_resources)
    );
}
void FrameSinkBundleClientInterceptorForTesting::OnBeginFramePausedChanged(uint32_t sink_id, bool paused) {
  GetForwardingInterface()->OnBeginFramePausedChanged(
    std::move(sink_id)
    , 
    std::move(paused)
    );
}
void FrameSinkBundleClientInterceptorForTesting::OnCompositorFrameTransitionDirectiveProcessed(uint32_t sink_id, uint32_t sequence_id) {
  GetForwardingInterface()->OnCompositorFrameTransitionDirectiveProcessed(
    std::move(sink_id)
    , 
    std::move(sequence_id)
    );
}
FrameSinkBundleClientAsyncWaiter::FrameSinkBundleClientAsyncWaiter(
    FrameSinkBundleClient* proxy) : proxy_(proxy) {}

FrameSinkBundleClientAsyncWaiter::~FrameSinkBundleClientAsyncWaiter() = default;






}  // viz::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif