// services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace viz::mojom {
class BeginFrameIdDataView;

class BeginFrameArgsDataView;

class BeginFrameAckDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::BeginFrameIdDataView> {
  using Data = ::viz::mojom::internal::BeginFrameId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::BeginFrameArgsDataView> {
  using Data = ::viz::mojom::internal::BeginFrameArgs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::BeginFrameAckDataView> {
  using Data = ::viz::mojom::internal::BeginFrameAck_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class BeginFrameArgsType : int32_t {
  
  INVALID = 0,
  
  NORMAL = 1,
  
  MISSED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BeginFrameArgsType value);
inline bool IsKnownEnumValue(BeginFrameArgsType value) {
  return internal::BeginFrameArgsType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BeginFrameIdDataView {
 public:
  BeginFrameIdDataView() = default;

  BeginFrameIdDataView(
      internal::BeginFrameId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t source_id() const {
    return data_->source_id;
  }
  uint64_t sequence_number() const {
    return data_->sequence_number;
  }
 private:
  internal::BeginFrameId_Data* data_ = nullptr;
};


class BeginFrameArgsDataView {
 public:
  BeginFrameArgsDataView() = default;

  BeginFrameArgsDataView(
      internal::BeginFrameArgs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameTime(UserType* output) {
    
    auto* pointer = data_->frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetDeadlineDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeadline(UserType* output) {
    
    auto* pointer = data_->deadline.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterval(UserType* output) {
    
    auto* pointer = data_->interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFrameIdDataView(
      BeginFrameIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameId(UserType* output) {
    
    auto* pointer = data_->frame_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameIdDataView>(
        pointer, output, message_);
  }
  uint64_t frames_throttled_since_last() const {
    return data_->frames_throttled_since_last;
  }
  int64_t trace_id() const {
    return data_->trace_id;
  }
  inline void GetDispatchTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDispatchTime(UserType* output) {
    
    auto* pointer = data_->dispatch_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetClientArrivalTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientArrivalTime(UserType* output) {
    
    auto* pointer = data_->client_arrival_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameArgsType>(
        data_value, output);
  }
  BeginFrameArgsType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::BeginFrameArgsType>(data_->type));
  }
  bool on_critical_path() const {
    return data_->on_critical_path;
  }
  bool animate_only() const {
    return data_->animate_only;
  }
 private:
  internal::BeginFrameArgs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BeginFrameAckDataView {
 public:
  BeginFrameAckDataView() = default;

  BeginFrameAckDataView(
      internal::BeginFrameAck_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t source_id() const {
    return data_->source_id;
  }
  uint64_t sequence_number() const {
    return data_->sequence_number;
  }
  int64_t trace_id() const {
    return data_->trace_id;
  }
  bool has_damage() const {
    return data_->has_damage;
  }
  inline void GetPreferredFrameIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreferredFrameInterval(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `preferred_frame_interval` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreferredFrameInterval` instead "
    "of `ReadPreferredFrameInterval if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->preferred_frame_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::BeginFrameAck_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

template <>
struct hash<::viz::mojom::BeginFrameArgsType>
    : public mojo::internal::EnumHashImpl<::viz::mojom::BeginFrameArgsType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BeginFrameArgsType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::BeginFrameArgsType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::BeginFrameArgsType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BeginFrameIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BeginFrameIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BeginFrameId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->source_id = Traits::source_id(input);
    fragment->sequence_number = Traits::sequence_number(input);
  }

  static bool Deserialize(::viz::mojom::internal::BeginFrameId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BeginFrameIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BeginFrameArgsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BeginFrameArgsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BeginFrameArgs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_time(input)) in_frame_time = Traits::frame_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_time)::BaseType> frame_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_frame_time, frame_time_fragment);
    fragment->frame_time.Set(
        frame_time_fragment.is_null() ? nullptr : frame_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_time in BeginFrameArgs struct");
    decltype(Traits::deadline(input)) in_deadline = Traits::deadline(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->deadline)::BaseType> deadline_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_deadline, deadline_fragment);
    fragment->deadline.Set(
        deadline_fragment.is_null() ? nullptr : deadline_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->deadline.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null deadline in BeginFrameArgs struct");
    decltype(Traits::interval(input)) in_interval = Traits::interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interval)::BaseType> interval_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_interval, interval_fragment);
    fragment->interval.Set(
        interval_fragment.is_null() ? nullptr : interval_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->interval.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interval in BeginFrameArgs struct");
    decltype(Traits::frame_id(input)) in_frame_id = Traits::frame_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_id)::BaseType> frame_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::BeginFrameIdDataView>(
        in_frame_id, frame_id_fragment);
    fragment->frame_id.Set(
        frame_id_fragment.is_null() ? nullptr : frame_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_id in BeginFrameArgs struct");
    fragment->frames_throttled_since_last = Traits::frames_throttled_since_last(input);
    fragment->trace_id = Traits::trace_id(input);
    decltype(Traits::dispatch_time(input)) in_dispatch_time = Traits::dispatch_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dispatch_time)::BaseType> dispatch_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_dispatch_time, dispatch_time_fragment);
    fragment->dispatch_time.Set(
        dispatch_time_fragment.is_null() ? nullptr : dispatch_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->dispatch_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dispatch_time in BeginFrameArgs struct");
    decltype(Traits::client_arrival_time(input)) in_client_arrival_time = Traits::client_arrival_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_arrival_time)::BaseType> client_arrival_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_client_arrival_time, client_arrival_time_fragment);
    fragment->client_arrival_time.Set(
        client_arrival_time_fragment.is_null() ? nullptr : client_arrival_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->client_arrival_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null client_arrival_time in BeginFrameArgs struct");
    mojo::internal::Serialize<::viz::mojom::BeginFrameArgsType>(
        Traits::type(input), &fragment->type);
    fragment->on_critical_path = Traits::on_critical_path(input);
    fragment->animate_only = Traits::animate_only(input);
  }

  static bool Deserialize(::viz::mojom::internal::BeginFrameArgs_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BeginFrameArgsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BeginFrameAckDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BeginFrameAckDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BeginFrameAck_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->source_id = Traits::source_id(input);
    fragment->sequence_number = Traits::sequence_number(input);
    fragment->trace_id = Traits::trace_id(input);
    fragment->has_damage = Traits::has_damage(input);
    decltype(Traits::preferred_frame_interval(input)) in_preferred_frame_interval = Traits::preferred_frame_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->preferred_frame_interval)::BaseType> preferred_frame_interval_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_preferred_frame_interval, preferred_frame_interval_fragment);
    fragment->preferred_frame_interval.Set(
        preferred_frame_interval_fragment.is_null() ? nullptr : preferred_frame_interval_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::BeginFrameAck_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BeginFrameAckDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {



inline void BeginFrameArgsDataView::GetFrameTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->frame_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void BeginFrameArgsDataView::GetDeadlineDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->deadline.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void BeginFrameArgsDataView::GetIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void BeginFrameArgsDataView::GetFrameIdDataView(
    BeginFrameIdDataView* output) {
  auto pointer = data_->frame_id.Get();
  *output = BeginFrameIdDataView(pointer, message_);
}
inline void BeginFrameArgsDataView::GetDispatchTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->dispatch_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void BeginFrameArgsDataView::GetClientArrivalTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->client_arrival_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void BeginFrameAckDataView::GetPreferredFrameIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->preferred_frame_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::BeginFrameArgsType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::BeginFrameArgsType value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_SHARED_H_