// services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINKS_METRICS_RECORDER_MOJOM_SHARED_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINKS_METRICS_RECORDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace viz::mojom {
class FrameCountingPerSinkDataDataView;

class FrameCountingDataDataView;

class OverdrawDataDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FrameCountingPerSinkDataDataView> {
  using Data = ::viz::mojom::internal::FrameCountingPerSinkData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::FrameCountingDataDataView> {
  using Data = ::viz::mojom::internal::FrameCountingData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::OverdrawDataDataView> {
  using Data = ::viz::mojom::internal::OverdrawData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {
// Interface base classes. They are used for type safety check.
class FrameSinksMetricsRecorderInterfaceBase {};

using FrameSinksMetricsRecorderPtrDataView =
    mojo::InterfacePtrDataView<FrameSinksMetricsRecorderInterfaceBase>;
using FrameSinksMetricsRecorderRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinksMetricsRecorderInterfaceBase>;
using FrameSinksMetricsRecorderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinksMetricsRecorderInterfaceBase>;
using FrameSinksMetricsRecorderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinksMetricsRecorderInterfaceBase>;


class FrameCountingPerSinkDataDataView {
 public:
  FrameCountingPerSinkDataDataView() = default;

  FrameCountingPerSinkDataDataView(
      internal::FrameCountingPerSinkData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::CompositorFrameSinkType>(
        data_value, output);
  }
  ::viz::mojom::CompositorFrameSinkType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CompositorFrameSinkType>(data_->type));
  }
  bool is_root() const {
    return data_->is_root;
  }
  inline void GetDebugLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugLabel(UserType* output) {
    
    auto* pointer = data_->debug_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint16_t start_bucket() const {
    return data_->start_bucket;
  }
  inline void GetPresentedFramesDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPresentedFrames(UserType* output) {
    
    auto* pointer = data_->presented_frames.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
 private:
  internal::FrameCountingPerSinkData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameCountingDataDataView {
 public:
  FrameCountingDataDataView() = default;

  FrameCountingDataDataView(
      internal::FrameCountingData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPerSinkDataDataView(
      mojo::ArrayDataView<FrameCountingPerSinkDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPerSinkData(UserType* output) {
    
    auto* pointer = data_->per_sink_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::FrameCountingPerSinkDataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FrameCountingData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OverdrawDataDataView {
 public:
  OverdrawDataDataView() = default;

  OverdrawDataDataView(
      internal::OverdrawData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAverageOverdrawsDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAverageOverdraws(UserType* output) {
    
    auto* pointer = data_->average_overdraws.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::OverdrawData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FrameCountingPerSinkDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameCountingPerSinkDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FrameCountingPerSinkData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkType>(
        Traits::type(input), &fragment->type);
    fragment->is_root = Traits::is_root(input);
    decltype(Traits::debug_label(input)) in_debug_label = Traits::debug_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_label)::BaseType> debug_label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_debug_label, debug_label_fragment);
    fragment->debug_label.Set(
        debug_label_fragment.is_null() ? nullptr : debug_label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->debug_label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_label in FrameCountingPerSinkData struct");
    fragment->start_bucket = Traits::start_bucket(input);
    decltype(Traits::presented_frames(input)) in_presented_frames = Traits::presented_frames(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->presented_frames)::BaseType>
        presented_frames_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& presented_frames_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
        in_presented_frames, presented_frames_fragment, &presented_frames_validate_params);
    fragment->presented_frames.Set(
        presented_frames_fragment.is_null() ? nullptr : presented_frames_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->presented_frames.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null presented_frames in FrameCountingPerSinkData struct");
  }

  static bool Deserialize(::viz::mojom::internal::FrameCountingPerSinkData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FrameCountingPerSinkDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FrameCountingDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameCountingDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FrameCountingData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::per_sink_data(input)) in_per_sink_data = Traits::per_sink_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->per_sink_data)::BaseType>
        per_sink_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& per_sink_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::FrameCountingPerSinkDataDataView>>(
        in_per_sink_data, per_sink_data_fragment, &per_sink_data_validate_params);
    fragment->per_sink_data.Set(
        per_sink_data_fragment.is_null() ? nullptr : per_sink_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->per_sink_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null per_sink_data in FrameCountingData struct");
  }

  static bool Deserialize(::viz::mojom::internal::FrameCountingData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FrameCountingDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::OverdrawDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::OverdrawDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::OverdrawData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::average_overdraws(input)) in_average_overdraws = Traits::average_overdraws(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->average_overdraws)::BaseType>
        average_overdraws_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& average_overdraws_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_average_overdraws, average_overdraws_fragment, &average_overdraws_validate_params);
    fragment->average_overdraws.Set(
        average_overdraws_fragment.is_null() ? nullptr : average_overdraws_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->average_overdraws.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null average_overdraws in OverdrawData struct");
  }

  static bool Deserialize(::viz::mojom::internal::OverdrawData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::OverdrawDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void FrameCountingPerSinkDataDataView::GetDebugLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->debug_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void FrameCountingPerSinkDataDataView::GetPresentedFramesDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->presented_frames.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}


inline void FrameCountingDataDataView::GetPerSinkDataDataView(
    mojo::ArrayDataView<FrameCountingPerSinkDataDataView>* output) {
  auto pointer = data_->per_sink_data.Get();
  *output = mojo::ArrayDataView<FrameCountingPerSinkDataDataView>(pointer, message_);
}


inline void OverdrawDataDataView::GetAverageOverdrawsDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->average_overdraws.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINKS_METRICS_RECORDER_MOJOM_SHARED_H_