// services/network/public/mojom/network_interface_change_listener.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_interface_change_listener.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class IfAddrMsgDataView;

class AddressMapDataView;

class OnlineLinksDataView;

class InitialAddressMapDataView;

class NetworkInterfaceChangeParamsDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::IfAddrMsgDataView> {
  using Data = ::network::mojom::internal::IfAddrMsg_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::AddressMapDataView> {
  using Data = ::network::mojom::internal::AddressMap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::OnlineLinksDataView> {
  using Data = ::network::mojom::internal::OnlineLinks_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::InitialAddressMapDataView> {
  using Data = ::network::mojom::internal::InitialAddressMap_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkInterfaceChangeParamsDataView> {
  using Data = ::network::mojom::internal::NetworkInterfaceChangeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class NetworkInterfaceChangeListenerInterfaceBase {};

using NetworkInterfaceChangeListenerPtrDataView =
    mojo::InterfacePtrDataView<NetworkInterfaceChangeListenerInterfaceBase>;
using NetworkInterfaceChangeListenerRequestDataView =
    mojo::InterfaceRequestDataView<NetworkInterfaceChangeListenerInterfaceBase>;
using NetworkInterfaceChangeListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NetworkInterfaceChangeListenerInterfaceBase>;
using NetworkInterfaceChangeListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NetworkInterfaceChangeListenerInterfaceBase>;


class IfAddrMsgDataView {
 public:
  IfAddrMsgDataView() = default;

  IfAddrMsgDataView(
      internal::IfAddrMsg_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t ifa_family() const {
    return data_->ifa_family;
  }
  uint8_t ifa_prefixlen() const {
    return data_->ifa_prefixlen;
  }
  uint8_t ifa_flags() const {
    return data_->ifa_flags;
  }
  uint8_t ifa_scope() const {
    return data_->ifa_scope;
  }
  uint32_t ifa_index() const {
    return data_->ifa_index;
  }
 private:
  internal::IfAddrMsg_Data* data_ = nullptr;
};


class AddressMapDataView {
 public:
  AddressMapDataView() = default;

  AddressMapDataView(
      internal::AddressMap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressMapDataView(
      mojo::MapDataView<::network::mojom::IPAddressDataView, IfAddrMsgDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddressMap(UserType* output) {
    
    auto* pointer = data_->address_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::IPAddressDataView, ::network::mojom::IfAddrMsgDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AddressMap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OnlineLinksDataView {
 public:
  OnlineLinksDataView() = default;

  OnlineLinksDataView(
      internal::OnlineLinks_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOnlineLinksDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOnlineLinks(UserType* output) {
    
    auto* pointer = data_->online_links.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::OnlineLinks_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InitialAddressMapDataView {
 public:
  InitialAddressMapDataView() = default;

  InitialAddressMapDataView(
      internal::InitialAddressMap_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressMapDataView(
      AddressMapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddressMap(UserType* output) {
    
    auto* pointer = data_->address_map.Get();
    return mojo::internal::Deserialize<::network::mojom::AddressMapDataView>(
        pointer, output, message_);
  }
  inline void GetOnlineLinksDataView(
      OnlineLinksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOnlineLinks(UserType* output) {
    
    auto* pointer = data_->online_links.Get();
    return mojo::internal::Deserialize<::network::mojom::OnlineLinksDataView>(
        pointer, output, message_);
  }
 private:
  internal::InitialAddressMap_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkInterfaceChangeParamsDataView {
 public:
  NetworkInterfaceChangeParamsDataView() = default;

  NetworkInterfaceChangeParamsDataView(
      internal::NetworkInterfaceChangeParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressMapDataView(
      mojo::MapDataView<::network::mojom::IPAddressDataView, IfAddrMsgDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddressMap(UserType* output) {
    
    auto* pointer = data_->address_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::IPAddressDataView, ::network::mojom::IfAddrMsgDataView>>(
        pointer, output, message_);
  }
  inline void GetOnlineLinksDataView(
      mojo::MapDataView<int32_t, bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOnlineLinks(UserType* output) {
    
    auto* pointer = data_->online_links.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int32_t, bool>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkInterfaceChangeParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::IfAddrMsgDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::IfAddrMsgDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::IfAddrMsg_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->ifa_family = Traits::ifa_family(input);
    fragment->ifa_prefixlen = Traits::ifa_prefixlen(input);
    fragment->ifa_flags = Traits::ifa_flags(input);
    fragment->ifa_scope = Traits::ifa_scope(input);
    fragment->ifa_index = Traits::ifa_index(input);
  }

  static bool Deserialize(::network::mojom::internal::IfAddrMsg_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::IfAddrMsgDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::AddressMapDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::AddressMapDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::AddressMap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::address_map(input)) in_address_map = Traits::address_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->address_map)::BaseType>
        address_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& address_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::IPAddressDataView, ::network::mojom::IfAddrMsgDataView>>(
        in_address_map, address_map_fragment, &address_map_validate_params);
    fragment->address_map.Set(
        address_map_fragment.is_null() ? nullptr : address_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->address_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null address_map in AddressMap struct");
  }

  static bool Deserialize(::network::mojom::internal::AddressMap_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::AddressMapDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::OnlineLinksDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::OnlineLinksDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::OnlineLinks_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::online_links(input)) in_online_links = Traits::online_links(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->online_links)::BaseType>
        online_links_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& online_links_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_online_links, online_links_fragment, &online_links_validate_params);
    fragment->online_links.Set(
        online_links_fragment.is_null() ? nullptr : online_links_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->online_links.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null online_links in OnlineLinks struct");
  }

  static bool Deserialize(::network::mojom::internal::OnlineLinks_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::OnlineLinksDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::InitialAddressMapDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::InitialAddressMapDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::InitialAddressMap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::address_map(input)) in_address_map = Traits::address_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->address_map)::BaseType> address_map_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::AddressMapDataView>(
        in_address_map, address_map_fragment);
    fragment->address_map.Set(
        address_map_fragment.is_null() ? nullptr : address_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->address_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null address_map in InitialAddressMap struct");
    decltype(Traits::online_links(input)) in_online_links = Traits::online_links(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->online_links)::BaseType> online_links_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::OnlineLinksDataView>(
        in_online_links, online_links_fragment);
    fragment->online_links.Set(
        online_links_fragment.is_null() ? nullptr : online_links_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->online_links.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null online_links in InitialAddressMap struct");
  }

  static bool Deserialize(::network::mojom::internal::InitialAddressMap_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::InitialAddressMapDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkInterfaceChangeParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkInterfaceChangeParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkInterfaceChangeParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::address_map(input)) in_address_map = Traits::address_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->address_map)::BaseType>
        address_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& address_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, true, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::IPAddressDataView, ::network::mojom::IfAddrMsgDataView>>(
        in_address_map, address_map_fragment, &address_map_validate_params);
    fragment->address_map.Set(
        address_map_fragment.is_null() ? nullptr : address_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->address_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null address_map in NetworkInterfaceChangeParams struct");
    decltype(Traits::online_links(input)) in_online_links = Traits::online_links(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->online_links)::BaseType>
        online_links_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& online_links_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<int32_t, bool>>(
        in_online_links, online_links_fragment, &online_links_validate_params);
    fragment->online_links.Set(
        online_links_fragment.is_null() ? nullptr : online_links_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->online_links.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null online_links in NetworkInterfaceChangeParams struct");
  }

  static bool Deserialize(::network::mojom::internal::NetworkInterfaceChangeParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkInterfaceChangeParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {



inline void AddressMapDataView::GetAddressMapDataView(
    mojo::MapDataView<::network::mojom::IPAddressDataView, IfAddrMsgDataView>* output) {
  auto pointer = data_->address_map.Get();
  *output = mojo::MapDataView<::network::mojom::IPAddressDataView, IfAddrMsgDataView>(pointer, message_);
}


inline void OnlineLinksDataView::GetOnlineLinksDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->online_links.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}


inline void InitialAddressMapDataView::GetAddressMapDataView(
    AddressMapDataView* output) {
  auto pointer = data_->address_map.Get();
  *output = AddressMapDataView(pointer, message_);
}
inline void InitialAddressMapDataView::GetOnlineLinksDataView(
    OnlineLinksDataView* output) {
  auto pointer = data_->online_links.Get();
  *output = OnlineLinksDataView(pointer, message_);
}


inline void NetworkInterfaceChangeParamsDataView::GetAddressMapDataView(
    mojo::MapDataView<::network::mojom::IPAddressDataView, IfAddrMsgDataView>* output) {
  auto pointer = data_->address_map.Get();
  *output = mojo::MapDataView<::network::mojom::IPAddressDataView, IfAddrMsgDataView>(pointer, message_);
}
inline void NetworkInterfaceChangeParamsDataView::GetOnlineLinksDataView(
    mojo::MapDataView<int32_t, bool>* output) {
  auto pointer = data_->online_links.Get();
  *output = mojo::MapDataView<int32_t, bool>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_SHARED_H_