// services/network/public/mojom/host_resolver.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  ResolveHostHandle_Cancel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResolveHostHandle_Cancel_Params_Data>;

  ResolveHostHandle_Cancel_Params_Data();
  ~ResolveHostHandle_Cancel_Params_Data() = delete;
};
static_assert(sizeof(ResolveHostHandle_Cancel_Params_Data) == 16,
              "Bad sizeof(ResolveHostHandle_Cancel_Params_Data)");
class  ResolveHostClient_OnComplete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::network::mojom::internal::ResolveErrorInfo_Data> resolve_error_info;
  mojo::internal::Pointer<::network::mojom::internal::AddressList_Data> resolved_addresses;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::HostResolverEndpointResult_Data>>> endpoint_results_with_metadata;

 private:
  friend class mojo::internal::MessageFragment<ResolveHostClient_OnComplete_Params_Data>;

  ResolveHostClient_OnComplete_Params_Data();
  ~ResolveHostClient_OnComplete_Params_Data() = delete;
};
static_assert(sizeof(ResolveHostClient_OnComplete_Params_Data) == 40,
              "Bad sizeof(ResolveHostClient_OnComplete_Params_Data)");
class  ResolveHostClient_OnTextResults_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> text_results;

 private:
  friend class mojo::internal::MessageFragment<ResolveHostClient_OnTextResults_Params_Data>;

  ResolveHostClient_OnTextResults_Params_Data();
  ~ResolveHostClient_OnTextResults_Params_Data() = delete;
};
static_assert(sizeof(ResolveHostClient_OnTextResults_Params_Data) == 16,
              "Bad sizeof(ResolveHostClient_OnTextResults_Params_Data)");
class  ResolveHostClient_OnHostnameResults_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::HostPortPair_Data>>> hosts;

 private:
  friend class mojo::internal::MessageFragment<ResolveHostClient_OnHostnameResults_Params_Data>;

  ResolveHostClient_OnHostnameResults_Params_Data();
  ~ResolveHostClient_OnHostnameResults_Params_Data() = delete;
};
static_assert(sizeof(ResolveHostClient_OnHostnameResults_Params_Data) == 16,
              "Bad sizeof(ResolveHostClient_OnHostnameResults_Params_Data)");
class  MdnsListenClient_OnAddressResult_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t update_type;
  int32_t query_type;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> endpoint;

 private:
  friend class mojo::internal::MessageFragment<MdnsListenClient_OnAddressResult_Params_Data>;

  MdnsListenClient_OnAddressResult_Params_Data();
  ~MdnsListenClient_OnAddressResult_Params_Data() = delete;
};
static_assert(sizeof(MdnsListenClient_OnAddressResult_Params_Data) == 24,
              "Bad sizeof(MdnsListenClient_OnAddressResult_Params_Data)");
class  MdnsListenClient_OnTextResult_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t update_type;
  int32_t query_type;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> text_records;

 private:
  friend class mojo::internal::MessageFragment<MdnsListenClient_OnTextResult_Params_Data>;

  MdnsListenClient_OnTextResult_Params_Data();
  ~MdnsListenClient_OnTextResult_Params_Data() = delete;
};
static_assert(sizeof(MdnsListenClient_OnTextResult_Params_Data) == 24,
              "Bad sizeof(MdnsListenClient_OnTextResult_Params_Data)");
class  MdnsListenClient_OnHostnameResult_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t update_type;
  int32_t query_type;
  mojo::internal::Pointer<::network::mojom::internal::HostPortPair_Data> host;

 private:
  friend class mojo::internal::MessageFragment<MdnsListenClient_OnHostnameResult_Params_Data>;

  MdnsListenClient_OnHostnameResult_Params_Data();
  ~MdnsListenClient_OnHostnameResult_Params_Data() = delete;
};
static_assert(sizeof(MdnsListenClient_OnHostnameResult_Params_Data) == 24,
              "Bad sizeof(MdnsListenClient_OnHostnameResult_Params_Data)");
class  MdnsListenClient_OnUnhandledResult_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t update_type;
  int32_t query_type;

 private:
  friend class mojo::internal::MessageFragment<MdnsListenClient_OnUnhandledResult_Params_Data>;

  MdnsListenClient_OnUnhandledResult_Params_Data();
  ~MdnsListenClient_OnUnhandledResult_Params_Data() = delete;
};
static_assert(sizeof(MdnsListenClient_OnUnhandledResult_Params_Data) == 16,
              "Bad sizeof(MdnsListenClient_OnUnhandledResult_Params_Data)");
class  HostResolver_ResolveHost_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::HostResolverHost_Data host;
  ::network::mojom::internal::NetworkAnonymizationKey_Data network_anonymization_key;
  mojo::internal::Pointer<internal::ResolveHostParameters_Data> optional_parameters;
  mojo::internal::Interface_Data response_client;

 private:
  friend class mojo::internal::MessageFragment<HostResolver_ResolveHost_Params_Data>;

  HostResolver_ResolveHost_Params_Data();
  ~HostResolver_ResolveHost_Params_Data() = delete;
};
static_assert(sizeof(HostResolver_ResolveHost_Params_Data) == 56,
              "Bad sizeof(HostResolver_ResolveHost_Params_Data)");
class  HostResolver_MdnsListen_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::HostPortPair_Data> host;
  int32_t query_type;
  mojo::internal::Interface_Data response_client;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<HostResolver_MdnsListen_Params_Data>;

  HostResolver_MdnsListen_Params_Data();
  ~HostResolver_MdnsListen_Params_Data() = delete;
};
static_assert(sizeof(HostResolver_MdnsListen_Params_Data) == 32,
              "Bad sizeof(HostResolver_MdnsListen_Params_Data)");
class  HostResolver_MdnsListen_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<HostResolver_MdnsListen_ResponseParams_Data>;

  HostResolver_MdnsListen_ResponseParams_Data();
  ~HostResolver_MdnsListen_ResponseParams_Data() = delete;
};
static_assert(sizeof(HostResolver_MdnsListen_ResponseParams_Data) == 16,
              "Bad sizeof(HostResolver_MdnsListen_ResponseParams_Data)");
class  DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data>;

  DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data();
  ~DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data() = delete;
};
static_assert(sizeof(DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data) == 8,
              "Bad sizeof(DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data)");
class  DnsConfigChangeManager_RequestNotifications_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data client;

 private:
  friend class mojo::internal::MessageFragment<DnsConfigChangeManager_RequestNotifications_Params_Data>;

  DnsConfigChangeManager_RequestNotifications_Params_Data();
  ~DnsConfigChangeManager_RequestNotifications_Params_Data() = delete;
};
static_assert(sizeof(DnsConfigChangeManager_RequestNotifications_Params_Data) == 16,
              "Bad sizeof(DnsConfigChangeManager_RequestNotifications_Params_Data)");

}  // namespace internal


class ResolveHostHandle_Cancel_ParamsDataView {
 public:
  ResolveHostHandle_Cancel_ParamsDataView() = default;

  ResolveHostHandle_Cancel_ParamsDataView(
      internal::ResolveHostHandle_Cancel_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t result() const {
    return data_->result;
  }
 private:
  internal::ResolveHostHandle_Cancel_Params_Data* data_ = nullptr;
};


class ResolveHostClient_OnComplete_ParamsDataView {
 public:
  ResolveHostClient_OnComplete_ParamsDataView() = default;

  ResolveHostClient_OnComplete_ParamsDataView(
      internal::ResolveHostClient_OnComplete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t result() const {
    return data_->result;
  }
  inline void GetResolveErrorInfoDataView(
      ::network::mojom::ResolveErrorInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResolveErrorInfo(UserType* output) {
    
    auto* pointer = data_->resolve_error_info.Get();
    return mojo::internal::Deserialize<::network::mojom::ResolveErrorInfoDataView>(
        pointer, output, message_);
  }
  inline void GetResolvedAddressesDataView(
      ::network::mojom::AddressListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResolvedAddresses(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::AddressListDataView, UserType>(),
    "Attempting to read the optional `resolved_addresses` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResolvedAddresses` instead "
    "of `ReadResolvedAddresses if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->resolved_addresses.Get();
    return mojo::internal::Deserialize<::network::mojom::AddressListDataView>(
        pointer, output, message_);
  }
  inline void GetEndpointResultsWithMetadataDataView(
      mojo::ArrayDataView<::network::mojom::HostResolverEndpointResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndpointResultsWithMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::HostResolverEndpointResultDataView>, UserType>(),
    "Attempting to read the optional `endpoint_results_with_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEndpointResultsWithMetadata` instead "
    "of `ReadEndpointResultsWithMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->endpoint_results_with_metadata.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HostResolverEndpointResultDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ResolveHostClient_OnComplete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResolveHostClient_OnTextResults_ParamsDataView {
 public:
  ResolveHostClient_OnTextResults_ParamsDataView() = default;

  ResolveHostClient_OnTextResults_ParamsDataView(
      internal::ResolveHostClient_OnTextResults_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextResultsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextResults(UserType* output) {
    
    auto* pointer = data_->text_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ResolveHostClient_OnTextResults_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResolveHostClient_OnHostnameResults_ParamsDataView {
 public:
  ResolveHostClient_OnHostnameResults_ParamsDataView() = default;

  ResolveHostClient_OnHostnameResults_ParamsDataView(
      internal::ResolveHostClient_OnHostnameResults_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostsDataView(
      mojo::ArrayDataView<::network::mojom::HostPortPairDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHosts(UserType* output) {
    
    auto* pointer = data_->hosts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HostPortPairDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ResolveHostClient_OnHostnameResults_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MdnsListenClient_OnAddressResult_ParamsDataView {
 public:
  MdnsListenClient_OnAddressResult_ParamsDataView() = default;

  MdnsListenClient_OnAddressResult_ParamsDataView(
      internal::MdnsListenClient_OnAddressResult_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadUpdateType(UserType* output) const {
    auto data_value = data_->update_type;
    return mojo::internal::Deserialize<::network::mojom::MdnsListenClient_UpdateType>(
        data_value, output);
  }
  MdnsListenClient_UpdateType update_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::MdnsListenClient_UpdateType>(data_->update_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadQueryType(UserType* output) const {
    auto data_value = data_->query_type;
    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_value, output);
  }
  DnsQueryType query_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->query_type));
  }
  inline void GetEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndpoint(UserType* output) {
    
    auto* pointer = data_->endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
 private:
  internal::MdnsListenClient_OnAddressResult_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MdnsListenClient_OnTextResult_ParamsDataView {
 public:
  MdnsListenClient_OnTextResult_ParamsDataView() = default;

  MdnsListenClient_OnTextResult_ParamsDataView(
      internal::MdnsListenClient_OnTextResult_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadUpdateType(UserType* output) const {
    auto data_value = data_->update_type;
    return mojo::internal::Deserialize<::network::mojom::MdnsListenClient_UpdateType>(
        data_value, output);
  }
  MdnsListenClient_UpdateType update_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::MdnsListenClient_UpdateType>(data_->update_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadQueryType(UserType* output) const {
    auto data_value = data_->query_type;
    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_value, output);
  }
  DnsQueryType query_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->query_type));
  }
  inline void GetTextRecordsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextRecords(UserType* output) {
    
    auto* pointer = data_->text_records.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MdnsListenClient_OnTextResult_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MdnsListenClient_OnHostnameResult_ParamsDataView {
 public:
  MdnsListenClient_OnHostnameResult_ParamsDataView() = default;

  MdnsListenClient_OnHostnameResult_ParamsDataView(
      internal::MdnsListenClient_OnHostnameResult_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadUpdateType(UserType* output) const {
    auto data_value = data_->update_type;
    return mojo::internal::Deserialize<::network::mojom::MdnsListenClient_UpdateType>(
        data_value, output);
  }
  MdnsListenClient_UpdateType update_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::MdnsListenClient_UpdateType>(data_->update_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadQueryType(UserType* output) const {
    auto data_value = data_->query_type;
    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_value, output);
  }
  DnsQueryType query_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->query_type));
  }
  inline void GetHostDataView(
      ::network::mojom::HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
 private:
  internal::MdnsListenClient_OnHostnameResult_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MdnsListenClient_OnUnhandledResult_ParamsDataView {
 public:
  MdnsListenClient_OnUnhandledResult_ParamsDataView() = default;

  MdnsListenClient_OnUnhandledResult_ParamsDataView(
      internal::MdnsListenClient_OnUnhandledResult_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadUpdateType(UserType* output) const {
    auto data_value = data_->update_type;
    return mojo::internal::Deserialize<::network::mojom::MdnsListenClient_UpdateType>(
        data_value, output);
  }
  MdnsListenClient_UpdateType update_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::MdnsListenClient_UpdateType>(data_->update_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadQueryType(UserType* output) const {
    auto data_value = data_->query_type;
    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_value, output);
  }
  DnsQueryType query_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->query_type));
  }
 private:
  internal::MdnsListenClient_OnUnhandledResult_Params_Data* data_ = nullptr;
};


class HostResolver_ResolveHost_ParamsDataView {
 public:
  HostResolver_ResolveHost_ParamsDataView() = default;

  HostResolver_ResolveHost_ParamsDataView(
      internal::HostResolver_ResolveHost_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostDataView(
      HostResolverHostDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = !data_->host.is_null() ? &data_->host : nullptr;
    return mojo::internal::Deserialize<::network::mojom::HostResolverHostDataView>(
        pointer, output, message_);
  }
  inline void GetNetworkAnonymizationKeyDataView(
      ::network::mojom::NetworkAnonymizationKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkAnonymizationKey(UserType* output) {
    
    auto* pointer = !data_->network_anonymization_key.is_null() ? &data_->network_anonymization_key : nullptr;
    return mojo::internal::Deserialize<::network::mojom::NetworkAnonymizationKeyDataView>(
        pointer, output, message_);
  }
  inline void GetOptionalParametersDataView(
      ResolveHostParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalParameters(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ResolveHostParametersDataView, UserType>(),
    "Attempting to read the optional `optional_parameters` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOptionalParameters` instead "
    "of `ReadOptionalParameters if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->optional_parameters.Get();
    return mojo::internal::Deserialize<::network::mojom::ResolveHostParametersDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeResponseClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ResolveHostClientInterfaceBase>>(
            &data_->response_client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::HostResolver_ResolveHost_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HostResolver_MdnsListen_ParamsDataView {
 public:
  HostResolver_MdnsListen_ParamsDataView() = default;

  HostResolver_MdnsListen_ParamsDataView(
      internal::HostResolver_MdnsListen_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostDataView(
      ::network::mojom::HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadQueryType(UserType* output) const {
    auto data_value = data_->query_type;
    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_value, output);
  }
  DnsQueryType query_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->query_type));
  }
  template <typename UserType>
  UserType TakeResponseClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::MdnsListenClientInterfaceBase>>(
            &data_->response_client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::HostResolver_MdnsListen_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HostResolver_MdnsListen_ResponseParamsDataView {
 public:
  HostResolver_MdnsListen_ResponseParamsDataView() = default;

  HostResolver_MdnsListen_ResponseParamsDataView(
      internal::HostResolver_MdnsListen_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t result() const {
    return data_->result;
  }
 private:
  internal::HostResolver_MdnsListen_ResponseParams_Data* data_ = nullptr;
};


class DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsDataView {
 public:
  DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsDataView() = default;

  DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsDataView(
      internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data* data_ = nullptr;
};


class DnsConfigChangeManager_RequestNotifications_ParamsDataView {
 public:
  DnsConfigChangeManager_RequestNotifications_ParamsDataView() = default;

  DnsConfigChangeManager_RequestNotifications_ParamsDataView(
      internal::DnsConfigChangeManager_RequestNotifications_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DnsConfigChangeManagerClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DnsConfigChangeManager_RequestNotifications_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



inline void ResolveHostClient_OnComplete_ParamsDataView::GetResolveErrorInfoDataView(
    ::network::mojom::ResolveErrorInfoDataView* output) {
  auto pointer = data_->resolve_error_info.Get();
  *output = ::network::mojom::ResolveErrorInfoDataView(pointer, message_);
}
inline void ResolveHostClient_OnComplete_ParamsDataView::GetResolvedAddressesDataView(
    ::network::mojom::AddressListDataView* output) {
  auto pointer = data_->resolved_addresses.Get();
  *output = ::network::mojom::AddressListDataView(pointer, message_);
}
inline void ResolveHostClient_OnComplete_ParamsDataView::GetEndpointResultsWithMetadataDataView(
    mojo::ArrayDataView<::network::mojom::HostResolverEndpointResultDataView>* output) {
  auto pointer = data_->endpoint_results_with_metadata.Get();
  *output = mojo::ArrayDataView<::network::mojom::HostResolverEndpointResultDataView>(pointer, message_);
}


inline void ResolveHostClient_OnTextResults_ParamsDataView::GetTextResultsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->text_results.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void ResolveHostClient_OnHostnameResults_ParamsDataView::GetHostsDataView(
    mojo::ArrayDataView<::network::mojom::HostPortPairDataView>* output) {
  auto pointer = data_->hosts.Get();
  *output = mojo::ArrayDataView<::network::mojom::HostPortPairDataView>(pointer, message_);
}


inline void MdnsListenClient_OnAddressResult_ParamsDataView::GetEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}


inline void MdnsListenClient_OnTextResult_ParamsDataView::GetTextRecordsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->text_records.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void MdnsListenClient_OnHostnameResult_ParamsDataView::GetHostDataView(
    ::network::mojom::HostPortPairDataView* output) {
  auto pointer = data_->host.Get();
  *output = ::network::mojom::HostPortPairDataView(pointer, message_);
}




inline void HostResolver_ResolveHost_ParamsDataView::GetHostDataView(
    HostResolverHostDataView* output) {
  auto pointer = &data_->host;
  *output = HostResolverHostDataView(pointer, message_);
}
inline void HostResolver_ResolveHost_ParamsDataView::GetNetworkAnonymizationKeyDataView(
    ::network::mojom::NetworkAnonymizationKeyDataView* output) {
  auto pointer = &data_->network_anonymization_key;
  *output = ::network::mojom::NetworkAnonymizationKeyDataView(pointer, message_);
}
inline void HostResolver_ResolveHost_ParamsDataView::GetOptionalParametersDataView(
    ResolveHostParametersDataView* output) {
  auto pointer = data_->optional_parameters.Get();
  *output = ResolveHostParametersDataView(pointer, message_);
}


inline void HostResolver_MdnsListen_ParamsDataView::GetHostDataView(
    ::network::mojom::HostPortPairDataView* output) {
  auto pointer = data_->host.Get();
  *output = ::network::mojom::HostPortPairDataView(pointer, message_);
}









}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_PARAMS_DATA_H_