// services/network/public/mojom/content_security_policy.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/content_security_policy.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/content_security_policy.mojom-params-data.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/content_security_policy.mojom-blink-import-headers.h"
#include "services/network/public/mojom/content_security_policy.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
ContentSecurityPolicyHeader::ContentSecurityPolicyHeader()
    : header_value(),
      type(ContentSecurityPolicyType::kEnforce),
      source(ContentSecurityPolicySource::kHTTP) {}

ContentSecurityPolicyHeader::ContentSecurityPolicyHeader(
    const WTF::String& header_value_in,
    ContentSecurityPolicyType type_in,
    ContentSecurityPolicySource source_in)
    : header_value(std::move(header_value_in)),
      type(std::move(type_in)),
      source(std::move(source_in)) {}

ContentSecurityPolicyHeader::~ContentSecurityPolicyHeader() = default;
size_t ContentSecurityPolicyHeader::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->header_value);
  seed = mojo::internal::WTFHash(seed, this->type);
  seed = mojo::internal::WTFHash(seed, this->source);
  return seed;
}

void ContentSecurityPolicyHeader::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header_value"), this->header_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContentSecurityPolicyType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContentSecurityPolicySource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContentSecurityPolicyHeader::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPSource::CSPSource()
    : scheme(),
      host(),
      port(-1),
      path(),
      is_host_wildcard(false),
      is_port_wildcard(false) {}

CSPSource::CSPSource(
    const WTF::String& scheme_in,
    const WTF::String& host_in,
    int32_t port_in,
    const WTF::String& path_in,
    bool is_host_wildcard_in,
    bool is_port_wildcard_in)
    : scheme(std::move(scheme_in)),
      host(std::move(host_in)),
      port(std::move(port_in)),
      path(std::move(path_in)),
      is_host_wildcard(std::move(is_host_wildcard_in)),
      is_port_wildcard(std::move(is_port_wildcard_in)) {}

CSPSource::~CSPSource() = default;
size_t CSPSource::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->scheme);
  seed = mojo::internal::WTFHash(seed, this->host);
  seed = mojo::internal::WTFHash(seed, this->port);
  seed = mojo::internal::WTFHash(seed, this->path);
  seed = mojo::internal::WTFHash(seed, this->is_host_wildcard);
  seed = mojo::internal::WTFHash(seed, this->is_port_wildcard);
  return seed;
}

void CSPSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_host_wildcard"), this->is_host_wildcard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_port_wildcard"), this->is_port_wildcard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSPSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPHashSource::CSPHashSource()
    : algorithm(),
      value() {}

CSPHashSource::CSPHashSource(
    ::network::mojom::blink::IntegrityAlgorithm algorithm_in,
    WTF::Vector<uint8_t> value_in)
    : algorithm(std::move(algorithm_in)),
      value(std::move(value_in)) {}

CSPHashSource::~CSPHashSource() = default;

void CSPHashSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "algorithm"), this->algorithm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::IntegrityAlgorithm>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSPHashSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPSourceList::CSPSourceList()
    : sources(),
      nonces(),
      hashes(),
      allow_self(false),
      allow_star(false),
      allow_inline(false),
      allow_inline_speculation_rules(false),
      allow_eval(false),
      allow_wasm_eval(false),
      allow_wasm_unsafe_eval(false),
      allow_dynamic(false),
      allow_unsafe_hashes(false),
      report_sample(false),
      report_hash_algorithm() {}

CSPSourceList::CSPSourceList(
    WTF::Vector<CSPSourcePtr> sources_in,
    WTF::Vector<WTF::String> nonces_in,
    WTF::Vector<CSPHashSourcePtr> hashes_in,
    bool allow_self_in,
    bool allow_star_in,
    bool allow_inline_in,
    bool allow_inline_speculation_rules_in,
    bool allow_eval_in,
    bool allow_wasm_eval_in,
    bool allow_wasm_unsafe_eval_in,
    bool allow_dynamic_in,
    bool allow_unsafe_hashes_in,
    bool report_sample_in,
    std::optional<::network::mojom::blink::IntegrityAlgorithm> report_hash_algorithm_in)
    : sources(std::move(sources_in)),
      nonces(std::move(nonces_in)),
      hashes(std::move(hashes_in)),
      allow_self(std::move(allow_self_in)),
      allow_star(std::move(allow_star_in)),
      allow_inline(std::move(allow_inline_in)),
      allow_inline_speculation_rules(std::move(allow_inline_speculation_rules_in)),
      allow_eval(std::move(allow_eval_in)),
      allow_wasm_eval(std::move(allow_wasm_eval_in)),
      allow_wasm_unsafe_eval(std::move(allow_wasm_unsafe_eval_in)),
      allow_dynamic(std::move(allow_dynamic_in)),
      allow_unsafe_hashes(std::move(allow_unsafe_hashes_in)),
      report_sample(std::move(report_sample_in)),
      report_hash_algorithm(std::move(report_hash_algorithm_in)) {}

CSPSourceList::~CSPSourceList() = default;

void CSPSourceList::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sources"), this->sources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<CSPSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonces"), this->nonces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hashes"), this->hashes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<CSPHashSourcePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_self"), this->allow_self,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_star"), this->allow_star,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_inline"), this->allow_inline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_inline_speculation_rules"), this->allow_inline_speculation_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_eval"), this->allow_eval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_wasm_eval"), this->allow_wasm_eval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_wasm_unsafe_eval"), this->allow_wasm_unsafe_eval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_dynamic"), this->allow_dynamic,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_unsafe_hashes"), this->allow_unsafe_hashes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_sample"), this->report_sample,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_hash_algorithm"), this->report_hash_algorithm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::network::mojom::blink::IntegrityAlgorithm>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSPSourceList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPTrustedTypes::CSPTrustedTypes()
    : list(),
      allow_any(false),
      allow_duplicates(false) {}

CSPTrustedTypes::CSPTrustedTypes(
    WTF::Vector<WTF::String> list_in,
    bool allow_any_in,
    bool allow_duplicates_in)
    : list(std::move(list_in)),
      allow_any(std::move(allow_any_in)),
      allow_duplicates(std::move(allow_duplicates_in)) {}

CSPTrustedTypes::~CSPTrustedTypes() = default;

void CSPTrustedTypes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "list"), this->list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_any"), this->allow_any,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_duplicates"), this->allow_duplicates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSPTrustedTypes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentSecurityPolicy::ContentSecurityPolicy()
    : self_origin(),
      raw_directives(),
      directives(),
      upgrade_insecure_requests(false),
      treat_as_public_address(false),
      block_all_mixed_content(false),
      sandbox(::network::mojom::blink::WebSandboxFlags::kNone),
      header(),
      use_reporting_api(false),
      report_endpoints(),
      require_trusted_types_for(CSPRequireTrustedTypesFor::None),
      trusted_types(),
      parsing_errors() {}

ContentSecurityPolicy::ContentSecurityPolicy(
    CSPSourcePtr self_origin_in,
    const WTF::HashMap<CSPDirectiveName, WTF::String>& raw_directives_in,
    WTF::HashMap<CSPDirectiveName, CSPSourceListPtr> directives_in,
    bool upgrade_insecure_requests_in,
    bool treat_as_public_address_in,
    bool block_all_mixed_content_in,
    ::network::mojom::blink::WebSandboxFlags sandbox_in,
    ContentSecurityPolicyHeaderPtr header_in,
    bool use_reporting_api_in,
    WTF::Vector<WTF::String> report_endpoints_in,
    CSPRequireTrustedTypesFor require_trusted_types_for_in,
    CSPTrustedTypesPtr trusted_types_in,
    WTF::Vector<WTF::String> parsing_errors_in)
    : self_origin(std::move(self_origin_in)),
      raw_directives(std::move(raw_directives_in)),
      directives(std::move(directives_in)),
      upgrade_insecure_requests(std::move(upgrade_insecure_requests_in)),
      treat_as_public_address(std::move(treat_as_public_address_in)),
      block_all_mixed_content(std::move(block_all_mixed_content_in)),
      sandbox(std::move(sandbox_in)),
      header(std::move(header_in)),
      use_reporting_api(std::move(use_reporting_api_in)),
      report_endpoints(std::move(report_endpoints_in)),
      require_trusted_types_for(std::move(require_trusted_types_for_in)),
      trusted_types(std::move(trusted_types_in)),
      parsing_errors(std::move(parsing_errors_in)) {}

ContentSecurityPolicy::~ContentSecurityPolicy() = default;

void ContentSecurityPolicy::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "self_origin"), this->self_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CSPSourcePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_directives"), this->raw_directives,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::HashMap<CSPDirectiveName, WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "directives"), this->directives,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::HashMap<CSPDirectiveName, CSPSourceListPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upgrade_insecure_requests"), this->upgrade_insecure_requests,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "treat_as_public_address"), this->treat_as_public_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "block_all_mixed_content"), this->block_all_mixed_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandbox"), this->sandbox,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::WebSandboxFlags>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header"), this->header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContentSecurityPolicyHeaderPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_reporting_api"), this->use_reporting_api,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_endpoints"), this->report_endpoints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_trusted_types_for"), this->require_trusted_types_for,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CSPRequireTrustedTypesFor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_types"), this->trusted_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CSPTrustedTypesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parsing_errors"), this->parsing_errors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContentSecurityPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CSPViolation::CSPViolation()
    : directive(),
      effective_directive(),
      console_message(),
      blocked_url(),
      report_endpoints(),
      use_reporting_api(),
      header(),
      type(),
      source_location() {}

CSPViolation::CSPViolation(
    const WTF::String& directive_in,
    const WTF::String& effective_directive_in,
    const WTF::String& console_message_in,
    const ::blink::KURL& blocked_url_in,
    WTF::Vector<WTF::String> report_endpoints_in,
    bool use_reporting_api_in,
    const WTF::String& header_in,
    ContentSecurityPolicyType type_in,
    ::network::mojom::blink::SourceLocationPtr source_location_in)
    : directive(std::move(directive_in)),
      effective_directive(std::move(effective_directive_in)),
      console_message(std::move(console_message_in)),
      blocked_url(std::move(blocked_url_in)),
      report_endpoints(std::move(report_endpoints_in)),
      use_reporting_api(std::move(use_reporting_api_in)),
      header(std::move(header_in)),
      type(std::move(type_in)),
      source_location(std::move(source_location_in)) {}

CSPViolation::~CSPViolation() = default;

void CSPViolation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "directive"), this->directive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "effective_directive"), this->effective_directive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "console_message"), this->console_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_url"), this->blocked_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_endpoints"), this->report_endpoints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_reporting_api"), this->use_reporting_api,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header"), this->header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContentSecurityPolicyType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_location"), this->source_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::SourceLocationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CSPViolation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AllowCSPFromHeaderValue::AllowCSPFromHeaderValue() : tag_(Tag::kAllowStar) {
  data_.allow_star = bool();
}

AllowCSPFromHeaderValue::~AllowCSPFromHeaderValue() {
  DestroyActive();
}


void AllowCSPFromHeaderValue::set_allow_star(
    bool allow_star) {
  if (tag_ != Tag::kAllowStar) {
    DestroyActive();
    tag_ = Tag::kAllowStar;
  }
  data_.allow_star = allow_star;
}
void AllowCSPFromHeaderValue::set_origin(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin) {
  if (tag_ == Tag::kOrigin) {
    *(data_.origin) = std::move(origin);
  } else {
    DestroyActive();
    tag_ = Tag::kOrigin;
    data_.origin = new ::scoped_refptr<const ::blink::SecurityOrigin>(
        std::move(origin));
  }
}
void AllowCSPFromHeaderValue::set_error_message(
    const WTF::String& error_message) {
  if (tag_ == Tag::kErrorMessage) {
    *(data_.error_message) = std::move(error_message);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorMessage;
    data_.error_message = new WTF::String(
        std::move(error_message));
  }
}

void AllowCSPFromHeaderValue::DestroyActive() {
  switch (tag_) {

    case Tag::kAllowStar:

      break;
    case Tag::kOrigin:

      delete data_.origin;
      break;
    case Tag::kErrorMessage:

      delete data_.error_message;
      break;
  }
}

bool AllowCSPFromHeaderValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ContentSecurityPolicyHeader::DataView, ::network::mojom::blink::ContentSecurityPolicyHeaderPtr>::Read(
    ::network::mojom::blink::ContentSecurityPolicyHeader::DataView input,
    ::network::mojom::blink::ContentSecurityPolicyHeaderPtr* output) {
  bool success = true;
  ::network::mojom::blink::ContentSecurityPolicyHeaderPtr result(::network::mojom::blink::ContentSecurityPolicyHeader::New());
  
      if (success && !input.ReadHeaderValue(&result->header_value))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPSource::DataView, ::network::mojom::blink::CSPSourcePtr>::Read(
    ::network::mojom::blink::CSPSource::DataView input,
    ::network::mojom::blink::CSPSourcePtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPSourcePtr result(::network::mojom::blink::CSPSource::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->is_host_wildcard = input.is_host_wildcard();
      if (success)
        result->is_port_wildcard = input.is_port_wildcard();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPHashSource::DataView, ::network::mojom::blink::CSPHashSourcePtr>::Read(
    ::network::mojom::blink::CSPHashSource::DataView input,
    ::network::mojom::blink::CSPHashSourcePtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPHashSourcePtr result(::network::mojom::blink::CSPHashSource::New());
  
      if (success && !input.ReadAlgorithm(&result->algorithm))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPSourceList::DataView, ::network::mojom::blink::CSPSourceListPtr>::Read(
    ::network::mojom::blink::CSPSourceList::DataView input,
    ::network::mojom::blink::CSPSourceListPtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPSourceListPtr result(::network::mojom::blink::CSPSourceList::New());
  
      if (success && !input.ReadSources(&result->sources))
        success = false;
      if (success && !input.ReadNonces(&result->nonces))
        success = false;
      if (success && !input.ReadHashes(&result->hashes))
        success = false;
      if (success)
        result->allow_self = input.allow_self();
      if (success)
        result->allow_star = input.allow_star();
      if (success)
        result->allow_inline = input.allow_inline();
      if (success)
        result->allow_inline_speculation_rules = input.allow_inline_speculation_rules();
      if (success)
        result->allow_eval = input.allow_eval();
      if (success)
        result->allow_wasm_eval = input.allow_wasm_eval();
      if (success)
        result->allow_wasm_unsafe_eval = input.allow_wasm_unsafe_eval();
      if (success)
        result->allow_dynamic = input.allow_dynamic();
      if (success)
        result->allow_unsafe_hashes = input.allow_unsafe_hashes();
      if (success)
        result->report_sample = input.report_sample();
      if (success && !input.ReadReportHashAlgorithm(&result->report_hash_algorithm)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPTrustedTypes::DataView, ::network::mojom::blink::CSPTrustedTypesPtr>::Read(
    ::network::mojom::blink::CSPTrustedTypes::DataView input,
    ::network::mojom::blink::CSPTrustedTypesPtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPTrustedTypesPtr result(::network::mojom::blink::CSPTrustedTypes::New());
  
      if (success && !input.ReadList(&result->list))
        success = false;
      if (success)
        result->allow_any = input.allow_any();
      if (success)
        result->allow_duplicates = input.allow_duplicates();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ContentSecurityPolicy::DataView, ::network::mojom::blink::ContentSecurityPolicyPtr>::Read(
    ::network::mojom::blink::ContentSecurityPolicy::DataView input,
    ::network::mojom::blink::ContentSecurityPolicyPtr* output) {
  bool success = true;
  ::network::mojom::blink::ContentSecurityPolicyPtr result(::network::mojom::blink::ContentSecurityPolicy::New());
  
      if (success && !input.ReadSelfOrigin(&result->self_origin))
        success = false;
      if (success && !input.ReadRawDirectives(&result->raw_directives))
        success = false;
      if (success && !input.ReadDirectives(&result->directives))
        success = false;
      if (success)
        result->upgrade_insecure_requests = input.upgrade_insecure_requests();
      if (success)
        result->treat_as_public_address = input.treat_as_public_address();
      if (success)
        result->block_all_mixed_content = input.block_all_mixed_content();
      if (success && !input.ReadSandbox(&result->sandbox))
        success = false;
      if (success && !input.ReadHeader(&result->header))
        success = false;
      if (success)
        result->use_reporting_api = input.use_reporting_api();
      if (success && !input.ReadReportEndpoints(&result->report_endpoints))
        success = false;
      if (success && !input.ReadRequireTrustedTypesFor(&result->require_trusted_types_for))
        success = false;
      if (success && !input.ReadTrustedTypes(&result->trusted_types))
        success = false;
      if (success && !input.ReadParsingErrors(&result->parsing_errors))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CSPViolation::DataView, ::network::mojom::blink::CSPViolationPtr>::Read(
    ::network::mojom::blink::CSPViolation::DataView input,
    ::network::mojom::blink::CSPViolationPtr* output) {
  bool success = true;
  ::network::mojom::blink::CSPViolationPtr result(::network::mojom::blink::CSPViolation::New());
  
      if (success && !input.ReadDirective(&result->directive))
        success = false;
      if (success && !input.ReadEffectiveDirective(&result->effective_directive))
        success = false;
      if (success && !input.ReadConsoleMessage(&result->console_message))
        success = false;
      if (success && !input.ReadBlockedUrl(&result->blocked_url))
        success = false;
      if (success && !input.ReadReportEndpoints(&result->report_endpoints))
        success = false;
      if (success)
        result->use_reporting_api = input.use_reporting_api();
      if (success && !input.ReadHeader(&result->header))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSourceLocation(&result->source_location))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::AllowCSPFromHeaderValue::DataView, ::network::mojom::blink::AllowCSPFromHeaderValuePtr>::Read(
    ::network::mojom::blink::AllowCSPFromHeaderValue::DataView input,
    ::network::mojom::blink::AllowCSPFromHeaderValuePtr* output) {
  using UnionType = ::network::mojom::blink::AllowCSPFromHeaderValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kAllowStar: {
      *output = UnionType::NewAllowStar(input.allow_star());
      break;
    }
    case Tag::kOrigin: {
      ::scoped_refptr<const ::blink::SecurityOrigin> result_origin;
      if (!input.ReadOrigin(&result_origin))
        return false;

      *output = UnionType::NewOrigin(
          std::move(result_origin));
      break;
    }
    case Tag::kErrorMessage: {
      WTF::String result_error_message;
      if (!input.ReadErrorMessage(&result_error_message))
        return false;

      *output = UnionType::NewErrorMessage(
          std::move(result_error_message));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif