// services/network/public/mojom/client_security_state.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/client_security_state.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/client_security_state.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* PrivateNetworkRequestPolicyToStringHelper(PrivateNetworkRequestPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrivateNetworkRequestPolicy::kAllow:
      return "kAllow";
    case PrivateNetworkRequestPolicy::kWarn:
      return "kWarn";
    case PrivateNetworkRequestPolicy::kBlock:
      return "kBlock";
    case PrivateNetworkRequestPolicy::kPreflightWarn:
      return "kPreflightWarn";
    case PrivateNetworkRequestPolicy::kPreflightBlock:
      return "kPreflightBlock";
    default:
      return nullptr;
  }
}

std::string PrivateNetworkRequestPolicyToString(PrivateNetworkRequestPolicy value) {
  const char *str = PrivateNetworkRequestPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrivateNetworkRequestPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrivateNetworkRequestPolicy value) {
  return os << PrivateNetworkRequestPolicyToString(value);
}

namespace internal {


// static
bool ClientSecurityState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientSecurityState_Data* object =
      static_cast<const ClientSecurityState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_embedder_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_embedder_policy, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->ip_address_space, validation_context))
    return false;


  if (!::network::mojom::internal::PrivateNetworkRequestPolicy_Data
        ::Validate(object->private_network_request_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_isolation_policy, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_isolation_policy, validation_context))
    return false;

  return true;
}

ClientSecurityState_Data::ClientSecurityState_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::PrivateNetworkRequestPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::PrivateNetworkRequestPolicy value) {
  return std::move(context).WriteString(::network::mojom::PrivateNetworkRequestPolicyToString(value));
}

} // namespace perfetto