// media/mojo/mojom/audio_decoder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_decoder.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_decoder.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_decoder.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_log.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "media/mojo/mojom/supported_audio_decoder_config_mojom_traits.h"




namespace media::mojom {

class AudioDecoderProxy;

template <typename ImplRefTraits>
class AudioDecoderStub;

class AudioDecoderRequestValidator;
class AudioDecoderResponseValidator;


class AudioDecoder
    : public AudioDecoderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1261102173
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioDecoderInterfaceBase;
  using Proxy_ = AudioDecoderProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioDecoderStub<ImplRefTraits>;

  using RequestValidator_ = AudioDecoderRequestValidator;
  using ResponseValidator_ = AudioDecoderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSupportedConfigsMinVersion = 0,
    kConstructMinVersion = 0,
    kInitializeMinVersion = 0,
    kSetDataSourceMinVersion = 0,
    kDecodeMinVersion = 0,
    kResetMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSupportedConfigs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Construct_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDataSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Decode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Reset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioDecoder() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetSupportedConfigs(std::vector<::media::SupportedAudioDecoderConfig>* out_supported_configs);

  using GetSupportedConfigsCallback = base::OnceCallback<void(const std::vector<::media::SupportedAudioDecoderConfig>&)>;
  
  virtual void GetSupportedConfigs(GetSupportedConfigsCallback callback) = 0;

  
  virtual void Construct(::mojo::PendingAssociatedRemote<AudioDecoderClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log) = 0;


  using InitializeCallback = base::OnceCallback<void(const ::media::DecoderStatus&, bool, ::media::AudioDecoderType)>;
  
  virtual void Initialize(const ::media::AudioDecoderConfig& config, const std::optional<::base::UnguessableToken>& cdm_id, InitializeCallback callback) = 0;

  
  virtual void SetDataSource(::mojo::ScopedDataPipeConsumerHandle receive_pipe) = 0;


  using DecodeCallback = base::OnceCallback<void(const ::media::DecoderStatus&)>;
  
  virtual void Decode(::media::mojom::DecoderBufferPtr buffer, DecodeCallback callback) = 0;


  using ResetCallback = base::OnceCallback<void()>;
  
  virtual void Reset(ResetCallback callback) = 0;
};

class AudioDecoderClientProxy;

template <typename ImplRefTraits>
class AudioDecoderClientStub;

class AudioDecoderClientRequestValidator;


class AudioDecoderClient
    : public AudioDecoderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioDecoderClientInterfaceBase;
  using Proxy_ = AudioDecoderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioDecoderClientStub<ImplRefTraits>;

  using RequestValidator_ = AudioDecoderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnBufferDecodedMinVersion = 0,
    kOnWaitingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnBufferDecoded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWaiting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioDecoderClient() = default;

  
  virtual void OnBufferDecoded(::media::mojom::AudioBufferPtr buffer) = 0;

  
  virtual void OnWaiting(::media::WaitingReason reason) = 0;
};



class  AudioDecoderProxy
    : public AudioDecoder {
 public:
  using InterfaceType = AudioDecoder;

  explicit AudioDecoderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetSupportedConfigs(std::vector<::media::SupportedAudioDecoderConfig>* out_supported_configs) final;
  
  void GetSupportedConfigs(GetSupportedConfigsCallback callback) final;
  
  void Construct(::mojo::PendingAssociatedRemote<AudioDecoderClient> client, ::mojo::PendingRemote<::media::mojom::MediaLog> media_log) final;
  
  void Initialize(const ::media::AudioDecoderConfig& config, const std::optional<::base::UnguessableToken>& cdm_id, InitializeCallback callback) final;
  
  void SetDataSource(::mojo::ScopedDataPipeConsumerHandle receive_pipe) final;
  
  void Decode(::media::mojom::DecoderBufferPtr buffer, DecodeCallback callback) final;
  
  void Reset(ResetCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AudioDecoderClientProxy
    : public AudioDecoderClient {
 public:
  using InterfaceType = AudioDecoderClient;

  explicit AudioDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnBufferDecoded(::media::mojom::AudioBufferPtr buffer) final;
  
  void OnWaiting(::media::WaitingReason reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AudioDecoderStubDispatch {
 public:
  static bool Accept(AudioDecoder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioDecoder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioDecoder>>
class AudioDecoderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioDecoderStub() = default;
  ~AudioDecoderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioDecoderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioDecoderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioDecoderClientStubDispatch {
 public:
  static bool Accept(AudioDecoderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioDecoderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioDecoderClient>>
class AudioDecoderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioDecoderClientStub() = default;
  ~AudioDecoderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioDecoderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioDecoderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AudioDecoderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioDecoderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AudioDecoderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  SupportedAudioDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupportedAudioDecoderConfig, T>::value>;
  using DataView = SupportedAudioDecoderConfigDataView;
  using Data_ = internal::SupportedAudioDecoderConfig_Data;

  template <typename... Args>
  static SupportedAudioDecoderConfigPtr New(Args&&... args) {
    return SupportedAudioDecoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupportedAudioDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<SupportedAudioDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupportedAudioDecoderConfig>::Convert(*this);
  }


  SupportedAudioDecoderConfig();

  SupportedAudioDecoderConfig(
      ::media::AudioCodec codec,
      ::media::AudioCodecProfile profile);


  ~SupportedAudioDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupportedAudioDecoderConfigPtr>
  SupportedAudioDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedAudioDecoderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupportedAudioDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupportedAudioDecoderConfig_UnserializedMessageContext<
            UserType, SupportedAudioDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupportedAudioDecoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupportedAudioDecoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupportedAudioDecoderConfig_UnserializedMessageContext<
            UserType, SupportedAudioDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupportedAudioDecoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::AudioCodec codec;
  
  ::media::AudioCodecProfile profile;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SupportedAudioDecoderConfigPtr SupportedAudioDecoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(profile)
  );
}

template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>*>
bool SupportedAudioDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  return true;
}

template <typename T, SupportedAudioDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.codec < rhs.codec)
    return true;
  if (rhs.codec < lhs.codec)
    return false;
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  return false;
}


}  // media::mojom

namespace mojo {


template <>
struct  StructTraits<::media::mojom::SupportedAudioDecoderConfig::DataView,
                                         ::media::mojom::SupportedAudioDecoderConfigPtr> {
  static bool IsNull(const ::media::mojom::SupportedAudioDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::mojom::SupportedAudioDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::mojom::SupportedAudioDecoderConfig::codec) codec(
      const ::media::mojom::SupportedAudioDecoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::mojom::SupportedAudioDecoderConfig::profile) profile(
      const ::media::mojom::SupportedAudioDecoderConfigPtr& input) {
    return input->profile;
  }

  static bool Read(::media::mojom::SupportedAudioDecoderConfig::DataView input, ::media::mojom::SupportedAudioDecoderConfigPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DECODER_MOJOM_H_