// gpu/ipc/common/device_perf_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_DEVICE_PERF_INFO_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_DEVICE_PERF_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/device_perf_info.mojom-shared-internal.h"



#include "base/component_export.h"




namespace gpu::mojom {
class DevicePerfInfoDataView;



}  // gpu::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::DevicePerfInfoDataView> {
  using Data = ::gpu::mojom::internal::DevicePerfInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class Direct3DFeatureLevel : int32_t {
  
  k1_0_Core = 0,
  
  k9_1 = 1,
  
  k9_2 = 2,
  
  k9_3 = 3,
  
  k10_0 = 4,
  
  k10_1 = 5,
  
  k11_0 = 6,
  
  k11_1 = 7,
  
  k12_0 = 8,
  
  k12_1 = 9,
  
  k12_2 = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, Direct3DFeatureLevel value);
inline bool IsKnownEnumValue(Direct3DFeatureLevel value) {
  return internal::Direct3DFeatureLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HasDiscreteGpu : int32_t {
  
  kUnknown = 0,
  
  kNo = 1,
  
  kYes = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, HasDiscreteGpu value);
inline bool IsKnownEnumValue(HasDiscreteGpu value) {
  return internal::HasDiscreteGpu_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DevicePerfInfoDataView {
 public:
  DevicePerfInfoDataView() = default;

  DevicePerfInfoDataView(
      internal::DevicePerfInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t total_physical_memory_mb() const {
    return data_->total_physical_memory_mb;
  }
  uint32_t total_disk_space_mb() const {
    return data_->total_disk_space_mb;
  }
  uint32_t hardware_concurrency() const {
    return data_->hardware_concurrency;
  }
 private:
  internal::DevicePerfInfo_Data* data_ = nullptr;
};


}  // gpu::mojom

namespace std {

template <>
struct hash<::gpu::mojom::Direct3DFeatureLevel>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::Direct3DFeatureLevel> {};

template <>
struct hash<::gpu::mojom::HasDiscreteGpu>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::HasDiscreteGpu> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::Direct3DFeatureLevel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::Direct3DFeatureLevel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::Direct3DFeatureLevel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::HasDiscreteGpu, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::HasDiscreteGpu, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::HasDiscreteGpu>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::DevicePerfInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::DevicePerfInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::DevicePerfInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->total_physical_memory_mb = Traits::total_physical_memory_mb(input);
    fragment->total_disk_space_mb = Traits::total_disk_space_mb(input);
    fragment->hardware_concurrency = Traits::hardware_concurrency(input);
  }

  static bool Deserialize(::gpu::mojom::internal::DevicePerfInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::DevicePerfInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {




}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::Direct3DFeatureLevel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::Direct3DFeatureLevel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::HasDiscreteGpu> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::HasDiscreteGpu value);
};

} // namespace perfetto

#endif  // GPU_IPC_COMMON_DEVICE_PERF_INFO_MOJOM_SHARED_H_