// extensions/common/mojom/url_pattern_set.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/url_pattern_set.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/url_pattern_set.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/url_pattern_set.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "extensions/common/mojom/url_pattern_set_mojom_traits.h"




namespace extensions::mojom {





class  URLPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLPattern, T>::value>;
  using DataView = URLPatternDataView;
  using Data_ = internal::URLPattern_Data;

  template <typename... Args>
  static URLPatternPtr New(Args&&... args) {
    return URLPatternPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLPatternPtr From(const U& u) {
    return mojo::TypeConverter<URLPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLPattern>::Convert(*this);
  }


  URLPattern();

  URLPattern(
      int32_t valid_schemes,
      const std::string& pattern);


  ~URLPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLPatternPtr>
  URLPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLPattern::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLPattern::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLPattern::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLPattern_UnserializedMessageContext<
            UserType, URLPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLPattern::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLPattern::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLPattern_UnserializedMessageContext<
            UserType, URLPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLPattern::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t valid_schemes;
  
  std::string pattern;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  URLPatternSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLPatternSet, T>::value>;
  using DataView = URLPatternSetDataView;
  using Data_ = internal::URLPatternSet_Data;

  template <typename... Args>
  static URLPatternSetPtr New(Args&&... args) {
    return URLPatternSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLPatternSetPtr From(const U& u) {
    return mojo::TypeConverter<URLPatternSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLPatternSet>::Convert(*this);
  }


  URLPatternSet();

  explicit URLPatternSet(
      std::vector<::URLPattern> patterns);


  ~URLPatternSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLPatternSetPtr>
  URLPatternSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLPatternSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URLPatternSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URLPatternSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLPatternSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLPatternSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLPatternSet_UnserializedMessageContext<
            UserType, URLPatternSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URLPatternSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URLPatternSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLPatternSet_UnserializedMessageContext<
            UserType, URLPatternSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLPatternSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::URLPattern> patterns;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLPatternSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLPatternSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLPatternSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLPatternSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
URLPatternPtr URLPattern::Clone() const {
  return New(
      mojo::Clone(valid_schemes),
      mojo::Clone(pattern)
  );
}

template <typename T, URLPattern::EnableIfSame<T>*>
bool URLPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->valid_schemes, other_struct.valid_schemes))
    return false;
  if (!mojo::Equals(this->pattern, other_struct.pattern))
    return false;
  return true;
}

template <typename T, URLPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.valid_schemes < rhs.valid_schemes)
    return true;
  if (rhs.valid_schemes < lhs.valid_schemes)
    return false;
  if (lhs.pattern < rhs.pattern)
    return true;
  if (rhs.pattern < lhs.pattern)
    return false;
  return false;
}
template <typename StructPtrType>
URLPatternSetPtr URLPatternSet::Clone() const {
  return New(
      mojo::Clone(patterns)
  );
}

template <typename T, URLPatternSet::EnableIfSame<T>*>
bool URLPatternSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->patterns, other_struct.patterns))
    return false;
  return true;
}

template <typename T, URLPatternSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.patterns < rhs.patterns)
    return true;
  if (rhs.patterns < lhs.patterns)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::URLPattern::DataView,
                                         ::extensions::mojom::URLPatternPtr> {
  static bool IsNull(const ::extensions::mojom::URLPatternPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::URLPatternPtr* output) { output->reset(); }

  static decltype(::extensions::mojom::URLPattern::valid_schemes) valid_schemes(
      const ::extensions::mojom::URLPatternPtr& input) {
    return input->valid_schemes;
  }

  static const decltype(::extensions::mojom::URLPattern::pattern)& pattern(
      const ::extensions::mojom::URLPatternPtr& input) {
    return input->pattern;
  }

  static bool Read(::extensions::mojom::URLPattern::DataView input, ::extensions::mojom::URLPatternPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::URLPatternSet::DataView,
                                         ::extensions::mojom::URLPatternSetPtr> {
  static bool IsNull(const ::extensions::mojom::URLPatternSetPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::URLPatternSetPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::URLPatternSet::patterns)& patterns(
      const ::extensions::mojom::URLPatternSetPtr& input) {
    return input->patterns;
  }

  static bool Read(::extensions::mojom::URLPatternSet::DataView input, ::extensions::mojom::URLPatternSetPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_H_