// extensions/common/mojom/frame.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/frame.mojom-shared-internal.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "extensions/common/mojom/code_injection.mojom-shared.h"
#include "extensions/common/mojom/context_type.mojom-shared.h"
#include "extensions/common/mojom/extra_response_data.mojom-shared.h"
#include "extensions/common/mojom/host_id.mojom-shared.h"
#include "extensions/common/mojom/injection_type.mojom-shared.h"
#include "extensions/common/mojom/match_origin_as_fallback.mojom-shared.h"
#include "extensions/common/mojom/message_port.mojom-shared.h"
#include "extensions/common/mojom/run_location.mojom-shared.h"
#include "extensions/common/mojom/stack_frame.mojom-shared.h"
#include "extensions/common/mojom/view_type.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace extensions::mojom {
class ExecuteCodeParamsDataView;

class RequestParamsDataView;



}  // extensions::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::ExecuteCodeParamsDataView> {
  using Data = ::extensions::mojom::internal::ExecuteCodeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::RequestParamsDataView> {
  using Data = ::extensions::mojom::internal::RequestParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {
// Interface base classes. They are used for type safety check.
class LocalFrameInterfaceBase {};

using LocalFramePtrDataView =
    mojo::InterfacePtrDataView<LocalFrameInterfaceBase>;
using LocalFrameRequestDataView =
    mojo::InterfaceRequestDataView<LocalFrameInterfaceBase>;
using LocalFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalFrameInterfaceBase>;
using LocalFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalFrameInterfaceBase>;
class LocalFrameHostInterfaceBase {};

using LocalFrameHostPtrDataView =
    mojo::InterfacePtrDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalFrameHostInterfaceBase>;


class ExecuteCodeParamsDataView {
 public:
  ExecuteCodeParamsDataView() = default;

  ExecuteCodeParamsDataView(
      internal::ExecuteCodeParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostIdDataView(
      ::extensions::mojom::HostIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostId(UserType* output) {
    
    auto* pointer = data_->host_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::HostIDDataView>(
        pointer, output, message_);
  }
  inline void GetInjectionDataView(
      ::extensions::mojom::CodeInjectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInjection(UserType* output) {
    
    auto* pointer = !data_->injection.is_null() ? &data_->injection : nullptr;
    return mojo::internal::Deserialize<::extensions::mojom::CodeInjectionDataView>(
        pointer, output, message_);
  }
  inline void GetWebviewSrcDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebviewSrc(UserType* output) {
    
    auto* pointer = data_->webview_src.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMatchOriginAsFallbackBehavior(UserType* output) const {
    auto data_value = data_->match_origin_as_fallback_behavior;
    return mojo::internal::Deserialize<::extensions::mojom::MatchOriginAsFallbackBehavior>(
        data_value, output);
  }
  ::extensions::mojom::MatchOriginAsFallbackBehavior match_origin_as_fallback_behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::MatchOriginAsFallbackBehavior>(data_->match_origin_as_fallback_behavior));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRunAt(UserType* output) const {
    auto data_value = data_->run_at;
    return mojo::internal::Deserialize<::extensions::mojom::RunLocation>(
        data_value, output);
  }
  ::extensions::mojom::RunLocation run_at() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::RunLocation>(data_->run_at));
  }
  bool is_web_view() const {
    return data_->is_web_view;
  }
 private:
  internal::ExecuteCodeParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequestParamsDataView {
 public:
  RequestParamsDataView() = default;

  RequestParamsDataView(
      internal::RequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetArgumentsDataView(
      ::mojo_base::mojom::ListValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArguments(UserType* output) {
    
    auto* pointer = data_->arguments.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ListValueDataView>(
        pointer, output, message_);
  }
  inline void GetExtensionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceUrl(UserType* output) {
    
    auto* pointer = data_->source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContextType(UserType* output) const {
    auto data_value = data_->context_type;
    return mojo::internal::Deserialize<::extensions::mojom::ContextType>(
        data_value, output);
  }
  ::extensions::mojom::ContextType context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::ContextType>(data_->context_type));
  }
  int32_t request_id() const {
    return data_->request_id;
  }
  bool has_callback() const {
    return data_->has_callback;
  }
  bool user_gesture() const {
    return data_->user_gesture;
  }
  int32_t worker_thread_id() const {
    return data_->worker_thread_id;
  }
  int64_t service_worker_version_id() const {
    return data_->service_worker_version_id;
  }
  inline void GetJsCallstackDataView(
      mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJsCallstack(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>, UserType>(),
    "Attempting to read the optional `js_callstack` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadJsCallstack` instead "
    "of `ReadJsCallstack if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->js_callstack.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::ExecuteCodeParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ExecuteCodeParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ExecuteCodeParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::host_id(input)) in_host_id = Traits::host_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_id)::BaseType> host_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::extensions::mojom::HostIDDataView>(
        in_host_id, host_id_fragment);
    fragment->host_id.Set(
        host_id_fragment.is_null() ? nullptr : host_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_id in ExecuteCodeParams struct");
    decltype(Traits::injection(input)) in_injection = Traits::injection(input);
    mojo::internal::MessageFragment<decltype(fragment->injection)>
        injection_fragment(fragment.message());
    injection_fragment.Claim(&fragment->injection);
    mojo::internal::Serialize<::extensions::mojom::CodeInjectionDataView>(
        in_injection, injection_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->injection.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null injection in ExecuteCodeParams struct");
    decltype(Traits::webview_src(input)) in_webview_src = Traits::webview_src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->webview_src)::BaseType> webview_src_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_webview_src, webview_src_fragment);
    fragment->webview_src.Set(
        webview_src_fragment.is_null() ? nullptr : webview_src_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->webview_src.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null webview_src in ExecuteCodeParams struct");
    mojo::internal::Serialize<::extensions::mojom::MatchOriginAsFallbackBehavior>(
        Traits::match_origin_as_fallback_behavior(input), &fragment->match_origin_as_fallback_behavior);
    mojo::internal::Serialize<::extensions::mojom::RunLocation>(
        Traits::run_at(input), &fragment->run_at);
    fragment->is_web_view = Traits::is_web_view(input);
  }

  static bool Deserialize(::extensions::mojom::internal::ExecuteCodeParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::ExecuteCodeParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::RequestParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::RequestParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::RequestParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in RequestParams struct");
    decltype(Traits::arguments(input)) in_arguments = Traits::arguments(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->arguments)::BaseType> arguments_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
        in_arguments, arguments_fragment);
    fragment->arguments.Set(
        arguments_fragment.is_null() ? nullptr : arguments_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->arguments.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null arguments in RequestParams struct");
    decltype(Traits::extension_id(input)) in_extension_id = Traits::extension_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extension_id)::BaseType> extension_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_extension_id, extension_id_fragment);
    fragment->extension_id.Set(
        extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->extension_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extension_id in RequestParams struct");
    decltype(Traits::source_url(input)) in_source_url = Traits::source_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_url)::BaseType> source_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_source_url, source_url_fragment);
    fragment->source_url.Set(
        source_url_fragment.is_null() ? nullptr : source_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->source_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_url in RequestParams struct");
    mojo::internal::Serialize<::extensions::mojom::ContextType>(
        Traits::context_type(input), &fragment->context_type);
    fragment->request_id = Traits::request_id(input);
    fragment->has_callback = Traits::has_callback(input);
    fragment->user_gesture = Traits::user_gesture(input);
    fragment->worker_thread_id = Traits::worker_thread_id(input);
    fragment->service_worker_version_id = Traits::service_worker_version_id(input);
    decltype(Traits::js_callstack(input)) in_js_callstack = Traits::js_callstack(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->js_callstack)::BaseType>
        js_callstack_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& js_callstack_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>>(
        in_js_callstack, js_callstack_fragment, &js_callstack_validate_params);
    fragment->js_callstack.Set(
        js_callstack_fragment.is_null() ? nullptr : js_callstack_fragment.data());
  }

  static bool Deserialize(::extensions::mojom::internal::RequestParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::RequestParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void ExecuteCodeParamsDataView::GetHostIdDataView(
    ::extensions::mojom::HostIDDataView* output) {
  auto pointer = data_->host_id.Get();
  *output = ::extensions::mojom::HostIDDataView(pointer, message_);
}
inline void ExecuteCodeParamsDataView::GetInjectionDataView(
    ::extensions::mojom::CodeInjectionDataView* output) {
  auto pointer = &data_->injection;
  *output = ::extensions::mojom::CodeInjectionDataView(pointer, message_);
}
inline void ExecuteCodeParamsDataView::GetWebviewSrcDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->webview_src.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void RequestParamsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RequestParamsDataView::GetArgumentsDataView(
    ::mojo_base::mojom::ListValueDataView* output) {
  auto pointer = data_->arguments.Get();
  *output = ::mojo_base::mojom::ListValueDataView(pointer, message_);
}
inline void RequestParamsDataView::GetExtensionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RequestParamsDataView::GetSourceUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->source_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RequestParamsDataView::GetJsCallstackDataView(
    mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>* output) {
  auto pointer = data_->js_callstack.Get();
  *output = mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>(pointer, message_);
}



}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_SHARED_H_