// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Tracing_h
#define content_protocol_Tracing_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/io.h"

namespace content {
namespace protocol {
namespace Tracing {
using MemoryDumpConfig = Object;
class TraceConfig;
using StreamFormat = String;
using StreamCompression = String;
using MemoryDumpLevelOfDetail = String;
using TracingBackend = String;

// ------------- Forward and enum declarations.

namespace StreamFormatEnum {
CONTENT_EXPORT extern const char Json[];
CONTENT_EXPORT extern const char Proto[];
} // namespace StreamFormatEnum

namespace StreamCompressionEnum {
CONTENT_EXPORT extern const char None[];
CONTENT_EXPORT extern const char Gzip[];
} // namespace StreamCompressionEnum

namespace MemoryDumpLevelOfDetailEnum {
CONTENT_EXPORT extern const char Background[];
CONTENT_EXPORT extern const char Light[];
CONTENT_EXPORT extern const char Detailed[];
} // namespace MemoryDumpLevelOfDetailEnum

namespace TracingBackendEnum {
CONTENT_EXPORT extern const char Auto[];
CONTENT_EXPORT extern const char Chrome[];
CONTENT_EXPORT extern const char System[];
} // namespace TracingBackendEnum

namespace Start {
namespace TransferModeEnum {
CONTENT_EXPORT extern const char* ReportEvents;
CONTENT_EXPORT extern const char* ReturnAsStream;
} // TransferModeEnum
} // Start

// ------------- Type and builder declarations.

class CONTENT_EXPORT TraceConfig : public ::crdtp::ProtocolObject<TraceConfig> {
public:
    ~TraceConfig() override { }

    struct CONTENT_EXPORT RecordModeEnum {
        static const char* RecordUntilFull;
        static const char* RecordContinuously;
        static const char* RecordAsMuchAsPossible;
        static const char* EchoToConsole;
    }; // RecordModeEnum

    bool HasRecordMode() { return !!m_recordMode; }
    String GetRecordMode(const String& defaultValue) const {
       return m_recordMode.value_or(defaultValue);
    }
    const std::optional<String>& GetRecordMode() const {
       return m_recordMode;
    }
    void SetRecordMode(const String& value) { m_recordMode = value; }

    bool HasTraceBufferSizeInKb() { return !!m_traceBufferSizeInKb; }
    double GetTraceBufferSizeInKb(double defaultValue) const {
       return m_traceBufferSizeInKb.value_or(defaultValue);
    }
    const std::optional<double>& GetTraceBufferSizeInKb() const {
       return m_traceBufferSizeInKb;
    }
    void SetTraceBufferSizeInKb(double value) { m_traceBufferSizeInKb = value; }

    bool HasEnableSampling() { return !!m_enableSampling; }
    bool GetEnableSampling(bool defaultValue) const {
       return m_enableSampling.value_or(defaultValue);
    }
    const std::optional<bool>& GetEnableSampling() const {
       return m_enableSampling;
    }
    void SetEnableSampling(bool value) { m_enableSampling = value; }

    bool HasEnableSystrace() { return !!m_enableSystrace; }
    bool GetEnableSystrace(bool defaultValue) const {
       return m_enableSystrace.value_or(defaultValue);
    }
    const std::optional<bool>& GetEnableSystrace() const {
       return m_enableSystrace;
    }
    void SetEnableSystrace(bool value) { m_enableSystrace = value; }

    bool HasEnableArgumentFilter() { return !!m_enableArgumentFilter; }
    bool GetEnableArgumentFilter(bool defaultValue) const {
       return m_enableArgumentFilter.value_or(defaultValue);
    }
    const std::optional<bool>& GetEnableArgumentFilter() const {
       return m_enableArgumentFilter;
    }
    void SetEnableArgumentFilter(bool value) { m_enableArgumentFilter = value; }

    bool HasIncludedCategories() { return !!m_includedCategories; }
    protocol::Array<String>* GetIncludedCategories(protocol::Array<String>* defaultValue) {
       return m_includedCategories ? m_includedCategories.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetIncludedCategories() const {
       return m_includedCategories;
    }
    void SetIncludedCategories(std::unique_ptr<protocol::Array<String>> value) { m_includedCategories = std::move(value); }

    bool HasExcludedCategories() { return !!m_excludedCategories; }
    protocol::Array<String>* GetExcludedCategories(protocol::Array<String>* defaultValue) {
       return m_excludedCategories ? m_excludedCategories.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetExcludedCategories() const {
       return m_excludedCategories;
    }
    void SetExcludedCategories(std::unique_ptr<protocol::Array<String>> value) { m_excludedCategories = std::move(value); }

    bool HasSyntheticDelays() { return !!m_syntheticDelays; }
    protocol::Array<String>* GetSyntheticDelays(protocol::Array<String>* defaultValue) {
       return m_syntheticDelays ? m_syntheticDelays.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<String>>& GetSyntheticDelays() const {
       return m_syntheticDelays;
    }
    void SetSyntheticDelays(std::unique_ptr<protocol::Array<String>> value) { m_syntheticDelays = std::move(value); }

    bool HasMemoryDumpConfig() { return !!m_memoryDumpConfig; }
    protocol::Tracing::MemoryDumpConfig* GetMemoryDumpConfig(protocol::Tracing::MemoryDumpConfig* defaultValue) {
       return m_memoryDumpConfig ? m_memoryDumpConfig.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Tracing::MemoryDumpConfig>& GetMemoryDumpConfig() const {
       return m_memoryDumpConfig;
    }
    void SetMemoryDumpConfig(std::unique_ptr<protocol::Tracing::MemoryDumpConfig> value) { m_memoryDumpConfig = std::move(value); }

    template<int STATE>
    class TraceConfigBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        TraceConfigBuilder<STATE>& SetRecordMode(const String& value)
        {
            m_result->SetRecordMode(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetTraceBufferSizeInKb(double value)
        {
            m_result->SetTraceBufferSizeInKb(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetEnableSampling(bool value)
        {
            m_result->SetEnableSampling(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetEnableSystrace(bool value)
        {
            m_result->SetEnableSystrace(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetEnableArgumentFilter(bool value)
        {
            m_result->SetEnableArgumentFilter(value);
            return *this;
        }

        TraceConfigBuilder<STATE>& SetIncludedCategories(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetIncludedCategories(std::move(value));
            return *this;
        }

        TraceConfigBuilder<STATE>& SetExcludedCategories(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetExcludedCategories(std::move(value));
            return *this;
        }

        TraceConfigBuilder<STATE>& SetSyntheticDelays(std::unique_ptr<protocol::Array<String>> value)
        {
            m_result->SetSyntheticDelays(std::move(value));
            return *this;
        }

        TraceConfigBuilder<STATE>& SetMemoryDumpConfig(std::unique_ptr<protocol::Tracing::MemoryDumpConfig> value)
        {
            m_result->SetMemoryDumpConfig(std::move(value));
            return *this;
        }

        std::unique_ptr<TraceConfig> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TraceConfig;
        TraceConfigBuilder() : m_result(new TraceConfig()) { }

        template<int STEP> TraceConfigBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TraceConfigBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Tracing::TraceConfig> m_result;
    };

    static TraceConfigBuilder<0> Create()
    {
        return TraceConfigBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TraceConfig()
    {
    }

    std::optional<String> m_recordMode;
    std::optional<double> m_traceBufferSizeInKb;
    std::optional<bool> m_enableSampling;
    std::optional<bool> m_enableSystrace;
    std::optional<bool> m_enableArgumentFilter;
    std::unique_ptr<protocol::Array<String>> m_includedCategories;
    std::unique_ptr<protocol::Array<String>> m_excludedCategories;
    std::unique_ptr<protocol::Array<String>> m_syntheticDelays;
    std::unique_ptr<protocol::Tracing::MemoryDumpConfig> m_memoryDumpConfig;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse End() = 0;
    class CONTENT_EXPORT GetCategoriesCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<String>> categories) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetCategoriesCallback() { }
    };
    virtual void GetCategories(std::unique_ptr<GetCategoriesCallback> callback) = 0;
    virtual DispatchResponse RecordClockSyncMarker(const String& in_syncId) = 0;
    class CONTENT_EXPORT RequestMemoryDumpCallback {
    public:
        virtual void sendSuccess(const String& dumpGuid, bool success) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~RequestMemoryDumpCallback() { }
    };
    virtual void RequestMemoryDump(std::optional<bool> in_deterministic, std::optional<String> in_levelOfDetail, std::unique_ptr<RequestMemoryDumpCallback> callback) = 0;
    class CONTENT_EXPORT StartCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~StartCallback() { }
    };
    virtual void Start(std::optional<String> in_categories, std::optional<String> in_options, std::optional<double> in_bufferUsageReportingInterval, std::optional<String> in_transferMode, std::optional<String> in_streamFormat, std::optional<String> in_streamCompression, std::unique_ptr<protocol::Tracing::TraceConfig> in_traceConfig, std::optional<Binary> in_perfettoConfig, std::optional<String> in_tracingBackend, std::unique_ptr<StartCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void BufferUsage(std::optional<double> percentFull = {}, std::optional<double> eventCount = {}, std::optional<double> value = {});
    void DataCollected(std::unique_ptr<protocol::Array<protocol::DictionaryValue>> value);
    void TracingComplete(bool dataLossOccurred, std::optional<String> stream = {}, std::optional<String> traceFormat = {}, std::optional<String> streamCompression = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Tracing
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Tracing_h)
