// components/services/unzip/public/mojom/unzipper.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/unzip/public/mojom/unzipper.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-params-data.h"
namespace unzip {
namespace mojom {

namespace internal {


// static
bool UnzipOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnzipOptions_Data* object =
      static_cast<const UnzipOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encoding, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& encoding_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->encoding, validation_context,
                                         &encoding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& password_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->password, validation_context,
                                         &password_validate_params)) {
    return false;
  }

  return true;
}

UnzipOptions_Data::UnzipOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Info_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Info_Data* object =
      static_cast<const Info_Data*>(data);

  return true;
}

Info_Data::Info_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnzipFilter_ShouldUnzipFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnzipFilter_ShouldUnzipFile_Params_Data* object =
      static_cast<const UnzipFilter_ShouldUnzipFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  return true;
}

UnzipFilter_ShouldUnzipFile_Params_Data::UnzipFilter_ShouldUnzipFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnzipFilter_ShouldUnzipFile_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnzipFilter_ShouldUnzipFile_ResponseParams_Data* object =
      static_cast<const UnzipFilter_ShouldUnzipFile_ResponseParams_Data*>(data);

  return true;
}

UnzipFilter_ShouldUnzipFile_ResponseParams_Data::UnzipFilter_ShouldUnzipFile_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UnzipListener_OnProgress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UnzipListener_OnProgress_Params_Data* object =
      static_cast<const UnzipListener_OnProgress_Params_Data*>(data);

  return true;
}

UnzipListener_OnProgress_Params_Data::UnzipListener_OnProgress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Unzipper_Unzip_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Unzipper_Unzip_Params_Data* object =
      static_cast<const Unzipper_Unzip_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->zip_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->zip_file, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->output_dir, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->output_dir,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->filter,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Unzipper_Unzip_Params_Data::Unzipper_Unzip_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Unzipper_Unzip_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Unzipper_Unzip_ResponseParams_Data* object =
      static_cast<const Unzipper_Unzip_ResponseParams_Data*>(data);

  return true;
}

Unzipper_Unzip_ResponseParams_Data::Unzipper_Unzip_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Unzipper_DetectEncoding_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Unzipper_DetectEncoding_Params_Data* object =
      static_cast<const Unzipper_DetectEncoding_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->zip_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->zip_file, validation_context))
    return false;

  return true;
}

Unzipper_DetectEncoding_Params_Data::Unzipper_DetectEncoding_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Unzipper_DetectEncoding_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Unzipper_DetectEncoding_ResponseParams_Data* object =
      static_cast<const Unzipper_DetectEncoding_ResponseParams_Data*>(data);

  return true;
}

Unzipper_DetectEncoding_ResponseParams_Data::Unzipper_DetectEncoding_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Unzipper_GetExtractedInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Unzipper_GetExtractedInfo_Params_Data* object =
      static_cast<const Unzipper_GetExtractedInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->zip_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->zip_file, validation_context))
    return false;

  return true;
}

Unzipper_GetExtractedInfo_Params_Data::Unzipper_GetExtractedInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Unzipper_GetExtractedInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Unzipper_GetExtractedInfo_ResponseParams_Data* object =
      static_cast<const Unzipper_GetExtractedInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

Unzipper_GetExtractedInfo_ResponseParams_Data::Unzipper_GetExtractedInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace unzip