// components/services/storage/public/mojom/partition.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/partition.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/partition.mojom-params-data.h"
#include "components/services/storage/public/mojom/partition.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/partition.mojom-import-headers.h"
#include "components/services/storage/public/mojom/partition.mojom-test-utils.h"


namespace storage::mojom {
const char Partition::Name_[] = "storage.mojom.Partition";

Partition::IPCStableHashFunction Partition::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Partition>(message.name())) {
    case messages::Partition::kBindOriginContext: {
      return &Partition::BindOriginContext_Sym::IPCStableHash;
    }
    case messages::Partition::kBindSessionStorageControl: {
      return &Partition::BindSessionStorageControl_Sym::IPCStableHash;
    }
    case messages::Partition::kBindLocalStorageControl: {
      return &Partition::BindLocalStorageControl_Sym::IPCStableHash;
    }
    case messages::Partition::kBindServiceWorkerStorageControl: {
      return &Partition::BindServiceWorkerStorageControl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Partition::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Partition>(message.name())) {
      case messages::Partition::kBindOriginContext:
            return "Receive storage::mojom::Partition::BindOriginContext";
      case messages::Partition::kBindSessionStorageControl:
            return "Receive storage::mojom::Partition::BindSessionStorageControl";
      case messages::Partition::kBindLocalStorageControl:
            return "Receive storage::mojom::Partition::BindLocalStorageControl";
      case messages::Partition::kBindServiceWorkerStorageControl:
            return "Receive storage::mojom::Partition::BindServiceWorkerStorageControl";
    }
  } else {
    switch (static_cast<messages::Partition>(message.name())) {
      case messages::Partition::kBindOriginContext:
            return "Receive reply storage::mojom::Partition::BindOriginContext";
      case messages::Partition::kBindSessionStorageControl:
            return "Receive reply storage::mojom::Partition::BindSessionStorageControl";
      case messages::Partition::kBindLocalStorageControl:
            return "Receive reply storage::mojom::Partition::BindLocalStorageControl";
      case messages::Partition::kBindServiceWorkerStorageControl:
            return "Receive reply storage::mojom::Partition::BindServiceWorkerStorageControl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Partition::BindOriginContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Partition::BindOriginContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Partition::BindSessionStorageControl_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Partition::BindSessionStorageControl");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Partition::BindLocalStorageControl_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Partition::BindLocalStorageControl");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Partition::BindServiceWorkerStorageControl_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Partition::BindServiceWorkerStorageControl");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PartitionProxy::PartitionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PartitionProxy::BindOriginContext(
    const ::url::Origin& in_origin, ::mojo::PendingReceiver<::storage::mojom::OriginContext> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Partition::BindOriginContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::storage::mojom::OriginContext>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Partition::kBindOriginContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Partition_BindOriginContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, origin_fragment);
  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in Partition.BindOriginContext request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::OriginContextInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Partition.BindOriginContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Partition::Name_);
  message.set_method_name("BindOriginContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PartitionProxy::BindSessionStorageControl(
    ::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Partition::BindSessionStorageControl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::storage::mojom::SessionStorageControl>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Partition::kBindSessionStorageControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Partition_BindSessionStorageControl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::SessionStorageControlInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Partition.BindSessionStorageControl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Partition::Name_);
  message.set_method_name("BindSessionStorageControl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PartitionProxy::BindLocalStorageControl(
    ::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Partition::BindLocalStorageControl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::storage::mojom::LocalStorageControl>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Partition::kBindLocalStorageControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Partition_BindLocalStorageControl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::LocalStorageControlInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Partition.BindLocalStorageControl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Partition::Name_);
  message.set_method_name("BindLocalStorageControl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PartitionProxy::BindServiceWorkerStorageControl(
    ::mojo::PendingReceiver<::storage::mojom::ServiceWorkerStorageControl> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Partition::BindServiceWorkerStorageControl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::storage::mojom::ServiceWorkerStorageControl>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Partition::kBindServiceWorkerStorageControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Partition_BindServiceWorkerStorageControl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerStorageControlInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Partition.BindServiceWorkerStorageControl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Partition::Name_);
  message.set_method_name("BindServiceWorkerStorageControl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PartitionStubDispatch::Accept(
    Partition* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Partition>(message->header()->name)) {
    case messages::Partition::kBindOriginContext: {
      DCHECK(message->is_serialized());
      internal::Partition_BindOriginContext_Params_Data* params =
          reinterpret_cast<internal::Partition_BindOriginContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Partition.0
      bool success = true;
      ::url::Origin p_origin{};
      ::mojo::PendingReceiver<::storage::mojom::OriginContext> p_receiver{};
      Partition_BindOriginContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Partition::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindOriginContext(        
        std::move(p_origin), 
        std::move(p_receiver));
      return true;
    }
    case messages::Partition::kBindSessionStorageControl: {
      DCHECK(message->is_serialized());
      internal::Partition_BindSessionStorageControl_Params_Data* params =
          reinterpret_cast<internal::Partition_BindSessionStorageControl_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Partition.1
      bool success = true;
      ::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> p_receiver{};
      Partition_BindSessionStorageControl_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Partition::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSessionStorageControl(        
        std::move(p_receiver));
      return true;
    }
    case messages::Partition::kBindLocalStorageControl: {
      DCHECK(message->is_serialized());
      internal::Partition_BindLocalStorageControl_Params_Data* params =
          reinterpret_cast<internal::Partition_BindLocalStorageControl_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Partition.2
      bool success = true;
      ::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> p_receiver{};
      Partition_BindLocalStorageControl_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Partition::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindLocalStorageControl(        
        std::move(p_receiver));
      return true;
    }
    case messages::Partition::kBindServiceWorkerStorageControl: {
      DCHECK(message->is_serialized());
      internal::Partition_BindServiceWorkerStorageControl_Params_Data* params =
          reinterpret_cast<internal::Partition_BindServiceWorkerStorageControl_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Partition.3
      bool success = true;
      ::mojo::PendingReceiver<::storage::mojom::ServiceWorkerStorageControl> p_receiver{};
      Partition_BindServiceWorkerStorageControl_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Partition::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindServiceWorkerStorageControl(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool PartitionStubDispatch::AcceptWithResponder(
    Partition* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Partition>(message->header()->name)) {
    case messages::Partition::kBindOriginContext: {
      break;
    }
    case messages::Partition::kBindSessionStorageControl: {
      break;
    }
    case messages::Partition::kBindLocalStorageControl: {
      break;
    }
    case messages::Partition::kBindServiceWorkerStorageControl: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPartitionValidationInfo[] = {
    {base::to_underlying(messages::Partition::kBindOriginContext),
     { &internal::Partition_BindOriginContext_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Partition::kBindSessionStorageControl),
     { &internal::Partition_BindSessionStorageControl_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Partition::kBindLocalStorageControl),
     { &internal::Partition_BindLocalStorageControl_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Partition::kBindServiceWorkerStorageControl),
     { &internal::Partition_BindServiceWorkerStorageControl_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PartitionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::Partition::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPartitionValidationInfo);
}



}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void PartitionInterceptorForTesting::BindOriginContext(const ::url::Origin& origin, ::mojo::PendingReceiver<::storage::mojom::OriginContext> receiver) {
  GetForwardingInterface()->BindOriginContext(
    std::move(origin)
    , 
    std::move(receiver)
    );
}
void PartitionInterceptorForTesting::BindSessionStorageControl(::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> receiver) {
  GetForwardingInterface()->BindSessionStorageControl(
    std::move(receiver)
    );
}
void PartitionInterceptorForTesting::BindLocalStorageControl(::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> receiver) {
  GetForwardingInterface()->BindLocalStorageControl(
    std::move(receiver)
    );
}
void PartitionInterceptorForTesting::BindServiceWorkerStorageControl(::mojo::PendingReceiver<::storage::mojom::ServiceWorkerStorageControl> receiver) {
  GetForwardingInterface()->BindServiceWorkerStorageControl(
    std::move(receiver)
    );
}
PartitionAsyncWaiter::PartitionAsyncWaiter(
    Partition* proxy) : proxy_(proxy) {}

PartitionAsyncWaiter::~PartitionAsyncWaiter() = default;






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif