// components/paint_preview/common/mojom/paint_preview_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/paint_preview/common/mojom/paint_preview_types.mojom-params-data.h"
namespace paint_preview {
namespace mojom {

NOINLINE static const char* RecordingPersistenceToStringHelper(RecordingPersistence value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RecordingPersistence::kFileSystem:
      return "kFileSystem";
    case RecordingPersistence::kMemoryBuffer:
      return "kMemoryBuffer";
    default:
      return nullptr;
  }
}

std::string RecordingPersistenceToString(RecordingPersistence value) {
  const char *str = RecordingPersistenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RecordingPersistence value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RecordingPersistence value) {
  return os << RecordingPersistenceToString(value);
}

namespace internal {
// static
bool SerializedRecording_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SerializedRecording_Data* object = static_cast<const SerializedRecording_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SerializedRecording_Tag::kFile: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_file, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_file, validation_context))
        return false;
      return true;
    }
    case SerializedRecording_Tag::kBuffer: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_buffer, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_buffer,
                                                   validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SerializedRecording");
      return false;
    }
  }
}

}  // namespace internal
}  // namespace mojom
}  // namespace paint_preview

namespace perfetto {

// static
void TraceFormatTraits<::paint_preview::mojom::RecordingPersistence>::WriteIntoTrace(
   perfetto::TracedValue context, ::paint_preview::mojom::RecordingPersistence value) {
  return std::move(context).WriteString(::paint_preview::mojom::RecordingPersistenceToString(value));
}

} // namespace perfetto