// components/digital_goods/mojom/digital_goods.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/digital_goods/mojom/digital_goods.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/digital_goods/mojom/digital_goods.mojom-params-data.h"
namespace payments {
namespace mojom {

NOINLINE static const char* BillingResponseCodeToStringHelper(BillingResponseCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BillingResponseCode::kOk:
      return "kOk";
    case BillingResponseCode::kError:
      return "kError";
    case BillingResponseCode::kItemAlreadyOwned:
      return "kItemAlreadyOwned";
    case BillingResponseCode::kItemNotOwned:
      return "kItemNotOwned";
    case BillingResponseCode::kItemUnavailable:
      return "kItemUnavailable";
    case BillingResponseCode::kClientAppUnavailable:
      return "kClientAppUnavailable";
    case BillingResponseCode::kClientAppError:
      return "kClientAppError";
    default:
      return nullptr;
  }
}

std::string BillingResponseCodeToString(BillingResponseCode value) {
  const char *str = BillingResponseCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BillingResponseCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BillingResponseCode value) {
  return os << BillingResponseCodeToString(value);
}

NOINLINE static const char* ItemTypeToStringHelper(ItemType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ItemType::kUnknown:
      return "kUnknown";
    case ItemType::kProduct:
      return "kProduct";
    case ItemType::kSubscription:
      return "kSubscription";
    default:
      return nullptr;
  }
}

std::string ItemTypeToString(ItemType value) {
  const char *str = ItemTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ItemType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ItemType value) {
  return os << ItemTypeToString(value);
}

NOINLINE static const char* CreateDigitalGoodsResponseCodeToStringHelper(CreateDigitalGoodsResponseCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateDigitalGoodsResponseCode::kOk:
      return "kOk";
    case CreateDigitalGoodsResponseCode::kError:
      return "kError";
    case CreateDigitalGoodsResponseCode::kUnsupportedPaymentMethod:
      return "kUnsupportedPaymentMethod";
    case CreateDigitalGoodsResponseCode::kUnsupportedContext:
      return "kUnsupportedContext";
    default:
      return nullptr;
  }
}

std::string CreateDigitalGoodsResponseCodeToString(CreateDigitalGoodsResponseCode value) {
  const char *str = CreateDigitalGoodsResponseCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateDigitalGoodsResponseCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateDigitalGoodsResponseCode value) {
  return os << CreateDigitalGoodsResponseCodeToString(value);
}

namespace internal {


// static
bool ItemDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 72 },
    { 1, 88 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ItemDetails_Data* object =
      static_cast<const ItemDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& item_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->item_id, validation_context,
                                         &item_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->price, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->price, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& subscription_period_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subscription_period, validation_context,
                                         &subscription_period_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& free_trial_period_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->free_trial_period, validation_context,
                                         &free_trial_period_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->introductory_price, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& introductory_price_period_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->introductory_price_period, validation_context,
                                         &introductory_price_period_validate_params)) {
    return false;
  }
  if (object->header_.version < 1)
    return true;


  if (!::payments::mojom::internal::ItemType_Data
        ::Validate(object->type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& icon_urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icon_urls, validation_context,
                                         &icon_urls_validate_params)) {
    return false;
  }

  return true;
}

ItemDetails_Data::ItemDetails_Data()
    : header_({sizeof(*this), 1}) {}


// static
bool PurchaseReference_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PurchaseReference_Data* object =
      static_cast<const PurchaseReference_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->item_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& item_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->item_id, validation_context,
                                         &item_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->purchase_token, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& purchase_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->purchase_token, validation_context,
                                         &purchase_token_validate_params)) {
    return false;
  }

  return true;
}

PurchaseReference_Data::PurchaseReference_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace payments

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::BillingResponseCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::BillingResponseCode value) {
  return std::move(context).WriteString(::payments::mojom::BillingResponseCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::ItemType>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::ItemType value) {
  return std::move(context).WriteString(::payments::mojom::ItemTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::CreateDigitalGoodsResponseCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::CreateDigitalGoodsResponseCode value) {
  return std::move(context).WriteString(::payments::mojom::CreateDigitalGoodsResponseCodeToString(value));
}

} // namespace perfetto