// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class DirectSocketOptionsDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DirectSocketOptionsDataView> {
  using Data = ::blink::mojom::internal::DirectSocketOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class DirectSocketsServiceInterfaceBase {};

using DirectSocketsServicePtrDataView =
    mojo::InterfacePtrDataView<DirectSocketsServiceInterfaceBase>;
using DirectSocketsServiceRequestDataView =
    mojo::InterfaceRequestDataView<DirectSocketsServiceInterfaceBase>;
using DirectSocketsServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DirectSocketsServiceInterfaceBase>;
using DirectSocketsServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DirectSocketsServiceInterfaceBase>;


class DirectSocketOptionsDataView {
 public:
  DirectSocketOptionsDataView() {}

  DirectSocketOptionsDataView(
      internal::DirectSocketOptions_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetLocalHostnameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLocalHostname(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `local_hostname` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalHostname` instead "
    "of `ReadLocalHostname if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_hostname.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  uint16_t local_port() const {
    return data_->local_port;
  }
  inline void GetRemoteHostnameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRemoteHostname(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `remote_hostname` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemoteHostname` instead "
    "of `ReadRemoteHostname if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->remote_hostname.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  uint16_t remote_port() const {
    return data_->remote_port;
  }
  int32_t send_buffer_size() const {
    return data_->send_buffer_size;
  }
  int32_t receive_buffer_size() const {
    return data_->receive_buffer_size;
  }
  bool keep_alive() const {
    return data_->keep_alive;
  }
  bool no_delay() const {
    return data_->no_delay;
  }
 private:
  internal::DirectSocketOptions_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DirectSocketOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DirectSocketOptionsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DirectSocketOptions_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::local_hostname(input)) in_local_hostname = Traits::local_hostname(input);
    typename decltype((*output)->local_hostname)::BaseType::BufferWriter
        local_hostname_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_local_hostname, buffer, &local_hostname_writer, context);
    (*output)->local_hostname.Set(
        local_hostname_writer.is_null() ? nullptr : local_hostname_writer.data());
    (*output)->local_port = Traits::local_port(input);
    decltype(Traits::remote_hostname(input)) in_remote_hostname = Traits::remote_hostname(input);
    typename decltype((*output)->remote_hostname)::BaseType::BufferWriter
        remote_hostname_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_remote_hostname, buffer, &remote_hostname_writer, context);
    (*output)->remote_hostname.Set(
        remote_hostname_writer.is_null() ? nullptr : remote_hostname_writer.data());
    (*output)->remote_port = Traits::remote_port(input);
    (*output)->send_buffer_size = Traits::send_buffer_size(input);
    (*output)->receive_buffer_size = Traits::receive_buffer_size(input);
    (*output)->keep_alive = Traits::keep_alive(input);
    (*output)->no_delay = Traits::no_delay(input);
  }

  static bool Deserialize(::blink::mojom::internal::DirectSocketOptions_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DirectSocketOptionsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void DirectSocketOptionsDataView::GetLocalHostnameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->local_hostname.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void DirectSocketOptionsDataView::GetRemoteHostnameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->remote_hostname.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_SHARED_H_