// ui/ozone/public/mojom/gesture_properties_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-params-data.h"
namespace ui {
namespace ozone {
namespace mojom {

std::ostream& operator<<(std::ostream& os, SetGesturePropErrorCode value) {
  switch(value) {
    case SetGesturePropErrorCode::SUCCESS:
      return os << "SetGesturePropErrorCode::SUCCESS";
    case SetGesturePropErrorCode::UNKNOWN_ERROR:
      return os << "SetGesturePropErrorCode::UNKNOWN_ERROR";
    case SetGesturePropErrorCode::NOT_FOUND:
      return os << "SetGesturePropErrorCode::NOT_FOUND";
    case SetGesturePropErrorCode::READ_ONLY:
      return os << "SetGesturePropErrorCode::READ_ONLY";
    case SetGesturePropErrorCode::TYPE_MISMATCH:
      return os << "SetGesturePropErrorCode::TYPE_MISMATCH";
    case SetGesturePropErrorCode::SIZE_MISMATCH:
      return os << "SetGesturePropErrorCode::SIZE_MISMATCH";
    default:
      return os << "Unknown SetGesturePropErrorCode value: " << static_cast<int32_t>(value);
  }
}

namespace internal {
// static
bool GesturePropValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GesturePropValue_Data* object = static_cast<const GesturePropValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GesturePropValue_Tag::INTS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_ints, 1, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams ints_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_ints, validation_context,
                                             &ints_validate_params)) {
        return false;
      }
      return true;
    }
    case GesturePropValue_Tag::SHORTS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shorts, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams shorts_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_shorts, validation_context,
                                             &shorts_validate_params)) {
        return false;
      }
      return true;
    }
    case GesturePropValue_Tag::BOOLS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bools, 3, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams bools_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_bools, validation_context,
                                             &bools_validate_params)) {
        return false;
      }
      return true;
    }
    case GesturePropValue_Tag::STR: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_str, 4, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams str_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_str, validation_context,
                                             &str_validate_params)) {
        return false;
      }
      return true;
    }
    case GesturePropValue_Tag::REALS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_reals, 5, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams reals_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_reals, validation_context,
                                             &reals_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GesturePropValue");
      return false;
    }
  }
}


// static
bool GesturePropertiesService_ListDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_ListDevices_Params_Data* object = static_cast<const GesturePropertiesService_ListDevices_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

GesturePropertiesService_ListDevices_Params_Data::GesturePropertiesService_ListDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_ListDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_ListDevices_ResponseParams_Data* object = static_cast<const GesturePropertiesService_ListDevices_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams result_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

GesturePropertiesService_ListDevices_ResponseParams_Data::GesturePropertiesService_ListDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_ListProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_ListProperties_Params_Data* object = static_cast<const GesturePropertiesService_ListProperties_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

GesturePropertiesService_ListProperties_Params_Data::GesturePropertiesService_ListProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_ListProperties_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_ListProperties_ResponseParams_Data* object = static_cast<const GesturePropertiesService_ListProperties_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->properties, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams properties_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->properties, validation_context,
                                         &properties_validate_params)) {
    return false;
  }

  return true;
}

GesturePropertiesService_ListProperties_ResponseParams_Data::GesturePropertiesService_ListProperties_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_GetProperty_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_GetProperty_Params_Data* object = static_cast<const GesturePropertiesService_GetProperty_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

GesturePropertiesService_GetProperty_Params_Data::GesturePropertiesService_GetProperty_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_GetProperty_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_GetProperty_ResponseParams_Data* object = static_cast<const GesturePropertiesService_GetProperty_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  return true;
}

GesturePropertiesService_GetProperty_ResponseParams_Data::GesturePropertiesService_GetProperty_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_SetProperty_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_SetProperty_Params_Data* object = static_cast<const GesturePropertiesService_SetProperty_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  return true;
}

GesturePropertiesService_SetProperty_Params_Data::GesturePropertiesService_SetProperty_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePropertiesService_SetProperty_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const GesturePropertiesService_SetProperty_ResponseParams_Data* object = static_cast<const GesturePropertiesService_SetProperty_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::ui::ozone::mojom::internal::SetGesturePropErrorCode_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

GesturePropertiesService_SetProperty_ResponseParams_Data::GesturePropertiesService_SetProperty_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ozone
}  // namespace ui