// ui/gfx/mojom/native_handle_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace gfx {
namespace mojom {
class NativePixmapPlaneDataView;

class NativePixmapHandleDataView;

class GpuMemoryBufferPlatformHandleDataView;


}  // namespace mojom
}  // namespace gfx

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::NativePixmapPlaneDataView> {
  using Data = ::gfx::mojom::internal::NativePixmapPlane_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::NativePixmapHandleDataView> {
  using Data = ::gfx::mojom::internal::NativePixmapHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView> {
  using Data = ::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gfx {
namespace mojom {


class NativePixmapPlaneDataView {
 public:
  NativePixmapPlaneDataView() {}

  NativePixmapPlaneDataView(
      internal::NativePixmapPlane_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t stride() const {
    return data_->stride;
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t size() const {
    return data_->size;
  }
  mojo::PlatformHandle TakeBufferHandle() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->buffer_handle, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NativePixmapPlane_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NativePixmapHandleDataView {
 public:
  NativePixmapHandleDataView() {}

  NativePixmapHandleDataView(
      internal::NativePixmapHandle_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPlanesDataView(
      mojo::ArrayDataView<NativePixmapPlaneDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPlanes(UserType* output) {
    
    auto* pointer = data_->planes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::NativePixmapPlaneDataView>>(
        pointer, output, context_);
  }
  uint64_t modifier() const {
    return data_->modifier;
  }
 private:
  internal::NativePixmapHandle_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuMemoryBufferPlatformHandleDataView {
 public:
  using Tag = internal::GpuMemoryBufferPlatformHandle_Data::GpuMemoryBufferPlatformHandle_Tag;

  GpuMemoryBufferPlatformHandleDataView() {}

  GpuMemoryBufferPlatformHandleDataView(
      internal::GpuMemoryBufferPlatformHandle_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_shared_memory_handle() const { return data_->tag == Tag::SHARED_MEMORY_HANDLE; }
  inline void GetSharedMemoryHandleDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSharedMemoryHandle(UserType* output) {
    
    DCHECK(is_shared_memory_handle());
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        data_->data.f_shared_memory_handle.Get(), output, context_);
  }
  bool is_native_pixmap_handle() const { return data_->tag == Tag::NATIVE_PIXMAP_HANDLE; }
  inline void GetNativePixmapHandleDataView(
      NativePixmapHandleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNativePixmapHandle(UserType* output) {
    
    DCHECK(is_native_pixmap_handle());
    return mojo::internal::Deserialize<::gfx::mojom::NativePixmapHandleDataView>(
        data_->data.f_native_pixmap_handle.Get(), output, context_);
  }

 private:
  internal::GpuMemoryBufferPlatformHandle_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gfx

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::NativePixmapPlaneDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::NativePixmapPlaneDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::NativePixmapPlane_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->stride = Traits::stride(input);
    (*output)->offset = Traits::offset(input);
    (*output)->size = Traits::size(input);
    decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);
    mojo::internal::Serialize<mojo::PlatformHandle>(
        in_buffer_handle, &(*output)->buffer_handle, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->buffer_handle),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid buffer_handle in NativePixmapPlane struct");
  }

  static bool Deserialize(::gfx::mojom::internal::NativePixmapPlane_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::NativePixmapPlaneDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::NativePixmapHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::NativePixmapHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::NativePixmapHandle_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::planes(input)) in_planes = Traits::planes(input);
    typename decltype((*output)->planes)::BaseType::BufferWriter
        planes_writer;
    const mojo::internal::ContainerValidateParams planes_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::NativePixmapPlaneDataView>>(
        in_planes, buffer, &planes_writer, &planes_validate_params,
        context);
    (*output)->planes.Set(
        planes_writer.is_null() ? nullptr : planes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->planes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null planes in NativePixmapHandle struct");
    (*output)->modifier = Traits::modifier(input);
  }

  static bool Deserialize(::gfx::mojom::internal::NativePixmapHandle_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::NativePixmapHandleDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView::Tag::SHARED_MEMORY_HANDLE: {
        decltype(Traits::shared_memory_handle(input))
            in_shared_memory_handle = Traits::shared_memory_handle(input);
        typename decltype(result->data.f_shared_memory_handle)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
            in_shared_memory_handle, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null shared_memory_handle in GpuMemoryBufferPlatformHandle union");
        result->data.f_shared_memory_handle.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView::Tag::NATIVE_PIXMAP_HANDLE: {
        decltype(Traits::native_pixmap_handle(input))
            in_native_pixmap_handle = Traits::native_pixmap_handle(input);
        typename decltype(result->data.f_native_pixmap_handle)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::gfx::mojom::NativePixmapHandleDataView>(
            in_native_pixmap_handle, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null native_pixmap_handle in GpuMemoryBufferPlatformHandle union");
        result->data.f_native_pixmap_handle.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx {
namespace mojom {



inline void NativePixmapHandleDataView::GetPlanesDataView(
    mojo::ArrayDataView<NativePixmapPlaneDataView>* output) {
  auto pointer = data_->planes.Get();
  *output = mojo::ArrayDataView<NativePixmapPlaneDataView>(pointer, context_);
}


inline void GpuMemoryBufferPlatformHandleDataView::GetSharedMemoryHandleDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) {
  DCHECK(is_shared_memory_handle());
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(data_->data.f_shared_memory_handle.Get(), context_);
}
inline void GpuMemoryBufferPlatformHandleDataView::GetNativePixmapHandleDataView(
    NativePixmapHandleDataView* output) {
  DCHECK(is_native_pixmap_handle());
  *output = NativePixmapHandleDataView(data_->data.f_native_pixmap_handle.Get(), context_);
}


}  // namespace mojom
}  // namespace gfx

#endif  // UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_SHARED_H_