// services/device/public/mojom/usb_enumeration_options.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/device/public/mojom/usb_enumeration_options.mojom-shared.h"
#include "services/device/public/mojom/usb_enumeration_options.mojom-blink-forward.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace device {
namespace mojom {
namespace blink {









class BLINK_PLATFORM_EXPORT UsbDeviceFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbDeviceFilter, T>::value>;
  using DataView = UsbDeviceFilterDataView;
  using Data_ = internal::UsbDeviceFilter_Data;

  template <typename... Args>
  static UsbDeviceFilterPtr New(Args&&... args) {
    return UsbDeviceFilterPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbDeviceFilterPtr From(const U& u) {
    return mojo::TypeConverter<UsbDeviceFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbDeviceFilter>::Convert(*this);
  }


  UsbDeviceFilter();

  UsbDeviceFilter(
      bool has_vendor_id,
      uint16_t vendor_id,
      bool has_product_id,
      uint16_t product_id,
      bool has_class_code,
      uint8_t class_code,
      bool has_subclass_code,
      uint8_t subclass_code,
      bool has_protocol_code,
      uint8_t protocol_code,
      const ::WTF::String& serial_number);

  ~UsbDeviceFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbDeviceFilterPtr>
  UsbDeviceFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbDeviceFilter::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbDeviceFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbDeviceFilter_UnserializedMessageContext<
            UserType, UsbDeviceFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<UsbDeviceFilter::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return UsbDeviceFilter::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbDeviceFilter_UnserializedMessageContext<
            UserType, UsbDeviceFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbDeviceFilter::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool has_vendor_id;
  
  uint16_t vendor_id;
  
  bool has_product_id;
  
  uint16_t product_id;
  
  bool has_class_code;
  
  uint8_t class_code;
  
  bool has_subclass_code;
  
  uint8_t subclass_code;
  
  bool has_protocol_code;
  
  uint8_t protocol_code;
  
  ::WTF::String serial_number;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT UsbEnumerationOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbEnumerationOptions, T>::value>;
  using DataView = UsbEnumerationOptionsDataView;
  using Data_ = internal::UsbEnumerationOptions_Data;

  template <typename... Args>
  static UsbEnumerationOptionsPtr New(Args&&... args) {
    return UsbEnumerationOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbEnumerationOptionsPtr From(const U& u) {
    return mojo::TypeConverter<UsbEnumerationOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbEnumerationOptions>::Convert(*this);
  }


  UsbEnumerationOptions();

  explicit UsbEnumerationOptions(
      WTF::Vector<UsbDeviceFilterPtr> filters);

  ~UsbEnumerationOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbEnumerationOptionsPtr>
  UsbEnumerationOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbEnumerationOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbEnumerationOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbEnumerationOptions_UnserializedMessageContext<
            UserType, UsbEnumerationOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<UsbEnumerationOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return UsbEnumerationOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbEnumerationOptions_UnserializedMessageContext<
            UserType, UsbEnumerationOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbEnumerationOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<UsbDeviceFilterPtr> filters;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(UsbEnumerationOptions);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
UsbDeviceFilterPtr UsbDeviceFilter::Clone() const {
  return New(
      mojo::Clone(has_vendor_id),
      mojo::Clone(vendor_id),
      mojo::Clone(has_product_id),
      mojo::Clone(product_id),
      mojo::Clone(has_class_code),
      mojo::Clone(class_code),
      mojo::Clone(has_subclass_code),
      mojo::Clone(subclass_code),
      mojo::Clone(has_protocol_code),
      mojo::Clone(protocol_code),
      mojo::Clone(serial_number)
  );
}

template <typename T, UsbDeviceFilter::EnableIfSame<T>*>
bool UsbDeviceFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_vendor_id, other_struct.has_vendor_id))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->has_product_id, other_struct.has_product_id))
    return false;
  if (!mojo::Equals(this->product_id, other_struct.product_id))
    return false;
  if (!mojo::Equals(this->has_class_code, other_struct.has_class_code))
    return false;
  if (!mojo::Equals(this->class_code, other_struct.class_code))
    return false;
  if (!mojo::Equals(this->has_subclass_code, other_struct.has_subclass_code))
    return false;
  if (!mojo::Equals(this->subclass_code, other_struct.subclass_code))
    return false;
  if (!mojo::Equals(this->has_protocol_code, other_struct.has_protocol_code))
    return false;
  if (!mojo::Equals(this->protocol_code, other_struct.protocol_code))
    return false;
  if (!mojo::Equals(this->serial_number, other_struct.serial_number))
    return false;
  return true;
}

template <typename T, UsbDeviceFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.has_vendor_id, rhs.has_vendor_id))
    return true;
  if (std::less<>{}(rhs.has_vendor_id, lhs.has_vendor_id))
    return false;
  if (std::less<>{}(lhs.vendor_id, rhs.vendor_id))
    return true;
  if (std::less<>{}(rhs.vendor_id, lhs.vendor_id))
    return false;
  if (std::less<>{}(lhs.has_product_id, rhs.has_product_id))
    return true;
  if (std::less<>{}(rhs.has_product_id, lhs.has_product_id))
    return false;
  if (std::less<>{}(lhs.product_id, rhs.product_id))
    return true;
  if (std::less<>{}(rhs.product_id, lhs.product_id))
    return false;
  if (std::less<>{}(lhs.has_class_code, rhs.has_class_code))
    return true;
  if (std::less<>{}(rhs.has_class_code, lhs.has_class_code))
    return false;
  if (std::less<>{}(lhs.class_code, rhs.class_code))
    return true;
  if (std::less<>{}(rhs.class_code, lhs.class_code))
    return false;
  if (std::less<>{}(lhs.has_subclass_code, rhs.has_subclass_code))
    return true;
  if (std::less<>{}(rhs.has_subclass_code, lhs.has_subclass_code))
    return false;
  if (std::less<>{}(lhs.subclass_code, rhs.subclass_code))
    return true;
  if (std::less<>{}(rhs.subclass_code, lhs.subclass_code))
    return false;
  if (std::less<>{}(lhs.has_protocol_code, rhs.has_protocol_code))
    return true;
  if (std::less<>{}(rhs.has_protocol_code, lhs.has_protocol_code))
    return false;
  if (std::less<>{}(lhs.protocol_code, rhs.protocol_code))
    return true;
  if (std::less<>{}(rhs.protocol_code, lhs.protocol_code))
    return false;
  if (std::less<>{}(lhs.serial_number, rhs.serial_number))
    return true;
  if (std::less<>{}(rhs.serial_number, lhs.serial_number))
    return false;
  return false;
}
template <typename StructPtrType>
UsbEnumerationOptionsPtr UsbEnumerationOptions::Clone() const {
  return New(
      mojo::Clone(filters)
  );
}

template <typename T, UsbEnumerationOptions::EnableIfSame<T>*>
bool UsbEnumerationOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  return true;
}

template <typename T, UsbEnumerationOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.filters, rhs.filters))
    return true;
  if (std::less<>{}(rhs.filters, lhs.filters))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbDeviceFilter::DataView,
                                         ::device::mojom::blink::UsbDeviceFilterPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbDeviceFilterPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbDeviceFilterPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::UsbDeviceFilter::has_vendor_id) has_vendor_id(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->has_vendor_id;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::vendor_id) vendor_id(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->vendor_id;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::has_product_id) has_product_id(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->has_product_id;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::product_id) product_id(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->product_id;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::has_class_code) has_class_code(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->has_class_code;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::class_code) class_code(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->class_code;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::has_subclass_code) has_subclass_code(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->has_subclass_code;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::subclass_code) subclass_code(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->subclass_code;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::has_protocol_code) has_protocol_code(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->has_protocol_code;
  }

  static decltype(::device::mojom::blink::UsbDeviceFilter::protocol_code) protocol_code(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->protocol_code;
  }

  static const decltype(::device::mojom::blink::UsbDeviceFilter::serial_number)& serial_number(
      const ::device::mojom::blink::UsbDeviceFilterPtr& input) {
    return input->serial_number;
  }

  static bool Read(::device::mojom::blink::UsbDeviceFilter::DataView input, ::device::mojom::blink::UsbDeviceFilterPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::UsbEnumerationOptions::DataView,
                                         ::device::mojom::blink::UsbEnumerationOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::UsbEnumerationOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::UsbEnumerationOptionsPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::UsbEnumerationOptions::filters)& filters(
      const ::device::mojom::blink::UsbEnumerationOptionsPtr& input) {
    return input->filters;
  }

  static bool Read(::device::mojom::blink::UsbEnumerationOptions::DataView input, ::device::mojom::blink::UsbEnumerationOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_BLINK_H_