// ipc/ipc.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef IPC_IPC_MOJOM_SHARED_H_
#define IPC_IPC_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ipc/ipc.mojom-shared-internal.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace IPC {
namespace mojom {
class MessageDataView;



}  // namespace mojom
}  // namespace IPC

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::IPC::mojom::MessageDataView> {
  using Data = ::IPC::mojom::internal::Message_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace IPC {
namespace mojom {
// Interface base classes. They are used for type safety check.
class GenericInterfaceInterfaceBase {};

using GenericInterfacePtrDataView =
    mojo::InterfacePtrDataView<GenericInterfaceInterfaceBase>;
using GenericInterfaceRequestDataView =
    mojo::InterfaceRequestDataView<GenericInterfaceInterfaceBase>;
using GenericInterfaceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GenericInterfaceInterfaceBase>;
using GenericInterfaceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GenericInterfaceInterfaceBase>;
class ChannelInterfaceBase {};

using ChannelPtrDataView =
    mojo::InterfacePtrDataView<ChannelInterfaceBase>;
using ChannelRequestDataView =
    mojo::InterfaceRequestDataView<ChannelInterfaceBase>;
using ChannelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ChannelInterfaceBase>;
using ChannelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ChannelInterfaceBase>;
class ChannelBootstrapInterfaceBase {};

using ChannelBootstrapPtrDataView =
    mojo::InterfacePtrDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapRequestDataView =
    mojo::InterfaceRequestDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ChannelBootstrapInterfaceBase>;


class MessageDataView {
 public:
  MessageDataView() {}

  MessageDataView(
      internal::Message_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetHandlesDataView(
      mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHandles(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>, UserType>(),
    "Attempting to read the optional `handles` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHandles` instead "
    "of `ReadHandles if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->handles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>>(
        pointer, output, context_);
  }
 private:
  internal::Message_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace IPC

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::IPC::mojom::MessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::IPC::mojom::MessageDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::IPC::mojom::internal::Message_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
    typename decltype((*output)->bytes)::BaseType::BufferWriter
        bytes_writer;
    const mojo::internal::ContainerValidateParams bytes_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_bytes, buffer, &bytes_writer, &bytes_validate_params,
        context);
    (*output)->bytes.Set(
        bytes_writer.is_null() ? nullptr : bytes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->bytes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bytes in Message struct");
    decltype(Traits::handles(input)) in_handles = Traits::handles(input);
    typename decltype((*output)->handles)::BaseType::BufferWriter
        handles_writer;
    const mojo::internal::ContainerValidateParams handles_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>>(
        in_handles, buffer, &handles_writer, &handles_validate_params,
        context);
    (*output)->handles.Set(
        handles_writer.is_null() ? nullptr : handles_writer.data());
  }

  static bool Deserialize(::IPC::mojom::internal::Message_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::IPC::mojom::MessageDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace IPC {
namespace mojom {

inline void MessageDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void MessageDataView::GetHandlesDataView(
    mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>* output) {
  auto pointer = data_->handles.Get();
  *output = mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace IPC

#endif  // IPC_IPC_MOJOM_SHARED_H_