/* PrefersColorSchemeSettings.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PrefersColorSchemeSettings.vala, do not modify */

/*
* Copyright 2020–2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <geoclue.h>
#include <granite.h>

#define SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_COLOR_SCHEME "color-scheme"
#define SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE "prefer-dark-schedule"
#define SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE_SNOOZED "prefer-dark-schedule-snoozed"
#define BUILD_PROJECT_NAME "io.elementary.settings-daemon"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS (settings_daemon_backends_prefers_color_scheme_settings_get_type ())
#define SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS, SettingsDaemonBackendsPrefersColorSchemeSettings))
#define SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS, SettingsDaemonBackendsPrefersColorSchemeSettingsClass))
#define SETTINGS_DAEMON_BACKENDS_IS_PREFERS_COLOR_SCHEME_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS))
#define SETTINGS_DAEMON_BACKENDS_IS_PREFERS_COLOR_SCHEME_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS))
#define SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS, SettingsDaemonBackendsPrefersColorSchemeSettingsClass))

typedef struct _SettingsDaemonBackendsPrefersColorSchemeSettings SettingsDaemonBackendsPrefersColorSchemeSettings;
typedef struct _SettingsDaemonBackendsPrefersColorSchemeSettingsClass SettingsDaemonBackendsPrefersColorSchemeSettingsClass;
typedef struct _SettingsDaemonBackendsPrefersColorSchemeSettingsPrivate SettingsDaemonBackendsPrefersColorSchemeSettingsPrivate;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE (pantheon_accounts_service_get_type ())
#define PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsService))
#define PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsServiceIface))

typedef struct _PantheonAccountsService PantheonAccountsService;
typedef struct _PantheonAccountsServiceIface PantheonAccountsServiceIface;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_accounts_service_proxy_get_type ())
enum  {
	SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_0_PROPERTY,
	SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_ACCOUNTS_SERVICE_PROPERTY,
	SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* settings_daemon_backends_prefers_color_scheme_settings_properties[SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _SettingsDaemonBackendsPrefersColorSchemeSettings {
	GObject parent_instance;
	SettingsDaemonBackendsPrefersColorSchemeSettingsPrivate * priv;
};

struct _SettingsDaemonBackendsPrefersColorSchemeSettingsClass {
	GObjectClass parent_class;
};

struct _PantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_prefers_color_scheme) (PantheonAccountsService* self);
	void (*set_prefers_color_scheme) (PantheonAccountsService* self, gint value);
	gint (*get_prefers_accent_color) (PantheonAccountsService* self);
	void (*set_prefers_accent_color) (PantheonAccountsService* self, gint value);
};

struct _SettingsDaemonBackendsPrefersColorSchemeSettingsPrivate {
	PantheonAccountsService* _accounts_service;
	GSettings* color_settings;
	gdouble sunrise;
	gdouble sunset;
	guint time_id;
};

struct _Block1Data {
	int _ref_count_;
	SettingsDaemonBackendsPrefersColorSchemeSettings* self;
	GClueSimple* simple;
};

struct _SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SettingsDaemonBackendsPrefersColorSchemeSettings* self;
	Block1Data* _data1_;
	GClueSimple* _tmp0_;
	GClueSimple* _tmp1_;
	GClueSimple* _tmp2_;
	GClueLocationProxy* _tmp3_;
	GClueLocationProxy* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	GClueSimple* _tmp7_;
	GClueLocationProxy* _tmp8_;
	GClueLocationProxy* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

static gint SettingsDaemonBackendsPrefersColorSchemeSettings_private_offset;
static gpointer settings_daemon_backends_prefers_color_scheme_settings_parent_class = NULL;

VALA_EXTERN GType settings_daemon_backends_prefers_color_scheme_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsDaemonBackendsPrefersColorSchemeSettings, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonAccountsService, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_accounts_service_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN SettingsDaemonBackendsPrefersColorSchemeSettings* settings_daemon_backends_prefers_color_scheme_settings_new (PantheonAccountsService* accounts_service);
VALA_EXTERN SettingsDaemonBackendsPrefersColorSchemeSettings* settings_daemon_backends_prefers_color_scheme_settings_construct (GType object_type,
                                                                                                                    PantheonAccountsService* accounts_service);
static void settings_daemon_backends_prefers_color_scheme_settings_update_timer (SettingsDaemonBackendsPrefersColorSchemeSettings* self);
static void settings_daemon_backends_prefers_color_scheme_settings_get_location (SettingsDaemonBackendsPrefersColorSchemeSettings* self,
                                                                          GAsyncReadyCallback _callback_,
                                                                          gpointer _user_data_);
static void settings_daemon_backends_prefers_color_scheme_settings_get_location_finish (SettingsDaemonBackendsPrefersColorSchemeSettings* self,
                                                                                 GAsyncResult* _res_);
static void settings_daemon_backends_prefers_color_scheme_settings_start_timer (SettingsDaemonBackendsPrefersColorSchemeSettings* self);
static void settings_daemon_backends_prefers_color_scheme_settings_stop_timer (SettingsDaemonBackendsPrefersColorSchemeSettings* self);
static gboolean settings_daemon_backends_prefers_color_scheme_settings_time_callback (SettingsDaemonBackendsPrefersColorSchemeSettings* self);
static gboolean _settings_daemon_backends_prefers_color_scheme_settings_time_callback_gsource_func (gpointer self);
static void settings_daemon_backends_prefers_color_scheme_settings_get_location_data_free (gpointer _data);
static gboolean settings_daemon_backends_prefers_color_scheme_settings_get_location_co (SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void settings_daemon_backends_prefers_color_scheme_settings_get_location_ready (GObject* source_object,
                                                                                GAsyncResult* _res_,
                                                                                gpointer _user_data_);
static void ___lambda11_ (Block1Data* _data1_);
static void settings_daemon_backends_prefers_color_scheme_settings_on_location_updated (SettingsDaemonBackendsPrefersColorSchemeSettings* self,
                                                                                 gdouble latitude,
                                                                                 gdouble longitude);
static void ____lambda11__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static gboolean settings_daemon_backends_prefers_color_scheme_settings_is_in_schedule (SettingsDaemonBackendsPrefersColorSchemeSettings* self);
static GVariant* _variant_new4 (gdouble value);
static GVariant* _variant_new5 (gdouble value);
VALA_EXTERN gboolean settings_daemon_utils_sunrise_sunset_calculator_get_sunrise_and_sunset (GDateTime* dt,
                                                                                 gdouble pos_lat,
                                                                                 gdouble pos_long,
                                                                                 gdouble* sunrise,
                                                                                 gdouble* sunset);
static void settings_daemon_backends_prefers_color_scheme_settings_update_color_scheme (SettingsDaemonBackendsPrefersColorSchemeSettings* self);
VALA_EXTERN PantheonAccountsService* settings_daemon_backends_prefers_color_scheme_settings_get_accounts_service (SettingsDaemonBackendsPrefersColorSchemeSettings* self);
VALA_EXTERN void pantheon_accounts_service_set_prefers_color_scheme (PantheonAccountsService* self,
                                                         gint value);
VALA_EXTERN gboolean settings_daemon_backends_prefers_color_scheme_settings_is_in_time_window (gdouble time_double,
                                                                                   gdouble from,
                                                                                   gdouble to);
VALA_EXTERN gdouble settings_daemon_backends_prefers_color_scheme_settings_date_time_double (GDateTime* date_time);
static void settings_daemon_backends_prefers_color_scheme_settings_set_accounts_service (SettingsDaemonBackendsPrefersColorSchemeSettings* self,
                                                                                  PantheonAccountsService* value);
static GObject * settings_daemon_backends_prefers_color_scheme_settings_constructor (GType type,
                                                                              guint n_construct_properties,
                                                                              GObjectConstructParam * construct_properties);
static void _settings_daemon_backends_prefers_color_scheme_settings_update_timer_g_settings_changed (GSettings* _sender,
                                                                                              const gchar* key,
                                                                                              gpointer self);
static void _settings_daemon_backends_prefers_color_scheme_settings_update_color_scheme_g_settings_changed (GSettings* _sender,
                                                                                                     const gchar* key,
                                                                                                     gpointer self);
static void settings_daemon_backends_prefers_color_scheme_settings_finalize (GObject * obj);
static GType settings_daemon_backends_prefers_color_scheme_settings_get_type_once (void);
static void _vala_settings_daemon_backends_prefers_color_scheme_settings_get_property (GObject * object,
                                                                                guint property_id,
                                                                                GValue * value,
                                                                                GParamSpec * pspec);
static void _vala_settings_daemon_backends_prefers_color_scheme_settings_set_property (GObject * object,
                                                                                guint property_id,
                                                                                const GValue * value,
                                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
settings_daemon_backends_prefers_color_scheme_settings_get_instance_private (SettingsDaemonBackendsPrefersColorSchemeSettings* self)
{
	return G_STRUCT_MEMBER_P (self, SettingsDaemonBackendsPrefersColorSchemeSettings_private_offset);
}

SettingsDaemonBackendsPrefersColorSchemeSettings*
settings_daemon_backends_prefers_color_scheme_settings_construct (GType object_type,
                                                                  PantheonAccountsService* accounts_service)
{
	SettingsDaemonBackendsPrefersColorSchemeSettings * self = NULL;
	g_return_val_if_fail (accounts_service != NULL, NULL);
	self = (SettingsDaemonBackendsPrefersColorSchemeSettings*) g_object_new (object_type, "accounts-service", accounts_service, NULL);
	return self;
}

SettingsDaemonBackendsPrefersColorSchemeSettings*
settings_daemon_backends_prefers_color_scheme_settings_new (PantheonAccountsService* accounts_service)
{
	return settings_daemon_backends_prefers_color_scheme_settings_construct (SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS, accounts_service);
}

static void
settings_daemon_backends_prefers_color_scheme_settings_update_timer (SettingsDaemonBackendsPrefersColorSchemeSettings* self)
{
	gchar* schedule = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->color_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE);
	schedule = _tmp1_;
	_tmp2_ = schedule;
	if (g_strcmp0 (_tmp2_, "sunset-to-sunrise") == 0) {
		settings_daemon_backends_prefers_color_scheme_settings_get_location (self, NULL, NULL);
		settings_daemon_backends_prefers_color_scheme_settings_start_timer (self);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = schedule;
		if (g_strcmp0 (_tmp3_, "manual") == 0) {
			settings_daemon_backends_prefers_color_scheme_settings_start_timer (self);
		} else {
			GSettings* _tmp4_;
			_tmp4_ = self->priv->color_settings;
			g_settings_set_boolean (_tmp4_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE_SNOOZED, FALSE);
			settings_daemon_backends_prefers_color_scheme_settings_stop_timer (self);
		}
	}
	_g_free0 (schedule);
}

static gboolean
_settings_daemon_backends_prefers_color_scheme_settings_time_callback_gsource_func (gpointer self)
{
	gboolean result;
	result = settings_daemon_backends_prefers_color_scheme_settings_time_callback ((SettingsDaemonBackendsPrefersColorSchemeSettings*) self);
	return result;
}

static void
settings_daemon_backends_prefers_color_scheme_settings_start_timer (SettingsDaemonBackendsPrefersColorSchemeSettings* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->time_id == ((guint) 0)) {
		GSource* time = NULL;
		GSource* _tmp0_;
		GSource* _tmp1_;
		GSource* _tmp2_;
		_tmp0_ = g_timeout_source_new ((guint) 1000);
		time = _tmp0_;
		_tmp1_ = time;
		g_source_set_callback (_tmp1_, _settings_daemon_backends_prefers_color_scheme_settings_time_callback_gsource_func, g_object_ref (self), g_object_unref);
		_tmp2_ = time;
		self->priv->time_id = g_source_attach (_tmp2_, NULL);
		_g_source_unref0 (time);
	}
}

static void
settings_daemon_backends_prefers_color_scheme_settings_stop_timer (SettingsDaemonBackendsPrefersColorSchemeSettings* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->time_id != ((guint) 0)) {
		g_source_remove (self->priv->time_id);
		self->priv->time_id = (guint) 0;
	}
}

static void
settings_daemon_backends_prefers_color_scheme_settings_get_location_data_free (gpointer _data)
{
	SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
settings_daemon_backends_prefers_color_scheme_settings_get_location (SettingsDaemonBackendsPrefersColorSchemeSettings* self,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_)
{
	SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData* _data_;
	SettingsDaemonBackendsPrefersColorSchemeSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, settings_daemon_backends_prefers_color_scheme_settings_get_location_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	settings_daemon_backends_prefers_color_scheme_settings_get_location_co (_data_);
}

static void
settings_daemon_backends_prefers_color_scheme_settings_get_location_finish (SettingsDaemonBackendsPrefersColorSchemeSettings* self,
                                                                            GAsyncResult* _res_)
{
	SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SettingsDaemonBackendsPrefersColorSchemeSettings* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->simple);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
settings_daemon_backends_prefers_color_scheme_settings_get_location_ready (GObject* source_object,
                                                                           GAsyncResult* _res_,
                                                                           gpointer _user_data_)
{
	SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	settings_daemon_backends_prefers_color_scheme_settings_get_location_co (_data_);
}

static void
___lambda11_ (Block1Data* _data1_)
{
	SettingsDaemonBackendsPrefersColorSchemeSettings* self;
	GClueSimple* _tmp0_;
	GClueLocationProxy* _tmp1_;
	GClueLocationProxy* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	GClueSimple* _tmp5_;
	GClueLocationProxy* _tmp6_;
	GClueLocationProxy* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	self = _data1_->self;
	_tmp0_ = _data1_->simple;
	_tmp1_ = gclue_simple_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	g_object_get ((GClueLocation*) _tmp2_, "latitude", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _data1_->simple;
	_tmp6_ = gclue_simple_get_location (_tmp5_);
	_tmp7_ = _tmp6_;
	g_object_get ((GClueLocation*) _tmp7_, "longitude", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	settings_daemon_backends_prefers_color_scheme_settings_on_location_updated (self, _tmp4_, _tmp9_);
}

static void
____lambda11__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda11_ (self);
}

static gboolean
settings_daemon_backends_prefers_color_scheme_settings_get_location_co (SettingsDaemonBackendsPrefersColorSchemeSettingsGetLocationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_data1_ = g_slice_new0 (Block1Data);
		_data_->_data1_->_ref_count_ = 1;
		_data_->_data1_->self = g_object_ref (_data_->self);
		_data_->_state_ = 1;
		gclue_simple_new (BUILD_PROJECT_NAME, GCLUE_ACCURACY_LEVEL_CITY, NULL, settings_daemon_backends_prefers_color_scheme_settings_get_location_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = gclue_simple_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_data1_->simple = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->_data1_->simple;
		g_signal_connect_data ((GObject*) _data_->_tmp1_, "notify::location", (GCallback) ____lambda11__g_object_notify, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
		_data_->_tmp2_ = _data_->_data1_->simple;
		_data_->_tmp3_ = gclue_simple_get_location (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		g_object_get ((GClueLocation*) _data_->_tmp4_, "latitude", &_data_->_tmp5_, NULL);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->_data1_->simple;
		_data_->_tmp8_ = gclue_simple_get_location (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		g_object_get ((GClueLocation*) _data_->_tmp9_, "longitude", &_data_->_tmp10_, NULL);
		_data_->_tmp11_ = _data_->_tmp10_;
		settings_daemon_backends_prefers_color_scheme_settings_on_location_updated (_data_->self, _data_->_tmp6_, _data_->_tmp11_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("PrefersColorSchemeSettings.vala:94: Failed to connect to GeoClue2 serv" \
"ice: %s", _data_->_tmp13_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
settings_daemon_backends_prefers_color_scheme_settings_time_callback (SettingsDaemonBackendsPrefersColorSchemeSettings* self)
{
	GraniteSettingsColorScheme new_color_scheme = 0;
	GSettings* _tmp0_;
	GSettings* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	new_color_scheme = GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE;
	if (settings_daemon_backends_prefers_color_scheme_settings_is_in_schedule (self)) {
		new_color_scheme = GRANITE_SETTINGS_COLOR_SCHEME_DARK;
	}
	_tmp0_ = self->priv->color_settings;
	if (new_color_scheme == g_settings_get_enum (_tmp0_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_COLOR_SCHEME)) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->color_settings;
		g_settings_set_boolean (_tmp1_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE_SNOOZED, FALSE);
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->color_settings;
	if (!g_settings_get_boolean (_tmp2_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE_SNOOZED)) {
		GSettings* _tmp3_;
		_tmp3_ = self->priv->color_settings;
		g_settings_set_enum (_tmp3_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_COLOR_SCHEME, (gint) new_color_scheme);
		result = TRUE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}

static GVariant*
_variant_new4 (gdouble value)
{
	return g_variant_ref_sink (g_variant_new_double (value));
}

static GVariant*
_variant_new5 (gdouble value)
{
	return g_variant_ref_sink (g_variant_new_double (value));
}

static void
settings_daemon_backends_prefers_color_scheme_settings_on_location_updated (SettingsDaemonBackendsPrefersColorSchemeSettings* self,
                                                                            gdouble latitude,
                                                                            gdouble longitude)
{
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant** _tmp3_;
	GVariant** _tmp4_;
	gint _tmp4__length1;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GDateTime* now = NULL;
	GDateTime* _tmp7_;
	gdouble _sunrise = 0.0;
	gdouble _sunset = 0.0;
	GDateTime* _tmp8_;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->color_settings;
	_tmp1_ = _variant_new4 (latitude);
	_tmp2_ = _variant_new5 (longitude);
	_tmp3_ = g_new0 (GVariant*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = g_variant_new_tuple (_tmp4_, 2);
	g_variant_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	g_settings_set_value (_tmp0_, "last-coordinates", _tmp6_);
	_g_variant_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_variant_unref), NULL);
	_tmp7_ = g_date_time_new_now_local ();
	now = _tmp7_;
	_tmp8_ = now;
	_tmp11_ = settings_daemon_utils_sunrise_sunset_calculator_get_sunrise_and_sunset (_tmp8_, latitude, longitude, &_tmp9_, &_tmp10_);
	_sunrise = _tmp9_;
	_sunset = _tmp10_;
	if (_tmp11_) {
		self->priv->sunrise = _sunrise;
		self->priv->sunset = _sunset;
	}
	_g_date_time_unref0 (now);
}

static void
settings_daemon_backends_prefers_color_scheme_settings_update_color_scheme (SettingsDaemonBackendsPrefersColorSchemeSettings* self)
{
	gint color_scheme = 0;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PantheonAccountsService* _tmp5_;
	GSettings* mutter_settings = NULL;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->color_settings;
	color_scheme = g_settings_get_enum (_tmp0_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_COLOR_SCHEME);
	if (color_scheme == ((gint) GRANITE_SETTINGS_COLOR_SCHEME_DARK)) {
		_tmp2_ = !settings_daemon_backends_prefers_color_scheme_settings_is_in_schedule (self);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (color_scheme != ((gint) GRANITE_SETTINGS_COLOR_SCHEME_DARK)) {
			_tmp3_ = settings_daemon_backends_prefers_color_scheme_settings_is_in_schedule (self);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		GSettings* _tmp4_;
		_tmp4_ = self->priv->color_settings;
		g_settings_set_boolean (_tmp4_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE_SNOOZED, TRUE);
	}
	_tmp5_ = self->priv->_accounts_service;
	pantheon_accounts_service_set_prefers_color_scheme (_tmp5_, color_scheme);
	_tmp6_ = g_settings_new ("org.gnome.desktop.interface");
	mutter_settings = _tmp6_;
	g_settings_set_enum (mutter_settings, "color-scheme", color_scheme);
	_g_object_unref0 (mutter_settings);
}

static gboolean
settings_daemon_backends_prefers_color_scheme_settings_is_in_schedule (SettingsDaemonBackendsPrefersColorSchemeSettings* self)
{
	gchar* schedule = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gdouble from = 0.0;
	gdouble to = 0.0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GDateTime* now = NULL;
	GDateTime* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->color_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE);
	schedule = _tmp1_;
	from = 20.0;
	to = 6.0;
	_tmp4_ = schedule;
	if (g_strcmp0 (_tmp4_, "sunset-to-sunrise") == 0) {
		_tmp3_ = self->priv->sunrise >= ((gdouble) 0);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = self->priv->sunset >= ((gdouble) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		from = self->priv->sunset;
		to = self->priv->sunrise;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = schedule;
		if (g_strcmp0 (_tmp5_, "manual") == 0) {
			GSettings* _tmp6_;
			GSettings* _tmp7_;
			_tmp6_ = self->priv->color_settings;
			from = g_settings_get_double (_tmp6_, "prefer-dark-schedule-from");
			_tmp7_ = self->priv->color_settings;
			to = g_settings_get_double (_tmp7_, "prefer-dark-schedule-to");
		}
	}
	_tmp8_ = g_date_time_new_now_local ();
	now = _tmp8_;
	result = settings_daemon_backends_prefers_color_scheme_settings_is_in_time_window (settings_daemon_backends_prefers_color_scheme_settings_date_time_double (now), from, to);
	_g_date_time_unref0 (now);
	_g_free0 (schedule);
	return result;
}

gboolean
settings_daemon_backends_prefers_color_scheme_settings_is_in_time_window (gdouble time_double,
                                                                          gdouble from,
                                                                          gdouble to)
{
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (from > to) {
		gboolean _tmp0_ = FALSE;
		if (time_double < to) {
			_tmp0_ = time_double <= from;
		} else {
			_tmp0_ = time_double >= from;
		}
		result = _tmp0_;
		return result;
	}
	if (time_double >= from) {
		_tmp1_ = time_double <= to;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

gdouble
settings_daemon_backends_prefers_color_scheme_settings_date_time_double (GDateTime* date_time)
{
	gdouble time_double = 0.0;
	gdouble result;
	g_return_val_if_fail (date_time != NULL, 0.0);
	time_double = (gdouble) 0;
	time_double += (gdouble) g_date_time_get_hour (date_time);
	time_double += ((gdouble) g_date_time_get_minute (date_time)) / 60;
	result = time_double;
	return result;
}

PantheonAccountsService*
settings_daemon_backends_prefers_color_scheme_settings_get_accounts_service (SettingsDaemonBackendsPrefersColorSchemeSettings* self)
{
	PantheonAccountsService* result;
	PantheonAccountsService* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accounts_service;
	result = _tmp0_;
	return result;
}

static void
settings_daemon_backends_prefers_color_scheme_settings_set_accounts_service (SettingsDaemonBackendsPrefersColorSchemeSettings* self,
                                                                             PantheonAccountsService* value)
{
	PantheonAccountsService* old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_daemon_backends_prefers_color_scheme_settings_get_accounts_service (self);
	if (old_value != value) {
		self->priv->_accounts_service = value;
		g_object_notify_by_pspec ((GObject *) self, settings_daemon_backends_prefers_color_scheme_settings_properties[SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_ACCOUNTS_SERVICE_PROPERTY]);
	}
}

static void
_settings_daemon_backends_prefers_color_scheme_settings_update_timer_g_settings_changed (GSettings* _sender,
                                                                                         const gchar* key,
                                                                                         gpointer self)
{
	settings_daemon_backends_prefers_color_scheme_settings_update_timer ((SettingsDaemonBackendsPrefersColorSchemeSettings*) self);
}

static void
_settings_daemon_backends_prefers_color_scheme_settings_update_color_scheme_g_settings_changed (GSettings* _sender,
                                                                                                const gchar* key,
                                                                                                gpointer self)
{
	settings_daemon_backends_prefers_color_scheme_settings_update_color_scheme ((SettingsDaemonBackendsPrefersColorSchemeSettings*) self);
}

static GObject *
settings_daemon_backends_prefers_color_scheme_settings_constructor (GType type,
                                                                    guint n_construct_properties,
                                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SettingsDaemonBackendsPrefersColorSchemeSettings * self;
	GSettings* _tmp0_;
	gchar* schedule = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GSettings* _tmp12_;
	gchar* _tmp13_;
	GSettings* _tmp14_;
	gchar* _tmp15_;
	parent_class = G_OBJECT_CLASS (settings_daemon_backends_prefers_color_scheme_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS, SettingsDaemonBackendsPrefersColorSchemeSettings);
	_tmp0_ = g_settings_new ("io.elementary.settings-daemon.prefers-color-scheme");
	_g_object_unref0 (self->priv->color_settings);
	self->priv->color_settings = _tmp0_;
	_tmp1_ = self->priv->color_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE);
	schedule = _tmp2_;
	_tmp3_ = schedule;
	if (g_strcmp0 (_tmp3_, "sunset-to-sunrise") == 0) {
		GVariant* variant = NULL;
		GSettings* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		GVariant* _tmp11_;
		_tmp4_ = self->priv->color_settings;
		_tmp5_ = g_settings_get_value (_tmp4_, "last-coordinates");
		variant = _tmp5_;
		_tmp6_ = variant;
		_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 0);
		_tmp8_ = _tmp7_;
		_tmp9_ = variant;
		_tmp10_ = g_variant_get_child_value (_tmp9_, (gsize) 1);
		_tmp11_ = _tmp10_;
		settings_daemon_backends_prefers_color_scheme_settings_on_location_updated (self, g_variant_get_double (_tmp8_), g_variant_get_double (_tmp11_));
		_g_variant_unref0 (_tmp11_);
		_g_variant_unref0 (_tmp8_);
		_g_variant_unref0 (variant);
	}
	_tmp12_ = self->priv->color_settings;
	_tmp13_ = g_strconcat ("changed::", SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_DARK_SCHEDULE, NULL);
	g_signal_connect_object (_tmp12_, _tmp13_, (GCallback) _settings_daemon_backends_prefers_color_scheme_settings_update_timer_g_settings_changed, self, 0);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->color_settings;
	_tmp15_ = g_strconcat ("changed::", SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_COLOR_SCHEME, NULL);
	g_signal_connect_object (_tmp14_, _tmp15_, (GCallback) _settings_daemon_backends_prefers_color_scheme_settings_update_color_scheme_g_settings_changed, self, 0);
	_g_free0 (_tmp15_);
	settings_daemon_backends_prefers_color_scheme_settings_update_timer (self);
	_g_free0 (schedule);
	return obj;
}

static void
settings_daemon_backends_prefers_color_scheme_settings_class_init (SettingsDaemonBackendsPrefersColorSchemeSettingsClass * klass,
                                                                   gpointer klass_data)
{
	settings_daemon_backends_prefers_color_scheme_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SettingsDaemonBackendsPrefersColorSchemeSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_settings_daemon_backends_prefers_color_scheme_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_settings_daemon_backends_prefers_color_scheme_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = settings_daemon_backends_prefers_color_scheme_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_daemon_backends_prefers_color_scheme_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_ACCOUNTS_SERVICE_PROPERTY, settings_daemon_backends_prefers_color_scheme_settings_properties[SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_ACCOUNTS_SERVICE_PROPERTY] = g_param_spec_object ("accounts-service", "accounts-service", "accounts-service", PANTHEON_TYPE_ACCOUNTS_SERVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
settings_daemon_backends_prefers_color_scheme_settings_instance_init (SettingsDaemonBackendsPrefersColorSchemeSettings * self,
                                                                      gpointer klass)
{
	self->priv = settings_daemon_backends_prefers_color_scheme_settings_get_instance_private (self);
	self->priv->sunrise = -1.0;
	self->priv->sunset = -1.0;
	self->priv->time_id = (guint) 0;
}

static void
settings_daemon_backends_prefers_color_scheme_settings_finalize (GObject * obj)
{
	SettingsDaemonBackendsPrefersColorSchemeSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS, SettingsDaemonBackendsPrefersColorSchemeSettings);
	_g_object_unref0 (self->priv->color_settings);
	G_OBJECT_CLASS (settings_daemon_backends_prefers_color_scheme_settings_parent_class)->finalize (obj);
}

static GType
settings_daemon_backends_prefers_color_scheme_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsDaemonBackendsPrefersColorSchemeSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_daemon_backends_prefers_color_scheme_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsDaemonBackendsPrefersColorSchemeSettings), 0, (GInstanceInitFunc) settings_daemon_backends_prefers_color_scheme_settings_instance_init, NULL };
	GType settings_daemon_backends_prefers_color_scheme_settings_type_id;
	settings_daemon_backends_prefers_color_scheme_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingsDaemonBackendsPrefersColorSchemeSettings", &g_define_type_info, 0);
	SettingsDaemonBackendsPrefersColorSchemeSettings_private_offset = g_type_add_instance_private (settings_daemon_backends_prefers_color_scheme_settings_type_id, sizeof (SettingsDaemonBackendsPrefersColorSchemeSettingsPrivate));
	return settings_daemon_backends_prefers_color_scheme_settings_type_id;
}

GType
settings_daemon_backends_prefers_color_scheme_settings_get_type (void)
{
	static volatile gsize settings_daemon_backends_prefers_color_scheme_settings_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_backends_prefers_color_scheme_settings_type_id__once)) {
		GType settings_daemon_backends_prefers_color_scheme_settings_type_id;
		settings_daemon_backends_prefers_color_scheme_settings_type_id = settings_daemon_backends_prefers_color_scheme_settings_get_type_once ();
		g_once_init_leave (&settings_daemon_backends_prefers_color_scheme_settings_type_id__once, settings_daemon_backends_prefers_color_scheme_settings_type_id);
	}
	return settings_daemon_backends_prefers_color_scheme_settings_type_id__once;
}

static void
_vala_settings_daemon_backends_prefers_color_scheme_settings_get_property (GObject * object,
                                                                           guint property_id,
                                                                           GValue * value,
                                                                           GParamSpec * pspec)
{
	SettingsDaemonBackendsPrefersColorSchemeSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS, SettingsDaemonBackendsPrefersColorSchemeSettings);
	switch (property_id) {
		case SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_ACCOUNTS_SERVICE_PROPERTY:
		g_value_set_object (value, settings_daemon_backends_prefers_color_scheme_settings_get_accounts_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_settings_daemon_backends_prefers_color_scheme_settings_set_property (GObject * object,
                                                                           guint property_id,
                                                                           const GValue * value,
                                                                           GParamSpec * pspec)
{
	SettingsDaemonBackendsPrefersColorSchemeSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETTINGS_DAEMON_BACKENDS_TYPE_PREFERS_COLOR_SCHEME_SETTINGS, SettingsDaemonBackendsPrefersColorSchemeSettings);
	switch (property_id) {
		case SETTINGS_DAEMON_BACKENDS_PREFERS_COLOR_SCHEME_SETTINGS_ACCOUNTS_SERVICE_PROPERTY:
		settings_daemon_backends_prefers_color_scheme_settings_set_accounts_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

