/* SearchBoolean.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SearchBoolean.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* For specifying whether a search should be ORed (any) or ANDed (all).*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecSearchCondition ParamSpecSearchCondition;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	SAVED_SEARCH_0_PROPERTY,
	SAVED_SEARCH_NUM_PROPERTIES
};
static GParamSpec* saved_search_properties[SAVED_SEARCH_NUM_PROPERTIES];
#define _saved_search_row_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_row_unref (var), NULL)))
#define _search_condition_unref0(var) ((var == NULL) ? NULL : (var = (search_condition_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _saved_search_table_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_table_unref (var), NULL)))
typedef struct _ParamSpecSavedSearchTable ParamSpecSavedSearchTable;
enum  {
	SAVED_SEARCH_TABLE_SEARCH_ADDED_SIGNAL,
	SAVED_SEARCH_TABLE_SEARCH_REMOVED_SIGNAL,
	SAVED_SEARCH_TABLE_NUM_SIGNALS
};
static guint saved_search_table_signals[SAVED_SEARCH_TABLE_NUM_SIGNALS] = {0};

struct _SearchConditionPrivate {
	SearchConditionSearchType _search_type;
};

struct _ParamSpecSearchCondition {
	GParamSpec parent_instance;
};

struct _SearchConditionTextPrivate {
	gchar* _text;
	SearchConditionTextContext _context;
};

struct _SearchConditionMediaTypePrivate {
	SearchConditionMediaTypeMediaType _media_type;
	SearchConditionMediaTypeContext _context;
};

struct _SearchConditionFlaggedPrivate {
	SearchConditionFlaggedState _state;
};

struct _SearchConditionModifiedPrivate {
	SearchConditionModifiedState _state;
	SearchConditionModifiedContext _context;
};

struct _SearchConditionDatePrivate {
	GDateTime* _date_one;
	GDateTime* _date_two;
	SearchConditionDateContext _context;
};

struct _SavedSearchPrivate {
	SavedSearchRow* row;
};

struct _SavedSearchTablePrivate {
	GeeHashMap* search_map;
};

struct _ParamSpecSavedSearchTable {
	GParamSpec parent_instance;
};

static gint SearchCondition_private_offset;
static gpointer search_condition_parent_class = NULL;
static gint SearchConditionText_private_offset;
static gpointer search_condition_text_parent_class = NULL;
static gint SearchConditionMediaType_private_offset;
static gpointer search_condition_media_type_parent_class = NULL;
static gint SearchConditionFlagged_private_offset;
static gpointer search_condition_flagged_parent_class = NULL;
static gint SearchConditionModified_private_offset;
static gpointer search_condition_modified_parent_class = NULL;
static gint SearchConditionDate_private_offset;
static gpointer search_condition_date_parent_class = NULL;
static gint SavedSearch_private_offset;
static gpointer saved_search_parent_class = NULL;
static gint SavedSearchTable_private_offset;
static gpointer saved_search_table_parent_class = NULL;
static SavedSearchTable* saved_search_table_instance;
static SavedSearchTable* saved_search_table_instance = NULL;

static gint __lambda19_ (void* a,
                  void* b);
static gint ___lambda19____compar_fn_t (void* key1,
                                 void* key2);
static gboolean search_condition_real_predicate (SearchCondition* self,
                                          MediaSource* source);
static void search_condition_finalize (SearchCondition * obj);
static GType search_condition_get_type_once (void);
static void search_condition_text_set_text (SearchConditionText* self,
                                     const gchar* value);
static void search_condition_text_set_context (SearchConditionText* self,
                                        SearchConditionTextContext value);
static gboolean search_condition_text_string_match (SearchConditionText* self,
                                             const gchar* needle,
                                             const gchar* haystack);
static gboolean search_condition_text_real_predicate (SearchCondition* base,
                                               MediaSource* source);
static void search_condition_text_finalize (SearchCondition * obj);
static GType search_condition_text_get_type_once (void);
static void search_condition_media_type_set_context (SearchConditionMediaType* self,
                                              SearchConditionMediaTypeContext value);
static void search_condition_media_type_set_media_type (SearchConditionMediaType* self,
                                                 SearchConditionMediaTypeMediaType value);
static gboolean search_condition_media_type_real_predicate (SearchCondition* base,
                                                     MediaSource* source);
static void search_condition_media_type_finalize (SearchCondition * obj);
static GType search_condition_media_type_get_type_once (void);
static void search_condition_flagged_set_state (SearchConditionFlagged* self,
                                         SearchConditionFlaggedState value);
static gboolean search_condition_flagged_real_predicate (SearchCondition* base,
                                                  MediaSource* source);
static void search_condition_flagged_finalize (SearchCondition * obj);
static GType search_condition_flagged_get_type_once (void);
static void search_condition_modified_set_context (SearchConditionModified* self,
                                            SearchConditionModifiedContext value);
static void search_condition_modified_set_state (SearchConditionModified* self,
                                          SearchConditionModifiedState value);
static gboolean search_condition_modified_real_predicate (SearchCondition* base,
                                                   MediaSource* source);
static void search_condition_modified_finalize (SearchCondition * obj);
static GType search_condition_modified_get_type_once (void);
static void search_condition_date_set_context (SearchConditionDate* self,
                                        SearchConditionDateContext value);
static void search_condition_date_set_date_one (SearchConditionDate* self,
                                         GDateTime* value);
static void search_condition_date_set_date_two (SearchConditionDate* self,
                                         GDateTime* value);
static gboolean search_condition_date_real_predicate (SearchCondition* base,
                                               MediaSource* source);
static void search_condition_date_finalize (SearchCondition * obj);
static GType search_condition_date_get_type_once (void);
static gchar* saved_search_real_get_name (DataObject* base);
static gchar* saved_search_real_to_string (DataObject* base);
static gchar* saved_search_real_get_typename (DataSource* base);
static gint64 saved_search_real_get_instance_id (DataSource* base);
static void saved_search_finalize (GObject * obj);
static GType saved_search_get_type_once (void);
static SavedSearchTable* saved_search_table_new (void);
static SavedSearchTable* saved_search_table_construct (GType object_type);
static void saved_search_table_finalize (SavedSearchTable * obj);
static GType saved_search_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
search_operator_to_string (SearchOperator self)
{
	gchar* result;
	switch (self) {
		case SEARCH_OPERATOR_ANY:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ANY");
			result = _tmp0_;
			return result;
		}
		case SEARCH_OPERATOR_ALL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ALL");
			result = _tmp1_;
			return result;
		}
		case SEARCH_OPERATOR_NONE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("NONE");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:38: unrecognized search operator enumeration value");
		}
	}
}

SearchOperator
search_operator_from_string (const gchar* str)
{
	SearchOperator result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "ANY") == 0) {
		result = SEARCH_OPERATOR_ANY;
		return result;
	} else {
		if (g_strcmp0 (str, "ALL") == 0) {
			result = SEARCH_OPERATOR_ALL;
			return result;
		} else {
			if (g_strcmp0 (str, "NONE") == 0) {
				result = SEARCH_OPERATOR_NONE;
				return result;
			} else {
				g_error ("SearchBoolean.vala:53: unrecognized search operator name: %s", str);
			}
		}
	}
}

static GType
search_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_OPERATOR_ANY, "SEARCH_OPERATOR_ANY", "any"}, {SEARCH_OPERATOR_ALL, "SEARCH_OPERATOR_ALL", "all"}, {SEARCH_OPERATOR_NONE, "SEARCH_OPERATOR_NONE", "none"}, {0, NULL, NULL}};
	GType search_operator_type_id;
	search_operator_type_id = g_enum_register_static ("SearchOperator", values);
	return search_operator_type_id;
}

GType
search_operator_get_type (void)
{
	static volatile gsize search_operator_type_id__once = 0;
	if (g_once_init_enter (&search_operator_type_id__once)) {
		GType search_operator_type_id;
		search_operator_type_id = search_operator_get_type_once ();
		g_once_init_leave (&search_operator_type_id__once, search_operator_type_id);
	}
	return search_operator_type_id__once;
}

static inline gpointer
search_condition_get_instance_private (SearchCondition* self)
{
	return G_STRUCT_MEMBER_P (self, SearchCondition_private_offset);
}

SearchConditionSearchType*
search_condition_search_type_as_array (gint* result_length1)
{
	SearchConditionSearchType* _tmp0_;
	SearchConditionSearchType* _tmp1_;
	gint _tmp1__length1;
	SearchConditionSearchType* result;
	_tmp0_ = g_new0 (SearchConditionSearchType, 10);
	_tmp0_[0] = SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT;
	_tmp0_[1] = SEARCH_CONDITION_SEARCH_TYPE_TITLE;
	_tmp0_[2] = SEARCH_CONDITION_SEARCH_TYPE_TAG;
	_tmp0_[3] = SEARCH_CONDITION_SEARCH_TYPE_COMMENT;
	_tmp0_[4] = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME;
	_tmp0_[5] = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME;
	_tmp0_[6] = SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE;
	_tmp0_[7] = SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE;
	_tmp0_[8] = SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE;
	_tmp0_[9] = SEARCH_CONDITION_SEARCH_TYPE_DATE;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 10;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gint
__lambda19_ (void* a,
             void* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	_tmp0_ = search_condition_search_type_display_text (*((SearchConditionSearchType*) a));
	_tmp1_ = _tmp0_;
	_tmp2_ = search_condition_search_type_display_text (*((SearchConditionSearchType*) b));
	_tmp3_ = _tmp2_;
	_tmp4_ = utf8_cs_compare (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gint
___lambda19____compar_fn_t (void* key1,
                            void* key2)
{
	gint result;
	result = __lambda19_ (key1, key2);
	return result;
}

void
search_condition_search_type_sort_array (SearchConditionSearchType** array,
                                         gint* array_length1)
{
	qsort (*array, (gsize) (*array_length1), (gsize) sizeof (SearchConditionSearchType), ___lambda19____compar_fn_t);
}

gchar*
search_condition_search_type_to_string (SearchConditionSearchType self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ANY_TEXT");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_TITLE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("TITLE");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_TAG:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("TAG");
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_COMMENT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("COMMENT");
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("EVENT_NAME");
			result = _tmp4_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("FILE_NAME");
			result = _tmp5_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("MEDIA_TYPE");
			result = _tmp6_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("FLAG_STATE");
			result = _tmp7_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("MODIFIED_STATE");
			result = _tmp8_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_DATE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("DATE");
			result = _tmp9_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:123: unrecognized search type enumeration value");
		}
	}
}

SearchConditionSearchType
search_condition_search_type_from_string (const gchar* str)
{
	SearchConditionSearchType result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "ANY_TEXT") == 0) {
		result = SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT;
		return result;
	} else {
		if (g_strcmp0 (str, "TITLE") == 0) {
			result = SEARCH_CONDITION_SEARCH_TYPE_TITLE;
			return result;
		} else {
			if (g_strcmp0 (str, "TAG") == 0) {
				result = SEARCH_CONDITION_SEARCH_TYPE_TAG;
				return result;
			} else {
				if (g_strcmp0 (str, "COMMENT") == 0) {
					result = SEARCH_CONDITION_SEARCH_TYPE_COMMENT;
					return result;
				} else {
					if (g_strcmp0 (str, "EVENT_NAME") == 0) {
						result = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME;
						return result;
					} else {
						if (g_strcmp0 (str, "FILE_NAME") == 0) {
							result = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME;
							return result;
						} else {
							if (g_strcmp0 (str, "MEDIA_TYPE") == 0) {
								result = SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE;
								return result;
							} else {
								if (g_strcmp0 (str, "FLAG_STATE") == 0) {
									result = SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE;
									return result;
								} else {
									if (g_strcmp0 (str, "MODIFIED_STATE") == 0) {
										result = SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE;
										return result;
									} else {
										if (g_strcmp0 (str, "DATE") == 0) {
											result = SEARCH_CONDITION_SEARCH_TYPE_DATE;
											return result;
										} else {
											g_error ("SearchBoolean.vala:159: unrecognized search type name: %s", str);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

gchar*
search_condition_search_type_display_text (SearchConditionSearchType self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Any text"));
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_TITLE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Title"));
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_TAG:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Tag"));
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_COMMENT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Comment"));
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Event name"));
			result = _tmp4_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("File name"));
			result = _tmp5_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Media type"));
			result = _tmp6_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Flag state"));
			result = _tmp7_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Photo state"));
			result = _tmp8_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_DATE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Date"));
			result = _tmp9_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:195: unrecognized search type enumeration value");
		}
	}
}

static GType
search_condition_search_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT, "SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT", "any-text"}, {SEARCH_CONDITION_SEARCH_TYPE_TITLE, "SEARCH_CONDITION_SEARCH_TYPE_TITLE", "title"}, {SEARCH_CONDITION_SEARCH_TYPE_TAG, "SEARCH_CONDITION_SEARCH_TYPE_TAG", "tag"}, {SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME, "SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME", "event-name"}, {SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME, "SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME", "file-name"}, {SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE, "SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE", "media-type"}, {SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE, "SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE", "flag-state"}, {SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE, "SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE", "modified-state"}, {SEARCH_CONDITION_SEARCH_TYPE_COMMENT, "SEARCH_CONDITION_SEARCH_TYPE_COMMENT", "comment"}, {SEARCH_CONDITION_SEARCH_TYPE_DATE, "SEARCH_CONDITION_SEARCH_TYPE_DATE", "date"}, {0, NULL, NULL}};
	GType search_condition_search_type_type_id;
	search_condition_search_type_type_id = g_enum_register_static ("SearchConditionSearchType", values);
	return search_condition_search_type_type_id;
}

GType
search_condition_search_type_get_type (void)
{
	static volatile gsize search_condition_search_type_type_id__once = 0;
	if (g_once_init_enter (&search_condition_search_type_type_id__once)) {
		GType search_condition_search_type_type_id;
		search_condition_search_type_type_id = search_condition_search_type_get_type_once ();
		g_once_init_leave (&search_condition_search_type_type_id__once, search_condition_search_type_type_id);
	}
	return search_condition_search_type_type_id__once;
}

static gboolean
search_condition_real_predicate (SearchCondition* self,
                                 MediaSource* source)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `search_condition_predicate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
search_condition_predicate (SearchCondition* self,
                            MediaSource* source)
{
	SearchConditionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SEARCH_CONDITION_GET_CLASS (self);
	if (_klass_->predicate) {
		return _klass_->predicate (self, source);
	}
	return FALSE;
}

SearchCondition*
search_condition_construct (GType object_type)
{
	SearchCondition* self = NULL;
	self = (SearchCondition*) g_type_create_instance (object_type);
	return self;
}

SearchConditionSearchType
search_condition_get_search_type (SearchCondition* self)
{
	SearchConditionSearchType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_search_type;
	return result;
}

void
search_condition_set_search_type (SearchCondition* self,
                                  SearchConditionSearchType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_search_type = value;
}

static void
value_search_condition_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_search_condition_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		search_condition_unref (value->data[0].v_pointer);
	}
}

static void
value_search_condition_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = search_condition_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_search_condition_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_search_condition_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SearchCondition * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = search_condition_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_search_condition_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	SearchCondition ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = search_condition_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_search_condition (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecSearchCondition* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SEARCH_CONDITION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_search_condition (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_search_condition (GValue* value,
                            gpointer v_object)
{
	SearchCondition * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEARCH_CONDITION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		search_condition_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		search_condition_unref (old);
	}
}

void
value_take_search_condition (GValue* value,
                             gpointer v_object)
{
	SearchCondition * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEARCH_CONDITION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		search_condition_unref (old);
	}
}

static void
search_condition_class_init (SearchConditionClass * klass,
                             gpointer klass_data)
{
	search_condition_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_finalize;
	g_type_class_adjust_private_offset (klass, &SearchCondition_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_real_predicate;
}

static void
search_condition_instance_init (SearchCondition * self,
                                gpointer klass)
{
	self->priv = search_condition_get_instance_private (self);
	self->ref_count = 1;
}

static void
search_condition_finalize (SearchCondition * obj)
{
	SearchCondition * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION, SearchCondition);
	g_signal_handlers_destroy (self);
}

static GType
search_condition_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_search_condition_init, value_search_condition_free_value, value_search_condition_copy_value, value_search_condition_peek_pointer, "p", value_search_condition_collect_value, "p", value_search_condition_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchCondition), 0, (GInstanceInitFunc) search_condition_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType search_condition_type_id;
	search_condition_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SearchCondition", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	SearchCondition_private_offset = g_type_add_instance_private (search_condition_type_id, sizeof (SearchConditionPrivate));
	return search_condition_type_id;
}

GType
search_condition_get_type (void)
{
	static volatile gsize search_condition_type_id__once = 0;
	if (g_once_init_enter (&search_condition_type_id__once)) {
		GType search_condition_type_id;
		search_condition_type_id = search_condition_get_type_once ();
		g_once_init_leave (&search_condition_type_id__once, search_condition_type_id);
	}
	return search_condition_type_id__once;
}

gpointer
search_condition_ref (gpointer instance)
{
	SearchCondition * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
search_condition_unref (gpointer instance)
{
	SearchCondition * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SEARCH_CONDITION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
search_condition_text_get_instance_private (SearchConditionText* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionText_private_offset);
}

gchar*
search_condition_text_context_to_string (SearchConditionTextContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("CONTAINS");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("IS_EXACTLY");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("STARTS_WITH");
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ENDS_WITH");
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("DOES_NOT_CONTAIN");
			result = _tmp4_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("IS_NOT_SET");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:240: unrecognized text search context enumeration v" \
"alue");
		}
	}
}

SearchConditionTextContext
search_condition_text_context_from_string (const gchar* str)
{
	SearchConditionTextContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "CONTAINS") == 0) {
		result = SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS;
		return result;
	} else {
		if (g_strcmp0 (str, "IS_EXACTLY") == 0) {
			result = SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY;
			return result;
		} else {
			if (g_strcmp0 (str, "STARTS_WITH") == 0) {
				result = SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH;
				return result;
			} else {
				if (g_strcmp0 (str, "ENDS_WITH") == 0) {
					result = SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH;
					return result;
				} else {
					if (g_strcmp0 (str, "DOES_NOT_CONTAIN") == 0) {
						result = SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN;
						return result;
					} else {
						if (g_strcmp0 (str, "IS_NOT_SET") == 0) {
							result = SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET;
							return result;
						} else {
							g_error ("SearchBoolean.vala:264: unrecognized text search context name: %s", str);
						}
					}
				}
			}
		}
	}
}

static GType
search_condition_text_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS, "SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS", "contains"}, {SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY, "SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY", "is-exactly"}, {SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH, "SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH", "starts-with"}, {SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH, "SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH", "ends-with"}, {SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN, "SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN", "does-not-contain"}, {SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET, "SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET", "is-not-set"}, {0, NULL, NULL}};
	GType search_condition_text_context_type_id;
	search_condition_text_context_type_id = g_enum_register_static ("SearchConditionTextContext", values);
	return search_condition_text_context_type_id;
}

GType
search_condition_text_context_get_type (void)
{
	static volatile gsize search_condition_text_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_text_context_type_id__once)) {
		GType search_condition_text_context_type_id;
		search_condition_text_context_type_id = search_condition_text_context_get_type_once ();
		g_once_init_leave (&search_condition_text_context_type_id__once, search_condition_text_context_type_id);
	}
	return search_condition_text_context_type_id__once;
}

SearchConditionText*
search_condition_text_construct (GType object_type,
                                 SearchConditionSearchType search_type,
                                 const gchar* text,
                                 SearchConditionTextContext context)
{
	SearchConditionText* self = NULL;
	gchar* _tmp0_ = NULL;
	self = (SearchConditionText*) search_condition_construct (object_type);
	search_condition_set_search_type ((SearchCondition*) self, search_type);
	if (text != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_utf8_strdown (text, (gssize) -1);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	search_condition_text_set_text (self, _tmp0_);
	search_condition_text_set_context (self, context);
	_g_free0 (_tmp0_);
	return self;
}

SearchConditionText*
search_condition_text_new (SearchConditionSearchType search_type,
                           const gchar* text,
                           SearchConditionTextContext context)
{
	return search_condition_text_construct (TYPE_SEARCH_CONDITION_TEXT, search_type, text, context);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
search_condition_text_string_match (SearchConditionText* self,
                                    const gchar* needle,
                                    const gchar* haystack)
{
	SearchConditionTextContext _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = self->priv->_context;
	switch (_tmp0_) {
		case SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS:
		case SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN:
		{
			gboolean _tmp1_ = FALSE;
			if (!is_string_empty (haystack)) {
				_tmp1_ = string_contains (haystack, needle);
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY:
		{
			gboolean _tmp2_ = FALSE;
			if (!is_string_empty (haystack)) {
				_tmp2_ = g_strcmp0 (haystack, needle) == 0;
			} else {
				_tmp2_ = FALSE;
			}
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH:
		{
			gboolean _tmp3_ = FALSE;
			if (!is_string_empty (haystack)) {
				_tmp3_ = g_str_has_prefix (haystack, needle);
			} else {
				_tmp3_ = FALSE;
			}
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH:
		{
			gboolean _tmp4_ = FALSE;
			if (!is_string_empty (haystack)) {
				_tmp4_ = g_str_has_suffix (haystack, needle);
			} else {
				_tmp4_ = FALSE;
			}
			result = _tmp4_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET:
		{
			result = is_string_empty (haystack);
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static gboolean
search_condition_text_real_predicate (SearchCondition* base,
                                      MediaSource* source)
{
	SearchConditionText * self;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	SearchConditionSearchType _tmp1_;
	SearchConditionSearchType _tmp2_;
	gboolean _tmp13_ = FALSE;
	SearchConditionSearchType _tmp14_;
	SearchConditionSearchType _tmp15_;
	gboolean _tmp36_ = FALSE;
	SearchConditionSearchType _tmp37_;
	SearchConditionSearchType _tmp38_;
	gboolean _tmp55_ = FALSE;
	SearchConditionSearchType _tmp56_;
	SearchConditionSearchType _tmp57_;
	gboolean _tmp68_ = FALSE;
	SearchConditionSearchType _tmp69_;
	SearchConditionSearchType _tmp70_;
	gboolean _tmp80_ = FALSE;
	SearchConditionTextContext _tmp81_;
	gboolean result;
	self = (SearchConditionText*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	ret = FALSE;
	_tmp1_ = search_condition_get_search_type ((SearchCondition*) self);
	_tmp2_ = _tmp1_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		SearchConditionSearchType _tmp3_;
		SearchConditionSearchType _tmp4_;
		_tmp3_ = search_condition_get_search_type ((SearchCondition*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = SEARCH_CONDITION_SEARCH_TYPE_TITLE == _tmp4_;
	}
	if (_tmp0_) {
		gchar* title = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = media_source_get_title (source);
		title = _tmp5_;
		_tmp6_ = title;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp7_ = self->priv->_text;
			_tmp8_ = title;
			_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
			_tmp10_ = _tmp9_;
			_tmp11_ = string_remove_diacritics (_tmp10_);
			_tmp12_ = _tmp11_;
			ret |= search_condition_text_string_match (self, _tmp7_, _tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
		}
		_g_free0 (title);
	}
	_tmp14_ = search_condition_get_search_type ((SearchCondition*) self);
	_tmp15_ = _tmp14_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp15_) {
		_tmp13_ = TRUE;
	} else {
		SearchConditionSearchType _tmp16_;
		SearchConditionSearchType _tmp17_;
		_tmp16_ = search_condition_get_search_type ((SearchCondition*) self);
		_tmp17_ = _tmp16_;
		_tmp13_ = SEARCH_CONDITION_SEARCH_TYPE_TAG == _tmp17_;
	}
	if (_tmp13_) {
		GeeList* tag_list = NULL;
		TagSourceCollection* _tmp18_;
		GeeList* _tmp19_;
		GeeList* _tmp20_;
		_tmp18_ = tag_global;
		_tmp19_ = tag_source_collection_fetch_for_source (_tmp18_, source);
		tag_list = _tmp19_;
		_tmp20_ = tag_list;
		if (NULL != _tmp20_) {
			gchar* itag = NULL;
			{
				GeeList* _tag_list = NULL;
				GeeList* _tmp21_;
				gint _tag_size = 0;
				GeeList* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tag_index = 0;
				_tmp21_ = tag_list;
				_tag_list = _tmp21_;
				_tmp22_ = _tag_list;
				_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tag_size = _tmp24_;
				_tag_index = -1;
				while (TRUE) {
					gint _tmp25_;
					gint _tmp26_;
					Tag* tag = NULL;
					GeeList* _tmp27_;
					gpointer _tmp28_;
					Tag* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					_tag_index = _tag_index + 1;
					_tmp25_ = _tag_index;
					_tmp26_ = _tag_size;
					if (!(_tmp25_ < _tmp26_)) {
						break;
					}
					_tmp27_ = _tag_list;
					_tmp28_ = gee_list_get (_tmp27_, _tag_index);
					tag = (Tag*) _tmp28_;
					_tmp29_ = tag;
					_tmp30_ = tag_get_searchable_name (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_utf8_strdown (_tmp31_, (gssize) -1);
					_g_free0 (itag);
					itag = _tmp32_;
					_g_free0 (_tmp31_);
					_tmp33_ = self->priv->_text;
					_tmp34_ = itag;
					ret |= search_condition_text_string_match (self, _tmp33_, _tmp34_);
					_g_object_unref0 (tag);
				}
			}
			_g_free0 (itag);
		} else {
			const gchar* _tmp35_;
			_tmp35_ = self->priv->_text;
			ret |= search_condition_text_string_match (self, _tmp35_, NULL);
		}
		_g_object_unref0 (tag_list);
	}
	_tmp37_ = search_condition_get_search_type ((SearchCondition*) self);
	_tmp38_ = _tmp37_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp38_) {
		_tmp36_ = TRUE;
	} else {
		SearchConditionSearchType _tmp39_;
		SearchConditionSearchType _tmp40_;
		_tmp39_ = search_condition_get_search_type ((SearchCondition*) self);
		_tmp40_ = _tmp39_;
		_tmp36_ = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME == _tmp40_;
	}
	if (_tmp36_) {
		gchar* _tmp41_ = NULL;
		Event* _tmp42_;
		Event* _tmp43_;
		gboolean _tmp44_;
		gchar* event_name = NULL;
		gchar* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp42_ = media_source_get_event (source);
		_tmp43_ = _tmp42_;
		_tmp44_ = NULL != _tmp43_;
		_g_object_unref0 (_tmp43_);
		if (_tmp44_) {
			Event* _tmp45_;
			Event* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp45_ = media_source_get_event (source);
			_tmp46_ = _tmp45_;
			_tmp47_ = data_object_get_name ((DataObject*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_utf8_strdown (_tmp48_, (gssize) -1);
			_tmp50_ = _tmp49_;
			_tmp51_ = string_remove_diacritics (_tmp50_);
			_g_free0 (_tmp41_);
			_tmp41_ = _tmp51_;
			_g_free0 (_tmp50_);
			_g_free0 (_tmp48_);
			_g_object_unref0 (_tmp46_);
		} else {
			_g_free0 (_tmp41_);
			_tmp41_ = NULL;
		}
		_tmp52_ = g_strdup (_tmp41_);
		event_name = _tmp52_;
		_tmp53_ = self->priv->_text;
		_tmp54_ = event_name;
		ret |= search_condition_text_string_match (self, _tmp53_, _tmp54_);
		_g_free0 (event_name);
		_g_free0 (_tmp41_);
	}
	_tmp56_ = search_condition_get_search_type ((SearchCondition*) self);
	_tmp57_ = _tmp56_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp57_) {
		_tmp55_ = TRUE;
	} else {
		SearchConditionSearchType _tmp58_;
		SearchConditionSearchType _tmp59_;
		_tmp58_ = search_condition_get_search_type ((SearchCondition*) self);
		_tmp59_ = _tmp58_;
		_tmp55_ = SEARCH_CONDITION_SEARCH_TYPE_COMMENT == _tmp59_;
	}
	if (_tmp55_) {
		gchar* comment = NULL;
		gchar* _tmp60_;
		const gchar* _tmp61_;
		_tmp60_ = media_source_get_comment (source);
		comment = _tmp60_;
		_tmp61_ = comment;
		if (NULL != _tmp61_) {
			const gchar* _tmp62_;
			const gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp62_ = self->priv->_text;
			_tmp63_ = comment;
			_tmp64_ = g_utf8_strdown (_tmp63_, (gssize) -1);
			_tmp65_ = _tmp64_;
			_tmp66_ = string_remove_diacritics (_tmp65_);
			_tmp67_ = _tmp66_;
			ret |= search_condition_text_string_match (self, _tmp62_, _tmp67_);
			_g_free0 (_tmp67_);
			_g_free0 (_tmp65_);
		}
		_g_free0 (comment);
	}
	_tmp69_ = search_condition_get_search_type ((SearchCondition*) self);
	_tmp70_ = _tmp69_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp70_) {
		_tmp68_ = TRUE;
	} else {
		SearchConditionSearchType _tmp71_;
		SearchConditionSearchType _tmp72_;
		_tmp71_ = search_condition_get_search_type ((SearchCondition*) self);
		_tmp72_ = _tmp71_;
		_tmp68_ = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME == _tmp72_;
	}
	if (_tmp68_) {
		const gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		_tmp73_ = self->priv->_text;
		_tmp74_ = media_source_get_basename (source);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_utf8_strdown (_tmp75_, (gssize) -1);
		_tmp77_ = _tmp76_;
		_tmp78_ = string_remove_diacritics (_tmp77_);
		_tmp79_ = _tmp78_;
		ret |= search_condition_text_string_match (self, _tmp73_, _tmp79_);
		_g_free0 (_tmp79_);
		_g_free0 (_tmp77_);
		_g_free0 (_tmp75_);
	}
	_tmp81_ = self->priv->_context;
	if (_tmp81_ == SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN) {
		_tmp80_ = !ret;
	} else {
		_tmp80_ = ret;
	}
	result = _tmp80_;
	return result;
}

const gchar*
search_condition_text_get_text (SearchConditionText* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
search_condition_text_set_text (SearchConditionText* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp0_;
}

SearchConditionTextContext
search_condition_text_get_context (SearchConditionText* self)
{
	SearchConditionTextContext result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_text_set_context (SearchConditionText* self,
                                   SearchConditionTextContext value)
{
	g_return_if_fail (self != NULL);
	self->priv->_context = value;
}

static void
search_condition_text_class_init (SearchConditionTextClass * klass,
                                  gpointer klass_data)
{
	search_condition_text_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_text_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionText_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_text_real_predicate;
}

static void
search_condition_text_instance_init (SearchConditionText * self,
                                     gpointer klass)
{
	self->priv = search_condition_text_get_instance_private (self);
}

static void
search_condition_text_finalize (SearchCondition * obj)
{
	SearchConditionText * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_TEXT, SearchConditionText);
	_g_free0 (self->priv->_text);
	SEARCH_CONDITION_CLASS (search_condition_text_parent_class)->finalize (obj);
}

static GType
search_condition_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionText), 0, (GInstanceInitFunc) search_condition_text_instance_init, NULL };
	GType search_condition_text_type_id;
	search_condition_text_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionText", &g_define_type_info, 0);
	SearchConditionText_private_offset = g_type_add_instance_private (search_condition_text_type_id, sizeof (SearchConditionTextPrivate));
	return search_condition_text_type_id;
}

GType
search_condition_text_get_type (void)
{
	static volatile gsize search_condition_text_type_id__once = 0;
	if (g_once_init_enter (&search_condition_text_type_id__once)) {
		GType search_condition_text_type_id;
		search_condition_text_type_id = search_condition_text_get_type_once ();
		g_once_init_leave (&search_condition_text_type_id__once, search_condition_text_type_id);
	}
	return search_condition_text_type_id__once;
}

static inline gpointer
search_condition_media_type_get_instance_private (SearchConditionMediaType* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionMediaType_private_offset);
}

gchar*
search_condition_media_type_context_to_string (SearchConditionMediaTypeContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("IS");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("IS_NOT");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:373: unrecognized media search context enumeration " \
"value");
		}
	}
}

SearchConditionMediaTypeContext
search_condition_media_type_context_from_string (const gchar* str)
{
	SearchConditionMediaTypeContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "IS") == 0) {
		result = SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
		return result;
	} else {
		if (g_strcmp0 (str, "IS_NOT") == 0) {
			result = SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
			return result;
		} else {
			g_error ("SearchBoolean.vala:385: unrecognized media search context name: %s", str);
		}
	}
}

static GType
search_condition_media_type_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS, "SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS", "is"}, {SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT, "SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT", "is-not"}, {0, NULL, NULL}};
	GType search_condition_media_type_context_type_id;
	search_condition_media_type_context_type_id = g_enum_register_static ("SearchConditionMediaTypeContext", values);
	return search_condition_media_type_context_type_id;
}

GType
search_condition_media_type_context_get_type (void)
{
	static volatile gsize search_condition_media_type_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_media_type_context_type_id__once)) {
		GType search_condition_media_type_context_type_id;
		search_condition_media_type_context_type_id = search_condition_media_type_context_get_type_once ();
		g_once_init_leave (&search_condition_media_type_context_type_id__once, search_condition_media_type_context_type_id);
	}
	return search_condition_media_type_context_type_id__once;
}

gchar*
search_condition_media_type_media_type_to_string (SearchConditionMediaTypeMediaType self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("PHOTO_ALL");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("PHOTO_RAW");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("VIDEO");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:406: unrecognized media search type enumeration val" \
"ue");
		}
	}
}

SearchConditionMediaTypeMediaType
search_condition_media_type_media_type_from_string (const gchar* str)
{
	SearchConditionMediaTypeMediaType result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "PHOTO_ALL") == 0) {
		result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL;
		return result;
	} else {
		if (g_strcmp0 (str, "PHOTO_RAW") == 0) {
			result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW;
			return result;
		} else {
			if (g_strcmp0 (str, "VIDEO") == 0) {
				result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO;
				return result;
			} else {
				g_error ("SearchBoolean.vala:421: unrecognized media search type name: %s", str);
			}
		}
	}
}

static GType
search_condition_media_type_media_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL", "photo-all"}, {SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW", "photo-raw"}, {SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO", "video"}, {0, NULL, NULL}};
	GType search_condition_media_type_media_type_type_id;
	search_condition_media_type_media_type_type_id = g_enum_register_static ("SearchConditionMediaTypeMediaType", values);
	return search_condition_media_type_media_type_type_id;
}

GType
search_condition_media_type_media_type_get_type (void)
{
	static volatile gsize search_condition_media_type_media_type_type_id__once = 0;
	if (g_once_init_enter (&search_condition_media_type_media_type_type_id__once)) {
		GType search_condition_media_type_media_type_type_id;
		search_condition_media_type_media_type_type_id = search_condition_media_type_media_type_get_type_once ();
		g_once_init_leave (&search_condition_media_type_media_type_type_id__once, search_condition_media_type_media_type_type_id);
	}
	return search_condition_media_type_media_type_type_id__once;
}

SearchConditionMediaType*
search_condition_media_type_construct (GType object_type,
                                       SearchConditionSearchType search_type,
                                       SearchConditionMediaTypeContext context,
                                       SearchConditionMediaTypeMediaType media_type)
{
	SearchConditionMediaType* self = NULL;
	self = (SearchConditionMediaType*) search_condition_construct (object_type);
	search_condition_set_search_type ((SearchCondition*) self, search_type);
	search_condition_media_type_set_context (self, context);
	search_condition_media_type_set_media_type (self, media_type);
	return self;
}

SearchConditionMediaType*
search_condition_media_type_new (SearchConditionSearchType search_type,
                                 SearchConditionMediaTypeContext context,
                                 SearchConditionMediaTypeMediaType media_type)
{
	return search_condition_media_type_construct (TYPE_SEARCH_CONDITION_MEDIA_TYPE, search_type, context, media_type);
}

static gboolean
search_condition_media_type_real_predicate (SearchCondition* base,
                                            MediaSource* source)
{
	SearchConditionMediaType * self;
	SearchConditionMediaTypeMediaType _tmp0_;
	gboolean result;
	self = (SearchConditionMediaType*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->priv->_media_type;
	switch (_tmp0_) {
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL:
		{
			if (IS_PHOTO (source)) {
				SearchConditionMediaTypeContext _tmp1_;
				_tmp1_ = self->priv->_context;
				result = _tmp1_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
				return result;
			} else {
				SearchConditionMediaTypeContext _tmp2_;
				_tmp2_ = self->priv->_context;
				result = _tmp2_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
				return result;
			}
		}
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW:
		{
			gboolean _tmp3_ = FALSE;
			if (IS_PHOTO (source)) {
				_tmp3_ = photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo)) == PHOTO_FILE_FORMAT_RAW;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				SearchConditionMediaTypeContext _tmp4_;
				_tmp4_ = self->priv->_context;
				result = _tmp4_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
				return result;
			} else {
				SearchConditionMediaTypeContext _tmp5_;
				_tmp5_ = self->priv->_context;
				result = _tmp5_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
				return result;
			}
		}
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO:
		{
			if (IS_VIDEO_SOURCE (source)) {
				SearchConditionMediaTypeContext _tmp6_;
				_tmp6_ = self->priv->_context;
				result = _tmp6_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
				return result;
			} else {
				SearchConditionMediaTypeContext _tmp7_;
				_tmp7_ = self->priv->_context;
				result = _tmp7_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
				return result;
			}
		}
		default:
		{
			g_error ("SearchBoolean.vala:467: unrecognized media search type enumeration val" \
"ue");
		}
	}
}

SearchConditionMediaTypeMediaType
search_condition_media_type_get_media_type (SearchConditionMediaType* self)
{
	SearchConditionMediaTypeMediaType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_media_type;
	return result;
}

static void
search_condition_media_type_set_media_type (SearchConditionMediaType* self,
                                            SearchConditionMediaTypeMediaType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_media_type = value;
}

SearchConditionMediaTypeContext
search_condition_media_type_get_context (SearchConditionMediaType* self)
{
	SearchConditionMediaTypeContext result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_media_type_set_context (SearchConditionMediaType* self,
                                         SearchConditionMediaTypeContext value)
{
	g_return_if_fail (self != NULL);
	self->priv->_context = value;
}

static void
search_condition_media_type_class_init (SearchConditionMediaTypeClass * klass,
                                        gpointer klass_data)
{
	search_condition_media_type_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_media_type_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionMediaType_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_media_type_real_predicate;
}

static void
search_condition_media_type_instance_init (SearchConditionMediaType * self,
                                           gpointer klass)
{
	self->priv = search_condition_media_type_get_instance_private (self);
}

static void
search_condition_media_type_finalize (SearchCondition * obj)
{
	SearchConditionMediaType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType);
	SEARCH_CONDITION_CLASS (search_condition_media_type_parent_class)->finalize (obj);
}

static GType
search_condition_media_type_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionMediaTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_media_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionMediaType), 0, (GInstanceInitFunc) search_condition_media_type_instance_init, NULL };
	GType search_condition_media_type_type_id;
	search_condition_media_type_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionMediaType", &g_define_type_info, 0);
	SearchConditionMediaType_private_offset = g_type_add_instance_private (search_condition_media_type_type_id, sizeof (SearchConditionMediaTypePrivate));
	return search_condition_media_type_type_id;
}

GType
search_condition_media_type_get_type (void)
{
	static volatile gsize search_condition_media_type_type_id__once = 0;
	if (g_once_init_enter (&search_condition_media_type_type_id__once)) {
		GType search_condition_media_type_type_id;
		search_condition_media_type_type_id = search_condition_media_type_get_type_once ();
		g_once_init_leave (&search_condition_media_type_type_id__once, search_condition_media_type_type_id);
	}
	return search_condition_media_type_type_id__once;
}

static inline gpointer
search_condition_flagged_get_instance_private (SearchConditionFlagged* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionFlagged_private_offset);
}

gchar*
search_condition_flagged_state_to_string (SearchConditionFlaggedState self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_FLAGGED_STATE_FLAGGED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("FLAGGED");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("UNFLAGGED");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:487: unrecognized flagged search state enumeration " \
"value");
		}
	}
}

SearchConditionFlaggedState
search_condition_flagged_state_from_string (const gchar* str)
{
	SearchConditionFlaggedState result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "FLAGGED") == 0) {
		result = SEARCH_CONDITION_FLAGGED_STATE_FLAGGED;
		return result;
	} else {
		if (g_strcmp0 (str, "UNFLAGGED") == 0) {
			result = SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED;
			return result;
		} else {
			g_error ("SearchBoolean.vala:499: unrecognized flagged search state name: %s", str);
		}
	}
}

static GType
search_condition_flagged_state_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_FLAGGED_STATE_FLAGGED, "SEARCH_CONDITION_FLAGGED_STATE_FLAGGED", "flagged"}, {SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED, "SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED", "unflagged"}, {0, NULL, NULL}};
	GType search_condition_flagged_state_type_id;
	search_condition_flagged_state_type_id = g_enum_register_static ("SearchConditionFlaggedState", values);
	return search_condition_flagged_state_type_id;
}

GType
search_condition_flagged_state_get_type (void)
{
	static volatile gsize search_condition_flagged_state_type_id__once = 0;
	if (g_once_init_enter (&search_condition_flagged_state_type_id__once)) {
		GType search_condition_flagged_state_type_id;
		search_condition_flagged_state_type_id = search_condition_flagged_state_get_type_once ();
		g_once_init_leave (&search_condition_flagged_state_type_id__once, search_condition_flagged_state_type_id);
	}
	return search_condition_flagged_state_type_id__once;
}

SearchConditionFlagged*
search_condition_flagged_construct (GType object_type,
                                    SearchConditionSearchType search_type,
                                    SearchConditionFlaggedState state)
{
	SearchConditionFlagged* self = NULL;
	self = (SearchConditionFlagged*) search_condition_construct (object_type);
	search_condition_set_search_type ((SearchCondition*) self, search_type);
	search_condition_flagged_set_state (self, state);
	return self;
}

SearchConditionFlagged*
search_condition_flagged_new (SearchConditionSearchType search_type,
                              SearchConditionFlaggedState state)
{
	return search_condition_flagged_construct (TYPE_SEARCH_CONDITION_FLAGGED, search_type, state);
}

static gboolean
search_condition_flagged_real_predicate (SearchCondition* base,
                                         MediaSource* source)
{
	SearchConditionFlagged * self;
	SearchConditionFlaggedState _tmp0_;
	gboolean result;
	self = (SearchConditionFlagged*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == SEARCH_CONDITION_FLAGGED_STATE_FLAGGED) {
		result = flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_FLAGGABLE, Flaggable));
		return result;
	} else {
		SearchConditionFlaggedState _tmp1_;
		_tmp1_ = self->priv->_state;
		if (_tmp1_ == SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED) {
			result = !flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_FLAGGABLE, Flaggable));
			return result;
		} else {
			g_error ("SearchBoolean.vala:521: unrecognized flagged search state");
		}
	}
}

SearchConditionFlaggedState
search_condition_flagged_get_state (SearchConditionFlagged* self)
{
	SearchConditionFlaggedState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
search_condition_flagged_set_state (SearchConditionFlagged* self,
                                    SearchConditionFlaggedState value)
{
	g_return_if_fail (self != NULL);
	self->priv->_state = value;
}

static void
search_condition_flagged_class_init (SearchConditionFlaggedClass * klass,
                                     gpointer klass_data)
{
	search_condition_flagged_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_flagged_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionFlagged_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_flagged_real_predicate;
}

static void
search_condition_flagged_instance_init (SearchConditionFlagged * self,
                                        gpointer klass)
{
	self->priv = search_condition_flagged_get_instance_private (self);
}

static void
search_condition_flagged_finalize (SearchCondition * obj)
{
	SearchConditionFlagged * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged);
	SEARCH_CONDITION_CLASS (search_condition_flagged_parent_class)->finalize (obj);
}

static GType
search_condition_flagged_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionFlaggedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_flagged_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionFlagged), 0, (GInstanceInitFunc) search_condition_flagged_instance_init, NULL };
	GType search_condition_flagged_type_id;
	search_condition_flagged_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionFlagged", &g_define_type_info, 0);
	SearchConditionFlagged_private_offset = g_type_add_instance_private (search_condition_flagged_type_id, sizeof (SearchConditionFlaggedPrivate));
	return search_condition_flagged_type_id;
}

GType
search_condition_flagged_get_type (void)
{
	static volatile gsize search_condition_flagged_type_id__once = 0;
	if (g_once_init_enter (&search_condition_flagged_type_id__once)) {
		GType search_condition_flagged_type_id;
		search_condition_flagged_type_id = search_condition_flagged_get_type_once ();
		g_once_init_leave (&search_condition_flagged_type_id__once, search_condition_flagged_type_id);
	}
	return search_condition_flagged_type_id__once;
}

static inline gpointer
search_condition_modified_get_instance_private (SearchConditionModified* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionModified_private_offset);
}

gchar*
search_condition_modified_context_to_string (SearchConditionModifiedContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_MODIFIED_CONTEXT_HAS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("HAS");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("HAS_NO");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:542: unrecognized modified search context enumerati" \
"on value");
		}
	}
}

SearchConditionModifiedContext
search_condition_modified_context_from_string (const gchar* str)
{
	SearchConditionModifiedContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "HAS") == 0) {
		result = SEARCH_CONDITION_MODIFIED_CONTEXT_HAS;
		return result;
	} else {
		if (g_strcmp0 (str, "HAS_NO") == 0) {
			result = SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO;
			return result;
		} else {
			g_error ("SearchBoolean.vala:554: unrecognized modified search context name: %s", str);
		}
	}
}

static GType
search_condition_modified_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_MODIFIED_CONTEXT_HAS, "SEARCH_CONDITION_MODIFIED_CONTEXT_HAS", "has"}, {SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO, "SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO", "has-no"}, {0, NULL, NULL}};
	GType search_condition_modified_context_type_id;
	search_condition_modified_context_type_id = g_enum_register_static ("SearchConditionModifiedContext", values);
	return search_condition_modified_context_type_id;
}

GType
search_condition_modified_context_get_type (void)
{
	static volatile gsize search_condition_modified_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_modified_context_type_id__once)) {
		GType search_condition_modified_context_type_id;
		search_condition_modified_context_type_id = search_condition_modified_context_get_type_once ();
		g_once_init_leave (&search_condition_modified_context_type_id__once, search_condition_modified_context_type_id);
	}
	return search_condition_modified_context_type_id__once;
}

gchar*
search_condition_modified_state_to_string (SearchConditionModifiedState self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_MODIFIED_STATE_MODIFIED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("MODIFIED");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("INTERNAL_CHANGES");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("EXTERNAL_CHANGES");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:575: unrecognized modified search state enumeration" \
" value");
		}
	}
}

SearchConditionModifiedState
search_condition_modified_state_from_string (const gchar* str)
{
	SearchConditionModifiedState result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "MODIFIED") == 0) {
		result = SEARCH_CONDITION_MODIFIED_STATE_MODIFIED;
		return result;
	} else {
		if (g_strcmp0 (str, "INTERNAL_CHANGES") == 0) {
			result = SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES;
			return result;
		} else {
			if (g_strcmp0 (str, "EXTERNAL_CHANGES") == 0) {
				result = SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES;
				return result;
			} else {
				g_error ("SearchBoolean.vala:590: unrecognized modified search state name: %s", str);
			}
		}
	}
}

static GType
search_condition_modified_state_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_MODIFIED_STATE_MODIFIED, "SEARCH_CONDITION_MODIFIED_STATE_MODIFIED", "modified"}, {SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES, "SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES", "internal-changes"}, {SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES, "SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES", "external-changes"}, {0, NULL, NULL}};
	GType search_condition_modified_state_type_id;
	search_condition_modified_state_type_id = g_enum_register_static ("SearchConditionModifiedState", values);
	return search_condition_modified_state_type_id;
}

GType
search_condition_modified_state_get_type (void)
{
	static volatile gsize search_condition_modified_state_type_id__once = 0;
	if (g_once_init_enter (&search_condition_modified_state_type_id__once)) {
		GType search_condition_modified_state_type_id;
		search_condition_modified_state_type_id = search_condition_modified_state_get_type_once ();
		g_once_init_leave (&search_condition_modified_state_type_id__once, search_condition_modified_state_type_id);
	}
	return search_condition_modified_state_type_id__once;
}

SearchConditionModified*
search_condition_modified_construct (GType object_type,
                                     SearchConditionSearchType search_type,
                                     SearchConditionModifiedContext context,
                                     SearchConditionModifiedState state)
{
	SearchConditionModified* self = NULL;
	self = (SearchConditionModified*) search_condition_construct (object_type);
	search_condition_set_search_type ((SearchCondition*) self, search_type);
	search_condition_modified_set_context (self, context);
	search_condition_modified_set_state (self, state);
	return self;
}

SearchConditionModified*
search_condition_modified_new (SearchConditionSearchType search_type,
                               SearchConditionModifiedContext context,
                               SearchConditionModifiedState state)
{
	return search_condition_modified_construct (TYPE_SEARCH_CONDITION_MODIFIED, search_type, context, state);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
search_condition_modified_real_predicate (SearchCondition* base,
                                          MediaSource* source)
{
	SearchConditionModified * self;
	Photo* photo = NULL;
	Photo* _tmp0_;
	Photo* _tmp1_;
	gboolean match = FALSE;
	SearchConditionModifiedState _tmp2_;
	gboolean result;
	self = (SearchConditionModified*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (IS_PHOTO (source) ? ((Photo*) source) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (photo);
		return result;
	}
	_tmp2_ = self->priv->_state;
	if (_tmp2_ == SEARCH_CONDITION_MODIFIED_STATE_MODIFIED) {
		gboolean _tmp3_ = FALSE;
		Photo* _tmp4_;
		_tmp4_ = photo;
		if (photo_has_transformations (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			Photo* _tmp5_;
			_tmp5_ = photo;
			_tmp3_ = photo_has_editable (_tmp5_);
		}
		match = _tmp3_;
	} else {
		SearchConditionModifiedState _tmp6_;
		_tmp6_ = self->priv->_state;
		if (_tmp6_ == SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES) {
			Photo* _tmp7_;
			_tmp7_ = photo;
			match = photo_has_transformations (_tmp7_);
		} else {
			SearchConditionModifiedState _tmp8_;
			_tmp8_ = self->priv->_state;
			if (_tmp8_ == SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES) {
				Photo* _tmp9_;
				_tmp9_ = photo;
				match = photo_has_editable (_tmp9_);
			} else {
				g_error ("SearchBoolean.vala:627: unrecognized modified search state");
			}
		}
	}
	if (match) {
		SearchConditionModifiedContext _tmp10_;
		_tmp10_ = self->priv->_context;
		result = _tmp10_ == SEARCH_CONDITION_MODIFIED_CONTEXT_HAS;
		_g_object_unref0 (photo);
		return result;
	} else {
		SearchConditionModifiedContext _tmp11_;
		_tmp11_ = self->priv->_context;
		result = _tmp11_ == SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO;
		_g_object_unref0 (photo);
		return result;
	}
}

SearchConditionModifiedState
search_condition_modified_get_state (SearchConditionModified* self)
{
	SearchConditionModifiedState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
search_condition_modified_set_state (SearchConditionModified* self,
                                     SearchConditionModifiedState value)
{
	g_return_if_fail (self != NULL);
	self->priv->_state = value;
}

SearchConditionModifiedContext
search_condition_modified_get_context (SearchConditionModified* self)
{
	SearchConditionModifiedContext result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_modified_set_context (SearchConditionModified* self,
                                       SearchConditionModifiedContext value)
{
	g_return_if_fail (self != NULL);
	self->priv->_context = value;
}

static void
search_condition_modified_class_init (SearchConditionModifiedClass * klass,
                                      gpointer klass_data)
{
	search_condition_modified_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_modified_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionModified_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_modified_real_predicate;
}

static void
search_condition_modified_instance_init (SearchConditionModified * self,
                                         gpointer klass)
{
	self->priv = search_condition_modified_get_instance_private (self);
}

static void
search_condition_modified_finalize (SearchCondition * obj)
{
	SearchConditionModified * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified);
	SEARCH_CONDITION_CLASS (search_condition_modified_parent_class)->finalize (obj);
}

static GType
search_condition_modified_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionModifiedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_modified_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionModified), 0, (GInstanceInitFunc) search_condition_modified_instance_init, NULL };
	GType search_condition_modified_type_id;
	search_condition_modified_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionModified", &g_define_type_info, 0);
	SearchConditionModified_private_offset = g_type_add_instance_private (search_condition_modified_type_id, sizeof (SearchConditionModifiedPrivate));
	return search_condition_modified_type_id;
}

GType
search_condition_modified_get_type (void)
{
	static volatile gsize search_condition_modified_type_id__once = 0;
	if (g_once_init_enter (&search_condition_modified_type_id__once)) {
		GType search_condition_modified_type_id;
		search_condition_modified_type_id = search_condition_modified_get_type_once ();
		g_once_init_leave (&search_condition_modified_type_id__once, search_condition_modified_type_id);
	}
	return search_condition_modified_type_id__once;
}

static inline gpointer
search_condition_date_get_instance_private (SearchConditionDate* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionDate_private_offset);
}

gchar*
search_condition_date_context_to_string (SearchConditionDateContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_DATE_CONTEXT_EXACT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("EXACT");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_AFTER:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("AFTER");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_BEFORE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("BEFORE");
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_BETWEEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("BETWEEN");
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("IS_NOT_SET");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:663: unrecognized date search context enumeration v" \
"alue");
		}
	}
}

SearchConditionDateContext
search_condition_date_context_from_string (const gchar* str)
{
	SearchConditionDateContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "EXACT") == 0) {
		result = SEARCH_CONDITION_DATE_CONTEXT_EXACT;
		return result;
	}
	if (g_strcmp0 (str, "AFTER") == 0) {
		result = SEARCH_CONDITION_DATE_CONTEXT_AFTER;
		return result;
	} else {
		if (g_strcmp0 (str, "BEFORE") == 0) {
			result = SEARCH_CONDITION_DATE_CONTEXT_BEFORE;
			return result;
		} else {
			if (g_strcmp0 (str, "BETWEEN") == 0) {
				result = SEARCH_CONDITION_DATE_CONTEXT_BETWEEN;
				return result;
			} else {
				if (g_strcmp0 (str, "IS_NOT_SET") == 0) {
					result = SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET;
					return result;
				} else {
					g_error ("SearchBoolean.vala:684: unrecognized date search context name: %s", str);
				}
			}
		}
	}
}

static GType
search_condition_date_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_DATE_CONTEXT_EXACT, "SEARCH_CONDITION_DATE_CONTEXT_EXACT", "exact"}, {SEARCH_CONDITION_DATE_CONTEXT_AFTER, "SEARCH_CONDITION_DATE_CONTEXT_AFTER", "after"}, {SEARCH_CONDITION_DATE_CONTEXT_BEFORE, "SEARCH_CONDITION_DATE_CONTEXT_BEFORE", "before"}, {SEARCH_CONDITION_DATE_CONTEXT_BETWEEN, "SEARCH_CONDITION_DATE_CONTEXT_BETWEEN", "between"}, {SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET, "SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET", "is-not-set"}, {0, NULL, NULL}};
	GType search_condition_date_context_type_id;
	search_condition_date_context_type_id = g_enum_register_static ("SearchConditionDateContext", values);
	return search_condition_date_context_type_id;
}

GType
search_condition_date_context_get_type (void)
{
	static volatile gsize search_condition_date_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_date_context_type_id__once)) {
		GType search_condition_date_context_type_id;
		search_condition_date_context_type_id = search_condition_date_context_get_type_once ();
		g_once_init_leave (&search_condition_date_context_type_id__once, search_condition_date_context_type_id);
	}
	return search_condition_date_context_type_id__once;
}

SearchConditionDate*
search_condition_date_construct (GType object_type,
                                 SearchConditionSearchType search_type,
                                 SearchConditionDateContext context,
                                 GDateTime* date_one,
                                 GDateTime* date_two)
{
	SearchConditionDate* self = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (date_one != NULL, NULL);
	g_return_val_if_fail (date_two != NULL, NULL);
	self = (SearchConditionDate*) search_condition_construct (object_type);
	search_condition_set_search_type ((SearchCondition*) self, search_type);
	search_condition_date_set_context (self, context);
	if (context != SEARCH_CONDITION_DATE_CONTEXT_BETWEEN) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_date_time_compare (date_two, date_one) >= 1;
	}
	if (_tmp0_) {
		search_condition_date_set_date_one (self, date_one);
		search_condition_date_set_date_two (self, date_two);
	} else {
		search_condition_date_set_date_one (self, date_two);
		search_condition_date_set_date_two (self, date_one);
	}
	return self;
}

SearchConditionDate*
search_condition_date_new (SearchConditionSearchType search_type,
                           SearchConditionDateContext context,
                           GDateTime* date_one,
                           GDateTime* date_two)
{
	return search_condition_date_construct (TYPE_SEARCH_CONDITION_DATE, search_type, context, date_one, date_two);
}

static gboolean
search_condition_date_real_predicate (SearchCondition* base,
                                      MediaSource* source)
{
	SearchConditionDate * self;
	gint64 exposure_time = 0LL;
	GDateTime* dt = NULL;
	GDateTime* _tmp1_;
	SearchConditionDateContext _tmp2_;
	gboolean result;
	self = (SearchConditionDate*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	exposure_time = media_source_get_exposure_time (source);
	if (exposure_time == ((gint64) 0)) {
		SearchConditionDateContext _tmp0_;
		_tmp0_ = self->priv->_context;
		result = _tmp0_ == SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET;
		return result;
	}
	_tmp1_ = g_date_time_new_from_unix_local (exposure_time);
	dt = _tmp1_;
	_tmp2_ = self->priv->_context;
	switch (_tmp2_) {
		case SEARCH_CONDITION_DATE_CONTEXT_EXACT:
		{
			GDateTime* second = NULL;
			GDateTime* _tmp3_;
			GDateTime* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GDateTime* _tmp6_;
			GDateTime* _tmp7_;
			_tmp3_ = self->priv->_date_one;
			_tmp4_ = g_date_time_add_days (_tmp3_, 1);
			second = _tmp4_;
			_tmp6_ = dt;
			_tmp7_ = self->priv->_date_one;
			if (g_date_time_compare (_tmp6_, _tmp7_) >= 0) {
				GDateTime* _tmp8_;
				GDateTime* _tmp9_;
				_tmp8_ = dt;
				_tmp9_ = second;
				_tmp5_ = g_date_time_compare (_tmp8_, _tmp9_) < 0;
			} else {
				_tmp5_ = FALSE;
			}
			result = _tmp5_;
			_g_date_time_unref0 (second);
			_g_date_time_unref0 (dt);
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_AFTER:
		{
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			_tmp10_ = dt;
			_tmp11_ = self->priv->_date_one;
			result = g_date_time_compare (_tmp10_, _tmp11_) >= 0;
			_g_date_time_unref0 (dt);
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_BEFORE:
		{
			GDateTime* _tmp12_;
			GDateTime* _tmp13_;
			_tmp12_ = dt;
			_tmp13_ = self->priv->_date_one;
			result = g_date_time_compare (_tmp12_, _tmp13_) <= 0;
			_g_date_time_unref0 (dt);
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_BETWEEN:
		{
			GDateTime* second = NULL;
			GDateTime* _tmp14_;
			GDateTime* _tmp15_;
			gboolean _tmp16_ = FALSE;
			GDateTime* _tmp17_;
			GDateTime* _tmp18_;
			_tmp14_ = self->priv->_date_two;
			_tmp15_ = g_date_time_add_days (_tmp14_, 1);
			second = _tmp15_;
			_tmp17_ = dt;
			_tmp18_ = self->priv->_date_one;
			if (g_date_time_compare (_tmp17_, _tmp18_) >= 0) {
				GDateTime* _tmp19_;
				GDateTime* _tmp20_;
				_tmp19_ = dt;
				_tmp20_ = second;
				_tmp16_ = g_date_time_compare (_tmp19_, _tmp20_) < 0;
			} else {
				_tmp16_ = FALSE;
			}
			result = _tmp16_;
			_g_date_time_unref0 (second);
			_g_date_time_unref0 (dt);
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET:
		{
			result = FALSE;
			_g_date_time_unref0 (dt);
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:744: unrecognized date search context enumeration v" \
"alue");
		}
	}
}

GDateTime*
search_condition_date_get_date_one (SearchConditionDate* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date_one;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
search_condition_date_set_date_one (SearchConditionDate* self,
                                    GDateTime* value)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_date_one);
	self->priv->_date_one = _tmp0_;
}

GDateTime*
search_condition_date_get_date_two (SearchConditionDate* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date_two;
	result = _tmp0_;
	return result;
}

static void
search_condition_date_set_date_two (SearchConditionDate* self,
                                    GDateTime* value)
{
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_date_two);
	self->priv->_date_two = _tmp0_;
}

SearchConditionDateContext
search_condition_date_get_context (SearchConditionDate* self)
{
	SearchConditionDateContext result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_date_set_context (SearchConditionDate* self,
                                   SearchConditionDateContext value)
{
	g_return_if_fail (self != NULL);
	self->priv->_context = value;
}

static void
search_condition_date_class_init (SearchConditionDateClass * klass,
                                  gpointer klass_data)
{
	search_condition_date_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_date_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionDate_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_date_real_predicate;
}

static void
search_condition_date_instance_init (SearchConditionDate * self,
                                     gpointer klass)
{
	self->priv = search_condition_date_get_instance_private (self);
}

static void
search_condition_date_finalize (SearchCondition * obj)
{
	SearchConditionDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_DATE, SearchConditionDate);
	_g_date_time_unref0 (self->priv->_date_one);
	_g_date_time_unref0 (self->priv->_date_two);
	SEARCH_CONDITION_CLASS (search_condition_date_parent_class)->finalize (obj);
}

static GType
search_condition_date_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionDate), 0, (GInstanceInitFunc) search_condition_date_instance_init, NULL };
	GType search_condition_date_type_id;
	search_condition_date_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionDate", &g_define_type_info, 0);
	SearchConditionDate_private_offset = g_type_add_instance_private (search_condition_date_type_id, sizeof (SearchConditionDatePrivate));
	return search_condition_date_type_id;
}

GType
search_condition_date_get_type (void)
{
	static volatile gsize search_condition_date_type_id__once = 0;
	if (g_once_init_enter (&search_condition_date_type_id__once)) {
		GType search_condition_date_type_id;
		search_condition_date_type_id = search_condition_date_get_type_once ();
		g_once_init_leave (&search_condition_date_type_id__once, search_condition_date_type_id);
	}
	return search_condition_date_type_id__once;
}

static inline gpointer
saved_search_get_instance_private (SavedSearch* self)
{
	return G_STRUCT_MEMBER_P (self, SavedSearch_private_offset);
}

static gpointer
_saved_search_row_ref0 (gpointer self)
{
	return self ? saved_search_row_ref (self) : NULL;
}

SavedSearch*
saved_search_construct (GType object_type,
                        SavedSearchRow* row,
                        gint64 object_id)
{
	SavedSearch * self = NULL;
	SavedSearchRow* _tmp0_;
	g_return_val_if_fail (row != NULL, NULL);
	self = (SavedSearch*) data_source_construct (object_type, object_id);
	_tmp0_ = _saved_search_row_ref0 (row);
	_saved_search_row_unref0 (self->priv->row);
	self->priv->row = _tmp0_;
	return self;
}

SavedSearch*
saved_search_new (SavedSearchRow* row,
                  gint64 object_id)
{
	return saved_search_construct (TYPE_SAVED_SEARCH, row, object_id);
}

static gchar*
saved_search_real_get_name (DataObject* base)
{
	SavedSearch * self;
	SavedSearchRow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (SavedSearch*) base;
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
saved_search_real_to_string (DataObject* base)
{
	SavedSearch * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (SavedSearch*) base;
	_tmp0_ = data_object_get_name ((DataObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("SavedSearch ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gchar*
saved_search_real_get_typename (DataSource* base)
{
	SavedSearch * self;
	gchar* _tmp0_;
	gchar* result;
	self = (SavedSearch*) base;
	_tmp0_ = g_strdup (SAVED_SEARCH_TYPENAME);
	result = _tmp0_;
	return result;
}

void
saved_search_get_saved_search_id (SavedSearch* self,
                                  SavedSearchID* result)
{
	SavedSearchRow* _tmp0_;
	SavedSearchID _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->search_id;
	*result = _tmp1_;
	return;
}

static gint64
saved_search_real_get_instance_id (DataSource* base)
{
	SavedSearch * self;
	SavedSearchID _tmp0_ = {0};
	gint64 result;
	self = (SavedSearch*) base;
	saved_search_get_saved_search_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

gint
saved_search_compare_names (void* a,
                            void* b)
{
	SavedSearch* asearch = NULL;
	SavedSearch* bsearch = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	asearch = (SavedSearch*) a;
	bsearch = (SavedSearch*) b;
	_tmp0_ = data_object_get_name ((DataObject*) asearch);
	_tmp1_ = data_object_get_name ((DataObject*) bsearch);
	result = string_collated_compare (_tmp0_, _tmp1_);
	return result;
}

gboolean
saved_search_predicate (SavedSearch* self,
                        MediaSource* source)
{
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	SavedSearchRow* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp1_ = self->priv->row;
	if (SEARCH_OPERATOR_ALL == _tmp1_->operator) {
		_tmp0_ = TRUE;
	} else {
		SavedSearchRow* _tmp2_;
		_tmp2_ = self->priv->row;
		_tmp0_ = SEARCH_OPERATOR_NONE == _tmp2_->operator;
	}
	if (_tmp0_) {
		ret = TRUE;
	} else {
		ret = FALSE;
	}
	{
		GeeList* _c_list = NULL;
		SavedSearchRow* _tmp3_;
		GeeList* _tmp4_;
		gint _c_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _c_index = 0;
		_tmp3_ = self->priv->row;
		_tmp4_ = _tmp3_->conditions;
		_c_list = _tmp4_;
		_tmp5_ = _c_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_c_size = _tmp7_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			SearchCondition* c = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			SavedSearchRow* _tmp12_;
			_c_index = _c_index + 1;
			_tmp8_ = _c_index;
			_tmp9_ = _c_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _c_list;
			_tmp11_ = gee_list_get (_tmp10_, _c_index);
			c = (SearchCondition*) _tmp11_;
			_tmp12_ = self->priv->row;
			if (SEARCH_OPERATOR_ALL == _tmp12_->operator) {
				SearchCondition* _tmp13_;
				_tmp13_ = c;
				ret &= search_condition_predicate (_tmp13_, source);
			} else {
				SavedSearchRow* _tmp14_;
				_tmp14_ = self->priv->row;
				if (SEARCH_OPERATOR_ANY == _tmp14_->operator) {
					SearchCondition* _tmp15_;
					_tmp15_ = c;
					ret |= search_condition_predicate (_tmp15_, source);
				} else {
					SavedSearchRow* _tmp16_;
					_tmp16_ = self->priv->row;
					if (SEARCH_OPERATOR_NONE == _tmp16_->operator) {
						SearchCondition* _tmp17_;
						_tmp17_ = c;
						ret &= !search_condition_predicate (_tmp17_, source);
					}
				}
			}
			_search_condition_unref0 (c);
		}
	}
	result = ret;
	return result;
}

void
saved_search_reconstitute (SavedSearch* self)
{
	SavedSearchTable* _tmp8_;
	SavedSearchTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		SavedSearchID _tmp0_ = {0};
		SavedSearchDBTable* _tmp1_;
		SavedSearchDBTable* _tmp2_;
		SavedSearchRow* _tmp3_;
		SavedSearchID _tmp4_ = {0};
		SavedSearchID _tmp5_;
		SavedSearchRow* _tmp6_;
		_tmp1_ = saved_search_db_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->row;
		saved_search_db_table_create_from_row (_tmp2_, _tmp3_, &_tmp4_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = self->priv->row;
		_tmp6_->search_id = _tmp0_;
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		app_window_database_error (_tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = saved_search_table_get_instance ();
	_tmp9_ = _tmp8_;
	saved_search_table_add_to_map (_tmp9_, self);
	_saved_search_table_unref0 (_tmp9_);
	_tmp10_ = data_object_to_string ((DataObject*) self);
	_tmp11_ = _tmp10_;
	g_debug ("SearchBoolean.vala:816: Reconstituted %s", _tmp11_);
	_g_free0 (_tmp11_);
}

gboolean
saved_search_rename (SavedSearch* self,
                     const gchar* new_name)
{
	SavedSearchTable* _tmp0_;
	SavedSearchTable* _tmp1_;
	gboolean _tmp2_;
	SavedSearchTable* _tmp10_;
	SavedSearchTable* _tmp11_;
	SavedSearchRow* _tmp12_;
	gchar* _tmp13_;
	SavedSearchTable* _tmp14_;
	SavedSearchTable* _tmp15_;
	LibraryWindow* _tmp16_;
	LibraryWindow* _tmp17_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_name != NULL, FALSE);
	if (is_string_empty (new_name)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = saved_search_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = saved_search_table_exists (_tmp1_, new_name);
	_saved_search_table_unref0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	{
		SavedSearchDBTable* _tmp3_;
		SavedSearchDBTable* _tmp4_;
		SavedSearchRow* _tmp5_;
		SavedSearchID _tmp6_;
		_tmp3_ = saved_search_db_table_get_instance ();
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->row;
		_tmp6_ = _tmp5_->search_id;
		saved_search_db_table_rename (_tmp4_, &_tmp6_, new_name, &_inner_error0_);
		_database_table_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		app_window_database_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = saved_search_table_get_instance ();
	_tmp11_ = _tmp10_;
	saved_search_table_remove_from_map (_tmp11_, self);
	_saved_search_table_unref0 (_tmp11_);
	_tmp12_ = self->priv->row;
	_tmp13_ = g_strdup (new_name);
	_g_free0 (_tmp12_->name);
	_tmp12_->name = _tmp13_;
	_tmp14_ = saved_search_table_get_instance ();
	_tmp15_ = _tmp14_;
	saved_search_table_add_to_map (_tmp15_, self);
	_saved_search_table_unref0 (_tmp15_);
	_tmp16_ = library_window_get_app ();
	_tmp17_ = _tmp16_;
	library_window_switch_to_saved_search (_tmp17_, self);
	_g_object_unref0 (_tmp17_);
	result = TRUE;
	return result;
}

GeeList*
saved_search_get_conditions (SavedSearch* self)
{
	SavedSearchRow* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->conditions;
	_tmp2_ = gee_list_get_read_only_view (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

SearchOperator
saved_search_get_operator (SavedSearch* self)
{
	SavedSearchRow* _tmp0_;
	SearchOperator result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->row;
	result = _tmp0_->operator;
	return result;
}

static void
saved_search_class_init (SavedSearchClass * klass,
                         gpointer klass_data)
{
	saved_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SavedSearch_private_offset);
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) saved_search_real_get_name;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) saved_search_real_to_string;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) saved_search_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) saved_search_real_get_instance_id;
	G_OBJECT_CLASS (klass)->finalize = saved_search_finalize;
}

static void
saved_search_instance_init (SavedSearch * self,
                            gpointer klass)
{
	self->priv = saved_search_get_instance_private (self);
}

static void
saved_search_finalize (GObject * obj)
{
	SavedSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH, SavedSearch);
	_saved_search_row_unref0 (self->priv->row);
	G_OBJECT_CLASS (saved_search_parent_class)->finalize (obj);
}

static GType
saved_search_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SavedSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearch), 0, (GInstanceInitFunc) saved_search_instance_init, NULL };
	GType saved_search_type_id;
	saved_search_type_id = g_type_register_static (TYPE_DATA_SOURCE, "SavedSearch", &g_define_type_info, 0);
	SavedSearch_private_offset = g_type_add_instance_private (saved_search_type_id, sizeof (SavedSearchPrivate));
	return saved_search_type_id;
}

GType
saved_search_get_type (void)
{
	static volatile gsize saved_search_type_id__once = 0;
	if (g_once_init_enter (&saved_search_type_id__once)) {
		GType saved_search_type_id;
		saved_search_type_id = saved_search_get_type_once ();
		g_once_init_leave (&saved_search_type_id__once, saved_search_type_id);
	}
	return saved_search_type_id__once;
}

static inline gpointer
saved_search_table_get_instance_private (SavedSearchTable* self)
{
	return G_STRUCT_MEMBER_P (self, SavedSearchTable_private_offset);
}

static SavedSearchTable*
saved_search_table_construct (GType object_type)
{
	SavedSearchTable* self = NULL;
	GError* _inner_error0_ = NULL;
	self = (SavedSearchTable*) g_type_create_instance (object_type);
	{
		GeeList* _tmp0_ = NULL;
		SavedSearchDBTable* _tmp1_;
		SavedSearchDBTable* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		_tmp1_ = saved_search_db_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = saved_search_db_table_get_all_rows (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			GeeList* _row_list = NULL;
			gint _row_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _row_index = 0;
			_row_list = _tmp0_;
			_tmp5_ = _row_list;
			_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_row_size = _tmp7_;
			_row_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				SavedSearchRow* row = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				SavedSearchRow* _tmp12_;
				SavedSearch* _tmp13_;
				SavedSearch* _tmp14_;
				_row_index = _row_index + 1;
				_tmp8_ = _row_index;
				_tmp9_ = _row_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _row_list;
				_tmp11_ = gee_list_get (_tmp10_, _row_index);
				row = (SavedSearchRow*) _tmp11_;
				_tmp12_ = row;
				_tmp13_ = saved_search_new (_tmp12_, DATA_OBJECT_INVALID_OBJECT_ID);
				_tmp14_ = _tmp13_;
				saved_search_table_add_to_map (self, _tmp14_);
				_g_object_unref0 (_tmp14_);
				_saved_search_row_unref0 (row);
			}
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = err;
		app_window_database_error (_tmp15_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

static SavedSearchTable*
saved_search_table_new (void)
{
	return saved_search_table_construct (TYPE_SAVED_SEARCH_TABLE);
}

static gpointer
_saved_search_table_ref0 (gpointer self)
{
	return self ? saved_search_table_ref (self) : NULL;
}

SavedSearchTable*
saved_search_table_get_instance (void)
{
	SavedSearchTable* _tmp0_;
	SavedSearchTable* _tmp2_;
	SavedSearchTable* _tmp3_;
	SavedSearchTable* result;
	_tmp0_ = saved_search_table_instance;
	if (_tmp0_ == NULL) {
		SavedSearchTable* _tmp1_;
		_tmp1_ = saved_search_table_new ();
		_saved_search_table_unref0 (saved_search_table_instance);
		saved_search_table_instance = _tmp1_;
	}
	_tmp2_ = saved_search_table_instance;
	_tmp3_ = _saved_search_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GeeCollection*
saved_search_table_get_all (SavedSearchTable* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->search_map;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

SavedSearch*
saved_search_table_create (SavedSearchTable* self,
                           const gchar* name,
                           SearchOperator operator,
                           GeeArrayList* conditions)
{
	SavedSearch* search = NULL;
	SavedSearch* _tmp7_;
	LibraryWindow* _tmp8_;
	LibraryWindow* _tmp9_;
	SavedSearch* _tmp10_;
	GError* _inner_error0_ = NULL;
	SavedSearch* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (conditions != NULL, NULL);
	search = NULL;
	{
		SavedSearchRow* _tmp0_ = NULL;
		SavedSearchDBTable* _tmp1_;
		SavedSearchDBTable* _tmp2_;
		SavedSearchRow* _tmp3_;
		SavedSearchRow* _tmp4_;
		SavedSearch* _tmp5_;
		_tmp1_ = saved_search_db_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = saved_search_db_table_add (_tmp2_, name, operator, conditions, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (search);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = saved_search_new (_tmp0_, DATA_OBJECT_INVALID_OBJECT_ID);
		_g_object_unref0 (search);
		search = _tmp5_;
		_saved_search_row_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		app_window_database_error (_tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (search);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp7_ = search;
	saved_search_table_add_to_map (self, _tmp7_);
	_tmp8_ = library_window_get_app ();
	_tmp9_ = _tmp8_;
	_tmp10_ = search;
	library_window_switch_to_saved_search (_tmp9_, _tmp10_);
	_g_object_unref0 (_tmp9_);
	result = search;
	return result;
}

void
saved_search_table_remove (SavedSearchTable* self,
                           SavedSearch* search)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	{
		SavedSearchDBTable* _tmp0_;
		SavedSearchDBTable* _tmp1_;
		SavedSearchID _tmp2_ = {0};
		_tmp0_ = saved_search_db_table_get_instance ();
		_tmp1_ = _tmp0_;
		saved_search_get_saved_search_id (search, &_tmp2_);
		saved_search_db_table_remove (_tmp1_, &_tmp2_, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		app_window_database_error (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	saved_search_table_remove_from_map (self, search);
}

void
saved_search_table_add_to_map (SavedSearchTable* self,
                               SavedSearch* search)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = self->priv->search_map;
	_tmp1_ = data_object_get_name ((DataObject*) search);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, search);
	_g_free0 (_tmp2_);
	g_signal_emit (self, saved_search_table_signals[SAVED_SEARCH_TABLE_SEARCH_ADDED_SIGNAL], 0, search);
}

void
saved_search_table_remove_from_map (SavedSearchTable* self,
                                    SavedSearch* search)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = self->priv->search_map;
	_tmp1_ = data_object_get_name ((DataObject*) search);
	_tmp2_ = _tmp1_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp2_, NULL);
	_g_free0 (_tmp2_);
	g_signal_emit (self, saved_search_table_signals[SAVED_SEARCH_TABLE_SEARCH_REMOVED_SIGNAL], 0, search);
}

GeeIterable*
saved_search_table_get_saved_searches (SavedSearchTable* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->search_map;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeIterable*) _tmp2_;
	return result;
}

gint
saved_search_table_get_count (SavedSearchTable* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->search_map;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
saved_search_table_exists (SavedSearchTable* self,
                           const gchar* search_name)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (search_name != NULL, FALSE);
	_tmp0_ = self->priv->search_map;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, search_name);
	return result;
}

gchar*
saved_search_table_generate_unique_name (SavedSearchTable* self)
{
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint ctr = 0;
		ctr = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* name = NULL;
				gchar* _tmp2_;
				const gchar* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(ctr < G_MAXINT)) {
					break;
				}
				_tmp2_ = g_strdup_printf ("%s %d", RESOURCES_DEFAULT_SAVED_SEARCH_NAME, ctr);
				name = _tmp2_;
				_tmp3_ = name;
				if (!saved_search_table_exists (self, _tmp3_)) {
					result = name;
					return result;
				}
				_g_free0 (name);
			}
		}
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

static void
value_saved_search_table_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_saved_search_table_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		saved_search_table_unref (value->data[0].v_pointer);
	}
}

static void
value_saved_search_table_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = saved_search_table_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_saved_search_table_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_saved_search_table_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SavedSearchTable * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = saved_search_table_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_saved_search_table_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	SavedSearchTable ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = saved_search_table_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_saved_search_table (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecSavedSearchTable* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SAVED_SEARCH_TABLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_saved_search_table (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_saved_search_table (GValue* value,
                              gpointer v_object)
{
	SavedSearchTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		saved_search_table_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		saved_search_table_unref (old);
	}
}

void
value_take_saved_search_table (GValue* value,
                               gpointer v_object)
{
	SavedSearchTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		saved_search_table_unref (old);
	}
}

static void
saved_search_table_class_init (SavedSearchTableClass * klass,
                               gpointer klass_data)
{
	saved_search_table_parent_class = g_type_class_peek_parent (klass);
	((SavedSearchTableClass *) klass)->finalize = saved_search_table_finalize;
	g_type_class_adjust_private_offset (klass, &SavedSearchTable_private_offset);
	saved_search_table_signals[SAVED_SEARCH_TABLE_SEARCH_ADDED_SIGNAL] = g_signal_new ("search-added", TYPE_SAVED_SEARCH_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SAVED_SEARCH);
	saved_search_table_signals[SAVED_SEARCH_TABLE_SEARCH_REMOVED_SIGNAL] = g_signal_new ("search-removed", TYPE_SAVED_SEARCH_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SAVED_SEARCH);
}

static void
saved_search_table_instance_init (SavedSearchTable * self,
                                  gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = saved_search_table_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_SAVED_SEARCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->search_map = _tmp0_;
	self->ref_count = 1;
}

static void
saved_search_table_finalize (SavedSearchTable * obj)
{
	SavedSearchTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_TABLE, SavedSearchTable);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->search_map);
}

static GType
saved_search_table_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_saved_search_table_init, value_saved_search_table_free_value, value_saved_search_table_copy_value, value_saved_search_table_peek_pointer, "p", value_saved_search_table_collect_value, "p", value_saved_search_table_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SavedSearchTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchTable), 0, (GInstanceInitFunc) saved_search_table_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType saved_search_table_type_id;
	saved_search_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SavedSearchTable", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SavedSearchTable_private_offset = g_type_add_instance_private (saved_search_table_type_id, sizeof (SavedSearchTablePrivate));
	return saved_search_table_type_id;
}

GType
saved_search_table_get_type (void)
{
	static volatile gsize saved_search_table_type_id__once = 0;
	if (g_once_init_enter (&saved_search_table_type_id__once)) {
		GType saved_search_table_type_id;
		saved_search_table_type_id = saved_search_table_get_type_once ();
		g_once_init_leave (&saved_search_table_type_id__once, saved_search_table_type_id);
	}
	return saved_search_table_type_id__once;
}

gpointer
saved_search_table_ref (gpointer instance)
{
	SavedSearchTable * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
saved_search_table_unref (gpointer instance)
{
	SavedSearchTable * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SAVED_SEARCH_TABLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

