/* MainWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2011-2025 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Maxwell Barvian <maxwell@elementary.io>
 *              Corentin Noël <corentin@elementary.io>
 */

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <granite.h>
#include <libecal/libecal.h>
#include "elementary-calendar.h"
#include <libedataserver/libedataserver.h>
#include <cairo-gobject.h>

#define MAYA_MAIN_WINDOW_ACTION_PREFIX "win."
#define MAYA_MAIN_WINDOW_ACTION_NEW_EVENT "action_new_event"
#define MAYA_MAIN_WINDOW_ACTION_SHOW_TODAY "action_show_today"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_TYPE_MAIN_WINDOW (maya_main_window_get_type ())
#define MAYA_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindow))
#define MAYA_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))
#define MAYA_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))

typedef struct _MayaMainWindow MayaMainWindow;
typedef struct _MayaMainWindowClass MayaMainWindowClass;
typedef struct _MayaMainWindowPrivate MayaMainWindowPrivate;

#define MAYA_VIEW_TYPE_CALENDAR_VIEW (maya_view_calendar_view_get_type ())
#define MAYA_VIEW_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView))
#define MAYA_VIEW_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))
#define MAYA_VIEW_IS_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_IS_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_CALENDAR_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))

typedef struct _MayaViewCalendarView MayaViewCalendarView;
typedef struct _MayaViewCalendarViewClass MayaViewCalendarViewClass;
enum  {
	MAYA_MAIN_WINDOW_0_PROPERTY,
	MAYA_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* maya_main_window_properties[MAYA_MAIN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MAYA_VIEW_TYPE_EVENT_DIALOG (maya_view_event_dialog_get_type ())
#define MAYA_VIEW_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialog))
#define MAYA_VIEW_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))
#define MAYA_VIEW_IS_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_IS_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_EVENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))

typedef struct _MayaViewEventDialog MayaViewEventDialog;
typedef struct _MayaViewEventDialogClass MayaViewEventDialogClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))

#define MAYA_TYPE_APPLICATION (maya_application_get_type ())
#define MAYA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_APPLICATION, MayaApplication))
#define MAYA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_APPLICATION, MayaApplicationClass))
#define MAYA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_APPLICATION))
#define MAYA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_APPLICATION))
#define MAYA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_APPLICATION, MayaApplicationClass))

typedef struct _MayaApplication MayaApplication;
typedef struct _MayaApplicationClass MayaApplicationClass;

#define MAYA_VIEW_TYPE_AGENDA_VIEW (maya_view_agenda_view_get_type ())
#define MAYA_VIEW_AGENDA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaView))
#define MAYA_VIEW_AGENDA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaViewClass))
#define MAYA_VIEW_IS_AGENDA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW))
#define MAYA_VIEW_IS_AGENDA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_AGENDA_VIEW))
#define MAYA_VIEW_AGENDA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaViewClass))

typedef struct _MayaViewAgendaView MayaViewAgendaView;
typedef struct _MayaViewAgendaViewClass MayaViewAgendaViewClass;
typedef struct _Block4Data Block4Data;

struct _MayaMainWindow {
	HdyApplicationWindow parent_instance;
	MayaMainWindowPrivate * priv;
	MayaViewCalendarView* calview;
};

struct _MayaMainWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _MayaMainWindowPrivate {
	guint configure_id;
};

struct _Block4Data {
	int _ref_count_;
	MayaMainWindow* self;
	MayaViewAgendaView* sidebar;
};

static gint MayaMainWindow_private_offset;
static gpointer maya_main_window_parent_class = NULL;
static GeeMultiMap* maya_main_window_action_accelerators;
static GeeMultiMap* maya_main_window_action_accelerators = NULL;
VALA_EXTERN GSettings* maya_application_saved_state;

VALA_EXTERN GType maya_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaMainWindow, g_object_unref)
VALA_EXTERN GType maya_view_calendar_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewCalendarView, g_object_unref)
static void maya_main_window_action_new_event (MayaMainWindow* self);
static void _maya_main_window_action_new_event_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void maya_main_window_action_show_today (MayaMainWindow* self);
static void _maya_main_window_action_show_today_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
VALA_EXTERN MayaMainWindow* maya_main_window_new (GtkApplication* application);
VALA_EXTERN MayaMainWindow* maya_main_window_construct (GType object_type,
                                            GtkApplication* application);
VALA_EXTERN void maya_main_window_on_tb_add_clicked (MayaMainWindow* self,
                                         GDateTime* dt);
VALA_EXTERN GType maya_view_event_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventDialog, g_object_unref)
VALA_EXTERN MayaViewEventDialog* maya_view_event_dialog_new (ECalComponent* ecal,
                                                 GDateTime* date_time,
                                                 GtkWindow* parent);
VALA_EXTERN MayaViewEventDialog* maya_view_event_dialog_construct (GType object_type,
                                                       ECalComponent* ecal,
                                                       GDateTime* date_time,
                                                       GtkWindow* parent);
VALA_EXTERN GDateTime* maya_view_calendar_view_get_selected_date (MayaViewCalendarView* self);
VALA_EXTERN void maya_view_calendar_view_today (MayaViewCalendarView* self);
static void maya_main_window_on_remove (MayaMainWindow* self,
                                 ECalComponent* comp);
VALA_EXTERN void maya_main_window_on_modified (MayaMainWindow* self,
                                   ECalComponent* comp);
VALA_EXTERN void maya_main_window_on_duplicated (MayaMainWindow* self,
                                     ECalComponent* comp);
static void _vala_ECalComponentId_free (ECalComponentId* self);
static gboolean maya_main_window_real_configure_event (GtkWidget* base,
                                                GdkEventConfigure* event);
static gboolean __lambda190_ (MayaMainWindow* self);
static gboolean ___lambda190__gsource_func (gpointer self);
static gboolean maya_main_window_real_delete_event (GtkWidget* base,
                                             GdkEventAny* event);
VALA_EXTERN GType maya_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaApplication, g_object_unref)
VALA_EXTERN void maya_application_ask_for_background (MayaApplication* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN gboolean maya_application_ask_for_background_finish (MayaApplication* self,
                                                     GAsyncResult* _res_);
static void __lambda191_ (MayaMainWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda191__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static GObject * maya_main_window_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
VALA_EXTERN GType maya_view_agenda_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewAgendaView, g_object_unref)
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN MayaViewCalendarView* maya_view_calendar_view_new (void);
VALA_EXTERN MayaViewCalendarView* maya_view_calendar_view_construct (GType object_type);
VALA_EXTERN MayaViewAgendaView* maya_view_agenda_view_new (void);
VALA_EXTERN MayaViewAgendaView* maya_view_agenda_view_construct (GType object_type);
VALA_EXTERN HdyHeaderBar* maya_view_calendar_view_get_header_bar (MayaViewCalendarView* self);
VALA_EXTERN HdyHeaderBar* maya_view_agenda_view_get_header_bar (MayaViewAgendaView* self);
static void _maya_main_window___lambda192_ (MayaMainWindow* self,
                                     GDateTime* date);
static void __maya_main_window___lambda192__maya_view_calendar_view_on_event_add (MayaViewCalendarView* _sender,
                                                                           GDateTime* date,
                                                                           gpointer self);
static void _maya_main_window___lambda193_ (Block4Data* _data4_,
                                     GDateTime* date);
VALA_EXTERN void maya_view_agenda_view_set_selected_date (MayaViewAgendaView* self,
                                              GDateTime* date);
static void __maya_main_window___lambda193__maya_view_calendar_view_selection_changed (MayaViewCalendarView* _sender,
                                                                                GDateTime* new_date,
                                                                                gpointer self);
static void _maya_main_window_on_remove_maya_view_agenda_view_event_removed (MayaViewAgendaView* _sender,
                                                                      ECalComponent* event,
                                                                      gpointer self);
static void maya_main_window_finalize (GObject * obj);
static GType maya_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry MAYA_MAIN_WINDOW_ACTION_ENTRIES[2] = {{MAYA_MAIN_WINDOW_ACTION_NEW_EVENT, _maya_main_window_action_new_event_gsimple_action_activate_callback}, {MAYA_MAIN_WINDOW_ACTION_SHOW_TODAY, _maya_main_window_action_show_today_gsimple_action_activate_callback}};

static inline gpointer
maya_main_window_get_instance_private (MayaMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MayaMainWindow_private_offset);
}

static void
_maya_main_window_action_new_event_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	maya_main_window_action_new_event ((MayaMainWindow*) self);
}

static void
_maya_main_window_action_show_today_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	maya_main_window_action_show_today ((MayaMainWindow*) self);
}

MayaMainWindow*
maya_main_window_construct (GType object_type,
                            GtkApplication* application)
{
	MayaMainWindow * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (MayaMainWindow*) g_object_new (object_type, "application", application, "height-request", 400, "icon-name", "io.elementary.calendar", "width-request", 625, NULL);
	return self;
}

MayaMainWindow*
maya_main_window_new (GtkApplication* application)
{
	return maya_main_window_construct (MAYA_TYPE_MAIN_WINDOW, application);
}

void
maya_main_window_on_tb_add_clicked (MayaMainWindow* self,
                                    GDateTime* dt)
{
	MayaViewEventDialog* dialog = NULL;
	MayaViewEventDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dt != NULL);
	_tmp0_ = maya_view_event_dialog_new (NULL, dt, (GtkWindow*) self);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_window_present ((GtkWindow*) dialog);
	_g_object_unref0 (dialog);
}

static void
maya_main_window_action_new_event (MayaMainWindow* self)
{
	MayaViewCalendarView* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->calview;
	_tmp1_ = maya_view_calendar_view_get_selected_date (_tmp0_);
	_tmp2_ = _tmp1_;
	maya_main_window_on_tb_add_clicked (self, _tmp2_);
}

static void
maya_main_window_action_show_today (MayaMainWindow* self)
{
	MayaViewCalendarView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->calview;
	maya_view_calendar_view_today (_tmp0_);
}

static void
maya_main_window_on_remove (MayaMainWindow* self,
                            ECalComponent* comp)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comp != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_object_get_data ((GObject*) comp, "source");
	calendar_event_store_remove_event (_tmp1_, (ESource*) _tmp2_, comp, E_CAL_OBJ_MOD_THIS);
	_g_object_unref0 (_tmp1_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
maya_main_window_on_modified (MayaMainWindow* self,
                              ECalComponent* comp)
{
	ESource* src = NULL;
	gconstpointer _tmp0_;
	ESource* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESource* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comp != NULL);
	_tmp0_ = g_object_get_data ((GObject*) comp, "source");
	_tmp1_ = _g_object_ref0 ((ESource*) _tmp0_);
	src = _tmp1_;
	_tmp3_ = src;
	_tmp4_ = e_source_get_writable (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		CalendarEventStore* _tmp6_;
		CalendarEventStore* _tmp7_;
		ESource* _tmp8_;
		_tmp6_ = calendar_event_store_get_default ();
		_tmp7_ = _tmp6_;
		_tmp8_ = src;
		_tmp2_ = calendar_event_store_calclient_is_readonly (_tmp7_, _tmp8_) == FALSE;
		_g_object_unref0 (_tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MayaViewEventDialog* dialog = NULL;
		MayaViewEventDialog* _tmp9_;
		MayaViewEventDialog* _tmp10_;
		_tmp9_ = maya_view_event_dialog_new (comp, NULL, (GtkWindow*) self);
		g_object_ref_sink (_tmp9_);
		dialog = _tmp9_;
		_tmp10_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp10_);
		_g_object_unref0 (dialog);
	} else {
		gdk_beep ();
	}
	_g_object_unref0 (src);
}

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

void
maya_main_window_on_duplicated (MayaMainWindow* self,
                                ECalComponent* comp)
{
	ESource* src = NULL;
	gconstpointer _tmp0_;
	ESource* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESource* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comp != NULL);
	_tmp0_ = g_object_get_data ((GObject*) comp, "source");
	_tmp1_ = _g_object_ref0 ((ESource*) _tmp0_);
	src = _tmp1_;
	_tmp3_ = src;
	_tmp4_ = e_source_get_writable (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		CalendarEventStore* _tmp6_;
		CalendarEventStore* _tmp7_;
		ESource* _tmp8_;
		_tmp6_ = calendar_event_store_get_default ();
		_tmp7_ = _tmp6_;
		_tmp8_ = src;
		_tmp2_ = calendar_event_store_calclient_is_readonly (_tmp7_, _tmp8_) == FALSE;
		_g_object_unref0 (_tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ECalComponent* dup_comp = NULL;
		ECalComponent* _tmp9_;
		ECalComponent* _tmp10_;
		ECalComponentId* _tmp11_;
		ECalComponentId* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		MayaViewEventDialog* dialog = NULL;
		ECalComponent* _tmp16_;
		GtkWindow* _tmp17_;
		MayaViewEventDialog* _tmp18_ = NULL;
		MayaViewEventDialog* _tmp19_;
		_tmp9_ = maya_util_copy_ecal_component (comp);
		dup_comp = _tmp9_;
		_tmp10_ = dup_comp;
		_tmp11_ = e_cal_component_get_id (comp);
		_tmp12_ = _tmp11_;
		_tmp13_ = e_cal_component_id_get_uid (_tmp12_);
		_tmp14_ = maya_util_mangle_uid (_tmp13_);
		_tmp15_ = _tmp14_;
		e_cal_component_set_uid (_tmp10_, _tmp15_);
		_g_free0 (_tmp15_);
		__vala_ECalComponentId_free0 (_tmp12_);
		_tmp16_ = dup_comp;
		_tmp17_ = _g_object_ref0 ((GtkWindow*) self);
		_tmp18_ = maya_view_event_dialog_new (_tmp16_, NULL, (GtkWindow*) self);
		gtk_window_set_transient_for ((GtkWindow*) _tmp18_, _tmp17_);
		_g_object_unref0 (_tmp17_);
		g_object_ref_sink (_tmp18_);
		dialog = _tmp18_;
		_tmp19_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp19_);
		_g_object_unref0 (dialog);
		_g_object_unref0 (dup_comp);
	} else {
		gdk_beep ();
	}
	_g_object_unref0 (src);
}

static gboolean
__lambda190_ (MayaMainWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self->priv->configure_id = (guint) 0;
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = maya_application_saved_state;
		g_settings_set_boolean (_tmp2_, "window-maximized", TRUE);
	} else {
		GSettings* _tmp3_;
		GdkRectangle rect = {0};
		GtkAllocation _tmp4_ = {0};
		GSettings* _tmp5_;
		GdkRectangle _tmp6_;
		GdkRectangle _tmp7_;
		_tmp3_ = maya_application_saved_state;
		g_settings_set_boolean (_tmp3_, "window-maximized", FALSE);
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
		rect = _tmp4_;
		_tmp5_ = maya_application_saved_state;
		_tmp6_ = rect;
		_tmp7_ = rect;
		g_settings_set (_tmp5_, "window-size", "(ii)", _tmp6_.width, _tmp7_.height);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda190__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda190_ ((MayaMainWindow*) self);
	return result;
}

static gboolean
maya_main_window_real_configure_event (GtkWidget* base,
                                       GdkEventConfigure* event)
{
	MayaMainWindow * self;
	gboolean result;
	self = (MayaMainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->configure_id != ((guint) 0)) {
		g_source_remove (self->priv->configure_id);
	}
	self->priv->configure_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda190__gsource_func, g_object_ref (self), g_object_unref);
	result = GTK_WIDGET_CLASS (maya_main_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	return result;
}

static void
__lambda191_ (MayaMainWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	MayaApplication* app = NULL;
	MayaApplication* _tmp0_;
	g_return_if_fail (res != NULL);
	app = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_APPLICATION, MayaApplication);
	_tmp0_ = app;
	if (maya_application_ask_for_background_finish (_tmp0_, res)) {
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_destroy ((GtkWidget*) self);
	}
}

static void
___lambda191__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda191_ ((MayaMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
maya_main_window_real_delete_event (GtkWidget* base,
                                    GdkEventAny* event)
{
	MayaMainWindow * self;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gboolean result;
	self = (MayaMainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	maya_application_ask_for_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, MAYA_TYPE_APPLICATION, MayaApplication), ___lambda191__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		MayaMainWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->sidebar);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_maya_main_window___lambda192_ (MayaMainWindow* self,
                                GDateTime* date)
{
	g_return_if_fail (date != NULL);
	maya_main_window_on_tb_add_clicked (self, date);
}

static void
__maya_main_window___lambda192__maya_view_calendar_view_on_event_add (MayaViewCalendarView* _sender,
                                                                      GDateTime* date,
                                                                      gpointer self)
{
	_maya_main_window___lambda192_ ((MayaMainWindow*) self, date);
}

static void
_maya_main_window___lambda193_ (Block4Data* _data4_,
                                GDateTime* date)
{
	MayaMainWindow* self;
	MayaViewAgendaView* _tmp0_;
	self = _data4_->self;
	g_return_if_fail (date != NULL);
	_tmp0_ = _data4_->sidebar;
	maya_view_agenda_view_set_selected_date (_tmp0_, date);
}

static void
__maya_main_window___lambda193__maya_view_calendar_view_selection_changed (MayaViewCalendarView* _sender,
                                                                           GDateTime* new_date,
                                                                           gpointer self)
{
	_maya_main_window___lambda193_ (self, new_date);
}

static void
_maya_main_window_on_remove_maya_view_agenda_view_event_removed (MayaViewAgendaView* _sender,
                                                                 ECalComponent* event,
                                                                 gpointer self)
{
	maya_main_window_on_remove ((MayaMainWindow*) self, event);
}

static GObject *
maya_main_window_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaMainWindow * self;
	Block4Data* _data4_;
	MayaViewCalendarView* _tmp19_ = NULL;
	MayaViewAgendaView* _tmp20_ = NULL;
	GtkPaned* hpaned = NULL;
	GtkPaned* _tmp21_;
	GtkPaned* _tmp22_;
	MayaViewCalendarView* _tmp23_;
	GtkPaned* _tmp24_;
	MayaViewAgendaView* _tmp25_;
	GtkPaned* _tmp26_;
	HdyHeaderGroup* header_group = NULL;
	HdyHeaderGroup* _tmp27_;
	HdyHeaderGroup* _tmp28_;
	MayaViewCalendarView* _tmp29_;
	HdyHeaderBar* _tmp30_;
	HdyHeaderBar* _tmp31_;
	HdyHeaderGroup* _tmp32_;
	MayaViewAgendaView* _tmp33_;
	HdyHeaderBar* _tmp34_;
	HdyHeaderBar* _tmp35_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp36_;
	GtkSizeGroup* _tmp37_;
	MayaViewCalendarView* _tmp38_;
	HdyHeaderBar* _tmp39_;
	HdyHeaderBar* _tmp40_;
	GtkSizeGroup* _tmp41_;
	MayaViewAgendaView* _tmp42_;
	HdyHeaderBar* _tmp43_;
	HdyHeaderBar* _tmp44_;
	MayaViewCalendarView* _tmp45_;
	MayaViewCalendarView* _tmp46_;
	MayaViewAgendaView* _tmp47_;
	GSettings* _tmp48_;
	GtkPaned* _tmp49_;
	parent_class = G_OBJECT_CLASS (maya_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_MAIN_WINDOW, MayaMainWindow);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, MAYA_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (MAYA_MAIN_WINDOW_ACTION_ENTRIES), self);
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = maya_main_window_action_accelerators;
		_tmp1_ = gee_multi_map_get_keys (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_action_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gchar* action = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GApplication* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GeeMultiMap* _tmp12_;
			const gchar* _tmp13_;
			GeeCollection* _tmp14_;
			GeeCollection* _tmp15_;
			gint _tmp16_ = 0;
			gpointer* _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			_tmp5_ = _action_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _action_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			action = (gchar*) _tmp7_;
			_tmp8_ = g_application_get_default ();
			_tmp9_ = action;
			_tmp10_ = g_strconcat (MAYA_MAIN_WINDOW_ACTION_PREFIX, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = maya_main_window_action_accelerators;
			_tmp13_ = action;
			_tmp14_ = gee_multi_map_get (_tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp17_ = gee_collection_to_array (_tmp15_, &_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp18__length1 = _tmp16_;
			gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_application_get_type (), GtkApplication), _tmp11_, _tmp18_);
			_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp15_);
			_g_free0 (_tmp11_);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	_tmp19_ = maya_view_calendar_view_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp19_, TRUE);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->calview);
	self->calview = _tmp19_;
	_tmp20_ = maya_view_agenda_view_new ();
	g_object_set ((GtkWidget*) _tmp20_, "width-request", 160, NULL);
	g_object_ref_sink (_tmp20_);
	_data4_->sidebar = _tmp20_;
	_tmp21_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp21_);
	hpaned = _tmp21_;
	_tmp22_ = hpaned;
	_tmp23_ = self->calview;
	gtk_paned_pack1 (_tmp22_, (GtkWidget*) _tmp23_, TRUE, FALSE);
	_tmp24_ = hpaned;
	_tmp25_ = _data4_->sidebar;
	gtk_paned_pack2 (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE);
	_tmp26_ = hpaned;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp26_, NULL);
	_tmp27_ = hdy_header_group_new ();
	header_group = _tmp27_;
	_tmp28_ = header_group;
	_tmp29_ = self->calview;
	_tmp30_ = maya_view_calendar_view_get_header_bar (_tmp29_);
	_tmp31_ = _tmp30_;
	hdy_header_group_add_header_bar (_tmp28_, _tmp31_);
	_tmp32_ = header_group;
	_tmp33_ = _data4_->sidebar;
	_tmp34_ = maya_view_agenda_view_get_header_bar (_tmp33_);
	_tmp35_ = _tmp34_;
	hdy_header_group_add_header_bar (_tmp32_, _tmp35_);
	_tmp36_ = gtk_size_group_new (GTK_SIZE_GROUP_VERTICAL);
	size_group = _tmp36_;
	_tmp37_ = size_group;
	_tmp38_ = self->calview;
	_tmp39_ = maya_view_calendar_view_get_header_bar (_tmp38_);
	_tmp40_ = _tmp39_;
	gtk_size_group_add_widget (_tmp37_, (GtkWidget*) _tmp40_);
	_tmp41_ = size_group;
	_tmp42_ = _data4_->sidebar;
	_tmp43_ = maya_view_agenda_view_get_header_bar (_tmp42_);
	_tmp44_ = _tmp43_;
	gtk_size_group_add_widget (_tmp41_, (GtkWidget*) _tmp44_);
	_tmp45_ = self->calview;
	g_signal_connect_object (_tmp45_, "on-event-add", (GCallback) __maya_main_window___lambda192__maya_view_calendar_view_on_event_add, self, 0);
	_tmp46_ = self->calview;
	g_signal_connect_data (_tmp46_, "selection-changed", (GCallback) __maya_main_window___lambda193__maya_view_calendar_view_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp47_ = _data4_->sidebar;
	g_signal_connect_object (_tmp47_, "event-removed", (GCallback) _maya_main_window_on_remove_maya_view_agenda_view_event_removed, self, 0);
	_tmp48_ = maya_application_saved_state;
	_tmp49_ = hpaned;
	g_settings_bind (_tmp48_, "hpaned-position", (GObject*) _tmp49_, "position", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (size_group);
	_g_object_unref0 (header_group);
	_g_object_unref0 (hpaned);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
maya_main_window_class_init (MayaMainWindowClass * klass,
                             gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	maya_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaMainWindow_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) maya_main_window_real_configure_event;
	((GtkWidgetClass *) klass)->delete_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) maya_main_window_real_delete_event;
	G_OBJECT_CLASS (klass)->constructor = maya_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_main_window_finalize;
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	maya_main_window_action_accelerators = (GeeMultiMap*) _tmp0_;
	_tmp1_ = maya_main_window_action_accelerators;
	gee_multi_map_set (_tmp1_, MAYA_MAIN_WINDOW_ACTION_NEW_EVENT, "<Control>n");
	_tmp2_ = maya_main_window_action_accelerators;
	gee_multi_map_set (_tmp2_, MAYA_MAIN_WINDOW_ACTION_SHOW_TODAY, "<Control>t");
}

static void
maya_main_window_instance_init (MayaMainWindow * self,
                                gpointer klass)
{
	self->priv = maya_main_window_get_instance_private (self);
}

static void
maya_main_window_finalize (GObject * obj)
{
	MayaMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_MAIN_WINDOW, MayaMainWindow);
	_g_object_unref0 (self->calview);
	G_OBJECT_CLASS (maya_main_window_parent_class)->finalize (obj);
}

static GType
maya_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaMainWindow), 0, (GInstanceInitFunc) maya_main_window_instance_init, NULL };
	GType maya_main_window_type_id;
	maya_main_window_type_id = g_type_register_static (hdy_application_window_get_type (), "MayaMainWindow", &g_define_type_info, 0);
	MayaMainWindow_private_offset = g_type_add_instance_private (maya_main_window_type_id, sizeof (MayaMainWindowPrivate));
	return maya_main_window_type_id;
}

GType
maya_main_window_get_type (void)
{
	static volatile gsize maya_main_window_type_id__once = 0;
	if (g_once_init_enter (&maya_main_window_type_id__once)) {
		GType maya_main_window_type_id;
		maya_main_window_type_id = maya_main_window_get_type_once ();
		g_once_init_leave (&maya_main_window_type_id__once, maya_main_window_type_id);
	}
	return maya_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

