#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


    #include <glib.h>

    // C API of libnetplan.so
    #include "netplan.h"
    #include "parse.h"
    #include "parse-nm.h"
    #include "util.h"

    // internal headers (private API)
    #include "util-internal.h"
    #include "names.h"
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 154), // NetplanAddressOptions *()(struct address_iter *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 164), // struct address_iter *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 33), // NetplanBackend()(NetplanNetDefinition const *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 159), // NetplanNetDefinition const *
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 33), // NetplanBackend()(NetplanState const *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 161), // NetplanState const *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 36), // NetplanDefType()(NetplanNetDefinition const *)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 157), // NetplanIPRoute *()(struct route_iter *)
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 167), // struct route_iter *
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION, 112), // NetplanNetDefinition *()(NetplanNetDefinition const *)
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 112), // NetplanNetDefinition *()(NetplanState const *, char const *)
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 20 */ _CFFI_OP(_CFFI_OP_POINTER, 162), // char const *
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 112), // NetplanNetDefinition *()(struct netdef_pertype_iter *)
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 166), // struct netdef_pertype_iter *
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 48), // NetplanParser *()(void)
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 69), // NetplanState *()(void)
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 103), // char *()(struct nameserver_iter *)
/* 30 */ _CFFI_OP(_CFFI_OP_POINTER, 165), // struct nameserver_iter *
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 20), // char const *()(NetplanBackend)
/* 33 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // NetplanBackend
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 20), // char const *()(NetplanDefType)
/* 36 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // NetplanDefType
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanNetDefinition const *)
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanNetDefinition const *, char const *, char const *, char const *)
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 44 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanParser *, char const *, NetplanError * *)
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 160), // NetplanParser *
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 50 */ _CFFI_OP(_CFFI_OP_POINTER, 102), // NetplanError * *
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanParser *, int, NetplanError * *)
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 54 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanParser *, int, char const *, NetplanError * *)
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 59 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 60 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanParser *, unsigned int, NetplanError * *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 65 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanState *, NetplanParser *, NetplanError * *)
/* 69 */ _CFFI_OP(_CFFI_OP_POINTER, 161), // NetplanState *
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 71 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanState const *, NetplanNetDefinition const *, NetplanError * *)
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanState const *, char const *, char const *, NetplanError * *)
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(NetplanState const *, int, NetplanError * *)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 86 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(char const *, char const *, int, NetplanError * *)
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 92 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 54), // int()(char const *, int, int, NetplanError * *)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 97 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 98 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 163), // ssize_t()(NetplanError *, char *, size_t)
/* 102 */ _CFFI_OP(_CFFI_OP_POINTER, 156), // NetplanError *
/* 103 */ _CFFI_OP(_CFFI_OP_POINTER, 162), // char *
/* 104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 163), // ssize_t()(NetplanNetDefinition const *, char *, size_t)
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 103),
/* 109 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct address_iter *()(NetplanNetDefinition *)
/* 112 */ _CFFI_OP(_CFFI_OP_POINTER, 159), // NetplanNetDefinition *
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 30), // struct nameserver_iter *()(NetplanNetDefinition *)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 112),
/* 116 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // struct netdef_pertype_iter *()(NetplanState *, char const *)
/* 118 */ _CFFI_OP(_CFFI_OP_NOOP, 69),
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct route_iter *()(NetplanNetDefinition *)
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 112),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION, 168), // uint64_t()(NetplanError *)
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 102),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // unsigned int()(NetplanNetDefinition const *)
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // unsigned int()(NetplanParser *)
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // unsigned int()(NetplanState const *)
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 169), // void()(NetplanParser * *)
/* 137 */ _CFFI_OP(_CFFI_OP_POINTER, 48), // NetplanParser * *
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 169), // void()(NetplanState * *)
/* 140 */ _CFFI_OP(_CFFI_OP_POINTER, 69), // NetplanState * *
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 169), // void()(struct address_iter *)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 169), // void()(struct nameserver_iter *)
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 169), // void()(struct netdef_pertype_iter *)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION, 169), // void()(struct route_iter *)
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 154 */ _CFFI_OP(_CFFI_OP_POINTER, 155), // NetplanAddressOptions *
/* 155 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // NetplanAddressOptions
/* 156 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // NetplanError
/* 157 */ _CFFI_OP(_CFFI_OP_POINTER, 158), // NetplanIPRoute *
/* 158 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // NetplanIPRoute
/* 159 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // NetplanNetDefinition
/* 160 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // NetplanParser
/* 161 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // NetplanState
/* 162 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 163 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 29), // ssize_t
/* 164 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct address_iter
/* 165 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct nameserver_iter
/* 166 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct netdef_pertype_iter
/* 167 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct route_iter
/* 168 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 169 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_NetplanAddressOptions(NetplanAddressOptions *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->address; (void)tmp; }
  { char * *tmp = &p->lifetime; (void)tmp; }
  { char * *tmp = &p->label; (void)tmp; }
}
struct _cffi_align_typedef_NetplanAddressOptions { char x; NetplanAddressOptions y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_NetplanIPRoute(NetplanIPRoute *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->family) | 0);  /* check that 'NetplanIPRoute.family' is an integer */
  { char * *tmp = &p->type; (void)tmp; }
  { char * *tmp = &p->scope; (void)tmp; }
  (void)((p->table) | 0);  /* check that 'NetplanIPRoute.table' is an integer */
  { char * *tmp = &p->from; (void)tmp; }
  { char * *tmp = &p->to; (void)tmp; }
  { char * *tmp = &p->via; (void)tmp; }
  (void)((p->onlink) | 0);  /* check that 'NetplanIPRoute.onlink' is an integer */
  (void)((p->metric) | 0);  /* check that 'NetplanIPRoute.metric' is an integer */
  (void)((p->mtubytes) | 0);  /* check that 'NetplanIPRoute.mtubytes' is an integer */
  (void)((p->congestion_window) | 0);  /* check that 'NetplanIPRoute.congestion_window' is an integer */
  (void)((p->advertised_receive_window) | 0);  /* check that 'NetplanIPRoute.advertised_receive_window' is an integer */
  (void)((p->advmss) | 0);  /* check that 'NetplanIPRoute.advmss' is an integer */
}
struct _cffi_align_typedef_NetplanIPRoute { char x; NetplanIPRoute y; };

static void _cffi_d__netplan_address_iter_free(struct address_iter * x0)
{
  _netplan_address_iter_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_address_iter_free(PyObject *self, PyObject *arg0)
{
  struct address_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct address_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _netplan_address_iter_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__netplan_address_iter_free _cffi_d__netplan_address_iter_free
#endif

static NetplanAddressOptions * _cffi_d__netplan_address_iter_next(struct address_iter * x0)
{
  return _netplan_address_iter_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_address_iter_next(PyObject *self, PyObject *arg0)
{
  struct address_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanAddressOptions * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct address_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_address_iter_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(154));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_address_iter_next _cffi_d__netplan_address_iter_next
#endif

static void _cffi_d__netplan_nameserver_iter_free(struct nameserver_iter * x0)
{
  _netplan_nameserver_iter_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_nameserver_iter_free(PyObject *self, PyObject *arg0)
{
  struct nameserver_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nameserver_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _netplan_nameserver_iter_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__netplan_nameserver_iter_free _cffi_d__netplan_nameserver_iter_free
#endif

static char * _cffi_d__netplan_nameserver_iter_next(struct nameserver_iter * x0)
{
  return _netplan_nameserver_iter_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_nameserver_iter_next(PyObject *self, PyObject *arg0)
{
  struct nameserver_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nameserver_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_nameserver_iter_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_nameserver_iter_next _cffi_d__netplan_nameserver_iter_next
#endif

static ssize_t _cffi_d__netplan_netdef_get_bond_mode(NetplanNetDefinition const * x0, char * x1, size_t x2)
{
  return _netplan_netdef_get_bond_mode(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_get_bond_mode(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "_netplan_netdef_get_bond_mode", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_get_bond_mode(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_get_bond_mode _cffi_d__netplan_netdef_get_bond_mode
#endif

static int _cffi_d__netplan_netdef_get_critical(NetplanNetDefinition const * x0)
{
  return _netplan_netdef_get_critical(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_get_critical(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_get_critical(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_get_critical _cffi_d__netplan_netdef_get_critical
#endif

static int _cffi_d__netplan_netdef_get_delay_virtual_functions_rebind(NetplanNetDefinition const * x0)
{
  return _netplan_netdef_get_delay_virtual_functions_rebind(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_get_delay_virtual_functions_rebind(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_get_delay_virtual_functions_rebind(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_get_delay_virtual_functions_rebind _cffi_d__netplan_netdef_get_delay_virtual_functions_rebind
#endif

static ssize_t _cffi_d__netplan_netdef_get_embedded_switch_mode(NetplanNetDefinition const * x0, char * x1, size_t x2)
{
  return _netplan_netdef_get_embedded_switch_mode(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_get_embedded_switch_mode(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "_netplan_netdef_get_embedded_switch_mode", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_get_embedded_switch_mode(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_get_embedded_switch_mode _cffi_d__netplan_netdef_get_embedded_switch_mode
#endif

static ssize_t _cffi_d__netplan_netdef_get_gateway4(NetplanNetDefinition const * x0, char * x1, size_t x2)
{
  return _netplan_netdef_get_gateway4(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_get_gateway4(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "_netplan_netdef_get_gateway4", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_get_gateway4(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_get_gateway4 _cffi_d__netplan_netdef_get_gateway4
#endif

static ssize_t _cffi_d__netplan_netdef_get_gateway6(NetplanNetDefinition const * x0, char * x1, size_t x2)
{
  return _netplan_netdef_get_gateway6(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_get_gateway6(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "_netplan_netdef_get_gateway6", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_get_gateway6(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_get_gateway6 _cffi_d__netplan_netdef_get_gateway6
#endif

static int _cffi_d__netplan_netdef_get_sriov_vlan_filter(NetplanNetDefinition const * x0)
{
  return _netplan_netdef_get_sriov_vlan_filter(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_get_sriov_vlan_filter(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_get_sriov_vlan_filter(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_get_sriov_vlan_filter _cffi_d__netplan_netdef_get_sriov_vlan_filter
#endif

static unsigned int _cffi_d__netplan_netdef_get_vlan_id(NetplanNetDefinition const * x0)
{
  return _netplan_netdef_get_vlan_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_get_vlan_id(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_get_vlan_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_get_vlan_id _cffi_d__netplan_netdef_get_vlan_id
#endif

static int _cffi_d__netplan_netdef_is_trivial_compound_itf(NetplanNetDefinition const * x0)
{
  return _netplan_netdef_is_trivial_compound_itf(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_is_trivial_compound_itf(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_is_trivial_compound_itf(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_is_trivial_compound_itf _cffi_d__netplan_netdef_is_trivial_compound_itf
#endif

static struct address_iter * _cffi_d__netplan_netdef_new_address_iter(NetplanNetDefinition * x0)
{
  return _netplan_netdef_new_address_iter(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_new_address_iter(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct address_iter * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(112), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(112), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_new_address_iter(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_new_address_iter _cffi_d__netplan_netdef_new_address_iter
#endif

static struct nameserver_iter * _cffi_d__netplan_netdef_new_nameserver_iter(NetplanNetDefinition * x0)
{
  return _netplan_netdef_new_nameserver_iter(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_new_nameserver_iter(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nameserver_iter * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(112), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(112), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_new_nameserver_iter(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(30));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_new_nameserver_iter _cffi_d__netplan_netdef_new_nameserver_iter
#endif

static struct route_iter * _cffi_d__netplan_netdef_new_route_iter(NetplanNetDefinition * x0)
{
  return _netplan_netdef_new_route_iter(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_new_route_iter(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct route_iter * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(112), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(112), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_new_route_iter(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_new_route_iter _cffi_d__netplan_netdef_new_route_iter
#endif

static struct nameserver_iter * _cffi_d__netplan_netdef_new_search_domain_iter(NetplanNetDefinition * x0)
{
  return _netplan_netdef_new_search_domain_iter(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_new_search_domain_iter(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct nameserver_iter * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(112), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(112), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_new_search_domain_iter(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(30));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_new_search_domain_iter _cffi_d__netplan_netdef_new_search_domain_iter
#endif

static void _cffi_d__netplan_netdef_pertype_iter_free(struct netdef_pertype_iter * x0)
{
  _netplan_netdef_pertype_iter_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_pertype_iter_free(PyObject *self, PyObject *arg0)
{
  struct netdef_pertype_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct netdef_pertype_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _netplan_netdef_pertype_iter_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__netplan_netdef_pertype_iter_free _cffi_d__netplan_netdef_pertype_iter_free
#endif

static NetplanNetDefinition * _cffi_d__netplan_netdef_pertype_iter_next(struct netdef_pertype_iter * x0)
{
  return _netplan_netdef_pertype_iter_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_netdef_pertype_iter_next(PyObject *self, PyObject *arg0)
{
  struct netdef_pertype_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanNetDefinition * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct netdef_pertype_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_netdef_pertype_iter_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(112));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_netdef_pertype_iter_next _cffi_d__netplan_netdef_pertype_iter_next
#endif

static void _cffi_d__netplan_route_iter_free(struct route_iter * x0)
{
  _netplan_route_iter_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_route_iter_free(PyObject *self, PyObject *arg0)
{
  struct route_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct route_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _netplan_route_iter_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__netplan_route_iter_free _cffi_d__netplan_route_iter_free
#endif

static NetplanIPRoute * _cffi_d__netplan_route_iter_next(struct route_iter * x0)
{
  return _netplan_route_iter_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_route_iter_next(PyObject *self, PyObject *arg0)
{
  struct route_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanIPRoute * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct route_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_route_iter_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(157));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_route_iter_next _cffi_d__netplan_route_iter_next
#endif

static void _cffi_d__netplan_search_domain_iter_free(struct nameserver_iter * x0)
{
  _netplan_search_domain_iter_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_search_domain_iter_free(PyObject *self, PyObject *arg0)
{
  struct nameserver_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nameserver_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _netplan_search_domain_iter_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__netplan_search_domain_iter_free _cffi_d__netplan_search_domain_iter_free
#endif

static char * _cffi_d__netplan_search_domain_iter_next(struct nameserver_iter * x0)
{
  return _netplan_search_domain_iter_next(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_search_domain_iter_next(PyObject *self, PyObject *arg0)
{
  struct nameserver_iter * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct nameserver_iter *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_search_domain_iter_next(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(103));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_search_domain_iter_next _cffi_d__netplan_search_domain_iter_next
#endif

static int _cffi_d__netplan_state_get_vf_count_for_def(NetplanState const * x0, NetplanNetDefinition const * x1, NetplanError * * x2)
{
  return _netplan_state_get_vf_count_for_def(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_state_get_vf_count_for_def(PyObject *self, PyObject *args)
{
  NetplanState const * x0;
  NetplanNetDefinition const * x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "_netplan_state_get_vf_count_for_def", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_state_get_vf_count_for_def(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_state_get_vf_count_for_def _cffi_d__netplan_state_get_vf_count_for_def
#endif

static struct netdef_pertype_iter * _cffi_d__netplan_state_new_netdef_pertype_iter(NetplanState * x0, char const * x1)
{
  return _netplan_state_new_netdef_pertype_iter(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__netplan_state_new_netdef_pertype_iter(PyObject *self, PyObject *args)
{
  NetplanState * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct netdef_pertype_iter * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "_netplan_state_new_netdef_pertype_iter", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _netplan_state_new_netdef_pertype_iter(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__netplan_state_new_netdef_pertype_iter _cffi_d__netplan_state_new_netdef_pertype_iter
#endif

static char const * _cffi_d_netplan_backend_name(NetplanBackend x0)
{
  return netplan_backend_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_backend_name(PyObject *self, PyObject *arg0)
{
  NetplanBackend x0;
  char const * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(33), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_backend_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(20));
  return pyresult;
}
#else
#  define _cffi_f_netplan_backend_name _cffi_d_netplan_backend_name
#endif

static char const * _cffi_d_netplan_def_type_name(NetplanDefType x0)
{
  return netplan_def_type_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_def_type_name(PyObject *self, PyObject *arg0)
{
  NetplanDefType x0;
  char const * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(36), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_def_type_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(20));
  return pyresult;
}
#else
#  define _cffi_f_netplan_def_type_name _cffi_d_netplan_def_type_name
#endif

static uint64_t _cffi_d_netplan_error_code(NetplanError * x0)
{
  return netplan_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_error_code(PyObject *self, PyObject *arg0)
{
  NetplanError * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(102), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanError *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(102), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_error_code _cffi_d_netplan_error_code
#endif

static ssize_t _cffi_d_netplan_error_message(NetplanError * x0, char * x1, size_t x2)
{
  return netplan_error_message(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_error_message(PyObject *self, PyObject *args)
{
  NetplanError * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_error_message", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(102), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanError *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(102), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_error_message(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_error_message _cffi_d_netplan_error_message
#endif

static int _cffi_d_netplan_netdef_get_accept_ra(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_accept_ra(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_accept_ra(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_accept_ra(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_accept_ra _cffi_d_netplan_netdef_get_accept_ra
#endif

static NetplanBackend _cffi_d_netplan_netdef_get_backend(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_backend(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_backend(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanBackend result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_backend(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(33));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_backend _cffi_d_netplan_netdef_get_backend
#endif

static NetplanNetDefinition * _cffi_d_netplan_netdef_get_bond_link(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_bond_link(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_bond_link(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanNetDefinition * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_bond_link(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(112));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_bond_link _cffi_d_netplan_netdef_get_bond_link
#endif

static NetplanNetDefinition * _cffi_d_netplan_netdef_get_bridge_link(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_bridge_link(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_bridge_link(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanNetDefinition * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_bridge_link(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(112));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_bridge_link _cffi_d_netplan_netdef_get_bridge_link
#endif

static int _cffi_d_netplan_netdef_get_dhcp4(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_dhcp4(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_dhcp4(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_dhcp4(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_dhcp4 _cffi_d_netplan_netdef_get_dhcp4
#endif

static int _cffi_d_netplan_netdef_get_dhcp6(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_dhcp6(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_dhcp6(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_dhcp6(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_dhcp6 _cffi_d_netplan_netdef_get_dhcp6
#endif

static ssize_t _cffi_d_netplan_netdef_get_filepath(NetplanNetDefinition const * x0, char * x1, size_t x2)
{
  return netplan_netdef_get_filepath(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_filepath(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_netdef_get_filepath", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_filepath(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_filepath _cffi_d_netplan_netdef_get_filepath
#endif

static ssize_t _cffi_d_netplan_netdef_get_id(NetplanNetDefinition const * x0, char * x1, size_t x2)
{
  return netplan_netdef_get_id(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_id(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_netdef_get_id", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_id(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_id _cffi_d_netplan_netdef_get_id
#endif

static int _cffi_d_netplan_netdef_get_link_local_ipv4(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_link_local_ipv4(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_link_local_ipv4(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_link_local_ipv4(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_link_local_ipv4 _cffi_d_netplan_netdef_get_link_local_ipv4
#endif

static int _cffi_d_netplan_netdef_get_link_local_ipv6(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_link_local_ipv6(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_link_local_ipv6(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_link_local_ipv6(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_link_local_ipv6 _cffi_d_netplan_netdef_get_link_local_ipv6
#endif

static ssize_t _cffi_d_netplan_netdef_get_macaddress(NetplanNetDefinition const * x0, char * x1, size_t x2)
{
  return netplan_netdef_get_macaddress(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_macaddress(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_netdef_get_macaddress", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_macaddress(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_macaddress _cffi_d_netplan_netdef_get_macaddress
#endif

static NetplanNetDefinition * _cffi_d_netplan_netdef_get_peer_link(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_peer_link(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_peer_link(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanNetDefinition * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_peer_link(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(112));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_peer_link _cffi_d_netplan_netdef_get_peer_link
#endif

static ssize_t _cffi_d_netplan_netdef_get_set_name(NetplanNetDefinition const * x0, char * x1, size_t x2)
{
  return netplan_netdef_get_set_name(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_set_name(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ssize_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_netdef_get_set_name", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_set_name(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ssize_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_set_name _cffi_d_netplan_netdef_get_set_name
#endif

static NetplanNetDefinition * _cffi_d_netplan_netdef_get_sriov_link(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_sriov_link(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_sriov_link(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanNetDefinition * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_sriov_link(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(112));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_sriov_link _cffi_d_netplan_netdef_get_sriov_link
#endif

static NetplanDefType _cffi_d_netplan_netdef_get_type(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_type(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanDefType result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(36));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_type _cffi_d_netplan_netdef_get_type
#endif

static NetplanNetDefinition * _cffi_d_netplan_netdef_get_vlan_link(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_vlan_link(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_vlan_link(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanNetDefinition * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_vlan_link(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(112));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_vlan_link _cffi_d_netplan_netdef_get_vlan_link
#endif

static NetplanNetDefinition * _cffi_d_netplan_netdef_get_vrf_link(NetplanNetDefinition const * x0)
{
  return netplan_netdef_get_vrf_link(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_get_vrf_link(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanNetDefinition * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_get_vrf_link(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(112));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_get_vrf_link _cffi_d_netplan_netdef_get_vrf_link
#endif

static int _cffi_d_netplan_netdef_has_match(NetplanNetDefinition const * x0)
{
  return netplan_netdef_has_match(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_has_match(PyObject *self, PyObject *arg0)
{
  NetplanNetDefinition const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_has_match(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_has_match _cffi_d_netplan_netdef_has_match
#endif

static int _cffi_d_netplan_netdef_match_interface(NetplanNetDefinition const * x0, char const * x1, char const * x2, char const * x3)
{
  return netplan_netdef_match_interface(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_netdef_match_interface(PyObject *self, PyObject *args)
{
  NetplanNetDefinition const * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "netplan_netdef_match_interface", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanNetDefinition const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_netdef_match_interface(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_netdef_match_interface _cffi_d_netplan_netdef_match_interface
#endif

static void _cffi_d_netplan_parser_clear(NetplanParser * * x0)
{
  netplan_parser_clear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_clear(PyObject *self, PyObject *arg0)
{
  NetplanParser * * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { netplan_parser_clear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_netplan_parser_clear _cffi_d_netplan_parser_clear
#endif

static unsigned int _cffi_d_netplan_parser_get_error_count(NetplanParser * x0)
{
  return netplan_parser_get_error_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_get_error_count(PyObject *self, PyObject *arg0)
{
  NetplanParser * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_get_error_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_get_error_count _cffi_d_netplan_parser_get_error_count
#endif

static unsigned int _cffi_d_netplan_parser_get_flags(NetplanParser * x0)
{
  return netplan_parser_get_flags(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_get_flags(PyObject *self, PyObject *arg0)
{
  NetplanParser * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_get_flags(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_get_flags _cffi_d_netplan_parser_get_flags
#endif

static int _cffi_d_netplan_parser_load_keyfile(NetplanParser * x0, char const * x1, NetplanError * * x2)
{
  return netplan_parser_load_keyfile(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_load_keyfile(PyObject *self, PyObject *args)
{
  NetplanParser * x0;
  char const * x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_parser_load_keyfile", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_load_keyfile(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_load_keyfile _cffi_d_netplan_parser_load_keyfile
#endif

static int _cffi_d_netplan_parser_load_nullable_fields(NetplanParser * x0, int x1, NetplanError * * x2)
{
  return netplan_parser_load_nullable_fields(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_load_nullable_fields(PyObject *self, PyObject *args)
{
  NetplanParser * x0;
  int x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_parser_load_nullable_fields", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_load_nullable_fields(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_load_nullable_fields _cffi_d_netplan_parser_load_nullable_fields
#endif

static int _cffi_d_netplan_parser_load_nullable_overrides(NetplanParser * x0, int x1, char const * x2, NetplanError * * x3)
{
  return netplan_parser_load_nullable_overrides(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_load_nullable_overrides(PyObject *self, PyObject *args)
{
  NetplanParser * x0;
  int x1;
  char const * x2;
  NetplanError * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "netplan_parser_load_nullable_overrides", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_load_nullable_overrides(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_load_nullable_overrides _cffi_d_netplan_parser_load_nullable_overrides
#endif

static int _cffi_d_netplan_parser_load_yaml(NetplanParser * x0, char const * x1, NetplanError * * x2)
{
  return netplan_parser_load_yaml(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_load_yaml(PyObject *self, PyObject *args)
{
  NetplanParser * x0;
  char const * x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_parser_load_yaml", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_load_yaml(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_load_yaml _cffi_d_netplan_parser_load_yaml
#endif

static int _cffi_d_netplan_parser_load_yaml_from_fd(NetplanParser * x0, int x1, NetplanError * * x2)
{
  return netplan_parser_load_yaml_from_fd(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_load_yaml_from_fd(PyObject *self, PyObject *args)
{
  NetplanParser * x0;
  int x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_parser_load_yaml_from_fd", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_load_yaml_from_fd(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_load_yaml_from_fd _cffi_d_netplan_parser_load_yaml_from_fd
#endif

static int _cffi_d_netplan_parser_load_yaml_hierarchy(NetplanParser * x0, char const * x1, NetplanError * * x2)
{
  return netplan_parser_load_yaml_hierarchy(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_load_yaml_hierarchy(PyObject *self, PyObject *args)
{
  NetplanParser * x0;
  char const * x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_parser_load_yaml_hierarchy", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_load_yaml_hierarchy(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_load_yaml_hierarchy _cffi_d_netplan_parser_load_yaml_hierarchy
#endif

static NetplanParser * _cffi_d_netplan_parser_new(void)
{
  return netplan_parser_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_new(PyObject *self, PyObject *noarg)
{
  NetplanParser * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(48));
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_new _cffi_d_netplan_parser_new
#endif

static int _cffi_d_netplan_parser_set_flags(NetplanParser * x0, unsigned int x1, NetplanError * * x2)
{
  return netplan_parser_set_flags(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_parser_set_flags(PyObject *self, PyObject *args)
{
  NetplanParser * x0;
  unsigned int x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_parser_set_flags", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_parser_set_flags(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_parser_set_flags _cffi_d_netplan_parser_set_flags
#endif

static void _cffi_d_netplan_state_clear(NetplanState * * x0)
{
  netplan_state_clear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_clear(PyObject *self, PyObject *arg0)
{
  NetplanState * * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(140), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(140), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { netplan_state_clear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_netplan_state_clear _cffi_d_netplan_state_clear
#endif

static int _cffi_d_netplan_state_dump_yaml(NetplanState const * x0, int x1, NetplanError * * x2)
{
  return netplan_state_dump_yaml(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_dump_yaml(PyObject *self, PyObject *args)
{
  NetplanState const * x0;
  int x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_state_dump_yaml", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_state_dump_yaml(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_state_dump_yaml _cffi_d_netplan_state_dump_yaml
#endif

static NetplanBackend _cffi_d_netplan_state_get_backend(NetplanState const * x0)
{
  return netplan_state_get_backend(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_get_backend(PyObject *self, PyObject *arg0)
{
  NetplanState const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanBackend result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_state_get_backend(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(33));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_state_get_backend _cffi_d_netplan_state_get_backend
#endif

static NetplanNetDefinition * _cffi_d_netplan_state_get_netdef(NetplanState const * x0, char const * x1)
{
  return netplan_state_get_netdef(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_get_netdef(PyObject *self, PyObject *args)
{
  NetplanState const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  NetplanNetDefinition * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "netplan_state_get_netdef", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_state_get_netdef(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(112));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_state_get_netdef _cffi_d_netplan_state_get_netdef
#endif

static unsigned int _cffi_d_netplan_state_get_netdefs_size(NetplanState const * x0)
{
  return netplan_state_get_netdefs_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_get_netdefs_size(PyObject *self, PyObject *arg0)
{
  NetplanState const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_state_get_netdefs_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_state_get_netdefs_size _cffi_d_netplan_state_get_netdefs_size
#endif

static int _cffi_d_netplan_state_import_parser_results(NetplanState * x0, NetplanParser * x1, NetplanError * * x2)
{
  return netplan_state_import_parser_results(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_import_parser_results(PyObject *self, PyObject *args)
{
  NetplanState * x0;
  NetplanParser * x1;
  NetplanError * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "netplan_state_import_parser_results", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(69), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(69), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (NetplanParser *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_state_import_parser_results(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_state_import_parser_results _cffi_d_netplan_state_import_parser_results
#endif

static NetplanState * _cffi_d_netplan_state_new(void)
{
  return netplan_state_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_new(PyObject *self, PyObject *noarg)
{
  NetplanState * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_state_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(69));
  return pyresult;
}
#else
#  define _cffi_f_netplan_state_new _cffi_d_netplan_state_new
#endif

static int _cffi_d_netplan_state_update_yaml_hierarchy(NetplanState const * x0, char const * x1, char const * x2, NetplanError * * x3)
{
  return netplan_state_update_yaml_hierarchy(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_update_yaml_hierarchy(PyObject *self, PyObject *args)
{
  NetplanState const * x0;
  char const * x1;
  char const * x2;
  NetplanError * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "netplan_state_update_yaml_hierarchy", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_state_update_yaml_hierarchy(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_state_update_yaml_hierarchy _cffi_d_netplan_state_update_yaml_hierarchy
#endif

static int _cffi_d_netplan_state_write_yaml_file(NetplanState const * x0, char const * x1, char const * x2, NetplanError * * x3)
{
  return netplan_state_write_yaml_file(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_state_write_yaml_file(PyObject *self, PyObject *args)
{
  NetplanState const * x0;
  char const * x1;
  char const * x2;
  NetplanError * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "netplan_state_write_yaml_file", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NetplanState const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_state_write_yaml_file(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_state_write_yaml_file _cffi_d_netplan_state_write_yaml_file
#endif

static int _cffi_d_netplan_util_create_yaml_patch(char const * x0, char const * x1, int x2, NetplanError * * x3)
{
  return netplan_util_create_yaml_patch(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_util_create_yaml_patch(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  int x2;
  NetplanError * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "netplan_util_create_yaml_patch", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_util_create_yaml_patch(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_util_create_yaml_patch _cffi_d_netplan_util_create_yaml_patch
#endif

static int _cffi_d_netplan_util_dump_yaml_subtree(char const * x0, int x1, int x2, NetplanError * * x3)
{
  return netplan_util_dump_yaml_subtree(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_netplan_util_dump_yaml_subtree(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  int x2;
  NetplanError * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "netplan_util_dump_yaml_subtree", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (NetplanError * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = netplan_util_dump_yaml_subtree(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_netplan_util_dump_yaml_subtree _cffi_d_netplan_util_dump_yaml_subtree
#endif

static int _cffi_const_UINT_MAX(unsigned long long *o)
{
  int n = (UINT_MAX) <= 0;
  *o = (unsigned long long)((UINT_MAX) | 0);  /* check that UINT_MAX is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_address_iter(struct address_iter *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_address_iter { char x; struct address_iter y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_nameserver_iter(struct nameserver_iter *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_nameserver_iter { char x; struct nameserver_iter y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_route_iter(struct route_iter *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_route_iter { char x; struct route_iter y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "UINT_MAX", (void *)_cffi_const_UINT_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_netplan_address_iter_free", (void *)_cffi_f__netplan_address_iter_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 142), (void *)_cffi_d__netplan_address_iter_free },
  { "_netplan_address_iter_next", (void *)_cffi_f__netplan_address_iter_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d__netplan_address_iter_next },
  { "_netplan_nameserver_iter_free", (void *)_cffi_f__netplan_nameserver_iter_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 145), (void *)_cffi_d__netplan_nameserver_iter_free },
  { "_netplan_nameserver_iter_next", (void *)_cffi_f__netplan_nameserver_iter_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 29), (void *)_cffi_d__netplan_nameserver_iter_next },
  { "_netplan_netdef_get_bond_mode", (void *)_cffi_f__netplan_netdef_get_bond_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d__netplan_netdef_get_bond_mode },
  { "_netplan_netdef_get_critical", (void *)_cffi_f__netplan_netdef_get_critical, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d__netplan_netdef_get_critical },
  { "_netplan_netdef_get_delay_virtual_functions_rebind", (void *)_cffi_f__netplan_netdef_get_delay_virtual_functions_rebind, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d__netplan_netdef_get_delay_virtual_functions_rebind },
  { "_netplan_netdef_get_embedded_switch_mode", (void *)_cffi_f__netplan_netdef_get_embedded_switch_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d__netplan_netdef_get_embedded_switch_mode },
  { "_netplan_netdef_get_gateway4", (void *)_cffi_f__netplan_netdef_get_gateway4, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d__netplan_netdef_get_gateway4 },
  { "_netplan_netdef_get_gateway6", (void *)_cffi_f__netplan_netdef_get_gateway6, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d__netplan_netdef_get_gateway6 },
  { "_netplan_netdef_get_sriov_vlan_filter", (void *)_cffi_f__netplan_netdef_get_sriov_vlan_filter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d__netplan_netdef_get_sriov_vlan_filter },
  { "_netplan_netdef_get_vlan_id", (void *)_cffi_f__netplan_netdef_get_vlan_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 127), (void *)_cffi_d__netplan_netdef_get_vlan_id },
  { "_netplan_netdef_is_trivial_compound_itf", (void *)_cffi_f__netplan_netdef_is_trivial_compound_itf, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d__netplan_netdef_is_trivial_compound_itf },
  { "_netplan_netdef_new_address_iter", (void *)_cffi_f__netplan_netdef_new_address_iter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 111), (void *)_cffi_d__netplan_netdef_new_address_iter },
  { "_netplan_netdef_new_nameserver_iter", (void *)_cffi_f__netplan_netdef_new_nameserver_iter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 114), (void *)_cffi_d__netplan_netdef_new_nameserver_iter },
  { "_netplan_netdef_new_route_iter", (void *)_cffi_f__netplan_netdef_new_route_iter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 121), (void *)_cffi_d__netplan_netdef_new_route_iter },
  { "_netplan_netdef_new_search_domain_iter", (void *)_cffi_f__netplan_netdef_new_search_domain_iter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 114), (void *)_cffi_d__netplan_netdef_new_search_domain_iter },
  { "_netplan_netdef_pertype_iter_free", (void *)_cffi_f__netplan_netdef_pertype_iter_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 148), (void *)_cffi_d__netplan_netdef_pertype_iter_free },
  { "_netplan_netdef_pertype_iter_next", (void *)_cffi_f__netplan_netdef_pertype_iter_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 22), (void *)_cffi_d__netplan_netdef_pertype_iter_next },
  { "_netplan_route_iter_free", (void *)_cffi_f__netplan_route_iter_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 151), (void *)_cffi_d__netplan_route_iter_free },
  { "_netplan_route_iter_next", (void *)_cffi_f__netplan_route_iter_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d__netplan_route_iter_next },
  { "_netplan_search_domain_iter_free", (void *)_cffi_f__netplan_search_domain_iter_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 145), (void *)_cffi_d__netplan_search_domain_iter_free },
  { "_netplan_search_domain_iter_next", (void *)_cffi_f__netplan_search_domain_iter_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 29), (void *)_cffi_d__netplan_search_domain_iter_next },
  { "_netplan_state_get_vf_count_for_def", (void *)_cffi_f__netplan_state_get_vf_count_for_def, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 73), (void *)_cffi_d__netplan_state_get_vf_count_for_def },
  { "_netplan_state_new_netdef_pertype_iter", (void *)_cffi_f__netplan_state_new_netdef_pertype_iter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 117), (void *)_cffi_d__netplan_state_new_netdef_pertype_iter },
  { "netplan_backend_name", (void *)_cffi_f_netplan_backend_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 32), (void *)_cffi_d_netplan_backend_name },
  { "netplan_def_type_name", (void *)_cffi_f_netplan_def_type_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 35), (void *)_cffi_d_netplan_def_type_name },
  { "netplan_error_code", (void *)_cffi_f_netplan_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 124), (void *)_cffi_d_netplan_error_code },
  { "netplan_error_message", (void *)_cffi_f_netplan_error_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 101), (void *)_cffi_d_netplan_error_message },
  { "netplan_netdef_get_accept_ra", (void *)_cffi_f_netplan_netdef_get_accept_ra, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_netplan_netdef_get_accept_ra },
  { "netplan_netdef_get_backend", (void *)_cffi_f_netplan_netdef_get_backend, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_netplan_netdef_get_backend },
  { "netplan_netdef_get_bond_link", (void *)_cffi_f_netplan_netdef_get_bond_link, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 15), (void *)_cffi_d_netplan_netdef_get_bond_link },
  { "netplan_netdef_get_bridge_link", (void *)_cffi_f_netplan_netdef_get_bridge_link, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 15), (void *)_cffi_d_netplan_netdef_get_bridge_link },
  { "netplan_netdef_get_dhcp4", (void *)_cffi_f_netplan_netdef_get_dhcp4, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_netplan_netdef_get_dhcp4 },
  { "netplan_netdef_get_dhcp6", (void *)_cffi_f_netplan_netdef_get_dhcp6, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_netplan_netdef_get_dhcp6 },
  { "netplan_netdef_get_filepath", (void *)_cffi_f_netplan_netdef_get_filepath, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_netplan_netdef_get_filepath },
  { "netplan_netdef_get_id", (void *)_cffi_f_netplan_netdef_get_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_netplan_netdef_get_id },
  { "netplan_netdef_get_link_local_ipv4", (void *)_cffi_f_netplan_netdef_get_link_local_ipv4, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_netplan_netdef_get_link_local_ipv4 },
  { "netplan_netdef_get_link_local_ipv6", (void *)_cffi_f_netplan_netdef_get_link_local_ipv6, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_netplan_netdef_get_link_local_ipv6 },
  { "netplan_netdef_get_macaddress", (void *)_cffi_f_netplan_netdef_get_macaddress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_netplan_netdef_get_macaddress },
  { "netplan_netdef_get_peer_link", (void *)_cffi_f_netplan_netdef_get_peer_link, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 15), (void *)_cffi_d_netplan_netdef_get_peer_link },
  { "netplan_netdef_get_set_name", (void *)_cffi_f_netplan_netdef_get_set_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_netplan_netdef_get_set_name },
  { "netplan_netdef_get_sriov_link", (void *)_cffi_f_netplan_netdef_get_sriov_link, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 15), (void *)_cffi_d_netplan_netdef_get_sriov_link },
  { "netplan_netdef_get_type", (void *)_cffi_f_netplan_netdef_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_netplan_netdef_get_type },
  { "netplan_netdef_get_vlan_link", (void *)_cffi_f_netplan_netdef_get_vlan_link, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 15), (void *)_cffi_d_netplan_netdef_get_vlan_link },
  { "netplan_netdef_get_vrf_link", (void *)_cffi_f_netplan_netdef_get_vrf_link, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 15), (void *)_cffi_d_netplan_netdef_get_vrf_link },
  { "netplan_netdef_has_match", (void *)_cffi_f_netplan_netdef_has_match, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 38), (void *)_cffi_d_netplan_netdef_has_match },
  { "netplan_netdef_match_interface", (void *)_cffi_f_netplan_netdef_match_interface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 41), (void *)_cffi_d_netplan_netdef_match_interface },
  { "netplan_parser_clear", (void *)_cffi_f_netplan_parser_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 136), (void *)_cffi_d_netplan_parser_clear },
  { "netplan_parser_get_error_count", (void *)_cffi_f_netplan_parser_get_error_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 130), (void *)_cffi_d_netplan_parser_get_error_count },
  { "netplan_parser_get_flags", (void *)_cffi_f_netplan_parser_get_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 130), (void *)_cffi_d_netplan_parser_get_flags },
  { "netplan_parser_load_keyfile", (void *)_cffi_f_netplan_parser_load_keyfile, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_netplan_parser_load_keyfile },
  { "netplan_parser_load_nullable_fields", (void *)_cffi_f_netplan_parser_load_nullable_fields, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 52), (void *)_cffi_d_netplan_parser_load_nullable_fields },
  { "netplan_parser_load_nullable_overrides", (void *)_cffi_f_netplan_parser_load_nullable_overrides, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 57), (void *)_cffi_d_netplan_parser_load_nullable_overrides },
  { "netplan_parser_load_yaml", (void *)_cffi_f_netplan_parser_load_yaml, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_netplan_parser_load_yaml },
  { "netplan_parser_load_yaml_from_fd", (void *)_cffi_f_netplan_parser_load_yaml_from_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 52), (void *)_cffi_d_netplan_parser_load_yaml_from_fd },
  { "netplan_parser_load_yaml_hierarchy", (void *)_cffi_f_netplan_parser_load_yaml_hierarchy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_netplan_parser_load_yaml_hierarchy },
  { "netplan_parser_new", (void *)_cffi_f_netplan_parser_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 25), (void *)_cffi_d_netplan_parser_new },
  { "netplan_parser_set_flags", (void *)_cffi_f_netplan_parser_set_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 63), (void *)_cffi_d_netplan_parser_set_flags },
  { "netplan_state_clear", (void *)_cffi_f_netplan_state_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 139), (void *)_cffi_d_netplan_state_clear },
  { "netplan_state_dump_yaml", (void *)_cffi_f_netplan_state_dump_yaml, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 84), (void *)_cffi_d_netplan_state_dump_yaml },
  { "netplan_state_get_backend", (void *)_cffi_f_netplan_state_get_backend, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_netplan_state_get_backend },
  { "netplan_state_get_netdef", (void *)_cffi_f_netplan_state_get_netdef, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 18), (void *)_cffi_d_netplan_state_get_netdef },
  { "netplan_state_get_netdefs_size", (void *)_cffi_f_netplan_state_get_netdefs_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 133), (void *)_cffi_d_netplan_state_get_netdefs_size },
  { "netplan_state_import_parser_results", (void *)_cffi_f_netplan_state_import_parser_results, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 68), (void *)_cffi_d_netplan_state_import_parser_results },
  { "netplan_state_new", (void *)_cffi_f_netplan_state_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 27), (void *)_cffi_d_netplan_state_new },
  { "netplan_state_update_yaml_hierarchy", (void *)_cffi_f_netplan_state_update_yaml_hierarchy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 78), (void *)_cffi_d_netplan_state_update_yaml_hierarchy },
  { "netplan_state_write_yaml_file", (void *)_cffi_f_netplan_state_write_yaml_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 78), (void *)_cffi_d_netplan_state_write_yaml_file },
  { "netplan_util_create_yaml_patch", (void *)_cffi_f_netplan_util_create_yaml_patch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 89), (void *)_cffi_d_netplan_util_create_yaml_patch },
  { "netplan_util_dump_yaml_subtree", (void *)_cffi_f_netplan_util_dump_yaml_subtree, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 95), (void *)_cffi_d_netplan_util_dump_yaml_subtree },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "address", offsetof(NetplanAddressOptions, address),
               sizeof(((NetplanAddressOptions *)0)->address),
               _CFFI_OP(_CFFI_OP_NOOP, 103) },
  { "lifetime", offsetof(NetplanAddressOptions, lifetime),
                sizeof(((NetplanAddressOptions *)0)->lifetime),
                _CFFI_OP(_CFFI_OP_NOOP, 103) },
  { "label", offsetof(NetplanAddressOptions, label),
             sizeof(((NetplanAddressOptions *)0)->label),
             _CFFI_OP(_CFFI_OP_NOOP, 103) },
  { "family", offsetof(NetplanIPRoute, family),
              sizeof(((NetplanIPRoute *)0)->family),
              _CFFI_OP(_CFFI_OP_NOOP, 54) },
  { "type", offsetof(NetplanIPRoute, type),
            sizeof(((NetplanIPRoute *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 103) },
  { "scope", offsetof(NetplanIPRoute, scope),
             sizeof(((NetplanIPRoute *)0)->scope),
             _CFFI_OP(_CFFI_OP_NOOP, 103) },
  { "table", offsetof(NetplanIPRoute, table),
             sizeof(((NetplanIPRoute *)0)->table),
             _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "from", offsetof(NetplanIPRoute, from),
            sizeof(((NetplanIPRoute *)0)->from),
            _CFFI_OP(_CFFI_OP_NOOP, 103) },
  { "to", offsetof(NetplanIPRoute, to),
          sizeof(((NetplanIPRoute *)0)->to),
          _CFFI_OP(_CFFI_OP_NOOP, 103) },
  { "via", offsetof(NetplanIPRoute, via),
           sizeof(((NetplanIPRoute *)0)->via),
           _CFFI_OP(_CFFI_OP_NOOP, 103) },
  { "onlink", offsetof(NetplanIPRoute, onlink),
              sizeof(((NetplanIPRoute *)0)->onlink),
              _CFFI_OP(_CFFI_OP_NOOP, 54) },
  { "metric", offsetof(NetplanIPRoute, metric),
              sizeof(((NetplanIPRoute *)0)->metric),
              _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "mtubytes", offsetof(NetplanIPRoute, mtubytes),
                sizeof(((NetplanIPRoute *)0)->mtubytes),
                _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "congestion_window", offsetof(NetplanIPRoute, congestion_window),
                         sizeof(((NetplanIPRoute *)0)->congestion_window),
                         _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "advertised_receive_window", offsetof(NetplanIPRoute, advertised_receive_window),
                                 sizeof(((NetplanIPRoute *)0)->advertised_receive_window),
                                 _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "advmss", offsetof(NetplanIPRoute, advmss),
              sizeof(((NetplanIPRoute *)0)->advmss),
              _CFFI_OP(_CFFI_OP_NOOP, 65) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$NetplanAddressOptions", 155, _CFFI_F_CHECK_FIELDS,
    sizeof(NetplanAddressOptions), offsetof(struct _cffi_align_typedef_NetplanAddressOptions, y), 0, 3 },
  { "$NetplanIPRoute", 158, _CFFI_F_CHECK_FIELDS,
    sizeof(NetplanIPRoute), offsetof(struct _cffi_align_typedef_NetplanIPRoute, y), 3, 13 },
  { "GError", 156, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "address_iter", 164, 0,
    sizeof(struct address_iter), offsetof(struct _cffi_align_struct_address_iter, y), 16, 0 },
  { "nameserver_iter", 165, 0,
    sizeof(struct nameserver_iter), offsetof(struct _cffi_align_struct_nameserver_iter, y), 16, 0 },
  { "netdef_pertype_iter", 166, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "netplan_net_definition", 159, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "netplan_parser", 160, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "netplan_state", 161, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "route_iter", 167, 0,
    sizeof(struct route_iter), offsetof(struct _cffi_align_struct_route_iter, y), 16, 0 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$NetplanBackend", 33, _cffi_prim_int(sizeof(NetplanBackend), ((NetplanBackend)-1) <= 0),
    "" },
  { "$NetplanDefType", 36, _cffi_prim_int(sizeof(NetplanDefType), ((NetplanDefType)-1) <= 0),
    "" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "NetplanAddressOptions", 155 },
  { "NetplanBackend", 33 },
  { "NetplanDefType", 36 },
  { "NetplanError", 156 },
  { "NetplanIPRoute", 158 },
  { "NetplanNetDefinition", 159 },
  { "NetplanParser", 160 },
  { "NetplanState", 161 },
  { "gboolean", 54 },
  { "gint", 54 },
  { "guint", 65 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  71,  /* num_globals */
  10,  /* num_struct_unions */
  2,  /* num_enums */
  11,  /* num_typenames */
  NULL,  /* no includes */
  170,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__netplan_cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__netplan_cffi(void) { return NULL; }
#  else
     init_netplan_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__netplan_cffi(void)
{
  return _cffi_init("_netplan_cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_netplan_cffi(void)
{
  _cffi_init("_netplan_cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
