
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kaboutplugindialog_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"
#include "kshortcutsdialog_wrapper.h"
#include "ktoolbar_wrapper.h"

// Argument includes
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAboutPluginDialog_Type = nullptr;
static PyTypeObject *Sbk_KAboutPluginDialog_TypeF(void)
{
    return _Sbk_KAboutPluginDialog_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KAboutPluginDialogWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

void KAboutPluginDialogWrapper::accept()
{
    static const char *funcName = "accept";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::accept();
    }
    KShortcutsDialogWrapper::sbk_o_accept("KAboutPluginDialog", funcName, gil, pyOverride);
}

void KAboutPluginDialogWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KToolBarWrapper::sbk_o_actionEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KToolBarWrapper::sbk_o_changeEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::closeEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_closeEvent("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

void KAboutPluginDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KAboutPluginDialog", funcName, gil, pyOverride, signal);
}

void KAboutPluginDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_contextMenuEvent("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

void KAboutPluginDialogWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

int KAboutPluginDialogWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KToolBarWrapper::sbk_o_devType("KAboutPluginDialog", funcName, gil, pyOverride);
}

void KAboutPluginDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KAboutPluginDialog", funcName, gil, pyOverride, signal);
}

void KAboutPluginDialogWrapper::done(int arg__1)
{
    static const char *funcName = "done";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::done(arg__1);
    }
    KShortcutsDialogWrapper::sbk_o_done("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

void KAboutPluginDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KToolBarWrapper::sbk_o_dragEnterEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragLeaveEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragMoveEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KToolBarWrapper::sbk_o_dropEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KToolBarWrapper::sbk_o_enterEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

bool KAboutPluginDialogWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

bool KAboutPluginDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KAboutPluginDialog", funcName, gil, pyOverride, arg__1, arg__2);
}

int KAboutPluginDialogWrapper::exec()
{
    static const char *funcName = "exec";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::exec();
    }
    return KShortcutsDialogWrapper::sbk_o_exec("KAboutPluginDialog", funcName, gil, pyOverride);
}

void KAboutPluginDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KToolBarWrapper::sbk_o_focusInEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

bool KAboutPluginDialogWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KToolBarWrapper::sbk_o_focusNextPrevChild("KAboutPluginDialog", funcName, gil, pyOverride, next);
}

void KAboutPluginDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KToolBarWrapper::sbk_o_focusOutEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

bool KAboutPluginDialogWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KAboutPluginDialog", funcName, gil, pyOverride);
}

int KAboutPluginDialogWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KToolBarWrapper::sbk_o_heightForWidth("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

void KAboutPluginDialogWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KToolBarWrapper::sbk_o_hideEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KToolBarWrapper::sbk_o_initPainter("KAboutPluginDialog", funcName, gil, pyOverride, painter);
}

void KAboutPluginDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KToolBarWrapper::sbk_o_inputMethodEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

::QVariant KAboutPluginDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KToolBarWrapper::sbk_o_inputMethodQuery("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

void KAboutPluginDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_keyPressEvent("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

void KAboutPluginDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_keyReleaseEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KToolBarWrapper::sbk_o_leaveEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

int KAboutPluginDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KToolBarWrapper::sbk_o_metric("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KAboutPluginDialogWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::minimumSizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KAboutPluginDialog", funcName, gil, pyOverride);
}

void KAboutPluginDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseDoubleClickEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseMoveEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KToolBarWrapper::sbk_o_mousePressEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseReleaseEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KToolBarWrapper::sbk_o_moveEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

bool KAboutPluginDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KToolBarWrapper::sbk_o_nativeEvent("KAboutPluginDialog", funcName, gil, pyOverride, eventType, message, result);
}

void KAboutPluginDialogWrapper::open()
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::open();
    }
    KShortcutsDialogWrapper::sbk_o_accept("KAboutPluginDialog", funcName, gil, pyOverride);
}

::QPaintEngine * KAboutPluginDialogWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KToolBarWrapper::sbk_o_paintEngine("KAboutPluginDialog", funcName, gil, pyOverride);
}

void KAboutPluginDialogWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KToolBarWrapper::sbk_o_paintEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

::QPaintDevice * KAboutPluginDialogWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KToolBarWrapper::sbk_o_redirected("KAboutPluginDialog", funcName, gil, pyOverride, offset);
}

void KAboutPluginDialogWrapper::reject()
{
    static const char *funcName = "reject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::reject();
    }
    KShortcutsDialogWrapper::sbk_o_accept("KAboutPluginDialog", funcName, gil, pyOverride);
}

void KAboutPluginDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_resizeEvent("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

void KAboutPluginDialogWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::setVisible(visible);
    }
    KToolBarWrapper::sbk_o_setVisible("KAboutPluginDialog", funcName, gil, pyOverride, visible);
}

::QPainter * KAboutPluginDialogWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KToolBarWrapper::sbk_o_sharedPainter("KAboutPluginDialog", funcName, gil, pyOverride);
}

void KAboutPluginDialogWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::showEvent(arg__1);
    }
    KToolBarWrapper::sbk_o_showEvent("KAboutPluginDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KAboutPluginDialogWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::sizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KAboutPluginDialog", funcName, gil, pyOverride);
}

void KAboutPluginDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KToolBarWrapper::sbk_o_tabletEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

void KAboutPluginDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAboutPluginDialog_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KToolBarWrapper::sbk_o_wheelEvent("KAboutPluginDialog", funcName, gil, pyOverride, event);
}

const QMetaObject *KAboutPluginDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KAboutPluginDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KAboutPluginDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KAboutPluginDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KAboutPluginDialogWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KAboutPluginDialogWrapper *>(this));
    }
    return KAboutPluginDialog::qt_metacast(_clname);
}

KAboutPluginDialogWrapper::~KAboutPluginDialogWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KAboutPluginDialog_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KAboutPluginDialog_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("KAboutPluginDialog");
    return -1;
}


static const char *Sbk_KAboutPluginDialog_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KAboutPluginDialog_EnumFlagInfo[] = {
    "Option:IntFlag:Options",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAboutPluginDialog_methods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KAboutPluginDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KAboutPluginDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KAboutPluginDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KAboutPluginDialogWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KAboutPluginDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAboutPluginDialog_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KAboutPluginDialogSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KAboutPluginDialog *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAboutPluginDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KAboutPluginDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAboutPluginDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAboutPluginDialog_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAboutPluginDialog_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAboutPluginDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAboutPluginDialog_spec = {
    "1:KXmlGui.KAboutPluginDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAboutPluginDialog_slots
};

} //extern "C"

static void *Sbk_KAboutPluginDialog_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KAboutPluginDialog *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KAboutPluginDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KAboutPluginDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KAboutPluginDialog_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KAboutPluginDialog::Option>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KAboutPluginDialog::Option *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KAboutPluginDialog_Option_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KAboutPluginDialog_Option_IDX])))
        return Enum_PythonToCpp_KAboutPluginDialog_Option;
    return {};
}

static PyObject *KAboutPluginDialog_Option_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KAboutPluginDialog::Option>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KAboutPluginDialog::Option *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KAboutPluginDialog_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KAboutPluginDialog::Option>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KAboutPluginDialog::Option> *>(cppOut) = value;

}

static PyObject *KAboutPluginDialog_Option_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KAboutPluginDialog::Option> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KAboutPluginDialog_Option_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAboutPluginDialog_PythonToCpp_KAboutPluginDialog_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAboutPluginDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAboutPluginDialog_PythonToCpp_KAboutPluginDialog_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutPluginDialog_TypeF()))
        return KAboutPluginDialog_PythonToCpp_KAboutPluginDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAboutPluginDialog_PTR_CppToPython_KAboutPluginDialog(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KAboutPluginDialog *>(const_cast<void *>(cppIn)), Sbk_KAboutPluginDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAboutPluginDialog_SignatureStrings[] = {
    nullptr}; // Sentinel
#else
static constexpr size_t KAboutPluginDialog_SignatureByteSize = 0;
static constexpr uint8_t KAboutPluginDialog_SignatureBytes[1] = {
    0x00
};
#endif

PyTypeObject *init_KAboutPluginDialog(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KAboutPluginDialog_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KAboutPluginDialog_IDX].type;

    Shiboken::AutoDecRef Sbk_KAboutPluginDialog_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))));

    _Sbk_KAboutPluginDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAboutPluginDialog",
        "KAboutPluginDialog*",
        &Sbk_KAboutPluginDialog_spec,
        &Shiboken::callCppDestructor< KAboutPluginDialog >,
        Sbk_KAboutPluginDialog_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KAboutPluginDialog_Type; // references _Sbk_KAboutPluginDialog_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAboutPluginDialog_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAboutPluginDialog_SignatureBytes, KAboutPluginDialog_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAboutPluginDialog_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KAboutPluginDialog_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAboutPluginDialog_PythonToCpp_KAboutPluginDialog_PTR,
        is_KAboutPluginDialog_PythonToCpp_KAboutPluginDialog_PTR_Convertible,
        KAboutPluginDialog_PTR_CppToPython_KAboutPluginDialog);

    Shiboken::Conversions::registerConverterName(converter, "KAboutPluginDialog");
    Shiboken::Conversions::registerConverterName(converter, "KAboutPluginDialog*");
    Shiboken::Conversions::registerConverterName(converter, "KAboutPluginDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAboutPluginDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KAboutPluginDialogWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KAboutPluginDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KAboutPluginDialog_TypeF(), &Sbk_KAboutPluginDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KAboutPluginDialog_TypeF(), &Sbk_KAboutPluginDialog_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KAboutPluginDialog_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Option'.
    const char *Option_Initializer[] = {
        "NoOptions",
        "HideTranslators",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Option_InitializerValues[] = {
        uint8_t(KAboutPluginDialog::Option::NoOptions),      //  0x00  0
        uint8_t(KAboutPluginDialog::Option::HideTranslators) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KAboutPluginDialog_TypeF(),
        "1:KXmlGui.KAboutPluginDialog.Option",
        Option_Initializer, Option_InitializerValues);
    SbkKXmlGuiTypeStructs[SBK_KAboutPluginDialog_Option_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKXmlGuiTypeStructs[SBK_QFlags_KAboutPluginDialog_Option_IDX].type =
        EType;
    // Register converter for enum 'KAboutPluginDialog::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KAboutPluginDialog_Option_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KAboutPluginDialog_Option,
            is_Enum_PythonToCpp_KAboutPluginDialog_Option_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KAboutPluginDialog::Option");
        Shiboken::Conversions::registerConverterAlias(converter, "Option");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KAboutPluginDialog_Option_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KAboutPluginDialog_Option,
            is_Enum_PythonToCpp_KAboutPluginDialog_Option_Convertible);
        // Register converter for flag 'QFlags<KAboutPluginDialog::Option>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KAboutPluginDialog::Option>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KAboutPluginDialog::Options");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Option' enum/flags.

    qRegisterMetaType< ::KAboutPluginDialog::Option >("KAboutPluginDialog::Option");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KAboutPluginDialog::staticMetaObject, sizeof(KAboutPluginDialogWrapper));

    return pyType;
}
