#ifndef itkVectorContainerSwigInterface_h
#define itkVectorContainerSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "set"
#include "itkVectorContainer.h"
#include "itkDataObjectDecorator.h"

using itkVectorContainerULSC = itk::VectorContainer< unsigned long,signed char >;
using itkVectorContainerULSC_Pointer = itk::VectorContainer< unsigned long,signed char >::Pointer;
using itkVectorContainerUCSC = itk::VectorContainer< unsigned char,signed char >;
using itkVectorContainerUCSC_Pointer = itk::VectorContainer< unsigned char,signed char >::Pointer;
using itkVectorContainerULSS = itk::VectorContainer< unsigned long,signed short >;
using itkVectorContainerULSS_Pointer = itk::VectorContainer< unsigned long,signed short >::Pointer;
using itkVectorContainerUCSS = itk::VectorContainer< unsigned char,signed short >;
using itkVectorContainerUCSS_Pointer = itk::VectorContainer< unsigned char,signed short >::Pointer;
using itkVectorContainerULF = itk::VectorContainer< unsigned long,float >;
using itkVectorContainerULF_Pointer = itk::VectorContainer< unsigned long,float >::Pointer;
using itkVectorContainerUCF = itk::VectorContainer< unsigned char,float >;
using itkVectorContainerUCF_Pointer = itk::VectorContainer< unsigned char,float >::Pointer;
using itkVectorContainerULD = itk::VectorContainer< unsigned long,double >;
using itkVectorContainerULD_Pointer = itk::VectorContainer< unsigned long,double >::Pointer;
using itkVectorContainerUCD = itk::VectorContainer< unsigned char,double >;
using itkVectorContainerUCD_Pointer = itk::VectorContainer< unsigned char,double >::Pointer;
using itkVectorContainerULVF2 = itk::VectorContainer< unsigned long,itk::Vector< float,2 > >;
using itkVectorContainerULVF2_Pointer = itk::VectorContainer< unsigned long,itk::Vector< float,2 > >::Pointer;
using itkVectorContainerULPF2 = itk::VectorContainer< unsigned long,itk::Point< float,2 > >;
using itkVectorContainerULPF2_Pointer = itk::VectorContainer< unsigned long,itk::Point< float,2 > >::Pointer;
using itkVectorContainerULMF22 = itk::VectorContainer< unsigned long, itk::Matrix< float, 2, 2 > >;
using itkVectorContainerULMF22_Pointer = itk::VectorContainer< unsigned long, itk::Matrix< float, 2, 2 > >::Pointer;
using itkVectorContainerULVD2 = itk::VectorContainer< unsigned long,itk::Vector< double,2 > >;
using itkVectorContainerULVD2_Pointer = itk::VectorContainer< unsigned long,itk::Vector< double,2 > >::Pointer;
using itkVectorContainerULPD2 = itk::VectorContainer< unsigned long,itk::Point< double,2 > >;
using itkVectorContainerULPD2_Pointer = itk::VectorContainer< unsigned long,itk::Point< double,2 > >::Pointer;
using itkVectorContainerULMD22 = itk::VectorContainer< unsigned long, itk::Matrix< double, 2, 2 > >;
using itkVectorContainerULMD22_Pointer = itk::VectorContainer< unsigned long, itk::Matrix< double, 2, 2 > >::Pointer;
using itkVectorContainerULVF3 = itk::VectorContainer< unsigned long,itk::Vector< float,3 > >;
using itkVectorContainerULVF3_Pointer = itk::VectorContainer< unsigned long,itk::Vector< float,3 > >::Pointer;
using itkVectorContainerULPF3 = itk::VectorContainer< unsigned long,itk::Point< float,3 > >;
using itkVectorContainerULPF3_Pointer = itk::VectorContainer< unsigned long,itk::Point< float,3 > >::Pointer;
using itkVectorContainerULMF33 = itk::VectorContainer< unsigned long, itk::Matrix< float, 3, 3 > >;
using itkVectorContainerULMF33_Pointer = itk::VectorContainer< unsigned long, itk::Matrix< float, 3, 3 > >::Pointer;
using itkVectorContainerULVD3 = itk::VectorContainer< unsigned long,itk::Vector< double,3 > >;
using itkVectorContainerULVD3_Pointer = itk::VectorContainer< unsigned long,itk::Vector< double,3 > >::Pointer;
using itkVectorContainerULPD3 = itk::VectorContainer< unsigned long,itk::Point< double,3 > >;
using itkVectorContainerULPD3_Pointer = itk::VectorContainer< unsigned long,itk::Point< double,3 > >::Pointer;
using itkVectorContainerULMD33 = itk::VectorContainer< unsigned long, itk::Matrix< double, 3, 3 > >;
using itkVectorContainerULMD33_Pointer = itk::VectorContainer< unsigned long, itk::Matrix< double, 3, 3 > >::Pointer;
using itkVectorContainerULVF4 = itk::VectorContainer< unsigned long,itk::Vector< float,4 > >;
using itkVectorContainerULVF4_Pointer = itk::VectorContainer< unsigned long,itk::Vector< float,4 > >::Pointer;
using itkVectorContainerULPF4 = itk::VectorContainer< unsigned long,itk::Point< float,4 > >;
using itkVectorContainerULPF4_Pointer = itk::VectorContainer< unsigned long,itk::Point< float,4 > >::Pointer;
using itkVectorContainerULMF44 = itk::VectorContainer< unsigned long, itk::Matrix< float, 4, 4 > >;
using itkVectorContainerULMF44_Pointer = itk::VectorContainer< unsigned long, itk::Matrix< float, 4, 4 > >::Pointer;
using itkVectorContainerULVD4 = itk::VectorContainer< unsigned long,itk::Vector< double,4 > >;
using itkVectorContainerULVD4_Pointer = itk::VectorContainer< unsigned long,itk::Vector< double,4 > >::Pointer;
using itkVectorContainerULPD4 = itk::VectorContainer< unsigned long,itk::Point< double,4 > >;
using itkVectorContainerULPD4_Pointer = itk::VectorContainer< unsigned long,itk::Point< double,4 > >::Pointer;
using itkVectorContainerULMD44 = itk::VectorContainer< unsigned long, itk::Matrix< double, 4, 4 > >;
using itkVectorContainerULMD44_Pointer = itk::VectorContainer< unsigned long, itk::Matrix< double, 4, 4 > >::Pointer;
using itkVectorContainerULAF = itk::VectorContainer< unsigned long, itk::Array< float > >;
using itkVectorContainerULAF_Pointer = itk::VectorContainer< unsigned long, itk::Array< float > >::Pointer;
using itkVectorContainerULAD = itk::VectorContainer< unsigned long, itk::Array< double > >;
using itkVectorContainerULAD_Pointer = itk::VectorContainer< unsigned long, itk::Array< double > >::Pointer;
using itkVectorContainerUCO2 = itk::VectorContainer< unsigned char,itk::Offset< 2 > >;
using itkVectorContainerUCO2_Pointer = itk::VectorContainer< unsigned char,itk::Offset< 2 > >::Pointer;
using itkVectorContainerUICID2 = itk::VectorContainer< unsigned int,itk::ContinuousIndex< double,2 > >;
using itkVectorContainerUICID2_Pointer = itk::VectorContainer< unsigned int,itk::ContinuousIndex< double,2 > >::Pointer;
using itkVectorContainerUCO3 = itk::VectorContainer< unsigned char,itk::Offset< 3 > >;
using itkVectorContainerUCO3_Pointer = itk::VectorContainer< unsigned char,itk::Offset< 3 > >::Pointer;
using itkVectorContainerUICID3 = itk::VectorContainer< unsigned int,itk::ContinuousIndex< double,3 > >;
using itkVectorContainerUICID3_Pointer = itk::VectorContainer< unsigned int,itk::ContinuousIndex< double,3 > >::Pointer;
using itkVectorContainerUCO4 = itk::VectorContainer< unsigned char,itk::Offset< 4 > >;
using itkVectorContainerUCO4_Pointer = itk::VectorContainer< unsigned char,itk::Offset< 4 > >::Pointer;
using itkVectorContainerUICID4 = itk::VectorContainer< unsigned int,itk::ContinuousIndex< double,4 > >;
using itkVectorContainerUICID4_Pointer = itk::VectorContainer< unsigned int,itk::ContinuousIndex< double,4 > >::Pointer;
using itkVectorContainerUIVUC1 = itk::VectorContainer< unsigned int,itk::Vector< unsigned char,1 > >;
using itkVectorContainerUIVUC1_Pointer = itk::VectorContainer< unsigned int,itk::Vector< unsigned char,1 > >::Pointer;
using itkVectorContainerULSUL = itk::VectorContainer< unsigned long, std::set< unsigned long > >;
using itkVectorContainerULSUL_Pointer = itk::VectorContainer< unsigned long, std::set< unsigned long > >::Pointer;
using itkVectorContainerULUL = itk::VectorContainer< unsigned long, unsigned long >;
using itkVectorContainerULUL_Pointer = itk::VectorContainer< unsigned long, unsigned long >::Pointer;
using itkVectorContainerULUI = itk::VectorContainer< unsigned long, unsigned int >;
using itkVectorContainerULUI_Pointer = itk::VectorContainer< unsigned long, unsigned int >::Pointer;
using itkVectorContainerULUC = itk::VectorContainer< unsigned long, unsigned char >;
using itkVectorContainerULUC_Pointer = itk::VectorContainer< unsigned long, unsigned char >::Pointer;
using itkVectorContainerULULL = itk::VectorContainer< unsigned long, unsigned long long >;
using itkVectorContainerULULL_Pointer = itk::VectorContainer< unsigned long, unsigned long long >::Pointer;
using itkVectorContainerULUS = itk::VectorContainer< unsigned long, unsigned short >;
using itkVectorContainerULUS_Pointer = itk::VectorContainer< unsigned long, unsigned short >::Pointer;
using itkVectorContainerUIUL = itk::VectorContainer< unsigned int, unsigned long >;
using itkVectorContainerUIUL_Pointer = itk::VectorContainer< unsigned int, unsigned long >::Pointer;
using itkVectorContainerUIUI = itk::VectorContainer< unsigned int, unsigned int >;
using itkVectorContainerUIUI_Pointer = itk::VectorContainer< unsigned int, unsigned int >::Pointer;
using itkVectorContainerUIUC = itk::VectorContainer< unsigned int, unsigned char >;
using itkVectorContainerUIUC_Pointer = itk::VectorContainer< unsigned int, unsigned char >::Pointer;
using itkVectorContainerUIULL = itk::VectorContainer< unsigned int, unsigned long long >;
using itkVectorContainerUIULL_Pointer = itk::VectorContainer< unsigned int, unsigned long long >::Pointer;
using itkVectorContainerUIUS = itk::VectorContainer< unsigned int, unsigned short >;
using itkVectorContainerUIUS_Pointer = itk::VectorContainer< unsigned int, unsigned short >::Pointer;
using itkVectorContainerUCUL = itk::VectorContainer< unsigned char, unsigned long >;
using itkVectorContainerUCUL_Pointer = itk::VectorContainer< unsigned char, unsigned long >::Pointer;
using itkVectorContainerUCUI = itk::VectorContainer< unsigned char, unsigned int >;
using itkVectorContainerUCUI_Pointer = itk::VectorContainer< unsigned char, unsigned int >::Pointer;
using itkVectorContainerUCUC = itk::VectorContainer< unsigned char, unsigned char >;
using itkVectorContainerUCUC_Pointer = itk::VectorContainer< unsigned char, unsigned char >::Pointer;
using itkVectorContainerUCULL = itk::VectorContainer< unsigned char, unsigned long long >;
using itkVectorContainerUCULL_Pointer = itk::VectorContainer< unsigned char, unsigned long long >::Pointer;
using itkVectorContainerUCUS = itk::VectorContainer< unsigned char, unsigned short >;
using itkVectorContainerUCUS_Pointer = itk::VectorContainer< unsigned char, unsigned short >::Pointer;
using itkVectorContainerULLUL = itk::VectorContainer< unsigned long long, unsigned long >;
using itkVectorContainerULLUL_Pointer = itk::VectorContainer< unsigned long long, unsigned long >::Pointer;
using itkVectorContainerULLUI = itk::VectorContainer< unsigned long long, unsigned int >;
using itkVectorContainerULLUI_Pointer = itk::VectorContainer< unsigned long long, unsigned int >::Pointer;
using itkVectorContainerULLUC = itk::VectorContainer< unsigned long long, unsigned char >;
using itkVectorContainerULLUC_Pointer = itk::VectorContainer< unsigned long long, unsigned char >::Pointer;
using itkVectorContainerULLULL = itk::VectorContainer< unsigned long long, unsigned long long >;
using itkVectorContainerULLULL_Pointer = itk::VectorContainer< unsigned long long, unsigned long long >::Pointer;
using itkVectorContainerULLUS = itk::VectorContainer< unsigned long long, unsigned short >;
using itkVectorContainerULLUS_Pointer = itk::VectorContainer< unsigned long long, unsigned short >::Pointer;
using itkVectorContainerUSUL = itk::VectorContainer< unsigned short, unsigned long >;
using itkVectorContainerUSUL_Pointer = itk::VectorContainer< unsigned short, unsigned long >::Pointer;
using itkVectorContainerUSUI = itk::VectorContainer< unsigned short, unsigned int >;
using itkVectorContainerUSUI_Pointer = itk::VectorContainer< unsigned short, unsigned int >::Pointer;
using itkVectorContainerUSUC = itk::VectorContainer< unsigned short, unsigned char >;
using itkVectorContainerUSUC_Pointer = itk::VectorContainer< unsigned short, unsigned char >::Pointer;
using itkVectorContainerUSULL = itk::VectorContainer< unsigned short, unsigned long long >;
using itkVectorContainerUSULL_Pointer = itk::VectorContainer< unsigned short, unsigned long long >::Pointer;
using itkVectorContainerUSUS = itk::VectorContainer< unsigned short, unsigned short >;
using itkVectorContainerUSUS_Pointer = itk::VectorContainer< unsigned short, unsigned short >::Pointer;
using itkDataObjectDecoratorVCUCD = itk::DataObjectDecorator< itk::VectorContainer< unsigned char, double > >;
using itkDataObjectDecoratorVCUCD_Pointer = itk::DataObjectDecorator< itk::VectorContainer< unsigned char, double > >::Pointer;


#include "ITKCommonBaseSwigInterface.h"
#include "itkArraySwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkVectorContainerSwigInterface.h"
#include "itkOffsetSwigInterface.h"
#include "itkPointSwigInterface.h"
#include "itkContinuousIndexSwigInterface.h"
#include "itkMatrixSwigInterface.h"
#endif
