{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node controlling the opacity of its single child node.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.OpacityNode
    ( 

-- * Exported types
    OpacityNode(..)                         ,
    IsOpacityNode                           ,
    toOpacityNode                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.OpacityNode#g:method:getChild"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpacity]("GI.Gsk.Objects.OpacityNode#g:method:getOpacity"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveOpacityNodeMethod                ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    OpacityNodeGetChildMethodInfo           ,
#endif
    opacityNodeGetChild                     ,


-- ** getOpacity #method:getOpacity#

#if defined(ENABLE_OVERLOADING)
    OpacityNodeGetOpacityMethodInfo         ,
#endif
    opacityNodeGetOpacity                   ,


-- ** new #method:new#

    opacityNodeNew                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype OpacityNode = OpacityNode (SP.ManagedPtr OpacityNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype OpacityNode where
    toManagedPtr (OpacityNode p) = p

foreign import ccall "gsk_opacity_node_get_type"
    c_gsk_opacity_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject OpacityNode where
    glibType = c_gsk_opacity_node_get_type

-- | Type class for types which can be safely cast to t'OpacityNode', for instance with `toOpacityNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf OpacityNode o) => IsOpacityNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf OpacityNode o) => IsOpacityNode o

instance O.HasParentTypes OpacityNode
type instance O.ParentTypes OpacityNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'OpacityNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toOpacityNode :: (MIO.MonadIO m, IsOpacityNode o) => o -> m OpacityNode
toOpacityNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo OpacityNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveOpacityNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOpacityNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveOpacityNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveOpacityNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveOpacityNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveOpacityNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveOpacityNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveOpacityNodeMethod "getChild" o = OpacityNodeGetChildMethodInfo
    ResolveOpacityNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveOpacityNodeMethod "getOpacity" o = OpacityNodeGetOpacityMethodInfo
    ResolveOpacityNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveOpacityNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOpacityNodeMethod t OpacityNode, O.OverloadedMethod info OpacityNode p) => OL.IsLabel t (OpacityNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOpacityNodeMethod t OpacityNode, O.OverloadedMethod info OpacityNode p, R.HasField t OpacityNode p) => R.HasField t OpacityNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOpacityNodeMethod t OpacityNode, O.OverloadedMethodInfo info OpacityNode) => OL.IsLabel t (O.MethodProxy info OpacityNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr OpacityNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method OpacityNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The node to draw" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "opacity"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The opacity to apply"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "OpacityNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_opacity_node_new" gsk_opacity_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    CFloat ->                               -- opacity : TBasicType TFloat
    IO (Ptr OpacityNode)

-- | Creates a @GskRenderNode@ that will drawn the /@child@/ with reduced
-- /@opacity@/.
opacityNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    a
    -- ^ /@child@/: The node to draw
    -> Float
    -- ^ /@opacity@/: The opacity to apply
    -> m OpacityNode
    -- ^ __Returns:__ A new @GskRenderNode@
opacityNodeNew child opacity = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    let opacity' = realToFrac opacity
    result <- gsk_opacity_node_new child' opacity'
    checkUnexpectedReturnNULL "opacityNodeNew" result
    result' <- (wrapPtr OpacityNode) result
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method OpacityNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "OpacityNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for an opacity"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_opacity_node_get_child" gsk_opacity_node_get_child :: 
    Ptr OpacityNode ->                      -- node : TInterface (Name {namespace = "Gsk", name = "OpacityNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Gets the child node that is getting opacityed by the given /@node@/.
opacityNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsOpacityNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for an opacity
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ The child that is getting opacityed
opacityNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_opacity_node_get_child node'
    checkUnexpectedReturnNULL "opacityNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data OpacityNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsOpacityNode a) => O.OverloadedMethod OpacityNodeGetChildMethodInfo a signature where
    overloadedMethod = opacityNodeGetChild

instance O.OverloadedMethodInfo OpacityNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.OpacityNode.opacityNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-OpacityNode.html#v:opacityNodeGetChild"
        })


#endif

-- method OpacityNode::get_opacity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "OpacityNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for an opacity"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_opacity_node_get_opacity" gsk_opacity_node_get_opacity :: 
    Ptr OpacityNode ->                      -- node : TInterface (Name {namespace = "Gsk", name = "OpacityNode"})
    IO CFloat

-- | Gets the transparency factor for an opacity node.
opacityNodeGetOpacity ::
    (B.CallStack.HasCallStack, MonadIO m, IsOpacityNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for an opacity
    -> m Float
    -- ^ __Returns:__ the opacity factor
opacityNodeGetOpacity node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_opacity_node_get_opacity node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data OpacityNodeGetOpacityMethodInfo
instance (signature ~ (m Float), MonadIO m, IsOpacityNode a) => O.OverloadedMethod OpacityNodeGetOpacityMethodInfo a signature where
    overloadedMethod = opacityNodeGetOpacity

instance O.OverloadedMethodInfo OpacityNodeGetOpacityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.OpacityNode.opacityNodeGetOpacity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-OpacityNode.html#v:opacityNodeGetOpacity"
        })


#endif


