{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.GLib.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace GLib"
 , ""
 , "# \"terminator_pos\" is not marked as out."
 , "ignore IOChannel.read_line_string"
 , ""
 , "# The test_data argument is not marked as a closure."
 , "ignore test_add_data_func_full"
 , ""
 , "# \"result\" parameter is an array, but it is not marked as such."
 , "ignore unichar_fully_decompose"
 , ""
 , "# These require more complex logic."
 , "ignore base64_decode_step"
 , "ignore base64_encode_step"
 , "ignore base64_encode_close"
 , ""
 , "# Return type (correctly) marked as nullable since 2.54 at least."
 , "set-attr GLib/TimeVal/to_iso8601/@return-value nullable 1"
 , ""
 , "# The return value does not have its refcount incremented"
 , "# See https://github.com/haskell-gi/haskell-gi/issues/173"
 , "set-attr GLib/Thread/self/@return-value transfer-ownership none"
 , ""
 , "if windows"
 , "   # Windows only macros in glib/gfileutils.h"
 , "   set-attr GLib/file_get_contents c:identifier g_file_get_contents_utf8"
 , "   set-attr GLib/file_open_tmp c:identifier g_file_open_tmp_utf8"
 , "   set-attr GLib/file_test c:identifier g_file_test_utf8"
 , "   set-attr GLib/mkstemp c:identifier g_mkstemp_utf8"
 , "   set-attr GLib/get_current_dir c:identifier g_get_current_dir_utf8"
 , "   ignore file_get_contents_utf8"
 , "   ignore file_open_tmp_utf8"
 , "   ignore file_test_utf8"
 , "   ignore mkstemp_utf8"
 , "   ignore get_current_dir_utf8"
 , ""
 , "   # Windows only macros in glib/gconvert.h"
 , "   set-attr GLib/filename_from_uri c:identifier g_filename_from_uri_utf8"
 , "   set-attr GLib/filename_from_utf8 c:identifier g_filename_from_utf8_utf8"
 , "   set-attr GLib/filename_to_uri c:identifier g_filename_to_uri_utf8"
 , "   set-attr GLib/filename_to_utf8 c:identifier g_filename_to_utf8_utf8"
 , "   ignore filename_from_uri_utf8"
 , "   ignore filename_from_utf8_utf8"
 , "   ignore filename_to_uri_utf8"
 , "   ignore filename_to_utf8_utf8"
 , ""
 , "   # Windows only macros in glib/genviron.h"
 , "   set-attr GLib/getenv c:identifier g_getenv_utf8"
 , "   set-attr GLib/setenv c:identifier g_setenv_utf8"
 , "   set-attr GLib/unsetenv c:identifier g_unsetenv_utf8"
 , "   ignore getenv_utf8"
 , "   ignore setenv_utf8"
 , "   ignore unsetenv_utf8"
 , ""
 , "   # Windows only macros in glib/gdir.h"
 , "   set-attr GLib/Dir/open c:identifier g_dir_open_utf8"
 , "   set-attr GLib/Dir/read_name c:identifier g_dir_read_name_utf8"
 , "   ignore Dir.open_utf8"
 , "   ignore Dir.read_name_utf8"
 , ""
 , "   # Windows only macros in glib/gmodule.h (not in GIR yet)"
 , "   set-attr GLib/Module/open c:identifier g_module_name_utf8"
 , "   set-attr GLib/Module/name c:identifier g_module_name_utf8"
 , "   ignore Module.open_utf8"
 , "   ignore Module.name_utf8"
 , ""
 , "   # Windows only macros in glib/giochannel.h"
 , "   set-attr GLib/IOChannel/new_file c:identifier g_io_channel_new_file_utf8"
 , "   ignore IOChannel.new_file_utf8"
 , "   # Use win32_new_socket (this \"stream\" version was only for binary compatibility)"
 , "   ignore IOChannel.win32_new_stream_socket"
 , ""
 , "   # ifdef G_OS_UNIX in glib/gmain.h"
 , "   ignore Source.add_unix_fd"
 , "   ignore Source.modify_unix_fd"
 , "   ignore Source.query_unix_fd"
 , "   ignore Source.remove_unix_fd"
 , ""
 , "   # Windows only macros in glib/spawn.h"
 , "   set-attr GLib/spawn_async c:identifier g_spawn_async_utf8"
 , "   set-attr GLib/spawn_async_with_pipes c:identifier g_spawn_async_with_pipes_utf8"
 , "   set-attr GLib/spawn_command_line_async c:identifier g_spawn_command_line_async_utf8"
 , "   set-attr GLib/spawn_command_line_sync c:identifier g_spawn_command_line_sync_utf8"
 , "   set-attr GLib/spawn_sync c:identifier g_spawn_sync_utf8"
 , "   ignore spawn_async_utf8"
 , "   ignore spawn_async_with_pipes_utf8"
 , "   ignore spawn_command_line_async_utf8"
 , "   ignore spawn_command_line_sync_utf8"
 , "   ignore spawn_sync_utf8"
 , ""
 , "   # In G_OS_UNIX only file glib/glib-unix.h"
 , "   ignore unix_error_quark"
 , "   ignore unix_fd_add"
 , "   ignore unix_fd_add_full"
 , "   ignore unix_fd_source_new"
 , "   ignore unix_open_pipe"
 , "   ignore unix_set_fd_nonblocking"
 , "   ignore unix_signal_add"
 , "   ignore unix_signal_add_full"
 , "   ignore unix_signal_source_new"
 , "endif"
 , ""
 , "# Generated from glib 2.48.0 with xsltproc Nullable.xslt GLib-2.0.gir"
 , "set-attr GLib/Array/sort_with_data/@parameters/user_data nullable 1"
 , "set-attr GLib/AsyncQueue/pop/@return-value nullable 1"
 , "set-attr GLib/AsyncQueue/pop_unlocked/@return-value nullable 1"
 , "set-attr GLib/AsyncQueue/push/@parameters/data nullable 1"
 , "set-attr GLib/AsyncQueue/push_front/@parameters/item nullable 1"
 , "set-attr GLib/AsyncQueue/push_front_unlocked/@parameters/item nullable 1"
 , "set-attr GLib/AsyncQueue/push_sorted/@parameters/data nullable 1"
 , "set-attr GLib/AsyncQueue/push_sorted/@parameters/user_data nullable 1"
 , "set-attr GLib/AsyncQueue/push_sorted_unlocked/@parameters/data nullable 1"
 , "set-attr GLib/AsyncQueue/push_sorted_unlocked/@parameters/user_data nullable 1"
 , "set-attr GLib/AsyncQueue/push_unlocked/@parameters/data nullable 1"
 , "set-attr GLib/AsyncQueue/remove/@parameters/item nullable 1"
 , "set-attr GLib/AsyncQueue/remove_unlocked/@parameters/item nullable 1"
 , "set-attr GLib/AsyncQueue/sort/@parameters/user_data nullable 1"
 , "set-attr GLib/AsyncQueue/sort_unlocked/@parameters/user_data nullable 1"
 , "set-attr GLib/AsyncQueue/timed_pop/@return-value nullable 1"
 , "set-attr GLib/AsyncQueue/timed_pop_unlocked/@return-value nullable 1"
 , "set-attr GLib/AsyncQueue/timeout_pop/@return-value nullable 1"
 , "set-attr GLib/AsyncQueue/timeout_pop_unlocked/@return-value nullable 1"
 , "set-attr GLib/AsyncQueue/try_pop/@return-value nullable 1"
 , "set-attr GLib/AsyncQueue/try_pop_unlocked/@return-value nullable 1"
 , "set-attr GLib/BookmarkFile/add_application/@parameters/name nullable 1"
 , "set-attr GLib/BookmarkFile/add_application/@parameters/exec nullable 1"
 , "set-attr GLib/BookmarkFile/get_title/@parameters/uri nullable 1"
 , "set-attr GLib/BookmarkFile/load_from_data_dirs/@parameters/full_path nullable 1"
 , "set-attr GLib/BookmarkFile/move_item/@parameters/new_uri nullable 1"
 , "set-attr GLib/BookmarkFile/set_description/@parameters/uri nullable 1"
 , "set-attr GLib/BookmarkFile/set_groups/@parameters/groups nullable 1"
 , "set-attr GLib/BookmarkFile/set_icon/@parameters/href nullable 1"
 , "set-attr GLib/BookmarkFile/set_title/@parameters/uri nullable 1"
 , "set-attr GLib/ByteArray/sort_with_data/@parameters/user_data nullable 1"
 , "set-attr GLib/Bytes/new/@parameters/data nullable 1"
 , "set-attr GLib/Bytes/new_static/@parameters/data nullable 1"
 , "set-attr GLib/Bytes/new_take/@parameters/data nullable 1"
 , "set-attr GLib/Bytes/new_with_free_func/@parameters/data nullable 1"
 , "set-attr GLib/Bytes/new_with_free_func/@parameters/user_data nullable 1"
 , "set-attr GLib/Bytes/get_data/@return-value nullable 1"
 , "set-attr GLib/Bytes/unref/@parameters/bytes nullable 1"
 , "set-attr GLib/ChildWatchFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/CompareDataFunc/@parameters/a nullable 1"
 , "set-attr GLib/CompareDataFunc/@parameters/b nullable 1"
 , "set-attr GLib/CompareDataFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/CompareFunc/@parameters/a nullable 1"
 , "set-attr GLib/CompareFunc/@parameters/b nullable 1"
 , "set-attr GLib/CopyFunc/@parameters/data nullable 1"
 , "set-attr GLib/DataForeachFunc/@parameters/data nullable 1"
 , "set-attr GLib/DataForeachFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/DestroyNotify/@parameters/data nullable 1"
 , "set-attr GLib/Dir/make_tmp/@parameters/tmpl nullable 1"
 , "set-attr GLib/DuplicateFunc/@return-value nullable 1"
 , "set-attr GLib/DuplicateFunc/@parameters/data nullable 1"
 , "set-attr GLib/DuplicateFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/EqualFunc/@parameters/a nullable 1"
 , "set-attr GLib/EqualFunc/@parameters/b nullable 1"
 , "set-attr GLib/Error/matches/@parameters/error nullable 1"
 , "set-attr GLib/FreeFunc/@parameters/data nullable 1"
 , "set-attr GLib/Func/@parameters/data nullable 1"
 , "set-attr GLib/Func/@parameters/user_data nullable 1"
 , "set-attr GLib/HFunc/@parameters/key nullable 1"
 , "set-attr GLib/HFunc/@parameters/value nullable 1"
 , "set-attr GLib/HFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/HRFunc/@parameters/key nullable 1"
 , "set-attr GLib/HRFunc/@parameters/value nullable 1"
 , "set-attr GLib/HRFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/HashFunc/@parameters/key nullable 1"
 , "set-attr GLib/HashTable/add/@parameters/key nullable 1"
 , "set-attr GLib/HashTable/contains/@parameters/key nullable 1"
 , "set-attr GLib/HashTable/find/@return-value nullable 1"
 , "set-attr GLib/HashTable/find/@parameters/user_data nullable 1"
 , "set-attr GLib/HashTable/foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/HashTable/foreach_remove/@parameters/user_data nullable 1"
 , "set-attr GLib/HashTable/foreach_steal/@parameters/user_data nullable 1"
 , "set-attr GLib/HashTable/insert/@parameters/key nullable 1"
 , "set-attr GLib/HashTable/insert/@parameters/value nullable 1"
 , "set-attr GLib/HashTable/lookup/@return-value nullable 1"
 , "set-attr GLib/HashTable/lookup/@parameters/key nullable 1"
 , "set-attr GLib/HashTable/lookup_extended/@parameters/lookup_key nullable 1"
 , "set-attr GLib/HashTable/lookup_extended/@parameters/orig_key nullable 1"
 , "set-attr GLib/HashTable/lookup_extended/@parameters/value nullable 1"
 , "set-attr GLib/HashTable/new_full/@parameters/key_destroy_func nullable 1"
 , "set-attr GLib/HashTable/new_full/@parameters/value_destroy_func nullable 1"
 , "set-attr GLib/HashTable/remove/@parameters/key nullable 1"
 , "set-attr GLib/HashTable/replace/@parameters/key nullable 1"
 , "set-attr GLib/HashTable/replace/@parameters/value nullable 1"
 , "set-attr GLib/HashTable/steal/@parameters/key nullable 1"
 , "set-attr GLib/HashTableIter/next/@parameters/key nullable 1"
 , "set-attr GLib/HashTableIter/next/@parameters/value nullable 1"
 , "set-attr GLib/HashTableIter/replace/@parameters/value nullable 1"
 , "set-attr GLib/Hook/find/@parameters/data nullable 1"
 , "set-attr GLib/Hook/find_data/@parameters/data nullable 1"
 , "set-attr GLib/Hook/find_func/@parameters/func nullable 1"
 , "set-attr GLib/Hook/find_func_data/@parameters/data nullable 1"
 , "set-attr GLib/Hook/insert_before/@parameters/sibling nullable 1"
 , "set-attr GLib/HookCheckFunc/@parameters/data nullable 1"
 , "set-attr GLib/HookCheckMarshaller/@parameters/marshal_data nullable 1"
 , "set-attr GLib/HookFindFunc/@parameters/data nullable 1"
 , "set-attr GLib/HookFunc/@parameters/data nullable 1"
 , "set-attr GLib/HookList/marshal/@parameters/marshal_data nullable 1"
 , "set-attr GLib/HookList/marshal_check/@parameters/marshal_data nullable 1"
 , "set-attr GLib/HookMarshaller/@parameters/marshal_data nullable 1"
 , "set-attr GLib/IOChannel/read_line_string/@parameters/terminator_pos nullable 1"
 , "set-attr GLib/IOChannel/set_encoding/@parameters/encoding nullable 1"
 , "set-attr GLib/IOChannel/set_line_term/@parameters/line_term nullable 1"
 , "set-attr GLib/IOFunc/@parameters/data nullable 1"
 , "set-attr GLib/KeyFile/get_comment/@parameters/group_name nullable 1"
 , "set-attr GLib/KeyFile/get_locale_string/@parameters/locale nullable 1"
 , "set-attr GLib/KeyFile/get_locale_string_list/@parameters/locale nullable 1"
 , "set-attr GLib/KeyFile/remove_comment/@parameters/group_name nullable 1"
 , "set-attr GLib/KeyFile/remove_comment/@parameters/key nullable 1"
 , "set-attr GLib/KeyFile/set_comment/@parameters/group_name nullable 1"
 , "set-attr GLib/KeyFile/set_comment/@parameters/key nullable 1"
 , "set-attr GLib/List/append/@parameters/data nullable 1"
 , "set-attr GLib/List/copy_deep/@parameters/user_data nullable 1"
 , "set-attr GLib/List/find/@parameters/data nullable 1"
 , "set-attr GLib/List/find_custom/@parameters/data nullable 1"
 , "set-attr GLib/List/foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/List/index/@parameters/data nullable 1"
 , "set-attr GLib/List/insert/@parameters/data nullable 1"
 , "set-attr GLib/List/insert_before/@parameters/data nullable 1"
 , "set-attr GLib/List/insert_sorted/@parameters/data nullable 1"
 , "set-attr GLib/List/insert_sorted_with_data/@parameters/data nullable 1"
 , "set-attr GLib/List/insert_sorted_with_data/@parameters/user_data nullable 1"
 , "set-attr GLib/List/nth_data/@return-value nullable 1"
 , "set-attr GLib/List/prepend/@parameters/data nullable 1"
 , "set-attr GLib/List/remove/@parameters/data nullable 1"
 , "set-attr GLib/List/remove_all/@parameters/data nullable 1"
 , "set-attr GLib/List/sort_with_data/@parameters/user_data nullable 1"
 , "set-attr GLib/LogFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/MainContext/add_poll/@parameters/context nullable 1"
 , "set-attr GLib/MainContext/find_source_by_funcs_user_data/@parameters/context nullable 1"
 , "set-attr GLib/MainContext/find_source_by_funcs_user_data/@parameters/user_data nullable 1"
 , "set-attr GLib/MainContext/find_source_by_id/@parameters/context nullable 1"
 , "set-attr GLib/MainContext/find_source_by_user_data/@parameters/user_data nullable 1"
 , "set-attr GLib/MainContext/invoke/@parameters/context nullable 1"
 , "set-attr GLib/MainContext/invoke/@parameters/data nullable 1"
 , "set-attr GLib/MainContext/invoke_full/@parameters/context nullable 1"
 , "set-attr GLib/MainContext/invoke_full/@parameters/data nullable 1"
 , "set-attr GLib/MainContext/invoke_full/@parameters/notify nullable 1"
 , "set-attr GLib/MainContext/iteration/@parameters/context nullable 1"
 , "set-attr GLib/MainContext/pending/@parameters/context nullable 1"
 , "set-attr GLib/MainContext/pop_thread_default/@parameters/context nullable 1"
 , "set-attr GLib/MainContext/push_thread_default/@parameters/context nullable 1"
 , "set-attr GLib/MainLoop/new/@parameters/context nullable 1"
 , "set-attr GLib/MarkupParseContext/new/@parameters/user_data nullable 1"
 , "set-attr GLib/MarkupParseContext/get_position/@parameters/line_number nullable 1"
 , "set-attr GLib/MarkupParseContext/get_position/@parameters/char_number nullable 1"
 , "set-attr GLib/MarkupParseContext/get_user_data/@return-value nullable 1"
 , "set-attr GLib/MarkupParseContext/pop/@return-value nullable 1"
 , "set-attr GLib/MarkupParseContext/push/@parameters/user_data nullable 1"
 , "set-attr GLib/MarkupParser/start_element/start_element/@parameters/user_data nullable 1"
 , "set-attr GLib/MarkupParser/end_element/end_element/@parameters/user_data nullable 1"
 , "set-attr GLib/MarkupParser/text/text/@parameters/user_data nullable 1"
 , "set-attr GLib/MarkupParser/passthrough/passthrough/@parameters/user_data nullable 1"
 , "set-attr GLib/MarkupParser/error/error/@parameters/user_data nullable 1"
 , "set-attr GLib/MatchInfo/expand_references/@return-value nullable 1"
 , "set-attr GLib/MatchInfo/expand_references/@parameters/match_info nullable 1"
 , "set-attr GLib/MatchInfo/fetch/@return-value nullable 1"
 , "set-attr GLib/MatchInfo/fetch_named/@return-value nullable 1"
 , "set-attr GLib/MatchInfo/free/@parameters/match_info nullable 1"
 , "set-attr GLib/Node/child_index/@parameters/data nullable 1"
 , "set-attr GLib/Node/children_foreach/@parameters/data nullable 1"
 , "set-attr GLib/Node/copy_deep/@parameters/data nullable 1"
 , "set-attr GLib/Node/find/@parameters/data nullable 1"
 , "set-attr GLib/Node/find_child/@parameters/data nullable 1"
 , "set-attr GLib/Node/traverse/@parameters/data nullable 1"
 , "set-attr GLib/Node/new/@parameters/data nullable 1"
 , "set-attr GLib/NodeForeachFunc/@parameters/data nullable 1"
 , "set-attr GLib/NodeTraverseFunc/@parameters/data nullable 1"
 , "set-attr GLib/Once/impl/@return-value nullable 1"
 , "set-attr GLib/Once/impl/@parameters/arg nullable 1"
 , "set-attr GLib/OptionArgFunc/@parameters/data nullable 1"
 , "set-attr GLib/OptionContext/add_main_entries/@parameters/translation_domain nullable 1"
 , "set-attr GLib/OptionContext/get_help/@parameters/group nullable 1"
 , "set-attr GLib/OptionContext/parse/@parameters/argc nullable 1"
 , "set-attr GLib/OptionContext/parse/@parameters/argv nullable 1"
 , "set-attr GLib/OptionContext/set_description/@parameters/description nullable 1"
 , "set-attr GLib/OptionContext/set_summary/@parameters/summary nullable 1"
 , "set-attr GLib/OptionContext/set_translate_func/@parameters/func nullable 1"
 , "set-attr GLib/OptionContext/set_translate_func/@parameters/data nullable 1"
 , "set-attr GLib/OptionContext/set_translate_func/@parameters/destroy_notify nullable 1"
 , "set-attr GLib/OptionContext/new/@parameters/parameter_string nullable 1"
 , "set-attr GLib/OptionErrorFunc/@parameters/data nullable 1"
 , "set-attr GLib/OptionGroup/new/@parameters/user_data nullable 1"
 , "set-attr GLib/OptionGroup/new/@parameters/destroy nullable 1"
 , "set-attr GLib/OptionGroup/set_parse_hooks/@parameters/pre_parse_func nullable 1"
 , "set-attr GLib/OptionGroup/set_parse_hooks/@parameters/post_parse_func nullable 1"
 , "set-attr GLib/OptionGroup/set_translate_func/@parameters/func nullable 1"
 , "set-attr GLib/OptionGroup/set_translate_func/@parameters/data nullable 1"
 , "set-attr GLib/OptionGroup/set_translate_func/@parameters/destroy_notify nullable 1"
 , "set-attr GLib/OptionParseFunc/@parameters/data nullable 1"
 , "set-attr GLib/Private/get/@return-value nullable 1"
 , "set-attr GLib/Private/replace/@parameters/value nullable 1"
 , "set-attr GLib/Private/set/@parameters/value nullable 1"
 , "set-attr GLib/PtrArray/add/@parameters/data nullable 1"
 , "set-attr GLib/PtrArray/foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/PtrArray/free/@return-value nullable 1"
 , "set-attr GLib/PtrArray/insert/@parameters/data nullable 1"
 , "set-attr GLib/PtrArray/new_full/@parameters/element_free_func nullable 1"
 , "set-attr GLib/PtrArray/new_with_free_func/@parameters/element_free_func nullable 1"
 , "set-attr GLib/PtrArray/remove/@parameters/data nullable 1"
 , "set-attr GLib/PtrArray/remove_fast/@parameters/data nullable 1"
 , "set-attr GLib/PtrArray/remove_index/@return-value nullable 1"
 , "set-attr GLib/PtrArray/remove_index_fast/@return-value nullable 1"
 , "set-attr GLib/PtrArray/set_free_func/@parameters/element_free_func nullable 1"
 , "set-attr GLib/PtrArray/sort_with_data/@parameters/user_data nullable 1"
 , "set-attr GLib/Queue/find/@parameters/data nullable 1"
 , "set-attr GLib/Queue/find_custom/@parameters/data nullable 1"
 , "set-attr GLib/Queue/foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/Queue/index/@parameters/data nullable 1"
 , "set-attr GLib/Queue/insert_after/@parameters/sibling nullable 1"
 , "set-attr GLib/Queue/insert_after/@parameters/data nullable 1"
 , "set-attr GLib/Queue/insert_before/@parameters/sibling nullable 1"
 , "set-attr GLib/Queue/insert_before/@parameters/data nullable 1"
 , "set-attr GLib/Queue/insert_sorted/@parameters/data nullable 1"
 , "set-attr GLib/Queue/insert_sorted/@parameters/user_data nullable 1"
 , "set-attr GLib/Queue/peek_head/@return-value nullable 1"
 , "set-attr GLib/Queue/peek_nth/@return-value nullable 1"
 , "set-attr GLib/Queue/peek_tail/@return-value nullable 1"
 , "set-attr GLib/Queue/pop_head/@return-value nullable 1"
 , "set-attr GLib/Queue/pop_nth/@return-value nullable 1"
 , "set-attr GLib/Queue/pop_tail/@return-value nullable 1"
 , "set-attr GLib/Queue/push_head/@parameters/data nullable 1"
 , "set-attr GLib/Queue/push_nth/@parameters/data nullable 1"
 , "set-attr GLib/Queue/push_tail/@parameters/data nullable 1"
 , "set-attr GLib/Queue/remove/@parameters/data nullable 1"
 , "set-attr GLib/Queue/remove_all/@parameters/data nullable 1"
 , "set-attr GLib/Queue/sort/@parameters/user_data nullable 1"
 , "set-attr GLib/Regex/new/@return-value nullable 1"
 , "set-attr GLib/Regex/replace_eval/@parameters/user_data nullable 1"
 , "set-attr GLib/RegexEvalCallback/@parameters/user_data nullable 1"
 , "set-attr GLib/SList/append/@parameters/data nullable 1"
 , "set-attr GLib/SList/copy_deep/@parameters/user_data nullable 1"
 , "set-attr GLib/SList/find/@parameters/data nullable 1"
 , "set-attr GLib/SList/find_custom/@parameters/data nullable 1"
 , "set-attr GLib/SList/foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/SList/index/@parameters/data nullable 1"
 , "set-attr GLib/SList/insert/@parameters/data nullable 1"
 , "set-attr GLib/SList/insert_before/@parameters/data nullable 1"
 , "set-attr GLib/SList/insert_sorted/@parameters/data nullable 1"
 , "set-attr GLib/SList/insert_sorted_with_data/@parameters/data nullable 1"
 , "set-attr GLib/SList/insert_sorted_with_data/@parameters/user_data nullable 1"
 , "set-attr GLib/SList/nth_data/@return-value nullable 1"
 , "set-attr GLib/SList/prepend/@parameters/data nullable 1"
 , "set-attr GLib/SList/remove/@parameters/data nullable 1"
 , "set-attr GLib/SList/remove_all/@parameters/data nullable 1"
 , "set-attr GLib/SList/sort_with_data/@parameters/user_data nullable 1"
 , "set-attr GLib/Scanner/lookup_symbol/@return-value nullable 1"
 , "set-attr GLib/Scanner/scope_add_symbol/@parameters/value nullable 1"
 , "set-attr GLib/Scanner/scope_foreach_symbol/@parameters/user_data nullable 1"
 , "set-attr GLib/Scanner/scope_lookup_symbol/@return-value nullable 1"
 , "set-attr GLib/Sequence/append/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/Sequence/insert_sorted/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/insert_sorted/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/insert_sorted_iter/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/insert_sorted_iter/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/lookup/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/lookup/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/lookup_iter/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/lookup_iter/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/prepend/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/search/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/search/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/search_iter/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/search_iter/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/sort/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/sort_iter/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/foreach_range/@parameters/user_data nullable 1"
 , "set-attr GLib/Sequence/get/@return-value nullable 1"
 , "set-attr GLib/Sequence/insert_before/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/new/@parameters/data_destroy nullable 1"
 , "set-attr GLib/Sequence/set/@parameters/data nullable 1"
 , "set-attr GLib/Sequence/sort_changed/@parameters/cmp_data nullable 1"
 , "set-attr GLib/Sequence/sort_changed_iter/@parameters/cmp_data nullable 1"
 , "set-attr GLib/SequenceIterCompareFunc/@parameters/data nullable 1"
 , "set-attr GLib/Source/attach/@parameters/context nullable 1"
 , "set-attr GLib/Source/get_context/@return-value nullable 1"
 , "set-attr GLib/Source/set_callback/@parameters/data nullable 1"
 , "set-attr GLib/Source/set_callback/@parameters/notify nullable 1"
 , "set-attr GLib/Source/set_callback_indirect/@parameters/callback_data nullable 1"
 , "set-attr GLib/Source/remove_by_funcs_user_data/@parameters/user_data nullable 1"
 , "set-attr GLib/Source/remove_by_user_data/@parameters/user_data nullable 1"
 , "set-attr GLib/SourceCallbackFuncs/get/get/@parameters/data nullable 1"
 , "set-attr GLib/SourceFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/SourceFuncs/dispatch/dispatch/@parameters/user_data nullable 1"
 , "set-attr GLib/SpawnChildSetupFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/String/free/@return-value nullable 1"
 , "set-attr GLib/TestDataFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/TestFixtureFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/TestLogFatalFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/Thread/new/@parameters/name nullable 1"
 , "set-attr GLib/Thread/new/@parameters/data nullable 1"
 , "set-attr GLib/Thread/try_new/@parameters/name nullable 1"
 , "set-attr GLib/Thread/try_new/@parameters/data nullable 1"
 , "set-attr GLib/Thread/join/@return-value nullable 1"
 , "set-attr GLib/Thread/exit/@parameters/retval nullable 1"
 , "set-attr GLib/ThreadFunc/@return-value nullable 1"
 , "set-attr GLib/ThreadFunc/@parameters/data nullable 1"
 , "set-attr GLib/ThreadPool/move_to_front/@parameters/data nullable 1"
 , "set-attr GLib/ThreadPool/push/@parameters/data nullable 1"
 , "set-attr GLib/ThreadPool/set_sort_function/@parameters/user_data nullable 1"
 , "set-attr GLib/ThreadPool/new/@parameters/user_data nullable 1"
 , "set-attr GLib/TimeZone/new/@parameters/identifier nullable 1"
 , "set-attr GLib/TranslateFunc/@parameters/data nullable 1"
 , "set-attr GLib/TrashStack/peek/@return-value nullable 1"
 , "set-attr GLib/TrashStack/pop/@return-value nullable 1"
 , "set-attr GLib/TraverseFunc/@parameters/key nullable 1"
 , "set-attr GLib/TraverseFunc/@parameters/value nullable 1"
 , "set-attr GLib/TraverseFunc/@parameters/data nullable 1"
 , "set-attr GLib/Tree/foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/Tree/insert/@parameters/key nullable 1"
 , "set-attr GLib/Tree/insert/@parameters/value nullable 1"
 , "set-attr GLib/Tree/lookup/@return-value nullable 1"
 , "set-attr GLib/Tree/lookup/@parameters/key nullable 1"
 , "set-attr GLib/Tree/lookup_extended/@parameters/lookup_key nullable 1"
 , "set-attr GLib/Tree/lookup_extended/@parameters/orig_key nullable 1"
 , "set-attr GLib/Tree/lookup_extended/@parameters/value nullable 1"
 , "set-attr GLib/Tree/remove/@parameters/key nullable 1"
 , "set-attr GLib/Tree/replace/@parameters/key nullable 1"
 , "set-attr GLib/Tree/replace/@parameters/value nullable 1"
 , "set-attr GLib/Tree/search/@return-value nullable 1"
 , "set-attr GLib/Tree/search/@parameters/user_data nullable 1"
 , "set-attr GLib/Tree/steal/@parameters/key nullable 1"
 , "set-attr GLib/Tree/traverse/@parameters/user_data nullable 1"
 , "set-attr GLib/Tree/new_full/@parameters/key_compare_data nullable 1"
 , "set-attr GLib/Tree/new_with_data/@parameters/key_compare_data nullable 1"
 , "set-attr GLib/UnixFDSourceFunc/@parameters/user_data nullable 1"
 , "set-attr GLib/Variant/new_array/@parameters/child_type nullable 1"
 , "set-attr GLib/Variant/new_array/@parameters/children nullable 1"
 , "set-attr GLib/Variant/new_fixed_array/@parameters/elements nullable 1"
 , "set-attr GLib/Variant/new_from_data/@parameters/user_data nullable 1"
 , "set-attr GLib/Variant/new_maybe/@parameters/child_type nullable 1"
 , "set-attr GLib/Variant/new_maybe/@parameters/child nullable 1"
 , "set-attr GLib/Variant/new_va/@parameters/endptr nullable 1"
 , "set-attr GLib/Variant/get_data/@return-value nullable 1"
 , "set-attr GLib/Variant/get_maybe/@return-value nullable 1"
 , "set-attr GLib/Variant/get_va/@parameters/endptr nullable 1"
 , "set-attr GLib/Variant/lookup_value/@parameters/expected_type nullable 1"
 , "set-attr GLib/Variant/print_string/@parameters/string nullable 1"
 , "set-attr GLib/Variant/parse/@parameters/type nullable 1"
 , "set-attr GLib/Variant/parse/@parameters/limit nullable 1"
 , "set-attr GLib/Variant/parse/@parameters/endptr nullable 1"
 , "set-attr GLib/VariantDict/new/@parameters/from_asv nullable 1"
 , "set-attr GLib/VariantDict/init/@parameters/from_asv nullable 1"
 , "set-attr GLib/VariantDict/lookup_value/@parameters/expected_type nullable 1"
 , "set-attr GLib/VariantIter/next_value/@return-value nullable 1"
 , "set-attr GLib/VariantType/free/@parameters/type nullable 1"
 , "set-attr GLib/VariantType/string_scan/@parameters/limit nullable 1"
 , "set-attr GLib/assertion_message_expr/@parameters/domain nullable 1"
 , "set-attr GLib/assertion_message_expr/@parameters/expr nullable 1"
 , "set-attr GLib/atomic_pointer_compare_and_exchange/@parameters/oldval nullable 1"
 , "set-attr GLib/atomic_pointer_compare_and_exchange/@parameters/newval nullable 1"
 , "set-attr GLib/atomic_pointer_get/@return-value nullable 1"
 , "set-attr GLib/atomic_pointer_set/@parameters/newval nullable 1"
 , "set-attr GLib/child_watch_add/@parameters/data nullable 1"
 , "set-attr GLib/child_watch_add_full/@parameters/data nullable 1"
 , "set-attr GLib/child_watch_add_full/@parameters/notify nullable 1"
 , "set-attr GLib/datalist_foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/datalist_get_data/@return-value nullable 1"
 , "set-attr GLib/datalist_id_dup_data/@return-value nullable 1"
 , "set-attr GLib/datalist_id_dup_data/@parameters/dup_func nullable 1"
 , "set-attr GLib/datalist_id_dup_data/@parameters/user_data nullable 1"
 , "set-attr GLib/datalist_id_get_data/@return-value nullable 1"
 , "set-attr GLib/datalist_id_remove_no_notify/@return-value nullable 1"
 , "set-attr GLib/datalist_id_replace_data/@parameters/oldval nullable 1"
 , "set-attr GLib/datalist_id_replace_data/@parameters/newval nullable 1"
 , "set-attr GLib/datalist_id_replace_data/@parameters/destroy nullable 1"
 , "set-attr GLib/datalist_id_replace_data/@parameters/old_destroy nullable 1"
 , "set-attr GLib/datalist_id_set_data_full/@parameters/data nullable 1"
 , "set-attr GLib/dataset_foreach/@parameters/user_data nullable 1"
 , "set-attr GLib/dataset_id_get_data/@return-value nullable 1"
 , "set-attr GLib/dataset_id_remove_no_notify/@return-value nullable 1"
 , "set-attr GLib/dataset_id_set_data_full/@parameters/data nullable 1"
 , "set-attr GLib/dcgettext/@parameters/domain nullable 1"
 , "set-attr GLib/dgettext/@parameters/domain nullable 1"
 , "set-attr GLib/dir_make_tmp/@parameters/tmpl nullable 1"
 , "set-attr GLib/direct_equal/@parameters/v1 nullable 1"
 , "set-attr GLib/direct_equal/@parameters/v2 nullable 1"
 , "set-attr GLib/direct_hash/@parameters/v nullable 1"
 , "set-attr GLib/dngettext/@parameters/domain nullable 1"
 , "set-attr GLib/dpgettext/@parameters/domain nullable 1"
 , "set-attr GLib/dpgettext2/@parameters/domain nullable 1"
 , "set-attr GLib/environ_getenv/@parameters/envp nullable 1"
 , "set-attr GLib/environ_setenv/@parameters/envp nullable 1"
 , "set-attr GLib/environ_unsetenv/@parameters/envp nullable 1"
 , "set-attr GLib/file_open_tmp/@parameters/tmpl nullable 1"
 , "set-attr GLib/filename_from_uri/@parameters/hostname nullable 1"
 , "set-attr GLib/filename_to_uri/@parameters/hostname nullable 1"
 , "set-attr GLib/free/@parameters/mem nullable 1"
 , "set-attr GLib/hash_table_add/@parameters/key nullable 1"
 , "set-attr GLib/hash_table_contains/@parameters/key nullable 1"
 , "set-attr GLib/hash_table_insert/@parameters/key nullable 1"
 , "set-attr GLib/hash_table_insert/@parameters/value nullable 1"
 , "set-attr GLib/hash_table_lookup/@return-value nullable 1"
 , "set-attr GLib/hash_table_lookup/@parameters/key nullable 1"
 , "set-attr GLib/hash_table_lookup_extended/@parameters/lookup_key nullable 1"
 , "set-attr GLib/hash_table_lookup_extended/@parameters/orig_key nullable 1"
 , "set-attr GLib/hash_table_lookup_extended/@parameters/value nullable 1"
 , "set-attr GLib/hash_table_remove/@parameters/key nullable 1"
 , "set-attr GLib/hash_table_replace/@parameters/key nullable 1"
 , "set-attr GLib/hash_table_replace/@parameters/value nullable 1"
 , "set-attr GLib/hash_table_steal/@parameters/key nullable 1"
 , "set-attr GLib/hook_insert_before/@parameters/sibling nullable 1"
 , "set-attr GLib/idle_add/@parameters/data nullable 1"
 , "set-attr GLib/idle_add_full/@parameters/data nullable 1"
 , "set-attr GLib/idle_add_full/@parameters/notify nullable 1"
 , "set-attr GLib/idle_remove_by_data/@parameters/data nullable 1"
 , "set-attr GLib/intern_static_string/@parameters/string nullable 1"
 , "set-attr GLib/intern_string/@parameters/string nullable 1"
 , "set-attr GLib/io_add_watch/@parameters/user_data nullable 1"
 , "set-attr GLib/io_add_watch_full/@parameters/user_data nullable 1"
 , "set-attr GLib/log/@parameters/log_domain nullable 1"
 , "set-attr GLib/log_default_handler/@parameters/log_domain nullable 1"
 , "set-attr GLib/log_default_handler/@parameters/message nullable 1"
 , "set-attr GLib/log_default_handler/@parameters/unused_data nullable 1"
 , "set-attr GLib/log_set_default_handler/@parameters/user_data nullable 1"
 , "set-attr GLib/log_set_handler/@parameters/log_domain nullable 1"
 , "set-attr GLib/log_set_handler/@parameters/user_data nullable 1"
 , "set-attr GLib/log_set_handler_full/@parameters/log_domain nullable 1"
 , "set-attr GLib/log_set_handler_full/@parameters/user_data nullable 1"
 , "set-attr GLib/logv/@parameters/log_domain nullable 1"
 , "set-attr GLib/malloc/@return-value nullable 1"
 , "set-attr GLib/malloc0/@return-value nullable 1"
 , "set-attr GLib/malloc0_n/@return-value nullable 1"
 , "set-attr GLib/malloc_n/@return-value nullable 1"
 , "set-attr GLib/memdup/@return-value nullable 1"
 , "set-attr GLib/memdup/@parameters/mem nullable 1"
 , "set-attr GLib/parse_debug_string/@parameters/string nullable 1"
 , "set-attr GLib/path_skip_root/@return-value nullable 1"
 , "set-attr GLib/pattern_match/@parameters/string_reversed nullable 1"
 , "set-attr GLib/prefix_error/@parameters/err nullable 1"
 , "set-attr GLib/propagate_error/@parameters/dest nullable 1"
 , "set-attr GLib/qsort_with_data/@parameters/user_data nullable 1"
 , "set-attr GLib/quark_from_static_string/@parameters/string nullable 1"
 , "set-attr GLib/quark_from_string/@parameters/string nullable 1"
 , "set-attr GLib/quark_try_string/@parameters/string nullable 1"
 , "set-attr GLib/realloc/@return-value nullable 1"
 , "set-attr GLib/realloc/@parameters/mem nullable 1"
 , "set-attr GLib/realloc_n/@return-value nullable 1"
 , "set-attr GLib/realloc_n/@parameters/mem nullable 1"
 , "set-attr GLib/return_if_fail_warning/@parameters/log_domain nullable 1"
 , "set-attr GLib/return_if_fail_warning/@parameters/expression nullable 1"
 , "set-attr GLib/sequence_get/@return-value nullable 1"
 , "set-attr GLib/sequence_set/@parameters/data nullable 1"
 , "set-attr GLib/slice_alloc/@return-value nullable 1"
 , "set-attr GLib/slice_alloc0/@return-value nullable 1"
 , "set-attr GLib/slice_copy/@return-value nullable 1"
 , "set-attr GLib/slice_copy/@parameters/mem_block nullable 1"
 , "set-attr GLib/slice_free1/@parameters/mem_block nullable 1"
 , "set-attr GLib/slice_free_chain_with_offset/@parameters/mem_chain nullable 1"
 , "set-attr GLib/source_remove_by_funcs_user_data/@parameters/user_data nullable 1"
 , "set-attr GLib/source_remove_by_user_data/@parameters/user_data nullable 1"
 , "set-attr GLib/spawn_async/@parameters/working_directory nullable 1"
 , "set-attr GLib/spawn_async/@parameters/envp nullable 1"
 , "set-attr GLib/spawn_async/@parameters/child_setup nullable 1"
 , "set-attr GLib/spawn_async/@parameters/user_data nullable 1"
 , "set-attr GLib/spawn_async_with_pipes/@parameters/working_directory nullable 1"
 , "set-attr GLib/spawn_async_with_pipes/@parameters/envp nullable 1"
 , "set-attr GLib/spawn_async_with_pipes/@parameters/child_setup nullable 1"
 , "set-attr GLib/spawn_async_with_pipes/@parameters/user_data nullable 1"
 , "set-attr GLib/spawn_sync/@parameters/working_directory nullable 1"
 , "set-attr GLib/spawn_sync/@parameters/envp nullable 1"
 , "set-attr GLib/spawn_sync/@parameters/child_setup nullable 1"
 , "set-attr GLib/spawn_sync/@parameters/user_data nullable 1"
 , "set-attr GLib/str_to_ascii/@parameters/from_locale nullable 1"
 , "set-attr GLib/str_tokenize_and_fold/@parameters/translit_locale nullable 1"
 , "set-attr GLib/strcmp0/@parameters/str1 nullable 1"
 , "set-attr GLib/strcmp0/@parameters/str2 nullable 1"
 , "set-attr GLib/strdelimit/@parameters/delimiters nullable 1"
 , "set-attr GLib/strdup/@parameters/str nullable 1"
 , "set-attr GLib/strdupv/@return-value nullable 1"
 , "set-attr GLib/strdupv/@parameters/str_array nullable 1"
 , "set-attr GLib/strescape/@parameters/exceptions nullable 1"
 , "set-attr GLib/strfreev/@parameters/str_array nullable 1"
 , "set-attr GLib/string_new/@parameters/init nullable 1"
 , "set-attr GLib/strjoin/@parameters/separator nullable 1"
 , "set-attr GLib/strjoinv/@parameters/separator nullable 1"
 , "set-attr GLib/test_add_data_func/@parameters/test_data nullable 1"
 , "set-attr GLib/test_add_data_func_full/@parameters/test_data nullable 1"
 , "set-attr GLib/test_add_vtable/@parameters/test_data nullable 1"
 , "set-attr GLib/test_create_case/@parameters/test_data nullable 1"
 , "set-attr GLib/test_expect_message/@parameters/log_domain nullable 1"
 , "set-attr GLib/test_incomplete/@parameters/msg nullable 1"
 , "set-attr GLib/test_log_set_fatal_handler/@parameters/user_data nullable 1"
 , "set-attr GLib/test_queue_destroy/@parameters/destroy_data nullable 1"
 , "set-attr GLib/test_queue_free/@parameters/gfree_pointer nullable 1"
 , "set-attr GLib/test_skip/@parameters/msg nullable 1"
 , "set-attr GLib/test_trap_subprocess/@parameters/test_path nullable 1"
 , "set-attr GLib/thread_exit/@parameters/retval nullable 1"
 , "set-attr GLib/timeout_add/@parameters/data nullable 1"
 , "set-attr GLib/timeout_add_full/@parameters/data nullable 1"
 , "set-attr GLib/timeout_add_full/@parameters/notify nullable 1"
 , "set-attr GLib/timeout_add_seconds/@parameters/data nullable 1"
 , "set-attr GLib/timeout_add_seconds_full/@parameters/data nullable 1"
 , "set-attr GLib/timeout_add_seconds_full/@parameters/notify nullable 1"
 , "set-attr GLib/trash_stack_peek/@return-value nullable 1"
 , "set-attr GLib/trash_stack_pop/@return-value nullable 1"
 , "set-attr GLib/try_malloc/@return-value nullable 1"
 , "set-attr GLib/try_malloc0/@return-value nullable 1"
 , "set-attr GLib/try_malloc0_n/@return-value nullable 1"
 , "set-attr GLib/try_malloc_n/@return-value nullable 1"
 , "set-attr GLib/try_realloc/@return-value nullable 1"
 , "set-attr GLib/try_realloc/@parameters/mem nullable 1"
 , "set-attr GLib/try_realloc_n/@return-value nullable 1"
 , "set-attr GLib/try_realloc_n/@parameters/mem nullable 1"
 , "set-attr GLib/unichar_fully_decompose/@parameters/result nullable 1"
 , "set-attr GLib/unix_fd_add/@parameters/user_data nullable 1"
 , "set-attr GLib/unix_fd_add_full/@parameters/user_data nullable 1"
 , "set-attr GLib/unix_signal_add/@parameters/user_data nullable 1"
 , "set-attr GLib/unix_signal_add_full/@parameters/user_data nullable 1"
 , "set-attr GLib/uri_escape_string/@parameters/reserved_chars_allowed nullable 1"
 , "set-attr GLib/uri_unescape_segment/@parameters/escaped_string nullable 1"
 , "set-attr GLib/uri_unescape_segment/@parameters/escaped_string_end nullable 1"
 , "set-attr GLib/uri_unescape_segment/@parameters/illegal_characters nullable 1"
 , "set-attr GLib/uri_unescape_string/@parameters/illegal_characters nullable 1"
 , "set-attr GLib/utf8_find_next_char/@parameters/end nullable 1"
 , "set-attr GLib/variant_parse/@parameters/type nullable 1"
 , "set-attr GLib/variant_parse/@parameters/limit nullable 1"
 , "set-attr GLib/variant_parse/@parameters/endptr nullable 1"
 , "set-attr GLib/variant_type_string_scan/@parameters/limit nullable 1"
 , "set-attr GLib/warn_message/@parameters/domain nullable 1"
 , "set-attr GLib/warn_message/@parameters/warnexpr nullable 1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.GLib.Config"
 , "GI.GLib"
 , "GI.GLib.Callbacks"
 , "GI.GLib.Constants"
 , "GI.GLib.Enums"
 , "GI.GLib.Flags"
 , "GI.GLib.Functions"
 , "GI.GLib.Structs"
 , "GI.GLib.Structs.Allocator"
 , "GI.GLib.Structs.AsyncQueue"
 , "GI.GLib.Structs.BookmarkFile"
 , "GI.GLib.Structs.ByteArray"
 , "GI.GLib.Structs.Bytes"
 , "GI.GLib.Structs.Cache"
 , "GI.GLib.Structs.Checksum"
 , "GI.GLib.Structs.Completion"
 , "GI.GLib.Structs.Cond"
 , "GI.GLib.Structs.Data"
 , "GI.GLib.Structs.Date"
 , "GI.GLib.Structs.DateTime"
 , "GI.GLib.Structs.DebugKey"
 , "GI.GLib.Structs.Dir"
 , "GI.GLib.Structs.HashTableIter"
 , "GI.GLib.Structs.Hmac"
 , "GI.GLib.Structs.Hook"
 , "GI.GLib.Structs.HookList"
 , "GI.GLib.Structs.IOChannel"
 , "GI.GLib.Structs.IOFuncs"
 , "GI.GLib.Structs.KeyFile"
 , "GI.GLib.Structs.LogField"
 , "GI.GLib.Structs.MainContext"
 , "GI.GLib.Structs.MainLoop"
 , "GI.GLib.Structs.MappedFile"
 , "GI.GLib.Structs.MarkupParseContext"
 , "GI.GLib.Structs.MarkupParser"
 , "GI.GLib.Structs.MatchInfo"
 , "GI.GLib.Structs.MemChunk"
 , "GI.GLib.Structs.MemVTable"
 , "GI.GLib.Structs.Node"
 , "GI.GLib.Structs.Once"
 , "GI.GLib.Structs.OptionContext"
 , "GI.GLib.Structs.OptionEntry"
 , "GI.GLib.Structs.OptionGroup"
 , "GI.GLib.Structs.PathBuf"
 , "GI.GLib.Structs.PatternSpec"
 , "GI.GLib.Structs.PollFD"
 , "GI.GLib.Structs.PtrArray"
 , "GI.GLib.Structs.Queue"
 , "GI.GLib.Structs.RWLock"
 , "GI.GLib.Structs.Rand"
 , "GI.GLib.Structs.RecMutex"
 , "GI.GLib.Structs.Regex"
 , "GI.GLib.Structs.Relation"
 , "GI.GLib.Structs.Scanner"
 , "GI.GLib.Structs.ScannerConfig"
 , "GI.GLib.Structs.Sequence"
 , "GI.GLib.Structs.SequenceIter"
 , "GI.GLib.Structs.Source"
 , "GI.GLib.Structs.SourceCallbackFuncs"
 , "GI.GLib.Structs.SourceFuncs"
 , "GI.GLib.Structs.StatBuf"
 , "GI.GLib.Structs.String"
 , "GI.GLib.Structs.StringChunk"
 , "GI.GLib.Structs.StrvBuilder"
 , "GI.GLib.Structs.TestCase"
 , "GI.GLib.Structs.TestConfig"
 , "GI.GLib.Structs.TestLogBuffer"
 , "GI.GLib.Structs.TestLogMsg"
 , "GI.GLib.Structs.TestSuite"
 , "GI.GLib.Structs.Thread"
 , "GI.GLib.Structs.ThreadPool"
 , "GI.GLib.Structs.TimeVal"
 , "GI.GLib.Structs.TimeZone"
 , "GI.GLib.Structs.Timer"
 , "GI.GLib.Structs.TrashStack"
 , "GI.GLib.Structs.Tree"
 , "GI.GLib.Structs.TreeNode"
 , "GI.GLib.Structs.Tuples"
 , "GI.GLib.Structs.UnixPipe"
 , "GI.GLib.Structs.Uri"
 , "GI.GLib.Structs.UriParamsIter"
 , "GI.GLib.Structs.VariantBuilder"
 , "GI.GLib.Structs.VariantDict"
 , "GI.GLib.Structs.VariantType"
 , "GI.GLib.Unions"
 , "GI.GLib.Unions.DoubleIEEE754"
 , "GI.GLib.Unions.FloatIEEE754"
 , "GI.GLib.Unions.Mutex"
 , "GI.GLib.Unions.TokenValue"]
