// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityStatus The vulnerability status.
type VulnerabilityStatus string

// List of VulnerabilityStatus.
const (
	VULNERABILITYSTATUS_OPEN       VulnerabilityStatus = "Open"
	VULNERABILITYSTATUS_MUTED      VulnerabilityStatus = "Muted"
	VULNERABILITYSTATUS_REMEDIATED VulnerabilityStatus = "Remediated"
	VULNERABILITYSTATUS_INPROGRESS VulnerabilityStatus = "InProgress"
	VULNERABILITYSTATUS_AUTOCLOSED VulnerabilityStatus = "AutoClosed"
)

var allowedVulnerabilityStatusEnumValues = []VulnerabilityStatus{
	VULNERABILITYSTATUS_OPEN,
	VULNERABILITYSTATUS_MUTED,
	VULNERABILITYSTATUS_REMEDIATED,
	VULNERABILITYSTATUS_INPROGRESS,
	VULNERABILITYSTATUS_AUTOCLOSED,
}

// GetAllowedValues reeturns the list of possible values.
func (v *VulnerabilityStatus) GetAllowedValues() []VulnerabilityStatus {
	return allowedVulnerabilityStatusEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *VulnerabilityStatus) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = VulnerabilityStatus(value)
	return nil
}

// NewVulnerabilityStatusFromValue returns a pointer to a valid VulnerabilityStatus
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewVulnerabilityStatusFromValue(v string) (*VulnerabilityStatus, error) {
	ev := VulnerabilityStatus(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for VulnerabilityStatus: valid values are %v", v, allowedVulnerabilityStatusEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v VulnerabilityStatus) IsValid() bool {
	for _, existing := range allowedVulnerabilityStatusEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to VulnerabilityStatus value.
func (v VulnerabilityStatus) Ptr() *VulnerabilityStatus {
	return &v
}
