/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, zeromq, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_zeromq_pub_sink = R"doc(Sink the contents of a stream to a ZMQ PUB socket.

This block acts as a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming stream data to each subscriber with a matching key. If the publisher's key is set to \"GNURadio\", the following example subscriber keys will match: \"G\", \"GN\", .., \"GNURadio\". In other words, the subscriber must contain the first set of characters from the publisher's key. If the subscriber sets an empty key \"\", it will accept all input messages from the publisher (including the key itself if one is set). Subscribers can either be another gr-zeromq source block or a non-GNU Radio ZMQ socket.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of zeromq::pub_sink.

Args:
    itemsize : Size of a stream item in bytes.
    vlen : Vector length of the input items. Note that one vector is one item.
    address : ZMQ socket address specifier.
    timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
    pass_tags : Whether sink will serialize and pass tags over the link.
    hwm : High Watermark to configure the socket to (-1 => zmq's default)
    key : Prepend a key/topic to the start of each message (default is none)
    drop_on_hwm : Optionally drop samples when high watermark is reached.
    bind : If true this block will bind to the address, otherwise it will connect; the default is to bind)doc";


static const char* __doc_gr_zeromq_pub_sink_pub_sink_0 = R"doc()doc";


static const char* __doc_gr_zeromq_pub_sink_pub_sink_1 = R"doc()doc";


static const char* __doc_gr_zeromq_pub_sink_make = R"doc(Sink the contents of a stream to a ZMQ PUB socket.

This block acts as a streaming sink for a GNU Radio flowgraph and writes its contents to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming stream data to each subscriber with a matching key. If the publisher's key is set to \"GNURadio\", the following example subscriber keys will match: \"G\", \"GN\", .., \"GNURadio\". In other words, the subscriber must contain the first set of characters from the publisher's key. If the subscriber sets an empty key \"\", it will accept all input messages from the publisher (including the key itself if one is set). Subscribers can either be another gr-zeromq source block or a non-GNU Radio ZMQ socket.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of zeromq::pub_sink.

Args:
    itemsize : Size of a stream item in bytes.
    vlen : Vector length of the input items. Note that one vector is one item.
    address : ZMQ socket address specifier.
    timeout : Receive timeout in milliseconds, default is 100ms, 1us increments.
    pass_tags : Whether sink will serialize and pass tags over the link.
    hwm : High Watermark to configure the socket to (-1 => zmq's default)
    key : Prepend a key/topic to the start of each message (default is none)
    drop_on_hwm : Optionally drop samples when high watermark is reached.
    bind : If true this block will bind to the address, otherwise it will connect; the default is to bind)doc";


static const char* __doc_gr_zeromq_pub_sink_last_endpoint = R"doc(Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.)doc";
