
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "cookiejar_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_CookieJar_Type = nullptr;
static PyTypeObject *Sbk_CookieJar_TypeF(void)
{
    return _Sbk_CookieJar_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void CookieJarWrapper::pysideInitQtMetaTypes()
{
}

void CookieJarWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

CookieJarWrapper::CookieJarWrapper(::QObject * parent) : CookieJar(parent)
{
}

void CookieJarWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CookieJar_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("CookieJar", funcName, gil, pyOverride, event);
}

void CookieJarWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CookieJar_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("CookieJar", funcName, gil, pyOverride, signal);
}

void CookieJarWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CookieJar_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("CookieJar", funcName, gil, pyOverride, event);
}

void CookieJarWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CookieJar_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("CookieJar", funcName, gil, pyOverride, signal);
}

bool CookieJarWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CookieJar_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("CookieJar", funcName, gil, pyOverride, event);
}

bool CookieJarWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CookieJar_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("CookieJar", funcName, gil, pyOverride, watched, event);
}

void CookieJarWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CookieJar_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("CookieJar", funcName, gil, pyOverride, event);
}

const QMetaObject *CookieJarWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return CookieJar::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int CookieJarWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = CookieJar::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *CookieJarWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< CookieJarWrapper *>(this));
    }
    return CookieJar::qt_metacast(_clname);
}

CookieJarWrapper::~CookieJarWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_CookieJar_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_CookieJar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::CookieJar >()))
        return -1;

    CookieJarWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:CookieJar", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: CookieJar::CookieJar(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // CookieJar(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // CookieJar(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // CookieJar(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) CookieJarWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new CookieJarWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< CookieJar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);
    };


    return 1;
}

static PyObject *Sbk_CookieJarFunc_deleteAllCookies(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<CookieJarWrapper *>(reinterpret_cast< ::CookieJar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "deleteAllCookies", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);

    if (PyArg_ParseTuple(args, "|O:deleteAllCookies", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CookieJar::deleteAllCookies(bool=)
    if (numArgs == 0) {
        overloadId = 0; // deleteAllCookies(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // deleteAllCookies(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "deleteAllCookies", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"deleteAll", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "deleteAllCookies", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // deleteAllCookies(bool)
            cppSelf->deleteAllCookies(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CookieJarFunc_deleteCookie(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<CookieJarWrapper *>(reinterpret_cast< ::CookieJar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CookieJar::deleteCookie(QNetworkCookie)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtNetworkTypeStructs[SBK_QNetworkCookie_IDX]), (pyArg)))) {
        overloadId = 0; // deleteCookie(QNetworkCookie)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "deleteCookie", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkCookie cppArg0_local;
        ::QNetworkCookie *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // deleteCookie(QNetworkCookie)
            cppSelf->deleteCookie(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CookieJarFunc_getAllCookies(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<CookieJarWrapper *>(reinterpret_cast< ::CookieJar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAllCookies()const
        QList<QNetworkCookie> cppResult = const_cast<const CookieJarWrapper *>(cppSelf)->getAllCookies();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QNetworkCookie_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CookieJarFunc_listMatchesDomain(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<CookieJarWrapper *>(reinterpret_cast< ::CookieJar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "listMatchesDomain", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CookieJar::listMatchesDomain(QStringList,QString)const->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // listMatchesDomain(QStringList,QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "listMatchesDomain", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // listMatchesDomain(QStringList,QString)const
            bool cppResult = static_cast<CookieJarWrapper *>(cppSelf)->CookieJarWrapper::listMatchesDomain_protected(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CookieJarFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<CookieJarWrapper *>(reinterpret_cast< ::CookieJar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CookieJarFunc_matchDomain(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<CookieJarWrapper *>(reinterpret_cast< ::CookieJar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "matchDomain", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CookieJar::matchDomain(QString,QString)const->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // matchDomain(QString,QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "matchDomain", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // matchDomain(QString,QString)const
            bool cppResult = static_cast<CookieJarWrapper *>(cppSelf)->CookieJarWrapper::matchDomain_protected(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CookieJarFunc_setAllowCookies(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<CookieJarWrapper *>(reinterpret_cast< ::CookieJar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CookieJar::setAllowCookies(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAllowCookies(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAllowCookies", errInfo, SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAllowCookies(bool)
            cppSelf->setAllowCookies(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_CookieJar_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_CookieJar_methods[] = {
    {"deleteAllCookies", reinterpret_cast<PyCFunction>(Sbk_CookieJarFunc_deleteAllCookies), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"deleteCookie", reinterpret_cast<PyCFunction>(Sbk_CookieJarFunc_deleteCookie), METH_O, nullptr},
    {"getAllCookies", reinterpret_cast<PyCFunction>(Sbk_CookieJarFunc_getAllCookies), METH_NOARGS, nullptr},
    {"listMatchesDomain", reinterpret_cast<PyCFunction>(Sbk_CookieJarFunc_listMatchesDomain), METH_VARARGS, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_CookieJarFunc_loadSettings), METH_NOARGS, nullptr},
    {"matchDomain", reinterpret_cast<PyCFunction>(Sbk_CookieJarFunc_matchDomain), METH_VARARGS, nullptr},
    {"setAllowCookies", reinterpret_cast<PyCFunction>(Sbk_CookieJarFunc_setAllowCookies), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_CookieJar_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::CookieJar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_CookieJar_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<CookieJarWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_CookieJar_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_CookieJar_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_CookieJar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_CookieJar_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_CookieJar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_CookieJar_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_CookieJar_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_CookieJar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_CookieJar_spec = {
    "1:PyFalkon.CookieJar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_CookieJar_slots
};

} //extern "C"

static void *Sbk_CookieJar_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::CookieJar *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void CookieJar_PythonToCpp_CookieJar_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_CookieJar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_CookieJar_PythonToCpp_CookieJar_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_CookieJar_TypeF()))
        return CookieJar_PythonToCpp_CookieJar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *CookieJar_PTR_CppToPython_CookieJar(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::CookieJar *>(const_cast<void *>(cppIn)), Sbk_CookieJar_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *CookieJar_SignatureStrings[] = {
    "PyFalkon.CookieJar(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.CookieJar.deleteAllCookies(self,deleteAll:bool=true)",
    "PyFalkon.CookieJar.deleteCookie(self,cookie:PySide6.QtNetwork.QNetworkCookie)",
    "PyFalkon.CookieJar.getAllCookies(self)->QList[PySide6.QtNetwork.QNetworkCookie]",
    "PyFalkon.CookieJar.listMatchesDomain(self,list:QStringList,cookieDomain:QString)->bool",
    "PyFalkon.CookieJar.loadSettings(self)",
    "PyFalkon.CookieJar.matchDomain(self,cookieDomain:QString,siteDomain:QString)->bool",
    "PyFalkon.CookieJar.setAllowCookies(self,allow:bool)",
    nullptr}; // Sentinel
#else
static constexpr size_t CookieJar_SignatureByteSize = 218;
static constexpr uint8_t CookieJar_SignatureBytes[218] = {
    0x78, 0xda, 0x8d, 0x51, 0x4b, 0x8b, 0xc2, 0x30, 0x10, 0xbe, 0xfb, 0x4b, 0x2c, 0x68, 0x8e, 0x1e,
    0x0a, 0x2e, 0x88, 0x8b, 0x07, 0x71, 0xb5, 0xa1, 0x47, 0xd9, 0x43, 0x6c, 0x47, 0xcd, 0x76, 0xcc,
    0x48, 0x32, 0xa5, 0xf8, 0xef, 0xb7, 0x69, 0xba, 0x8b, 0x8f, 0xa0, 0xde, 0x26, 0x5f, 0xbe, 0x57,
    0x32, 0xd9, 0x65, 0xa1, 0xb0, 0x22, 0x23, 0xe6, 0x44, 0x95, 0x86, 0xa5, 0xb2, 0x43, 0x07, 0xb8,
    0x1f, 0x9d, 0x95, 0x05, 0xc3, 0x69, 0x76, 0xc9, 0x75, 0x09, 0x13, 0x21, 0x79, 0x4e, 0x16, 0x84,
    0xdc, 0xec, 0x7e, 0xa0, 0xe0, 0xa9, 0xa9, 0x11, 0xcf, 0x6c, 0x93, 0x41, 0xf6, 0x20, 0x17, 0x25,
    0x20, 0x30, 0xcc, 0x10, 0x03, 0xe4, 0x82, 0xdf, 0x3f, 0x9a, 0xee, 0x88, 0x70, 0xca, 0xb6, 0x86,
    0x27, 0xea, 0x70, 0x0e, 0xca, 0xa2, 0x9b, 0xaf, 0x9a, 0xac, 0x81, 0x1b, 0xb2, 0x95, 0x90, 0xfd,
    0x10, 0xc8, 0x51, 0xb7, 0x03, 0xf0, 0x5d, 0x91, 0x64, 0xfc, 0x21, 0x57, 0xda, 0xf1, 0xf6, 0x95,
    0xdf, 0x77, 0xcc, 0x0f, 0x5b, 0xe5, 0x97, 0xe2, 0xe2, 0x08, 0xee, 0x93, 0x4e, 0x4a, 0x9b, 0x50,
    0xd1, 0xc3, 0xa9, 0xcc, 0xd9, 0x6a, 0x73, 0xf0, 0xe6, 0x7d, 0xe7, 0x40, 0xf9, 0xbb, 0x68, 0x93,
    0xfd, 0xd3, 0xa3, 0xb6, 0xa4, 0xca, 0x1c, 0x98, 0x5b, 0x56, 0xdf, 0x32, 0xc6, 0x3a, 0xf9, 0xe0,
    0xeb, 0xd8, 0x58, 0xca, 0xc8, 0x69, 0x7e, 0x3f, 0xd8, 0x75, 0xff, 0x43, 0xcd, 0xcd, 0xaa, 0x94,
    0x47, 0xba, 0x35, 0x25, 0x83, 0x5f, 0xc3, 0x02, 0xc8, 0x4d
};
#endif

PyTypeObject *init_CookieJar(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_CookieJar_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_CookieJar_IDX].type;

    Shiboken::AutoDecRef Sbk_CookieJar_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_CookieJar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "CookieJar",
        "CookieJar*",
        &Sbk_CookieJar_spec,
        &Shiboken::callCppDestructor< CookieJar >,
        Sbk_CookieJar_Type_bases.object(),
        0);
    auto *pyType = Sbk_CookieJar_TypeF(); // references _Sbk_CookieJar_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, CookieJar_SignatureStrings);
#else
    InitSignatureBytes(pyType, CookieJar_SignatureBytes, CookieJar_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_CookieJar_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_CookieJar_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        CookieJar_PythonToCpp_CookieJar_PTR,
        is_CookieJar_PythonToCpp_CookieJar_PTR_Convertible,
        CookieJar_PTR_CppToPython_CookieJar);

    Shiboken::Conversions::registerConverterName(converter, "CookieJar");
    Shiboken::Conversions::registerConverterName(converter, "CookieJar*");
    Shiboken::Conversions::registerConverterName(converter, "CookieJar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::CookieJar).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(CookieJarWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_CookieJar_TypeF(), &Sbk_CookieJar_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::CookieJar::staticMetaObject);
    CookieJarWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::CookieJar::staticMetaObject, sizeof(CookieJarWrapper));

    return pyType;
}
