// This file was generated by qtwaylandscanner
// source file is plugin-manager-v1.xml

#ifndef QT_WAYLAND_SERVER_PLUGIN_MANAGER_V1
#define QT_WAYLAND_SERVER_PLUGIN_MANAGER_V1

#include "wayland-server-core.h"
#include "wayland-plugin-manager-v1-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  plugin_manager_v1
    {
    public:
        plugin_manager_v1(struct ::wl_client *client, uint32_t id, int version);
        plugin_manager_v1(struct ::wl_display *display, int version);
        plugin_manager_v1(struct ::wl_resource *resource);
        plugin_manager_v1();

        virtual ~plugin_manager_v1();

        class Resource
        {
        public:
            Resource() : plugin_manager_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            plugin_manager_v1 *plugin_manager_v1_object;
            plugin_manager_v1 *object() { return plugin_manager_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, uint32_t id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, uint32_t id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, uint32_t id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_role = 0, // given wl_surface has another role
            error_plugin_id = 1, // given wl_surface has another plugin_id
        };

        void send_position_changed(uint32_t dock_position);
        void send_position_changed(struct ::wl_resource *resource, uint32_t dock_position);
        void send_color_theme_changed(uint32_t dock_color_theme);
        void send_color_theme_changed(struct ::wl_resource *resource, uint32_t dock_color_theme);
        void send_active_color_changed(const QString &active_color, const QString &dark_active_color);
        void send_active_color_changed(struct ::wl_resource *resource, const QString &active_color, const QString &dark_active_color);
        void send_font_changed(const QString &font_name, int32_t font_point_size);
        void send_font_changed(struct ::wl_resource *resource, const QString &font_name, int32_t font_point_size);
        void send_theme_changed(const QString &theme_name, const QString &icon_theme_name);
        void send_theme_changed(struct ::wl_resource *resource, const QString &theme_name, const QString &icon_theme_name);
        void send_event_message(const QString &msg);
        void send_event_message(struct ::wl_resource *resource, const QString &msg);

    protected:
        virtual Resource *plugin_manager_v1_allocate();

        virtual void plugin_manager_v1_bind_resource(Resource *resource);
        virtual void plugin_manager_v1_destroy_resource(Resource *resource);

        virtual void plugin_manager_v1_destroy(Resource *resource);
        virtual void plugin_manager_v1_request_message(Resource *resource, const QString &plugin_id, const QString &item_key, const QString &msg);
        virtual void plugin_manager_v1_create_popup_at(Resource *resource, const QString &plugin_id, const QString &item_key, int32_t type, int32_t x, int32_t y, struct ::wl_resource *surface, uint32_t id);
        virtual void plugin_manager_v1_create_plugin(Resource *resource, const QString &plugin_id, const QString &item_key, const QString &display_name, int32_t plugin_flags, int32_t type, int32_t size_policy, struct ::wl_resource *surface, uint32_t id);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::plugin_manager_v1_interface m_plugin_manager_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_request_message(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *plugin_id,
            const char *item_key,
            const char *msg);
        static void handle_create_popup_at(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *plugin_id,
            const char *item_key,
            int32_t type,
            int32_t x,
            int32_t y,
            struct ::wl_resource *surface,
            uint32_t id);
        static void handle_create_plugin(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *plugin_id,
            const char *item_key,
            const char *display_name,
            int32_t plugin_flags,
            int32_t type,
            int32_t size_policy,
            struct ::wl_resource *surface,
            uint32_t id);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct DisplayDestroyedListener : ::wl_listener {
            plugin_manager_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  plugin_popup
    {
    public:
        plugin_popup(struct ::wl_client *client, uint32_t id, int version);
        plugin_popup(struct ::wl_display *display, int version);
        plugin_popup(struct ::wl_resource *resource);
        plugin_popup();

        virtual ~plugin_popup();

        class Resource
        {
        public:
            Resource() : plugin_popup_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            plugin_popup *plugin_popup_object;
            plugin_popup *object() { return plugin_popup_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, uint32_t id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, uint32_t id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, uint32_t id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_close();
        void send_close(struct ::wl_resource *resource);
        void send_geometry(int32_t x, int32_t y, int32_t width, int32_t height);
        void send_geometry(struct ::wl_resource *resource, int32_t x, int32_t y, int32_t width, int32_t height);

    protected:
        virtual Resource *plugin_popup_allocate();

        virtual void plugin_popup_bind_resource(Resource *resource);
        virtual void plugin_popup_destroy_resource(Resource *resource);

        virtual void plugin_popup_destroy(Resource *resource);
        virtual void plugin_popup_set_position(Resource *resource, int32_t x, int32_t y);
        virtual void plugin_popup_source_size(Resource *resource, int32_t width, int32_t height);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::plugin_popup_interface m_plugin_popup_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_position(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t x,
            int32_t y);
        static void handle_source_size(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t width,
            int32_t height);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct DisplayDestroyedListener : ::wl_listener {
            plugin_popup *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  plugin
    {
    public:
        plugin(struct ::wl_client *client, uint32_t id, int version);
        plugin(struct ::wl_display *display, int version);
        plugin(struct ::wl_resource *resource);
        plugin();

        virtual ~plugin();

        class Resource
        {
        public:
            Resource() : plugin_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            plugin *plugin_object;
            plugin *object() { return plugin_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, uint32_t id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, uint32_t id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, uint32_t id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_close();
        void send_close(struct ::wl_resource *resource);
        void send_geometry(int32_t x, int32_t y, int32_t width, int32_t height);
        void send_geometry(struct ::wl_resource *resource, int32_t x, int32_t y, int32_t width, int32_t height);
        void send_margin(int32_t spacing);
        void send_margin(struct ::wl_resource *resource, int32_t spacing);
        void send_raw_global_pos(int32_t x, int32_t y);
        void send_raw_global_pos(struct ::wl_resource *resource, int32_t x, int32_t y);

    protected:
        virtual Resource *plugin_allocate();

        virtual void plugin_bind_resource(Resource *resource);
        virtual void plugin_destroy_resource(Resource *resource);

        virtual void plugin_destroy(Resource *resource);
        virtual void plugin_mouse_event(Resource *resource, int32_t type);
        virtual void plugin_dcc_icon(Resource *resource, const QString &type);
        virtual void plugin_request_shutdown(Resource *resource, const QString &type);
        virtual void plugin_source_size(Resource *resource, int32_t width, int32_t height);
        virtual void plugin_close_quick_panel(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::plugin_interface m_plugin_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_mouse_event(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t type);
        static void handle_dcc_icon(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *type);
        static void handle_request_shutdown(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *type);
        static void handle_source_size(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t width,
            int32_t height);
        static void handle_close_quick_panel(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct DisplayDestroyedListener : ::wl_listener {
            plugin *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
