/* MenuItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MenuItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MENU_ITEM_0_PROPERTY,
	MENU_ITEM_IMAGE_SOURCE_PROPERTY,
	MENU_ITEM_LABEL_TEXT_PROPERTY,
	MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* menu_item_properties[MENU_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MenuItemPrivate {
	GtkBox* menu_item;
	GtkImage* button_image;
	GtkLabel* button_label;
	gchar* _image_source;
	gchar* _label_text;
};

static gint MenuItem_private_offset;
static gpointer menu_item_parent_class = NULL;
static GType menu_item_type_id = 0;

static GObject * menu_item_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void menu_item_finalize (GObject * obj);
static void _vala_menu_item_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_menu_item_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
menu_item_get_instance_private (MenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, MenuItem_private_offset);
}

MenuItem*
menu_item_construct (GType object_type,
                     const gchar* label_text,
                     const gchar* image_source)
{
	MenuItem * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkImage* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* _tmp4_;
	GtkBox* _tmp5_;
	g_return_val_if_fail (label_text != NULL, NULL);
	g_return_val_if_fail (image_source != NULL, NULL);
	self = (MenuItem*) g_object_new (object_type, "can-focus", TRUE, NULL);
	menu_item_set_image (self, image_source);
	menu_item_set_label (self, label_text);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 8);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->menu_item);
	self->priv->menu_item = _tmp0_;
	_tmp1_ = self->priv->menu_item;
	_tmp2_ = self->priv->button_image;
	gtk_box_pack_start (_tmp1_, (GtkWidget*) _tmp2_, FALSE, FALSE, (guint) 0);
	_tmp3_ = self->priv->menu_item;
	_tmp4_ = self->priv->button_label;
	gtk_box_pack_end (_tmp3_, (GtkWidget*) _tmp4_, TRUE, TRUE, (guint) 0);
	_tmp5_ = self->priv->menu_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	return self;
}

MenuItem*
menu_item_new (const gchar* label_text,
               const gchar* image_source)
{
	return menu_item_construct (TYPE_MENU_ITEM, label_text, image_source);
}

/**
 * Set the image for this item.
 */
void
menu_item_set_image (MenuItem* self,
                     const gchar* source)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->button_image;
	if (_tmp0_ == NULL) {
		GtkImage* _tmp1_;
		_tmp1_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->button_image);
		self->priv->button_image = _tmp1_;
	}
	_tmp2_ = self->priv->button_image;
	gtk_image_set_from_icon_name (_tmp2_, source, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
}

/**
 * Sets the label for this item.
 */
void
menu_item_set_label (MenuItem* self,
                     const gchar* text)
{
	gchar* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->priv->_label_text);
	self->priv->_label_text = _tmp0_;
	_tmp1_ = self->priv->button_label;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GtkLabel* _tmp3_ = NULL;
		_tmp2_ = self->priv->_label_text;
		_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
		gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->button_label);
		self->priv->button_label = _tmp3_;
	} else {
		GtkLabel* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->button_label;
		_tmp5_ = self->priv->_label_text;
		gtk_label_set_text (_tmp4_, _tmp5_);
	}
}

const gchar*
menu_item_get_image_source (MenuItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image_source;
	result = _tmp0_;
	return result;
}

void
menu_item_set_image_source (MenuItem* self,
                            const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = menu_item_get_image_source (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_image_source);
	self->priv->_image_source = _tmp2_;
	_tmp3_ = menu_item_get_image_source (self);
	_tmp4_ = _tmp3_;
	menu_item_set_image (self, _tmp4_);
	g_object_notify_by_pspec ((GObject *) self, menu_item_properties[MENU_ITEM_IMAGE_SOURCE_PROPERTY]);
}

const gchar*
menu_item_get_label_text (MenuItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_text;
	result = _tmp0_;
	return result;
}

void
menu_item_set_label_text (MenuItem* self,
                          const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = menu_item_get_label_text (self);
	_tmp1_ = _tmp0_;
	menu_item_set_label (self, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, menu_item_properties[MENU_ITEM_LABEL_TEXT_PROPERTY]);
}

static GObject *
menu_item_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MenuItem * self;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	parent_class = G_OBJECT_CLASS (menu_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MENU_ITEM, MenuItem);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "flat");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "menuitem");
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}

static void
menu_item_class_init (MenuItemClass * klass,
                      gpointer klass_data)
{
	menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MenuItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_menu_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = menu_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_ITEM_IMAGE_SOURCE_PROPERTY, menu_item_properties[MENU_ITEM_IMAGE_SOURCE_PROPERTY] = g_param_spec_string ("image-source", "image-source", "image-source", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_ITEM_LABEL_TEXT_PROPERTY, menu_item_properties[MENU_ITEM_LABEL_TEXT_PROPERTY] = g_param_spec_string ("label-text", "label-text", "label-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
menu_item_instance_init (MenuItem * self,
                         gpointer klass)
{
	self->priv = menu_item_get_instance_private (self);
	self->priv->menu_item = NULL;
	self->priv->button_image = NULL;
	self->priv->button_label = NULL;
	self->priv->_image_source = NULL;
	self->priv->_label_text = NULL;
}

static void
menu_item_finalize (GObject * obj)
{
	MenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MENU_ITEM, MenuItem);
	_g_object_unref0 (self->priv->menu_item);
	_g_object_unref0 (self->priv->button_image);
	_g_object_unref0 (self->priv->button_label);
	_g_free0 (self->priv->_image_source);
	_g_free0 (self->priv->_label_text);
	G_OBJECT_CLASS (menu_item_parent_class)->finalize (obj);
}

/**
 * Wraps a `Gtk.Button` so we can have more control over the menu
 * item widgets and layout.
 */
GType
menu_item_get_type (void)
{
	return menu_item_type_id;
}

GType
menu_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (MenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MenuItem), 0, (GInstanceInitFunc) menu_item_instance_init, NULL };
	menu_item_type_id = g_type_module_register_type (module, gtk_button_get_type (), "MenuItem", &g_define_type_info, 0);
	MenuItem_private_offset = sizeof (MenuItemPrivate);
	return menu_item_type_id;
}

static void
_vala_menu_item_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	MenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENU_ITEM, MenuItem);
	switch (property_id) {
		case MENU_ITEM_IMAGE_SOURCE_PROPERTY:
		g_value_set_string (value, menu_item_get_image_source (self));
		break;
		case MENU_ITEM_LABEL_TEXT_PROPERTY:
		g_value_set_string (value, menu_item_get_label_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_menu_item_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	MenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENU_ITEM, MenuItem);
	switch (property_id) {
		case MENU_ITEM_IMAGE_SOURCE_PROPERTY:
		menu_item_set_image_source (self, g_value_get_string (value));
		break;
		case MENU_ITEM_LABEL_TEXT_PROPERTY:
		menu_item_set_label_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

