/*******************************************************************************
 * Copyright 2009-2023 Jörg Müller
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

#include "respec/JOSResampleReader.h"

// sinc filter coefficients, Nz = 42, L = 500, freq = 0.916636, Kaiser Window B = 12

AUD_NAMESPACE_BEGIN

const int JOSResampleReader::m_len_medium = 22909;
const int JOSResampleReader::m_L_medium = 500;

const float JOSResampleReader::m_coeff_medium[m_len_medium + 1] = {
9.166359212e-01f, 9.166308436e-01f, 9.166156110e-01f, 9.165902235e-01f, 9.165546819e-01f, 9.165089866e-01f, 9.164531388e-01f, 9.163871394e-01f, 9.163109898e-01f, 9.162246915e-01f, 
9.161282463e-01f, 9.160216561e-01f, 9.159049229e-01f, 9.157780492e-01f, 9.156410375e-01f, 9.154938905e-01f, 9.153366112e-01f, 9.151692027e-01f, 9.149916683e-01f, 9.148040116e-01f, 
9.146062364e-01f, 9.143983465e-01f, 9.141803463e-01f, 9.139522399e-01f, 9.137140320e-01f, 9.134657274e-01f, 9.132073309e-01f, 9.129388479e-01f, 9.126602835e-01f, 9.123716434e-01f, 
9.120729335e-01f, 9.117641595e-01f, 9.114453277e-01f, 9.111164446e-01f, 9.107775165e-01f, 9.104285504e-01f, 9.100695532e-01f, 9.097005320e-01f, 9.093214943e-01f, 9.089324475e-01f, 
9.085333996e-01f, 9.081243584e-01f, 9.077053321e-01f, 9.072763291e-01f, 9.068373579e-01f, 9.063884274e-01f, 9.059295464e-01f, 9.054607242e-01f, 9.049819701e-01f, 9.044932937e-01f, 
9.039947047e-01f, 9.034862131e-01f, 9.029678289e-01f, 9.024395627e-01f, 9.019014249e-01f, 9.013534262e-01f, 9.007955776e-01f, 9.002278902e-01f, 8.996503754e-01f, 8.990630446e-01f, 
8.984659097e-01f, 8.978589824e-01f, 8.972422750e-01f, 8.966157996e-01f, 8.959795689e-01f, 8.953335954e-01f, 8.946778921e-01f, 8.940124720e-01f, 8.933373485e-01f, 8.926525349e-01f, 
8.919580449e-01f, 8.912538924e-01f, 8.905400914e-01f, 8.898166561e-01f, 8.890836010e-01f, 8.883409405e-01f, 8.875886897e-01f, 8.868268633e-01f, 8.860554766e-01f, 8.852745450e-01f, 
8.844840840e-01f, 8.836841093e-01f, 8.828746369e-01f, 8.820556829e-01f, 8.812272636e-01f, 8.803893954e-01f, 8.795420951e-01f, 8.786853796e-01f, 8.778192658e-01f, 8.769437709e-01f, 
8.760589125e-01f, 8.751647081e-01f, 8.742611755e-01f, 8.733483326e-01f, 8.724261976e-01f, 8.714947889e-01f, 8.705541249e-01f, 8.696042244e-01f, 8.686451062e-01f, 8.676767893e-01f, 
8.666992931e-01f, 8.657126369e-01f, 8.647168404e-01f, 8.637119232e-01f, 8.626979055e-01f, 8.616748072e-01f, 8.606426487e-01f, 8.596014505e-01f, 8.585512333e-01f, 8.574920178e-01f, 
8.564238252e-01f, 8.553466766e-01f, 8.542605933e-01f, 8.531655969e-01f, 8.520617092e-01f, 8.509489519e-01f, 8.498273472e-01f, 8.486969172e-01f, 8.475576845e-01f, 8.464096715e-01f, 
8.452529009e-01f, 8.440873958e-01f, 8.429131792e-01f, 8.417302743e-01f, 8.405387045e-01f, 8.393384935e-01f, 8.381296650e-01f, 8.369122429e-01f, 8.356862513e-01f, 8.344517144e-01f, 
8.332086566e-01f, 8.319571026e-01f, 8.306970771e-01f, 8.294286049e-01f, 8.281517112e-01f, 8.268664211e-01f, 8.255727602e-01f, 8.242707538e-01f, 8.229604278e-01f, 8.216418079e-01f, 
8.203149203e-01f, 8.189797911e-01f, 8.176364466e-01f, 8.162849134e-01f, 8.149252181e-01f, 8.135573876e-01f, 8.121814487e-01f, 8.107974287e-01f, 8.094053548e-01f, 8.080052544e-01f, 
8.065971551e-01f, 8.051810846e-01f, 8.037570709e-01f, 8.023251420e-01f, 8.008853260e-01f, 7.994376512e-01f, 7.979821463e-01f, 7.965188397e-01f, 7.950477604e-01f, 7.935689371e-01f, 
7.920823990e-01f, 7.905881753e-01f, 7.890862953e-01f, 7.875767886e-01f, 7.860596848e-01f, 7.845350137e-01f, 7.830028052e-01f, 7.814630894e-01f, 7.799158965e-01f, 7.783612568e-01f, 
7.767992009e-01f, 7.752297593e-01f, 7.736529629e-01f, 7.720688425e-01f, 7.704774291e-01f, 7.688787541e-01f, 7.672728485e-01f, 7.656597440e-01f, 7.640394720e-01f, 7.624120643e-01f, 
7.607775527e-01f, 7.591359692e-01f, 7.574873459e-01f, 7.558317149e-01f, 7.541691088e-01f, 7.524995598e-01f, 7.508231007e-01f, 7.491397642e-01f, 7.474495831e-01f, 7.457525904e-01f, 
7.440488193e-01f, 7.423383030e-01f, 7.406210748e-01f, 7.388971682e-01f, 7.371666168e-01f, 7.354294543e-01f, 7.336857145e-01f, 7.319354315e-01f, 7.301786392e-01f, 7.284153719e-01f, 
7.266456638e-01f, 7.248695495e-01f, 7.230870634e-01f, 7.212982401e-01f, 7.195031144e-01f, 7.177017213e-01f, 7.158940956e-01f, 7.140802725e-01f, 7.122602872e-01f, 7.104341749e-01f, 
7.086019712e-01f, 7.067637114e-01f, 7.049194314e-01f, 7.030691667e-01f, 7.012129532e-01f, 6.993508269e-01f, 6.974828239e-01f, 6.956089802e-01f, 6.937293321e-01f, 6.918439160e-01f, 
6.899527683e-01f, 6.880559255e-01f, 6.861534244e-01f, 6.842453016e-01f, 6.823315940e-01f, 6.804123385e-01f, 6.784875721e-01f, 6.765573320e-01f, 6.746216554e-01f, 6.726805796e-01f, 
6.707341419e-01f, 6.687823799e-01f, 6.668253311e-01f, 6.648630332e-01f, 6.628955239e-01f, 6.609228411e-01f, 6.589450227e-01f, 6.569621066e-01f, 6.549741311e-01f, 6.529811342e-01f, 
6.509831542e-01f, 6.489802294e-01f, 6.469723983e-01f, 6.449596994e-01f, 6.429421711e-01f, 6.409198522e-01f, 6.388927814e-01f, 6.368609974e-01f, 6.348245393e-01f, 6.327834458e-01f, 
6.307377561e-01f, 6.286875091e-01f, 6.266327442e-01f, 6.245735005e-01f, 6.225098173e-01f, 6.204417340e-01f, 6.183692900e-01f, 6.162925249e-01f, 6.142114781e-01f, 6.121261895e-01f, 
6.100366985e-01f, 6.079430451e-01f, 6.058452690e-01f, 6.037434101e-01f, 6.016375084e-01f, 5.995276038e-01f, 5.974137365e-01f, 5.952959465e-01f, 5.931742741e-01f, 5.910487594e-01f, 
5.889194427e-01f, 5.867863644e-01f, 5.846495649e-01f, 5.825090846e-01f, 5.803649640e-01f, 5.782172436e-01f, 5.760659641e-01f, 5.739111661e-01f, 5.717528903e-01f, 5.695911773e-01f, 
5.674260681e-01f, 5.652576033e-01f, 5.630858239e-01f, 5.609107708e-01f, 5.587324850e-01f, 5.565510073e-01f, 5.543663789e-01f, 5.521786409e-01f, 5.499878342e-01f, 5.477940001e-01f, 
5.455971798e-01f, 5.433974144e-01f, 5.411947452e-01f, 5.389892135e-01f, 5.367808605e-01f, 5.345697277e-01f, 5.323558565e-01f, 5.301392881e-01f, 5.279200640e-01f, 5.256982258e-01f, 
5.234738148e-01f, 5.212468725e-01f, 5.190174406e-01f, 5.167855606e-01f, 5.145512740e-01f, 5.123146224e-01f, 5.100756475e-01f, 5.078343908e-01f, 5.055908942e-01f, 5.033451991e-01f, 
5.010973474e-01f, 4.988473807e-01f, 4.965953407e-01f, 4.943412692e-01f, 4.920852079e-01f, 4.898271986e-01f, 4.875672831e-01f, 4.853055031e-01f, 4.830419005e-01f, 4.807765169e-01f, 
4.785093943e-01f, 4.762405744e-01f, 4.739700991e-01f, 4.716980102e-01f, 4.694243494e-01f, 4.671491587e-01f, 4.648724798e-01f, 4.625943547e-01f, 4.603148250e-01f, 4.580339326e-01f, 
4.557517194e-01f, 4.534682272e-01f, 4.511834978e-01f, 4.488975730e-01f, 4.466104946e-01f, 4.443223044e-01f, 4.420330442e-01f, 4.397427557e-01f, 4.374514808e-01f, 4.351592612e-01f, 
4.328661387e-01f, 4.305721549e-01f, 4.282773516e-01f, 4.259817706e-01f, 4.236854534e-01f, 4.213884418e-01f, 4.190907775e-01f, 4.167925020e-01f, 4.144936570e-01f, 4.121942841e-01f, 
4.098944248e-01f, 4.075941208e-01f, 4.052934134e-01f, 4.029923444e-01f, 4.006909551e-01f, 3.983892870e-01f, 3.960873815e-01f, 3.937852800e-01f, 3.914830239e-01f, 3.891806546e-01f, 
3.868782133e-01f, 3.845757413e-01f, 3.822732799e-01f, 3.799708703e-01f, 3.776685537e-01f, 3.753663712e-01f, 3.730643640e-01f, 3.707625730e-01f, 3.684610394e-01f, 3.661598041e-01f, 
3.638589082e-01f, 3.615583924e-01f, 3.592582977e-01f, 3.569586649e-01f, 3.546595349e-01f, 3.523609483e-01f, 3.500629458e-01f, 3.477655681e-01f, 3.454688558e-01f, 3.431728495e-01f, 
3.408775896e-01f, 3.385831167e-01f, 3.362894711e-01f, 3.339966932e-01f, 3.317048233e-01f, 3.294139017e-01f, 3.271239684e-01f, 3.248350638e-01f, 3.225472279e-01f, 3.202605006e-01f, 
3.179749220e-01f, 3.156905320e-01f, 3.134073705e-01f, 3.111254772e-01f, 3.088448918e-01f, 3.065656541e-01f, 3.042878036e-01f, 3.020113799e-01f, 2.997364224e-01f, 2.974629707e-01f, 
2.951910639e-01f, 2.929207415e-01f, 2.906520425e-01f, 2.883850062e-01f, 2.861196716e-01f, 2.838560778e-01f, 2.815942636e-01f, 2.793342679e-01f, 2.770761295e-01f, 2.748198871e-01f, 
2.725655793e-01f, 2.703132447e-01f, 2.680629218e-01f, 2.658146490e-01f, 2.635684646e-01f, 2.613244069e-01f, 2.590825140e-01f, 2.568428240e-01f, 2.546053749e-01f, 2.523702047e-01f, 
2.501373511e-01f, 2.479068520e-01f, 2.456787449e-01f, 2.434530676e-01f, 2.412298574e-01f, 2.390091519e-01f, 2.367909883e-01f, 2.345754038e-01f, 2.323624356e-01f, 2.301521208e-01f, 
2.279444963e-01f, 2.257395990e-01f, 2.235374657e-01f, 2.213381330e-01f, 2.191416375e-01f, 2.169480158e-01f, 2.147573042e-01f, 2.125695391e-01f, 2.103847566e-01f, 2.082029928e-01f, 
2.060242838e-01f, 2.038486655e-01f, 2.016761736e-01f, 1.995068439e-01f, 1.973407120e-01f, 1.951778133e-01f, 1.930181833e-01f, 1.908618573e-01f, 1.887088704e-01f, 1.865592578e-01f, 
1.844130544e-01f, 1.822702950e-01f, 1.801310145e-01f, 1.779952475e-01f, 1.758630285e-01f, 1.737343920e-01f, 1.716093722e-01f, 1.694880034e-01f, 1.673703197e-01f, 1.652563551e-01f, 
1.631461435e-01f, 1.610397185e-01f, 1.589371138e-01f, 1.568383630e-01f, 1.547434995e-01f, 1.526525565e-01f, 1.505655673e-01f, 1.484825648e-01f, 1.464035821e-01f, 1.443286518e-01f, 
1.422578068e-01f, 1.401910796e-01f, 1.381285027e-01f, 1.360701083e-01f, 1.340159287e-01f, 1.319659960e-01f, 1.299203421e-01f, 1.278789988e-01f, 1.258419979e-01f, 1.238093709e-01f, 
1.217811493e-01f, 1.197573644e-01f, 1.177380474e-01f, 1.157232294e-01f, 1.137129413e-01f, 1.117072139e-01f, 1.097060779e-01f, 1.077095638e-01f, 1.057177021e-01f, 1.037305229e-01f, 
1.017480566e-01f, 9.977033298e-02f, 9.779738204e-02f, 9.582923350e-02f, 9.386591696e-02f, 9.190746188e-02f, 8.995389761e-02f, 8.800525334e-02f, 8.606155812e-02f, 8.412284087e-02f, 
8.218913037e-02f, 8.026045526e-02f, 7.833684404e-02f, 7.641832506e-02f, 7.450492655e-02f, 7.259667658e-02f, 7.069360307e-02f, 6.879573383e-02f, 6.690309649e-02f, 6.501571856e-02f, 
6.313362738e-02f, 6.125685019e-02f, 5.938541403e-02f, 5.751934583e-02f, 5.565867236e-02f, 5.380342024e-02f, 5.195361597e-02f, 5.010928585e-02f, 4.827045608e-02f, 4.643715269e-02f, 
4.460940155e-02f, 4.278722840e-02f, 4.097065883e-02f, 3.915971825e-02f, 3.735443194e-02f, 3.555482504e-02f, 3.376092252e-02f, 3.197274919e-02f, 3.019032973e-02f, 2.841368864e-02f, 
2.664285028e-02f, 2.487783886e-02f, 2.311867842e-02f, 2.136539286e-02f, 1.961800591e-02f, 1.787654116e-02f, 1.614102202e-02f, 1.441147176e-02f, 1.268791349e-02f, 1.097037015e-02f, 
9.258864542e-03f, 7.553419289e-03f, 5.854056866e-03f, 4.160799585e-03f, 2.473669595e-03f, 7.926888899e-04f, -8.821207022e-04f, -2.550737512e-03f, -4.213140034e-03f, -5.869306922e-03f, 
-7.519216995e-03f, -9.162849234e-03f, -1.080018278e-02f, -1.243119695e-02f, -1.405587120e-02f, -1.567418518e-02f, -1.728611869e-02f, -1.889165169e-02f, -2.049076431e-02f, -2.208343684e-02f, 
-2.366964976e-02f, -2.524938369e-02f, -2.682261942e-02f, -2.838933791e-02f, -2.994952031e-02f, -3.150314789e-02f, -3.305020213e-02f, -3.459066466e-02f, -3.612451728e-02f, -3.765174196e-02f, 
-3.917232084e-02f, -4.068623622e-02f, -4.219347059e-02f, -4.369400658e-02f, -4.518782703e-02f, -4.667491490e-02f, -4.815525337e-02f, -4.962882576e-02f, -5.109561556e-02f, -5.255560646e-02f, 
-5.400878228e-02f, -5.545512706e-02f, -5.689462496e-02f, -5.832726035e-02f, -5.975301776e-02f, -6.117188189e-02f, -6.258383762e-02f, -6.398886999e-02f, -6.538696423e-02f, -6.677810573e-02f, 
-6.816228007e-02f, -6.953947297e-02f, -7.090967037e-02f, -7.227285834e-02f, -7.362902316e-02f, -7.497815127e-02f, -7.632022927e-02f, -7.765524396e-02f, -7.898318229e-02f, -8.030403142e-02f, 
-8.161777864e-02f, -8.292441146e-02f, -8.422391754e-02f, -8.551628470e-02f, -8.680150099e-02f, -8.807955457e-02f, -8.935043383e-02f, -9.061412730e-02f, -9.187062371e-02f, -9.311991195e-02f, 
-9.436198110e-02f, -9.559682041e-02f, -9.682441929e-02f, -9.804476736e-02f, -9.925785440e-02f, -1.004636704e-01f, -1.016622054e-01f, -1.028534497e-01f, -1.040373940e-01f, -1.052140287e-01f, 
-1.063833448e-01f, -1.075453333e-01f, -1.086999854e-01f, -1.098472924e-01f, -1.109872459e-01f, -1.121198376e-01f, -1.132450595e-01f, -1.143629036e-01f, -1.154733622e-01f, -1.165764277e-01f, 
-1.176720927e-01f, -1.187603501e-01f, -1.198411927e-01f, -1.209146138e-01f, -1.219806067e-01f, -1.230391648e-01f, -1.240902820e-01f, -1.251339519e-01f, -1.261701687e-01f, -1.271989265e-01f, 
-1.282202198e-01f, -1.292340432e-01f, -1.302403913e-01f, -1.312392591e-01f, -1.322306417e-01f, -1.332145343e-01f, -1.341909325e-01f, -1.351598319e-01f, -1.361212282e-01f, -1.370751175e-01f, 
-1.380214958e-01f, -1.389603597e-01f, -1.398917054e-01f, -1.408155299e-01f, -1.417318299e-01f, -1.426406024e-01f, -1.435418447e-01f, -1.444355543e-01f, -1.453217285e-01f, -1.462003653e-01f, 
-1.470714625e-01f, -1.479350183e-01f, -1.487910309e-01f, -1.496394987e-01f, -1.504804204e-01f, -1.513137948e-01f, -1.521396209e-01f, -1.529578978e-01f, -1.537686248e-01f, -1.545718015e-01f, 
-1.553674275e-01f, -1.561555026e-01f, -1.569360270e-01f, -1.577090007e-01f, -1.584744242e-01f, -1.592322980e-01f, -1.599826229e-01f, -1.607253996e-01f, -1.614606293e-01f, -1.621883132e-01f, 
-1.629084528e-01f, -1.636210495e-01f, -1.643261052e-01f, -1.650236218e-01f, -1.657136013e-01f, -1.663960461e-01f, -1.670709585e-01f, -1.677383413e-01f, -1.683981971e-01f, -1.690505289e-01f, 
-1.696953399e-01f, -1.703326333e-01f, -1.709624126e-01f, -1.715846814e-01f, -1.721994435e-01f, -1.728067029e-01f, -1.734064638e-01f, -1.739987304e-01f, -1.745835071e-01f, -1.751607988e-01f, 
-1.757306100e-01f, -1.762929459e-01f, -1.768478116e-01f, -1.773952123e-01f, -1.779351536e-01f, -1.784676411e-01f, -1.789926805e-01f, -1.795102780e-01f, -1.800204395e-01f, -1.805231715e-01f, 
-1.810184803e-01f, -1.815063727e-01f, -1.819868553e-01f, -1.824599352e-01f, -1.829256195e-01f, -1.833839154e-01f, -1.838348304e-01f, -1.842783721e-01f, -1.847145484e-01f, -1.851433670e-01f, 
-1.855648361e-01f, -1.859789640e-01f, -1.863857590e-01f, -1.867852297e-01f, -1.871773849e-01f, -1.875622335e-01f, -1.879397845e-01f, -1.883100470e-01f, -1.886730306e-01f, -1.890287446e-01f, 
-1.893771988e-01f, -1.897184030e-01f, -1.900523672e-01f, -1.903791015e-01f, -1.906986162e-01f, -1.910109219e-01f, -1.913160291e-01f, -1.916139485e-01f, -1.919046912e-01f, -1.921882681e-01f, 
-1.924646904e-01f, -1.927339697e-01f, -1.929961174e-01f, -1.932511451e-01f, -1.934990647e-01f, -1.937398882e-01f, -1.939736278e-01f, -1.942002956e-01f, -1.944199042e-01f, -1.946324661e-01f, 
-1.948379941e-01f, -1.950365009e-01f, -1.952279997e-01f, -1.954125036e-01f, -1.955900259e-01f, -1.957605801e-01f, -1.959241798e-01f, -1.960808387e-01f, -1.962305707e-01f, -1.963733899e-01f, 
-1.965093105e-01f, -1.966383467e-01f, -1.967605131e-01f, -1.968758243e-01f, -1.969842949e-01f, -1.970859399e-01f, -1.971807744e-01f, -1.972688134e-01f, -1.973500723e-01f, -1.974245666e-01f, 
-1.974923118e-01f, -1.975533236e-01f, -1.976076180e-01f, -1.976552109e-01f, -1.976961184e-01f, -1.977303568e-01f, -1.977579425e-01f, -1.977788921e-01f, -1.977932221e-01f, -1.978009495e-01f, 
-1.978020911e-01f, -1.977966641e-01f, -1.977846855e-01f, -1.977661728e-01f, -1.977411433e-01f, -1.977096148e-01f, -1.976716048e-01f, -1.976271313e-01f, -1.975762122e-01f, -1.975188656e-01f, 
-1.974551097e-01f, -1.973849629e-01f, -1.973084437e-01f, -1.972255707e-01f, -1.971363625e-01f, -1.970408381e-01f, -1.969390164e-01f, -1.968309165e-01f, -1.967165576e-01f, -1.965959591e-01f, 
-1.964691404e-01f, -1.963361210e-01f, -1.961969208e-01f, -1.960515595e-01f, -1.959000570e-01f, -1.957424334e-01f, -1.955787088e-01f, -1.954089036e-01f, -1.952330381e-01f, -1.950511328e-01f, 
-1.948632084e-01f, -1.946692857e-01f, -1.944693853e-01f, -1.942635284e-01f, -1.940517360e-01f, -1.938340293e-01f, -1.936104296e-01f, -1.933809582e-01f, -1.931456367e-01f, -1.929044868e-01f, 
-1.926575301e-01f, -1.924047885e-01f, -1.921462839e-01f, -1.918820384e-01f, -1.916120741e-01f, -1.913364134e-01f, -1.910550784e-01f, -1.907680918e-01f, -1.904754760e-01f, -1.901772537e-01f, 
-1.898734478e-01f, -1.895640810e-01f, -1.892491764e-01f, -1.889287569e-01f, -1.886028458e-01f, -1.882714663e-01f, -1.879346418e-01f, -1.875923957e-01f, -1.872447515e-01f, -1.868917329e-01f, 
-1.865333637e-01f, -1.861696676e-01f, -1.858006686e-01f, -1.854263907e-01f, -1.850468579e-01f, -1.846620945e-01f, -1.842721247e-01f, -1.838769730e-01f, -1.834766637e-01f, -1.830712214e-01f, 
-1.826606708e-01f, -1.822450365e-01f, -1.818243433e-01f, -1.813986162e-01f, -1.809678800e-01f, -1.805321599e-01f, -1.800914810e-01f, -1.796458684e-01f, -1.791953475e-01f, -1.787399436e-01f, 
-1.782796822e-01f, -1.778145888e-01f, -1.773446891e-01f, -1.768700086e-01f, -1.763905732e-01f, -1.759064087e-01f, -1.754175409e-01f, -1.749239960e-01f, -1.744257999e-01f, -1.739229787e-01f, 
-1.734155587e-01f, -1.729035661e-01f, -1.723870272e-01f, -1.718659686e-01f, -1.713404165e-01f, -1.708103976e-01f, -1.702759386e-01f, -1.697370659e-01f, -1.691938065e-01f, -1.686461871e-01f, 
-1.680942346e-01f, -1.675379758e-01f, -1.669774379e-01f, -1.664126478e-01f, -1.658436327e-01f, -1.652704198e-01f, -1.646930362e-01f, -1.641115093e-01f, -1.635258664e-01f, -1.629361350e-01f, 
-1.623423424e-01f, -1.617445163e-01f, -1.611426841e-01f, -1.605368736e-01f, -1.599271124e-01f, -1.593134282e-01f, -1.586958487e-01f, -1.580744020e-01f, -1.574491157e-01f, -1.568200180e-01f, 
-1.561871366e-01f, -1.555504998e-01f, -1.549101354e-01f, -1.542660718e-01f, -1.536183369e-01f, -1.529669591e-01f, -1.523119666e-01f, -1.516533877e-01f, -1.509912507e-01f, -1.503255840e-01f, 
-1.496564160e-01f, -1.489837752e-01f, -1.483076901e-01f, -1.476281892e-01f, -1.469453011e-01f, -1.462590544e-01f, -1.455694778e-01f, -1.448765998e-01f, -1.441804493e-01f, -1.434810550e-01f, 
-1.427784457e-01f, -1.420726502e-01f, -1.413636972e-01f, -1.406516158e-01f, -1.399364348e-01f, -1.392181830e-01f, -1.384968896e-01f, -1.377725835e-01f, -1.370452936e-01f, -1.363150490e-01f, 
-1.355818788e-01f, -1.348458121e-01f, -1.341068780e-01f, -1.333651056e-01f, -1.326205240e-01f, -1.318731625e-01f, -1.311230501e-01f, -1.303702162e-01f, -1.296146900e-01f, -1.288565007e-01f, 
-1.280956776e-01f, -1.273322499e-01f, -1.265662470e-01f, -1.257976981e-01f, -1.250266326e-01f, -1.242530798e-01f, -1.234770691e-01f, -1.226986298e-01f, -1.219177914e-01f, -1.211345831e-01f, 
-1.203490343e-01f, -1.195611745e-01f, -1.187710331e-01f, -1.179786395e-01f, -1.171840230e-01f, -1.163872132e-01f, -1.155882394e-01f, -1.147871310e-01f, -1.139839176e-01f, -1.131786285e-01f, 
-1.123712931e-01f, -1.115619410e-01f, -1.107506015e-01f, -1.099373040e-01f, -1.091220781e-01f, -1.083049530e-01f, -1.074859584e-01f, -1.066651235e-01f, -1.058424777e-01f, -1.050180506e-01f, 
-1.041918715e-01f, -1.033639697e-01f, -1.025343748e-01f, -1.017031160e-01f, -1.008702227e-01f, -1.000357243e-01f, -9.919965014e-02f, -9.836202955e-02f, -9.752289185e-02f, -9.668226635e-02f, 
-9.584018234e-02f, -9.499666911e-02f, -9.415175591e-02f, -9.330547200e-02f, -9.245784660e-02f, -9.160890893e-02f, -9.075868818e-02f, -8.990721353e-02f, -8.905451412e-02f, -8.820061910e-02f, 
-8.734555757e-02f, -8.648935862e-02f, -8.563205132e-02f, -8.477366470e-02f, -8.391422779e-02f, -8.305376958e-02f, -8.219231903e-02f, -8.132990508e-02f, -8.046655664e-02f, -7.960230259e-02f, 
-7.873717179e-02f, -7.787119305e-02f, -7.700439518e-02f, -7.613680694e-02f, -7.526845704e-02f, -7.439937420e-02f, -7.352958707e-02f, -7.265912429e-02f, -7.178801444e-02f, -7.091628608e-02f, 
-7.004396775e-02f, -6.917108792e-02f, -6.829767504e-02f, -6.742375752e-02f, -6.654936373e-02f, -6.567452201e-02f, -6.479926063e-02f, -6.392360786e-02f, -6.304759189e-02f, -6.217124089e-02f, 
-6.129458298e-02f, -6.041764623e-02f, -5.954045869e-02f, -5.866304833e-02f, -5.778544309e-02f, -5.690767088e-02f, -5.602975952e-02f, -5.515173683e-02f, -5.427363056e-02f, -5.339546839e-02f, 
-5.251727798e-02f, -5.163908692e-02f, -5.076092278e-02f, -4.988281303e-02f, -4.900478512e-02f, -4.812686644e-02f, -4.724908433e-02f, -4.637146605e-02f, -4.549403884e-02f, -4.461682986e-02f, 
-4.373986623e-02f, -4.286317499e-02f, -4.198678314e-02f, -4.111071762e-02f, -4.023500530e-02f, -3.935967300e-02f, -3.848474748e-02f, -3.761025542e-02f, -3.673622347e-02f, -3.586267819e-02f, 
-3.498964609e-02f, -3.411715360e-02f, -3.324522712e-02f, -3.237389295e-02f, -3.150317733e-02f, -3.063310645e-02f, -2.976370643e-02f, -2.889500331e-02f, -2.802702306e-02f, -2.715979160e-02f, 
-2.629333476e-02f, -2.542767832e-02f, -2.456284797e-02f, -2.369886934e-02f, -2.283576799e-02f, -2.197356940e-02f, -2.111229897e-02f, -2.025198206e-02f, -1.939264391e-02f, -1.853430972e-02f, 
-1.767700459e-02f, -1.682075358e-02f, -1.596558162e-02f, -1.511151361e-02f, -1.425857435e-02f, -1.340678857e-02f, -1.255618092e-02f, -1.170677596e-02f, -1.085859818e-02f, -1.001167199e-02f, 
-9.166021718e-03f, -8.321671609e-03f, -7.478645824e-03f, -6.636968445e-03f, -5.796663469e-03f, -4.957754809e-03f, -4.120266295e-03f, -3.284221669e-03f, -2.449644592e-03f, -1.616558636e-03f, 
-7.849872875e-04f, 4.504605390e-05f, 8.735180761e-04f, 1.700405555e-03f, 2.525685355e-03f, 3.349334430e-03f, 4.171329823e-03f, 4.991648667e-03f, 5.810268185e-03f, 6.627165691e-03f, 
7.442318593e-03f, 8.255704389e-03f, 9.067300668e-03f, 9.877085114e-03f, 1.068503551e-02f, 1.149112971e-02f, 1.229534570e-02f, 1.309766153e-02f, 1.389805536e-02f, 1.469650543e-02f, 
1.549299011e-02f, 1.628748782e-02f, 1.707997712e-02f, 1.787043665e-02f, 1.865884513e-02f, 1.944518141e-02f, 2.022942443e-02f, 2.101155321e-02f, 2.179154690e-02f, 2.256938472e-02f, 
2.334504602e-02f, 2.411851023e-02f, 2.488975689e-02f, 2.565876564e-02f, 2.642551622e-02f, 2.718998849e-02f, 2.795216238e-02f, 2.871201796e-02f, 2.946953538e-02f, 3.022469490e-02f, 
3.097747689e-02f, 3.172786183e-02f, 3.247583028e-02f, 3.322136293e-02f, 3.396444058e-02f, 3.470504413e-02f, 3.544315456e-02f, 3.617875301e-02f, 3.691182069e-02f, 3.764233892e-02f, 
3.837028915e-02f, 3.909565292e-02f, 3.981841188e-02f, 4.053854782e-02f, 4.125604259e-02f, 4.197087818e-02f, 4.268303670e-02f, 4.339250035e-02f, 4.409925145e-02f, 4.480327244e-02f, 
4.550454586e-02f, 4.620305436e-02f, 4.689878071e-02f, 4.759170781e-02f, 4.828181864e-02f, 4.896909631e-02f, 4.965352405e-02f, 5.033508520e-02f, 5.101376320e-02f, 5.168954164e-02f, 
5.236240419e-02f, 5.303233466e-02f, 5.369931695e-02f, 5.436333511e-02f, 5.502437327e-02f, 5.568241570e-02f, 5.633744679e-02f, 5.698945104e-02f, 5.763841305e-02f, 5.828431758e-02f, 
5.892714946e-02f, 5.956689367e-02f, 6.020353530e-02f, 6.083705956e-02f, 6.146745178e-02f, 6.209469740e-02f, 6.271878199e-02f, 6.333969125e-02f, 6.395741096e-02f, 6.457192707e-02f, 
6.518322561e-02f, 6.579129277e-02f, 6.639611482e-02f, 6.699767817e-02f, 6.759596937e-02f, 6.819097506e-02f, 6.878268202e-02f, 6.937107714e-02f, 6.995614745e-02f, 7.053788008e-02f, 
7.111626231e-02f, 7.169128152e-02f, 7.226292521e-02f, 7.283118103e-02f, 7.339603672e-02f, 7.395748018e-02f, 7.451549939e-02f, 7.507008250e-02f, 7.562121775e-02f, 7.616889352e-02f, 
7.671309830e-02f, 7.725382073e-02f, 7.779104954e-02f, 7.832477363e-02f, 7.885498197e-02f, 7.938166370e-02f, 7.990480807e-02f, 8.042440445e-02f, 8.094044233e-02f, 8.145291135e-02f, 
8.196180125e-02f, 8.246710191e-02f, 8.296880333e-02f, 8.346689564e-02f, 8.396136909e-02f, 8.445221407e-02f, 8.493942107e-02f, 8.542298074e-02f, 8.590288382e-02f, 8.637912121e-02f, 
8.685168392e-02f, 8.732056308e-02f, 8.778574996e-02f, 8.824723596e-02f, 8.870501259e-02f, 8.915907150e-02f, 8.960940445e-02f, 9.005600336e-02f, 9.049886024e-02f, 9.093796726e-02f, 
9.137331668e-02f, 9.180490093e-02f, 9.223271253e-02f, 9.265674415e-02f, 9.307698858e-02f, 9.349343874e-02f, 9.390608766e-02f, 9.431492853e-02f, 9.471995464e-02f, 9.512115942e-02f, 
9.551853642e-02f, 9.591207933e-02f, 9.630178196e-02f, 9.668763823e-02f, 9.706964222e-02f, 9.744778811e-02f, 9.782207022e-02f, 9.819248301e-02f, 9.855902104e-02f, 9.892167901e-02f, 
9.928045176e-02f, 9.963533423e-02f, 9.998632151e-02f, 1.003334088e-01f, 1.006765915e-01f, 1.010158649e-01f, 1.013512248e-01f, 1.016826668e-01f, 1.020101868e-01f, 1.023337807e-01f, 
1.026534446e-01f, 1.029691749e-01f, 1.032809677e-01f, 1.035888196e-01f, 1.038927272e-01f, 1.041926873e-01f, 1.044886966e-01f, 1.047807522e-01f, 1.050688512e-01f, 1.053529908e-01f, 
1.056331684e-01f, 1.059093815e-01f, 1.061816276e-01f, 1.064499045e-01f, 1.067142101e-01f, 1.069745424e-01f, 1.072308995e-01f, 1.074832796e-01f, 1.077316810e-01f, 1.079761024e-01f, 
1.082165422e-01f, 1.084529993e-01f, 1.086854725e-01f, 1.089139608e-01f, 1.091384632e-01f, 1.093589791e-01f, 1.095755078e-01f, 1.097880488e-01f, 1.099966017e-01f, 1.102011662e-01f, 
1.104017421e-01f, 1.105983295e-01f, 1.107909284e-01f, 1.109795392e-01f, 1.111641620e-01f, 1.113447974e-01f, 1.115214460e-01f, 1.116941085e-01f, 1.118627857e-01f, 1.120274786e-01f, 
1.121881882e-01f, 1.123449158e-01f, 1.124976627e-01f, 1.126464303e-01f, 1.127912201e-01f, 1.129320339e-01f, 1.130688735e-01f, 1.132017407e-01f, 1.133306376e-01f, 1.134555664e-01f, 
1.135765294e-01f, 1.136935289e-01f, 1.138065675e-01f, 1.139156478e-01f, 1.140207725e-01f, 1.141219446e-01f, 1.142191670e-01f, 1.143124428e-01f, 1.144017752e-01f, 1.144871677e-01f, 
1.145686236e-01f, 1.146461465e-01f, 1.147197401e-01f, 1.147894082e-01f, 1.148551548e-01f, 1.149169838e-01f, 1.149748995e-01f, 1.150289061e-01f, 1.150790079e-01f, 1.151252095e-01f, 
1.151675156e-01f, 1.152059307e-01f, 1.152404597e-01f, 1.152711077e-01f, 1.152978796e-01f, 1.153207806e-01f, 1.153398160e-01f, 1.153549913e-01f, 1.153663119e-01f, 1.153737834e-01f, 
1.153774116e-01f, 1.153772023e-01f, 1.153731616e-01f, 1.153652953e-01f, 1.153536098e-01f, 1.153381112e-01f, 1.153188060e-01f, 1.152957008e-01f, 1.152688020e-01f, 1.152381164e-01f, 
1.152036508e-01f, 1.151654122e-01f, 1.151234076e-01f, 1.150776441e-01f, 1.150281289e-01f, 1.149748696e-01f, 1.149178734e-01f, 1.148571480e-01f, 1.147927010e-01f, 1.147245402e-01f, 
1.146526735e-01f, 1.145771089e-01f, 1.144978544e-01f, 1.144149182e-01f, 1.143283087e-01f, 1.142380341e-01f, 1.141441031e-01f, 1.140465241e-01f, 1.139453060e-01f, 1.138404574e-01f, 
1.137319873e-01f, 1.136199047e-01f, 1.135042186e-01f, 1.133849383e-01f, 1.132620731e-01f, 1.131356323e-01f, 1.130056254e-01f, 1.128720620e-01f, 1.127349517e-01f, 1.125943045e-01f, 
1.124501300e-01f, 1.123024384e-01f, 1.121512396e-01f, 1.119965438e-01f, 1.118383612e-01f, 1.116767023e-01f, 1.115115774e-01f, 1.113429971e-01f, 1.111709719e-01f, 1.109955127e-01f, 
1.108166301e-01f, 1.106343352e-01f, 1.104486388e-01f, 1.102595522e-01f, 1.100670863e-01f, 1.098712525e-01f, 1.096720622e-01f, 1.094695267e-01f, 1.092636576e-01f, 1.090544665e-01f, 
1.088419651e-01f, 1.086261652e-01f, 1.084070785e-01f, 1.081847172e-01f, 1.079590931e-01f, 1.077302186e-01f, 1.074981056e-01f, 1.072627666e-01f, 1.070242139e-01f, 1.067824599e-01f, 
1.065375172e-01f, 1.062893985e-01f, 1.060381163e-01f, 1.057836836e-01f, 1.055261131e-01f, 1.052654178e-01f, 1.050016106e-01f, 1.047347048e-01f, 1.044647135e-01f, 1.041916499e-01f, 
1.039155273e-01f, 1.036363593e-01f, 1.033541591e-01f, 1.030689405e-01f, 1.027807170e-01f, 1.024895023e-01f, 1.021953103e-01f, 1.018981548e-01f, 1.015980496e-01f, 1.012950089e-01f, 
1.009890466e-01f, 1.006801770e-01f, 1.003684142e-01f, 1.000537725e-01f, 9.973626634e-02f, 9.941591005e-02f, 9.909271815e-02f, 9.876670521e-02f, 9.843788585e-02f, 9.810627478e-02f, 
9.777188674e-02f, 9.743473658e-02f, 9.709483918e-02f, 9.675220951e-02f, 9.640686259e-02f, 9.605881350e-02f, 9.570807740e-02f, 9.535466951e-02f, 9.499860510e-02f, 9.463989950e-02f, 
9.427856812e-02f, 9.391462642e-02f, 9.354808992e-02f, 9.317897419e-02f, 9.280729489e-02f, 9.243306769e-02f, 9.205630837e-02f, 9.167703274e-02f, 9.129525665e-02f, 9.091099605e-02f, 
9.052426690e-02f, 9.013508526e-02f, 8.974346720e-02f, 8.934942889e-02f, 8.895298650e-02f, 8.855415630e-02f, 8.815295459e-02f, 8.774939773e-02f, 8.734350212e-02f, 8.693528422e-02f, 
8.652476055e-02f, 8.611194764e-02f, 8.569686213e-02f, 8.527952065e-02f, 8.485993991e-02f, 8.443813667e-02f, 8.401412771e-02f, 8.358792988e-02f, 8.315956007e-02f, 8.272903521e-02f, 
8.229637228e-02f, 8.186158829e-02f, 8.142470033e-02f, 8.098572548e-02f, 8.054468090e-02f, 8.010158379e-02f, 7.965645136e-02f, 7.920930090e-02f, 7.876014972e-02f, 7.830901516e-02f, 
7.785591462e-02f, 7.740086552e-02f, 7.694388533e-02f, 7.648499155e-02f, 7.602420171e-02f, 7.556153339e-02f, 7.509700421e-02f, 7.463063179e-02f, 7.416243383e-02f, 7.369242802e-02f, 
7.322063211e-02f, 7.274706389e-02f, 7.227174114e-02f, 7.179468172e-02f, 7.131590349e-02f, 7.083542435e-02f, 7.035326222e-02f, 6.986943507e-02f, 6.938396087e-02f, 6.889685764e-02f, 
6.840814341e-02f, 6.791783625e-02f, 6.742595426e-02f, 6.693251554e-02f, 6.643753823e-02f, 6.594104051e-02f, 6.544304055e-02f, 6.494355658e-02f, 6.444260681e-02f, 6.394020951e-02f, 
6.343638294e-02f, 6.293114541e-02f, 6.242451524e-02f, 6.191651074e-02f, 6.140715029e-02f, 6.089645224e-02f, 6.038443499e-02f, 5.987111695e-02f, 5.935651653e-02f, 5.884065217e-02f, 
5.832354234e-02f, 5.780520548e-02f, 5.728566010e-02f, 5.676492467e-02f, 5.624301771e-02f, 5.571995774e-02f, 5.519576329e-02f, 5.467045291e-02f, 5.414404514e-02f, 5.361655855e-02f, 
5.308801171e-02f, 5.255842320e-02f, 5.202781162e-02f, 5.149619555e-02f, 5.096359361e-02f, 5.043002440e-02f, 4.989550654e-02f, 4.936005864e-02f, 4.882369935e-02f, 4.828644728e-02f, 
4.774832107e-02f, 4.720933935e-02f, 4.666952077e-02f, 4.612888397e-02f, 4.558744758e-02f, 4.504523025e-02f, 4.450225063e-02f, 4.395852734e-02f, 4.341407905e-02f, 4.286892437e-02f, 
4.232308196e-02f, 4.177657044e-02f, 4.122940844e-02f, 4.068161460e-02f, 4.013320753e-02f, 3.958420586e-02f, 3.903462818e-02f, 3.848449312e-02f, 3.793381926e-02f, 3.738262520e-02f, 
3.683092952e-02f, 3.627875079e-02f, 3.572610759e-02f, 3.517301846e-02f, 3.461950196e-02f, 3.406557661e-02f, 3.351126095e-02f, 3.295657347e-02f, 3.240153270e-02f, 3.184615710e-02f, 
3.129046515e-02f, 3.073447532e-02f, 3.017820604e-02f, 2.962167575e-02f, 2.906490286e-02f, 2.850790576e-02f, 2.795070284e-02f, 2.739331246e-02f, 2.683575297e-02f, 2.627804269e-02f, 
2.572019992e-02f, 2.516224297e-02f, 2.460419008e-02f, 2.404605953e-02f, 2.348786952e-02f, 2.292963826e-02f, 2.237138394e-02f, 2.181312472e-02f, 2.125487873e-02f, 2.069666408e-02f, 
2.013849886e-02f, 1.958040114e-02f, 1.902238896e-02f, 1.846448032e-02f, 1.790669320e-02f, 1.734904558e-02f, 1.679155538e-02f, 1.623424049e-02f, 1.567711881e-02f, 1.512020816e-02f, 
1.456352637e-02f, 1.400709123e-02f, 1.345092048e-02f, 1.289503185e-02f, 1.233944303e-02f, 1.178417168e-02f, 1.122923544e-02f, 1.067465188e-02f, 1.012043858e-02f, 9.566613058e-03f, 
9.013192805e-03f, 8.460195279e-03f, 7.907637899e-03f, 7.355538050e-03f, 6.803913079e-03f, 6.252780298e-03f, 5.702156978e-03f, 5.152060354e-03f, 4.602507622e-03f, 4.053515939e-03f, 
3.505102422e-03f, 2.957284148e-03f, 2.410078153e-03f, 1.863501433e-03f, 1.317570943e-03f, 7.723035929e-04f, 2.277162530e-04f, -3.161742503e-04f, -8.593511340e-04f, -1.401797659e-03f, 
-1.943497131e-03f, -2.484432900e-03f, -3.024588361e-03f, -3.563946955e-03f, -4.102492170e-03f, -4.640207539e-03f, -5.177076645e-03f, -5.713083116e-03f, -6.248210628e-03f, -6.782442906e-03f, 
-7.315763726e-03f, -7.848156911e-03f, -8.379606334e-03f, -8.910095918e-03f, -9.439609639e-03f, -9.968131521e-03f, -1.049564564e-02f, -1.102213613e-02f, -1.154758717e-02f, -1.207198299e-02f, 
-1.259530789e-02f, -1.311754619e-02f, -1.363868231e-02f, -1.415870069e-02f, -1.467758582e-02f, -1.519532229e-02f, -1.571189469e-02f, -1.622728771e-02f, -1.674148607e-02f, -1.725447456e-02f, 
-1.776623802e-02f, -1.827676136e-02f, -1.878602953e-02f, -1.929402756e-02f, -1.980074051e-02f, -2.030615353e-02f, -2.081025182e-02f, -2.131302063e-02f, -2.181444528e-02f, -2.231451114e-02f, 
-2.281320367e-02f, -2.331050835e-02f, -2.380641076e-02f, -2.430089652e-02f, -2.479395132e-02f, -2.528556091e-02f, -2.577571111e-02f, -2.626438780e-02f, -2.675157693e-02f, -2.723726450e-02f, 
-2.772143658e-02f, -2.820407933e-02f, -2.868517894e-02f, -2.916472169e-02f, -2.964269392e-02f, -3.011908202e-02f, -3.059387248e-02f, -3.106705183e-02f, -3.153860669e-02f, -3.200852372e-02f, 
-3.247678967e-02f, -3.294339137e-02f, -3.340831568e-02f, -3.387154956e-02f, -3.433308004e-02f, -3.479289421e-02f, -3.525097923e-02f, -3.570732233e-02f, -3.616191082e-02f, -3.661473208e-02f, 
-3.706577356e-02f, -3.751502277e-02f, -3.796246731e-02f, -3.840809484e-02f, -3.885189311e-02f, -3.929384992e-02f, -3.973395316e-02f, -4.017219080e-02f, -4.060855086e-02f, -4.104302145e-02f, 
-4.147559075e-02f, -4.190624703e-02f, -4.233497862e-02f, -4.276177392e-02f, -4.318662142e-02f, -4.360950968e-02f, -4.403042734e-02f, -4.444936311e-02f, -4.486630578e-02f, -4.528124423e-02f, 
-4.569416739e-02f, -4.610506429e-02f, -4.651392404e-02f, -4.692073580e-02f, -4.732548885e-02f, -4.772817251e-02f, -4.812877620e-02f, -4.852728942e-02f, -4.892370173e-02f, -4.931800281e-02f, 
-4.971018237e-02f, -5.010023023e-02f, -5.048813629e-02f, -5.087389053e-02f, -5.125748298e-02f, -5.163890381e-02f, -5.201814322e-02f, -5.239519151e-02f, -5.277003906e-02f, -5.314267634e-02f, 
-5.351309389e-02f, -5.388128234e-02f, -5.424723239e-02f, -5.461093485e-02f, -5.497238059e-02f, -5.533156056e-02f, -5.568846581e-02f, -5.604308746e-02f, -5.639541672e-02f, -5.674544489e-02f, 
-5.709316333e-02f, -5.743856352e-02f, -5.778163699e-02f, -5.812237538e-02f, -5.846077040e-02f, -5.879681385e-02f, -5.913049761e-02f, -5.946181365e-02f, -5.979075403e-02f, -6.011731088e-02f, 
-6.044147644e-02f, -6.076324301e-02f, -6.108260299e-02f, -6.139954886e-02f, -6.171407320e-02f, -6.202616865e-02f, -6.233582797e-02f, -6.264304397e-02f, -6.294780958e-02f, -6.325011779e-02f, 
-6.354996170e-02f, -6.384733448e-02f, -6.414222940e-02f, -6.443463980e-02f, -6.472455912e-02f, -6.501198089e-02f, -6.529689872e-02f, -6.557930632e-02f, -6.585919747e-02f, -6.613656604e-02f, 
-6.641140600e-02f, -6.668371141e-02f, -6.695347641e-02f, -6.722069522e-02f, -6.748536216e-02f, -6.774747163e-02f, -6.800701814e-02f, -6.826399626e-02f, -6.851840067e-02f, -6.877022612e-02f, 
-6.901946746e-02f, -6.926611964e-02f, -6.951017768e-02f, -6.975163669e-02f, -6.999049188e-02f, -7.022673854e-02f, -7.046037205e-02f, -7.069138789e-02f, -7.091978162e-02f, -7.114554889e-02f, 
-7.136868544e-02f, -7.158918709e-02f, -7.180704977e-02f, -7.202226948e-02f, -7.223484231e-02f, -7.244476447e-02f, -7.265203221e-02f, -7.285664191e-02f, -7.305859002e-02f, -7.325787309e-02f, 
-7.345448775e-02f, -7.364843071e-02f, -7.383969881e-02f, -7.402828892e-02f, -7.421419806e-02f, -7.439742329e-02f, -7.457796180e-02f, -7.475581083e-02f, -7.493096775e-02f, -7.510342998e-02f, 
-7.527319506e-02f, -7.544026060e-02f, -7.560462431e-02f, -7.576628399e-02f, -7.592523753e-02f, -7.608148289e-02f, -7.623501814e-02f, -7.638584144e-02f, -7.653395103e-02f, -7.667934524e-02f, 
-7.682202249e-02f, -7.696198130e-02f, -7.709922025e-02f, -7.723373804e-02f, -7.736553345e-02f, -7.749460533e-02f, -7.762095265e-02f, -7.774457445e-02f, -7.786546986e-02f, -7.798363809e-02f, 
-7.809907847e-02f, -7.821179037e-02f, -7.832177330e-02f, -7.842902682e-02f, -7.853355060e-02f, -7.863534438e-02f, -7.873440800e-02f, -7.883074139e-02f, -7.892434457e-02f, -7.901521762e-02f, 
-7.910336075e-02f, -7.918877422e-02f, -7.927145840e-02f, -7.935141375e-02f, -7.942864080e-02f, -7.950314017e-02f, -7.957491258e-02f, -7.964395882e-02f, -7.971027978e-02f, -7.977387644e-02f, 
-7.983474985e-02f, -7.989290116e-02f, -7.994833160e-02f, -8.000104248e-02f, -8.005103521e-02f, -8.009831127e-02f, -8.014287225e-02f, -8.018471980e-02f, -8.022385567e-02f, -8.026028169e-02f, 
-8.029399977e-02f, -8.032501192e-02f, -8.035332021e-02f, -8.037892683e-02f, -8.040183402e-02f, -8.042204412e-02f, -8.043955956e-02f, -8.045438284e-02f, -8.046651655e-02f, -8.047596338e-02f, 
-8.048272606e-02f, -8.048680745e-02f, -8.048821048e-02f, -8.048693813e-02f, -8.048299352e-02f, -8.047637980e-02f, -8.046710023e-02f, -8.045515815e-02f, -8.044055698e-02f, -8.042330021e-02f, 
-8.040339143e-02f, -8.038083431e-02f, -8.035563258e-02f, -8.032779006e-02f, -8.029731068e-02f, -8.026419840e-02f, -8.022845731e-02f, -8.019009154e-02f, -8.014910532e-02f, -8.010550296e-02f, 
-8.005928884e-02f, -8.001046743e-02f, -7.995904327e-02f, -7.990502098e-02f, -7.984840527e-02f, -7.978920091e-02f, -7.972741276e-02f, -7.966304576e-02f, -7.959610492e-02f, -7.952659533e-02f, 
-7.945452215e-02f, -7.937989063e-02f, -7.930270609e-02f, -7.922297392e-02f, -7.914069961e-02f, -7.905588869e-02f, -7.896854680e-02f, -7.887867962e-02f, -7.878629294e-02f, -7.869139261e-02f, 
-7.859398454e-02f, -7.849407475e-02f, -7.839166929e-02f, -7.828677431e-02f, -7.817939604e-02f, -7.806954076e-02f, -7.795721485e-02f, -7.784242474e-02f, -7.772517693e-02f, -7.760547802e-02f, 
-7.748333465e-02f, -7.735875355e-02f, -7.723174152e-02f, -7.710230542e-02f, -7.697045219e-02f, -7.683618885e-02f, -7.669952246e-02f, -7.656046019e-02f, -7.641900923e-02f, -7.627517689e-02f, 
-7.612897052e-02f, -7.598039753e-02f, -7.582946543e-02f, -7.567618176e-02f, -7.552055417e-02f, -7.536259034e-02f, -7.520229804e-02f, -7.503968509e-02f, -7.487475938e-02f, -7.470752889e-02f, 
-7.453800163e-02f, -7.436618569e-02f, -7.419208924e-02f, -7.401572049e-02f, -7.383708772e-02f, -7.365619930e-02f, -7.347306362e-02f, -7.328768918e-02f, -7.310008449e-02f, -7.291025818e-02f, 
-7.271821890e-02f, -7.252397538e-02f, -7.232753640e-02f, -7.212891082e-02f, -7.192810755e-02f, -7.172513555e-02f, -7.152000386e-02f, -7.131272157e-02f, -7.110329783e-02f, -7.089174185e-02f, 
-7.067806290e-02f, -7.046227030e-02f, -7.024437344e-02f, -7.002438177e-02f, -6.980230478e-02f, -6.957815203e-02f, -6.935193314e-02f, -6.912365777e-02f, -6.889333565e-02f, -6.866097657e-02f, 
-6.842659036e-02f, -6.819018691e-02f, -6.795177618e-02f, -6.771136815e-02f, -6.746897289e-02f, -6.722460050e-02f, -6.697826114e-02f, -6.672996503e-02f, -6.647972243e-02f, -6.622754366e-02f, 
-6.597343909e-02f, -6.571741914e-02f, -6.545949428e-02f, -6.519967502e-02f, -6.493797195e-02f, -6.467439567e-02f, -6.440895687e-02f, -6.414166625e-02f, -6.387253459e-02f, -6.360157270e-02f, 
-6.332879144e-02f, -6.305420172e-02f, -6.277781449e-02f, -6.249964076e-02f, -6.221969158e-02f, -6.193797804e-02f, -6.165451128e-02f, -6.136930248e-02f, -6.108236288e-02f, -6.079370374e-02f, 
-6.050333637e-02f, -6.021127215e-02f, -5.991752247e-02f, -5.962209877e-02f, -5.932501254e-02f, -5.902627531e-02f, -5.872589864e-02f, -5.842389415e-02f, -5.812027349e-02f, -5.781504834e-02f, 
-5.750823043e-02f, -5.719983154e-02f, -5.688986346e-02f, -5.657833805e-02f, -5.626526718e-02f, -5.595066278e-02f, -5.563453680e-02f, -5.531690123e-02f, -5.499776812e-02f, -5.467714951e-02f, 
-5.435505752e-02f, -5.403150427e-02f, -5.370650194e-02f, -5.338006274e-02f, -5.305219889e-02f, -5.272292268e-02f, -5.239224639e-02f, -5.206018238e-02f, -5.172674301e-02f, -5.139194067e-02f, 
-5.105578780e-02f, -5.071829685e-02f, -5.037948033e-02f, -5.003935074e-02f, -4.969792065e-02f, -4.935520262e-02f, -4.901120927e-02f, -4.866595324e-02f, -4.831944717e-02f, -4.797170378e-02f, 
-4.762273576e-02f, -4.727255588e-02f, -4.692117688e-02f, -4.656861158e-02f, -4.621487279e-02f, -4.585997335e-02f, -4.550392613e-02f, -4.514674402e-02f, -4.478843995e-02f, -4.442902684e-02f, 
-4.406851766e-02f, -4.370692539e-02f, -4.334426304e-02f, -4.298054363e-02f, -4.261578020e-02f, -4.224998582e-02f, -4.188317358e-02f, -4.151535658e-02f, -4.114654794e-02f, -4.077676081e-02f, 
-4.040600835e-02f, -4.003430374e-02f, -3.966166017e-02f, -3.928809085e-02f, -3.891360902e-02f, -3.853822790e-02f, -3.816196077e-02f, -3.778482090e-02f, -3.740682158e-02f, -3.702797610e-02f, 
-3.664829780e-02f, -3.626779998e-02f, -3.588649601e-02f, -3.550439922e-02f, -3.512152300e-02f, -3.473788071e-02f, -3.435348574e-02f, -3.396835150e-02f, -3.358249139e-02f, -3.319591884e-02f, 
-3.280864727e-02f, -3.242069012e-02f, -3.203206083e-02f, -3.164277286e-02f, -3.125283966e-02f, -3.086227472e-02f, -3.047109149e-02f, -3.007930347e-02f, -2.968692413e-02f, -2.929396697e-02f, 
-2.890044550e-02f, -2.850637319e-02f, -2.811176358e-02f, -2.771663015e-02f, -2.732098642e-02f, -2.692484591e-02f, -2.652822214e-02f, -2.613112862e-02f, -2.573357887e-02f, -2.533558641e-02f, 
-2.493716476e-02f, -2.453832746e-02f, -2.413908800e-02f, -2.373945992e-02f, -2.333945674e-02f, -2.293909197e-02f, -2.253837912e-02f, -2.213733172e-02f, -2.173596326e-02f, -2.133428726e-02f, 
-2.093231722e-02f, -2.053006664e-02f, -2.012754900e-02f, -1.972477780e-02f, -1.932176652e-02f, -1.891852865e-02f, -1.851507764e-02f, -1.811142696e-02f, -1.770759007e-02f, -1.730358042e-02f, 
-1.689941145e-02f, -1.649509659e-02f, -1.609064927e-02f, -1.568608289e-02f, -1.528141087e-02f, -1.487664659e-02f, -1.447180345e-02f, -1.406689481e-02f, -1.366193404e-02f, -1.325693448e-02f, 
-1.285190948e-02f, -1.244687235e-02f, -1.204183640e-02f, -1.163681495e-02f, -1.123182126e-02f, -1.082686861e-02f, -1.042197025e-02f, -1.001713943e-02f, -9.612389368e-03f, -9.207733270e-03f, 
-8.803184330e-03f, -8.398755723e-03f, -7.994460607e-03f, -7.590312121e-03f, -7.186323388e-03f, -6.782507513e-03f, -6.378877580e-03f, -5.975446654e-03f, -5.572227783e-03f, -5.169233993e-03f, 
-4.766478289e-03f, -4.363973656e-03f, -3.961733059e-03f, -3.559769440e-03f, -3.158095718e-03f, -2.756724793e-03f, -2.355669539e-03f, -1.954942808e-03f, -1.554557428e-03f, -1.154526205e-03f, 
-7.548619186e-04f, -3.555773241e-04f, 4.331484798e-05f, 4.418018926e-04f, 8.398711306e-04f, 1.237509909e-03f, 1.634705602e-03f, 2.031445610e-03f, 2.427717361e-03f, 2.823508311e-03f, 
3.218805945e-03f, 3.613597773e-03f, 4.007871339e-03f, 4.401614212e-03f, 4.794813993e-03f, 5.187458312e-03f, 5.579534829e-03f, 5.971031237e-03f, 6.361935256e-03f, 6.752234642e-03f, 
7.141917179e-03f, 7.530970686e-03f, 7.919383013e-03f, 8.307142043e-03f, 8.694235693e-03f, 9.080651912e-03f, 9.466378685e-03f, 9.851404031e-03f, 1.023571600e-02f, 1.061930268e-02f, 
1.100215220e-02f, 1.138425272e-02f, 1.176559243e-02f, 1.214615956e-02f, 1.252594238e-02f, 1.290492919e-02f, 1.328310835e-02f, 1.366046822e-02f, 1.403699723e-02f, 1.441268384e-02f, 
1.478751654e-02f, 1.516148386e-02f, 1.553457439e-02f, 1.590677673e-02f, 1.627807954e-02f, 1.664847151e-02f, 1.701794138e-02f, 1.738647793e-02f, 1.775406996e-02f, 1.812070636e-02f, 
1.848637600e-02f, 1.885106784e-02f, 1.921477087e-02f, 1.957747411e-02f, 1.993916664e-02f, 2.029983757e-02f, 2.065947607e-02f, 2.101807133e-02f, 2.137561260e-02f, 2.173208919e-02f, 
2.208749043e-02f, 2.244180570e-02f, 2.279502443e-02f, 2.314713610e-02f, 2.349813023e-02f, 2.384799640e-02f, 2.419672420e-02f, 2.454430332e-02f, 2.489072345e-02f, 2.523597436e-02f, 
2.558004586e-02f, 2.592292779e-02f, 2.626461006e-02f, 2.660508262e-02f, 2.694433547e-02f, 2.728235867e-02f, 2.761914231e-02f, 2.795467654e-02f, 2.828895156e-02f, 2.862195763e-02f, 
2.895368504e-02f, 2.928412415e-02f, 2.961326536e-02f, 2.994109913e-02f, 3.026761596e-02f, 3.059280641e-02f, 3.091666110e-02f, 3.123917068e-02f, 3.156032588e-02f, 3.188011746e-02f, 
3.219853625e-02f, 3.251557313e-02f, 3.283121902e-02f, 3.314546491e-02f, 3.345830184e-02f, 3.376972089e-02f, 3.407971323e-02f, 3.438827006e-02f, 3.469538262e-02f, 3.500104224e-02f, 
3.530524028e-02f, 3.560796817e-02f, 3.590921739e-02f, 3.620897949e-02f, 3.650724604e-02f, 3.680400871e-02f, 3.709925920e-02f, 3.739298928e-02f, 3.768519077e-02f, 3.797585554e-02f, 
3.826497555e-02f, 3.855254278e-02f, 3.883854929e-02f, 3.912298720e-02f, 3.940584866e-02f, 3.968712592e-02f, 3.996681126e-02f, 4.024489704e-02f, 4.052137565e-02f, 4.079623957e-02f, 
4.106948132e-02f, 4.134109350e-02f, 4.161106875e-02f, 4.187939977e-02f, 4.214607934e-02f, 4.241110028e-02f, 4.267445549e-02f, 4.293613791e-02f, 4.319614056e-02f, 4.345445651e-02f, 
4.371107889e-02f, 4.396600091e-02f, 4.421921582e-02f, 4.447071694e-02f, 4.472049766e-02f, 4.496855141e-02f, 4.521487172e-02f, 4.545945214e-02f, 4.570228631e-02f, 4.594336792e-02f, 
4.618269075e-02f, 4.642024860e-02f, 4.665603536e-02f, 4.689004499e-02f, 4.712227149e-02f, 4.735270894e-02f, 4.758135149e-02f, 4.780819333e-02f, 4.803322874e-02f, 4.825645205e-02f, 
4.847785765e-02f, 4.869744001e-02f, 4.891519365e-02f, 4.913111317e-02f, 4.934519322e-02f, 4.955742852e-02f, 4.976781386e-02f, 4.997634409e-02f, 5.018301413e-02f, 5.038781895e-02f, 
5.059075361e-02f, 5.079181322e-02f, 5.099099296e-02f, 5.118828807e-02f, 5.138369386e-02f, 5.157720571e-02f, 5.176881907e-02f, 5.195852944e-02f, 5.214633239e-02f, 5.233222357e-02f, 
5.251619869e-02f, 5.269825352e-02f, 5.287838390e-02f, 5.305658573e-02f, 5.323285500e-02f, 5.340718774e-02f, 5.357958007e-02f, 5.375002814e-02f, 5.391852822e-02f, 5.408507660e-02f, 
5.424966966e-02f, 5.441230385e-02f, 5.457297567e-02f, 5.473168170e-02f, 5.488841859e-02f, 5.504318304e-02f, 5.519597184e-02f, 5.534678184e-02f, 5.549560994e-02f, 5.564245313e-02f, 
5.578730846e-02f, 5.593017305e-02f, 5.607104407e-02f, 5.620991878e-02f, 5.634679450e-02f, 5.648166862e-02f, 5.661453860e-02f, 5.674540194e-02f, 5.687425625e-02f, 5.700109919e-02f, 
5.712592847e-02f, 5.724874190e-02f, 5.736953732e-02f, 5.748831268e-02f, 5.760506597e-02f, 5.771979526e-02f, 5.783249867e-02f, 5.794317440e-02f, 5.805182074e-02f, 5.815843600e-02f, 
5.826301859e-02f, 5.836556700e-02f, 5.846607974e-02f, 5.856455544e-02f, 5.866099276e-02f, 5.875539045e-02f, 5.884774732e-02f, 5.893806225e-02f, 5.902633418e-02f, 5.911256212e-02f, 
5.919674515e-02f, 5.927888243e-02f, 5.935897316e-02f, 5.943701664e-02f, 5.951301220e-02f, 5.958695927e-02f, 5.965885734e-02f, 5.972870595e-02f, 5.979650473e-02f, 5.986225336e-02f, 
5.992595160e-02f, 5.998759926e-02f, 6.004719624e-02f, 6.010474249e-02f, 6.016023804e-02f, 6.021368296e-02f, 6.026507743e-02f, 6.031442165e-02f, 6.036171592e-02f, 6.040696059e-02f, 
6.045015610e-02f, 6.049130292e-02f, 6.053040161e-02f, 6.056745279e-02f, 6.060245715e-02f, 6.063541545e-02f, 6.066632850e-02f, 6.069519719e-02f, 6.072202247e-02f, 6.074680535e-02f, 
6.076954694e-02f, 6.079024836e-02f, 6.080891083e-02f, 6.082553564e-02f, 6.084012413e-02f, 6.085267772e-02f, 6.086319786e-02f, 6.087168611e-02f, 6.087814408e-02f, 6.088257342e-02f, 
6.088497588e-02f, 6.088535325e-02f, 6.088370740e-02f, 6.088004026e-02f, 6.087435382e-02f, 6.086665013e-02f, 6.085693131e-02f, 6.084519956e-02f, 6.083145711e-02f, 6.081570628e-02f, 
6.079794944e-02f, 6.077818904e-02f, 6.075642756e-02f, 6.073266758e-02f, 6.070691172e-02f, 6.067916268e-02f, 6.064942320e-02f, 6.061769610e-02f, 6.058398426e-02f, 6.054829062e-02f, 
6.051061817e-02f, 6.047096999e-02f, 6.042934919e-02f, 6.038575896e-02f, 6.034020256e-02f, 6.029268328e-02f, 6.024320451e-02f, 6.019176966e-02f, 6.013838224e-02f, 6.008304579e-02f, 
6.002576393e-02f, 5.996654033e-02f, 5.990537873e-02f, 5.984228291e-02f, 5.977725673e-02f, 5.971030410e-02f, 5.964142900e-02f, 5.957063545e-02f, 5.949792754e-02f, 5.942330942e-02f, 
5.934678531e-02f, 5.926835946e-02f, 5.918803619e-02f, 5.910581990e-02f, 5.902171502e-02f, 5.893572604e-02f, 5.884785753e-02f, 5.875811408e-02f, 5.866650039e-02f, 5.857302116e-02f, 
5.847768118e-02f, 5.838048529e-02f, 5.828143839e-02f, 5.818054542e-02f, 5.807781140e-02f, 5.797324139e-02f, 5.786684050e-02f, 5.775861391e-02f, 5.764856684e-02f, 5.753670458e-02f, 
5.742303247e-02f, 5.730755590e-02f, 5.719028032e-02f, 5.707121122e-02f, 5.695035416e-02f, 5.682771474e-02f, 5.670329862e-02f, 5.657711153e-02f, 5.644915922e-02f, 5.631944751e-02f, 
5.618798227e-02f, 5.605476942e-02f, 5.591981495e-02f, 5.578312487e-02f, 5.564470526e-02f, 5.550456225e-02f, 5.536270202e-02f, 5.521913079e-02f, 5.507385486e-02f, 5.492688054e-02f, 
5.477821422e-02f, 5.462786232e-02f, 5.447583133e-02f, 5.432212777e-02f, 5.416675822e-02f, 5.400972931e-02f, 5.385104770e-02f, 5.369072012e-02f, 5.352875334e-02f, 5.336515417e-02f, 
5.319992948e-02f, 5.303308617e-02f, 5.286463122e-02f, 5.269457161e-02f, 5.252291441e-02f, 5.234966670e-02f, 5.217483562e-02f, 5.199842838e-02f, 5.182045219e-02f, 5.164091434e-02f, 
5.145982214e-02f, 5.127718296e-02f, 5.109300422e-02f, 5.090729336e-02f, 5.072005789e-02f, 5.053130534e-02f, 5.034104329e-02f, 5.014927938e-02f, 4.995602127e-02f, 4.976127666e-02f, 
4.956505332e-02f, 4.936735904e-02f, 4.916820164e-02f, 4.896758901e-02f, 4.876552906e-02f, 4.856202974e-02f, 4.835709906e-02f, 4.815074505e-02f, 4.794297578e-02f, 4.773379937e-02f, 
4.752322397e-02f, 4.731125778e-02f, 4.709790901e-02f, 4.688318595e-02f, 4.666709690e-02f, 4.644965019e-02f, 4.623085422e-02f, 4.601071739e-02f, 4.578924816e-02f, 4.556645501e-02f, 
4.534234648e-02f, 4.511693112e-02f, 4.489021753e-02f, 4.466221434e-02f, 4.443293020e-02f, 4.420237384e-02f, 4.397055396e-02f, 4.373747935e-02f, 4.350315880e-02f, 4.326760115e-02f, 
4.303081525e-02f, 4.279281001e-02f, 4.255359436e-02f, 4.231317727e-02f, 4.207156771e-02f, 4.182877472e-02f, 4.158480735e-02f, 4.133967469e-02f, 4.109338586e-02f, 4.084594999e-02f, 
4.059737626e-02f, 4.034767389e-02f, 4.009685209e-02f, 3.984492013e-02f, 3.959188731e-02f, 3.933776293e-02f, 3.908255634e-02f, 3.882627692e-02f, 3.856893407e-02f, 3.831053720e-02f, 
3.805109578e-02f, 3.779061927e-02f, 3.752911719e-02f, 3.726659906e-02f, 3.700307443e-02f, 3.673855288e-02f, 3.647304402e-02f, 3.620655747e-02f, 3.593910288e-02f, 3.567068991e-02f, 
3.540132828e-02f, 3.513102770e-02f, 3.485979790e-02f, 3.458764865e-02f, 3.431458973e-02f, 3.404063095e-02f, 3.376578214e-02f, 3.349005313e-02f, 3.321345381e-02f, 3.293599405e-02f, 
3.265768376e-02f, 3.237853287e-02f, 3.209855132e-02f, 3.181774907e-02f, 3.153613611e-02f, 3.125372243e-02f, 3.097051805e-02f, 3.068653300e-02f, 3.040177734e-02f, 3.011626113e-02f, 
2.982999445e-02f, 2.954298741e-02f, 2.925525011e-02f, 2.896679268e-02f, 2.867762528e-02f, 2.838775806e-02f, 2.809720119e-02f, 2.780596485e-02f, 2.751405925e-02f, 2.722149461e-02f, 
2.692828114e-02f, 2.663442908e-02f, 2.633994869e-02f, 2.604485022e-02f, 2.574914395e-02f, 2.545284016e-02f, 2.515594915e-02f, 2.485848122e-02f, 2.456044669e-02f, 2.426185588e-02f, 
2.396271913e-02f, 2.366304677e-02f, 2.336284917e-02f, 2.306213667e-02f, 2.276091965e-02f, 2.245920848e-02f, 2.215701355e-02f, 2.185434524e-02f, 2.155121395e-02f, 2.124763008e-02f, 
2.094360403e-02f, 2.063914624e-02f, 2.033426710e-02f, 2.002897704e-02f, 1.972328650e-02f, 1.941720590e-02f, 1.911074568e-02f, 1.880391627e-02f, 1.849672813e-02f, 1.818919169e-02f, 
1.788131741e-02f, 1.757311573e-02f, 1.726459710e-02f, 1.695577198e-02f, 1.664665081e-02f, 1.633724406e-02f, 1.602756218e-02f, 1.571761563e-02f, 1.540741485e-02f, 1.509697030e-02f, 
1.478629244e-02f, 1.447539171e-02f, 1.416427857e-02f, 1.385296347e-02f, 1.354145684e-02f, 1.322976914e-02f, 1.291791080e-02f, 1.260589225e-02f, 1.229372394e-02f, 1.198141629e-02f, 
1.166897972e-02f, 1.135642466e-02f, 1.104376152e-02f, 1.073100070e-02f, 1.041815262e-02f, 1.010522766e-02f, 9.792236231e-03f, 9.479188703e-03f, 9.166095458e-03f, 8.852966865e-03f, 
8.539813288e-03f, 8.226645081e-03f, 7.913472589e-03f, 7.600306151e-03f, 7.287156094e-03f, 6.974032737e-03f, 6.660946391e-03f, 6.347907354e-03f, 6.034925915e-03f, 5.722012353e-03f, 
5.409176935e-03f, 5.096429917e-03f, 4.783781544e-03f, 4.471242049e-03f, 4.158821651e-03f, 3.846530558e-03f, 3.534378966e-03f, 3.222377055e-03f, 2.910534994e-03f, 2.598862937e-03f, 
2.287371023e-03f, 1.976069379e-03f, 1.664968114e-03f, 1.354077325e-03f, 1.043407090e-03f, 7.329674754e-04f, 4.227685280e-04f, 1.128202799e-04f, -1.968672540e-04f, -5.062840756e-04f, 
-8.154202043e-04f, -1.124265677e-03f, -1.432810549e-03f, -1.741044893e-03f, -2.048958802e-03f, -2.356542385e-03f, -2.663785773e-03f, -2.970679115e-03f, -3.277212580e-03f, -3.583376358e-03f, 
-3.889160658e-03f, -4.194555711e-03f, -4.499551768e-03f, -4.804139101e-03f, -5.108308005e-03f, -5.412048796e-03f, -5.715351814e-03f, -6.018207417e-03f, -6.320605991e-03f, -6.622537941e-03f, 
-6.923993699e-03f, -7.224963718e-03f, -7.525438476e-03f, -7.825408474e-03f, -8.124864240e-03f, -8.423796324e-03f, -8.722195304e-03f, -9.020051782e-03f, -9.317356384e-03f, -9.614099765e-03f, 
-9.910272604e-03f, -1.020586561e-02f, -1.050086951e-02f, -1.079527507e-02f, -1.108907308e-02f, -1.138225434e-02f, -1.167480971e-02f, -1.196673006e-02f, -1.225800629e-02f, -1.254862931e-02f, 
-1.283859011e-02f, -1.312787965e-02f, -1.341648895e-02f, -1.370440907e-02f, -1.399163108e-02f, -1.427814608e-02f, -1.456394522e-02f, -1.484901965e-02f, -1.513336059e-02f, -1.541695926e-02f, 
-1.569980693e-02f, -1.598189488e-02f, -1.626321446e-02f, -1.654375700e-02f, -1.682351391e-02f, -1.710247662e-02f, -1.738063657e-02f, -1.765798527e-02f, -1.793451423e-02f, -1.821021502e-02f, 
-1.848507923e-02f, -1.875909848e-02f, -1.903226445e-02f, -1.930456882e-02f, -1.957600333e-02f, -1.984655975e-02f, -2.011622988e-02f, -2.038500556e-02f, -2.065287866e-02f, -2.091984111e-02f, 
-2.118588484e-02f, -2.145100185e-02f, -2.171518415e-02f, -2.197842381e-02f, -2.224071292e-02f, -2.250204362e-02f, -2.276240808e-02f, -2.302179851e-02f, -2.328020716e-02f, -2.353762633e-02f, 
-2.379404833e-02f, -2.404946554e-02f, -2.430387035e-02f, -2.455725522e-02f, -2.480961263e-02f, -2.506093511e-02f, -2.531121521e-02f, -2.556044555e-02f, -2.580861877e-02f, -2.605572756e-02f, 
-2.630176465e-02f, -2.654672279e-02f, -2.679059481e-02f, -2.703337356e-02f, -2.727505192e-02f, -2.751562284e-02f, -2.775507930e-02f, -2.799341430e-02f, -2.823062092e-02f, -2.846669226e-02f, 
-2.870162147e-02f, -2.893540174e-02f, -2.916802631e-02f, -2.939948845e-02f, -2.962978148e-02f, -2.985889878e-02f, -3.008683374e-02f, -3.031357983e-02f, -3.053913055e-02f, -3.076347943e-02f, 
-3.098662007e-02f, -3.120854610e-02f, -3.142925119e-02f, -3.164872907e-02f, -3.186697351e-02f, -3.208397833e-02f, -3.229973737e-02f, -3.251424455e-02f, -3.272749382e-02f, -3.293947918e-02f, 
-3.315019467e-02f, -3.335963439e-02f, -3.356779247e-02f, -3.377466310e-02f, -3.398024051e-02f, -3.418451897e-02f, -3.438749282e-02f, -3.458915643e-02f, -3.478950422e-02f, -3.498853066e-02f, 
-3.518623027e-02f, -3.538259760e-02f, -3.557762729e-02f, -3.577131398e-02f, -3.596365239e-02f, -3.615463728e-02f, -3.634426345e-02f, -3.653252576e-02f, -3.671941911e-02f, -3.690493847e-02f, 
-3.708907883e-02f, -3.727183525e-02f, -3.745320283e-02f, -3.763317672e-02f, -3.781175212e-02f, -3.798892429e-02f, -3.816468852e-02f, -3.833904018e-02f, -3.851197465e-02f, -3.868348740e-02f, 
-3.885357392e-02f, -3.902222977e-02f, -3.918945055e-02f, -3.935523192e-02f, -3.951956958e-02f, -3.968245929e-02f, -3.984389685e-02f, -4.000387812e-02f, -4.016239902e-02f, -4.031945550e-02f, 
-4.047504357e-02f, -4.062915930e-02f, -4.078179880e-02f, -4.093295825e-02f, -4.108263385e-02f, -4.123082187e-02f, -4.137751865e-02f, -4.152272055e-02f, -4.166642400e-02f, -4.180862548e-02f, 
-4.194932152e-02f, -4.208850869e-02f, -4.222618364e-02f, -4.236234306e-02f, -4.249698367e-02f, -4.263010229e-02f, -4.276169574e-02f, -4.289176092e-02f, -4.302029480e-02f, -4.314729436e-02f, 
-4.327275667e-02f, -4.339667883e-02f, -4.351905801e-02f, -4.363989142e-02f, -4.375917633e-02f, -4.387691005e-02f, -4.399308997e-02f, -4.410771350e-02f, -4.422077814e-02f, -4.433228140e-02f, 
-4.444222089e-02f, -4.455059423e-02f, -4.465739912e-02f, -4.476263331e-02f, -4.486629461e-02f, -4.496838085e-02f, -4.506888995e-02f, -4.516781987e-02f, -4.526516862e-02f, -4.536093427e-02f, 
-4.545511495e-02f, -4.554770882e-02f, -4.563871411e-02f, -4.572812911e-02f, -4.581595216e-02f, -4.590218163e-02f, -4.598681597e-02f, -4.606985369e-02f, -4.615129332e-02f, -4.623113348e-02f, 
-4.630937282e-02f, -4.638601005e-02f, -4.646104394e-02f, -4.653447330e-02f, -4.660629701e-02f, -4.667651399e-02f, -4.674512322e-02f, -4.681212373e-02f, -4.687751462e-02f, -4.694129502e-02f, 
-4.700346412e-02f, -4.706402118e-02f, -4.712296549e-02f, -4.718029641e-02f, -4.723601334e-02f, -4.729011575e-02f, -4.734260316e-02f, -4.739347512e-02f, -4.744273127e-02f, -4.749037127e-02f, 
-4.753639487e-02f, -4.758080183e-02f, -4.762359199e-02f, -4.766476525e-02f, -4.770432154e-02f, -4.774226087e-02f, -4.777858326e-02f, -4.781328884e-02f, -4.784637775e-02f, -4.787785020e-02f, 
-4.790770645e-02f, -4.793594681e-02f, -4.796257165e-02f, -4.798758139e-02f, -4.801097649e-02f, -4.803275749e-02f, -4.805292496e-02f, -4.807147953e-02f, -4.808842188e-02f, -4.810375274e-02f, 
-4.811747291e-02f, -4.812958321e-02f, -4.814008455e-02f, -4.814897786e-02f, -4.815626414e-02f, -4.816194444e-02f, -4.816601986e-02f, -4.816849155e-02f, -4.816936070e-02f, -4.816862858e-02f, 
-4.816629650e-02f, -4.816236580e-02f, -4.815683791e-02f, -4.814971427e-02f, -4.814099641e-02f, -4.813068588e-02f, -4.811878431e-02f, -4.810529335e-02f, -4.809021472e-02f, -4.807355019e-02f, 
-4.805530157e-02f, -4.803547074e-02f, -4.801405962e-02f, -4.799107016e-02f, -4.796650440e-02f, -4.794036441e-02f, -4.791265229e-02f, -4.788337023e-02f, -4.785252045e-02f, -4.782010520e-02f, 
-4.778612682e-02f, -4.775058766e-02f, -4.771349016e-02f, -4.767483677e-02f, -4.763463002e-02f, -4.759287246e-02f, -4.754956672e-02f, -4.750471546e-02f, -4.745832139e-02f, -4.741038727e-02f, 
-4.736091591e-02f, -4.730991016e-02f, -4.725737294e-02f, -4.720330720e-02f, -4.714771594e-02f, -4.709060221e-02f, -4.703196910e-02f, -4.697181977e-02f, -4.691015740e-02f, -4.684698523e-02f, 
-4.678230656e-02f, -4.671612470e-02f, -4.664844305e-02f, -4.657926503e-02f, -4.650859411e-02f, -4.643643382e-02f, -4.636278771e-02f, -4.628765941e-02f, -4.621105256e-02f, -4.613297088e-02f, 
-4.605341810e-02f, -4.597239804e-02f, -4.588991451e-02f, -4.580597142e-02f, -4.572057269e-02f, -4.563372230e-02f, -4.554542426e-02f, -4.545568263e-02f, -4.536450154e-02f, -4.527188512e-02f, 
-4.517783757e-02f, -4.508236314e-02f, -4.498546611e-02f, -4.488715079e-02f, -4.478742158e-02f, -4.468628287e-02f, -4.458373912e-02f, -4.447979483e-02f, -4.437445455e-02f, -4.426772286e-02f, 
-4.415960437e-02f, -4.405010377e-02f, -4.393922575e-02f, -4.382697508e-02f, -4.371335653e-02f, -4.359837496e-02f, -4.348203522e-02f, -4.336434225e-02f, -4.324530098e-02f, -4.312491643e-02f, 
-4.300319362e-02f, -4.288013764e-02f, -4.275575360e-02f, -4.263004666e-02f, -4.250302201e-02f, -4.237468489e-02f, -4.224504057e-02f, -4.211409438e-02f, -4.198185165e-02f, -4.184831778e-02f, 
-4.171349820e-02f, -4.157739838e-02f, -4.144002382e-02f, -4.130138006e-02f, -4.116147268e-02f, -4.102030730e-02f, -4.087788958e-02f, -4.073422520e-02f, -4.058931989e-02f, -4.044317941e-02f, 
-4.029580957e-02f, -4.014721620e-02f, -3.999740518e-02f, -3.984638240e-02f, -3.969415381e-02f, -3.954072540e-02f, -3.938610316e-02f, -3.923029315e-02f, -3.907330145e-02f, -3.891513417e-02f, 
-3.875579746e-02f, -3.859529751e-02f, -3.843364053e-02f, -3.827083277e-02f, -3.810688051e-02f, -3.794179007e-02f, -3.777556780e-02f, -3.760822008e-02f, -3.743975331e-02f, -3.727017394e-02f, 
-3.709948846e-02f, -3.692770336e-02f, -3.675482518e-02f, -3.658086049e-02f, -3.640581590e-02f, -3.622969802e-02f, -3.605251353e-02f, -3.587426912e-02f, -3.569497149e-02f, -3.551462740e-02f, 
-3.533324364e-02f, -3.515082700e-02f, -3.496738433e-02f, -3.478292248e-02f, -3.459744836e-02f, -3.441096887e-02f, -3.422349098e-02f, -3.403502166e-02f, -3.384556790e-02f, -3.365513675e-02f, 
-3.346373525e-02f, -3.327137049e-02f, -3.307804959e-02f, -3.288377966e-02f, -3.268856789e-02f, -3.249242145e-02f, -3.229534756e-02f, -3.209735345e-02f, -3.189844639e-02f, -3.169863365e-02f, 
-3.149792256e-02f, -3.129632045e-02f, -3.109383467e-02f, -3.089047260e-02f, -3.068624166e-02f, -3.048114926e-02f, -3.027520286e-02f, -3.006840992e-02f, -2.986077795e-02f, -2.965231447e-02f, 
-2.944302700e-02f, -2.923292310e-02f, -2.902201037e-02f, -2.881029639e-02f, -2.859778880e-02f, -2.838449522e-02f, -2.817042334e-02f, -2.795558081e-02f, -2.773997535e-02f, -2.752361468e-02f, 
-2.730650654e-02f, -2.708865868e-02f, -2.687007888e-02f, -2.665077493e-02f, -2.643075466e-02f, -2.621002587e-02f, -2.598859643e-02f, -2.576647420e-02f, -2.554366706e-02f, -2.532018290e-02f, 
-2.509602964e-02f, -2.487121521e-02f, -2.464574755e-02f, -2.441963463e-02f, -2.419288442e-02f, -2.396550491e-02f, -2.373750411e-02f, -2.350889003e-02f, -2.327967071e-02f, -2.304985420e-02f, 
-2.281944856e-02f, -2.258846185e-02f, -2.235690218e-02f, -2.212477764e-02f, -2.189209634e-02f, -2.165886640e-02f, -2.142509597e-02f, -2.119079318e-02f, -2.095596620e-02f, -2.072062320e-02f, 
-2.048477236e-02f, -2.024842187e-02f, -2.001157993e-02f, -1.977425476e-02f, -1.953645457e-02f, -1.929818759e-02f, -1.905946207e-02f, -1.882028624e-02f, -1.858066838e-02f, -1.834061674e-02f, 
-1.810013960e-02f, -1.785924524e-02f, -1.761794194e-02f, -1.737623801e-02f, -1.713414173e-02f, -1.689166143e-02f, -1.664880542e-02f, -1.640558202e-02f, -1.616199955e-02f, -1.591806635e-02f, 
-1.567379075e-02f, -1.542918110e-02f, -1.518424575e-02f, -1.493899305e-02f, -1.469343134e-02f, -1.444756900e-02f, -1.420141438e-02f, -1.395497586e-02f, -1.370826179e-02f, -1.346128056e-02f, 
-1.321404053e-02f, -1.296655009e-02f, -1.271881761e-02f, -1.247085147e-02f, -1.222266006e-02f, -1.197425175e-02f, -1.172563493e-02f, -1.147681798e-02f, -1.122780929e-02f, -1.097861724e-02f, 
-1.072925022e-02f, -1.047971660e-02f, -1.023002478e-02f, -9.980183123e-03f, -9.730200019e-03f, -9.480083843e-03f, -9.229842972e-03f, -8.979485779e-03f, -8.729020636e-03f, -8.478455911e-03f, 
-8.227799970e-03f, -7.977061174e-03f, -7.726247882e-03f, -7.475368449e-03f, -7.224431225e-03f, -6.973444556e-03f, -6.722416784e-03f, -6.471356245e-03f, -6.220271271e-03f, -5.969170187e-03f, 
-5.718061312e-03f, -5.466952962e-03f, -5.215853444e-03f, -4.964771058e-03f, -4.713714100e-03f, -4.462690855e-03f, -4.211709605e-03f, -3.960778621e-03f, -3.709906168e-03f, -3.459100501e-03f, 
-3.208369869e-03f, -2.957722510e-03f, -2.707166655e-03f, -2.456710524e-03f, -2.206362329e-03f, -1.956130271e-03f, -1.706022542e-03f, -1.456047324e-03f, -1.206212786e-03f, -9.565270905e-04f, 
-7.069983848e-04f, -4.576348070e-04f, -2.084444835e-04f, 4.056447158e-05f, 2.893839559e-04f, 5.380058795e-04f, 7.864221651e-04f, 1.034624748e-03f, 1.282605577e-03f, 1.530356615e-03f, 
1.777869835e-03f, 2.025137229e-03f, 2.272150800e-03f, 2.518902565e-03f, 2.765384557e-03f, 3.011588823e-03f, 3.257507427e-03f, 3.503132445e-03f, 3.748455971e-03f, 3.993470115e-03f, 
4.238167003e-03f, 4.482538775e-03f, 4.726577590e-03f, 4.970275624e-03f, 5.213625069e-03f, 5.456618135e-03f, 5.699247048e-03f, 5.941504055e-03f, 6.183381418e-03f, 6.424871418e-03f, 
6.665966356e-03f, 6.906658550e-03f, 7.146940338e-03f, 7.386804077e-03f, 7.626242144e-03f, 7.865246935e-03f, 8.103810865e-03f, 8.341926373e-03f, 8.579585913e-03f, 8.816781965e-03f, 
9.053507026e-03f, 9.289753615e-03f, 9.525514274e-03f, 9.760781565e-03f, 9.995548072e-03f, 1.022980640e-02f, 1.046354918e-02f, 1.069676907e-02f, 1.092945873e-02f, 1.116161086e-02f, 
1.139321818e-02f, 1.162427344e-02f, 1.185476940e-02f, 1.208469886e-02f, 1.231405462e-02f, 1.254282953e-02f, 1.277101645e-02f, 1.299860827e-02f, 1.322559790e-02f, 1.345197828e-02f, 
1.367774238e-02f, 1.390288317e-02f, 1.412739368e-02f, 1.435126695e-02f, 1.457449605e-02f, 1.479707406e-02f, 1.501899411e-02f, 1.524024935e-02f, 1.546083294e-02f, 1.568073810e-02f, 
1.589995804e-02f, 1.611848602e-02f, 1.633631533e-02f, 1.655343929e-02f, 1.676985122e-02f, 1.698554449e-02f, 1.720051252e-02f, 1.741474871e-02f, 1.762824653e-02f, 1.784099946e-02f, 
1.805300101e-02f, 1.826424473e-02f, 1.847472419e-02f, 1.868443298e-02f, 1.889336476e-02f, 1.910151317e-02f, 1.930887191e-02f, 1.951543470e-02f, 1.972119531e-02f, 1.992614752e-02f, 
2.013028514e-02f, 2.033360202e-02f, 2.053609205e-02f, 2.073774913e-02f, 2.093856722e-02f, 2.113854028e-02f, 2.133766234e-02f, 2.153592742e-02f, 2.173332960e-02f, 2.192986299e-02f, 
2.212552173e-02f, 2.232029999e-02f, 2.251419198e-02f, 2.270719194e-02f, 2.289929414e-02f, 2.309049288e-02f, 2.328078252e-02f, 2.347015742e-02f, 2.365861200e-02f, 2.384614070e-02f, 
2.403273799e-02f, 2.421839840e-02f, 2.440311647e-02f, 2.458688678e-02f, 2.476970395e-02f, 2.495156264e-02f, 2.513245754e-02f, 2.531238337e-02f, 2.549133490e-02f, 2.566930691e-02f, 
2.584629425e-02f, 2.602229178e-02f, 2.619729442e-02f, 2.637129709e-02f, 2.654429479e-02f, 2.671628253e-02f, 2.688725536e-02f, 2.705720837e-02f, 2.722613669e-02f, 2.739403548e-02f, 
2.756089995e-02f, 2.772672534e-02f, 2.789150692e-02f, 2.805524001e-02f, 2.821791997e-02f, 2.837954218e-02f, 2.854010208e-02f, 2.869959513e-02f, 2.885801684e-02f, 2.901536276e-02f, 
2.917162847e-02f, 2.932680959e-02f, 2.948090179e-02f, 2.963390077e-02f, 2.978580226e-02f, 2.993660205e-02f, 3.008629596e-02f, 3.023487985e-02f, 3.038234960e-02f, 3.052870118e-02f, 
3.067393054e-02f, 3.081803371e-02f, 3.096100674e-02f, 3.110284574e-02f, 3.124354684e-02f, 3.138310622e-02f, 3.152152011e-02f, 3.165878475e-02f, 3.179489645e-02f, 3.192985156e-02f, 
3.206364645e-02f, 3.219627754e-02f, 3.232774131e-02f, 3.245803425e-02f, 3.258715291e-02f, 3.271509388e-02f, 3.284185378e-02f, 3.296742930e-02f, 3.309181713e-02f, 3.321501403e-02f, 
3.333701681e-02f, 3.345782228e-02f, 3.357742734e-02f, 3.369582889e-02f, 3.381302391e-02f, 3.392900940e-02f, 3.404378241e-02f, 3.415734001e-02f, 3.426967935e-02f, 3.438079760e-02f, 
3.449069196e-02f, 3.459935971e-02f, 3.470679813e-02f, 3.481300458e-02f, 3.491797643e-02f, 3.502171111e-02f, 3.512420611e-02f, 3.522545891e-02f, 3.532546709e-02f, 3.542422825e-02f, 
3.552174002e-02f, 3.561800008e-02f, 3.571300618e-02f, 3.580675607e-02f, 3.589924757e-02f, 3.599047854e-02f, 3.608044687e-02f, 3.616915052e-02f, 3.625658746e-02f, 3.634275573e-02f, 
3.642765339e-02f, 3.651127858e-02f, 3.659362943e-02f, 3.667470416e-02f, 3.675450102e-02f, 3.683301829e-02f, 3.691025431e-02f, 3.698620744e-02f, 3.706087613e-02f, 3.713425881e-02f, 
3.720635401e-02f, 3.727716028e-02f, 3.734667620e-02f, 3.741490042e-02f, 3.748183162e-02f, 3.754746852e-02f, 3.761180989e-02f, 3.767485455e-02f, 3.773660135e-02f, 3.779704918e-02f, 
3.785619700e-02f, 3.791404379e-02f, 3.797058858e-02f, 3.802583044e-02f, 3.807976850e-02f, 3.813240191e-02f, 3.818372988e-02f, 3.823375165e-02f, 3.828246653e-02f, 3.832987384e-02f, 
3.837597297e-02f, 3.842076334e-02f, 3.846424442e-02f, 3.850641571e-02f, 3.854727677e-02f, 3.858682721e-02f, 3.862506665e-02f, 3.866199479e-02f, 3.869761135e-02f, 3.873191610e-02f, 
3.876490886e-02f, 3.879658950e-02f, 3.882695790e-02f, 3.885601401e-02f, 3.888375784e-02f, 3.891018939e-02f, 3.893530876e-02f, 3.895911606e-02f, 3.898161144e-02f, 3.900279513e-02f, 
3.902266736e-02f, 3.904122842e-02f, 3.905847865e-02f, 3.907441843e-02f, 3.908904817e-02f, 3.910236835e-02f, 3.911437946e-02f, 3.912508205e-02f, 3.913447672e-02f, 3.914256409e-02f, 
3.914934486e-02f, 3.915481973e-02f, 3.915898947e-02f, 3.916185488e-02f, 3.916341681e-02f, 3.916367615e-02f, 3.916263384e-02f, 3.916029084e-02f, 3.915664817e-02f, 3.915170689e-02f, 
3.914546810e-02f, 3.913793295e-02f, 3.912910261e-02f, 3.911897832e-02f, 3.910756135e-02f, 3.909485299e-02f, 3.908085462e-02f, 3.906556761e-02f, 3.904899340e-02f, 3.903113348e-02f, 
3.901198935e-02f, 3.899156258e-02f, 3.896985476e-02f, 3.894686754e-02f, 3.892260261e-02f, 3.889706167e-02f, 3.887024651e-02f, 3.884215892e-02f, 3.881280074e-02f, 3.878217388e-02f, 
3.875028024e-02f, 3.871712181e-02f, 3.868270058e-02f, 3.864701860e-02f, 3.861007797e-02f, 3.857188081e-02f, 3.853242929e-02f, 3.849172561e-02f, 3.844977203e-02f, 3.840657083e-02f, 
3.836212434e-02f, 3.831643493e-02f, 3.826950499e-02f, 3.822133698e-02f, 3.817193338e-02f, 3.812129671e-02f, 3.806942953e-02f, 3.801633445e-02f, 3.796201410e-02f, 3.790647117e-02f, 
3.784970836e-02f, 3.779172843e-02f, 3.773253418e-02f, 3.767212843e-02f, 3.761051406e-02f, 3.754769397e-02f, 3.748367111e-02f, 3.741844845e-02f, 3.735202902e-02f, 3.728441588e-02f, 
3.721561211e-02f, 3.714562086e-02f, 3.707444528e-02f, 3.700208859e-02f, 3.692855402e-02f, 3.685384485e-02f, 3.677796440e-02f, 3.670091602e-02f, 3.662270309e-02f, 3.654332904e-02f, 
3.646279733e-02f, 3.638111146e-02f, 3.629827494e-02f, 3.621429136e-02f, 3.612916431e-02f, 3.604289742e-02f, 3.595549437e-02f, 3.586695887e-02f, 3.577729465e-02f, 3.568650550e-02f, 
3.559459521e-02f, 3.550156765e-02f, 3.540742668e-02f, 3.531217621e-02f, 3.521582020e-02f, 3.511836263e-02f, 3.501980750e-02f, 3.492015887e-02f, 3.481942082e-02f, 3.471759745e-02f, 
3.461469292e-02f, 3.451071140e-02f, 3.440565711e-02f, 3.429953430e-02f, 3.419234722e-02f, 3.408410021e-02f, 3.397479758e-02f, 3.386444373e-02f, 3.375304305e-02f, 3.364059997e-02f, 
3.352711897e-02f, 3.341260454e-02f, 3.329706121e-02f, 3.318049354e-02f, 3.306290612e-02f, 3.294430356e-02f, 3.282469053e-02f, 3.270407170e-02f, 3.258245177e-02f, 3.245983550e-02f, 
3.233622765e-02f, 3.221163302e-02f, 3.208605644e-02f, 3.195950276e-02f, 3.183197688e-02f, 3.170348370e-02f, 3.157402817e-02f, 3.144361527e-02f, 3.131224998e-02f, 3.117993735e-02f, 
3.104668241e-02f, 3.091249027e-02f, 3.077736602e-02f, 3.064131481e-02f, 3.050434180e-02f, 3.036645217e-02f, 3.022765116e-02f, 3.008794400e-02f, 2.994733596e-02f, 2.980583233e-02f, 
2.966343845e-02f, 2.952015966e-02f, 2.937600133e-02f, 2.923096887e-02f, 2.908506768e-02f, 2.893830323e-02f, 2.879068099e-02f, 2.864220645e-02f, 2.849288513e-02f, 2.834272259e-02f, 
2.819172439e-02f, 2.803989612e-02f, 2.788724341e-02f, 2.773377189e-02f, 2.757948722e-02f, 2.742439510e-02f, 2.726850123e-02f, 2.711181134e-02f, 2.695433118e-02f, 2.679606654e-02f, 
2.663702321e-02f, 2.647720700e-02f, 2.631662376e-02f, 2.615527936e-02f, 2.599317966e-02f, 2.583033058e-02f, 2.566673805e-02f, 2.550240800e-02f, 2.533734640e-02f, 2.517155923e-02f, 
2.500505250e-02f, 2.483783224e-02f, 2.466990448e-02f, 2.450127529e-02f, 2.433195075e-02f, 2.416193697e-02f, 2.399124005e-02f, 2.381986614e-02f, 2.364782139e-02f, 2.347511197e-02f, 
2.330174407e-02f, 2.312772391e-02f, 2.295305771e-02f, 2.277775170e-02f, 2.260181215e-02f, 2.242524533e-02f, 2.224805754e-02f, 2.207025508e-02f, 2.189184427e-02f, 2.171283145e-02f, 
2.153322299e-02f, 2.135302524e-02f, 2.117224460e-02f, 2.099088746e-02f, 2.080896024e-02f, 2.062646936e-02f, 2.044342127e-02f, 2.025982242e-02f, 2.007567929e-02f, 1.989099836e-02f, 
1.970578612e-02f, 1.952004909e-02f, 1.933379379e-02f, 1.914702675e-02f, 1.895975452e-02f, 1.877198366e-02f, 1.858372074e-02f, 1.839497234e-02f, 1.820574507e-02f, 1.801604552e-02f, 
1.782588031e-02f, 1.763525608e-02f, 1.744417945e-02f, 1.725265708e-02f, 1.706069562e-02f, 1.686830174e-02f, 1.667548213e-02f, 1.648224346e-02f, 1.628859244e-02f, 1.609453577e-02f, 
1.590008016e-02f, 1.570523234e-02f, 1.550999904e-02f, 1.531438700e-02f, 1.511840296e-02f, 1.492205368e-02f, 1.472534592e-02f, 1.452828645e-02f, 1.433088204e-02f, 1.413313948e-02f, 
1.393506556e-02f, 1.373666707e-02f, 1.353795081e-02f, 1.333892359e-02f, 1.313959223e-02f, 1.293996353e-02f, 1.274004433e-02f, 1.253984144e-02f, 1.233936171e-02f, 1.213861197e-02f, 
1.193759905e-02f, 1.173632981e-02f, 1.153481110e-02f, 1.133304976e-02f, 1.113105264e-02f, 1.092882662e-02f, 1.072637855e-02f, 1.052371529e-02f, 1.032084371e-02f, 1.011777067e-02f, 
9.914503051e-03f, 9.711047720e-03f, 9.507411550e-03f, 9.303601415e-03f, 9.099624191e-03f, 8.895486752e-03f, 8.691195977e-03f, 8.486758741e-03f, 8.282181920e-03f, 8.077472393e-03f, 
7.872637034e-03f, 7.667682720e-03f, 7.462616325e-03f, 7.257444722e-03f, 7.052174785e-03f, 6.846813384e-03f, 6.641367389e-03f, 6.435843665e-03f, 6.230249080e-03f, 6.024590494e-03f, 
5.818874767e-03f, 5.613108758e-03f, 5.407299319e-03f, 5.201453302e-03f, 4.995577553e-03f, 4.789678916e-03f, 4.583764231e-03f, 4.377840331e-03f, 4.171914049e-03f, 3.965992209e-03f, 
3.760081634e-03f, 3.554189140e-03f, 3.348321536e-03f, 3.142485629e-03f, 2.936688217e-03f, 2.730936095e-03f, 2.525236050e-03f, 2.319594862e-03f, 2.114019306e-03f, 1.908516149e-03f, 
1.703092152e-03f, 1.497754067e-03f, 1.292508641e-03f, 1.087362610e-03f, 8.823227052e-04f, 6.773956480e-04f, 4.725881516e-04f, 2.679069209e-04f, 6.335865173e-05f, -1.410499689e-04f, 
-3.453122634e-04f, -5.494215634e-04f, -7.533712103e-04f, -9.571545555e-04f, -1.160764960e-03f, -1.364195796e-03f, -1.567440446e-03f, -1.770492302e-03f, -1.973344768e-03f, -2.175991259e-03f, 
-2.378425202e-03f, -2.580640033e-03f, -2.782629204e-03f, -2.984386175e-03f, -3.185904421e-03f, -3.387177427e-03f, -3.588198693e-03f, -3.788961729e-03f, -3.989460060e-03f, -4.189687225e-03f, 
-4.389636774e-03f, -4.589302273e-03f, -4.788677299e-03f, -4.987755446e-03f, -5.186530320e-03f, -5.384995542e-03f, -5.583144750e-03f, -5.780971592e-03f, -5.978469736e-03f, -6.175632862e-03f, 
-6.372454666e-03f, -6.568928861e-03f, -6.765049174e-03f, -6.960809350e-03f, -7.156203148e-03f, -7.351224345e-03f, -7.545866733e-03f, -7.740124124e-03f, -7.933990342e-03f, -8.127459234e-03f, 
-8.320524659e-03f, -8.513180497e-03f, -8.705420644e-03f, -8.897239016e-03f, -9.088629544e-03f, -9.279586179e-03f, -9.470102892e-03f, -9.660173671e-03f, -9.849792522e-03f, -1.003895347e-02f, 
-1.022765056e-02f, -1.041587787e-02f, -1.060362946e-02f, -1.079089945e-02f, -1.097768197e-02f, -1.116397115e-02f, -1.134976116e-02f, -1.153504618e-02f, -1.171982043e-02f, -1.190407812e-02f, 
-1.208781351e-02f, -1.227102086e-02f, -1.245369447e-02f, -1.263582864e-02f, -1.281741771e-02f, -1.299845604e-02f, -1.317893800e-02f, -1.335885799e-02f, -1.353821044e-02f, -1.371698978e-02f, 
-1.389519049e-02f, -1.407280706e-02f, -1.424983400e-02f, -1.442626585e-02f, -1.460209716e-02f, -1.477732253e-02f, -1.495193655e-02f, -1.512593386e-02f, -1.529930912e-02f, -1.547205700e-02f, 
-1.564417221e-02f, -1.581564948e-02f, -1.598648356e-02f, -1.615666923e-02f, -1.632620129e-02f, -1.649507456e-02f, -1.666328392e-02f, -1.683082422e-02f, -1.699769038e-02f, -1.716387733e-02f, 
-1.732938002e-02f, -1.749419344e-02f, -1.765831259e-02f, -1.782173252e-02f, -1.798444827e-02f, -1.814645495e-02f, -1.830774765e-02f, -1.846832154e-02f, -1.862817176e-02f, -1.878729353e-02f, 
-1.894568207e-02f, -1.910333262e-02f, -1.926024046e-02f, -1.941640090e-02f, -1.957180928e-02f, -1.972646096e-02f, -1.988035132e-02f, -2.003347579e-02f, -2.018582982e-02f, -2.033740887e-02f, 
-2.048820846e-02f, -2.063822412e-02f, -2.078745140e-02f, -2.093588591e-02f, -2.108352326e-02f, -2.123035911e-02f, -2.137638912e-02f, -2.152160902e-02f, -2.166601454e-02f, -2.180960144e-02f, 
-2.195236554e-02f, -2.209430264e-02f, -2.223540863e-02f, -2.237567937e-02f, -2.251511080e-02f, -2.265369886e-02f, -2.279143954e-02f, -2.292832884e-02f, -2.306436281e-02f, -2.319953752e-02f, 
-2.333384907e-02f, -2.346729361e-02f, -2.359986729e-02f, -2.373156632e-02f, -2.386238692e-02f, -2.399232536e-02f, -2.412137793e-02f, -2.424954096e-02f, -2.437681079e-02f, -2.450318383e-02f, 
-2.462865649e-02f, -2.475322522e-02f, -2.487688652e-02f, -2.499963689e-02f, -2.512147289e-02f, -2.524239109e-02f, -2.536238813e-02f, -2.548146064e-02f, -2.559960530e-02f, -2.571681884e-02f, 
-2.583309799e-02f, -2.594843954e-02f, -2.606284030e-02f, -2.617629711e-02f, -2.628880687e-02f, -2.640036647e-02f, -2.651097287e-02f, -2.662062305e-02f, -2.672931402e-02f, -2.683704283e-02f, 
-2.694380656e-02f, -2.704960233e-02f, -2.715442729e-02f, -2.725827862e-02f, -2.736115354e-02f, -2.746304929e-02f, -2.756396318e-02f, -2.766389251e-02f, -2.776283464e-02f, -2.786078696e-02f, 
-2.795774690e-02f, -2.805371192e-02f, -2.814867950e-02f, -2.824264717e-02f, -2.833561250e-02f, -2.842757308e-02f, -2.851852655e-02f, -2.860847058e-02f, -2.869740286e-02f, -2.878532112e-02f, 
-2.887222316e-02f, -2.895810676e-02f, -2.904296978e-02f, -2.912681009e-02f, -2.920962560e-02f, -2.929141426e-02f, -2.937217406e-02f, -2.945190302e-02f, -2.953059918e-02f, -2.960826063e-02f, 
-2.968488552e-02f, -2.976047198e-02f, -2.983501823e-02f, -2.990852249e-02f, -2.998098302e-02f, -3.005239815e-02f, -3.012276619e-02f, -3.019208553e-02f, -3.026035458e-02f, -3.032757178e-02f, 
-3.039373562e-02f, -3.045884462e-02f, -3.052289732e-02f, -3.058589232e-02f, -3.064782824e-02f, -3.070870376e-02f, -3.076851755e-02f, -3.082726836e-02f, -3.088495497e-02f, -3.094157616e-02f, 
-3.099713079e-02f, -3.105161773e-02f, -3.110503590e-02f, -3.115738425e-02f, -3.120866176e-02f, -3.125886746e-02f, -3.130800040e-02f, -3.135605968e-02f, -3.140304443e-02f, -3.144895381e-02f, 
-3.149378704e-02f, -3.153754334e-02f, -3.158022199e-02f, -3.162182231e-02f, -3.166234365e-02f, -3.170178538e-02f, -3.174014692e-02f, -3.177742773e-02f, -3.181362731e-02f, -3.184874518e-02f, 
-3.188278091e-02f, -3.191573409e-02f, -3.194760436e-02f, -3.197839140e-02f, -3.200809491e-02f, -3.203671463e-02f, -3.206425036e-02f, -3.209070190e-02f, -3.211606911e-02f, -3.214035187e-02f, 
-3.216355011e-02f, -3.218566379e-02f, -3.220669291e-02f, -3.222663750e-02f, -3.224549762e-02f, -3.226327339e-02f, -3.227996493e-02f, -3.229557243e-02f, -3.231009610e-02f, -3.232353618e-02f, 
-3.233589296e-02f, -3.234716675e-02f, -3.235735791e-02f, -3.236646683e-02f, -3.237449393e-02f, -3.238143968e-02f, -3.238730456e-02f, -3.239208912e-02f, -3.239579391e-02f, -3.239841954e-02f, 
-3.239996665e-02f, -3.240043591e-02f, -3.239982802e-02f, -3.239814374e-02f, -3.239538383e-02f, -3.239154912e-02f, -3.238664044e-02f, -3.238065869e-02f, -3.237360478e-02f, -3.236547966e-02f, 
-3.235628433e-02f, -3.234601980e-02f, -3.233468713e-02f, -3.232228742e-02f, -3.230882178e-02f, -3.229429139e-02f, -3.227869744e-02f, -3.226204114e-02f, -3.224432378e-02f, -3.222554665e-02f, 
-3.220571108e-02f, -3.218481844e-02f, -3.216287013e-02f, -3.213986757e-02f, -3.211581226e-02f, -3.209070567e-02f, -3.206454936e-02f, -3.203734489e-02f, -3.200909386e-02f, -3.197979791e-02f, 
-3.194945872e-02f, -3.191807798e-02f, -3.188565744e-02f, -3.185219886e-02f, -3.181770405e-02f, -3.178217485e-02f, -3.174561312e-02f, -3.170802077e-02f, -3.166939974e-02f, -3.162975198e-02f, 
-3.158907951e-02f, -3.154738436e-02f, -3.150466859e-02f, -3.146093431e-02f, -3.141618363e-02f, -3.137041873e-02f, -3.132364180e-02f, -3.127585508e-02f, -3.122706080e-02f, -3.117726128e-02f, 
-3.112645883e-02f, -3.107465580e-02f, -3.102185458e-02f, -3.096805760e-02f, -3.091326729e-02f, -3.085748614e-02f, -3.080071665e-02f, -3.074296138e-02f, -3.068422289e-02f, -3.062450379e-02f, 
-3.056380671e-02f, -3.050213432e-02f, -3.043948931e-02f, -3.037587441e-02f, -3.031129237e-02f, -3.024574599e-02f, -3.017923807e-02f, -3.011177147e-02f, -3.004334907e-02f, -2.997397376e-02f, 
-2.990364848e-02f, -2.983237620e-02f, -2.976015991e-02f, -2.968700265e-02f, -2.961290745e-02f, -2.953787740e-02f, -2.946191562e-02f, -2.938502524e-02f, -2.930720943e-02f, -2.922847138e-02f, 
-2.914881433e-02f, -2.906824153e-02f, -2.898675625e-02f, -2.890436181e-02f, -2.882106155e-02f, -2.873685883e-02f, -2.865175704e-02f, -2.856575960e-02f, -2.847886996e-02f, -2.839109160e-02f, 
-2.830242802e-02f, -2.821288275e-02f, -2.812245934e-02f, -2.803116138e-02f, -2.793899248e-02f, -2.784595626e-02f, -2.775205640e-02f, -2.765729658e-02f, -2.756168052e-02f, -2.746521195e-02f, 
-2.736789464e-02f, -2.726973239e-02f, -2.717072900e-02f, -2.707088833e-02f, -2.697021424e-02f, -2.686871062e-02f, -2.676638139e-02f, -2.666323048e-02f, -2.655926188e-02f, -2.645447956e-02f, 
-2.634888755e-02f, -2.624248988e-02f, -2.613529062e-02f, -2.602729385e-02f, -2.591850368e-02f, -2.580892426e-02f, -2.569855973e-02f, -2.558741428e-02f, -2.547549211e-02f, -2.536279745e-02f, 
-2.524933454e-02f, -2.513510768e-02f, -2.502012113e-02f, -2.490437923e-02f, -2.478788632e-02f, -2.467064675e-02f, -2.455266491e-02f, -2.443394520e-02f, -2.431449205e-02f, -2.419430990e-02f, 
-2.407340324e-02f, -2.395177654e-02f, -2.382943431e-02f, -2.370638110e-02f, -2.358262145e-02f, -2.345815993e-02f, -2.333300113e-02f, -2.320714968e-02f, -2.308061019e-02f, -2.295338733e-02f, 
-2.282548577e-02f, -2.269691019e-02f, -2.256766532e-02f, -2.243775587e-02f, -2.230718659e-02f, -2.217596226e-02f, -2.204408766e-02f, -2.191156758e-02f, -2.177840687e-02f, -2.164461035e-02f, 
-2.151018288e-02f, -2.137512935e-02f, -2.123945463e-02f, -2.110316365e-02f, -2.096626133e-02f, -2.082875262e-02f, -2.069064248e-02f, -2.055193588e-02f, -2.041263782e-02f, -2.027275332e-02f, 
-2.013228739e-02f, -1.999124509e-02f, -1.984963147e-02f, -1.970745161e-02f, -1.956471059e-02f, -1.942141352e-02f, -1.927756552e-02f, -1.913317173e-02f, -1.898823730e-02f, -1.884276738e-02f, 
-1.869676717e-02f, -1.855024184e-02f, -1.840319662e-02f, -1.825563671e-02f, -1.810756735e-02f, -1.795899380e-02f, -1.780992130e-02f, -1.766035514e-02f, -1.751030061e-02f, -1.735976299e-02f, 
-1.720874760e-02f, -1.705725978e-02f, -1.690530484e-02f, -1.675288815e-02f, -1.660001506e-02f, -1.644669094e-02f, -1.629292118e-02f, -1.613871116e-02f, -1.598406631e-02f, -1.582899203e-02f, 
-1.567349374e-02f, -1.551757689e-02f, -1.536124693e-02f, -1.520450931e-02f, -1.504736949e-02f, -1.488983297e-02f, -1.473190521e-02f, -1.457359173e-02f, -1.441489802e-02f, -1.425582960e-02f, 
-1.409639200e-02f, -1.393659074e-02f, -1.377643136e-02f, -1.361591941e-02f, -1.345506046e-02f, -1.329386006e-02f, -1.313232378e-02f, -1.297045721e-02f, -1.280826594e-02f, -1.264575555e-02f, 
-1.248293164e-02f, -1.231979983e-02f, -1.215636572e-02f, -1.199263495e-02f, -1.182861312e-02f, -1.166430589e-02f, -1.149971888e-02f, -1.133485774e-02f, -1.116972811e-02f, -1.100433566e-02f, 
-1.083868604e-02f, -1.067278491e-02f, -1.050663795e-02f, -1.034025082e-02f, -1.017362921e-02f, -1.000677879e-02f, -9.839705258e-03f, -9.672414292e-03f, -9.504911589e-03f, -9.337202844e-03f, 
-9.169293755e-03f, -9.001190025e-03f, -8.832897357e-03f, -8.664421459e-03f, -8.495768041e-03f, -8.326942812e-03f, -8.157951488e-03f, -7.988799783e-03f, -7.819493413e-03f, -7.650038097e-03f, 
-7.480439554e-03f, -7.310703505e-03f, -7.140835670e-03f, -6.970841771e-03f, -6.800727531e-03f, -6.630498671e-03f, -6.460160916e-03f, -6.289719985e-03f, -6.119181603e-03f, -5.948551490e-03f, 
-5.777835367e-03f, -5.607038954e-03f, -5.436167970e-03f, -5.265228132e-03f, -5.094225158e-03f, -4.923164760e-03f, -4.752052653e-03f, -4.580894546e-03f, -4.409696148e-03f, -4.238463165e-03f, 
-4.067201301e-03f, -3.895916257e-03f, -3.724613729e-03f, -3.553299414e-03f, -3.381979002e-03f, -3.210658180e-03f, -3.039342634e-03f, -2.868038043e-03f, -2.696750084e-03f, -2.525484429e-03f, 
-2.354246744e-03f, -2.183042693e-03f, -2.011877935e-03f, -1.840758121e-03f, -1.669688901e-03f, -1.498675916e-03f, -1.327724803e-03f, -1.156841195e-03f, -9.860307157e-04f, -8.152989852e-04f, 
-6.446516164e-04f, -4.740942159e-04f, -3.036323837e-04f, -1.332717130e-04f, 3.698221014e-05f, 2.071238066e-04f, 3.771475048e-04f, 5.470477406e-04f, 7.168189575e-04f, 8.864556070e-04f, 
1.055952149e-03f, 1.225303050e-03f, 1.394502788e-03f, 1.563545847e-03f, 1.732426720e-03f, 1.901139911e-03f, 2.069679930e-03f, 2.238041298e-03f, 2.406218547e-03f, 2.574206216e-03f, 
2.741998855e-03f, 2.909591025e-03f, 3.076977294e-03f, 3.244152244e-03f, 3.411110465e-03f, 3.577846560e-03f, 3.744355140e-03f, 3.910630829e-03f, 4.076668263e-03f, 4.242462086e-03f, 
4.408006958e-03f, 4.573297546e-03f, 4.738328533e-03f, 4.903094612e-03f, 5.067590488e-03f, 5.231810879e-03f, 5.395750517e-03f, 5.559404143e-03f, 5.722766514e-03f, 5.885832399e-03f, 
6.048596581e-03f, 6.211053854e-03f, 6.373199030e-03f, 6.535026930e-03f, 6.696532391e-03f, 6.857710264e-03f, 7.018555414e-03f, 7.179062722e-03f, 7.339227079e-03f, 7.499043396e-03f, 
7.658506595e-03f, 7.817611615e-03f, 7.976353410e-03f, 8.134726948e-03f, 8.292727213e-03f, 8.450349206e-03f, 8.607587942e-03f, 8.764438453e-03f, 8.920895787e-03f, 9.076955007e-03f, 
9.232611194e-03f, 9.387859444e-03f, 9.542694871e-03f, 9.697112606e-03f, 9.851107795e-03f, 1.000467560e-02f, 1.015781121e-02f, 1.031050982e-02f, 1.046276665e-02f, 1.061457693e-02f, 
1.076593591e-02f, 1.091683887e-02f, 1.106728109e-02f, 1.121725788e-02f, 1.136676456e-02f, 1.151579649e-02f, 1.166434901e-02f, 1.181241752e-02f, 1.195999742e-02f, 1.210708412e-02f, 
1.225367306e-02f, 1.239975970e-02f, 1.254533952e-02f, 1.269040802e-02f, 1.283496071e-02f, 1.297899313e-02f, 1.312250085e-02f, 1.326547943e-02f, 1.340792448e-02f, 1.354983161e-02f, 
1.369119647e-02f, 1.383201472e-02f, 1.397228203e-02f, 1.411199410e-02f, 1.425114667e-02f, 1.438973548e-02f, 1.452775629e-02f, 1.466520489e-02f, 1.480207709e-02f, 1.493836872e-02f, 
1.507407564e-02f, 1.520919371e-02f, 1.534371884e-02f, 1.547764695e-02f, 1.561097397e-02f, 1.574369588e-02f, 1.587580866e-02f, 1.600730832e-02f, 1.613819089e-02f, 1.626845242e-02f, 
1.639808901e-02f, 1.652709674e-02f, 1.665547175e-02f, 1.678321019e-02f, 1.691030822e-02f, 1.703676204e-02f, 1.716256788e-02f, 1.728772197e-02f, 1.741222059e-02f, 1.753606003e-02f, 
1.765923660e-02f, 1.778174664e-02f, 1.790358653e-02f, 1.802475264e-02f, 1.814524139e-02f, 1.826504923e-02f, 1.838417261e-02f, 1.850260803e-02f, 1.862035199e-02f, 1.873740104e-02f, 
1.885375175e-02f, 1.896940070e-02f, 1.908434450e-02f, 1.919857980e-02f, 1.931210326e-02f, 1.942491158e-02f, 1.953700148e-02f, 1.964836969e-02f, 1.975901298e-02f, 1.986892816e-02f, 
1.997811205e-02f, 2.008656149e-02f, 2.019427335e-02f, 2.030124455e-02f, 2.040747200e-02f, 2.051295266e-02f, 2.061768351e-02f, 2.072166156e-02f, 2.082488385e-02f, 2.092734743e-02f, 
2.102904940e-02f, 2.112998686e-02f, 2.123015697e-02f, 2.132955689e-02f, 2.142818382e-02f, 2.152603499e-02f, 2.162310764e-02f, 2.171939906e-02f, 2.181490656e-02f, 2.190962747e-02f, 
2.200355914e-02f, 2.209669899e-02f, 2.218904441e-02f, 2.228059287e-02f, 2.237134183e-02f, 2.246128880e-02f, 2.255043131e-02f, 2.263876691e-02f, 2.272629320e-02f, 2.281300779e-02f, 
2.289890833e-02f, 2.298399248e-02f, 2.306825796e-02f, 2.315170249e-02f, 2.323432382e-02f, 2.331611976e-02f, 2.339708810e-02f, 2.347722671e-02f, 2.355653344e-02f, 2.363500621e-02f, 
2.371264295e-02f, 2.378944161e-02f, 2.386540019e-02f, 2.394051671e-02f, 2.401478921e-02f, 2.408821577e-02f, 2.416079450e-02f, 2.423252354e-02f, 2.430340104e-02f, 2.437342521e-02f, 
2.444259427e-02f, 2.451090647e-02f, 2.457836010e-02f, 2.464495347e-02f, 2.471068491e-02f, 2.477555281e-02f, 2.483955556e-02f, 2.490269160e-02f, 2.496495939e-02f, 2.502635741e-02f, 
2.508688419e-02f, 2.514653828e-02f, 2.520531826e-02f, 2.526322273e-02f, 2.532025035e-02f, 2.537639977e-02f, 2.543166970e-02f, 2.548605887e-02f, 2.553956603e-02f, 2.559218999e-02f, 
2.564392955e-02f, 2.569478357e-02f, 2.574475093e-02f, 2.579383053e-02f, 2.584202133e-02f, 2.588932228e-02f, 2.593573239e-02f, 2.598125069e-02f, 2.602587624e-02f, 2.606960814e-02f, 
2.611244549e-02f, 2.615438746e-02f, 2.619543323e-02f, 2.623558201e-02f, 2.627483303e-02f, 2.631318558e-02f, 2.635063895e-02f, 2.638719249e-02f, 2.642284554e-02f, 2.645759751e-02f, 
2.649144781e-02f, 2.652439591e-02f, 2.655644129e-02f, 2.658758345e-02f, 2.661782195e-02f, 2.664715636e-02f, 2.667558628e-02f, 2.670311136e-02f, 2.672973125e-02f, 2.675544565e-02f, 
2.678025429e-02f, 2.680415692e-02f, 2.682715333e-02f, 2.684924334e-02f, 2.687042679e-02f, 2.689070357e-02f, 2.691007356e-02f, 2.692853672e-02f, 2.694609302e-02f, 2.696274244e-02f, 
2.697848501e-02f, 2.699332080e-02f, 2.700724989e-02f, 2.702027239e-02f, 2.703238846e-02f, 2.704359827e-02f, 2.705390203e-02f, 2.706329997e-02f, 2.707179236e-02f, 2.707937951e-02f, 
2.708606173e-02f, 2.709183938e-02f, 2.709671285e-02f, 2.710068256e-02f, 2.710374894e-02f, 2.710591248e-02f, 2.710717368e-02f, 2.710753307e-02f, 2.710699122e-02f, 2.710554872e-02f, 
2.710320619e-02f, 2.709996429e-02f, 2.709582370e-02f, 2.709078513e-02f, 2.708484931e-02f, 2.707801703e-02f, 2.707028907e-02f, 2.706166627e-02f, 2.705214948e-02f, 2.704173959e-02f, 
2.703043752e-02f, 2.701824420e-02f, 2.700516062e-02f, 2.699118777e-02f, 2.697632668e-02f, 2.696057842e-02f, 2.694394408e-02f, 2.692642476e-02f, 2.690802162e-02f, 2.688873583e-02f, 
2.686856860e-02f, 2.684752115e-02f, 2.682559474e-02f, 2.680279067e-02f, 2.677911024e-02f, 2.675455481e-02f, 2.672912574e-02f, 2.670282444e-02f, 2.667565234e-02f, 2.664761088e-02f, 
2.661870157e-02f, 2.658892590e-02f, 2.655828542e-02f, 2.652678170e-02f, 2.649441633e-02f, 2.646119094e-02f, 2.642710717e-02f, 2.639216671e-02f, 2.635637125e-02f, 2.631972254e-02f, 
2.628222233e-02f, 2.624387241e-02f, 2.620467459e-02f, 2.616463071e-02f, 2.612374264e-02f, 2.608201228e-02f, 2.603944154e-02f, 2.599603237e-02f, 2.595178676e-02f, 2.590670669e-02f, 
2.586079420e-02f, 2.581405134e-02f, 2.576648019e-02f, 2.571808285e-02f, 2.566886146e-02f, 2.561881817e-02f, 2.556795518e-02f, 2.551627468e-02f, 2.546377892e-02f, 2.541047015e-02f, 
2.535635066e-02f, 2.530142276e-02f, 2.524568879e-02f, 2.518915112e-02f, 2.513181212e-02f, 2.507367422e-02f, 2.501473985e-02f, 2.495501147e-02f, 2.489449156e-02f, 2.483318265e-02f, 
2.477108727e-02f, 2.470820797e-02f, 2.464454735e-02f, 2.458010801e-02f, 2.451489259e-02f, 2.444890374e-02f, 2.438214414e-02f, 2.431461651e-02f, 2.424632357e-02f, 2.417726807e-02f, 
2.410745279e-02f, 2.403688053e-02f, 2.396555412e-02f, 2.389347639e-02f, 2.382065022e-02f, 2.374707850e-02f, 2.367276415e-02f, 2.359771010e-02f, 2.352191932e-02f, 2.344539478e-02f, 
2.336813950e-02f, 2.329015650e-02f, 2.321144884e-02f, 2.313201958e-02f, 2.305187182e-02f, 2.297100867e-02f, 2.288943328e-02f, 2.280714880e-02f, 2.272415842e-02f, 2.264046533e-02f, 
2.255607276e-02f, 2.247098396e-02f, 2.238520219e-02f, 2.229873074e-02f, 2.221157291e-02f, 2.212373204e-02f, 2.203521147e-02f, 2.194601457e-02f, 2.185614474e-02f, 2.176560537e-02f, 
2.167439991e-02f, 2.158253180e-02f, 2.149000451e-02f, 2.139682153e-02f, 2.130298637e-02f, 2.120850255e-02f, 2.111337363e-02f, 2.101760317e-02f, 2.092119475e-02f, 2.082415199e-02f, 
2.072647849e-02f, 2.062817791e-02f, 2.052925391e-02f, 2.042971016e-02f, 2.032955036e-02f, 2.022877823e-02f, 2.012739750e-02f, 2.002541191e-02f, 1.992282524e-02f, 1.981964128e-02f, 
1.971586382e-02f, 1.961149670e-02f, 1.950654373e-02f, 1.940100879e-02f, 1.929489574e-02f, 1.918820846e-02f, 1.908095088e-02f, 1.897312689e-02f, 1.886474046e-02f, 1.875579552e-02f, 
1.864629605e-02f, 1.853624603e-02f, 1.842564947e-02f, 1.831451038e-02f, 1.820283279e-02f, 1.809062076e-02f, 1.797787834e-02f, 1.786460962e-02f, 1.775081868e-02f, 1.763650964e-02f, 
1.752168661e-02f, 1.740635374e-02f, 1.729051517e-02f, 1.717417507e-02f, 1.705733762e-02f, 1.694000701e-02f, 1.682218744e-02f, 1.670388315e-02f, 1.658509836e-02f, 1.646583732e-02f, 
1.634610428e-02f, 1.622590353e-02f, 1.610523935e-02f, 1.598411603e-02f, 1.586253789e-02f, 1.574050925e-02f, 1.561803445e-02f, 1.549511783e-02f, 1.537176376e-02f, 1.524797660e-02f, 
1.512376074e-02f, 1.499912057e-02f, 1.487406050e-02f, 1.474858494e-02f, 1.462269833e-02f, 1.449640510e-02f, 1.436970969e-02f, 1.424261658e-02f, 1.411513024e-02f, 1.398725513e-02f, 
1.385899575e-02f, 1.373035661e-02f, 1.360134221e-02f, 1.347195708e-02f, 1.334220573e-02f, 1.321209272e-02f, 1.308162258e-02f, 1.295079988e-02f, 1.281962919e-02f, 1.268811506e-02f, 
1.255626210e-02f, 1.242407488e-02f, 1.229155801e-02f, 1.215871610e-02f, 1.202555375e-02f, 1.189207561e-02f, 1.175828628e-02f, 1.162419042e-02f, 1.148979266e-02f, 1.135509767e-02f, 
1.122011009e-02f, 1.108483460e-02f, 1.094927586e-02f, 1.081343856e-02f, 1.067732739e-02f, 1.054094702e-02f, 1.040430217e-02f, 1.026739753e-02f, 1.013023781e-02f, 9.992827728e-03f, 
9.855172004e-03f, 9.717275361e-03f, 9.579142531e-03f, 9.440778246e-03f, 9.302187248e-03f, 9.163374280e-03f, 9.024344090e-03f, 8.885101432e-03f, 8.745651061e-03f, 8.605997740e-03f, 
8.466146231e-03f, 8.326101302e-03f, 8.185867727e-03f, 8.045450278e-03f, 7.904853733e-03f, 7.764082874e-03f, 7.623142484e-03f, 7.482037349e-03f, 7.340772257e-03f, 7.199352000e-03f, 
7.057781369e-03f, 6.916065161e-03f, 6.774208172e-03f, 6.632215200e-03f, 6.490091045e-03f, 6.347840510e-03f, 6.205468395e-03f, 6.062979505e-03f, 5.920378643e-03f, 5.777670616e-03f, 
5.634860228e-03f, 5.491952286e-03f, 5.348951595e-03f, 5.205862962e-03f, 5.062691193e-03f, 4.919441095e-03f, 4.776117471e-03f, 4.632725128e-03f, 4.489268870e-03f, 4.345753499e-03f, 
4.202183819e-03f, 4.058564629e-03f, 3.914900730e-03f, 3.771196920e-03f, 3.627457995e-03f, 3.483688750e-03f, 3.339893978e-03f, 3.196078468e-03f, 3.052247010e-03f, 2.908404388e-03f, 
2.764555387e-03f, 2.620704785e-03f, 2.476857361e-03f, 2.333017888e-03f, 2.189191138e-03f, 2.045381878e-03f, 1.901594873e-03f, 1.757834881e-03f, 1.614106661e-03f, 1.470414963e-03f, 
1.326764538e-03f, 1.183160127e-03f, 1.039606471e-03f, 8.961083038e-04f, 7.526703561e-04f, 6.092973524e-04f, 4.659940126e-04f, 3.227650513e-04f, 1.796151776e-04f, 3.654909510e-05f, 
-1.064284984e-04f, -2.493129109e-04f, -3.920994564e-04f, -5.347834551e-04f, -6.773602337e-04f, -8.198251252e-04f, -9.621734691e-04f, -1.104400612e-03f, -1.246501907e-03f, -1.388472715e-03f, 
-1.530308404e-03f, -1.672004347e-03f, -1.813555930e-03f, -1.954958540e-03f, -2.096207577e-03f, -2.237298446e-03f, -2.378226562e-03f, -2.518987347e-03f, -2.659576232e-03f, -2.799988656e-03f, 
-2.940220068e-03f, -3.080265924e-03f, -3.220121691e-03f, -3.359782843e-03f, -3.499244864e-03f, -3.638503250e-03f, -3.777553502e-03f, -3.916391134e-03f, -4.055011669e-03f, -4.193410640e-03f, 
-4.331583591e-03f, -4.469526073e-03f, -4.607233651e-03f, -4.744701900e-03f, -4.881926404e-03f, -5.018902760e-03f, -5.155626574e-03f, -5.292093464e-03f, -5.428299059e-03f, -5.564239000e-03f, 
-5.699908939e-03f, -5.835304541e-03f, -5.970421480e-03f, -6.105255444e-03f, -6.239802133e-03f, -6.374057259e-03f, -6.508016545e-03f, -6.641675729e-03f, -6.775030561e-03f, -6.908076801e-03f, 
-7.040810225e-03f, -7.173226621e-03f, -7.305321791e-03f, -7.437091547e-03f, -7.568531719e-03f, -7.699638147e-03f, -7.830406686e-03f, -7.960833206e-03f, -8.090913589e-03f, -8.220643731e-03f, 
-8.350019544e-03f, -8.479036952e-03f, -8.607691896e-03f, -8.735980330e-03f, -8.863898222e-03f, -8.991441556e-03f, -9.118606331e-03f, -9.245388561e-03f, -9.371784274e-03f, -9.497789514e-03f, 
-9.623400341e-03f, -9.748612831e-03f, -9.873423073e-03f, -9.997827175e-03f, -1.012182126e-02f, -1.024540146e-02f, -1.036856394e-02f, -1.049130487e-02f, -1.061362042e-02f, -1.073550682e-02f, 
-1.085696027e-02f, -1.097797701e-02f, -1.109855331e-02f, -1.121868542e-02f, -1.133836963e-02f, -1.145760226e-02f, -1.157637963e-02f, -1.169469806e-02f, -1.181255393e-02f, -1.192994360e-02f, 
-1.204686347e-02f, -1.216330995e-02f, -1.227927946e-02f, -1.239476846e-02f, -1.250977341e-02f, -1.262429078e-02f, -1.273831709e-02f, -1.285184885e-02f, -1.296488259e-02f, -1.307741488e-02f, 
-1.318944230e-02f, -1.330096143e-02f, -1.341196889e-02f, -1.352246131e-02f, -1.363243534e-02f, -1.374188766e-02f, -1.385081496e-02f, -1.395921394e-02f, -1.406708133e-02f, -1.417441389e-02f, 
-1.428120838e-02f, -1.438746159e-02f, -1.449317034e-02f, -1.459833144e-02f, -1.470294174e-02f, -1.480699813e-02f, -1.491049748e-02f, -1.501343670e-02f, -1.511581274e-02f, -1.521762253e-02f, 
-1.531886304e-02f, -1.541953128e-02f, -1.551962426e-02f, -1.561913900e-02f, -1.571807257e-02f, -1.581642204e-02f, -1.591418450e-02f, -1.601135708e-02f, -1.610793692e-02f, -1.620392118e-02f, 
-1.629930703e-02f, -1.639409170e-02f, -1.648827239e-02f, -1.658184637e-02f, -1.667481090e-02f, -1.676716327e-02f, -1.685890080e-02f, -1.695002082e-02f, -1.704052069e-02f, -1.713039779e-02f, 
-1.721964952e-02f, -1.730827332e-02f, -1.739626662e-02f, -1.748362690e-02f, -1.757035164e-02f, -1.765643837e-02f, -1.774188462e-02f, -1.782668795e-02f, -1.791084595e-02f, -1.799435622e-02f, 
-1.807721639e-02f, -1.815942412e-02f, -1.824097707e-02f, -1.832187295e-02f, -1.840210949e-02f, -1.848168442e-02f, -1.856059551e-02f, -1.863884055e-02f, -1.871641737e-02f, -1.879332380e-02f, 
-1.886955770e-02f, -1.894511696e-02f, -1.901999949e-02f, -1.909420322e-02f, -1.916772611e-02f, -1.924056614e-02f, -1.931272132e-02f, -1.938418967e-02f, -1.945496925e-02f, -1.952505813e-02f, 
-1.959445443e-02f, -1.966315625e-02f, -1.973116176e-02f, -1.979846912e-02f, -1.986507654e-02f, -1.993098223e-02f, -1.999618445e-02f, -2.006068147e-02f, -2.012447157e-02f, -2.018755309e-02f, 
-2.024992436e-02f, -2.031158376e-02f, -2.037252968e-02f, -2.043276053e-02f, -2.049227477e-02f, -2.055107086e-02f, -2.060914730e-02f, -2.066650259e-02f, -2.072313529e-02f, -2.077904396e-02f, 
-2.083422720e-02f, -2.088868361e-02f, -2.094241186e-02f, -2.099541059e-02f, -2.104767851e-02f, -2.109921432e-02f, -2.115001679e-02f, -2.120008466e-02f, -2.124941674e-02f, -2.129801184e-02f, 
-2.134586881e-02f, -2.139298651e-02f, -2.143936384e-02f, -2.148499971e-02f, -2.152989308e-02f, -2.157404291e-02f, -2.161744819e-02f, -2.166010795e-02f, -2.170202122e-02f, -2.174318709e-02f, 
-2.178360465e-02f, -2.182327301e-02f, -2.186219134e-02f, -2.190035879e-02f, -2.193777456e-02f, -2.197443789e-02f, -2.201034801e-02f, -2.204550421e-02f, -2.207990577e-02f, -2.211355204e-02f, 
-2.214644235e-02f, -2.217857608e-02f, -2.220995264e-02f, -2.224057146e-02f, -2.227043197e-02f, -2.229953367e-02f, -2.232787606e-02f, -2.235545866e-02f, -2.238228103e-02f, -2.240834275e-02f, 
-2.243364343e-02f, -2.245818269e-02f, -2.248196020e-02f, -2.250497563e-02f, -2.252722869e-02f, -2.254871912e-02f, -2.256944667e-02f, -2.258941113e-02f, -2.260861231e-02f, -2.262705004e-02f, 
-2.264472419e-02f, -2.266163463e-02f, -2.267778128e-02f, -2.269316408e-02f, -2.270778298e-02f, -2.272163798e-02f, -2.273472909e-02f, -2.274705634e-02f, -2.275861980e-02f, -2.276941956e-02f, 
-2.277945574e-02f, -2.278872846e-02f, -2.279723790e-02f, -2.280498424e-02f, -2.281196770e-02f, -2.281818852e-02f, -2.282364697e-02f, -2.282834333e-02f, -2.283227792e-02f, -2.283545109e-02f, 
-2.283786319e-02f, -2.283951461e-02f, -2.284040578e-02f, -2.284053714e-02f, -2.283990914e-02f, -2.283852229e-02f, -2.283637708e-02f, -2.283347408e-02f, -2.282981383e-02f, -2.282539694e-02f, 
-2.282022400e-02f, -2.281429568e-02f, -2.280761262e-02f, -2.280017551e-02f, -2.279198508e-02f, -2.278304205e-02f, -2.277334719e-02f, -2.276290129e-02f, -2.275170515e-02f, -2.273975962e-02f, 
-2.272706555e-02f, -2.271362383e-02f, -2.269943536e-02f, -2.268450108e-02f, -2.266882194e-02f, -2.265239894e-02f, -2.263523306e-02f, -2.261732534e-02f, -2.259867684e-02f, -2.257928862e-02f, 
-2.255916180e-02f, -2.253829749e-02f, -2.251669685e-02f, -2.249436105e-02f, -2.247129127e-02f, -2.244748875e-02f, -2.242295473e-02f, -2.239769047e-02f, -2.237169726e-02f, -2.234497641e-02f, 
-2.231752927e-02f, -2.228935720e-02f, -2.226046156e-02f, -2.223084378e-02f, -2.220050529e-02f, -2.216944752e-02f, -2.213767197e-02f, -2.210518013e-02f, -2.207197352e-02f, -2.203805368e-02f, 
-2.200342219e-02f, -2.196808062e-02f, -2.193203060e-02f, -2.189527376e-02f, -2.185781175e-02f, -2.181964626e-02f, -2.178077898e-02f, -2.174121164e-02f, -2.170094599e-02f, -2.165998380e-02f, 
-2.161832685e-02f, -2.157597696e-02f, -2.153293596e-02f, -2.148920570e-02f, -2.144478808e-02f, -2.139968498e-02f, -2.135389832e-02f, -2.130743005e-02f, -2.126028214e-02f, -2.121245656e-02f, 
-2.116395533e-02f, -2.111478047e-02f, -2.106493403e-02f, -2.101441808e-02f, -2.096323471e-02f, -2.091138603e-02f, -2.085887418e-02f, -2.080570131e-02f, -2.075186959e-02f, -2.069738122e-02f, 
-2.064223841e-02f, -2.058644339e-02f, -2.052999843e-02f, -2.047290579e-02f, -2.041516778e-02f, -2.035678671e-02f, -2.029776491e-02f, -2.023810474e-02f, -2.017780858e-02f, -2.011687881e-02f, 
-2.005531786e-02f, -1.999312816e-02f, -1.993031216e-02f, -1.986687233e-02f, -1.980281117e-02f, -1.973813118e-02f, -1.967283490e-02f, -1.960692488e-02f, -1.954040367e-02f, -1.947327388e-02f, 
-1.940553809e-02f, -1.933719894e-02f, -1.926825907e-02f, -1.919872114e-02f, -1.912858783e-02f, -1.905786182e-02f, -1.898654585e-02f, -1.891464263e-02f, -1.884215492e-02f, -1.876908549e-02f, 
-1.869543712e-02f, -1.862121262e-02f, -1.854641480e-02f, -1.847104650e-02f, -1.839511058e-02f, -1.831860992e-02f, -1.824154739e-02f, -1.816392590e-02f, -1.808574839e-02f, -1.800701777e-02f, 
-1.792773703e-02f, -1.784790911e-02f, -1.776753702e-02f, -1.768662375e-02f, -1.760517234e-02f, -1.752318580e-02f, -1.744066721e-02f, -1.735761962e-02f, -1.727404612e-02f, -1.718994982e-02f, 
-1.710533382e-02f, -1.702020125e-02f, -1.693455527e-02f, -1.684839903e-02f, -1.676173571e-02f, -1.667456849e-02f, -1.658690060e-02f, -1.649873524e-02f, -1.641007565e-02f, -1.632092507e-02f, 
-1.623128679e-02f, -1.614116406e-02f, -1.605056018e-02f, -1.595947846e-02f, -1.586792222e-02f, -1.577589479e-02f, -1.568339952e-02f, -1.559043976e-02f, -1.549701890e-02f, -1.540314031e-02f, 
-1.530880740e-02f, -1.521402359e-02f, -1.511879229e-02f, -1.502311694e-02f, -1.492700101e-02f, -1.483044794e-02f, -1.473346122e-02f, -1.463604434e-02f, -1.453820079e-02f, -1.443993409e-02f, 
-1.434124776e-02f, -1.424214535e-02f, -1.414263039e-02f, -1.404270644e-02f, -1.394237709e-02f, -1.384164590e-02f, -1.374051647e-02f, -1.363899241e-02f, -1.353707734e-02f, -1.343477487e-02f, 
-1.333208864e-02f, -1.322902231e-02f, -1.312557952e-02f, -1.302176396e-02f, -1.291757928e-02f, -1.281302919e-02f, -1.270811737e-02f, -1.260284755e-02f, -1.249722342e-02f, -1.239124873e-02f, 
-1.228492720e-02f, -1.217826259e-02f, -1.207125863e-02f, -1.196391911e-02f, -1.185624779e-02f, -1.174824845e-02f, -1.163992488e-02f, -1.153128088e-02f, -1.142232025e-02f, -1.131304681e-02f, 
-1.120346438e-02f, -1.109357679e-02f, -1.098338787e-02f, -1.087290149e-02f, -1.076212147e-02f, -1.065105170e-02f, -1.053969603e-02f, -1.042805834e-02f, -1.031614252e-02f, -1.020395244e-02f, 
-1.009149201e-02f, -9.978765127e-03f, -9.865775701e-03f, -9.752527646e-03f, -9.639024882e-03f, -9.525271338e-03f, -9.411270946e-03f, -9.297027645e-03f, -9.182545379e-03f, -9.067828098e-03f, 
-8.952879757e-03f, -8.837704317e-03f, -8.722305743e-03f, -8.606688007e-03f, -8.490855083e-03f, -8.374810952e-03f, -8.258559598e-03f, -8.142105011e-03f, -8.025451184e-03f, -7.908602116e-03f, 
-7.791561806e-03f, -7.674334262e-03f, -7.556923492e-03f, -7.439333510e-03f, -7.321568332e-03f, -7.203631978e-03f, -7.085528471e-03f, -6.967261836e-03f, -6.848836104e-03f, -6.730255306e-03f, 
-6.611523477e-03f, -6.492644654e-03f, -6.373622876e-03f, -6.254462186e-03f, -6.135166627e-03f, -6.015740245e-03f, -5.896187088e-03f, -5.776511206e-03f, -5.656716650e-03f, -5.536807472e-03f, 
-5.416787727e-03f, -5.296661469e-03f, -5.176432756e-03f, -5.056105643e-03f, -4.935684189e-03f, -4.815172453e-03f, -4.694574493e-03f, -4.573894369e-03f, -4.453136141e-03f, -4.332303868e-03f, 
-4.211401611e-03f, -4.090433429e-03f, -3.969403381e-03f, -3.848315527e-03f, -3.727173924e-03f, -3.605982630e-03f, -3.484745703e-03f, -3.363467197e-03f, -3.242151168e-03f, -3.120801670e-03f, 
-2.999422753e-03f, -2.878018470e-03f, -2.756592869e-03f, -2.635149998e-03f, -2.513693901e-03f, -2.392228622e-03f, -2.270758202e-03f, -2.149286681e-03f, -2.027818093e-03f, -1.906356475e-03f, 
-1.784905855e-03f, -1.663470264e-03f, -1.542053726e-03f, -1.420660263e-03f, -1.299293895e-03f, -1.177958638e-03f, -1.056658503e-03f, -9.353974986e-04f, -8.141796306e-04f, -6.930088995e-04f, 
-5.718893023e-04f, -4.508248319e-04f, -3.298194768e-04f, -2.088772212e-04f, -8.800204464e-05f, 3.280207785e-05f, 1.535311761e-04f, 2.741812848e-04f, 3.947484439e-04f, 5.152286981e-04f, 
6.356180978e-04f, 7.559126987e-04f, 8.761085620e-04f, 9.962017545e-04f, 1.116188349e-03f, 1.236064425e-03f, 1.355826065e-03f, 1.475469363e-03f, 1.594990413e-03f, 1.714385321e-03f, 
1.833650197e-03f, 1.952781157e-03f, 2.071774326e-03f, 2.190625833e-03f, 2.309331817e-03f, 2.427888423e-03f, 2.546291803e-03f, 2.664538117e-03f, 2.782623531e-03f, 2.900544222e-03f, 
3.018296371e-03f, 3.135876169e-03f, 3.253279815e-03f, 3.370503517e-03f, 3.487543488e-03f, 3.604395954e-03f, 3.721057145e-03f, 3.837523303e-03f, 3.953790677e-03f, 4.069855526e-03f, 
4.185714116e-03f, 4.301362726e-03f, 4.416797640e-03f, 4.532015154e-03f, 4.647011572e-03f, 4.761783209e-03f, 4.876326388e-03f, 4.990637444e-03f, 5.104712719e-03f, 5.218548569e-03f, 
5.332141357e-03f, 5.445487456e-03f, 5.558583253e-03f, 5.671425142e-03f, 5.784009528e-03f, 5.896332829e-03f, 6.008391472e-03f, 6.120181895e-03f, 6.231700548e-03f, 6.342943891e-03f, 
6.453908396e-03f, 6.564590547e-03f, 6.674986839e-03f, 6.785093778e-03f, 6.894907881e-03f, 7.004425681e-03f, 7.113643718e-03f, 7.222558546e-03f, 7.331166732e-03f, 7.439464855e-03f, 
7.547449505e-03f, 7.655117286e-03f, 7.762464814e-03f, 7.869488717e-03f, 7.976185638e-03f, 8.082552230e-03f, 8.188585161e-03f, 8.294281111e-03f, 8.399636775e-03f, 8.504648860e-03f, 
8.609314085e-03f, 8.713629185e-03f, 8.817590908e-03f, 8.921196014e-03f, 9.024441280e-03f, 9.127323494e-03f, 9.229839459e-03f, 9.331985993e-03f, 9.433759926e-03f, 9.535158105e-03f, 
9.636177390e-03f, 9.736814655e-03f, 9.837066790e-03f, 9.936930698e-03f, 1.003640330e-02f, 1.013548152e-02f, 1.023416232e-02f, 1.033244266e-02f, 1.043031952e-02f, 1.052778988e-02f, 
1.062485077e-02f, 1.072149920e-02f, 1.081773221e-02f, 1.091354686e-02f, 1.100894023e-02f, 1.110390939e-02f, 1.119845146e-02f, 1.129256355e-02f, 1.138624280e-02f, 1.147948635e-02f, 
1.157229138e-02f, 1.166465506e-02f, 1.175657461e-02f, 1.184804723e-02f, 1.193907016e-02f, 1.202964065e-02f, 1.211975597e-02f, 1.220941339e-02f, 1.229861022e-02f, 1.238734378e-02f, 
1.247561139e-02f, 1.256341042e-02f, 1.265073822e-02f, 1.273759219e-02f, 1.282396972e-02f, 1.290986824e-02f, 1.299528519e-02f, 1.308021802e-02f, 1.316466420e-02f, 1.324862122e-02f, 
1.333208660e-02f, 1.341505785e-02f, 1.349753253e-02f, 1.357950819e-02f, 1.366098242e-02f, 1.374195281e-02f, 1.382241698e-02f, 1.390237256e-02f, 1.398181721e-02f, 1.406074861e-02f, 
1.413916443e-02f, 1.421706239e-02f, 1.429444021e-02f, 1.437129565e-02f, 1.444762646e-02f, 1.452343042e-02f, 1.459870535e-02f, 1.467344906e-02f, 1.474765940e-02f, 1.482133421e-02f, 
1.489447138e-02f, 1.496706881e-02f, 1.503912441e-02f, 1.511063611e-02f, 1.518160188e-02f, 1.525201969e-02f, 1.532188753e-02f, 1.539120342e-02f, 1.545996538e-02f, 1.552817147e-02f, 
1.559581977e-02f, 1.566290836e-02f, 1.572943535e-02f, 1.579539888e-02f, 1.586079710e-02f, 1.592562818e-02f, 1.598989031e-02f, 1.605358170e-02f, 1.611670058e-02f, 1.617924521e-02f, 
1.624121385e-02f, 1.630260480e-02f, 1.636341637e-02f, 1.642364689e-02f, 1.648329471e-02f, 1.654235820e-02f, 1.660083577e-02f, 1.665872581e-02f, 1.671602677e-02f, 1.677273711e-02f, 
1.682885528e-02f, 1.688437980e-02f, 1.693930918e-02f, 1.699364195e-02f, 1.704737667e-02f, 1.710051193e-02f, 1.715304631e-02f, 1.720497844e-02f, 1.725630697e-02f, 1.730703054e-02f, 
1.735714785e-02f, 1.740665760e-02f, 1.745555852e-02f, 1.750384934e-02f, 1.755152883e-02f, 1.759859579e-02f, 1.764504902e-02f, 1.769088735e-02f, 1.773610963e-02f, 1.778071474e-02f, 
1.782470156e-02f, 1.786806902e-02f, 1.791081604e-02f, 1.795294159e-02f, 1.799444464e-02f, 1.803532420e-02f, 1.807557927e-02f, 1.811520891e-02f, 1.815421218e-02f, 1.819258817e-02f, 
1.823033597e-02f, 1.826745473e-02f, 1.830394358e-02f, 1.833980169e-02f, 1.837502827e-02f, 1.840962252e-02f, 1.844358368e-02f, 1.847691100e-02f, 1.850960377e-02f, 1.854166128e-02f, 
1.857308285e-02f, 1.860386782e-02f, 1.863401557e-02f, 1.866352547e-02f, 1.869239694e-02f, 1.872062940e-02f, 1.874822229e-02f, 1.877517511e-02f, 1.880148733e-02f, 1.882715847e-02f, 
1.885218807e-02f, 1.887657569e-02f, 1.890032091e-02f, 1.892342333e-02f, 1.894588256e-02f, 1.896769827e-02f, 1.898887011e-02f, 1.900939777e-02f, 1.902928095e-02f, 1.904851940e-02f, 
1.906711287e-02f, 1.908506112e-02f, 1.910236396e-02f, 1.911902119e-02f, 1.913503267e-02f, 1.915039825e-02f, 1.916511781e-02f, 1.917919125e-02f, 1.919261851e-02f, 1.920539952e-02f, 
1.921753426e-02f, 1.922902271e-02f, 1.923986489e-02f, 1.925006083e-02f, 1.925961058e-02f, 1.926851422e-02f, 1.927677184e-02f, 1.928438356e-02f, 1.929134953e-02f, 1.929766990e-02f, 
1.930334485e-02f, 1.930837459e-02f, 1.931275935e-02f, 1.931649937e-02f, 1.931959491e-02f, 1.932204627e-02f, 1.932385375e-02f, 1.932501769e-02f, 1.932553844e-02f, 1.932541637e-02f, 
1.932465188e-02f, 1.932324539e-02f, 1.932119732e-02f, 1.931850814e-02f, 1.931517832e-02f, 1.931120837e-02f, 1.930659881e-02f, 1.930135017e-02f, 1.929546303e-02f, 1.928893796e-02f, 
1.928177557e-02f, 1.927397648e-02f, 1.926554135e-02f, 1.925647083e-02f, 1.924676561e-02f, 1.923642640e-02f, 1.922545394e-02f, 1.921384896e-02f, 1.920161224e-02f, 1.918874457e-02f, 
1.917524677e-02f, 1.916111965e-02f, 1.914636408e-02f, 1.913098092e-02f, 1.911497107e-02f, 1.909833544e-02f, 1.908107496e-02f, 1.906319059e-02f, 1.904468329e-02f, 1.902555407e-02f, 
1.900580394e-02f, 1.898543392e-02f, 1.896444507e-02f, 1.894283847e-02f, 1.892061521e-02f, 1.889777640e-02f, 1.887432317e-02f, 1.885025668e-02f, 1.882557810e-02f, 1.880028862e-02f, 
1.877438945e-02f, 1.874788182e-02f, 1.872076699e-02f, 1.869304621e-02f, 1.866472079e-02f, 1.863579203e-02f, 1.860626125e-02f, 1.857612981e-02f, 1.854539907e-02f, 1.851407041e-02f, 
1.848214524e-02f, 1.844962499e-02f, 1.841651109e-02f, 1.838280500e-02f, 1.834850821e-02f, 1.831362220e-02f, 1.827814851e-02f, 1.824208867e-02f, 1.820544422e-02f, 1.816821674e-02f, 
1.813040783e-02f, 1.809201909e-02f, 1.805305215e-02f, 1.801350865e-02f, 1.797339026e-02f, 1.793269867e-02f, 1.789143557e-02f, 1.784960267e-02f, 1.780720173e-02f, 1.776423448e-02f, 
1.772070270e-02f, 1.767660818e-02f, 1.763195273e-02f, 1.758673818e-02f, 1.754096635e-02f, 1.749463912e-02f, 1.744775836e-02f, 1.740032596e-02f, 1.735234383e-02f, 1.730381391e-02f, 
1.725473813e-02f, 1.720511847e-02f, 1.715495689e-02f, 1.710425540e-02f, 1.705301600e-02f, 1.700124073e-02f, 1.694893163e-02f, 1.689609077e-02f, 1.684272021e-02f, 1.678882207e-02f, 
1.673439844e-02f, 1.667945147e-02f, 1.662398328e-02f, 1.656799604e-02f, 1.651149192e-02f, 1.645447313e-02f, 1.639694185e-02f, 1.633890032e-02f, 1.628035078e-02f, 1.622129548e-02f, 
1.616173668e-02f, 1.610167668e-02f, 1.604111776e-02f, 1.598006226e-02f, 1.591851250e-02f, 1.585647082e-02f, 1.579393958e-02f, 1.573092116e-02f, 1.566741796e-02f, 1.560343236e-02f, 
1.553896680e-02f, 1.547402370e-02f, 1.540860552e-02f, 1.534271471e-02f, 1.527635376e-02f, 1.520952515e-02f, 1.514223138e-02f, 1.507447498e-02f, 1.500625849e-02f, 1.493758443e-02f, 
1.486845538e-02f, 1.479887391e-02f, 1.472884260e-02f, 1.465836406e-02f, 1.458744090e-02f, 1.451607574e-02f, 1.444427123e-02f, 1.437203001e-02f, 1.429935476e-02f, 1.422624815e-02f, 
1.415271287e-02f, 1.407875163e-02f, 1.400436715e-02f, 1.392956214e-02f, 1.385433936e-02f, 1.377870156e-02f, 1.370265149e-02f, 1.362619195e-02f, 1.354932572e-02f, 1.347205559e-02f, 
1.339438439e-02f, 1.331631494e-02f, 1.323785007e-02f, 1.315899263e-02f, 1.307974548e-02f, 1.300011149e-02f, 1.292009355e-02f, 1.283969453e-02f, 1.275891736e-02f, 1.267776493e-02f, 
1.259624018e-02f, 1.251434603e-02f, 1.243208545e-02f, 1.234946138e-02f, 1.226647678e-02f, 1.218313464e-02f, 1.209943794e-02f, 1.201538968e-02f, 1.193099287e-02f, 1.184625051e-02f, 
1.176116565e-02f, 1.167574130e-02f, 1.158998052e-02f, 1.150388637e-02f, 1.141746190e-02f, 1.133071019e-02f, 1.124363431e-02f, 1.115623737e-02f, 1.106852246e-02f, 1.098049268e-02f, 
1.089215116e-02f, 1.080350101e-02f, 1.071454538e-02f, 1.062528741e-02f, 1.053573023e-02f, 1.044587702e-02f, 1.035573094e-02f, 1.026529516e-02f, 1.017457286e-02f, 1.008356723e-02f, 
9.992281467e-03f, 9.900718779e-03f, 9.808882374e-03f, 9.716775469e-03f, 9.624401291e-03f, 9.531763072e-03f, 9.438864050e-03f, 9.345707471e-03f, 9.252296588e-03f, 9.158634660e-03f, 
9.064724950e-03f, 8.970570732e-03f, 8.876175283e-03f, 8.781541885e-03f, 8.686673829e-03f, 8.591574411e-03f, 8.496246930e-03f, 8.400694694e-03f, 8.304921015e-03f, 8.208929210e-03f, 
8.112722602e-03f, 8.016304518e-03f, 7.919678293e-03f, 7.822847262e-03f, 7.725814770e-03f, 7.628584163e-03f, 7.531158792e-03f, 7.433542014e-03f, 7.335737190e-03f, 7.237747685e-03f, 
7.139576866e-03f, 7.041228108e-03f, 6.942704786e-03f, 6.844010282e-03f, 6.745147979e-03f, 6.646121265e-03f, 6.546933531e-03f, 6.447588171e-03f, 6.348088584e-03f, 6.248438169e-03f, 
6.148640331e-03f, 6.048698475e-03f, 5.948616012e-03f, 5.848396352e-03f, 5.748042910e-03f, 5.647559102e-03f, 5.546948348e-03f, 5.446214069e-03f, 5.345359688e-03f, 5.244388629e-03f, 
5.143304320e-03f, 5.042110189e-03f, 4.940809666e-03f, 4.839406183e-03f, 4.737903173e-03f, 4.636304070e-03f, 4.534612309e-03f, 4.432831327e-03f, 4.330964560e-03f, 4.229015447e-03f, 
4.126987426e-03f, 4.024883937e-03f, 3.922708419e-03f, 3.820464311e-03f, 3.718155055e-03f, 3.615784090e-03f, 3.513354856e-03f, 3.410870793e-03f, 3.308335342e-03f, 3.205751941e-03f, 
3.103124029e-03f, 3.000455045e-03f, 2.897748427e-03f, 2.795007611e-03f, 2.692236032e-03f, 2.589437127e-03f, 2.486614327e-03f, 2.383771067e-03f, 2.280910776e-03f, 2.178036884e-03f, 
2.075152819e-03f, 1.972262006e-03f, 1.869367871e-03f, 1.766473836e-03f, 1.663583320e-03f, 1.560699742e-03f, 1.457826517e-03f, 1.354967059e-03f, 1.252124779e-03f, 1.149303085e-03f, 
1.046505381e-03f, 9.437350717e-04f, 8.409955556e-04f, 7.382902294e-04f, 6.356224864e-04f, 5.329957168e-04f, 4.304133072e-04f, 3.278786407e-04f, 2.253950969e-04f, 1.229660514e-04f, 
2.059487619e-05f, -8.171506078e-05f, -1.839603956e-04f, -2.861377687e-04f, -3.882438245e-04f, -4.902752120e-04f, -5.922285848e-04f, -6.941006010e-04f, -7.958879232e-04f, -8.975872193e-04f, 
-9.991951618e-04f, -1.100708428e-03f, -1.202123702e-03f, -1.303437670e-03f, -1.404647026e-03f, -1.505748470e-03f, -1.606738705e-03f, -1.707614442e-03f, -1.808372396e-03f, -1.909009290e-03f, 
-2.009521852e-03f, -2.109906815e-03f, -2.210160919e-03f, -2.310280911e-03f, -2.410263544e-03f, -2.510105577e-03f, -2.609803777e-03f, -2.709354916e-03f, -2.808755773e-03f, -2.908003136e-03f, 
-3.007093797e-03f, -3.106024558e-03f, -3.204792227e-03f, -3.303393619e-03f, -3.401825556e-03f, -3.500084869e-03f, -3.598168397e-03f, -3.696072984e-03f, -3.793795485e-03f, -3.891332760e-03f, 
-3.988681680e-03f, -4.085839122e-03f, -4.182801972e-03f, -4.279567125e-03f, -4.376131483e-03f, -4.472491957e-03f, -4.568645468e-03f, -4.664588945e-03f, -4.760319324e-03f, -4.855833552e-03f, 
-4.951128585e-03f, -5.046201388e-03f, -5.141048933e-03f, -5.235668205e-03f, -5.330056196e-03f, -5.424209908e-03f, -5.518126352e-03f, -5.611802550e-03f, -5.705235533e-03f, -5.798422342e-03f, 
-5.891360027e-03f, -5.984045651e-03f, -6.076476284e-03f, -6.168649008e-03f, -6.260560913e-03f, -6.352209104e-03f, -6.443590691e-03f, -6.534702799e-03f, -6.625542561e-03f, -6.716107122e-03f, 
-6.806393638e-03f, -6.896399276e-03f, -6.986121212e-03f, -7.075556636e-03f, -7.164702748e-03f, -7.253556759e-03f, -7.342115891e-03f, -7.430377380e-03f, -7.518338470e-03f, -7.605996419e-03f, 
-7.693348496e-03f, -7.780391982e-03f, -7.867124169e-03f, -7.953542364e-03f, -8.039643881e-03f, -8.125426051e-03f, -8.210886215e-03f, -8.296021725e-03f, -8.380829949e-03f, -8.465308264e-03f, 
-8.549454061e-03f, -8.633264744e-03f, -8.716737730e-03f, -8.799870446e-03f, -8.882660336e-03f, -8.965104853e-03f, -9.047201466e-03f, -9.128947656e-03f, -9.210340917e-03f, -9.291378756e-03f, 
-9.372058693e-03f, -9.452378264e-03f, -9.532335015e-03f, -9.611926508e-03f, -9.691150316e-03f, -9.770004029e-03f, -9.848485249e-03f, -9.926591592e-03f, -1.000432069e-02f, -1.008167018e-02f, 
-1.015863772e-02f, -1.023522099e-02f, -1.031141768e-02f, -1.038722547e-02f, -1.046264210e-02f, -1.053766528e-02f, -1.061229276e-02f, -1.068652229e-02f, -1.076035166e-02f, -1.083377865e-02f, 
-1.090680105e-02f, -1.097941670e-02f, -1.105162341e-02f, -1.112341903e-02f, -1.119480143e-02f, -1.126576848e-02f, -1.133631808e-02f, -1.140644813e-02f, -1.147615655e-02f, -1.154544128e-02f, 
-1.161430027e-02f, -1.168273150e-02f, -1.175073293e-02f, -1.181830258e-02f, -1.188543846e-02f, -1.195213859e-02f, -1.201840103e-02f, -1.208422383e-02f, -1.214960507e-02f, -1.221454284e-02f, 
-1.227903526e-02f, -1.234308044e-02f, -1.240667654e-02f, -1.246982170e-02f, -1.253251410e-02f, -1.259475193e-02f, -1.265653339e-02f, -1.271785670e-02f, -1.277872011e-02f, -1.283912186e-02f, 
-1.289906024e-02f, -1.295853352e-02f, -1.301754000e-02f, -1.307607802e-02f, -1.313414590e-02f, -1.319174200e-02f, -1.324886469e-02f, -1.330551235e-02f, -1.336168339e-02f, -1.341737623e-02f, 
-1.347258931e-02f, -1.352732108e-02f, -1.358157001e-02f, -1.363533460e-02f, -1.368861333e-02f, -1.374140474e-02f, -1.379370737e-02f, -1.384551977e-02f, -1.389684052e-02f, -1.394766820e-02f, 
-1.399800143e-02f, -1.404783882e-02f, -1.409717903e-02f, -1.414602070e-02f, -1.419436253e-02f, -1.424220320e-02f, -1.428954142e-02f, -1.433637593e-02f, -1.438270548e-02f, -1.442852881e-02f, 
-1.447384473e-02f, -1.451865202e-02f, -1.456294951e-02f, -1.460673603e-02f, -1.465001043e-02f, -1.469277159e-02f, -1.473501839e-02f, -1.477674974e-02f, -1.481796456e-02f, -1.485866179e-02f, 
-1.489884039e-02f, -1.493849934e-02f, -1.497763764e-02f, -1.501625430e-02f, -1.505434835e-02f, -1.509191883e-02f, -1.512896482e-02f, -1.516548540e-02f, -1.520147967e-02f, -1.523694676e-02f, 
-1.527188579e-02f, -1.530629594e-02f, -1.534017638e-02f, -1.537352629e-02f, -1.540634489e-02f, -1.543863141e-02f, -1.547038510e-02f, -1.550160523e-02f, -1.553229107e-02f, -1.556244193e-02f, 
-1.559205713e-02f, -1.562113601e-02f, -1.564967792e-02f, -1.567768225e-02f, -1.570514838e-02f, -1.573207573e-02f, -1.575846372e-02f, -1.578431180e-02f, -1.580961945e-02f, -1.583438614e-02f, 
-1.585861139e-02f, -1.588229470e-02f, -1.590543562e-02f, -1.592803371e-02f, -1.595008854e-02f, -1.597159971e-02f, -1.599256683e-02f, -1.601298953e-02f, -1.603286747e-02f, -1.605220031e-02f, 
-1.607098773e-02f, -1.608922944e-02f, -1.610692517e-02f, -1.612407465e-02f, -1.614067765e-02f, -1.615673394e-02f, -1.617224332e-02f, -1.618720560e-02f, -1.620162061e-02f, -1.621548821e-02f, 
-1.622880827e-02f, -1.624158067e-02f, -1.625380532e-02f, -1.626548215e-02f, -1.627661109e-02f, -1.628719210e-02f, -1.629722517e-02f, -1.630671029e-02f, -1.631564748e-02f, -1.632403678e-02f, 
-1.633187822e-02f, -1.633917189e-02f, -1.634591786e-02f, -1.635211626e-02f, -1.635776719e-02f, -1.636287081e-02f, -1.636742728e-02f, -1.637143677e-02f, -1.637489947e-02f, -1.637781561e-02f, 
-1.638018542e-02f, -1.638200915e-02f, -1.638328707e-02f, -1.638401946e-02f, -1.638420663e-02f, -1.638384890e-02f, -1.638294661e-02f, -1.638150012e-02f, -1.637950982e-02f, -1.637697608e-02f, 
-1.637389933e-02f, -1.637027999e-02f, -1.636611852e-02f, -1.636141537e-02f, -1.635617103e-02f, -1.635038601e-02f, -1.634406081e-02f, -1.633719598e-02f, -1.632979207e-02f, -1.632184965e-02f, 
-1.631336932e-02f, -1.630435167e-02f, -1.629479733e-02f, -1.628470695e-02f, -1.627408117e-02f, -1.626292069e-02f, -1.625122619e-02f, -1.623899838e-02f, -1.622623799e-02f, -1.621294577e-02f, 
-1.619912248e-02f, -1.618476889e-02f, -1.616988582e-02f, -1.615447407e-02f, -1.613853447e-02f, -1.612206787e-02f, -1.610507514e-02f, -1.608755715e-02f, -1.606951482e-02f, -1.605094905e-02f, 
-1.603186078e-02f, -1.601225096e-02f, -1.599212055e-02f, -1.597147054e-02f, -1.595030193e-02f, -1.592861573e-02f, -1.590641298e-02f, -1.588369473e-02f, -1.586046205e-02f, -1.583671601e-02f, 
-1.581245772e-02f, -1.578768829e-02f, -1.576240885e-02f, -1.573662056e-02f, -1.571032458e-02f, -1.568352208e-02f, -1.565621427e-02f, -1.562840236e-02f, -1.560008757e-02f, -1.557127115e-02f, 
-1.554195437e-02f, -1.551213849e-02f, -1.548182482e-02f, -1.545101466e-02f, -1.541970932e-02f, -1.538791017e-02f, -1.535561854e-02f, -1.532283581e-02f, -1.528956336e-02f, -1.525580261e-02f, 
-1.522155495e-02f, -1.518682184e-02f, -1.515160471e-02f, -1.511590503e-02f, -1.507972427e-02f, -1.504306393e-02f, -1.500592552e-02f, -1.496831056e-02f, -1.493022059e-02f, -1.489165717e-02f, 
-1.485262185e-02f, -1.481311623e-02f, -1.477314189e-02f, -1.473270046e-02f, -1.469179356e-02f, -1.465042282e-02f, -1.460858991e-02f, -1.456629650e-02f, -1.452354427e-02f, -1.448033491e-02f, 
-1.443667014e-02f, -1.439255169e-02f, -1.434798130e-02f, -1.430296071e-02f, -1.425749171e-02f, -1.421157607e-02f, -1.416521560e-02f, -1.411841209e-02f, -1.407116737e-02f, -1.402348328e-02f, 
-1.397536167e-02f, -1.392680441e-02f, -1.387781337e-02f, -1.382839044e-02f, -1.377853752e-02f, -1.372825654e-02f, -1.367754943e-02f, -1.362641812e-02f, -1.357486457e-02f, -1.352289076e-02f, 
-1.347049866e-02f, -1.341769027e-02f, -1.336446759e-02f, -1.331083265e-02f, -1.325678747e-02f, -1.320233411e-02f, -1.314747461e-02f, -1.309221105e-02f, -1.303654551e-02f, -1.298048009e-02f, 
-1.292401688e-02f, -1.286715801e-02f, -1.280990560e-02f, -1.275226180e-02f, -1.269422875e-02f, -1.263580863e-02f, -1.257700361e-02f, -1.251781588e-02f, -1.245824763e-02f, -1.239830108e-02f, 
-1.233797845e-02f, -1.227728197e-02f, -1.221621388e-02f, -1.215477644e-02f, -1.209297192e-02f, -1.203080259e-02f, -1.196827073e-02f, -1.190537866e-02f, -1.184212867e-02f, -1.177852308e-02f, 
-1.171456423e-02f, -1.165025446e-02f, -1.158559610e-02f, -1.152059154e-02f, -1.145524312e-02f, -1.138955324e-02f, -1.132352429e-02f, -1.125715867e-02f, -1.119045878e-02f, -1.112342704e-02f, 
-1.105606589e-02f, -1.098837777e-02f, -1.092036511e-02f, -1.085203039e-02f, -1.078337606e-02f, -1.071440460e-02f, -1.064511849e-02f, -1.057552024e-02f, -1.050561233e-02f, -1.043539730e-02f, 
-1.036487764e-02f, -1.029405590e-02f, -1.022293461e-02f, -1.015151631e-02f, -1.007980356e-02f, -1.000779893e-02f, -9.935504976e-03f, -9.862924283e-03f, -9.790059438e-03f, -9.716913035e-03f, 
-9.643487676e-03f, -9.569785970e-03f, -9.495810536e-03f, -9.421563998e-03f, -9.347048989e-03f, -9.272268149e-03f, -9.197224124e-03f, -9.121919569e-03f, -9.046357146e-03f, -8.970539521e-03f, 
-8.894469372e-03f, -8.818149379e-03f, -8.741582231e-03f, -8.664770623e-03f, -8.587717258e-03f, -8.510424843e-03f, -8.432896092e-03f, -8.355133726e-03f, -8.277140473e-03f, -8.198919065e-03f, 
-8.120472240e-03f, -8.041802744e-03f, -7.962913326e-03f, -7.883806743e-03f, -7.804485756e-03f, -7.724953133e-03f, -7.645211646e-03f, -7.565264072e-03f, -7.485113194e-03f, -7.404761801e-03f, 
-7.324212684e-03f, -7.243468643e-03f, -7.162532480e-03f, -7.081407002e-03f, -7.000095021e-03f, -6.918599353e-03f, -6.836922819e-03f, -6.755068246e-03f, -6.673038461e-03f, -6.590836298e-03f, 
-6.508464595e-03f, -6.425926194e-03f, -6.343223939e-03f, -6.260360680e-03f, -6.177339270e-03f, -6.094162564e-03f, -6.010833422e-03f, -5.927354708e-03f, -5.843729287e-03f, -5.759960029e-03f, 
-5.676049807e-03f, -5.592001495e-03f, -5.507817972e-03f, -5.423502120e-03f, -5.339056821e-03f, -5.254484962e-03f, -5.169789432e-03f, -5.084973122e-03f, -5.000038925e-03f, -4.914989736e-03f, 
-4.829828455e-03f, -4.744557979e-03f, -4.659181211e-03f, -4.573701053e-03f, -4.488120412e-03f, -4.402442193e-03f, -4.316669304e-03f, -4.230804655e-03f, -4.144851157e-03f, -4.058811721e-03f, 
-3.972689261e-03f, -3.886486691e-03f, -3.800206925e-03f, -3.713852880e-03f, -3.627427472e-03f, -3.540933618e-03f, -3.454374235e-03f, -3.367752243e-03f, -3.281070558e-03f, -3.194332100e-03f, 
-3.107539787e-03f, -3.020696539e-03f, -2.933805273e-03f, -2.846868909e-03f, -2.759890365e-03f, -2.672872558e-03f, -2.585818406e-03f, -2.498730826e-03f, -2.411612734e-03f, -2.324467046e-03f, 
-2.237296677e-03f, -2.150104540e-03f, -2.062893547e-03f, -1.975666611e-03f, -1.888426642e-03f, -1.801176549e-03f, -1.713919239e-03f, -1.626657619e-03f, -1.539394593e-03f, -1.452133064e-03f, 
-1.364875933e-03f, -1.277626099e-03f, -1.190386459e-03f, -1.103159908e-03f, -1.015949339e-03f, -9.287576430e-04f, -8.415877076e-04f, -7.544424188e-04f, -6.673246597e-04f, -5.802373109e-04f, 
-4.931832501e-04f, -4.061653523e-04f, -3.191864894e-04f, -2.322495305e-04f, -1.453573415e-04f, -5.851278481e-05f, 2.828128008e-05f, 1.150219973e-04f, 2.017065144e-04f, 2.883319825e-04f, 
3.748955566e-04f, 4.613943952e-04f, 5.478256607e-04f, 6.341865198e-04f, 7.204741427e-04f, 8.066857042e-04f, 8.928183831e-04f, 9.788693627e-04f, 1.064835830e-03f, 1.150714979e-03f, 
1.236504004e-03f, 1.322200107e-03f, 1.407800495e-03f, 1.493302379e-03f, 1.578702975e-03f, 1.663999503e-03f, 1.749189190e-03f, 1.834269267e-03f, 1.919236971e-03f, 2.004089545e-03f, 
2.088824235e-03f, 2.173438295e-03f, 2.257928984e-03f, 2.342293566e-03f, 2.426529312e-03f, 2.510633499e-03f, 2.594603408e-03f, 2.678436328e-03f, 2.762129554e-03f, 2.845680387e-03f, 
2.929086134e-03f, 3.012344109e-03f, 3.095451633e-03f, 3.178406032e-03f, 3.261204640e-03f, 3.343844797e-03f, 3.426323851e-03f, 3.508639156e-03f, 3.590788073e-03f, 3.672767971e-03f, 
3.754576225e-03f, 3.836210219e-03f, 3.917667342e-03f, 3.998944993e-03f, 4.080040576e-03f, 4.160951505e-03f, 4.241675200e-03f, 4.322209090e-03f, 4.402550611e-03f, 4.482697207e-03f, 
4.562646331e-03f, 4.642395442e-03f, 4.721942009e-03f, 4.801283510e-03f, 4.880417428e-03f, 4.959341259e-03f, 5.038052503e-03f, 5.116548672e-03f, 5.194827285e-03f, 5.272885869e-03f, 
5.350721962e-03f, 5.428333109e-03f, 5.505716865e-03f, 5.582870794e-03f, 5.659792469e-03f, 5.736479470e-03f, 5.812929391e-03f, 5.889139831e-03f, 5.965108401e-03f, 6.040832719e-03f, 
6.116310416e-03f, 6.191539129e-03f, 6.266516508e-03f, 6.341240210e-03f, 6.415707903e-03f, 6.489917265e-03f, 6.563865985e-03f, 6.637551760e-03f, 6.710972299e-03f, 6.784125319e-03f, 
6.857008550e-03f, 6.929619731e-03f, 7.001956610e-03f, 7.074016947e-03f, 7.145798514e-03f, 7.217299091e-03f, 7.288516470e-03f, 7.359448453e-03f, 7.430092854e-03f, 7.500447497e-03f, 
7.570510216e-03f, 7.640278858e-03f, 7.709751281e-03f, 7.778925352e-03f, 7.847798952e-03f, 7.916369970e-03f, 7.984636310e-03f, 8.052595884e-03f, 8.120246618e-03f, 8.187586449e-03f, 
8.254613324e-03f, 8.321325203e-03f, 8.387720059e-03f, 8.453795873e-03f, 8.519550642e-03f, 8.584982372e-03f, 8.650089082e-03f, 8.714868803e-03f, 8.779319578e-03f, 8.843439463e-03f, 
8.907226524e-03f, 8.970678841e-03f, 9.033794506e-03f, 9.096571623e-03f, 9.159008309e-03f, 9.221102693e-03f, 9.282852916e-03f, 9.344257133e-03f, 9.405313510e-03f, 9.466020227e-03f, 
9.526375475e-03f, 9.586377460e-03f, 9.646024400e-03f, 9.705314525e-03f, 9.764246079e-03f, 9.822817319e-03f, 9.881026513e-03f, 9.938871946e-03f, 9.996351911e-03f, 1.005346472e-02f, 
1.011020869e-02f, 1.016658217e-02f, 1.022258349e-02f, 1.027821103e-02f, 1.033346315e-02f, 1.038833825e-02f, 1.044283472e-02f, 1.049695100e-02f, 1.055068550e-02f, 1.060403666e-02f, 
1.065700295e-02f, 1.070958284e-02f, 1.076177481e-02f, 1.081357736e-02f, 1.086498900e-02f, 1.091600827e-02f, 1.096663368e-02f, 1.101686381e-02f, 1.106669723e-02f, 1.111613250e-02f, 
1.116516824e-02f, 1.121380304e-02f, 1.126203554e-02f, 1.130986437e-02f, 1.135728819e-02f, 1.140430566e-02f, 1.145091547e-02f, 1.149711631e-02f, 1.154290689e-02f, 1.158828594e-02f, 
1.163325220e-02f, 1.167780442e-02f, 1.172194136e-02f, 1.176566182e-02f, 1.180896458e-02f, 1.185184847e-02f, 1.189431230e-02f, 1.193635493e-02f, 1.197797520e-02f, 1.201917198e-02f, 
1.205994417e-02f, 1.210029066e-02f, 1.214021037e-02f, 1.217970223e-02f, 1.221876518e-02f, 1.225739818e-02f, 1.229560022e-02f, 1.233337026e-02f, 1.237070734e-02f, 1.240761045e-02f, 
1.244407864e-02f, 1.248011096e-02f, 1.251570648e-02f, 1.255086426e-02f, 1.258558341e-02f, 1.261986304e-02f, 1.265370227e-02f, 1.268710025e-02f, 1.272005612e-02f, 1.275256907e-02f, 
1.278463827e-02f, 1.281626294e-02f, 1.284744227e-02f, 1.287817552e-02f, 1.290846192e-02f, 1.293830074e-02f, 1.296769125e-02f, 1.299663275e-02f, 1.302512455e-02f, 1.305316597e-02f, 
1.308075636e-02f, 1.310789506e-02f, 1.313458144e-02f, 1.316081490e-02f, 1.318659484e-02f, 1.321192066e-02f, 1.323679181e-02f, 1.326120772e-02f, 1.328516787e-02f, 1.330867174e-02f, 
1.333171881e-02f, 1.335430859e-02f, 1.337644061e-02f, 1.339811442e-02f, 1.341932956e-02f, 1.344008561e-02f, 1.346038216e-02f, 1.348021881e-02f, 1.349959517e-02f, 1.351851089e-02f, 
1.353696560e-02f, 1.355495898e-02f, 1.357249070e-02f, 1.358956047e-02f, 1.360616799e-02f, 1.362231299e-02f, 1.363799521e-02f, 1.365321441e-02f, 1.366797037e-02f, 1.368226287e-02f, 
1.369609172e-02f, 1.370945673e-02f, 1.372235776e-02f, 1.373479463e-02f, 1.374676724e-02f, 1.375827544e-02f, 1.376931916e-02f, 1.377989828e-02f, 1.379001276e-02f, 1.379966252e-02f, 
1.380884754e-02f, 1.381756778e-02f, 1.382582324e-02f, 1.383361393e-02f, 1.384093986e-02f, 1.384780107e-02f, 1.385419762e-02f, 1.386012957e-02f, 1.386559701e-02f, 1.387060004e-02f, 
1.387513877e-02f, 1.387921333e-02f, 1.388282386e-02f, 1.388597053e-02f, 1.388865352e-02f, 1.389087301e-02f, 1.389262920e-02f, 1.389392234e-02f, 1.389475264e-02f, 1.389512036e-02f, 
1.389502577e-02f, 1.389446915e-02f, 1.389345080e-02f, 1.389197103e-02f, 1.389003018e-02f, 1.388762858e-02f, 1.388476659e-02f, 1.388144459e-02f, 1.387766296e-02f, 1.387342212e-02f, 
1.386872247e-02f, 1.386356445e-02f, 1.385794852e-02f, 1.385187513e-02f, 1.384534476e-02f, 1.383835791e-02f, 1.383091508e-02f, 1.382301681e-02f, 1.381466362e-02f, 1.380585607e-02f, 
1.379659472e-02f, 1.378688017e-02f, 1.377671301e-02f, 1.376609385e-02f, 1.375502331e-02f, 1.374350204e-02f, 1.373153069e-02f, 1.371910994e-02f, 1.370624047e-02f, 1.369292297e-02f, 
1.367915817e-02f, 1.366494679e-02f, 1.365028957e-02f, 1.363518728e-02f, 1.361964068e-02f, 1.360365056e-02f, 1.358721771e-02f, 1.357034296e-02f, 1.355302714e-02f, 1.353527107e-02f, 
1.351707563e-02f, 1.349844169e-02f, 1.347937012e-02f, 1.345986183e-02f, 1.343991773e-02f, 1.341953875e-02f, 1.339872583e-02f, 1.337747992e-02f, 1.335580199e-02f, 1.333369303e-02f, 
1.331115403e-02f, 1.328818600e-02f, 1.326478997e-02f, 1.324096697e-02f, 1.321671805e-02f, 1.319204428e-02f, 1.316694674e-02f, 1.314142651e-02f, 1.311548470e-02f, 1.308912243e-02f, 
1.306234084e-02f, 1.303514106e-02f, 1.300752425e-02f, 1.297949158e-02f, 1.295104425e-02f, 1.292218344e-02f, 1.289291037e-02f, 1.286322625e-02f, 1.283313233e-02f, 1.280262986e-02f, 
1.277172009e-02f, 1.274040430e-02f, 1.270868379e-02f, 1.267655984e-02f, 1.264403377e-02f, 1.261110691e-02f, 1.257778059e-02f, 1.254405617e-02f, 1.250993501e-02f, 1.247541848e-02f, 
1.244050797e-02f, 1.240520488e-02f, 1.236951063e-02f, 1.233342663e-02f, 1.229695432e-02f, 1.226009516e-02f, 1.222285060e-02f, 1.218522211e-02f, 1.214721118e-02f, 1.210881930e-02f, 
1.207004798e-02f, 1.203089875e-02f, 1.199137313e-02f, 1.195147266e-02f, 1.191119890e-02f, 1.187055341e-02f, 1.182953778e-02f, 1.178815359e-02f, 1.174640244e-02f, 1.170428594e-02f, 
1.166180571e-02f, 1.161896339e-02f, 1.157576062e-02f, 1.153219906e-02f, 1.148828037e-02f, 1.144400623e-02f, 1.139937833e-02f, 1.135439837e-02f, 1.130906805e-02f, 1.126338910e-02f, 
1.121736324e-02f, 1.117099223e-02f, 1.112427780e-02f, 1.107722172e-02f, 1.102982577e-02f, 1.098209173e-02f, 1.093402139e-02f, 1.088561654e-02f, 1.083687901e-02f, 1.078781062e-02f, 
1.073841320e-02f, 1.068868859e-02f, 1.063863865e-02f, 1.058826523e-02f, 1.053757021e-02f, 1.048655548e-02f, 1.043522291e-02f, 1.038357441e-02f, 1.033161189e-02f, 1.027933727e-02f, 
1.022675248e-02f, 1.017385945e-02f, 1.012066013e-02f, 1.006715648e-02f, 1.001335045e-02f, 9.959244032e-03f, 9.904839195e-03f, 9.850137933e-03f, 9.795142245e-03f, 9.739854140e-03f, 
9.684275632e-03f, 9.628408749e-03f, 9.572255521e-03f, 9.515817992e-03f, 9.459098210e-03f, 9.402098233e-03f, 9.344820128e-03f, 9.287265969e-03f, 9.229437836e-03f, 9.171337820e-03f, 
9.112968019e-03f, 9.054330537e-03f, 8.995427487e-03f, 8.936260990e-03f, 8.876833174e-03f, 8.817146173e-03f, 8.757202132e-03f, 8.697003198e-03f, 8.636551530e-03f, 8.575849291e-03f, 
8.514898654e-03f, 8.453701795e-03f, 8.392260900e-03f, 8.330578160e-03f, 8.268655775e-03f, 8.206495949e-03f, 8.144100895e-03f, 8.081472829e-03f, 8.018613978e-03f, 7.955526571e-03f, 
7.892212847e-03f, 7.828675048e-03f, 7.764915424e-03f, 7.700936230e-03f, 7.636739728e-03f, 7.572328186e-03f, 7.507703876e-03f, 7.442869077e-03f, 7.377826074e-03f, 7.312577156e-03f, 
7.247124619e-03f, 7.181470764e-03f, 7.115617897e-03f, 7.049568329e-03f, 6.983324377e-03f, 6.916888362e-03f, 6.850262611e-03f, 6.783449455e-03f, 6.716451231e-03f, 6.649270279e-03f, 
6.581908946e-03f, 6.514369581e-03f, 6.446654540e-03f, 6.378766180e-03f, 6.310706867e-03f, 6.242478968e-03f, 6.174084854e-03f, 6.105526902e-03f, 6.036807492e-03f, 5.967929007e-03f, 
5.898893836e-03f, 5.829704371e-03f, 5.760363006e-03f, 5.690872140e-03f, 5.621234176e-03f, 5.551451520e-03f, 5.481526581e-03f, 5.411461771e-03f, 5.341259506e-03f, 5.270922205e-03f, 
5.200452290e-03f, 5.129852185e-03f, 5.059124319e-03f, 4.988271120e-03f, 4.917295024e-03f, 4.846198465e-03f, 4.774983881e-03f, 4.703653714e-03f, 4.632210406e-03f, 4.560656402e-03f, 
4.488994151e-03f, 4.417226102e-03f, 4.345354707e-03f, 4.273382419e-03f, 4.201311694e-03f, 4.129144989e-03f, 4.056884763e-03f, 3.984533477e-03f, 3.912093593e-03f, 3.839567575e-03f, 
3.766957888e-03f, 3.694266998e-03f, 3.621497373e-03f, 3.548651480e-03f, 3.475731791e-03f, 3.402740775e-03f, 3.329680905e-03f, 3.256554651e-03f, 3.183364489e-03f, 3.110112890e-03f, 
3.036802330e-03f, 2.963435282e-03f, 2.890014223e-03f, 2.816541627e-03f, 2.743019969e-03f, 2.669451727e-03f, 2.595839374e-03f, 2.522185388e-03f, 2.448492243e-03f, 2.374762416e-03f, 
2.300998380e-03f, 2.227202611e-03f, 2.153377584e-03f, 2.079525771e-03f, 2.005649646e-03f, 1.931751682e-03f, 1.857834350e-03f, 1.783900122e-03f, 1.709951466e-03f, 1.635990852e-03f, 
1.562020748e-03f, 1.488043621e-03f, 1.414061935e-03f, 1.340078155e-03f, 1.266094743e-03f, 1.192114160e-03f, 1.118138867e-03f, 1.044171320e-03f, 9.702139755e-04f, 8.962692884e-04f, 
8.223397107e-04f, 7.484276927e-04f, 6.745356828e-04f, 6.006661270e-04f, 5.268214693e-04f, 4.530041512e-04f, 3.792166120e-04f, 3.054612883e-04f, 2.317406143e-04f, 1.580570217e-04f, 
8.441293920e-05f, 1.081079289e-05f, -6.274699405e-05f, -1.362580014e-04f, -2.097198119e-04f, -2.831300115e-04f, -3.564861892e-04f, -4.297859373e-04f, -5.030268517e-04f, -5.762065312e-04f, 
-6.493225786e-04f, -7.223725999e-04f, -7.953542049e-04f, -8.682650073e-04f, -9.411026243e-04f, -1.013864677e-03f, -1.086548791e-03f, -1.159152595e-03f, -1.231673723e-03f, -1.304109811e-03f, 
-1.376458503e-03f, -1.448717443e-03f, -1.520884283e-03f, -1.592956678e-03f, -1.664932286e-03f, -1.736808773e-03f, -1.808583807e-03f, -1.880255062e-03f, -1.951820216e-03f, -2.023276953e-03f, 
-2.094622963e-03f, -2.165855937e-03f, -2.236973575e-03f, -2.307973582e-03f, -2.378853666e-03f, -2.449611542e-03f, -2.520244930e-03f, -2.590751557e-03f, -2.661129153e-03f, -2.731375455e-03f, 
-2.801488206e-03f, -2.871465155e-03f, -2.941304056e-03f, -3.011002669e-03f, -3.080558761e-03f, -3.149970104e-03f, -3.219234477e-03f, -3.288349665e-03f, -3.357313459e-03f, -3.426123657e-03f, 
-3.494778062e-03f, -3.563274486e-03f, -3.631610745e-03f, -3.699784664e-03f, -3.767794072e-03f, -3.835636807e-03f, -3.903310714e-03f, -3.970813643e-03f, -4.038143453e-03f, -4.105298008e-03f, 
-4.172275182e-03f, -4.239072853e-03f, -4.305688908e-03f, -4.372121241e-03f, -4.438367755e-03f, -4.504426357e-03f, -4.570294964e-03f, -4.635971501e-03f, -4.701453899e-03f, -4.766740097e-03f, 
-4.831828043e-03f, -4.896715691e-03f, -4.961401005e-03f, -5.025881956e-03f, -5.090156522e-03f, -5.154222691e-03f, -5.218078458e-03f, -5.281721825e-03f, -5.345150806e-03f, -5.408363420e-03f, 
-5.471357695e-03f, -5.534131669e-03f, -5.596683386e-03f, -5.659010901e-03f, -5.721112277e-03f, -5.782985585e-03f, -5.844628905e-03f, -5.906040326e-03f, -5.967217946e-03f, -6.028159872e-03f, 
-6.088864219e-03f, -6.149329113e-03f, -6.209552687e-03f, -6.269533084e-03f, -6.329268457e-03f, -6.388756967e-03f, -6.447996785e-03f, -6.506986092e-03f, -6.565723077e-03f, -6.624205940e-03f, 
-6.682432890e-03f, -6.740402144e-03f, -6.798111931e-03f, -6.855560489e-03f, -6.912746065e-03f, -6.969666917e-03f, -7.026321312e-03f, -7.082707527e-03f, -7.138823849e-03f, -7.194668576e-03f, 
-7.250240014e-03f, -7.305536482e-03f, -7.360556305e-03f, -7.415297824e-03f, -7.469759385e-03f, -7.523939346e-03f, -7.577836077e-03f, -7.631447957e-03f, -7.684773374e-03f, -7.737810731e-03f, 
-7.790558436e-03f, -7.843014912e-03f, -7.895178590e-03f, -7.947047913e-03f, -7.998621335e-03f, -8.049897319e-03f, -8.100874340e-03f, -8.151550885e-03f, -8.201925451e-03f, -8.251996544e-03f, 
-8.301762685e-03f, -8.351222402e-03f, -8.400374236e-03f, -8.449216741e-03f, -8.497748478e-03f, -8.545968023e-03f, -8.593873961e-03f, -8.641464889e-03f, -8.688739415e-03f, -8.735696160e-03f, 
-8.782333754e-03f, -8.828650840e-03f, -8.874646073e-03f, -8.920318117e-03f, -8.965665649e-03f, -9.010687360e-03f, -9.055381949e-03f, -9.099748128e-03f, -9.143784621e-03f, -9.187490164e-03f, 
-9.230863504e-03f, -9.273903400e-03f, -9.316608623e-03f, -9.358977957e-03f, -9.401010196e-03f, -9.442704146e-03f, -9.484058628e-03f, -9.525072471e-03f, -9.565744518e-03f, -9.606073625e-03f, 
-9.646058658e-03f, -9.685698496e-03f, -9.724992031e-03f, -9.763938167e-03f, -9.802535819e-03f, -9.840783916e-03f, -9.878681397e-03f, -9.916227215e-03f, -9.953420336e-03f, -9.990259736e-03f, 
-1.002674441e-02f, -1.006287335e-02f, -1.009864558e-02f, -1.013406012e-02f, -1.016911601e-02f, -1.020381231e-02f, -1.023814808e-02f, -1.027212239e-02f, -1.030573435e-02f, -1.033898304e-02f, 
-1.037186759e-02f, -1.040438712e-02f, -1.043654077e-02f, -1.046832769e-02f, -1.049974706e-02f, -1.053079805e-02f, -1.056147985e-02f, -1.059179167e-02f, -1.062173271e-02f, -1.065130223e-02f, 
-1.068049944e-02f, -1.070932362e-02f, -1.073777402e-02f, -1.076584994e-02f, -1.079355066e-02f, -1.082087548e-02f, -1.084782375e-02f, -1.087439477e-02f, -1.090058790e-02f, -1.092640251e-02f, 
-1.095183795e-02f, -1.097689362e-02f, -1.100156891e-02f, -1.102586324e-02f, -1.104977602e-02f, -1.107330670e-02f, -1.109645472e-02f, -1.111921955e-02f, -1.114160067e-02f, -1.116359756e-02f, 
-1.118520972e-02f, -1.120643668e-02f, -1.122727795e-02f, -1.124773309e-02f, -1.126780165e-02f, -1.128748319e-02f, -1.130677729e-02f, -1.132568356e-02f, -1.134420159e-02f, -1.136233101e-02f, 
-1.138007145e-02f, -1.139742256e-02f, -1.141438400e-02f, -1.143095545e-02f, -1.144713658e-02f, -1.146292710e-02f, -1.147832672e-02f, -1.149333517e-02f, -1.150795218e-02f, -1.152217752e-02f, 
-1.153601094e-02f, -1.154945222e-02f, -1.156250116e-02f, -1.157515756e-02f, -1.158742123e-02f, -1.159929202e-02f, -1.161076976e-02f, -1.162185432e-02f, -1.163254556e-02f, -1.164284337e-02f, 
-1.165274765e-02f, -1.166225830e-02f, -1.167137525e-02f, -1.168009844e-02f, -1.168842782e-02f, -1.169636334e-02f, -1.170390500e-02f, -1.171105276e-02f, -1.171780665e-02f, -1.172416667e-02f, 
-1.173013286e-02f, -1.173570525e-02f, -1.174088390e-02f, -1.174566888e-02f, -1.175006026e-02f, -1.175405815e-02f, -1.175766265e-02f, -1.176087389e-02f, -1.176369198e-02f, -1.176611708e-02f, 
-1.176814936e-02f, -1.176978897e-02f, -1.177103611e-02f, -1.177189098e-02f, -1.177235378e-02f, -1.177242474e-02f, -1.177210409e-02f, -1.177139210e-02f, -1.177028901e-02f, -1.176879511e-02f, 
-1.176691067e-02f, -1.176463602e-02f, -1.176197145e-02f, -1.175891729e-02f, -1.175547389e-02f, -1.175164160e-02f, -1.174742077e-02f, -1.174281180e-02f, -1.173781507e-02f, -1.173243098e-02f, 
-1.172665994e-02f, -1.172050240e-02f, -1.171395878e-02f, -1.170702954e-02f, -1.169971515e-02f, -1.169201609e-02f, -1.168393284e-02f, -1.167546592e-02f, -1.166661583e-02f, -1.165738310e-02f, 
-1.164776829e-02f, -1.163777193e-02f, -1.162739460e-02f, -1.161663687e-02f, -1.160549934e-02f, -1.159398260e-02f, -1.158208728e-02f, -1.156981399e-02f, -1.155716338e-02f, -1.154413610e-02f, 
-1.153073282e-02f, -1.151695420e-02f, -1.150280094e-02f, -1.148827374e-02f, -1.147337330e-02f, -1.145810036e-02f, -1.144245565e-02f, -1.142643991e-02f, -1.141005391e-02f, -1.139329841e-02f, 
-1.137617421e-02f, -1.135868209e-02f, -1.134082287e-02f, -1.132259736e-02f, -1.130400639e-02f, -1.128505080e-02f, -1.126573145e-02f, -1.124604921e-02f, -1.122600494e-02f, -1.120559954e-02f, 
-1.118483391e-02f, -1.116370896e-02f, -1.114222561e-02f, -1.112038480e-02f, -1.109818746e-02f, -1.107563457e-02f, -1.105272708e-02f, -1.102946597e-02f, -1.100585224e-02f, -1.098188689e-02f, 
-1.095757092e-02f, -1.093290536e-02f, -1.090789126e-02f, -1.088252964e-02f, -1.085682158e-02f, -1.083076813e-02f, -1.080437037e-02f, -1.077762940e-02f, -1.075054631e-02f, -1.072312221e-02f, 
-1.069535823e-02f, -1.066725549e-02f, -1.063881515e-02f, -1.061003834e-02f, -1.058092624e-02f, -1.055148002e-02f, -1.052170087e-02f, -1.049158997e-02f, -1.046114853e-02f, -1.043037777e-02f, 
-1.039927892e-02f, -1.036785320e-02f, -1.033610187e-02f, -1.030402618e-02f, -1.027162739e-02f, -1.023890679e-02f, -1.020586565e-02f, -1.017250528e-02f, -1.013882698e-02f, -1.010483206e-02f, 
-1.007052185e-02f, -1.003589768e-02f, -1.000096091e-02f, -9.965712873e-03f, -9.930154943e-03f, -9.894288492e-03f, -9.858114902e-03f, -9.821635565e-03f, -9.784851881e-03f, -9.747765261e-03f, 
-9.710377125e-03f, -9.672688900e-03f, -9.634702026e-03f, -9.596417949e-03f, -9.557838125e-03f, -9.518964019e-03f, -9.479797104e-03f, -9.440338864e-03f, -9.400590789e-03f, -9.360554380e-03f, 
-9.320231145e-03f, -9.279622603e-03f, -9.238730278e-03f, -9.197555707e-03f, -9.156100430e-03f, -9.114366001e-03f, -9.072353979e-03f, -9.030065932e-03f, -8.987503435e-03f, -8.944668075e-03f, 
-8.901561442e-03f, -8.858185138e-03f, -8.814540772e-03f, -8.770629959e-03f, -8.726454325e-03f, -8.682015501e-03f, -8.637315128e-03f, -8.592354853e-03f, -8.547136332e-03f, -8.501661228e-03f, 
-8.455931211e-03f, -8.409947958e-03f, -8.363713157e-03f, -8.317228498e-03f, -8.270495683e-03f, -8.223516418e-03f, -8.176292417e-03f, -8.128825403e-03f, -8.081117103e-03f, -8.033169254e-03f, 
-7.984983597e-03f, -7.936561881e-03f, -7.887905864e-03f, -7.839017306e-03f, -7.789897979e-03f, -7.740549658e-03f, -7.690974125e-03f, -7.641173170e-03f, -7.591148587e-03f, -7.540902179e-03f, 
-7.490435754e-03f, -7.439751126e-03f, -7.388850116e-03f, -7.337734549e-03f, -7.286406259e-03f, -7.234867084e-03f, -7.183118869e-03f, -7.131163463e-03f, -7.079002723e-03f, -7.026638510e-03f, 
-6.974072693e-03f, -6.921307142e-03f, -6.868343738e-03f, -6.815184364e-03f, -6.761830908e-03f, -6.708285267e-03f, -6.654549338e-03f, -6.600625028e-03f, -6.546514247e-03f, -6.492218909e-03f, 
-6.437740934e-03f, -6.383082247e-03f, -6.328244779e-03f, -6.273230464e-03f, -6.218041241e-03f, -6.162679053e-03f, -6.107145850e-03f, -6.051443584e-03f, -5.995574213e-03f, -5.939539699e-03f, 
-5.883342007e-03f, -5.826983108e-03f, -5.770464976e-03f, -5.713789590e-03f, -5.656958932e-03f, -5.599974990e-03f, -5.542839752e-03f, -5.485555215e-03f, -5.428123374e-03f, -5.370546233e-03f, 
-5.312825796e-03f, -5.254964073e-03f, -5.196963075e-03f, -5.138824818e-03f, -5.080551321e-03f, -5.022144607e-03f, -4.963606701e-03f, -4.904939631e-03f, -4.846145430e-03f, -4.787226131e-03f, 
-4.728183773e-03f, -4.669020396e-03f, -4.609738043e-03f, -4.550338759e-03f, -4.490824594e-03f, -4.431197599e-03f, -4.371459827e-03f, -4.311613334e-03f, -4.251660179e-03f, -4.191602422e-03f, 
-4.131442126e-03f, -4.071181357e-03f, -4.010822181e-03f, -3.950366667e-03f, -3.889816887e-03f, -3.829174914e-03f, -3.768442822e-03f, -3.707622688e-03f, -3.646716590e-03f, -3.585726607e-03f, 
-3.524654821e-03f, -3.463503315e-03f, -3.402274173e-03f, -3.340969480e-03f, -3.279591322e-03f, -3.218141788e-03f, -3.156622966e-03f, -3.095036946e-03f, -3.033385819e-03f, -2.971671677e-03f, 
-2.909896612e-03f, -2.848062718e-03f, -2.786172088e-03f, -2.724226818e-03f, -2.662229001e-03f, -2.600180735e-03f, -2.538084114e-03f, -2.475941236e-03f, -2.413754196e-03f, -2.351525091e-03f, 
-2.289256019e-03f, -2.226949076e-03f, -2.164606358e-03f, -2.102229964e-03f, -2.039821988e-03f, -1.977384529e-03f, -1.914919681e-03f, -1.852429540e-03f, -1.789916202e-03f, -1.727381762e-03f, 
-1.664828313e-03f, -1.602257949e-03f, -1.539672762e-03f, -1.477074846e-03f, -1.414466290e-03f, -1.351849186e-03f, -1.289225621e-03f, -1.226597685e-03f, -1.163967465e-03f, -1.101337045e-03f, 
-1.038708511e-03f, -9.760839463e-04f, -9.134654318e-04f, -8.508550480e-04f, -7.882548738e-04f, -7.256669863e-04f, -6.630934608e-04f, -6.005363711e-04f, -5.379977889e-04f, -4.754797843e-04f, 
-4.129844252e-04f, -3.505137776e-04f, -2.880699055e-04f, -2.256548704e-04f, -1.632707321e-04f, -1.009195475e-04f, -3.860337167e-05f, 2.367574307e-05f, 8.591574678e-05f, 1.481145921e-04f, 
2.102702343e-04f, 2.723806313e-04f, 3.344437439e-04f, 3.964575356e-04f, 4.584199728e-04f, 5.203290251e-04f, 5.821826647e-04f, 6.439788672e-04f, 7.057156113e-04f, 7.673908788e-04f, 
8.290026551e-04f, 8.905489285e-04f, 9.520276911e-04f, 1.013436938e-03f, 1.074774669e-03f, 1.136038886e-03f, 1.197227596e-03f, 1.258338807e-03f, 1.319370536e-03f, 1.380320798e-03f, 
1.441187615e-03f, 1.501969014e-03f, 1.562663024e-03f, 1.623267678e-03f, 1.683781015e-03f, 1.744201077e-03f, 1.804525910e-03f, 1.864753566e-03f, 1.924882099e-03f, 1.984909569e-03f, 
2.044834042e-03f, 2.104653585e-03f, 2.164366272e-03f, 2.223970183e-03f, 2.283463400e-03f, 2.342844011e-03f, 2.402110109e-03f, 2.461259793e-03f, 2.520291165e-03f, 2.579202334e-03f, 
2.637991412e-03f, 2.696656519e-03f, 2.755195779e-03f, 2.813607320e-03f, 2.871889277e-03f, 2.930039790e-03f, 2.988057004e-03f, 3.045939072e-03f, 3.103684149e-03f, 3.161290399e-03f, 
3.218755989e-03f, 3.276079093e-03f, 3.333257892e-03f, 3.390290571e-03f, 3.447175322e-03f, 3.503910343e-03f, 3.560493838e-03f, 3.616924017e-03f, 3.673199096e-03f, 3.729317299e-03f, 
3.785276853e-03f, 3.841075994e-03f, 3.896712964e-03f, 3.952186011e-03f, 4.007493389e-03f, 4.062633361e-03f, 4.117604194e-03f, 4.172404162e-03f, 4.227031547e-03f, 4.281484638e-03f, 
4.335761729e-03f, 4.389861122e-03f, 4.443781127e-03f, 4.497520059e-03f, 4.551076241e-03f, 4.604448003e-03f, 4.657633684e-03f, 4.710631626e-03f, 4.763440183e-03f, 4.816057712e-03f, 
4.868482582e-03f, 4.920713165e-03f, 4.972747843e-03f, 5.024585005e-03f, 5.076223047e-03f, 5.127660374e-03f, 5.178895397e-03f, 5.229926536e-03f, 5.280752218e-03f, 5.331370878e-03f, 
5.381780959e-03f, 5.431980912e-03f, 5.481969195e-03f, 5.531744276e-03f, 5.581304629e-03f, 5.630648737e-03f, 5.679775091e-03f, 5.728682190e-03f, 5.777368542e-03f, 5.825832663e-03f, 
5.874073076e-03f, 5.922088314e-03f, 5.969876918e-03f, 6.017437437e-03f, 6.064768429e-03f, 6.111868459e-03f, 6.158736104e-03f, 6.205369945e-03f, 6.251768576e-03f, 6.297930598e-03f, 
6.343854619e-03f, 6.389539258e-03f, 6.434983142e-03f, 6.480184908e-03f, 6.525143200e-03f, 6.569856672e-03f, 6.614323987e-03f, 6.658543817e-03f, 6.702514843e-03f, 6.746235755e-03f, 
6.789705251e-03f, 6.832922041e-03f, 6.875884842e-03f, 6.918592381e-03f, 6.961043394e-03f, 7.003236626e-03f, 7.045170832e-03f, 7.086844776e-03f, 7.128257232e-03f, 7.169406983e-03f, 
7.210292822e-03f, 7.250913550e-03f, 7.291267979e-03f, 7.331354931e-03f, 7.371173236e-03f, 7.410721736e-03f, 7.449999279e-03f, 7.489004727e-03f, 7.527736949e-03f, 7.566194825e-03f, 
7.604377243e-03f, 7.642283104e-03f, 7.679911317e-03f, 7.717260799e-03f, 7.754330482e-03f, 7.791119303e-03f, 7.827626211e-03f, 7.863850166e-03f, 7.899790136e-03f, 7.935445102e-03f, 
7.970814051e-03f, 8.005895984e-03f, 8.040689910e-03f, 8.075194850e-03f, 8.109409833e-03f, 8.143333899e-03f, 8.176966099e-03f, 8.210305494e-03f, 8.243351156e-03f, 8.276102165e-03f, 
8.308557615e-03f, 8.340716606e-03f, 8.372578253e-03f, 8.404141678e-03f, 8.435406015e-03f, 8.466370409e-03f, 8.497034013e-03f, 8.527395994e-03f, 8.557455527e-03f, 8.587211799e-03f, 
8.616664006e-03f, 8.645811357e-03f, 8.674653069e-03f, 8.703188372e-03f, 8.731416506e-03f, 8.759336719e-03f, 8.786948275e-03f, 8.814250444e-03f, 8.841242508e-03f, 8.867923762e-03f, 
8.894293510e-03f, 8.920351066e-03f, 8.946095756e-03f, 8.971526916e-03f, 8.996643895e-03f, 9.021446050e-03f, 9.045932750e-03f, 9.070103376e-03f, 9.093957318e-03f, 9.117493979e-03f, 
9.140712772e-03f, 9.163613119e-03f, 9.186194456e-03f, 9.208456228e-03f, 9.230397893e-03f, 9.252018918e-03f, 9.273318781e-03f, 9.294296973e-03f, 9.314952994e-03f, 9.335286355e-03f, 
9.355296581e-03f, 9.374983204e-03f, 9.394345769e-03f, 9.413383834e-03f, 9.432096964e-03f, 9.450484738e-03f, 9.468546745e-03f, 9.486282586e-03f, 9.503691873e-03f, 9.520774227e-03f, 
9.537529283e-03f, 9.553956685e-03f, 9.570056090e-03f, 9.585827164e-03f, 9.601269586e-03f, 9.616383046e-03f, 9.631167244e-03f, 9.645621892e-03f, 9.659746712e-03f, 9.673541439e-03f, 
9.687005817e-03f, 9.700139604e-03f, 9.712942567e-03f, 9.725414484e-03f, 9.737555146e-03f, 9.749364353e-03f, 9.760841917e-03f, 9.771987662e-03f, 9.782801423e-03f, 9.793283045e-03f, 
9.803432384e-03f, 9.813249310e-03f, 9.822733700e-03f, 9.831885446e-03f, 9.840704448e-03f, 9.849190619e-03f, 9.857343884e-03f, 9.865164176e-03f, 9.872651442e-03f, 9.879805638e-03f, 
9.886626734e-03f, 9.893114708e-03f, 9.899269551e-03f, 9.905091265e-03f, 9.910579861e-03f, 9.915735364e-03f, 9.920557809e-03f, 9.925047241e-03f, 9.929203717e-03f, 9.933027306e-03f, 
9.936518086e-03f, 9.939676147e-03f, 9.942501591e-03f, 9.944994530e-03f, 9.947155087e-03f, 9.948983395e-03f, 9.950479600e-03f, 9.951643858e-03f, 9.952476337e-03f, 9.952977213e-03f, 
9.953146677e-03f, 9.952984927e-03f, 9.952492174e-03f, 9.951668641e-03f, 9.950514560e-03f, 9.949030173e-03f, 9.947215736e-03f, 9.945071513e-03f, 9.942597780e-03f, 9.939794824e-03f, 
9.936662943e-03f, 9.933202444e-03f, 9.929413647e-03f, 9.925296881e-03f, 9.920852487e-03f, 9.916080816e-03f, 9.910982229e-03f, 9.905557100e-03f, 9.899805812e-03f, 9.893728758e-03f, 
9.887326342e-03f, 9.880598980e-03f, 9.873547097e-03f, 9.866171129e-03f, 9.858471523e-03f, 9.850448736e-03f, 9.842103236e-03f, 9.833435500e-03f, 9.824446017e-03f, 9.815135286e-03f, 
9.805503816e-03f, 9.795552127e-03f, 9.785280750e-03f, 9.774690223e-03f, 9.763781098e-03f, 9.752553936e-03f, 9.741009308e-03f, 9.729147795e-03f, 9.716969988e-03f, 9.704476490e-03f, 
9.691667913e-03f, 9.678544878e-03f, 9.665108017e-03f, 9.651357972e-03f, 9.637295396e-03f, 9.622920951e-03f, 9.608235309e-03f, 9.593239152e-03f, 9.577933172e-03f, 9.562318071e-03f, 
9.546394560e-03f, 9.530163362e-03f, 9.513625207e-03f, 9.496780837e-03f, 9.479631003e-03f, 9.462176465e-03f, 9.444417994e-03f, 9.426356369e-03f, 9.407992381e-03f, 9.389326827e-03f, 
9.370360517e-03f, 9.351094270e-03f, 9.331528912e-03f, 9.311665281e-03f, 9.291504223e-03f, 9.271046595e-03f, 9.250293261e-03f, 9.229245096e-03f, 9.207902984e-03f, 9.186267819e-03f, 
9.164340502e-03f, 9.142121944e-03f, 9.119613067e-03f, 9.096814801e-03f, 9.073728083e-03f, 9.050353862e-03f, 9.026693095e-03f, 9.002746747e-03f, 8.978515793e-03f, 8.954001217e-03f, 
8.929204010e-03f, 8.904125174e-03f, 8.878765719e-03f, 8.853126664e-03f, 8.827209036e-03f, 8.801013870e-03f, 8.774542212e-03f, 8.747795115e-03f, 8.720773639e-03f, 8.693478856e-03f, 
8.665911844e-03f, 8.638073690e-03f, 8.609965489e-03f, 8.581588344e-03f, 8.552943368e-03f, 8.524031681e-03f, 8.494854411e-03f, 8.465412695e-03f, 8.435707677e-03f, 8.405740510e-03f, 
8.375512354e-03f, 8.345024378e-03f, 8.314277759e-03f, 8.283273681e-03f, 8.252013336e-03f, 8.220497925e-03f, 8.188728655e-03f, 8.156706741e-03f, 8.124433408e-03f, 8.091909885e-03f, 
8.059137412e-03f, 8.026117233e-03f, 7.992850603e-03f, 7.959338781e-03f, 7.925583037e-03f, 7.891584646e-03f, 7.857344891e-03f, 7.822865061e-03f, 7.788146455e-03f, 7.753190375e-03f, 
7.717998135e-03f, 7.682571051e-03f, 7.646910451e-03f, 7.611017666e-03f, 7.574894036e-03f, 7.538540907e-03f, 7.501959632e-03f, 7.465151571e-03f, 7.428118091e-03f, 7.390860564e-03f, 
7.353380371e-03f, 7.315678897e-03f, 7.277757537e-03f, 7.239617688e-03f, 7.201260758e-03f, 7.162688157e-03f, 7.123901304e-03f, 7.084901625e-03f, 7.045690549e-03f, 7.006269514e-03f, 
6.966639963e-03f, 6.926803345e-03f, 6.886761115e-03f, 6.846514735e-03f, 6.806065671e-03f, 6.765415396e-03f, 6.724565389e-03f, 6.683517134e-03f, 6.642272121e-03f, 6.600831846e-03f, 
6.559197810e-03f, 6.517371520e-03f, 6.475354488e-03f, 6.433148231e-03f, 6.390754273e-03f, 6.348174142e-03f, 6.305409371e-03f, 6.262461499e-03f, 6.219332070e-03f, 6.176022634e-03f, 
6.132534743e-03f, 6.088869957e-03f, 6.045029840e-03f, 6.001015961e-03f, 5.956829893e-03f, 5.912473214e-03f, 5.867947508e-03f, 5.823254362e-03f, 5.778395369e-03f, 5.733372124e-03f, 
5.688186231e-03f, 5.642839293e-03f, 5.597332922e-03f, 5.551668731e-03f, 5.505848340e-03f, 5.459873371e-03f, 5.413745451e-03f, 5.367466210e-03f, 5.321037285e-03f, 5.274460314e-03f, 
5.227736940e-03f, 5.180868810e-03f, 5.133857575e-03f, 5.086704888e-03f, 5.039412408e-03f, 4.991981796e-03f, 4.944414718e-03f, 4.896712842e-03f, 4.848877841e-03f, 4.800911389e-03f, 
4.752815167e-03f, 4.704590855e-03f, 4.656240140e-03f, 4.607764710e-03f, 4.559166256e-03f, 4.510446474e-03f, 4.461607060e-03f, 4.412649716e-03f, 4.363576145e-03f, 4.314388053e-03f, 
4.265087149e-03f, 4.215675145e-03f, 4.166153756e-03f, 4.116524697e-03f, 4.066789690e-03f, 4.016950455e-03f, 3.967008717e-03f, 3.916966202e-03f, 3.866824639e-03f, 3.816585761e-03f, 
3.766251299e-03f, 3.715822989e-03f, 3.665302569e-03f, 3.614691777e-03f, 3.563992357e-03f, 3.513206050e-03f, 3.462334601e-03f, 3.411379759e-03f, 3.360343270e-03f, 3.309226885e-03f, 
3.258032355e-03f, 3.206761435e-03f, 3.155415878e-03f, 3.103997440e-03f, 3.052507880e-03f, 3.000948954e-03f, 2.949322424e-03f, 2.897630050e-03f, 2.845873595e-03f, 2.794054821e-03f, 
2.742175492e-03f, 2.690237374e-03f, 2.638242233e-03f, 2.586191834e-03f, 2.534087946e-03f, 2.481932336e-03f, 2.429726774e-03f, 2.377473028e-03f, 2.325172868e-03f, 2.272828065e-03f, 
2.220440389e-03f, 2.168011610e-03f, 2.115543501e-03f, 2.063037832e-03f, 2.010496375e-03f, 1.957920902e-03f, 1.905313184e-03f, 1.852674992e-03f, 1.800008099e-03f, 1.747314275e-03f, 
1.694595292e-03f, 1.641852921e-03f, 1.589088932e-03f, 1.536305095e-03f, 1.483503180e-03f, 1.430684957e-03f, 1.377852193e-03f, 1.325006658e-03f, 1.272150117e-03f, 1.219284339e-03f, 
1.166411088e-03f, 1.113532130e-03f, 1.060649229e-03f, 1.007764147e-03f, 9.548786473e-04f, 9.019944904e-04f, 8.491134361e-04f, 7.962372431e-04f, 7.433676686e-04f, 6.905064687e-04f, 
6.376553982e-04f, 5.848162101e-04f, 5.319906562e-04f, 4.791804867e-04f, 4.263874502e-04f, 3.736132936e-04f, 3.208597620e-04f, 2.681285989e-04f, 2.154215459e-04f, 1.627403425e-04f, 
1.100867267e-04f, 5.746243395e-05f, 4.869198097e-06f, -4.769124937e-05f, -1.002171791e-04f, -1.527068639e-04f, -2.051585790e-04f, -2.575706018e-04f, -3.099412123e-04f, -3.622686928e-04f, 
-4.145513282e-04f, -4.667874059e-04f, -5.189752159e-04f, -5.711130510e-04f, -6.231992066e-04f, -6.752319810e-04f, -7.272096753e-04f, -7.791305935e-04f, -8.309930425e-04f, -8.827953323e-04f, 
-9.345357759e-04f, -9.862126894e-04f, -1.037824392e-03f, -1.089369207e-03f, -1.140845459e-03f, -1.192251478e-03f, -1.243585596e-03f, -1.294846149e-03f, -1.346031477e-03f, -1.397139922e-03f, 
-1.448169832e-03f, -1.499119556e-03f, -1.549987449e-03f, -1.600771868e-03f, -1.651471174e-03f, -1.702083734e-03f, -1.752607916e-03f, -1.803042094e-03f, -1.853384644e-03f, -1.903633949e-03f, 
-1.953788394e-03f, -2.003846368e-03f, -2.053806265e-03f, -2.103666484e-03f, -2.153425427e-03f, -2.203081500e-03f, -2.252633115e-03f, -2.302078688e-03f, -2.351416639e-03f, -2.400645393e-03f, 
-2.449763379e-03f, -2.498769031e-03f, -2.547660789e-03f, -2.596437096e-03f, -2.645096400e-03f, -2.693637154e-03f, -2.742057818e-03f, -2.790356854e-03f, -2.838532730e-03f, -2.886583920e-03f, 
-2.934508903e-03f, -2.982306160e-03f, -3.029974183e-03f, -3.077511463e-03f, -3.124916502e-03f, -3.172187803e-03f, -3.219323876e-03f, -3.266323238e-03f, -3.313184409e-03f, -3.359905915e-03f, 
-3.406486289e-03f, -3.452924068e-03f, -3.499217796e-03f, -3.545366022e-03f, -3.591367300e-03f, -3.637220192e-03f, -3.682923264e-03f, -3.728475088e-03f, -3.773874243e-03f, -3.819119312e-03f, 
-3.864208887e-03f, -3.909141564e-03f, -3.953915945e-03f, -3.998530639e-03f, -4.042984260e-03f, -4.087275430e-03f, -4.131402777e-03f, -4.175364933e-03f, -4.219160539e-03f, -4.262788241e-03f, 
-4.306246693e-03f, -4.349534553e-03f, -4.392650488e-03f, -4.435593170e-03f, -4.478361278e-03f, -4.520953497e-03f, -4.563368521e-03f, -4.605605048e-03f, -4.647661784e-03f, -4.689537443e-03f, 
-4.731230742e-03f, -4.772740410e-03f, -4.814065179e-03f, -4.855203789e-03f, -4.896154988e-03f, -4.936917530e-03f, -4.977490176e-03f, -5.017871696e-03f, -5.058060864e-03f, -5.098056464e-03f, 
-5.137857284e-03f, -5.177462124e-03f, -5.216869787e-03f, -5.256079085e-03f, -5.295088837e-03f, -5.333897871e-03f, -5.372505019e-03f, -5.410909124e-03f, -5.449109035e-03f, -5.487103607e-03f, 
-5.524891706e-03f, -5.562472203e-03f, -5.599843977e-03f, -5.637005915e-03f, -5.673956911e-03f, -5.710695869e-03f, -5.747221698e-03f, -5.783533317e-03f, -5.819629650e-03f, -5.855509632e-03f, 
-5.891172204e-03f, -5.926616315e-03f, -5.961840923e-03f, -5.996844994e-03f, -6.031627499e-03f, -6.066187421e-03f, -6.100523749e-03f, -6.134635480e-03f, -6.168521620e-03f, -6.202181183e-03f, 
-6.235613191e-03f, -6.268816673e-03f, -6.301790668e-03f, -6.334534223e-03f, -6.367046392e-03f, -6.399326238e-03f, -6.431372833e-03f, -6.463185257e-03f, -6.494762598e-03f, -6.526103953e-03f, 
-6.557208426e-03f, -6.588075132e-03f, -6.618703191e-03f, -6.649091735e-03f, -6.679239902e-03f, -6.709146841e-03f, -6.738811707e-03f, -6.768233665e-03f, -6.797411888e-03f, -6.826345559e-03f, 
-6.855033867e-03f, -6.883476013e-03f, -6.911671204e-03f, -6.939618657e-03f, -6.967317598e-03f, -6.994767261e-03f, -7.021966889e-03f, -7.048915734e-03f, -7.075613057e-03f, -7.102058127e-03f, 
-7.128250222e-03f, -7.154188630e-03f, -7.179872648e-03f, -7.205301579e-03f, -7.230474739e-03f, -7.255391451e-03f, -7.280051045e-03f, -7.304452864e-03f, -7.328596257e-03f, -7.352480584e-03f, 
-7.376105212e-03f, -7.399469518e-03f, -7.422572889e-03f, -7.445414720e-03f, -7.467994415e-03f, -7.490311388e-03f, -7.512365061e-03f, -7.534154865e-03f, -7.555680243e-03f, -7.576940643e-03f, 
-7.597935525e-03f, -7.618664358e-03f, -7.639126619e-03f, -7.659321794e-03f, -7.679249380e-03f, -7.698908882e-03f, -7.718299815e-03f, -7.737421702e-03f, -7.756274076e-03f, -7.774856480e-03f, 
-7.793168465e-03f, -7.811209592e-03f, -7.828979432e-03f, -7.846477563e-03f, -7.863703574e-03f, -7.880657065e-03f, -7.897337641e-03f, -7.913744920e-03f, -7.929878529e-03f, -7.945738102e-03f, 
-7.961323284e-03f, -7.976633730e-03f, -7.991669104e-03f, -8.006429078e-03f, -8.020913334e-03f, -8.035121565e-03f, -8.049053472e-03f, -8.062708765e-03f, -8.076087164e-03f, -8.089188398e-03f, 
-8.102012207e-03f, -8.114558338e-03f, -8.126826549e-03f, -8.138816607e-03f, -8.150528289e-03f, -8.161961379e-03f, -8.173115674e-03f, -8.183990979e-03f, -8.194587106e-03f, -8.204903881e-03f, 
-8.214941135e-03f, -8.224698711e-03f, -8.234176460e-03f, -8.243374245e-03f, -8.252291936e-03f, -8.260929412e-03f, -8.269286563e-03f, -8.277363287e-03f, -8.285159494e-03f, -8.292675101e-03f, 
-8.299910035e-03f, -8.306864232e-03f, -8.313537638e-03f, -8.319930209e-03f, -8.326041908e-03f, -8.331872711e-03f, -8.337422600e-03f, -8.342691568e-03f, -8.347679618e-03f, -8.352386760e-03f, 
-8.356813016e-03f, -8.360958416e-03f, -8.364822999e-03f, -8.368406815e-03f, -8.371709921e-03f, -8.374732385e-03f, -8.377474284e-03f, -8.379935703e-03f, -8.382116739e-03f, -8.384017496e-03f, 
-8.385638088e-03f, -8.386978637e-03f, -8.388039278e-03f, -8.388820151e-03f, -8.389321407e-03f, -8.389543207e-03f, -8.389485719e-03f, -8.389149124e-03f, -8.388533607e-03f, -8.387639367e-03f, 
-8.386466609e-03f, -8.385015548e-03f, -8.383286410e-03f, -8.381279428e-03f, -8.378994843e-03f, -8.376432909e-03f, -8.373593885e-03f, -8.370478042e-03f, -8.367085659e-03f, -8.363417023e-03f, 
-8.359472432e-03f, -8.355252192e-03f, -8.350756618e-03f, -8.345986033e-03f, -8.340940771e-03f, -8.335621173e-03f, -8.330027591e-03f, -8.324160384e-03f, -8.318019920e-03f, -8.311606578e-03f, 
-8.304920744e-03f, -8.297962812e-03f, -8.290733187e-03f, -8.283232282e-03f, -8.275460517e-03f, -8.267418324e-03f, -8.259106142e-03f, -8.250524418e-03f, -8.241673609e-03f, -8.232554180e-03f, 
-8.223166605e-03f, -8.213511366e-03f, -8.203588955e-03f, -8.193399871e-03f, -8.182944622e-03f, -8.172223726e-03f, -8.161237706e-03f, -8.149987099e-03f, -8.138472444e-03f, -8.126694295e-03f, 
-8.114653208e-03f, -8.102349753e-03f, -8.089784506e-03f, -8.076958049e-03f, -8.063870977e-03f, -8.050523890e-03f, -8.036917398e-03f, -8.023052117e-03f, -8.008928675e-03f, -7.994547704e-03f, 
-7.979909847e-03f, -7.965015754e-03f, -7.949866084e-03f, -7.934461503e-03f, -7.918802686e-03f, -7.902890316e-03f, -7.886725083e-03f, -7.870307685e-03f, -7.853638830e-03f, -7.836719232e-03f, 
-7.819549613e-03f, -7.802130704e-03f, -7.784463244e-03f, -7.766547977e-03f, -7.748385658e-03f, -7.729977048e-03f, -7.711322917e-03f, -7.692424041e-03f, -7.673281206e-03f, -7.653895203e-03f, 
-7.634266832e-03f, -7.614396901e-03f, -7.594286224e-03f, -7.573935625e-03f, -7.553345933e-03f, -7.532517985e-03f, -7.511452626e-03f, -7.490150709e-03f, -7.468613093e-03f, -7.446840645e-03f, 
-7.424834239e-03f, -7.402594756e-03f, -7.380123084e-03f, -7.357420121e-03f, -7.334486767e-03f, -7.311323934e-03f, -7.287932539e-03f, -7.264313505e-03f, -7.240467763e-03f, -7.216396253e-03f, 
-7.192099917e-03f, -7.167579710e-03f, -7.142836589e-03f, -7.117871519e-03f, -7.092685474e-03f, -7.067279431e-03f, -7.041654378e-03f, -7.015811306e-03f, -6.989751215e-03f, -6.963475110e-03f, 
-6.936984004e-03f, -6.910278914e-03f, -6.883360868e-03f, -6.856230896e-03f, -6.828890036e-03f, -6.801339333e-03f, -6.773579838e-03f, -6.745612607e-03f, -6.717438705e-03f, -6.689059201e-03f, 
-6.660475170e-03f, -6.631687695e-03f, -6.602697863e-03f, -6.573506769e-03f, -6.544115512e-03f, -6.514525198e-03f, -6.484736940e-03f, -6.454751856e-03f, -6.424571068e-03f, -6.394195707e-03f, 
-6.363626908e-03f, -6.332865811e-03f, -6.301913564e-03f, -6.270771319e-03f, -6.239440233e-03f, -6.207921471e-03f, -6.176216201e-03f, -6.144325597e-03f, -6.112250840e-03f, -6.079993114e-03f, 
-6.047553612e-03f, -6.014933527e-03f, -5.982134062e-03f, -5.949156423e-03f, -5.916001822e-03f, -5.882671475e-03f, -5.849166604e-03f, -5.815488435e-03f, -5.781638202e-03f, -5.747617140e-03f, 
-5.713426491e-03f, -5.679067502e-03f, -5.644541424e-03f, -5.609849513e-03f, -5.574993030e-03f, -5.539973241e-03f, -5.504791416e-03f, -5.469448829e-03f, -5.433946760e-03f, -5.398286493e-03f, 
-5.362469316e-03f, -5.326496522e-03f, -5.290369408e-03f, -5.254089275e-03f, -5.217657428e-03f, -5.181075179e-03f, -5.144343840e-03f, -5.107464730e-03f, -5.070439171e-03f, -5.033268490e-03f, 
-4.995954017e-03f, -4.958497085e-03f, -4.920899035e-03f, -4.883161206e-03f, -4.845284945e-03f, -4.807271603e-03f, -4.769122531e-03f, -4.730839087e-03f, -4.692422631e-03f, -4.653874528e-03f, 
-4.615196145e-03f, -4.576388853e-03f, -4.537454028e-03f, -4.498393046e-03f, -4.459207289e-03f, -4.419898141e-03f, -4.380466991e-03f, -4.340915229e-03f, -4.301244250e-03f, -4.261455450e-03f, 
-4.221550229e-03f, -4.181529991e-03f, -4.141396142e-03f, -4.101150091e-03f, -4.060793250e-03f, -4.020327033e-03f, -3.979752859e-03f, -3.939072146e-03f, -3.898286317e-03f, -3.857396799e-03f, 
-3.816405018e-03f, -3.775312406e-03f, -3.734120395e-03f, -3.692830420e-03f, -3.651443919e-03f, -3.609962331e-03f, -3.568387100e-03f, -3.526719669e-03f, -3.484961484e-03f, -3.443113995e-03f, 
-3.401178651e-03f, -3.359156906e-03f, -3.317050215e-03f, -3.274860033e-03f, -3.232587819e-03f, -3.190235033e-03f, -3.147803137e-03f, -3.105293595e-03f, -3.062707872e-03f, -3.020047434e-03f, 
-2.977313752e-03f, -2.934508293e-03f, -2.891632530e-03f, -2.848687935e-03f, -2.805675983e-03f, -2.762598149e-03f, -2.719455910e-03f, -2.676250743e-03f, -2.632984129e-03f, -2.589657546e-03f, 
-2.546272476e-03f, -2.502830402e-03f, -2.459332806e-03f, -2.415781173e-03f, -2.372176988e-03f, -2.328521736e-03f, -2.284816904e-03f, -2.241063979e-03f, -2.197264449e-03f, -2.153419803e-03f, 
-2.109531529e-03f, -2.065601117e-03f, -2.021630057e-03f, -1.977619840e-03f, -1.933571956e-03f, -1.889487895e-03f, -1.845369151e-03f, -1.801217213e-03f, -1.757033574e-03f, -1.712819725e-03f, 
-1.668577159e-03f, -1.624307367e-03f, -1.580011840e-03f, -1.535692071e-03f, -1.491349551e-03f, -1.446985771e-03f, -1.402602223e-03f, -1.358200397e-03f, -1.313781784e-03f, -1.269347873e-03f, 
-1.224900155e-03f, -1.180440119e-03f, -1.135969253e-03f, -1.091489045e-03f, -1.047000982e-03f, -1.002506552e-03f, -9.580072394e-04f, -9.135045305e-04f, -8.689999092e-04f, -8.244948590e-04f, 
-7.799908624e-04f, -7.354894008e-04f, -6.909919547e-04f, -6.465000036e-04f, -6.020150258e-04f, -5.575384983e-04f, -5.130718970e-04f, -4.686166965e-04f, -4.241743701e-04f, -3.797463897e-04f, 
-3.353342257e-04f, -2.909393473e-04f, -2.465632218e-04f, -2.022073153e-04f, -1.578730921e-04f, -1.135620148e-04f, -6.927554442e-05f, -2.501514014e-05f, 1.921774062e-05f, 6.342164232e-05f, 
1.075951113e-04f, 1.517366958e-04f, 1.958449461e-04f, 2.399184146e-04f, 2.839556556e-04f, 3.279552258e-04f, 3.719156836e-04f, 4.158355903e-04f, 4.597135088e-04f, 5.035480048e-04f, 
5.473376462e-04f, 5.910810032e-04f, 6.347766487e-04f, 6.784231579e-04f, 7.220191085e-04f, 7.655630811e-04f, 8.090536587e-04f, 8.524894270e-04f, 8.958689744e-04f, 9.391908923e-04f, 
9.824537748e-04f, 1.025656219e-03f, 1.068796824e-03f, 1.111874193e-03f, 1.154886932e-03f, 1.197833650e-03f, 1.240712959e-03f, 1.283523474e-03f, 1.326263813e-03f, 1.368932597e-03f, 
1.411528452e-03f, 1.454050005e-03f, 1.496495888e-03f, 1.538864736e-03f, 1.581155186e-03f, 1.623365882e-03f, 1.665495467e-03f, 1.707542591e-03f, 1.749505907e-03f, 1.791384070e-03f, 
1.833175740e-03f, 1.874879581e-03f, 1.916494261e-03f, 1.958018449e-03f, 1.999450823e-03f, 2.040790059e-03f, 2.082034842e-03f, 2.123183858e-03f, 2.164235798e-03f, 2.205189358e-03f, 
2.246043235e-03f, 2.286796134e-03f, 2.327446763e-03f, 2.367993832e-03f, 2.408436057e-03f, 2.448772160e-03f, 2.489000865e-03f, 2.529120900e-03f, 2.569130999e-03f, 2.609029901e-03f, 
2.648816348e-03f, 2.688489087e-03f, 2.728046869e-03f, 2.767488451e-03f, 2.806812593e-03f, 2.846018062e-03f, 2.885103628e-03f, 2.924068066e-03f, 2.962910156e-03f, 3.001628683e-03f, 
3.040222436e-03f, 3.078690211e-03f, 3.117030807e-03f, 3.155243029e-03f, 3.193325687e-03f, 3.231277595e-03f, 3.269097573e-03f, 3.306784446e-03f, 3.344337046e-03f, 3.381754206e-03f, 
3.419034769e-03f, 3.456177580e-03f, 3.493181490e-03f, 3.530045357e-03f, 3.566768042e-03f, 3.603348413e-03f, 3.639785344e-03f, 3.676077712e-03f, 3.712224402e-03f, 3.748224304e-03f, 
3.784076313e-03f, 3.819779330e-03f, 3.855332261e-03f, 3.890734020e-03f, 3.925983523e-03f, 3.961079695e-03f, 3.996021466e-03f, 4.030807770e-03f, 4.065437550e-03f, 4.099909753e-03f, 
4.134223331e-03f, 4.168377244e-03f, 4.202370457e-03f, 4.236201941e-03f, 4.269870673e-03f, 4.303375637e-03f, 4.336715822e-03f, 4.369890224e-03f, 4.402897843e-03f, 4.435737689e-03f, 
4.468408776e-03f, 4.500910123e-03f, 4.533240757e-03f, 4.565399712e-03f, 4.597386027e-03f, 4.629198747e-03f, 4.660836924e-03f, 4.692299618e-03f, 4.723585894e-03f, 4.754694821e-03f, 
4.785625480e-03f, 4.816376954e-03f, 4.846948334e-03f, 4.877338718e-03f, 4.907547210e-03f, 4.937572922e-03f, 4.967414971e-03f, 4.997072480e-03f, 5.026544582e-03f, 5.055830414e-03f, 
5.084929121e-03f, 5.113839853e-03f, 5.142561769e-03f, 5.171094034e-03f, 5.199435819e-03f, 5.227586304e-03f, 5.255544674e-03f, 5.283310121e-03f, 5.310881845e-03f, 5.338259053e-03f, 
5.365440958e-03f, 5.392426780e-03f, 5.419215747e-03f, 5.445807093e-03f, 5.472200060e-03f, 5.498393898e-03f, 5.524387861e-03f, 5.550181212e-03f, 5.575773223e-03f, 5.601163170e-03f, 
5.626350338e-03f, 5.651334018e-03f, 5.676113510e-03f, 5.700688120e-03f, 5.725057162e-03f, 5.749219955e-03f, 5.773175830e-03f, 5.796924120e-03f, 5.820464169e-03f, 5.843795328e-03f, 
5.866916953e-03f, 5.889828409e-03f, 5.912529070e-03f, 5.935018315e-03f, 5.957295531e-03f, 5.979360112e-03f, 6.001211463e-03f, 6.022848991e-03f, 6.044272114e-03f, 6.065480257e-03f, 
6.086472852e-03f, 6.107249340e-03f, 6.127809167e-03f, 6.148151788e-03f, 6.168276667e-03f, 6.188183272e-03f, 6.207871083e-03f, 6.227339585e-03f, 6.246588270e-03f, 6.265616639e-03f, 
6.284424201e-03f, 6.303010472e-03f, 6.321374976e-03f, 6.339517244e-03f, 6.357436815e-03f, 6.375133236e-03f, 6.392606062e-03f, 6.409854856e-03f, 6.426879186e-03f, 6.443678632e-03f, 
6.460252779e-03f, 6.476601221e-03f, 6.492723558e-03f, 6.508619399e-03f, 6.524288362e-03f, 6.539730071e-03f, 6.554944159e-03f, 6.569930266e-03f, 6.584688039e-03f, 6.599217136e-03f, 
6.613517219e-03f, 6.627587960e-03f, 6.641429040e-03f, 6.655040145e-03f, 6.668420970e-03f, 6.681571219e-03f, 6.694490603e-03f, 6.707178840e-03f, 6.719635657e-03f, 6.731860790e-03f, 
6.743853980e-03f, 6.755614978e-03f, 6.767143542e-03f, 6.778439439e-03f, 6.789502443e-03f, 6.800332335e-03f, 6.810928907e-03f, 6.821291955e-03f, 6.831421286e-03f, 6.841316714e-03f, 
6.850978059e-03f, 6.860405152e-03f, 6.869597830e-03f, 6.878555939e-03f, 6.887279331e-03f, 6.895767869e-03f, 6.904021421e-03f, 6.912039864e-03f, 6.919823084e-03f, 6.927370973e-03f, 
6.934683433e-03f, 6.941760372e-03f, 6.948601706e-03f, 6.955207361e-03f, 6.961577268e-03f, 6.967711368e-03f, 6.973609610e-03f, 6.979271950e-03f, 6.984698352e-03f, 6.989888787e-03f, 
6.994843236e-03f, 6.999561686e-03f, 7.004044133e-03f, 7.008290581e-03f, 7.012301040e-03f, 7.016075531e-03f, 7.019614079e-03f, 7.022916721e-03f, 7.025983498e-03f, 7.028814462e-03f, 
7.031409671e-03f, 7.033769190e-03f, 7.035893095e-03f, 7.037781467e-03f, 7.039434396e-03f, 7.040851979e-03f, 7.042034321e-03f, 7.042981536e-03f, 7.043693744e-03f, 7.044171073e-03f, 
7.044413661e-03f, 7.044421651e-03f, 7.044195195e-03f, 7.043734452e-03f, 7.043039590e-03f, 7.042110783e-03f, 7.040948215e-03f, 7.039552075e-03f, 7.037922560e-03f, 7.036059878e-03f, 
7.033964241e-03f, 7.031635869e-03f, 7.029074992e-03f, 7.026281845e-03f, 7.023256672e-03f, 7.019999725e-03f, 7.016511261e-03f, 7.012791548e-03f, 7.008840859e-03f, 7.004659475e-03f, 
7.000247687e-03f, 6.995605789e-03f, 6.990734086e-03f, 6.985632889e-03f, 6.980302518e-03f, 6.974743297e-03f, 6.968955562e-03f, 6.962939653e-03f, 6.956695918e-03f, 6.950224713e-03f, 
6.943526402e-03f, 6.936601355e-03f, 6.929449950e-03f, 6.922072572e-03f, 6.914469613e-03f, 6.906641473e-03f, 6.898588559e-03f, 6.890311285e-03f, 6.881810072e-03f, 6.873085350e-03f, 
6.864137554e-03f, 6.854967126e-03f, 6.845574517e-03f, 6.835960184e-03f, 6.826124592e-03f, 6.816068210e-03f, 6.805791519e-03f, 6.795295003e-03f, 6.784579155e-03f, 6.773644473e-03f, 
6.762491466e-03f, 6.751120645e-03f, 6.739532531e-03f, 6.727727652e-03f, 6.715706541e-03f, 6.703469740e-03f, 6.691017796e-03f, 6.678351263e-03f, 6.665470703e-03f, 6.652376685e-03f, 
6.639069783e-03f, 6.625550579e-03f, 6.611819661e-03f, 6.597877624e-03f, 6.583725070e-03f, 6.569362607e-03f, 6.554790850e-03f, 6.540010420e-03f, 6.525021946e-03f, 6.509826063e-03f, 
6.494423410e-03f, 6.478814636e-03f, 6.463000394e-03f, 6.446981346e-03f, 6.430758157e-03f, 6.414331502e-03f, 6.397702059e-03f, 6.380870515e-03f, 6.363837562e-03f, 6.346603897e-03f, 
6.329170227e-03f, 6.311537260e-03f, 6.293705716e-03f, 6.275676316e-03f, 6.257449791e-03f, 6.239026875e-03f, 6.220408310e-03f, 6.201594845e-03f, 6.182587231e-03f, 6.163386229e-03f, 
6.143992604e-03f, 6.124407128e-03f, 6.104630578e-03f, 6.084663737e-03f, 6.064507395e-03f, 6.044162345e-03f, 6.023629390e-03f, 6.002909334e-03f, 5.982002990e-03f, 5.960911176e-03f, 
5.939634715e-03f, 5.918174437e-03f, 5.896531175e-03f, 5.874705770e-03f, 5.852699068e-03f, 5.830511920e-03f, 5.808145182e-03f, 5.785599717e-03f, 5.762876392e-03f, 5.739976079e-03f, 
5.716899658e-03f, 5.693648012e-03f, 5.670222029e-03f, 5.646622603e-03f, 5.622850634e-03f, 5.598907025e-03f, 5.574792687e-03f, 5.550508534e-03f, 5.526055485e-03f, 5.501434466e-03f, 
5.476646406e-03f, 5.451692239e-03f, 5.426572906e-03f, 5.401289350e-03f, 5.375842521e-03f, 5.350233373e-03f, 5.324462866e-03f, 5.298531962e-03f, 5.272441631e-03f, 5.246192845e-03f, 
5.219786583e-03f, 5.193223826e-03f, 5.166505561e-03f, 5.139632780e-03f, 5.112606480e-03f, 5.085427660e-03f, 5.058097326e-03f, 5.030616486e-03f, 5.002986154e-03f, 4.975207350e-03f, 
4.947281093e-03f, 4.919208412e-03f, 4.890990338e-03f, 4.862627904e-03f, 4.834122150e-03f, 4.805474119e-03f, 4.776684858e-03f, 4.747755420e-03f, 4.718686858e-03f, 4.689480232e-03f, 
4.660136605e-03f, 4.630657045e-03f, 4.601042622e-03f, 4.571294410e-03f, 4.541413488e-03f, 4.511400939e-03f, 4.481257847e-03f, 4.450985303e-03f, 4.420584399e-03f, 4.390056232e-03f, 
4.359401903e-03f, 4.328622514e-03f, 4.297719173e-03f, 4.266692990e-03f, 4.235545079e-03f, 4.204276558e-03f, 4.172888547e-03f, 4.141382169e-03f, 4.109758552e-03f, 4.078018826e-03f, 
4.046164123e-03f, 4.014195581e-03f, 3.982114339e-03f, 3.949921538e-03f, 3.917618325e-03f, 3.885205848e-03f, 3.852685258e-03f, 3.820057710e-03f, 3.787324359e-03f, 3.754486366e-03f, 
3.721544893e-03f, 3.688501106e-03f, 3.655356171e-03f, 3.622111260e-03f, 3.588767544e-03f, 3.555326201e-03f, 3.521788407e-03f, 3.488155343e-03f, 3.454428192e-03f, 3.420608139e-03f, 
3.386696371e-03f, 3.352694079e-03f, 3.318602453e-03f, 3.284422689e-03f, 3.250155983e-03f, 3.215803533e-03f, 3.181366539e-03f, 3.146846206e-03f, 3.112243736e-03f, 3.077560336e-03f, 
3.042797216e-03f, 3.007955584e-03f, 2.973036654e-03f, 2.938041640e-03f, 2.902971756e-03f, 2.867828221e-03f, 2.832612253e-03f, 2.797325073e-03f, 2.761967903e-03f, 2.726541968e-03f, 
2.691048491e-03f, 2.655488701e-03f, 2.619863825e-03f, 2.584175092e-03f, 2.548423734e-03f, 2.512610982e-03f, 2.476738070e-03f, 2.440806233e-03f, 2.404816705e-03f, 2.368770724e-03f, 
2.332669528e-03f, 2.296514356e-03f, 2.260306447e-03f, 2.224047043e-03f, 2.187737384e-03f, 2.151378715e-03f, 2.114972277e-03f, 2.078519316e-03f, 2.042021077e-03f, 2.005478804e-03f, 
1.968893744e-03f, 1.932267145e-03f, 1.895600254e-03f, 1.858894318e-03f, 1.822150586e-03f, 1.785370308e-03f, 1.748554732e-03f, 1.711705108e-03f, 1.674822686e-03f, 1.637908717e-03f, 
1.600964451e-03f, 1.563991138e-03f, 1.526990030e-03f, 1.489962377e-03f, 1.452909431e-03f, 1.415832443e-03f, 1.378732663e-03f, 1.341611343e-03f, 1.304469734e-03f, 1.267309086e-03f, 
1.230130649e-03f, 1.192935675e-03f, 1.155725413e-03f, 1.118501113e-03f, 1.081264024e-03f, 1.044015395e-03f, 1.006756476e-03f, 9.694885134e-04f, 9.322127555e-04f, 8.949304493e-04f, 
8.576428412e-04f, 8.203511768e-04f, 7.830567015e-04f, 7.457606594e-04f, 7.084642943e-04f, 6.711688490e-04f, 6.338755653e-04f, 5.965856845e-04f, 5.593004467e-04f, 5.220210909e-04f, 
4.847488555e-04f, 4.474849775e-04f, 4.102306930e-04f, 3.729872369e-04f, 3.357558428e-04f, 2.985377434e-04f, 2.613341700e-04f, 2.241463523e-04f, 1.869755192e-04f, 1.498228980e-04f, 
1.126897143e-04f, 7.557719273e-05f, 3.848655612e-05f, 1.419025876e-06f, -3.562417821e-05f, -7.264183793e-05f, -1.096327367e-04f, -1.465956598e-04f, -1.835293939e-04f, -2.204327279e-04f, 
-2.573044520e-04f, -2.941433586e-04f, -3.309482420e-04f, -3.677178982e-04f, -4.044511252e-04f, -4.411467233e-04f, -4.778034945e-04f, -5.144202430e-04f, -5.509957752e-04f, -5.875288996e-04f, 
-6.240184268e-04f, -6.604631697e-04f, -6.968619436e-04f, -7.332135660e-04f, -7.695168567e-04f, -8.057706380e-04f, -8.419737346e-04f, -8.781249735e-04f, -9.142231843e-04f, -9.502671994e-04f, 
-9.862558534e-04f, -1.022187984e-03f, -1.058062430e-03f, -1.093878036e-03f, -1.129633646e-03f, -1.165328108e-03f, -1.200960274e-03f, -1.236528997e-03f, -1.272033135e-03f, -1.307471546e-03f, 
-1.342843093e-03f, -1.378146642e-03f, -1.413381060e-03f, -1.448545221e-03f, -1.483637998e-03f, -1.518658269e-03f, -1.553604915e-03f, -1.588476820e-03f, -1.623272872e-03f, -1.657991961e-03f, 
-1.692632981e-03f, -1.727194829e-03f, -1.761676406e-03f, -1.796076616e-03f, -1.830394366e-03f, -1.864628567e-03f, -1.898778134e-03f, -1.932841984e-03f, -1.966819040e-03f, -2.000708226e-03f, 
-2.034508470e-03f, -2.068218706e-03f, -2.101837870e-03f, -2.135364901e-03f, -2.168798743e-03f, -2.202138343e-03f, -2.235382654e-03f, -2.268530629e-03f, -2.301581228e-03f, -2.334533414e-03f, 
-2.367386154e-03f, -2.400138419e-03f, -2.432789184e-03f, -2.465337427e-03f, -2.497782133e-03f, -2.530122288e-03f, -2.562356883e-03f, -2.594484915e-03f, -2.626505383e-03f, -2.658417291e-03f, 
-2.690219647e-03f, -2.721911465e-03f, -2.753491760e-03f, -2.784959555e-03f, -2.816313875e-03f, -2.847553751e-03f, -2.878678216e-03f, -2.909686311e-03f, -2.940577078e-03f, -2.971349566e-03f, 
-3.002002827e-03f, -3.032535920e-03f, -3.062947905e-03f, -3.093237850e-03f, -3.123404826e-03f, -3.153447908e-03f, -3.183366179e-03f, -3.213158722e-03f, -3.242824629e-03f, -3.272362994e-03f, 
-3.301772919e-03f, -3.331053507e-03f, -3.360203868e-03f, -3.389223117e-03f, -3.418110374e-03f, -3.446864764e-03f, -3.475485415e-03f, -3.503971463e-03f, -3.532322048e-03f, -3.560536315e-03f, 
-3.588613412e-03f, -3.616552496e-03f, -3.644352727e-03f, -3.672013270e-03f, -3.699533296e-03f, -3.726911981e-03f, -3.754148505e-03f, -3.781242056e-03f, -3.808191825e-03f, -3.834997009e-03f, 
-3.861656810e-03f, -3.888170437e-03f, -3.914537102e-03f, -3.940756025e-03f, -3.966826428e-03f, -3.992747542e-03f, -4.018518602e-03f, -4.044138849e-03f, -4.069607527e-03f, -4.094923889e-03f, 
-4.120087193e-03f, -4.145096700e-03f, -4.169951680e-03f, -4.194651405e-03f, -4.219195157e-03f, -4.243582220e-03f, -4.267811886e-03f, -4.291883450e-03f, -4.315796217e-03f, -4.339549493e-03f, 
-4.363142594e-03f, -4.386574838e-03f, -4.409845552e-03f, -4.432954067e-03f, -4.455899720e-03f, -4.478681855e-03f, -4.501299821e-03f, -4.523752972e-03f, -4.546040670e-03f, -4.568162282e-03f, 
-4.590117180e-03f, -4.611904744e-03f, -4.633524357e-03f, -4.654975412e-03f, -4.676257304e-03f, -4.697369437e-03f, -4.718311219e-03f, -4.739082066e-03f, -4.759681398e-03f, -4.780108644e-03f, 
-4.800363235e-03f, -4.820444613e-03f, -4.840352221e-03f, -4.860085513e-03f, -4.879643945e-03f, -4.899026983e-03f, -4.918234096e-03f, -4.937264761e-03f, -4.956118461e-03f, -4.974794685e-03f, 
-4.993292928e-03f, -5.011612692e-03f, -5.029753484e-03f, -5.047714819e-03f, -5.065496218e-03f, -5.083097206e-03f, -5.100517317e-03f, -5.117756091e-03f, -5.134813073e-03f, -5.151687816e-03f, 
-5.168379878e-03f, -5.184888823e-03f, -5.201214224e-03f, -5.217355658e-03f, -5.233312709e-03f, -5.249084968e-03f, -5.264672031e-03f, -5.280073503e-03f, -5.295288993e-03f, -5.310318117e-03f, 
-5.325160498e-03f, -5.339815766e-03f, -5.354283557e-03f, -5.368563512e-03f, -5.382655281e-03f, -5.396558518e-03f, -5.410272886e-03f, -5.423798053e-03f, -5.437133694e-03f, -5.450279491e-03f, 
-5.463235130e-03f, -5.476000307e-03f, -5.488574724e-03f, -5.500958086e-03f, -5.513150109e-03f, -5.525150514e-03f, -5.536959028e-03f, -5.548575384e-03f, -5.559999323e-03f, -5.571230593e-03f, 
-5.582268946e-03f, -5.593114144e-03f, -5.603765954e-03f, -5.614224148e-03f, -5.624488506e-03f, -5.634558817e-03f, -5.644434872e-03f, -5.654116472e-03f, -5.663603423e-03f, -5.672895540e-03f, 
-5.681992640e-03f, -5.690894552e-03f, -5.699601107e-03f, -5.708112146e-03f, -5.716427515e-03f, -5.724547067e-03f, -5.732470661e-03f, -5.740198165e-03f, -5.747729449e-03f, -5.755064395e-03f, 
-5.762202888e-03f, -5.769144821e-03f, -5.775890093e-03f, -5.782438610e-03f, -5.788790285e-03f, -5.794945038e-03f, -5.800902793e-03f, -5.806663483e-03f, -5.812227048e-03f, -5.817593433e-03f, 
-5.822762591e-03f, -5.827734481e-03f, -5.832509067e-03f, -5.837086322e-03f, -5.841466226e-03f, -5.845648762e-03f, -5.849633924e-03f, -5.853421710e-03f, -5.857012125e-03f, -5.860405180e-03f, 
-5.863600894e-03f, -5.866599291e-03f, -5.869400404e-03f, -5.872004270e-03f, -5.874410933e-03f, -5.876620445e-03f, -5.878632864e-03f, -5.880448252e-03f, -5.882066682e-03f, -5.883488230e-03f, 
-5.884712980e-03f, -5.885741023e-03f, -5.886572454e-03f, -5.887207377e-03f, -5.887645903e-03f, -5.887888146e-03f, -5.887934231e-03f, -5.887784285e-03f, -5.887438445e-03f, -5.886896852e-03f, 
-5.886159655e-03f, -5.885227009e-03f, -5.884099075e-03f, -5.882776021e-03f, -5.881258021e-03f, -5.879545255e-03f, -5.877637911e-03f, -5.875536181e-03f, -5.873240265e-03f, -5.870750369e-03f, 
-5.868066706e-03f, -5.865189493e-03f, -5.862118956e-03f, -5.858855327e-03f, -5.855398841e-03f, -5.851749744e-03f, -5.847908286e-03f, -5.843874722e-03f, -5.839649315e-03f, -5.835232333e-03f, 
-5.830624053e-03f, -5.825824754e-03f, -5.820834725e-03f, -5.815654259e-03f, -5.810283655e-03f, -5.804723219e-03f, -5.798973263e-03f, -5.793034106e-03f, -5.786906071e-03f, -5.780589488e-03f, 
-5.774084695e-03f, -5.767392032e-03f, -5.760511850e-03f, -5.753444501e-03f, -5.746190347e-03f, -5.738749754e-03f, -5.731123094e-03f, -5.723310746e-03f, -5.715313094e-03f, -5.707130528e-03f, 
-5.698763444e-03f, -5.690212245e-03f, -5.681477338e-03f, -5.672559137e-03f, -5.663458062e-03f, -5.654174537e-03f, -5.644708995e-03f, -5.635061872e-03f, -5.625233611e-03f, -5.615224661e-03f, 
-5.605035475e-03f, -5.594666514e-03f, -5.584118243e-03f, -5.573391134e-03f, -5.562485663e-03f, -5.551402314e-03f, -5.540141573e-03f, -5.528703937e-03f, -5.517089902e-03f, -5.505299975e-03f, 
-5.493334667e-03f, -5.481194491e-03f, -5.468879972e-03f, -5.456391634e-03f, -5.443730012e-03f, -5.430895641e-03f, -5.417889066e-03f, -5.404710836e-03f, -5.391361503e-03f, -5.377841628e-03f, 
-5.364151775e-03f, -5.350292514e-03f, -5.336264420e-03f, -5.322068073e-03f, -5.307704060e-03f, -5.293172970e-03f, -5.278475400e-03f, -5.263611951e-03f, -5.248583230e-03f, -5.233389847e-03f, 
-5.218032420e-03f, -5.202511569e-03f, -5.186827922e-03f, -5.170982110e-03f, -5.154974769e-03f, -5.138806542e-03f, -5.122478074e-03f, -5.105990018e-03f, -5.089343028e-03f, -5.072537768e-03f, 
-5.055574901e-03f, -5.038455100e-03f, -5.021179040e-03f, -5.003747401e-03f, -4.986160868e-03f, -4.968420132e-03f, -4.950525886e-03f, -4.932478830e-03f, -4.914279667e-03f, -4.895929107e-03f, 
-4.877427861e-03f, -4.858776647e-03f, -4.839976188e-03f, -4.821027210e-03f, -4.801930444e-03f, -4.782686625e-03f, -4.763296493e-03f, -4.743760792e-03f, -4.724080272e-03f, -4.704255684e-03f, 
-4.684287786e-03f, -4.664177340e-03f, -4.643925112e-03f, -4.623531870e-03f, -4.602998390e-03f, -4.582325450e-03f, -4.561513832e-03f, -4.540564323e-03f, -4.519477713e-03f, -4.498254797e-03f, 
-4.476896374e-03f, -4.455403246e-03f, -4.433776220e-03f, -4.412016107e-03f, -4.390123720e-03f, -4.368099879e-03f, -4.345945405e-03f, -4.323661124e-03f, -4.301247867e-03f, -4.278706466e-03f, 
-4.256037759e-03f, -4.233242586e-03f, -4.210321793e-03f, -4.187276227e-03f, -4.164106740e-03f, -4.140814187e-03f, -4.117399428e-03f, -4.093863324e-03f, -4.070206742e-03f, -4.046430550e-03f, 
-4.022535622e-03f, -3.998522833e-03f, -3.974393063e-03f, -3.950147194e-03f, -3.925786113e-03f, -3.901310709e-03f, -3.876721873e-03f, -3.852020503e-03f, -3.827207496e-03f, -3.802283755e-03f, 
-3.777250184e-03f, -3.752107691e-03f, -3.726857189e-03f, -3.701499590e-03f, -3.676035812e-03f, -3.650466774e-03f, -3.624793401e-03f, -3.599016616e-03f, -3.573137349e-03f, -3.547156532e-03f, 
-3.521075098e-03f, -3.494893984e-03f, -3.468614130e-03f, -3.442236477e-03f, -3.415761972e-03f, -3.389191560e-03f, -3.362526193e-03f, -3.335766822e-03f, -3.308914403e-03f, -3.281969893e-03f, 
-3.254934252e-03f, -3.227808443e-03f, -3.200593429e-03f, -3.173290179e-03f, -3.145899660e-03f, -3.118422846e-03f, -3.090860709e-03f, -3.063214226e-03f, -3.035484375e-03f, -3.007672136e-03f, 
-2.979778491e-03f, -2.951804424e-03f, -2.923750923e-03f, -2.895618976e-03f, -2.867409572e-03f, -2.839123704e-03f, -2.810762367e-03f, -2.782326557e-03f, -2.753817270e-03f, -2.725235507e-03f, 
-2.696582269e-03f, -2.667858560e-03f, -2.639065384e-03f, -2.610203746e-03f, -2.581274657e-03f, -2.552279124e-03f, -2.523218159e-03f, -2.494092775e-03f, -2.464903985e-03f, -2.435652806e-03f, 
-2.406340253e-03f, -2.376967346e-03f, -2.347535105e-03f, -2.318044548e-03f, -2.288496700e-03f, -2.258892584e-03f, -2.229233223e-03f, -2.199519644e-03f, -2.169752873e-03f, -2.139933939e-03f, 
-2.110063870e-03f, -2.080143697e-03f, -2.050174450e-03f, -2.020157161e-03f, -1.990092863e-03f, -1.959982590e-03f, -1.929827376e-03f, -1.899628257e-03f, -1.869386268e-03f, -1.839102447e-03f, 
-1.808777831e-03f, -1.778413458e-03f, -1.748010368e-03f, -1.717569598e-03f, -1.687092190e-03f, -1.656579184e-03f, -1.626031621e-03f, -1.595450542e-03f, -1.564836989e-03f, -1.534192004e-03f, 
-1.503516631e-03f, -1.472811911e-03f, -1.442078888e-03f, -1.411318605e-03f, -1.380532107e-03f, -1.349720436e-03f, -1.318884636e-03f, -1.288025753e-03f, -1.257144829e-03f, -1.226242908e-03f, 
-1.195321036e-03f, -1.164380256e-03f, -1.133421612e-03f, -1.102446147e-03f, -1.071454907e-03f, -1.040448933e-03f, -1.009429270e-03f, -9.783969610e-04f, -9.473530482e-04f, -9.162985744e-04f, 
-8.852345818e-04f, -8.541621121e-04f, -8.230822067e-04f, -7.919959066e-04f, -7.609042520e-04f, -7.298082829e-04f, -6.987090387e-04f, -6.676075581e-04f, -6.365048791e-04f, -6.054020392e-04f, 
-5.743000753e-04f, -5.432000232e-04f, -5.121029184e-04f, -4.810097952e-04f, -4.499216873e-04f, -4.188396274e-04f, -3.877646475e-04f, -3.566977785e-04f, -3.256400503e-04f, -2.945924919e-04f, 
-2.635561313e-04f, -2.325319953e-04f, -2.015211097e-04f, -1.705244991e-04f, -1.395431871e-04f, -1.085781957e-04f, -7.763054623e-05f, -4.670125825e-05f, -1.579135029e-05f, 1.509816054e-05f, 
4.596625848e-05f, 7.681192918e-05f, 1.076341597e-04f, 1.384319386e-04f, 1.692042560e-04f, 1.999501033e-04f, 2.306684738e-04f, 2.613583621e-04f, 2.920187647e-04f, 3.226486796e-04f, 
3.532471065e-04f, 3.838130469e-04f, 4.143455039e-04f, 4.448434826e-04f, 4.753059897e-04f, 5.057320341e-04f, 5.361206262e-04f, 5.664707786e-04f, 5.967815056e-04f, 6.270518237e-04f, 
6.572807514e-04f, 6.874673090e-04f, 7.176105192e-04f, 7.477094066e-04f, 7.777629981e-04f, 8.077703225e-04f, 8.377304112e-04f, 8.676422973e-04f, 8.975050168e-04f, 9.273176074e-04f, 
9.570791095e-04f, 9.867885658e-04f, 1.016445021e-03f, 1.046047523e-03f, 1.075595122e-03f, 1.105086869e-03f, 1.134521820e-03f, 1.163899032e-03f, 1.193217565e-03f, 1.222476481e-03f, 
1.251674847e-03f, 1.280811729e-03f, 1.309886198e-03f, 1.338897328e-03f, 1.367844194e-03f, 1.396725875e-03f, 1.425541452e-03f, 1.454290011e-03f, 1.482970638e-03f, 1.511582423e-03f, 
1.540124460e-03f, 1.568595843e-03f, 1.596995674e-03f, 1.625323052e-03f, 1.653577083e-03f, 1.681756876e-03f, 1.709861541e-03f, 1.737890193e-03f, 1.765841948e-03f, 1.793715927e-03f, 
1.821511255e-03f, 1.849227058e-03f, 1.876862465e-03f, 1.904416611e-03f, 1.931888633e-03f, 1.959277670e-03f, 1.986582865e-03f, 2.013803367e-03f, 2.040938324e-03f, 2.067986890e-03f, 
2.094948223e-03f, 2.121821482e-03f, 2.148605833e-03f, 2.175300443e-03f, 2.201904483e-03f, 2.228417127e-03f, 2.254837554e-03f, 2.281164946e-03f, 2.307398489e-03f, 2.333537372e-03f, 
2.359580788e-03f, 2.385527934e-03f, 2.411378010e-03f, 2.437130221e-03f, 2.462783774e-03f, 2.488337883e-03f, 2.513791762e-03f, 2.539144632e-03f, 2.564395715e-03f, 2.589544240e-03f, 
2.614589438e-03f, 2.639530544e-03f, 2.664366797e-03f, 2.689097442e-03f, 2.713721726e-03f, 2.738238900e-03f, 2.762648220e-03f, 2.786948945e-03f, 2.811140339e-03f, 2.835221671e-03f, 
2.859192213e-03f, 2.883051241e-03f, 2.906798035e-03f, 2.930431880e-03f, 2.953952066e-03f, 2.977357886e-03f, 3.000648637e-03f, 3.023823621e-03f, 3.046882145e-03f, 3.069823519e-03f, 
3.092647059e-03f, 3.115352083e-03f, 3.137937916e-03f, 3.160403886e-03f, 3.182749325e-03f, 3.204973571e-03f, 3.227075966e-03f, 3.249055856e-03f, 3.270912591e-03f, 3.292645527e-03f, 
3.314254024e-03f, 3.335737446e-03f, 3.357095162e-03f, 3.378326546e-03f, 3.399430976e-03f, 3.420407836e-03f, 3.441256513e-03f, 3.461976399e-03f, 3.482566891e-03f, 3.503027392e-03f, 
3.523357307e-03f, 3.543556049e-03f, 3.563623033e-03f, 3.583557680e-03f, 3.603359415e-03f, 3.623027671e-03f, 3.642561880e-03f, 3.661961485e-03f, 3.681225930e-03f, 3.700354665e-03f, 
3.719347144e-03f, 3.738202829e-03f, 3.756921183e-03f, 3.775501676e-03f, 3.793943782e-03f, 3.812246983e-03f, 3.830410761e-03f, 3.848434607e-03f, 3.866318016e-03f, 3.884060486e-03f, 
3.901661523e-03f, 3.919120636e-03f, 3.936437341e-03f, 3.953611157e-03f, 3.970641610e-03f, 3.987528229e-03f, 4.004270549e-03f, 4.020868112e-03f, 4.037320462e-03f, 4.053627150e-03f, 
4.069787733e-03f, 4.085801770e-03f, 4.101668829e-03f, 4.117388481e-03f, 4.132960302e-03f, 4.148383875e-03f, 4.163658786e-03f, 4.178784627e-03f, 4.193760997e-03f, 4.208587498e-03f, 
4.223263738e-03f, 4.237789330e-03f, 4.252163894e-03f, 4.266387054e-03f, 4.280458438e-03f, 4.294377681e-03f, 4.308144423e-03f, 4.321758310e-03f, 4.335218992e-03f, 4.348526125e-03f, 
4.361679371e-03f, 4.374678395e-03f, 4.387522871e-03f, 4.400212475e-03f, 4.412746891e-03f, 4.425125807e-03f, 4.437348916e-03f, 4.449415917e-03f, 4.461326515e-03f, 4.473080420e-03f, 
4.484677347e-03f, 4.496117017e-03f, 4.507399156e-03f, 4.518523496e-03f, 4.529489774e-03f, 4.540297731e-03f, 4.550947118e-03f, 4.561437685e-03f, 4.571769194e-03f, 4.581941408e-03f, 
4.591954096e-03f, 4.601807035e-03f, 4.611500006e-03f, 4.621032793e-03f, 4.630405191e-03f, 4.639616994e-03f, 4.648668008e-03f, 4.657558039e-03f, 4.666286902e-03f, 4.674854416e-03f, 
4.683260405e-03f, 4.691504701e-03f, 4.699587139e-03f, 4.707507561e-03f, 4.715265812e-03f, 4.722861747e-03f, 4.730295222e-03f, 4.737566101e-03f, 4.744674253e-03f, 4.751619553e-03f, 
4.758401881e-03f, 4.765021122e-03f, 4.771477166e-03f, 4.777769912e-03f, 4.783899260e-03f, 4.789865119e-03f, 4.795667402e-03f, 4.801306026e-03f, 4.806780918e-03f, 4.812092005e-03f, 
4.817239223e-03f, 4.822222514e-03f, 4.827041823e-03f, 4.831697102e-03f, 4.836188308e-03f, 4.840515404e-03f, 4.844678358e-03f, 4.848677144e-03f, 4.852511742e-03f, 4.856182135e-03f, 
4.859688315e-03f, 4.863030277e-03f, 4.866208022e-03f, 4.869221556e-03f, 4.872070893e-03f, 4.874756049e-03f, 4.877277048e-03f, 4.879633919e-03f, 4.881826694e-03f, 4.883855415e-03f, 
4.885720125e-03f, 4.887420875e-03f, 4.888957721e-03f, 4.890330724e-03f, 4.891539951e-03f, 4.892585474e-03f, 4.893467371e-03f, 4.894185723e-03f, 4.894740620e-03f, 4.895132156e-03f, 
4.895360429e-03f, 4.895425543e-03f, 4.895327610e-03f, 4.895066743e-03f, 4.894643064e-03f, 4.894056698e-03f, 4.893307777e-03f, 4.892396437e-03f, 4.891322820e-03f, 4.890087074e-03f, 
4.888689350e-03f, 4.887129808e-03f, 4.885408610e-03f, 4.883525924e-03f, 4.881481924e-03f, 4.879276789e-03f, 4.876910704e-03f, 4.874383858e-03f, 4.871696445e-03f, 4.868848665e-03f, 
4.865840725e-03f, 4.862672833e-03f, 4.859345206e-03f, 4.855858064e-03f, 4.852211633e-03f, 4.848406144e-03f, 4.844441834e-03f, 4.840318944e-03f, 4.836037720e-03f, 4.831598414e-03f, 
4.827001283e-03f, 4.822246588e-03f, 4.817334596e-03f, 4.812265580e-03f, 4.807039815e-03f, 4.801657585e-03f, 4.796119177e-03f, 4.790424881e-03f, 4.784574996e-03f, 4.778569824e-03f, 
4.772409671e-03f, 4.766094850e-03f, 4.759625678e-03f, 4.753002475e-03f, 4.746225570e-03f, 4.739295294e-03f, 4.732211984e-03f, 4.724975981e-03f, 4.717587631e-03f, 4.710047285e-03f, 
4.702355301e-03f, 4.694512037e-03f, 4.686517861e-03f, 4.678373142e-03f, 4.670078256e-03f, 4.661633583e-03f, 4.653039507e-03f, 4.644296418e-03f, 4.635404709e-03f, 4.626364781e-03f, 
4.617177035e-03f, 4.607841881e-03f, 4.598359731e-03f, 4.588731002e-03f, 4.578956117e-03f, 4.569035502e-03f, 4.558969588e-03f, 4.548758810e-03f, 4.538403610e-03f, 4.527904432e-03f, 
4.517261726e-03f, 4.506475944e-03f, 4.495547545e-03f, 4.484476992e-03f, 4.473264752e-03f, 4.461911297e-03f, 4.450417101e-03f, 4.438782646e-03f, 4.427008417e-03f, 4.415094901e-03f, 
4.403042592e-03f, 4.390851989e-03f, 4.378523592e-03f, 4.366057907e-03f, 4.353455446e-03f, 4.340716722e-03f, 4.327842254e-03f, 4.314832565e-03f, 4.301688183e-03f, 4.288409637e-03f, 
4.274997465e-03f, 4.261452204e-03f, 4.247774398e-03f, 4.233964595e-03f, 4.220023346e-03f, 4.205951208e-03f, 4.191748738e-03f, 4.177416502e-03f, 4.162955065e-03f, 4.148365001e-03f, 
4.133646883e-03f, 4.118801291e-03f, 4.103828807e-03f, 4.088730020e-03f, 4.073505519e-03f, 4.058155898e-03f, 4.042681757e-03f, 4.027083696e-03f, 4.011362321e-03f, 3.995518243e-03f, 
3.979552073e-03f, 3.963464428e-03f, 3.947255929e-03f, 3.930927200e-03f, 3.914478867e-03f, 3.897911563e-03f, 3.881225922e-03f, 3.864422581e-03f, 3.847502183e-03f, 3.830465371e-03f, 
3.813312796e-03f, 3.796045109e-03f, 3.778662964e-03f, 3.761167021e-03f, 3.743557942e-03f, 3.725836391e-03f, 3.708003039e-03f, 3.690058555e-03f, 3.672003617e-03f, 3.653838901e-03f, 
3.635565090e-03f, 3.617182867e-03f, 3.598692922e-03f, 3.580095945e-03f, 3.561392630e-03f, 3.542583674e-03f, 3.523669778e-03f, 3.504651644e-03f, 3.485529979e-03f, 3.466305492e-03f, 
3.446978895e-03f, 3.427550904e-03f, 3.408022235e-03f, 3.388393610e-03f, 3.368665753e-03f, 3.348839389e-03f, 3.328915248e-03f, 3.308894063e-03f, 3.288776567e-03f, 3.268563499e-03f, 
3.248255598e-03f, 3.227853607e-03f, 3.207358271e-03f, 3.186770339e-03f, 3.166090560e-03f, 3.145319689e-03f, 3.124458480e-03f, 3.103507692e-03f, 3.082468086e-03f, 3.061340423e-03f, 
3.040125471e-03f, 3.018823996e-03f, 2.997436769e-03f, 2.975964562e-03f, 2.954408150e-03f, 2.932768310e-03f, 2.911045822e-03f, 2.889241467e-03f, 2.867356028e-03f, 2.845390292e-03f, 
2.823345047e-03f, 2.801221082e-03f, 2.779019190e-03f, 2.756740166e-03f, 2.734384805e-03f, 2.711953906e-03f, 2.689448269e-03f, 2.666868696e-03f, 2.644215992e-03f, 2.621490962e-03f, 
2.598694414e-03f, 2.575827158e-03f, 2.552890006e-03f, 2.529883770e-03f, 2.506809266e-03f, 2.483667311e-03f, 2.460458722e-03f, 2.437184320e-03f, 2.413844926e-03f, 2.390441365e-03f, 
2.366974459e-03f, 2.343445037e-03f, 2.319853926e-03f, 2.296201955e-03f, 2.272489955e-03f, 2.248718759e-03f, 2.224889199e-03f, 2.201002112e-03f, 2.177058334e-03f, 2.153058701e-03f, 
2.129004054e-03f, 2.104895232e-03f, 2.080733077e-03f, 2.056518432e-03f, 2.032252140e-03f, 2.007935046e-03f, 1.983567997e-03f, 1.959151840e-03f, 1.934687422e-03f, 1.910175593e-03f, 
1.885617203e-03f, 1.861013104e-03f, 1.836364147e-03f, 1.811671186e-03f, 1.786935074e-03f, 1.762156667e-03f, 1.737336819e-03f, 1.712476387e-03f, 1.687576229e-03f, 1.662637202e-03f, 
1.637660164e-03f, 1.612645975e-03f, 1.587595495e-03f, 1.562509584e-03f, 1.537389103e-03f, 1.512234915e-03f, 1.487047880e-03f, 1.461828862e-03f, 1.436578723e-03f, 1.411298328e-03f, 
1.385988541e-03f, 1.360650225e-03f, 1.335284245e-03f, 1.309891467e-03f, 1.284472755e-03f, 1.259028975e-03f, 1.233560994e-03f, 1.208069676e-03f, 1.182555889e-03f, 1.157020499e-03f, 
1.131464371e-03f, 1.105888373e-03f, 1.080293371e-03f, 1.054680232e-03f, 1.029049823e-03f, 1.003403010e-03f, 9.777406589e-04f, 9.520636373e-04f, 9.263728112e-04f, 9.006690468e-04f, 
8.749532101e-04f, 8.492261671e-04f, 8.234887833e-04f, 7.977419242e-04f, 7.719864547e-04f, 7.462232396e-04f, 7.204531434e-04f, 6.946770302e-04f, 6.688957635e-04f, 6.431102065e-04f, 
6.173212222e-04f, 5.915296726e-04f, 5.657364197e-04f, 5.399423245e-04f, 5.141482478e-04f, 4.883550495e-04f, 4.625635892e-04f, 4.367747255e-04f, 4.109893166e-04f, 3.852082198e-04f, 
3.594322917e-04f, 3.336623882e-04f, 3.078993644e-04f, 2.821440744e-04f, 2.563973716e-04f, 2.306601086e-04f, 2.049331368e-04f, 1.792173071e-04f, 1.535134690e-04f, 1.278224712e-04f, 
1.021451615e-04f, 7.648238634e-05f, 5.083499139e-05f, 2.520382106e-05f, -4.102813381e-07f, -2.600647365e-05f, -5.158391489e-05f, -7.714176533e-05f, -1.026791864e-04f, -1.281953409e-04f, 
-1.536893929e-04f, -1.791605077e-04f, -2.046078520e-04f, -2.300305940e-04f, -2.554279030e-04f, -2.807989501e-04f, -3.061429076e-04f, -3.314589493e-04f, -3.567462507e-04f, -3.820039885e-04f, 
-4.072313414e-04f, -4.324274892e-04f, -4.575916138e-04f, -4.827228983e-04f, -5.078205278e-04f, -5.328836889e-04f, -5.579115700e-04f, -5.829033612e-04f, -6.078582544e-04f, -6.327754433e-04f, 
-6.576541234e-04f, -6.824934921e-04f, -7.072927486e-04f, -7.320510941e-04f, -7.567677315e-04f, -7.814418660e-04f, -8.060727044e-04f, -8.306594558e-04f, -8.552013311e-04f, -8.796975435e-04f, 
-9.041473080e-04f, -9.285498419e-04f, -9.529043644e-04f, -9.772100972e-04f, -1.001466264e-03f, -1.025672090e-03f, -1.049826805e-03f, -1.073929637e-03f, -1.097979820e-03f, -1.121976589e-03f, 
-1.145919181e-03f, -1.169806836e-03f, -1.193638794e-03f, -1.217414302e-03f, -1.241132605e-03f, -1.264792952e-03f, -1.288394596e-03f, -1.311936790e-03f, -1.335418791e-03f, -1.358839859e-03f, 
-1.382199254e-03f, -1.405496241e-03f, -1.428730087e-03f, -1.451900062e-03f, -1.475005437e-03f, -1.498045488e-03f, -1.521019491e-03f, -1.543926728e-03f, -1.566766481e-03f, -1.589538035e-03f, 
-1.612240680e-03f, -1.634873706e-03f, -1.657436408e-03f, -1.679928082e-03f, -1.702348029e-03f, -1.724695550e-03f, -1.746969952e-03f, -1.769170543e-03f, -1.791296635e-03f, -1.813347542e-03f, 
-1.835322581e-03f, -1.857221073e-03f, -1.879042341e-03f, -1.900785712e-03f, -1.922450516e-03f, -1.944036084e-03f, -1.965541753e-03f, -1.986966863e-03f, -2.008310754e-03f, -2.029572772e-03f, 
-2.050752266e-03f, -2.071848587e-03f, -2.092861091e-03f, -2.113789134e-03f, -2.134632079e-03f, -2.155389291e-03f, -2.176060137e-03f, -2.196643989e-03f, -2.217140222e-03f, -2.237548212e-03f, 
-2.257867343e-03f, -2.278096999e-03f, -2.298236567e-03f, -2.318285440e-03f, -2.338243013e-03f, -2.358108685e-03f, -2.377881857e-03f, -2.397561935e-03f, -2.417148328e-03f, -2.436640449e-03f, 
-2.456037715e-03f, -2.475339544e-03f, -2.494545361e-03f, -2.513654593e-03f, -2.532666669e-03f, -2.551581025e-03f, -2.570397098e-03f, -2.589114330e-03f, -2.607732167e-03f, -2.626250056e-03f, 
-2.644667452e-03f, -2.662983810e-03f, -2.681198591e-03f, -2.699311259e-03f, -2.717321281e-03f, -2.735228130e-03f, -2.753031280e-03f, -2.770730211e-03f, -2.788324406e-03f, -2.805813352e-03f, 
-2.823196540e-03f, -2.840473464e-03f, -2.857643624e-03f, -2.874706520e-03f, -2.891661661e-03f, -2.908508557e-03f, -2.925246721e-03f, -2.941875673e-03f, -2.958394934e-03f, -2.974804031e-03f, 
-2.991102495e-03f, -3.007289859e-03f, -3.023365662e-03f, -3.039329446e-03f, -3.055180758e-03f, -3.070919149e-03f, -3.086544173e-03f, -3.102055390e-03f, -3.117452361e-03f, -3.132734654e-03f, 
-3.147901840e-03f, -3.162953494e-03f, -3.177889196e-03f, -3.192708529e-03f, -3.207411082e-03f, -3.221996445e-03f, -3.236464216e-03f, -3.250813995e-03f, -3.265045386e-03f, -3.279157998e-03f, 
-3.293151444e-03f, -3.307025342e-03f, -3.320779313e-03f, -3.334412983e-03f, -3.347925982e-03f, -3.361317945e-03f, -3.374588510e-03f, -3.387737320e-03f, -3.400764024e-03f, -3.413668271e-03f, 
-3.426449719e-03f, -3.439108028e-03f, -3.451642862e-03f, -3.464053891e-03f, -3.476340787e-03f, -3.488503230e-03f, -3.500540900e-03f, -3.512453485e-03f, -3.524240676e-03f, -3.535902168e-03f, 
-3.547437660e-03f, -3.558846857e-03f, -3.570129468e-03f, -3.581285206e-03f, -3.592313788e-03f, -3.603214936e-03f, -3.613988376e-03f, -3.624633840e-03f, -3.635151063e-03f, -3.645539785e-03f, 
-3.655799749e-03f, -3.665930705e-03f, -3.675932405e-03f, -3.685804609e-03f, -3.695547077e-03f, -3.705159576e-03f, -3.714641879e-03f, -3.723993759e-03f, -3.733214999e-03f, -3.742305382e-03f, 
-3.751264698e-03f, -3.760092740e-03f, -3.768789308e-03f, -3.777354203e-03f, -3.785787234e-03f, -3.794088211e-03f, -3.802256953e-03f, -3.810293279e-03f, -3.818197015e-03f, -3.825967992e-03f, 
-3.833606044e-03f, -3.841111010e-03f, -3.848482735e-03f, -3.855721066e-03f, -3.862825857e-03f, -3.869796964e-03f, -3.876634251e-03f, -3.883337583e-03f, -3.889906832e-03f, -3.896341874e-03f, 
-3.902642588e-03f, -3.908808860e-03f, -3.914840580e-03f, -3.920737641e-03f, -3.926499941e-03f, -3.932127385e-03f, -3.937619880e-03f, -3.942977337e-03f, -3.948199675e-03f, -3.953286814e-03f, 
-3.958238681e-03f, -3.963055206e-03f, -3.967736324e-03f, -3.972281975e-03f, -3.976692104e-03f, -3.980966659e-03f, -3.985105593e-03f, -3.989108865e-03f, -3.992976438e-03f, -3.996708277e-03f, 
-4.000304356e-03f, -4.003764649e-03f, -4.007089139e-03f, -4.010277810e-03f, -4.013330652e-03f, -4.016247660e-03f, -4.019028832e-03f, -4.021674173e-03f, -4.024183689e-03f, -4.026557394e-03f, 
-4.028795304e-03f, -4.030897442e-03f, -4.032863834e-03f, -4.034694509e-03f, -4.036389503e-03f, -4.037948856e-03f, -4.039372612e-03f, -4.040660820e-03f, -4.041813532e-03f, -4.042830807e-03f, 
-4.043712707e-03f, -4.044459297e-03f, -4.045070649e-03f, -4.045546839e-03f, -4.045887947e-03f, -4.046094057e-03f, -4.046165258e-03f, -4.046101643e-03f, -4.045903310e-03f, -4.045570361e-03f, 
-4.045102903e-03f, -4.044501047e-03f, -4.043764908e-03f, -4.042894606e-03f, -4.041890266e-03f, -4.040752016e-03f, -4.039479989e-03f, -4.038074322e-03f, -4.036535157e-03f, -4.034862641e-03f, 
-4.033056923e-03f, -4.031118159e-03f, -4.029046508e-03f, -4.026842133e-03f, -4.024505201e-03f, -4.022035885e-03f, -4.019434362e-03f, -4.016700812e-03f, -4.013835419e-03f, -4.010838374e-03f, 
-4.007709870e-03f, -4.004450103e-03f, -4.001059277e-03f, -3.997537598e-03f, -3.993885276e-03f, -3.990102525e-03f, -3.986189565e-03f, -3.982146618e-03f, -3.977973912e-03f, -3.973671678e-03f, 
-3.969240152e-03f, -3.964679573e-03f, -3.959990185e-03f, -3.955172237e-03f, -3.950225980e-03f, -3.945151671e-03f, -3.939949569e-03f, -3.934619940e-03f, -3.929163051e-03f, -3.923579175e-03f, 
-3.917868589e-03f, -3.912031574e-03f, -3.906068413e-03f, -3.899979396e-03f, -3.893764815e-03f, -3.887424967e-03f, -3.880960152e-03f, -3.874370675e-03f, -3.867656845e-03f, -3.860818973e-03f, 
-3.853857377e-03f, -3.846772375e-03f, -3.839564294e-03f, -3.832233460e-03f, -3.824780205e-03f, -3.817204865e-03f, -3.809507781e-03f, -3.801689294e-03f, -3.793749753e-03f, -3.785689508e-03f, 
-3.777508914e-03f, -3.769208330e-03f, -3.760788118e-03f, -3.752248644e-03f, -3.743590278e-03f, -3.734813394e-03f, -3.725918367e-03f, -3.716905581e-03f, -3.707775417e-03f, -3.698528266e-03f, 
-3.689164519e-03f, -3.679684571e-03f, -3.670088821e-03f, -3.660377672e-03f, -3.650551529e-03f, -3.640610804e-03f, -3.630555908e-03f, -3.620387259e-03f, -3.610105276e-03f, -3.599710384e-03f, 
-3.589203010e-03f, -3.578583585e-03f, -3.567852541e-03f, -3.557010318e-03f, -3.546057357e-03f, -3.534994100e-03f, -3.523820996e-03f, -3.512538496e-03f, -3.501147055e-03f, -3.489647130e-03f, 
-3.478039181e-03f, -3.466323674e-03f, -3.454501075e-03f, -3.442571856e-03f, -3.430536491e-03f, -3.418395456e-03f, -3.406149232e-03f, -3.393798302e-03f, -3.381343154e-03f, -3.368784276e-03f, 
-3.356122163e-03f, -3.343357310e-03f, -3.330490215e-03f, -3.317521382e-03f, -3.304451316e-03f, -3.291280524e-03f, -3.278009518e-03f, -3.264638813e-03f, -3.251168925e-03f, -3.237600374e-03f, 
-3.223933684e-03f, -3.210169380e-03f, -3.196307991e-03f, -3.182350050e-03f, -3.168296090e-03f, -3.154146649e-03f, -3.139902267e-03f, -3.125563487e-03f, -3.111130855e-03f, -3.096604920e-03f, 
-3.081986231e-03f, -3.067275345e-03f, -3.052472816e-03f, -3.037579204e-03f, -3.022595071e-03f, -3.007520982e-03f, -2.992357503e-03f, -2.977105205e-03f, -2.961764660e-03f, -2.946336442e-03f, 
-2.930821129e-03f, -2.915219300e-03f, -2.899531538e-03f, -2.883758428e-03f, -2.867900557e-03f, -2.851958513e-03f, -2.835932890e-03f, -2.819824282e-03f, -2.803633285e-03f, -2.787360498e-03f, 
-2.771006523e-03f, -2.754571963e-03f, -2.738057425e-03f, -2.721463515e-03f, -2.704790845e-03f, -2.688040026e-03f, -2.671211675e-03f, -2.654306407e-03f, -2.637324841e-03f, -2.620267599e-03f, 
-2.603135303e-03f, -2.585928579e-03f, -2.568648055e-03f, -2.551294358e-03f, -2.533868121e-03f, -2.516369977e-03f, -2.498800561e-03f, -2.481160510e-03f, -2.463450463e-03f, -2.445671061e-03f, 
-2.427822946e-03f, -2.409906764e-03f, -2.391923160e-03f, -2.373872783e-03f, -2.355756283e-03f, -2.337574312e-03f, -2.319327522e-03f, -2.301016569e-03f, -2.282642109e-03f, -2.264204802e-03f, 
-2.245705307e-03f, -2.227144286e-03f, -2.208522401e-03f, -2.189840319e-03f, -2.171098705e-03f, -2.152298227e-03f, -2.133439554e-03f, -2.114523357e-03f, -2.095550309e-03f, -2.076521082e-03f, 
-2.057436353e-03f, -2.038296797e-03f, -2.019103092e-03f, -1.999855918e-03f, -1.980555954e-03f, -1.961203883e-03f, -1.941800387e-03f, -1.922346150e-03f, -1.902841858e-03f, -1.883288197e-03f, 
-1.863685855e-03f, -1.844035521e-03f, -1.824337885e-03f, -1.804593637e-03f, -1.784803470e-03f, -1.764968077e-03f, -1.745088151e-03f, -1.725164389e-03f, -1.705197486e-03f, -1.685188139e-03f, 
-1.665137046e-03f, -1.645044905e-03f, -1.624912418e-03f, -1.604740283e-03f, -1.584529203e-03f, -1.564279880e-03f, -1.543993016e-03f, -1.523669315e-03f, -1.503309482e-03f, -1.482914222e-03f, 
-1.462484240e-03f, -1.442020243e-03f, -1.421522938e-03f, -1.400993033e-03f, -1.380431236e-03f, -1.359838256e-03f, -1.339214801e-03f, -1.318561583e-03f, -1.297879310e-03f, -1.277168695e-03f, 
-1.256430448e-03f, -1.235665281e-03f, -1.214873906e-03f, -1.194057036e-03f, -1.173215382e-03f, -1.152349659e-03f, -1.131460578e-03f, -1.110548855e-03f, -1.089615203e-03f, -1.068660336e-03f, 
-1.047684968e-03f, -1.026689814e-03f, -1.005675588e-03f, -9.846430045e-04f, -9.635927791e-04f, -9.425256263e-04f, -9.214422611e-04f, -9.003433984e-04f, -8.792297531e-04f, -8.581020403e-04f, 
-8.369609747e-04f, -8.158072713e-04f, -7.946416448e-04f, -7.734648097e-04f, -7.522774806e-04f, -7.310803717e-04f, -7.098741973e-04f, -6.886596711e-04f, -6.674375070e-04f, -6.462084183e-04f, 
-6.249731181e-04f, -6.037323194e-04f, -5.824867345e-04f, -5.612370757e-04f, -5.399840548e-04f, -5.187283830e-04f, -4.974707714e-04f, -4.762119304e-04f, -4.549525701e-04f, -4.336934001e-04f, 
-4.124351293e-04f, -3.911784662e-04f, -3.699241188e-04f, -3.486727943e-04f, -3.274251996e-04f, -3.061820406e-04f, -2.849440228e-04f, -2.637118510e-04f, -2.424862292e-04f, -2.212678607e-04f, 
-2.000574481e-04f, -1.788556931e-04f, -1.576632969e-04f, -1.364809595e-04f, -1.153093803e-04f, -9.414925784e-05f, -7.300128963e-05f, -5.186617239e-05f, -3.074460186e-05f, -9.637272848e-06f, 
1.145512083e-05f, 3.253188635e-05f, 5.359233192e-05f, 7.463576678e-05f, 9.566150123e-05f, 1.166688467e-04f, 1.376571157e-04f, 1.586256218e-04f, 1.795736799e-04f, 2.005006059e-04f, 
2.214057170e-04f, 2.422883317e-04f, 2.631477695e-04f, 2.839833513e-04f, 3.047943994e-04f, 3.255802373e-04f, 3.463401898e-04f, 3.670735830e-04f, 3.877797446e-04f, 4.084580035e-04f, 
4.291076900e-04f, 4.497281361e-04f, 4.703186749e-04f, 4.908786411e-04f, 5.114073712e-04f, 5.319042027e-04f, 5.523684751e-04f, 5.727995292e-04f, 5.931967076e-04f, 6.135593542e-04f, 
6.338868147e-04f, 6.541784367e-04f, 6.744335689e-04f, 6.946515623e-04f, 7.148317691e-04f, 7.349735436e-04f, 7.550762416e-04f, 7.751392208e-04f, 7.951618407e-04f, 8.151434625e-04f, 
8.350834494e-04f, 8.549811664e-04f, 8.748359801e-04f, 8.946472595e-04f, 9.144143750e-04f, 9.341366994e-04f, 9.538136069e-04f, 9.734444743e-04f, 9.930286799e-04f, 1.012565604e-03f, 
1.032054630e-03f, 1.051495141e-03f, 1.070886525e-03f, 1.090228169e-03f, 1.109519466e-03f, 1.128759808e-03f, 1.147948589e-03f, 1.167085208e-03f, 1.186169063e-03f, 1.205199556e-03f, 
1.224176092e-03f, 1.243098075e-03f, 1.261964915e-03f, 1.280776022e-03f, 1.299530808e-03f, 1.318228690e-03f, 1.336869084e-03f, 1.355451411e-03f, 1.373975092e-03f, 1.392439552e-03f, 
1.410844219e-03f, 1.429188520e-03f, 1.447471890e-03f, 1.465693761e-03f, 1.483853570e-03f, 1.501950757e-03f, 1.519984763e-03f, 1.537955033e-03f, 1.555861012e-03f, 1.573702152e-03f, 
1.591477903e-03f, 1.609187720e-03f, 1.626831060e-03f, 1.644407382e-03f, 1.661916150e-03f, 1.679356827e-03f, 1.696728882e-03f, 1.714031785e-03f, 1.731265008e-03f, 1.748428028e-03f, 
1.765520323e-03f, 1.782541374e-03f, 1.799490665e-03f, 1.816367683e-03f, 1.833171916e-03f, 1.849902858e-03f, 1.866560004e-03f, 1.883142851e-03f, 1.899650900e-03f, 1.916083656e-03f, 
1.932440623e-03f, 1.948721312e-03f, 1.964925236e-03f, 1.981051908e-03f, 1.997100848e-03f, 2.013071577e-03f, 2.028963618e-03f, 2.044776499e-03f, 2.060509749e-03f, 2.076162902e-03f, 
2.091735494e-03f, 2.107227064e-03f, 2.122637154e-03f, 2.137965309e-03f, 2.153211077e-03f, 2.168374009e-03f, 2.183453661e-03f, 2.198449590e-03f, 2.213361355e-03f, 2.228188522e-03f, 
2.242930656e-03f, 2.257587328e-03f, 2.272158112e-03f, 2.286642583e-03f, 2.301040321e-03f, 2.315350910e-03f, 2.329573934e-03f, 2.343708983e-03f, 2.357755651e-03f, 2.371713531e-03f, 
2.385582225e-03f, 2.399361333e-03f, 2.413050461e-03f, 2.426649218e-03f, 2.440157217e-03f, 2.453574073e-03f, 2.466899404e-03f, 2.480132832e-03f, 2.493273984e-03f, 2.506322488e-03f, 
2.519277975e-03f, 2.532140083e-03f, 2.544908449e-03f, 2.557582716e-03f, 2.570162530e-03f, 2.582647539e-03f, 2.595037397e-03f, 2.607331760e-03f, 2.619530286e-03f, 2.631632640e-03f, 
2.643638486e-03f, 2.655547496e-03f, 2.667359341e-03f, 2.679073700e-03f, 2.690690252e-03f, 2.702208682e-03f, 2.713628676e-03f, 2.724949925e-03f, 2.736172124e-03f, 2.747294970e-03f, 
2.758318165e-03f, 2.769241414e-03f, 2.780064425e-03f, 2.790786911e-03f, 2.801408586e-03f, 2.811929171e-03f, 2.822348388e-03f, 2.832665964e-03f, 2.842881627e-03f, 2.852995113e-03f, 
2.863006158e-03f, 2.872914503e-03f, 2.882719892e-03f, 2.892422073e-03f, 2.902020799e-03f, 2.911515824e-03f, 2.920906907e-03f, 2.930193812e-03f, 2.939376304e-03f, 2.948454152e-03f, 
2.957427132e-03f, 2.966295020e-03f, 2.975057596e-03f, 2.983714646e-03f, 2.992265958e-03f, 3.000711324e-03f, 3.009050539e-03f, 3.017283403e-03f, 3.025409719e-03f, 3.033429293e-03f, 
3.041341937e-03f, 3.049147464e-03f, 3.056845692e-03f, 3.064436443e-03f, 3.071919543e-03f, 3.079294819e-03f, 3.086562106e-03f, 3.093721239e-03f, 3.100772059e-03f, 3.107714409e-03f, 
3.114548139e-03f, 3.121273098e-03f, 3.127889142e-03f, 3.134396131e-03f, 3.140793927e-03f, 3.147082395e-03f, 3.153261408e-03f, 3.159330838e-03f, 3.165290562e-03f, 3.171140464e-03f, 
3.176880428e-03f, 3.182510342e-03f, 3.188030100e-03f, 3.193439598e-03f, 3.198738736e-03f, 3.203927419e-03f, 3.209005553e-03f, 3.213973052e-03f, 3.218829829e-03f, 3.223575804e-03f, 
3.228210900e-03f, 3.232735044e-03f, 3.237148165e-03f, 3.241450198e-03f, 3.245641080e-03f, 3.249720754e-03f, 3.253689165e-03f, 3.257546261e-03f, 3.261291996e-03f, 3.264926327e-03f, 
3.268449213e-03f, 3.271860619e-03f, 3.275160513e-03f, 3.278348866e-03f, 3.281425655e-03f, 3.284390857e-03f, 3.287244456e-03f, 3.289986439e-03f, 3.292616795e-03f, 3.295135520e-03f, 
3.297542610e-03f, 3.299838068e-03f, 3.302021899e-03f, 3.304094111e-03f, 3.306054718e-03f, 3.307903736e-03f, 3.309641185e-03f, 3.311267090e-03f, 3.312781476e-03f, 3.314184377e-03f, 
3.315475827e-03f, 3.316655865e-03f, 3.317724533e-03f, 3.318681877e-03f, 3.319527947e-03f, 3.320262796e-03f, 3.320886483e-03f, 3.321399066e-03f, 3.321800612e-03f, 3.322091188e-03f, 
3.322270865e-03f, 3.322339720e-03f, 3.322297832e-03f, 3.322145283e-03f, 3.321882159e-03f, 3.321508551e-03f, 3.321024552e-03f, 3.320430260e-03f, 3.319725776e-03f, 3.318911203e-03f, 
3.317986650e-03f, 3.316952229e-03f, 3.315808054e-03f, 3.314554246e-03f, 3.313190926e-03f, 3.311718220e-03f, 3.310136257e-03f, 3.308445172e-03f, 3.306645100e-03f, 3.304736182e-03f, 
3.302718562e-03f, 3.300592386e-03f, 3.298357806e-03f, 3.296014975e-03f, 3.293564053e-03f, 3.291005199e-03f, 3.288338579e-03f, 3.285564361e-03f, 3.282682717e-03f, 3.279693822e-03f, 
3.276597854e-03f, 3.273394996e-03f, 3.270085434e-03f, 3.266669355e-03f, 3.263146953e-03f, 3.259518424e-03f, 3.255783966e-03f, 3.251943782e-03f, 3.247998079e-03f, 3.243947065e-03f, 
3.239790954e-03f, 3.235529960e-03f, 3.231164305e-03f, 3.226694210e-03f, 3.222119901e-03f, 3.217441609e-03f, 3.212659565e-03f, 3.207774006e-03f, 3.202785171e-03f, 3.197693302e-03f, 
3.192498646e-03f, 3.187201451e-03f, 3.181801970e-03f, 3.176300458e-03f, 3.170697175e-03f, 3.164992381e-03f, 3.159186343e-03f, 3.153279328e-03f, 3.147271609e-03f, 3.141163459e-03f, 
3.134955157e-03f, 3.128646984e-03f, 3.122239224e-03f, 3.115732164e-03f, 3.109126094e-03f, 3.102421309e-03f, 3.095618104e-03f, 3.088716779e-03f, 3.081717636e-03f, 3.074620983e-03f, 
3.067427127e-03f, 3.060136379e-03f, 3.052749056e-03f, 3.045265474e-03f, 3.037685954e-03f, 3.030010821e-03f, 3.022240400e-03f, 3.014375021e-03f, 3.006415018e-03f, 2.998360725e-03f, 
2.990212480e-03f, 2.981970626e-03f, 2.973635506e-03f, 2.965207467e-03f, 2.956686859e-03f, 2.948074034e-03f, 2.939369349e-03f, 2.930573162e-03f, 2.921685833e-03f, 2.912707726e-03f, 
2.903639209e-03f, 2.894480650e-03f, 2.885232422e-03f, 2.875894900e-03f, 2.866468461e-03f, 2.856953485e-03f, 2.847350356e-03f, 2.837659458e-03f, 2.827881181e-03f, 2.818015915e-03f, 
2.808064053e-03f, 2.798025992e-03f, 2.787902131e-03f, 2.777692870e-03f, 2.767398614e-03f, 2.757019768e-03f, 2.746556742e-03f, 2.736009948e-03f, 2.725379798e-03f, 2.714666710e-03f, 
2.703871103e-03f, 2.692993396e-03f, 2.682034015e-03f, 2.670993386e-03f, 2.659871936e-03f, 2.648670098e-03f, 2.637388303e-03f, 2.626026988e-03f, 2.614586592e-03f, 2.603067553e-03f, 
2.591470315e-03f, 2.579795322e-03f, 2.568043022e-03f, 2.556213865e-03f, 2.544308301e-03f, 2.532326785e-03f, 2.520269773e-03f, 2.508137722e-03f, 2.495931094e-03f, 2.483650351e-03f, 
2.471295958e-03f, 2.458868381e-03f, 2.446368089e-03f, 2.433795554e-03f, 2.421151249e-03f, 2.408435648e-03f, 2.395649229e-03f, 2.382792470e-03f, 2.369865854e-03f, 2.356869863e-03f, 
2.343804983e-03f, 2.330671700e-03f, 2.317470503e-03f, 2.304201883e-03f, 2.290866334e-03f, 2.277464349e-03f, 2.263996425e-03f, 2.250463061e-03f, 2.236864756e-03f, 2.223202013e-03f, 
2.209475335e-03f, 2.195685228e-03f, 2.181832199e-03f, 2.167916756e-03f, 2.153939412e-03f, 2.139900677e-03f, 2.125801066e-03f, 2.111641096e-03f, 2.097421282e-03f, 2.083142144e-03f, 
2.068804202e-03f, 2.054407979e-03f, 2.039953999e-03f, 2.025442786e-03f, 2.010874867e-03f, 1.996250771e-03f, 1.981571027e-03f, 1.966836166e-03f, 1.952046722e-03f, 1.937203227e-03f, 
1.922306218e-03f, 1.907356232e-03f, 1.892353806e-03f, 1.877299481e-03f, 1.862193797e-03f, 1.847037297e-03f, 1.831830523e-03f, 1.816574022e-03f, 1.801268339e-03f, 1.785914020e-03f, 
1.770511616e-03f, 1.755061675e-03f, 1.739564749e-03f, 1.724021389e-03f, 1.708432149e-03f, 1.692797584e-03f, 1.677118248e-03f, 1.661394697e-03f, 1.645627491e-03f, 1.629817187e-03f, 
1.613964345e-03f, 1.598069526e-03f, 1.582133291e-03f, 1.566156203e-03f, 1.550138825e-03f, 1.534081723e-03f, 1.517985461e-03f, 1.501850605e-03f, 1.485677724e-03f, 1.469467384e-03f, 
1.453220156e-03f, 1.436936607e-03f, 1.420617310e-03f, 1.404262835e-03f, 1.387873753e-03f, 1.371450638e-03f, 1.354994064e-03f, 1.338504604e-03f, 1.321982832e-03f, 1.305429326e-03f, 
1.288844659e-03f, 1.272229410e-03f, 1.255584155e-03f, 1.238909473e-03f, 1.222205941e-03f, 1.205474139e-03f, 1.188714645e-03f, 1.171928041e-03f, 1.155114906e-03f, 1.138275821e-03f, 
1.121411368e-03f, 1.104522128e-03f, 1.087608683e-03f, 1.070671617e-03f, 1.053711510e-03f, 1.036728948e-03f, 1.019724513e-03f, 1.002698789e-03f, 9.856523600e-04f, 9.685858106e-04f, 
9.514997253e-04f, 9.343946888e-04f, 9.172712861e-04f, 9.001301024e-04f, 8.829717229e-04f, 8.657967330e-04f, 8.486057185e-04f, 8.313992649e-04f, 8.141779580e-04f, 7.969423836e-04f, 
7.796931275e-04f, 7.624307756e-04f, 7.451559137e-04f, 7.278691278e-04f, 7.105710036e-04f, 6.932621269e-04f, 6.759430834e-04f, 6.586144585e-04f, 6.412768379e-04f, 6.239308068e-04f, 
6.065769504e-04f, 5.892158537e-04f, 5.718481015e-04f, 5.544742784e-04f, 5.370949687e-04f, 5.197107565e-04f, 5.023222257e-04f, 4.849299599e-04f, 4.675345421e-04f, 4.501365554e-04f, 
4.327365822e-04f, 4.153352049e-04f, 3.979330050e-04f, 3.805305642e-04f, 3.631284632e-04f, 3.457272826e-04f, 3.283276025e-04f, 3.109300025e-04f, 2.935350615e-04f, 2.761433582e-04f, 
2.587554705e-04f, 2.413719760e-04f, 2.239934514e-04f, 2.066204730e-04f, 1.892536165e-04f, 1.718934569e-04f, 1.545405686e-04f, 1.371955252e-04f, 1.198588998e-04f, 1.025312646e-04f, 
8.521319132e-05f, 6.790525062e-05f, 5.060801262e-05f, 3.332204658e-05f, 1.604792096e-05f, -1.213796589e-06f, -1.846253926e-05f, -3.569774110e-05f, -5.291883705e-05f, -7.012526291e-05f, 
-8.731645543e-05f, -1.044918523e-04f, -1.216508920e-04f, -1.387930143e-04f, -1.559176597e-04f, -1.730242696e-04f, -1.901122869e-04f, -2.071811549e-04f, -2.242303185e-04f, -2.412592234e-04f, 
-2.582673164e-04f, -2.752540455e-04f, -2.922188598e-04f, -3.091612095e-04f, -3.260805459e-04f, -3.429763218e-04f, -3.598479908e-04f, -3.766950079e-04f, -3.935168293e-04f, -4.103129126e-04f, 
-4.270827163e-04f, -4.438257007e-04f, -4.605413268e-04f, -4.772290575e-04f, -4.938883567e-04f, -5.105186896e-04f, -5.271195231e-04f, -5.436903250e-04f, -5.602305650e-04f, -5.767397140e-04f, 
-5.932172442e-04f, -6.096626294e-04f, -6.260753450e-04f, -6.424548676e-04f, -6.588006754e-04f, -6.751122483e-04f, -6.913890675e-04f, -7.076306159e-04f, -7.238363779e-04f, -7.400058395e-04f, 
-7.561384882e-04f, -7.722338133e-04f, -7.882913057e-04f, -8.043104577e-04f, -8.202907636e-04f, -8.362317191e-04f, -8.521328218e-04f, -8.679935709e-04f, -8.838134674e-04f, -8.995920140e-04f, 
-9.153287150e-04f, -9.310230768e-04f, -9.466746072e-04f, -9.622828162e-04f, -9.778472154e-04f, -9.933673181e-04f, -1.008842640e-03f, -1.024272697e-03f, -1.039657010e-03f, -1.054995099e-03f, 
-1.070286487e-03f, -1.085530698e-03f, -1.100727259e-03f, -1.115875699e-03f, -1.130975549e-03f, -1.146026341e-03f, -1.161027610e-03f, -1.175978891e-03f, -1.190879725e-03f, -1.205729650e-03f, 
-1.220528211e-03f, -1.235274952e-03f, -1.249969419e-03f, -1.264611162e-03f, -1.279199731e-03f, -1.293734679e-03f, -1.308215563e-03f, -1.322641938e-03f, -1.337013365e-03f, -1.351329406e-03f, 
-1.365589624e-03f, -1.379793585e-03f, -1.393940858e-03f, -1.408031012e-03f, -1.422063622e-03f, -1.436038262e-03f, -1.449954508e-03f, -1.463811941e-03f, -1.477610142e-03f, -1.491348696e-03f, 
-1.505027189e-03f, -1.518645209e-03f, -1.532202347e-03f, -1.545698198e-03f, -1.559132356e-03f, -1.572504419e-03f, -1.585813989e-03f, -1.599060669e-03f, -1.612244062e-03f, -1.625363778e-03f, 
-1.638419425e-03f, -1.651410617e-03f, -1.664336969e-03f, -1.677198099e-03f, -1.689993625e-03f, -1.702723170e-03f, -1.715386360e-03f, -1.727982822e-03f, -1.740512185e-03f, -1.752974082e-03f, 
-1.765368148e-03f, -1.777694020e-03f, -1.789951339e-03f, -1.802139747e-03f, -1.814258890e-03f, -1.826308414e-03f, -1.838287971e-03f, -1.850197213e-03f, -1.862035796e-03f, -1.873803378e-03f, 
-1.885499620e-03f, -1.897124186e-03f, -1.908676741e-03f, -1.920156954e-03f, -1.931564497e-03f, -1.942899044e-03f, -1.954160271e-03f, -1.965347859e-03f, -1.976461489e-03f, -1.987500846e-03f, 
-1.998465618e-03f, -2.009355496e-03f, -2.020170172e-03f, -2.030909342e-03f, -2.041572704e-03f, -2.052159961e-03f, -2.062670817e-03f, -2.073104977e-03f, -2.083462152e-03f, -2.093742055e-03f, 
-2.103944401e-03f, -2.114068907e-03f, -2.124115295e-03f, -2.134083288e-03f, -2.143972613e-03f, -2.153783000e-03f, -2.163514180e-03f, -2.173165890e-03f, -2.182737865e-03f, -2.192229848e-03f, 
-2.201641583e-03f, -2.210972815e-03f, -2.220223294e-03f, -2.229392773e-03f, -2.238481006e-03f, -2.247487752e-03f, -2.256412772e-03f, -2.265255830e-03f, -2.274016693e-03f, -2.282695130e-03f, 
-2.291290914e-03f, -2.299803821e-03f, -2.308233629e-03f, -2.316580120e-03f, -2.324843079e-03f, -2.333022293e-03f, -2.341117552e-03f, -2.349128650e-03f, -2.357055382e-03f, -2.364897550e-03f, 
-2.372654953e-03f, -2.380327399e-03f, -2.387914694e-03f, -2.395416651e-03f, -2.402833084e-03f, -2.410163810e-03f, -2.417408649e-03f, -2.424567424e-03f, -2.431639962e-03f, -2.438626092e-03f, 
-2.445525646e-03f, -2.452338460e-03f, -2.459064372e-03f, -2.465703223e-03f, -2.472254858e-03f, -2.478719124e-03f, -2.485095872e-03f, -2.491384955e-03f, -2.497586230e-03f, -2.503699557e-03f, 
-2.509724797e-03f, -2.515661817e-03f, -2.521510485e-03f, -2.527270674e-03f, -2.532942258e-03f, -2.538525115e-03f, -2.544019126e-03f, -2.549424175e-03f, -2.554740149e-03f, -2.559966938e-03f, 
-2.565104437e-03f, -2.570152539e-03f, -2.575111147e-03f, -2.579980160e-03f, -2.584759486e-03f, -2.589449033e-03f, -2.594048712e-03f, -2.598558438e-03f, -2.602978129e-03f, -2.607307705e-03f, 
-2.611547091e-03f, -2.615696214e-03f, -2.619755003e-03f, -2.623723393e-03f, -2.627601318e-03f, -2.631388719e-03f, -2.635085537e-03f, -2.638691719e-03f, -2.642207212e-03f, -2.645631968e-03f, 
-2.648965943e-03f, -2.652209093e-03f, -2.655361379e-03f, -2.658422766e-03f, -2.661393219e-03f, -2.664272710e-03f, -2.667061211e-03f, -2.669758699e-03f, -2.672365152e-03f, -2.674880553e-03f, 
-2.677304886e-03f, -2.679638142e-03f, -2.681880310e-03f, -2.684031385e-03f, -2.686091365e-03f, -2.688060250e-03f, -2.689938044e-03f, -2.691724754e-03f, -2.693420388e-03f, -2.695024961e-03f, 
-2.696538488e-03f, -2.697960987e-03f, -2.699292480e-03f, -2.700532992e-03f, -2.701682551e-03f, -2.702741189e-03f, -2.703708937e-03f, -2.704585835e-03f, -2.705371921e-03f, -2.706067239e-03f, 
-2.706671834e-03f, -2.707185755e-03f, -2.707609055e-03f, -2.707941788e-03f, -2.708184012e-03f, -2.708335788e-03f, -2.708397180e-03f, -2.708368255e-03f, -2.708249082e-03f, -2.708039734e-03f, 
-2.707740287e-03f, -2.707350820e-03f, -2.706871414e-03f, -2.706302154e-03f, -2.705643127e-03f, -2.704894424e-03f, -2.704056139e-03f, -2.703128366e-03f, -2.702111207e-03f, -2.701004762e-03f, 
-2.699809137e-03f, -2.698524440e-03f, -2.697150782e-03f, -2.695688276e-03f, -2.694137039e-03f, -2.692497190e-03f, -2.690768852e-03f, -2.688952150e-03f, -2.687047213e-03f, -2.685054170e-03f, 
-2.682973157e-03f, -2.680804309e-03f, -2.678547765e-03f, -2.676203669e-03f, -2.673772166e-03f, -2.671253402e-03f, -2.668647530e-03f, -2.665954702e-03f, -2.663175075e-03f, -2.660308807e-03f, 
-2.657356062e-03f, -2.654317003e-03f, -2.651191797e-03f, -2.647980615e-03f, -2.644683631e-03f, -2.641301018e-03f, -2.637832957e-03f, -2.634279627e-03f, -2.630641213e-03f, -2.626917901e-03f, 
-2.623109880e-03f, -2.619217342e-03f, -2.615240483e-03f, -2.611179498e-03f, -2.607034588e-03f, -2.602805955e-03f, -2.598493806e-03f, -2.594098346e-03f, -2.589619788e-03f, -2.585058343e-03f, 
-2.580414228e-03f, -2.575687661e-03f, -2.570878862e-03f, -2.565988056e-03f, -2.561015468e-03f, -2.555961327e-03f, -2.550825864e-03f, -2.545609312e-03f, -2.540311909e-03f, -2.534933892e-03f, 
-2.529475502e-03f, -2.523936985e-03f, -2.518318585e-03f, -2.512620551e-03f, -2.506843135e-03f, -2.500986591e-03f, -2.495051174e-03f, -2.489037143e-03f, -2.482944759e-03f, -2.476774286e-03f, 
-2.470525989e-03f, -2.464200136e-03f, -2.457796998e-03f, -2.451316848e-03f, -2.444759962e-03f, -2.438126617e-03f, -2.431417092e-03f, -2.424631672e-03f, -2.417770639e-03f, -2.410834282e-03f, 
-2.403822889e-03f, -2.396736752e-03f, -2.389576165e-03f, -2.382341424e-03f, -2.375032827e-03f, -2.367650676e-03f, -2.360195272e-03f, -2.352666922e-03f, -2.345065932e-03f, -2.337392611e-03f, 
-2.329647272e-03f, -2.321830229e-03f, -2.313941796e-03f, -2.305982293e-03f, -2.297952039e-03f, -2.289851358e-03f, -2.281680572e-03f, -2.273440010e-03f, -2.265130000e-03f, -2.256750872e-03f, 
-2.248302959e-03f, -2.239786597e-03f, -2.231202121e-03f, -2.222549871e-03f, -2.213830188e-03f, -2.205043415e-03f, -2.196189896e-03f, -2.187269978e-03f, -2.178284011e-03f, -2.169232344e-03f, 
-2.160115331e-03f, -2.150933326e-03f, -2.141686685e-03f, -2.132375768e-03f, -2.123000933e-03f, -2.113562544e-03f, -2.104060964e-03f, -2.094496560e-03f, -2.084869697e-03f, -2.075180747e-03f, 
-2.065430080e-03f, -2.055618069e-03f, -2.045745089e-03f, -2.035811517e-03f, -2.025817730e-03f, -2.015764109e-03f, -2.005651035e-03f, -1.995478891e-03f, -1.985248064e-03f, -1.974958938e-03f, 
-1.964611904e-03f, -1.954207350e-03f, -1.943745669e-03f, -1.933227253e-03f, -1.922652497e-03f, -1.912021799e-03f, -1.901335555e-03f, -1.890594165e-03f, -1.879798031e-03f, -1.868947555e-03f, 
-1.858043141e-03f, -1.847085194e-03f, -1.836074122e-03f, -1.825010333e-03f, -1.813894238e-03f, -1.802726247e-03f, -1.791506773e-03f, -1.780236232e-03f, -1.768915037e-03f, -1.757543607e-03f, 
-1.746122359e-03f, -1.734651714e-03f, -1.723132092e-03f, -1.711563915e-03f, -1.699947608e-03f, -1.688283595e-03f, -1.676572303e-03f, -1.664814159e-03f, -1.653009591e-03f, -1.641159029e-03f, 
-1.629262905e-03f, -1.617321651e-03f, -1.605335701e-03f, -1.593305488e-03f, -1.581231449e-03f, -1.569114021e-03f, -1.556953641e-03f, -1.544750750e-03f, -1.532505786e-03f, -1.520219192e-03f, 
-1.507891410e-03f, -1.495522882e-03f, -1.483114054e-03f, -1.470665371e-03f, -1.458177279e-03f, -1.445650226e-03f, -1.433084660e-03f, -1.420481029e-03f, -1.407839785e-03f, -1.395161379e-03f, 
-1.382446262e-03f, -1.369694887e-03f, -1.356907709e-03f, -1.344085181e-03f, -1.331227759e-03f, -1.318335899e-03f, -1.305410059e-03f, -1.292450695e-03f, -1.279458268e-03f, -1.266433235e-03f, 
-1.253376058e-03f, -1.240287196e-03f, -1.227167112e-03f, -1.214016268e-03f, -1.200835125e-03f, -1.187624149e-03f, -1.174383803e-03f, -1.161114552e-03f, -1.147816861e-03f, -1.134491196e-03f, 
-1.121138024e-03f, -1.107757812e-03f, -1.094351027e-03f, -1.080918138e-03f, -1.067459614e-03f, -1.053975923e-03f, -1.040467535e-03f, -1.026934921e-03f, -1.013378551e-03f, -9.997988952e-04f, 
-9.861964263e-04f, -9.725716155e-04f, -9.589249352e-04f, -9.452568579e-04f, -9.315678565e-04f, -9.178584043e-04f, -9.041289748e-04f, -8.903800420e-04f, -8.766120799e-04f, -8.628255631e-04f, 
-8.490209661e-04f, -8.351987640e-04f, -8.213594319e-04f, -8.075034450e-04f, -7.936312791e-04f, -7.797434097e-04f, -7.658403128e-04f, -7.519224643e-04f, -7.379903404e-04f, -7.240444174e-04f, 
-7.100851715e-04f, -6.961130792e-04f, -6.821286170e-04f, -6.681322615e-04f, -6.541244890e-04f, -6.401057763e-04f, -6.260765999e-04f, -6.120374362e-04f, -5.979887619e-04f, -5.839310534e-04f, 
-5.698647871e-04f, -5.557904392e-04f, -5.417084861e-04f, -5.276194037e-04f, -5.135236681e-04f, -4.994217550e-04f, -4.853141402e-04f, -4.712012991e-04f, -4.570837070e-04f, -4.429618389e-04f, 
-4.288361698e-04f, -4.147071742e-04f, -4.005753265e-04f, -3.864411008e-04f, -3.723049708e-04f, -3.581674101e-04f, -3.440288918e-04f, -3.298898888e-04f, -3.157508735e-04f, -3.016123181e-04f, 
-2.874746943e-04f, -2.733384734e-04f, -2.592041265e-04f, -2.450721239e-04f, -2.309429358e-04f, -2.168170317e-04f, -2.026948808e-04f, -1.885769517e-04f, -1.744637125e-04f, -1.603556309e-04f, 
-1.462531740e-04f, -1.321568082e-04f, -1.180669995e-04f, -1.039842133e-04f, -8.990891438e-05f, -7.584156694e-05f, -6.178263450e-05f, -4.773257998e-05f, -3.369186561e-05f, -1.966095299e-05f, 
-5.640302998e-06f, 8.369624171e-06f, 2.236836904e-05f, 3.635547287e-05f, 5.033047765e-05f, 6.429292616e-05f, 7.824236192e-05f, 9.217832926e-05f, 1.061003733e-04f, 1.200080400e-04f, 
1.339008762e-04f, 1.477784294e-04f, 1.616402482e-04f, 1.754858820e-04f, 1.893148809e-04f, 2.031267963e-04f, 2.169211800e-04f, 2.306975853e-04f, 2.444555660e-04f, 2.581946771e-04f, 
2.719144746e-04f, 2.856145152e-04f, 2.992943569e-04f, 3.129535587e-04f, 3.265916805e-04f, 3.402082833e-04f, 3.538029292e-04f, 3.673751813e-04f, 3.809246038e-04f, 3.944507622e-04f, 
4.079532228e-04f, 4.214315532e-04f, 4.348853222e-04f, 4.483140996e-04f, 4.617174565e-04f, 4.750949651e-04f, 4.884461989e-04f, 5.017707325e-04f, 5.150681418e-04f, 5.283380039e-04f, 
5.415798971e-04f, 5.547934011e-04f, 5.679780967e-04f, 5.811335662e-04f, 5.942593930e-04f, 6.073551620e-04f, 6.204204593e-04f, 6.334548723e-04f, 6.464579899e-04f, 6.594294023e-04f, 
6.723687011e-04f, 6.852754792e-04f, 6.981493311e-04f, 7.109898524e-04f, 7.237966405e-04f, 7.365692940e-04f, 7.493074130e-04f, 7.620105991e-04f, 7.746784554e-04f, 7.873105864e-04f, 
7.999065982e-04f, 8.124660984e-04f, 8.249886960e-04f, 8.374740017e-04f, 8.499216277e-04f, 8.623311878e-04f, 8.747022973e-04f, 8.870345730e-04f, 8.993276336e-04f, 9.115810991e-04f, 
9.237945913e-04f, 9.359677335e-04f, 9.481001508e-04f, 9.601914699e-04f, 9.722413191e-04f, 9.842493283e-04f, 9.962151294e-04f, 1.008138356e-03f, 1.020018642e-03f, 1.031855626e-03f, 
1.043648946e-03f, 1.055398241e-03f, 1.067103155e-03f, 1.078763330e-03f, 1.090378414e-03f, 1.101948052e-03f, 1.113471894e-03f, 1.124949591e-03f, 1.136380796e-03f, 1.147765164e-03f, 
1.159102351e-03f, 1.170392015e-03f, 1.181633817e-03f, 1.192827418e-03f, 1.203972482e-03f, 1.215068676e-03f, 1.226115667e-03f, 1.237113124e-03f, 1.248060720e-03f, 1.258958127e-03f, 
1.269805020e-03f, 1.280601078e-03f, 1.291345980e-03f, 1.302039406e-03f, 1.312681040e-03f, 1.323270567e-03f, 1.333807675e-03f, 1.344292052e-03f, 1.354723390e-03f, 1.365101381e-03f, 
1.375425721e-03f, 1.385696108e-03f, 1.395912241e-03f, 1.406073820e-03f, 1.416180550e-03f, 1.426232135e-03f, 1.436228284e-03f, 1.446168706e-03f, 1.456053112e-03f, 1.465881218e-03f, 
1.475652737e-03f, 1.485367389e-03f, 1.495024894e-03f, 1.504624974e-03f, 1.514167353e-03f, 1.523651758e-03f, 1.533077918e-03f, 1.542445563e-03f, 1.551754428e-03f, 1.561004246e-03f, 
1.570194755e-03f, 1.579325696e-03f, 1.588396809e-03f, 1.597407839e-03f, 1.606358532e-03f, 1.615248636e-03f, 1.624077902e-03f, 1.632846084e-03f, 1.641552935e-03f, 1.650198214e-03f, 
1.658781681e-03f, 1.667303096e-03f, 1.675762224e-03f, 1.684158832e-03f, 1.692492688e-03f, 1.700763564e-03f, 1.708971231e-03f, 1.717115467e-03f, 1.725196049e-03f, 1.733212757e-03f, 
1.741165373e-03f, 1.749053682e-03f, 1.756877472e-03f, 1.764636531e-03f, 1.772330652e-03f, 1.779959629e-03f, 1.787523257e-03f, 1.795021337e-03f, 1.802453668e-03f, 1.809820054e-03f, 
1.817120302e-03f, 1.824354219e-03f, 1.831521616e-03f, 1.838622306e-03f, 1.845656105e-03f, 1.852622829e-03f, 1.859522299e-03f, 1.866354338e-03f, 1.873118770e-03f, 1.879815423e-03f, 
1.886444126e-03f, 1.893004712e-03f, 1.899497014e-03f, 1.905920871e-03f, 1.912276121e-03f, 1.918562605e-03f, 1.924780169e-03f, 1.930928659e-03f, 1.937007923e-03f, 1.943017814e-03f, 
1.948958184e-03f, 1.954828892e-03f, 1.960629794e-03f, 1.966360753e-03f, 1.972021633e-03f, 1.977612298e-03f, 1.983132619e-03f, 1.988582466e-03f, 1.993961712e-03f, 1.999270234e-03f, 
2.004507909e-03f, 2.009674620e-03f, 2.014770249e-03f, 2.019794681e-03f, 2.024747807e-03f, 2.029629515e-03f, 2.034439700e-03f, 2.039178256e-03f, 2.043845084e-03f, 2.048440082e-03f, 
2.052963154e-03f, 2.057414207e-03f, 2.061793147e-03f, 2.066099886e-03f, 2.070334337e-03f, 2.074496415e-03f, 2.078586039e-03f, 2.082603128e-03f, 2.086547607e-03f, 2.090419400e-03f, 
2.094218436e-03f, 2.097944645e-03f, 2.101597961e-03f, 2.105178318e-03f, 2.108685655e-03f, 2.112119913e-03f, 2.115481033e-03f, 2.118768962e-03f, 2.121983648e-03f, 2.125125042e-03f, 
2.128193095e-03f, 2.131187764e-03f, 2.134109007e-03f, 2.136956783e-03f, 2.139731056e-03f, 2.142431792e-03f, 2.145058958e-03f, 2.147612525e-03f, 2.150092464e-03f, 2.152498753e-03f, 
2.154831368e-03f, 2.157090291e-03f, 2.159275503e-03f, 2.161386990e-03f, 2.163424739e-03f, 2.165388742e-03f, 2.167278991e-03f, 2.169095480e-03f, 2.170838208e-03f, 2.172507174e-03f, 
2.174102382e-03f, 2.175623836e-03f, 2.177071544e-03f, 2.178445516e-03f, 2.179745764e-03f, 2.180972303e-03f, 2.182125151e-03f, 2.183204326e-03f, 2.184209853e-03f, 2.185141755e-03f, 
2.186000059e-03f, 2.186784795e-03f, 2.187495995e-03f, 2.188133693e-03f, 2.188697927e-03f, 2.189188735e-03f, 2.189606160e-03f, 2.189950245e-03f, 2.190221037e-03f, 2.190418586e-03f, 
2.190542942e-03f, 2.190594159e-03f, 2.190572294e-03f, 2.190477405e-03f, 2.190309553e-03f, 2.190068802e-03f, 2.189755217e-03f, 2.189368867e-03f, 2.188909822e-03f, 2.188378155e-03f, 
2.187773941e-03f, 2.187097259e-03f, 2.186348188e-03f, 2.185526810e-03f, 2.184633210e-03f, 2.183667476e-03f, 2.182629697e-03f, 2.181519965e-03f, 2.180338373e-03f, 2.179085018e-03f, 
2.177760000e-03f, 2.176363418e-03f, 2.174895377e-03f, 2.173355982e-03f, 2.171745342e-03f, 2.170063566e-03f, 2.168310767e-03f, 2.166487061e-03f, 2.164592563e-03f, 2.162627395e-03f, 
2.160591677e-03f, 2.158485533e-03f, 2.156309090e-03f, 2.154062476e-03f, 2.151745822e-03f, 2.149359262e-03f, 2.146902929e-03f, 2.144376962e-03f, 2.141781500e-03f, 2.139116686e-03f, 
2.136382663e-03f, 2.133579577e-03f, 2.130707578e-03f, 2.127766815e-03f, 2.124757442e-03f, 2.121679613e-03f, 2.118533486e-03f, 2.115319221e-03f, 2.112036978e-03f, 2.108686922e-03f, 
2.105269217e-03f, 2.101784033e-03f, 2.098231539e-03f, 2.094611908e-03f, 2.090925313e-03f, 2.087171931e-03f, 2.083351940e-03f, 2.079465522e-03f, 2.075512858e-03f, 2.071494133e-03f, 
2.067409535e-03f, 2.063259252e-03f, 2.059043475e-03f, 2.054762396e-03f, 2.050416212e-03f, 2.046005118e-03f, 2.041529314e-03f, 2.036989000e-03f, 2.032384381e-03f, 2.027715660e-03f, 
2.022983045e-03f, 2.018186744e-03f, 2.013326969e-03f, 2.008403933e-03f, 2.003417850e-03f, 1.998368937e-03f, 1.993257412e-03f, 1.988083497e-03f, 1.982847414e-03f, 1.977549387e-03f, 
1.972189642e-03f, 1.966768408e-03f, 1.961285915e-03f, 1.955742395e-03f, 1.950138082e-03f, 1.944473210e-03f, 1.938748018e-03f, 1.932962746e-03f, 1.927117633e-03f, 1.921212924e-03f, 
1.915248862e-03f, 1.909225695e-03f, 1.903143670e-03f, 1.897003038e-03f, 1.890804051e-03f, 1.884546962e-03f, 1.878232027e-03f, 1.871859502e-03f, 1.865429647e-03f, 1.858942721e-03f, 
1.852398988e-03f, 1.845798711e-03f, 1.839142156e-03f, 1.832429589e-03f, 1.825661281e-03f, 1.818837501e-03f, 1.811958521e-03f, 1.805024616e-03f, 1.798036061e-03f, 1.790993133e-03f, 
1.783896111e-03f, 1.776745274e-03f, 1.769540906e-03f, 1.762283288e-03f, 1.754972707e-03f, 1.747609448e-03f, 1.740193800e-03f, 1.732726053e-03f, 1.725206496e-03f, 1.717635424e-03f, 
1.710013129e-03f, 1.702339908e-03f, 1.694616058e-03f, 1.686841876e-03f, 1.679017663e-03f, 1.671143721e-03f, 1.663220351e-03f, 1.655247859e-03f, 1.647226550e-03f, 1.639156730e-03f, 
1.631038708e-03f, 1.622872795e-03f, 1.614659300e-03f, 1.606398536e-03f, 1.598090818e-03f, 1.589736460e-03f, 1.581335778e-03f, 1.572889090e-03f, 1.564396716e-03f, 1.555858975e-03f, 
1.547276189e-03f, 1.538648681e-03f, 1.529976774e-03f, 1.521260795e-03f, 1.512501068e-03f, 1.503697923e-03f, 1.494851687e-03f, 1.485962691e-03f, 1.477031266e-03f, 1.468057744e-03f, 
1.459042460e-03f, 1.449985746e-03f, 1.440887939e-03f, 1.431749377e-03f, 1.422570396e-03f, 1.413351336e-03f, 1.404092537e-03f, 1.394794340e-03f, 1.385457087e-03f, 1.376081122e-03f, 
1.366666788e-03f, 1.357214432e-03f, 1.347724398e-03f, 1.338197035e-03f, 1.328632690e-03f, 1.319031713e-03f, 1.309394453e-03f, 1.299721263e-03f, 1.290012493e-03f, 1.280268497e-03f, 
1.270489628e-03f, 1.260676241e-03f, 1.250828692e-03f, 1.240947337e-03f, 1.231032532e-03f, 1.221084637e-03f, 1.211104010e-03f, 1.201091011e-03f, 1.191046000e-03f, 1.180969338e-03f, 
1.170861388e-03f, 1.160722512e-03f, 1.150553074e-03f, 1.140353437e-03f, 1.130123968e-03f, 1.119865032e-03f, 1.109576994e-03f, 1.099260223e-03f, 1.088915085e-03f, 1.078541950e-03f, 
1.068141186e-03f, 1.057713162e-03f, 1.047258250e-03f, 1.036776820e-03f, 1.026269243e-03f, 1.015735892e-03f, 1.005177139e-03f, 9.945933573e-04f, 9.839849203e-04f, 9.733522024e-04f, 
9.626955784e-04f, 9.520154235e-04f, 9.413121133e-04f, 9.305860241e-04f, 9.198375325e-04f, 9.090670156e-04f, 8.982748509e-04f, 8.874614164e-04f, 8.766270903e-04f, 8.657722516e-04f, 
8.548972792e-04f, 8.440025527e-04f, 8.330884520e-04f, 8.221553572e-04f, 8.112036489e-04f, 8.002337080e-04f, 7.892459155e-04f, 7.782406530e-04f, 7.672183021e-04f, 7.561792448e-04f, 
7.451238634e-04f, 7.340525404e-04f, 7.229656584e-04f, 7.118636004e-04f, 7.007467494e-04f, 6.896154889e-04f, 6.784702022e-04f, 6.673112730e-04f, 6.561390852e-04f, 6.449540225e-04f, 
6.337564691e-04f, 6.225468092e-04f, 6.113254269e-04f, 6.000927065e-04f, 5.888490326e-04f, 5.775947896e-04f, 5.663303619e-04f, 5.550561341e-04f, 5.437724908e-04f, 5.324798165e-04f, 
5.211784958e-04f, 5.098689132e-04f, 4.985514532e-04f, 4.872265002e-04f, 4.758944387e-04f, 4.645556530e-04f, 4.532105273e-04f, 4.418594457e-04f, 4.305027924e-04f, 4.191409511e-04f, 
4.077743057e-04f, 3.964032399e-04f, 3.850281369e-04f, 3.736493803e-04f, 3.622673530e-04f, 3.508824380e-04f, 3.394950179e-04f, 3.281054753e-04f, 3.167141923e-04f, 3.053215509e-04f, 
2.939279329e-04f, 2.825337198e-04f, 2.711392925e-04f, 2.597450321e-04f, 2.483513191e-04f, 2.369585336e-04f, 2.255670556e-04f, 2.141772646e-04f, 2.027895397e-04f, 1.914042598e-04f, 
1.800218032e-04f, 1.686425480e-04f, 1.572668718e-04f, 1.458951517e-04f, 1.345277644e-04f, 1.231650863e-04f, 1.118074931e-04f, 1.004553603e-04f, 8.910906266e-05f, 7.776897455e-05f, 
6.643546983e-05f, 5.510892185e-05f, 4.378970341e-05f, 3.247818674e-05f, 2.117474356e-05f, 9.879744976e-06f, -1.406438460e-06f, -1.268343680e-05f, -2.395088071e-05f, -3.520840147e-05f, 
-4.645563097e-05f, -5.769220177e-05f, -6.891774707e-05f, -8.013190074e-05f, -9.133429732e-05f, -1.025245720e-04f, -1.137023609e-04f, -1.248673004e-04f, -1.360190280e-04f, -1.471571819e-04f, 
-1.582814007e-04f, -1.693913243e-04f, -1.804865929e-04f, -1.915668477e-04f, -2.026317307e-04f, -2.136808846e-04f, -2.247139529e-04f, -2.357305802e-04f, -2.467304116e-04f, -2.577130932e-04f, 
-2.686782720e-04f, -2.796255958e-04f, -2.905547133e-04f, -3.014652740e-04f, -3.123569286e-04f, -3.232293283e-04f, -3.340821256e-04f, -3.449149737e-04f, -3.557275269e-04f, -3.665194403e-04f, 
-3.772903701e-04f, -3.880399734e-04f, -3.987679084e-04f, -4.094738342e-04f, -4.201574109e-04f, -4.308182998e-04f, -4.414561629e-04f, -4.520706636e-04f, -4.626614662e-04f, -4.732282360e-04f, 
-4.837706395e-04f, -4.942883441e-04f, -5.047810186e-04f, -5.152483326e-04f, -5.256899570e-04f, -5.361055638e-04f, -5.464948261e-04f, -5.568574180e-04f, -5.671930152e-04f, -5.775012940e-04f, 
-5.877819324e-04f, -5.980346091e-04f, -6.082590045e-04f, -6.184547997e-04f, -6.286216774e-04f, -6.387593214e-04f, -6.488674166e-04f, -6.589456494e-04f, -6.689937073e-04f, -6.790112790e-04f, 
-6.889980546e-04f, -6.989537254e-04f, -7.088779842e-04f, -7.187705247e-04f, -7.286310423e-04f, -7.384592335e-04f, -7.482547962e-04f, -7.580174297e-04f, -7.677468344e-04f, -7.774427124e-04f, 
-7.871047668e-04f, -7.967327025e-04f, -8.063262254e-04f, -8.158850430e-04f, -8.254088641e-04f, -8.348973990e-04f, -8.443503592e-04f, -8.537674580e-04f, -8.631484098e-04f, -8.724929306e-04f, 
-8.818007378e-04f, -8.910715503e-04f, -9.003050884e-04f, -9.095010740e-04f, -9.186592302e-04f, -9.277792820e-04f, -9.368609556e-04f, -9.459039787e-04f, -9.549080808e-04f, -9.638729926e-04f, 
-9.727984465e-04f, -9.816841764e-04f, -9.905299178e-04f, -9.993354076e-04f, -1.008100384e-03f, -1.016824588e-03f, -1.025507761e-03f, -1.034149646e-03f, -1.042749988e-03f, -1.051308534e-03f, 
-1.059825031e-03f, -1.068299229e-03f, -1.076730880e-03f, -1.085119737e-03f, -1.093465553e-03f, -1.101768086e-03f, -1.110027094e-03f, -1.118242335e-03f, -1.126413571e-03f, -1.134540564e-03f, 
-1.142623080e-03f, -1.150660885e-03f, -1.158653746e-03f, -1.166601433e-03f, -1.174503717e-03f, -1.182360371e-03f, -1.190171170e-03f, -1.197935891e-03f, -1.205654311e-03f, -1.213326211e-03f, 
-1.220951371e-03f, -1.228529576e-03f, -1.236060611e-03f, -1.243544262e-03f, -1.250980317e-03f, -1.258368569e-03f, -1.265708807e-03f, -1.273000827e-03f, -1.280244424e-03f, -1.287439396e-03f, 
-1.294585542e-03f, -1.301682663e-03f, -1.308730561e-03f, -1.315729043e-03f, -1.322677913e-03f, -1.329576981e-03f, -1.336426057e-03f, -1.343224952e-03f, -1.349973481e-03f, -1.356671458e-03f, 
-1.363318703e-03f, -1.369915033e-03f, -1.376460271e-03f, -1.382954239e-03f, -1.389396762e-03f, -1.395787667e-03f, -1.402126783e-03f, -1.408413939e-03f, -1.414648970e-03f, -1.420831708e-03f, 
-1.426961990e-03f, -1.433039654e-03f, -1.439064540e-03f, -1.445036490e-03f, -1.450955348e-03f, -1.456820959e-03f, -1.462633171e-03f, -1.468391833e-03f, -1.474096797e-03f, -1.479747916e-03f, 
-1.485345045e-03f, -1.490888042e-03f, -1.496376766e-03f, -1.501811077e-03f, -1.507190838e-03f, -1.512515915e-03f, -1.517786174e-03f, -1.523001485e-03f, -1.528161717e-03f, -1.533266743e-03f, 
-1.538316439e-03f, -1.543310681e-03f, -1.548249347e-03f, -1.553132317e-03f, -1.557959475e-03f, -1.562730704e-03f, -1.567445892e-03f, -1.572104926e-03f, -1.576707697e-03f, -1.581254097e-03f, 
-1.585744020e-03f, -1.590177363e-03f, -1.594554024e-03f, -1.598873903e-03f, -1.603136902e-03f, -1.607342926e-03f, -1.611491880e-03f, -1.615583674e-03f, -1.619618216e-03f, -1.623595420e-03f, 
-1.627515199e-03f, -1.631377469e-03f, -1.635182149e-03f, -1.638929159e-03f, -1.642618421e-03f, -1.646249858e-03f, -1.649823398e-03f, -1.653338967e-03f, -1.656796497e-03f, -1.660195919e-03f, 
-1.663537168e-03f, -1.666820179e-03f, -1.670044892e-03f, -1.673211244e-03f, -1.676319180e-03f, -1.679368643e-03f, -1.682359579e-03f, -1.685291937e-03f, -1.688165666e-03f, -1.690980718e-03f, 
-1.693737048e-03f, -1.696434613e-03f, -1.699073369e-03f, -1.701653277e-03f, -1.704174300e-03f, -1.706636401e-03f, -1.709039547e-03f, -1.711383706e-03f, -1.713668848e-03f, -1.715894945e-03f, 
-1.718061971e-03f, -1.720169903e-03f, -1.722218718e-03f, -1.724208397e-03f, -1.726138922e-03f, -1.728010278e-03f, -1.729822449e-03f, -1.731575425e-03f, -1.733269195e-03f, -1.734903752e-03f, 
-1.736479090e-03f, -1.737995205e-03f, -1.739452094e-03f, -1.740849758e-03f, -1.742188200e-03f, -1.743467422e-03f, -1.744687432e-03f, -1.745848236e-03f, -1.746949846e-03f, -1.747992272e-03f, 
-1.748975530e-03f, -1.749899634e-03f, -1.750764602e-03f, -1.751570455e-03f, -1.752317214e-03f, -1.753004903e-03f, -1.753633548e-03f, -1.754203175e-03f, -1.754713816e-03f, -1.755165501e-03f, 
-1.755558263e-03f, -1.755892139e-03f, -1.756167166e-03f, -1.756383383e-03f, -1.756540831e-03f, -1.756639553e-03f, -1.756679595e-03f, -1.756661004e-03f, -1.756583828e-03f, -1.756448119e-03f, 
-1.756253929e-03f, -1.756001313e-03f, -1.755690328e-03f, -1.755321032e-03f, -1.754893486e-03f, -1.754407751e-03f, -1.753863894e-03f, -1.753261978e-03f, -1.752602073e-03f, -1.751884249e-03f, 
-1.751108577e-03f, -1.750275131e-03f, -1.749383986e-03f, -1.748435220e-03f, -1.747428912e-03f, -1.746365143e-03f, -1.745243997e-03f, -1.744065558e-03f, -1.742829913e-03f, -1.741537150e-03f, 
-1.740187360e-03f, -1.738780635e-03f, -1.737317070e-03f, -1.735796759e-03f, -1.734219801e-03f, -1.732586295e-03f, -1.730896343e-03f, -1.729150047e-03f, -1.727347513e-03f, -1.725488847e-03f, 
-1.723574159e-03f, -1.721603557e-03f, -1.719577154e-03f, -1.717495065e-03f, -1.715357405e-03f, -1.713164291e-03f, -1.710915842e-03f, -1.708612179e-03f, -1.706253425e-03f, -1.703839705e-03f, 
-1.701371144e-03f, -1.698847870e-03f, -1.696270014e-03f, -1.693637706e-03f, -1.690951079e-03f, -1.688210268e-03f, -1.685415410e-03f, -1.682566642e-03f, -1.679664105e-03f, -1.676707940e-03f, 
-1.673698290e-03f, -1.670635301e-03f, -1.667519118e-03f, -1.664349890e-03f, -1.661127767e-03f, -1.657852900e-03f, -1.654525443e-03f, -1.651145549e-03f, -1.647713377e-03f, -1.644229083e-03f, 
-1.640692827e-03f, -1.637104770e-03f, -1.633465076e-03f, -1.629773909e-03f, -1.626031435e-03f, -1.622237821e-03f, -1.618393237e-03f, -1.614497853e-03f, -1.610551842e-03f, -1.606555378e-03f, 
-1.602508635e-03f, -1.598411792e-03f, -1.594265025e-03f, -1.590068517e-03f, -1.585822447e-03f, -1.581526999e-03f, -1.577182358e-03f, -1.572788709e-03f, -1.568346241e-03f, -1.563855141e-03f, 
-1.559315601e-03f, -1.554727813e-03f, -1.550091969e-03f, -1.545408265e-03f, -1.540676897e-03f, -1.535898062e-03f, -1.531071961e-03f, -1.526198793e-03f, -1.521278760e-03f, -1.516312065e-03f, 
-1.511298914e-03f, -1.506239513e-03f, -1.501134069e-03f, -1.495982791e-03f, -1.490785889e-03f, -1.485543575e-03f, -1.480256062e-03f, -1.474923563e-03f, -1.469546296e-03f, -1.464124476e-03f, 
-1.458658322e-03f, -1.453148054e-03f, -1.447593892e-03f, -1.441996058e-03f, -1.436354776e-03f, -1.430670271e-03f, -1.424942768e-03f, -1.419172495e-03f, -1.413359680e-03f, -1.407504553e-03f, 
-1.401607344e-03f, -1.395668286e-03f, -1.389687613e-03f, -1.383665558e-03f, -1.377602357e-03f, -1.371498248e-03f, -1.365353468e-03f, -1.359168256e-03f, -1.352942854e-03f, -1.346677502e-03f, 
-1.340372443e-03f, -1.334027921e-03f, -1.327644181e-03f, -1.321221469e-03f, -1.314760032e-03f, -1.308260119e-03f, -1.301721978e-03f, -1.295145860e-03f, -1.288532016e-03f, -1.281880699e-03f, 
-1.275192163e-03f, -1.268466662e-03f, -1.261704451e-03f, -1.254905788e-03f, -1.248070929e-03f, -1.241200134e-03f, -1.234293662e-03f, -1.227351774e-03f, -1.220374731e-03f, -1.213362795e-03f, 
-1.206316231e-03f, -1.199235303e-03f, -1.192120276e-03f, -1.184971416e-03f, -1.177788990e-03f, -1.170573267e-03f, -1.163324515e-03f, -1.156043005e-03f, -1.148729006e-03f, -1.141382791e-03f, 
-1.134004633e-03f, -1.126594803e-03f, -1.119153577e-03f, -1.111681230e-03f, -1.104178036e-03f, -1.096644273e-03f, -1.089080218e-03f, -1.081486150e-03f, -1.073862346e-03f, -1.066209087e-03f, 
-1.058526654e-03f, -1.050815326e-03f, -1.043075387e-03f, -1.035307118e-03f, -1.027510804e-03f, -1.019686727e-03f, -1.011835174e-03f, -1.003956429e-03f, -9.960507782e-04f, -9.881185086e-04f, 
-9.801599075e-04f, -9.721752629e-04f, -9.641648636e-04f, -9.561289987e-04f, -9.480679583e-04f, -9.399820327e-04f, -9.318715132e-04f, -9.237366914e-04f, -9.155778594e-04f, -9.073953102e-04f, 
-8.991893371e-04f, -8.909602340e-04f, -8.827082953e-04f, -8.744338159e-04f, -8.661370913e-04f, -8.578184175e-04f, -8.494780909e-04f, -8.411164083e-04f, -8.327336673e-04f, -8.243301655e-04f, 
-8.159062014e-04f, -8.074620736e-04f, -7.989980813e-04f, -7.905145241e-04f, -7.820117018e-04f, -7.734899149e-04f, -7.649494641e-04f, -7.563906506e-04f, -7.478137758e-04f, -7.392191415e-04f, 
-7.306070499e-04f, -7.219778036e-04f, -7.133317054e-04f, -7.046690584e-04f, -6.959901661e-04f, -6.872953321e-04f, -6.785848606e-04f, -6.698590557e-04f, -6.611182221e-04f, -6.523626645e-04f, 
-6.435926879e-04f, -6.348085976e-04f, -6.260106992e-04f, -6.171992981e-04f, -6.083747004e-04f, -5.995372121e-04f, -5.906871395e-04f, -5.818247889e-04f, -5.729504668e-04f, -5.640644801e-04f, 
-5.551671355e-04f, -5.462587399e-04f, -5.373396006e-04f, -5.284100245e-04f, -5.194703191e-04f, -5.105207916e-04f, -5.015617495e-04f, -4.925935002e-04f, -4.836163514e-04f, -4.746306104e-04f, 
-4.656365851e-04f, -4.566345828e-04f, -4.476249114e-04f, -4.386078785e-04f, -4.295837916e-04f, -4.205529583e-04f, -4.115156863e-04f, -4.024722830e-04f, -3.934230559e-04f, -3.843683124e-04f, 
-3.753083599e-04f, -3.662435055e-04f, -3.571740566e-04f, -3.481003200e-04f, -3.390226028e-04f, -3.299412117e-04f, -3.208564535e-04f, -3.117686347e-04f, -3.026780616e-04f, -2.935850405e-04f, 
-2.844898774e-04f, -2.753928782e-04f, -2.662943486e-04f, -2.571945939e-04f, -2.480939195e-04f, -2.389926303e-04f, -2.298910311e-04f, -2.207894265e-04f, -2.116881207e-04f, -2.025874178e-04f, 
-1.934876214e-04f, -1.843890351e-04f, -1.752919620e-04f, -1.661967049e-04f, -1.571035663e-04f, -1.480128486e-04f, -1.389248535e-04f, -1.298398826e-04f, -1.207582371e-04f, -1.116802177e-04f, 
-1.026061250e-04f, -9.353625887e-05f, -8.447091909e-05f, -7.541040487e-05f, -6.635501507e-05f, -5.730504809e-05f, -4.826080192e-05f, -3.922257412e-05f, -3.019066175e-05f, -2.116536147e-05f, 
-1.214696941e-05f, -3.135781271e-06f, 5.867907770e-06f, 1.486380302e-05f, 2.385161031e-05f, 3.283103597e-05f, 4.180178687e-05f, 5.076357042e-05f, 5.971609456e-05f, 6.865906780e-05f, 
7.759219923e-05f, 8.651519848e-05f, 9.542777578e-05f, 1.043296420e-04f, 1.132205085e-04f, 1.221000873e-04f, 1.309680912e-04f, 1.398242333e-04f, 1.486682277e-04f, 1.574997888e-04f, 
1.663186320e-04f, 1.751244732e-04f, 1.839170288e-04f, 1.926960162e-04f, 2.014611533e-04f, 2.102121588e-04f, 2.189487520e-04f, 2.276706530e-04f, 2.363775826e-04f, 2.450692624e-04f, 
2.537454147e-04f, 2.624057625e-04f, 2.710500296e-04f, 2.796779405e-04f, 2.882892208e-04f, 2.968835965e-04f, 3.054607945e-04f, 3.140205427e-04f, 3.225625695e-04f, 3.310866044e-04f, 
3.395923776e-04f, 3.480796202e-04f, 3.565480640e-04f, 3.649974419e-04f, 3.734274874e-04f, 3.818379351e-04f, 3.902285204e-04f, 3.985989794e-04f, 4.069490495e-04f, 4.152784686e-04f, 
4.235869758e-04f, 4.318743109e-04f, 4.401402148e-04f, 4.483844293e-04f, 4.566066971e-04f, 4.648067618e-04f, 4.729843681e-04f, 4.811392616e-04f, 4.892711889e-04f, 4.973798974e-04f, 
5.054651359e-04f, 5.135266537e-04f, 5.215642015e-04f, 5.295775309e-04f, 5.375663944e-04f, 5.455305456e-04f, 5.534697393e-04f, 5.613837310e-04f, 5.692722776e-04f, 5.771351368e-04f, 
5.849720676e-04f, 5.927828299e-04f, 6.005671846e-04f, 6.083248940e-04f, 6.160557212e-04f, 6.237594305e-04f, 6.314357874e-04f, 6.390845583e-04f, 6.467055110e-04f, 6.542984141e-04f, 
6.618630377e-04f, 6.693991528e-04f, 6.769065315e-04f, 6.843849473e-04f, 6.918341746e-04f, 6.992539892e-04f, 7.066441679e-04f, 7.140044889e-04f, 7.213347312e-04f, 7.286346754e-04f, 
7.359041030e-04f, 7.431427970e-04f, 7.503505414e-04f, 7.575271214e-04f, 7.646723236e-04f, 7.717859356e-04f, 7.788677466e-04f, 7.859175466e-04f, 7.929351271e-04f, 7.999202809e-04f, 
8.068728020e-04f, 8.137924855e-04f, 8.206791281e-04f, 8.275325275e-04f, 8.343524828e-04f, 8.411387944e-04f, 8.478912640e-04f, 8.546096945e-04f, 8.612938903e-04f, 8.679436570e-04f, 
8.745588014e-04f, 8.811391317e-04f, 8.876844577e-04f, 8.941945902e-04f, 9.006693413e-04f, 9.071085248e-04f, 9.135119555e-04f, 9.198794498e-04f, 9.262108253e-04f, 9.325059010e-04f, 
9.387644973e-04f, 9.449864360e-04f, 9.511715402e-04f, 9.573196344e-04f, 9.634305446e-04f, 9.695040981e-04f, 9.755401235e-04f, 9.815384510e-04f, 9.874989121e-04f, 9.934213398e-04f, 
9.993055684e-04f, 1.005151434e-03f, 1.010958773e-03f, 1.016727424e-03f, 1.022457228e-03f, 1.028148026e-03f, 1.033799661e-03f, 1.039411977e-03f, 1.044984821e-03f, 1.050518039e-03f, 
1.056011480e-03f, 1.061464994e-03f, 1.066878433e-03f, 1.072251651e-03f, 1.077584501e-03f, 1.082876841e-03f, 1.088128526e-03f, 1.093339417e-03f, 1.098509374e-03f, 1.103638260e-03f, 
1.108725936e-03f, 1.113772270e-03f, 1.118777126e-03f, 1.123740373e-03f, 1.128661881e-03f, 1.133541521e-03f, 1.138379165e-03f, 1.143174687e-03f, 1.147927963e-03f, 1.152638869e-03f, 
1.157307286e-03f, 1.161933092e-03f, 1.166516169e-03f, 1.171056401e-03f, 1.175553673e-03f, 1.180007870e-03f, 1.184418880e-03f, 1.188786593e-03f, 1.193110900e-03f, 1.197391694e-03f, 
1.201628867e-03f, 1.205822316e-03f, 1.209971939e-03f, 1.214077632e-03f, 1.218139298e-03f, 1.222156837e-03f, 1.226130153e-03f, 1.230059151e-03f, 1.233943737e-03f, 1.237783820e-03f, 
1.241579308e-03f, 1.245330114e-03f, 1.249036150e-03f, 1.252697330e-03f, 1.256313570e-03f, 1.259884789e-03f, 1.263410903e-03f, 1.266891836e-03f, 1.270327508e-03f, 1.273717843e-03f, 
1.277062768e-03f, 1.280362208e-03f, 1.283616093e-03f, 1.286824352e-03f, 1.289986918e-03f, 1.293103723e-03f, 1.296174703e-03f, 1.299199794e-03f, 1.302178935e-03f, 1.305112064e-03f, 
1.307999124e-03f, 1.310840057e-03f, 1.313634807e-03f, 1.316383321e-03f, 1.319085547e-03f, 1.321741433e-03f, 1.324350931e-03f, 1.326913992e-03f, 1.329430572e-03f, 1.331900625e-03f, 
1.334324110e-03f, 1.336700984e-03f, 1.339031208e-03f, 1.341314745e-03f, 1.343551558e-03f, 1.345741611e-03f, 1.347884873e-03f, 1.349981311e-03f, 1.352030896e-03f, 1.354033598e-03f, 
1.355989392e-03f, 1.357898252e-03f, 1.359760155e-03f, 1.361575078e-03f, 1.363343001e-03f, 1.365063906e-03f, 1.366737774e-03f, 1.368364591e-03f, 1.369944342e-03f, 1.371477015e-03f, 
1.372962600e-03f, 1.374401086e-03f, 1.375792466e-03f, 1.377136734e-03f, 1.378433885e-03f, 1.379683917e-03f, 1.380886828e-03f, 1.382042619e-03f, 1.383151290e-03f, 1.384212846e-03f, 
1.385227292e-03f, 1.386194634e-03f, 1.387114879e-03f, 1.387988039e-03f, 1.388814123e-03f, 1.389593146e-03f, 1.390325120e-03f, 1.391010063e-03f, 1.391647991e-03f, 1.392238924e-03f, 
1.392782883e-03f, 1.393279889e-03f, 1.393729966e-03f, 1.394133139e-03f, 1.394489436e-03f, 1.394798884e-03f, 1.395061515e-03f, 1.395277358e-03f, 1.395446447e-03f, 1.395568817e-03f, 
1.395644504e-03f, 1.395673545e-03f, 1.395655980e-03f, 1.395591848e-03f, 1.395481194e-03f, 1.395324059e-03f, 1.395120489e-03f, 1.394870532e-03f, 1.394574235e-03f, 1.394231648e-03f, 
1.393842823e-03f, 1.393407812e-03f, 1.392926669e-03f, 1.392399451e-03f, 1.391826214e-03f, 1.391207018e-03f, 1.390541922e-03f, 1.389830989e-03f, 1.389074282e-03f, 1.388271865e-03f, 
1.387423805e-03f, 1.386530169e-03f, 1.385591027e-03f, 1.384606449e-03f, 1.383576507e-03f, 1.382501274e-03f, 1.381380826e-03f, 1.380215240e-03f, 1.379004592e-03f, 1.377748963e-03f, 
1.376448433e-03f, 1.375103084e-03f, 1.373713000e-03f, 1.372278266e-03f, 1.370798968e-03f, 1.369275195e-03f, 1.367707035e-03f, 1.366094580e-03f, 1.364437921e-03f, 1.362737153e-03f, 
1.360992369e-03f, 1.359203667e-03f, 1.357371143e-03f, 1.355494898e-03f, 1.353575032e-03f, 1.351611646e-03f, 1.349604843e-03f, 1.347554729e-03f, 1.345461409e-03f, 1.343324991e-03f, 
1.341145583e-03f, 1.338923295e-03f, 1.336658239e-03f, 1.334350526e-03f, 1.332000272e-03f, 1.329607592e-03f, 1.327172602e-03f, 1.324695420e-03f, 1.322176166e-03f, 1.319614960e-03f, 
1.317011924e-03f, 1.314367181e-03f, 1.311680856e-03f, 1.308953074e-03f, 1.306183963e-03f, 1.303373651e-03f, 1.300522267e-03f, 1.297629943e-03f, 1.294696811e-03f, 1.291723003e-03f, 
1.288708655e-03f, 1.285653902e-03f, 1.282558882e-03f, 1.279423733e-03f, 1.276248594e-03f, 1.273033606e-03f, 1.269778912e-03f, 1.266484654e-03f, 1.263150976e-03f, 1.259778026e-03f, 
1.256365948e-03f, 1.252914892e-03f, 1.249425006e-03f, 1.245896441e-03f, 1.242329348e-03f, 1.238723880e-03f, 1.235080191e-03f, 1.231398435e-03f, 1.227678770e-03f, 1.223921351e-03f, 
1.220126337e-03f, 1.216293888e-03f, 1.212424165e-03f, 1.208517329e-03f, 1.204573543e-03f, 1.200592971e-03f, 1.196575778e-03f, 1.192522130e-03f, 1.188432194e-03f, 1.184306139e-03f, 
1.180144133e-03f, 1.175946348e-03f, 1.171712954e-03f, 1.167444124e-03f, 1.163140031e-03f, 1.158800851e-03f, 1.154426758e-03f, 1.150017929e-03f, 1.145574542e-03f, 1.141096776e-03f, 
1.136584809e-03f, 1.132038823e-03f, 1.127459000e-03f, 1.122845520e-03f, 1.118198569e-03f, 1.113518331e-03f, 1.108804990e-03f, 1.104058735e-03f, 1.099279750e-03f, 1.094468226e-03f, 
1.089624351e-03f, 1.084748316e-03f, 1.079840310e-03f, 1.074900527e-03f, 1.069929159e-03f, 1.064926400e-03f, 1.059892444e-03f, 1.054827488e-03f, 1.049731726e-03f, 1.044605356e-03f, 
1.039448577e-03f, 1.034261588e-03f, 1.029044587e-03f, 1.023797777e-03f, 1.018521357e-03f, 1.013215531e-03f, 1.007880501e-03f, 1.002516471e-03f, 9.971236460e-04f, 9.917022313e-04f, 
9.862524330e-04f, 9.807744581e-04f, 9.752685143e-04f, 9.697348102e-04f, 9.641735549e-04f, 9.585849585e-04f, 9.529692316e-04f, 9.473265858e-04f, 9.416572331e-04f, 9.359613865e-04f, 
9.302392595e-04f, 9.244910664e-04f, 9.187170221e-04f, 9.129173424e-04f, 9.070922434e-04f, 9.012419422e-04f, 8.953666564e-04f, 8.894666043e-04f, 8.835420048e-04f, 8.775930774e-04f, 
8.716200424e-04f, 8.656231205e-04f, 8.596025331e-04f, 8.535585022e-04f, 8.474912504e-04f, 8.414010009e-04f, 8.352879775e-04f, 8.291524045e-04f, 8.229945067e-04f, 8.168145096e-04f, 
8.106126392e-04f, 8.043891219e-04f, 7.981441849e-04f, 7.918780558e-04f, 7.855909625e-04f, 7.792831337e-04f, 7.729547984e-04f, 7.666061863e-04f, 7.602375273e-04f, 7.538490521e-04f, 
7.474409914e-04f, 7.410135769e-04f, 7.345670404e-04f, 7.281016142e-04f, 7.216175311e-04f, 7.151150243e-04f, 7.085943272e-04f, 7.020556740e-04f, 6.954992991e-04f, 6.889254372e-04f, 
6.823343234e-04f, 6.757261934e-04f, 6.691012830e-04f, 6.624598285e-04f, 6.558020665e-04f, 6.491282340e-04f, 6.424385682e-04f, 6.357333068e-04f, 6.290126877e-04f, 6.222769490e-04f, 
6.155263294e-04f, 6.087610676e-04f, 6.019814028e-04f, 5.951875743e-04f, 5.883798218e-04f, 5.815583851e-04f, 5.747235045e-04f, 5.678754203e-04f, 5.610143731e-04f, 5.541406038e-04f, 
5.472543534e-04f, 5.403558633e-04f, 5.334453748e-04f, 5.265231297e-04f, 5.195893698e-04f, 5.126443372e-04f, 5.056882739e-04f, 4.987214224e-04f, 4.917440251e-04f, 4.847563247e-04f, 
4.777585640e-04f, 4.707509858e-04f, 4.637338331e-04f, 4.567073492e-04f, 4.496717772e-04f, 4.426273603e-04f, 4.355743421e-04f, 4.285129660e-04f, 4.214434755e-04f, 4.143661143e-04f, 
4.072811259e-04f, 4.001887541e-04f, 3.930892425e-04f, 3.859828351e-04f, 3.788697754e-04f, 3.717503074e-04f, 3.646246747e-04f, 3.574931213e-04f, 3.503558907e-04f, 3.432132268e-04f, 
3.360653732e-04f, 3.289125737e-04f, 3.217550719e-04f, 3.145931113e-04f, 3.074269354e-04f, 3.002567876e-04f, 2.930829114e-04f, 2.859055499e-04f, 2.787249464e-04f, 2.715413438e-04f, 
2.643549852e-04f, 2.571661133e-04f, 2.499749709e-04f, 2.427818006e-04f, 2.355868447e-04f, 2.283903455e-04f, 2.211925451e-04f, 2.139936855e-04f, 2.067940084e-04f, 1.995937554e-04f, 
1.923931678e-04f, 1.851924870e-04f, 1.779919537e-04f, 1.707918089e-04f, 1.635922930e-04f, 1.563936463e-04f, 1.491961089e-04f, 1.419999207e-04f, 1.348053211e-04f, 1.276125495e-04f, 
1.204218449e-04f, 1.132334460e-04f, 1.060475913e-04f, 9.886451899e-05f, 9.168446690e-05f, 8.450767260e-05f, 7.733437331e-05f, 7.016480595e-05f, 6.299920710e-05f, 5.583781298e-05f, 
4.868085950e-05f, 4.152858217e-05f, 3.438121618e-05f, 2.723899631e-05f, 2.010215698e-05f, 1.297093223e-05f, 5.845555699e-06f, -1.273739382e-06f, -8.386720181e-06f, -1.549315429e-05f, 
-2.259280971e-05f, -2.968545489e-05f, -3.677085872e-05f, -4.384879051e-05f, -5.091902005e-05f, -5.798131757e-05f, -6.503545380e-05f, -7.208119990e-05f, -7.911832755e-05f, -8.614660890e-05f, 
-9.316581660e-05f, -1.001757238e-04f, -1.071761042e-04f, -1.141667320e-04f, -1.211473818e-04f, -1.281178290e-04f, -1.350778492e-04f, -1.420272189e-04f, -1.489657149e-04f, -1.558931147e-04f, 
-1.628091963e-04f, -1.697137382e-04f, -1.766065197e-04f, -1.834873205e-04f, -1.903559209e-04f, -1.972121020e-04f, -2.040556452e-04f, -2.108863327e-04f, -2.177039475e-04f, -2.245082728e-04f, 
-2.312990928e-04f, -2.380761922e-04f, -2.448393563e-04f, -2.515883712e-04f, -2.583230236e-04f, -2.650431007e-04f, -2.717483907e-04f, -2.784386821e-04f, -2.851137646e-04f, -2.917734280e-04f, 
-2.984174633e-04f, -3.050456620e-04f, -3.116578161e-04f, -3.182537188e-04f, -3.248331636e-04f, -3.313959450e-04f, -3.379418581e-04f, -3.444706988e-04f, -3.509822638e-04f, -3.574763504e-04f, 
-3.639527567e-04f, -3.704112818e-04f, -3.768517254e-04f, -3.832738879e-04f, -3.896775706e-04f, -3.960625756e-04f, -4.024287058e-04f, -4.087757649e-04f, -4.151035573e-04f, -4.214118884e-04f, 
-4.277005644e-04f, -4.339693921e-04f, -4.402181795e-04f, -4.464467351e-04f, -4.526548684e-04f, -4.588423899e-04f, -4.650091107e-04f, -4.711548428e-04f, -4.772793993e-04f, -4.833825940e-04f, 
-4.894642414e-04f, -4.955241573e-04f, -5.015621582e-04f, -5.075780612e-04f, -5.135716849e-04f, -5.195428482e-04f, -5.254913714e-04f, -5.314170755e-04f, -5.373197823e-04f, -5.431993148e-04f, 
-5.490554967e-04f, -5.548881528e-04f, -5.606971088e-04f, -5.664821913e-04f, -5.722432278e-04f, -5.779800470e-04f, -5.836924784e-04f, -5.893803523e-04f, -5.950435003e-04f, -6.006817547e-04f, 
-6.062949491e-04f, -6.118829178e-04f, -6.174454961e-04f, -6.229825206e-04f, -6.284938284e-04f, -6.339792582e-04f, -6.394386492e-04f, -6.448718419e-04f, -6.502786777e-04f, -6.556589991e-04f, 
-6.610126496e-04f, -6.663394736e-04f, -6.716393169e-04f, -6.769120260e-04f, -6.821574484e-04f, -6.873754330e-04f, -6.925658295e-04f, -6.977284887e-04f, -7.028632625e-04f, -7.079700038e-04f, 
-7.130485666e-04f, -7.180988061e-04f, -7.231205783e-04f, -7.281137405e-04f, -7.330781511e-04f, -7.380136695e-04f, -7.429201562e-04f, -7.477974728e-04f, -7.526454820e-04f, -7.574640477e-04f, 
-7.622530348e-04f, -7.670123092e-04f, -7.717417382e-04f, -7.764411901e-04f, -7.811105341e-04f, -7.857496410e-04f, -7.903583822e-04f, -7.949366306e-04f, -7.994842600e-04f, -8.040011457e-04f, 
-8.084871636e-04f, -8.129421913e-04f, -8.173661071e-04f, -8.217587907e-04f, -8.261201230e-04f, -8.304499858e-04f, -8.347482623e-04f, -8.390148367e-04f, -8.432495945e-04f, -8.474524223e-04f, 
-8.516232079e-04f, -8.557618402e-04f, -8.598682094e-04f, -8.639422068e-04f, -8.679837248e-04f, -8.719926572e-04f, -8.759688988e-04f, -8.799123456e-04f, -8.838228950e-04f, -8.877004454e-04f, 
-8.915448963e-04f, -8.953561487e-04f, -8.991341046e-04f, -9.028786671e-04f, -9.065897409e-04f, -9.102672314e-04f, -9.139110457e-04f, -9.175210917e-04f, -9.210972788e-04f, -9.246395175e-04f, 
-9.281477195e-04f, -9.316217977e-04f, -9.350616664e-04f, -9.384672408e-04f, -9.418384377e-04f, -9.451751749e-04f, -9.484773714e-04f, -9.517449476e-04f, -9.549778250e-04f, -9.581759263e-04f, 
-9.613391756e-04f, -9.644674981e-04f, -9.675608203e-04f, -9.706190699e-04f, -9.736421759e-04f, -9.766300684e-04f, -9.795826790e-04f, -9.824999402e-04f, -9.853817861e-04f, -9.882281518e-04f, 
-9.910389737e-04f, -9.938141896e-04f, -9.965537383e-04f, -9.992575600e-04f, -1.001925596e-03f, -1.004557789e-03f, -1.007154084e-03f, -1.009714424e-03f, -1.012238758e-03f, -1.014727031e-03f, 
-1.017179194e-03f, -1.019595197e-03f, -1.021974991e-03f, -1.024318528e-03f, -1.026625763e-03f, -1.028896651e-03f, -1.031131149e-03f, -1.033329213e-03f, -1.035490804e-03f, -1.037615882e-03f, 
-1.039704408e-03f, -1.041756344e-03f, -1.043771656e-03f, -1.045750307e-03f, -1.047692266e-03f, -1.049597499e-03f, -1.051465976e-03f, -1.053297667e-03f, -1.055092543e-03f, -1.056850579e-03f, 
-1.058571747e-03f, -1.060256023e-03f, -1.061903385e-03f, -1.063513808e-03f, -1.065087274e-03f, -1.066623763e-03f, -1.068123255e-03f, -1.069585734e-03f, -1.071011185e-03f, -1.072399592e-03f, 
-1.073750942e-03f, -1.075065224e-03f, -1.076342427e-03f, -1.077582540e-03f, -1.078785557e-03f, -1.079951469e-03f, -1.081080271e-03f, -1.082171959e-03f, -1.083226529e-03f, -1.084243979e-03f, 
-1.085224309e-03f, -1.086167518e-03f, -1.087073609e-03f, -1.087942585e-03f, -1.088774450e-03f, -1.089569209e-03f, -1.090326868e-03f, -1.091047437e-03f, -1.091730924e-03f, -1.092377339e-03f, 
-1.092986694e-03f, -1.093559002e-03f, -1.094094277e-03f, -1.094592534e-03f, -1.095053790e-03f, -1.095478063e-03f, -1.095865371e-03f, -1.096215736e-03f, -1.096529177e-03f, -1.096805719e-03f, 
-1.097045384e-03f, -1.097248199e-03f, -1.097414188e-03f, -1.097543380e-03f, -1.097635804e-03f, -1.097691490e-03f, -1.097710467e-03f, -1.097692770e-03f, -1.097638431e-03f, -1.097547486e-03f, 
-1.097419970e-03f, -1.097255920e-03f, -1.097055374e-03f, -1.096818373e-03f, -1.096544956e-03f, -1.096235167e-03f, -1.095889047e-03f, -1.095506641e-03f, -1.095087995e-03f, -1.094633154e-03f, 
-1.094142168e-03f, -1.093615085e-03f, -1.093051954e-03f, -1.092452828e-03f, -1.091817758e-03f, -1.091146798e-03f, -1.090440004e-03f, -1.089697430e-03f, -1.088919135e-03f, -1.088105175e-03f, 
-1.087255612e-03f, -1.086370504e-03f, -1.085449913e-03f, -1.084493904e-03f, -1.083502538e-03f, -1.082475882e-03f, -1.081414001e-03f, -1.080316963e-03f, -1.079184836e-03f, -1.078017689e-03f, 
-1.076815594e-03f, -1.075578622e-03f, -1.074306845e-03f, -1.073000338e-03f, -1.071659176e-03f, -1.070283435e-03f, -1.068873191e-03f, -1.067428524e-03f, -1.065949513e-03f, -1.064436238e-03f, 
-1.062888781e-03f, -1.061307224e-03f, -1.059691651e-03f, -1.058042147e-03f, -1.056358798e-03f, -1.054641690e-03f, -1.052890911e-03f, -1.051106551e-03f, -1.049288700e-03f, -1.047437447e-03f, 
-1.045552887e-03f, -1.043635111e-03f, -1.041684214e-03f, -1.039700291e-03f, -1.037683438e-03f, -1.035633753e-03f, -1.033551334e-03f, -1.031436279e-03f, -1.029288690e-03f, -1.027108668e-03f, 
-1.024896314e-03f, -1.022651732e-03f, -1.020375027e-03f, -1.018066303e-03f, -1.015725667e-03f, -1.013353226e-03f, -1.010949087e-03f, -1.008513361e-03f, -1.006046158e-03f, -1.003547587e-03f, 
-1.001017762e-03f, -9.984567948e-04f, -9.958647998e-04f, -9.932418916e-04f, -9.905881860e-04f, -9.879037997e-04f, -9.851888503e-04f, -9.824434563e-04f, -9.796677371e-04f, -9.768618130e-04f, 
-9.740258054e-04f, -9.711598363e-04f, -9.682640288e-04f, -9.653385067e-04f, -9.623833951e-04f, -9.593988194e-04f, -9.563849063e-04f, -9.533417832e-04f, -9.502695785e-04f, -9.471684212e-04f, 
-9.440384414e-04f, -9.408797700e-04f, -9.376925387e-04f, -9.344768799e-04f, -9.312329272e-04f, -9.279608147e-04f, -9.246606775e-04f, -9.213326513e-04f, -9.179768729e-04f, -9.145934798e-04f, 
-9.111826101e-04f, -9.077444031e-04f, -9.042789985e-04f, -9.007865369e-04f, -8.972671599e-04f, -8.937210096e-04f, -8.901482290e-04f, -8.865489619e-04f, -8.829233526e-04f, -8.792715466e-04f, 
-8.755936897e-04f, -8.718899287e-04f, -8.681604111e-04f, -8.644052851e-04f, -8.606246996e-04f, -8.568188042e-04f, -8.529877494e-04f, -8.491316861e-04f, -8.452507663e-04f, -8.413451422e-04f, 
-8.374149671e-04f, -8.334603949e-04f, -8.294815800e-04f, -8.254786777e-04f, -8.214518437e-04f, -8.174012347e-04f, -8.133270078e-04f, -8.092293209e-04f, -8.051083324e-04f, -8.009642014e-04f, 
-7.967970876e-04f, -7.926071516e-04f, -7.883945541e-04f, -7.841594569e-04f, -7.799020221e-04f, -7.756224126e-04f, -7.713207918e-04f, -7.669973237e-04f, -7.626521728e-04f, -7.582855043e-04f, 
-7.538974841e-04f, -7.494882782e-04f, -7.450580537e-04f, -7.406069780e-04f, -7.361352189e-04f, -7.316429451e-04f, -7.271303255e-04f, -7.225975297e-04f, -7.180447278e-04f, -7.134720904e-04f, 
-7.088797887e-04f, -7.042679942e-04f, -6.996368791e-04f, -6.949866160e-04f, -6.903173780e-04f, -6.856293386e-04f, -6.809226719e-04f, -6.761975525e-04f, -6.714541553e-04f, -6.666926557e-04f, 
-6.619132297e-04f, -6.571160535e-04f, -6.523013039e-04f, -6.474691580e-04f, -6.426197936e-04f, -6.377533886e-04f, -6.328701214e-04f, -6.279701709e-04f, -6.230537164e-04f, -6.181209373e-04f, 
-6.131720139e-04f, -6.082071264e-04f, -6.032264555e-04f, -5.982301826e-04f, -5.932184889e-04f, -5.881915563e-04f, -5.831495671e-04f, -5.780927037e-04f, -5.730211490e-04f, -5.679350862e-04f, 
-5.628346988e-04f, -5.577201705e-04f, -5.525916856e-04f, -5.474494284e-04f, -5.422935836e-04f, -5.371243362e-04f, -5.319418716e-04f, -5.267463753e-04f, -5.215380331e-04f, -5.163170310e-04f, 
-5.110835555e-04f, -5.058377931e-04f, -5.005799307e-04f, -4.953101553e-04f, -4.900286543e-04f, -4.847356151e-04f, -4.794312254e-04f, -4.741156734e-04f, -4.687891470e-04f, -4.634518346e-04f, 
-4.581039248e-04f, -4.527456063e-04f, -4.473770679e-04f, -4.419984988e-04f, -4.366100882e-04f, -4.312120255e-04f, -4.258045002e-04f, -4.203877020e-04f, -4.149618207e-04f, -4.095270463e-04f, 
-4.040835688e-04f, -3.986315785e-04f, -3.931712657e-04f, -3.877028207e-04f, -3.822264342e-04f, -3.767422966e-04f, -3.712505987e-04f, -3.657515313e-04f, -3.602452853e-04f, -3.547320514e-04f, 
-3.492120207e-04f, -3.436853843e-04f, -3.381523332e-04f, -3.326130584e-04f, -3.270677513e-04f, -3.215166028e-04f, -3.159598043e-04f, -3.103975469e-04f, -3.048300219e-04f, -2.992574205e-04f, 
-2.936799339e-04f, -2.880977533e-04f, -2.825110699e-04f, -2.769200748e-04f, -2.713249592e-04f, -2.657259143e-04f, -2.601231310e-04f, -2.545168003e-04f, -2.489071132e-04f, -2.432942607e-04f, 
-2.376784334e-04f, -2.320598223e-04f, -2.264386178e-04f, -2.208150106e-04f, -2.151891913e-04f, -2.095613501e-04f, -2.039316773e-04f, -1.983003631e-04f, -1.926675976e-04f, -1.870335707e-04f, 
-1.813984721e-04f, -1.757624915e-04f, -1.701258184e-04f, -1.644886422e-04f, -1.588511521e-04f, -1.532135371e-04f, -1.475759860e-04f, -1.419386876e-04f, -1.363018303e-04f, -1.306656025e-04f, 
-1.250301924e-04f, -1.193957878e-04f, -1.137625765e-04f, -1.081307459e-04f, -1.025004834e-04f, -9.687197610e-05f, -9.124541074e-05f, -8.562097396e-05f, -7.999885212e-05f, -7.437923132e-05f, 
-6.876229742e-05f, -6.314823602e-05f, -5.753723244e-05f, -5.192947174e-05f, -4.632513869e-05f, -4.072441780e-05f, -3.512749325e-05f, -2.953454895e-05f, -2.394576851e-05f, -1.836133521e-05f, 
-1.278143205e-05f, -7.206241676e-06f, -1.635946424e-06f, 3.929271701e-06f, 9.489231037e-06f, 1.504375026e-05f, 2.059264840e-05f, 2.613574484e-05f, 3.167285932e-05f, 3.720381195e-05f, 
4.272842321e-05f, 4.824651397e-05f, 5.375790546e-05f, 5.926241932e-05f, 6.475987757e-05f, 7.025010264e-05f, 7.573291737e-05f, 8.120814499e-05f, 8.667560918e-05f, 9.213513401e-05f, 
9.758654399e-05f, 1.030296641e-04f, 1.084643197e-04f, 1.138903366e-04f, 1.193075411e-04f, 1.247157599e-04f, 1.301148203e-04f, 1.355045498e-04f, 1.408847768e-04f, 1.462553296e-04f, 
1.516160375e-04f, 1.569667300e-04f, 1.623072372e-04f, 1.676373897e-04f, 1.729570185e-04f, 1.782659552e-04f, 1.835640320e-04f, 1.888510814e-04f, 1.941269367e-04f, 1.993914314e-04f, 
2.046443997e-04f, 2.098856765e-04f, 2.151150970e-04f, 2.203324971e-04f, 2.255377131e-04f, 2.307305820e-04f, 2.359109413e-04f, 2.410786291e-04f, 2.462334841e-04f, 2.513753455e-04f, 
2.565040532e-04f, 2.616194475e-04f, 2.667213695e-04f, 2.718096608e-04f, 2.768841636e-04f, 2.819447207e-04f, 2.869911756e-04f, 2.920233722e-04f, 2.970411553e-04f, 3.020443702e-04f, 
3.070328629e-04f, 3.120064798e-04f, 3.169650681e-04f, 3.219084759e-04f, 3.268365515e-04f, 3.317491441e-04f, 3.366461035e-04f, 3.415272802e-04f, 3.463925254e-04f, 3.512416909e-04f, 
3.560746292e-04f, 3.608911934e-04f, 3.656912375e-04f, 3.704746159e-04f, 3.752411840e-04f, 3.799907976e-04f, 3.847233135e-04f, 3.894385889e-04f, 3.941364820e-04f, 3.988168515e-04f, 
4.034795569e-04f, 4.081244585e-04f, 4.127514172e-04f, 4.173602946e-04f, 4.219509531e-04f, 4.265232561e-04f, 4.310770672e-04f, 4.356122512e-04f, 4.401286734e-04f, 4.446262001e-04f, 
4.491046980e-04f, 4.535640349e-04f, 4.580040793e-04f, 4.624247002e-04f, 4.668257677e-04f, 4.712071525e-04f, 4.755687261e-04f, 4.799103609e-04f, 4.842319300e-04f, 4.885333072e-04f, 
4.928143673e-04f, 4.970749857e-04f, 5.013150387e-04f, 5.055344034e-04f, 5.097329578e-04f, 5.139105804e-04f, 5.180671509e-04f, 5.222025495e-04f, 5.263166575e-04f, 5.304093568e-04f, 
5.344805303e-04f, 5.385300616e-04f, 5.425578351e-04f, 5.465637363e-04f, 5.505476512e-04f, 5.545094669e-04f, 5.584490713e-04f, 5.623663529e-04f, 5.662612014e-04f, 5.701335072e-04f, 
5.739831616e-04f, 5.778100566e-04f, 5.816140853e-04f, 5.853951415e-04f, 5.891531200e-04f, 5.928879163e-04f, 5.965994269e-04f, 6.002875492e-04f, 6.039521815e-04f, 6.075932228e-04f, 
6.112105731e-04f, 6.148041333e-04f, 6.183738052e-04f, 6.219194915e-04f, 6.254410957e-04f, 6.289385224e-04f, 6.324116768e-04f, 6.358604653e-04f, 6.392847950e-04f, 6.426845740e-04f, 
6.460597112e-04f, 6.494101167e-04f, 6.527357012e-04f, 6.560363764e-04f, 6.593120551e-04f, 6.625626506e-04f, 6.657880777e-04f, 6.689882516e-04f, 6.721630888e-04f, 6.753125064e-04f, 
6.784364227e-04f, 6.815347569e-04f, 6.846074289e-04f, 6.876543599e-04f, 6.906754717e-04f, 6.936706872e-04f, 6.966399303e-04f, 6.995831257e-04f, 7.025001991e-04f, 7.053910771e-04f, 
7.082556875e-04f, 7.110939586e-04f, 7.139058201e-04f, 7.166912024e-04f, 7.194500369e-04f, 7.221822559e-04f, 7.248877928e-04f, 7.275665819e-04f, 7.302185583e-04f, 7.328436584e-04f, 
7.354418191e-04f, 7.380129788e-04f, 7.405570763e-04f, 7.430740519e-04f, 7.455638465e-04f, 7.480264021e-04f, 7.504616617e-04f, 7.528695691e-04f, 7.552500693e-04f, 7.576031081e-04f, 
7.599286324e-04f, 7.622265899e-04f, 7.644969295e-04f, 7.667396010e-04f, 7.689545549e-04f, 7.711417432e-04f, 7.733011184e-04f, 7.754326342e-04f, 7.775362452e-04f, 7.796119071e-04f, 
7.816595766e-04f, 7.836792110e-04f, 7.856707691e-04f, 7.876342104e-04f, 7.895694954e-04f, 7.914765856e-04f, 7.933554434e-04f, 7.952060325e-04f, 7.970283172e-04f, 7.988222629e-04f, 
8.005878361e-04f, 8.023250042e-04f, 8.040337356e-04f, 8.057139997e-04f, 8.073657668e-04f, 8.089890082e-04f, 8.105836964e-04f, 8.121498045e-04f, 8.136873070e-04f, 8.151961790e-04f, 
8.166763969e-04f, 8.181279379e-04f, 8.195507803e-04f, 8.209449031e-04f, 8.223102868e-04f, 8.236469124e-04f, 8.249547620e-04f, 8.262338190e-04f, 8.274840673e-04f, 8.287054922e-04f, 
8.298980796e-04f, 8.310618167e-04f, 8.321966916e-04f, 8.333026932e-04f, 8.343798116e-04f, 8.354280378e-04f, 8.364473638e-04f, 8.374377825e-04f, 8.383992879e-04f, 8.393318748e-04f, 
8.402355391e-04f, 8.411102777e-04f, 8.419560885e-04f, 8.427729702e-04f, 8.435609226e-04f, 8.443199464e-04f, 8.450500434e-04f, 8.457512163e-04f, 8.464234687e-04f, 8.470668053e-04f, 
8.476812315e-04f, 8.482667541e-04f, 8.488233805e-04f, 8.493511192e-04f, 8.498499796e-04f, 8.503199721e-04f, 8.507611082e-04f, 8.511734001e-04f, 8.515568611e-04f, 8.519115054e-04f, 
8.522373483e-04f, 8.525344059e-04f, 8.528026952e-04f, 8.530422344e-04f, 8.532530424e-04f, 8.534351391e-04f, 8.535885455e-04f, 8.537132834e-04f, 8.538093755e-04f, 8.538768455e-04f, 
8.539157181e-04f, 8.539260189e-04f, 8.539077744e-04f, 8.538610121e-04f, 8.537857603e-04f, 8.536820483e-04f, 8.535499065e-04f, 8.533893660e-04f, 8.532004588e-04f, 8.529832180e-04f, 
8.527376776e-04f, 8.524638723e-04f, 8.521618380e-04f, 8.518316113e-04f, 8.514732299e-04f, 8.510867322e-04f, 8.506721577e-04f, 8.502295466e-04f, 8.497589403e-04f, 8.492603808e-04f, 
8.487339112e-04f, 8.481795754e-04f, 8.475974181e-04f, 8.469874852e-04f, 8.463498232e-04f, 8.456844796e-04f, 8.449915028e-04f, 8.442709419e-04f, 8.435228473e-04f, 8.427472697e-04f, 
8.419442613e-04f, 8.411138746e-04f, 8.402561634e-04f, 8.393711821e-04f, 8.384589860e-04f, 8.375196315e-04f, 8.365531755e-04f, 8.355596761e-04f, 8.345391919e-04f, 8.334917827e-04f, 
8.324175089e-04f, 8.313164319e-04f, 8.301886138e-04f, 8.290341177e-04f, 8.278530073e-04f, 8.266453474e-04f, 8.254112036e-04f, 8.241506420e-04f, 8.228637300e-04f, 8.215505354e-04f, 
8.202111271e-04f, 8.188455748e-04f, 8.174539488e-04f, 8.160363204e-04f, 8.145927616e-04f, 8.131233453e-04f, 8.116281452e-04f, 8.101072356e-04f, 8.085606919e-04f, 8.069885901e-04f, 
8.053910069e-04f, 8.037680200e-04f, 8.021197077e-04f, 8.004461493e-04f, 7.987474246e-04f, 7.970236143e-04f, 7.952747999e-04f, 7.935010637e-04f, 7.917024886e-04f, 7.898791584e-04f, 
7.880311575e-04f, 7.861585712e-04f, 7.842614855e-04f, 7.823399871e-04f, 7.803941635e-04f, 7.784241029e-04f, 7.764298943e-04f, 7.744116272e-04f, 7.723693920e-04f, 7.703032800e-04f, 
7.682133828e-04f, 7.660997930e-04f, 7.639626039e-04f, 7.618019094e-04f, 7.596178041e-04f, 7.574103834e-04f, 7.551797434e-04f, 7.529259806e-04f, 7.506491926e-04f, 7.483494774e-04f, 
7.460269338e-04f, 7.436816612e-04f, 7.413137598e-04f, 7.389233303e-04f, 7.365104741e-04f, 7.340752933e-04f, 7.316178908e-04f, 7.291383697e-04f, 7.266368343e-04f, 7.241133892e-04f, 
7.215681397e-04f, 7.190011918e-04f, 7.164126519e-04f, 7.138026274e-04f, 7.111712260e-04f, 7.085185562e-04f, 7.058447271e-04f, 7.031498482e-04f, 7.004340299e-04f, 6.976973829e-04f, 
6.949400189e-04f, 6.921620497e-04f, 6.893635880e-04f, 6.865447470e-04f, 6.837056406e-04f, 6.808463830e-04f, 6.779670893e-04f, 6.750678748e-04f, 6.721488557e-04f, 6.692101485e-04f, 
6.662518704e-04f, 6.632741391e-04f, 6.602770728e-04f, 6.572607904e-04f, 6.542254112e-04f, 6.511710549e-04f, 6.480978419e-04f, 6.450058932e-04f, 6.418953301e-04f, 6.387662746e-04f, 
6.356188490e-04f, 6.324531763e-04f, 6.292693799e-04f, 6.260675837e-04f, 6.228479120e-04f, 6.196104898e-04f, 6.163554424e-04f, 6.130828956e-04f, 6.097929757e-04f, 6.064858095e-04f, 
6.031615242e-04f, 5.998202474e-04f, 5.964621073e-04f, 5.930872324e-04f, 5.896957517e-04f, 5.862877947e-04f, 5.828634912e-04f, 5.794229715e-04f, 5.759663663e-04f, 5.724938069e-04f, 
5.690054246e-04f, 5.655013515e-04f, 5.619817198e-04f, 5.584466625e-04f, 5.548963125e-04f, 5.513308033e-04f, 5.477502691e-04f, 5.441548438e-04f, 5.405446624e-04f, 5.369198597e-04f, 
5.332805712e-04f, 5.296269325e-04f, 5.259590799e-04f, 5.222771497e-04f, 5.185812787e-04f, 5.148716041e-04f, 5.111482633e-04f, 5.074113941e-04f, 5.036611346e-04f, 4.998976232e-04f, 
4.961209987e-04f, 4.923314001e-04f, 4.885289668e-04f, 4.847138384e-04f, 4.808861549e-04f, 4.770460565e-04f, 4.731936837e-04f, 4.693291773e-04f, 4.654526784e-04f, 4.615643284e-04f, 
4.576642687e-04f, 4.537526413e-04f, 4.498295883e-04f, 4.458952521e-04f, 4.419497752e-04f, 4.379933005e-04f, 4.340259710e-04f, 4.300479302e-04f, 4.260593214e-04f, 4.220602885e-04f, 
4.180509753e-04f, 4.140315261e-04f, 4.100020852e-04f, 4.059627973e-04f, 4.019138069e-04f, 3.978552592e-04f, 3.937872992e-04f, 3.897100722e-04f, 3.856237237e-04f, 3.815283994e-04f, 
3.774242450e-04f, 3.733114066e-04f, 3.691900302e-04f, 3.650602622e-04f, 3.609222488e-04f, 3.567761368e-04f, 3.526220726e-04f, 3.484602032e-04f, 3.442906755e-04f, 3.401136365e-04f, 
3.359292334e-04f, 3.317376134e-04f, 3.275389240e-04f, 3.233333124e-04f, 3.191209264e-04f, 3.149019135e-04f, 3.106764215e-04f, 3.064445982e-04f, 3.022065913e-04f, 2.979625490e-04f, 
2.937126191e-04f, 2.894569497e-04f, 2.851956889e-04f, 2.809289848e-04f, 2.766569858e-04f, 2.723798399e-04f, 2.680976954e-04f, 2.638107006e-04f, 2.595190038e-04f, 2.552227534e-04f, 
2.509220977e-04f, 2.466171849e-04f, 2.423081635e-04f, 2.379951818e-04f, 2.336783880e-04f, 2.293579306e-04f, 2.250339578e-04f, 2.207066178e-04f, 2.163760590e-04f, 2.120424295e-04f, 
2.077058774e-04f, 2.033665509e-04f, 1.990245982e-04f, 1.946801671e-04f, 1.903334057e-04f, 1.859844618e-04f, 1.816334833e-04f, 1.772806180e-04f, 1.729260134e-04f, 1.685698173e-04f, 
1.642121771e-04f, 1.598532403e-04f, 1.554931541e-04f, 1.511320657e-04f, 1.467701224e-04f, 1.424074710e-04f, 1.380442584e-04f, 1.336806314e-04f, 1.293167367e-04f, 1.249527206e-04f, 
1.205887297e-04f, 1.162249100e-04f, 1.118614077e-04f, 1.074983687e-04f, 1.031359387e-04f, 9.877426343e-05f, 9.441348823e-05f, 9.005375838e-05f, 8.569521901e-05f, 8.133801500e-05f, 
7.698229111e-05f, 7.262819187e-05f, 6.827586163e-05f, 6.392544455e-05f, 5.957708457e-05f, 5.523092543e-05f, 5.088711067e-05f, 4.654578359e-05f, 4.220708729e-05f, 3.787116464e-05f, 
3.353815826e-05f, 2.920821056e-05f, 2.488146370e-05f, 2.055805959e-05f, 1.623813991e-05f, 1.192184606e-05f, 7.609319199e-06f, 3.300700226e-06f, -1.003870235e-06f, -5.304251827e-06f, 
-9.600304472e-06f, -1.389188837e-05f, -1.817886400e-05f, -2.246109215e-05f, -2.673843387e-05f, -3.101075054e-05f, -3.527790381e-05f, -3.953975568e-05f, -4.379616841e-05f, -4.804700462e-05f, 
-5.229212722e-05f, -5.653139945e-05f, -6.076468489e-05f, -6.499184745e-05f, -6.921275136e-05f, -7.342726121e-05f, -7.763524192e-05f, -8.183655878e-05f, -8.603107741e-05f, -9.021866381e-05f, 
-9.439918432e-05f, -9.857250566e-05f, -1.027384949e-04f, -1.068970196e-04f, -1.110479474e-04f, -1.151911468e-04f, -1.193264861e-04f, -1.234538346e-04f, -1.275730615e-04f, -1.316840366e-04f, 
-1.357866302e-04f, -1.398807128e-04f, -1.439661555e-04f, -1.480428297e-04f, -1.521106072e-04f, -1.561693603e-04f, -1.602189618e-04f, -1.642592847e-04f, -1.682902026e-04f, -1.723115895e-04f, 
-1.763233198e-04f, -1.803252685e-04f, -1.843173108e-04f, -1.882993226e-04f, -1.922711801e-04f, -1.962327600e-04f, -2.001839395e-04f, -2.041245962e-04f, -2.080546083e-04f, -2.119738543e-04f, 
-2.158822133e-04f, -2.197795648e-04f, -2.236657889e-04f, -2.275407661e-04f, -2.314043774e-04f, -2.352565043e-04f, -2.390970289e-04f, -2.429258337e-04f, -2.467428017e-04f, -2.505478164e-04f, 
-2.543407619e-04f, -2.581215227e-04f, -2.618899841e-04f, -2.656460314e-04f, -2.693895510e-04f, -2.731204295e-04f, -2.768385540e-04f, -2.805438124e-04f, -2.842360930e-04f, -2.879152845e-04f, 
-2.915812763e-04f, -2.952339584e-04f, -2.988732212e-04f, -3.024989558e-04f, -3.061110538e-04f, -3.097094074e-04f, -3.132939093e-04f, -3.168644527e-04f, -3.204209316e-04f, -3.239632404e-04f, 
-3.274912741e-04f, -3.310049283e-04f, -3.345040993e-04f, -3.379886838e-04f, -3.414585791e-04f, -3.449136833e-04f, -3.483538949e-04f, -3.517791130e-04f, -3.551892374e-04f, -3.585841685e-04f, 
-3.619638072e-04f, -3.653280551e-04f, -3.686768144e-04f, -3.720099879e-04f, -3.753274791e-04f, -3.786291919e-04f, -3.819150311e-04f, -3.851849020e-04f, -3.884387104e-04f, -3.916763629e-04f, 
-3.948977667e-04f, -3.981028297e-04f, -4.012914603e-04f, -4.044635675e-04f, -4.076190612e-04f, -4.107578518e-04f, -4.138798502e-04f, -4.169849682e-04f, -4.200731181e-04f, -4.231442129e-04f, 
-4.261981663e-04f, -4.292348926e-04f, -4.322543068e-04f, -4.352563244e-04f, -4.382408619e-04f, -4.412078362e-04f, -4.441571650e-04f, -4.470887665e-04f, -4.500025599e-04f, -4.528984646e-04f, 
-4.557764012e-04f, -4.586362906e-04f, -4.614780546e-04f, -4.643016155e-04f, -4.671068965e-04f, -4.698938213e-04f, -4.726623145e-04f, -4.754123011e-04f, -4.781437070e-04f, -4.808564588e-04f, 
-4.835504838e-04f, -4.862257099e-04f, -4.888820657e-04f, -4.915194806e-04f, -4.941378847e-04f, -4.967372088e-04f, -4.993173843e-04f, -5.018783434e-04f, -5.044200190e-04f, -5.069423447e-04f, 
-5.094452549e-04f, -5.119286847e-04f, -5.143925697e-04f, -5.168368465e-04f, -5.192614522e-04f, -5.216663249e-04f, -5.240514030e-04f, -5.264166262e-04f, -5.287619343e-04f, -5.310872683e-04f, 
-5.333925697e-04f, -5.356777808e-04f, -5.379428446e-04f, -5.401877049e-04f, -5.424123062e-04f, -5.446165937e-04f, -5.468005133e-04f, -5.489640117e-04f, -5.511070364e-04f, -5.532295356e-04f, 
-5.553314581e-04f, -5.574127536e-04f, -5.594733726e-04f, -5.615132660e-04f, -5.635323860e-04f, -5.655306850e-04f, -5.675081164e-04f, -5.694646344e-04f, -5.714001938e-04f, -5.733147503e-04f, 
-5.752082602e-04f, -5.770806806e-04f, -5.789319694e-04f, -5.807620853e-04f, -5.825709876e-04f, -5.843586363e-04f, -5.861249925e-04f, -5.878700177e-04f, -5.895936743e-04f, -5.912959255e-04f, 
-5.929767351e-04f, -5.946360678e-04f, -5.962738891e-04f, -5.978901650e-04f, -5.994848625e-04f, -6.010579493e-04f, -6.026093938e-04f, -6.041391652e-04f, -6.056472335e-04f, -6.071335693e-04f, 
-6.085981443e-04f, -6.100409305e-04f, -6.114619009e-04f, -6.128610294e-04f, -6.142382905e-04f, -6.155936593e-04f, -6.169271120e-04f, -6.182386253e-04f, -6.195281768e-04f, -6.207957448e-04f, 
-6.220413083e-04f, -6.232648472e-04f, -6.244663422e-04f, -6.256457744e-04f, -6.268031261e-04f, -6.279383801e-04f, -6.290515200e-04f, -6.301425303e-04f, -6.312113961e-04f, -6.322581032e-04f, 
-6.332826384e-04f, -6.342849891e-04f, -6.352651435e-04f, -6.362230904e-04f, -6.371588196e-04f, -6.380723216e-04f, -6.389635876e-04f, -6.398326094e-04f, -6.406793800e-04f, -6.415038926e-04f, 
-6.423061416e-04f, -6.430861219e-04f, -6.438438293e-04f, -6.445792603e-04f, -6.452924121e-04f, -6.459832827e-04f, -6.466518709e-04f, -6.472981761e-04f, -6.479221986e-04f, -6.485239394e-04f, 
-6.491034002e-04f, -6.496605836e-04f, -6.501954927e-04f, -6.507081315e-04f, -6.511985048e-04f, -6.516666181e-04f, -6.521124775e-04f, -6.525360900e-04f, -6.529374633e-04f, -6.533166058e-04f, 
-6.536735268e-04f, -6.540082360e-04f, -6.543207442e-04f, -6.546110628e-04f, -6.548792039e-04f, -6.551251803e-04f, -6.553490056e-04f, -6.555506941e-04f, -6.557302609e-04f, -6.558877217e-04f, 
-6.560230931e-04f, -6.561363923e-04f, -6.562276373e-04f, -6.562968466e-04f, -6.563440398e-04f, -6.563692369e-04f, -6.563724588e-04f, -6.563537270e-04f, -6.563130639e-04f, -6.562504923e-04f, 
-6.561660361e-04f, -6.560597196e-04f, -6.559315679e-04f, -6.557816070e-04f, -6.556098632e-04f, -6.554163640e-04f, -6.552011372e-04f, -6.549642116e-04f, -6.547056164e-04f, -6.544253817e-04f, 
-6.541235383e-04f, -6.538001176e-04f, -6.534551518e-04f, -6.530886738e-04f, -6.527007170e-04f, -6.522913156e-04f, -6.518605047e-04f, -6.514083197e-04f, -6.509347969e-04f, -6.504399734e-04f, 
-6.499238867e-04f, -6.493865752e-04f, -6.488280778e-04f, -6.482484342e-04f, -6.476476848e-04f, -6.470258705e-04f, -6.463830330e-04f, -6.457192148e-04f, -6.450344586e-04f, -6.443288083e-04f, 
-6.436023082e-04f, -6.428550032e-04f, -6.420869389e-04f, -6.412981617e-04f, -6.404887185e-04f, -6.396586569e-04f, -6.388080251e-04f, -6.379368719e-04f, -6.370452470e-04f, -6.361332005e-04f, 
-6.352007831e-04f, -6.342480463e-04f, -6.332750422e-04f, -6.322818234e-04f, -6.312684433e-04f, -6.302349557e-04f, -6.291814154e-04f, -6.281078774e-04f, -6.270143976e-04f, -6.259010324e-04f, 
-6.247678388e-04f, -6.236148744e-04f, -6.224421976e-04f, -6.212498672e-04f, -6.200379425e-04f, -6.188064838e-04f, -6.175555516e-04f, -6.162852072e-04f, -6.149955124e-04f, -6.136865297e-04f, 
-6.123583221e-04f, -6.110109532e-04f, -6.096444872e-04f, -6.082589887e-04f, -6.068545233e-04f, -6.054311567e-04f, -6.039889555e-04f, -6.025279868e-04f, -6.010483180e-04f, -5.995500175e-04f, 
-5.980331538e-04f, -5.964977964e-04f, -5.949440151e-04f, -5.933718802e-04f, -5.917814628e-04f, -5.901728342e-04f, -5.885460665e-04f, -5.869012323e-04f, -5.852384047e-04f, -5.835576573e-04f, 
-5.818590642e-04f, -5.801427003e-04f, -5.784086406e-04f, -5.766569608e-04f, -5.748877374e-04f, -5.731010470e-04f, -5.712969668e-04f, -5.694755748e-04f, -5.676369490e-04f, -5.657811685e-04f, 
-5.639083124e-04f, -5.620184605e-04f, -5.601116931e-04f, -5.581880910e-04f, -5.562477354e-04f, -5.542907081e-04f, -5.523170912e-04f, -5.503269675e-04f, -5.483204201e-04f, -5.462975326e-04f, 
-5.442583892e-04f, -5.422030744e-04f, -5.401316732e-04f, -5.380442711e-04f, -5.359409541e-04f, -5.338218084e-04f, -5.316869211e-04f, -5.295363792e-04f, -5.273702705e-04f, -5.251886832e-04f, 
-5.229917059e-04f, -5.207794275e-04f, -5.185519375e-04f, -5.163093257e-04f, -5.140516824e-04f, -5.117790984e-04f, -5.094916647e-04f, -5.071894727e-04f, -5.048726146e-04f, -5.025411824e-04f, 
-5.001952691e-04f, -4.978349676e-04f, -4.954603715e-04f, -4.930715747e-04f, -4.906686715e-04f, -4.882517565e-04f, -4.858209247e-04f, -4.833762715e-04f, -4.809178928e-04f, -4.784458846e-04f, 
-4.759603435e-04f, -4.734613663e-04f, -4.709490503e-04f, -4.684234929e-04f, -4.658847922e-04f, -4.633330464e-04f, -4.607683541e-04f, -4.581908143e-04f, -4.556005261e-04f, -4.529975893e-04f, 
-4.503821037e-04f, -4.477541695e-04f, -4.451138875e-04f, -4.424613584e-04f, -4.397966834e-04f, -4.371199641e-04f, -4.344313023e-04f, -4.317308000e-04f, -4.290185597e-04f, -4.262946840e-04f, 
-4.235592760e-04f, -4.208124389e-04f, -4.180542763e-04f, -4.152848920e-04f, -4.125043901e-04f, -4.097128749e-04f, -4.069104512e-04f, -4.040972238e-04f, -4.012732979e-04f, -3.984387788e-04f, 
-3.955937724e-04f, -3.927383844e-04f, -3.898727210e-04f, -3.869968886e-04f, -3.841109939e-04f, -3.812151438e-04f, -3.783094452e-04f, -3.753940056e-04f, -3.724689324e-04f, -3.695343334e-04f, 
-3.665903166e-04f, -3.636369902e-04f, -3.606744625e-04f, -3.577028421e-04f, -3.547222378e-04f, -3.517327586e-04f, -3.487345136e-04f, -3.457276121e-04f, -3.427121638e-04f, -3.396882782e-04f, 
-3.366560653e-04f, -3.336156352e-04f, -3.305670980e-04f, -3.275105641e-04f, -3.244461441e-04f, -3.213739486e-04f, -3.182940885e-04f, -3.152066748e-04f, -3.121118186e-04f, -3.090096312e-04f, 
-3.059002240e-04f, -3.027837085e-04f, -2.996601964e-04f, -2.965297995e-04f, -2.933926297e-04f, -2.902487990e-04f, -2.870984195e-04f, -2.839416035e-04f, -2.807784634e-04f, -2.776091115e-04f, 
-2.744336605e-04f, -2.712522229e-04f, -2.680649115e-04f, -2.648718391e-04f, -2.616731186e-04f, -2.584688629e-04f, -2.552591852e-04f, -2.520441984e-04f, -2.488240158e-04f, -2.455987506e-04f, 
-2.423685161e-04f, -2.391334257e-04f, -2.358935927e-04f, -2.326491305e-04f, -2.294001527e-04f, -2.261467729e-04f, -2.228891044e-04f, -2.196272610e-04f, -2.163613562e-04f, -2.130915037e-04f, 
-2.098178171e-04f, -2.065404100e-04f, -2.032593963e-04f, -1.999748895e-04f, -1.966870033e-04f, -1.933958515e-04f, -1.901015477e-04f, -1.868042056e-04f, -1.835039388e-04f, -1.802008611e-04f, 
-1.768950859e-04f, -1.735867271e-04f, -1.702758980e-04f, -1.669627123e-04f, -1.636472834e-04f, -1.603297249e-04f, -1.570101502e-04f, -1.536886727e-04f, -1.503654056e-04f, -1.470404624e-04f, 
-1.437139561e-04f, -1.403860000e-04f, -1.370567071e-04f, -1.337261906e-04f, -1.303945633e-04f, -1.270619381e-04f, -1.237284278e-04f, -1.203941452e-04f, -1.170592029e-04f, -1.137237133e-04f, 
-1.103877890e-04f, -1.070515423e-04f, -1.037150854e-04f, -1.003785305e-04f, -9.704198959e-05f, -9.370557457e-05f, -9.036939726e-05f, -8.703356933e-05f, -8.369820232e-05f, -8.036340766e-05f, 
-7.702929664e-05f, -7.369598042e-05f, -7.036357002e-05f, -6.703217630e-05f, -6.370191001e-05f, -6.037288171e-05f, -5.704520184e-05f, -5.371898067e-05f, -5.039432830e-05f, -4.707135469e-05f, 
-4.375016960e-05f, -4.043088266e-05f, -3.711360328e-05f, -3.379844073e-05f, -3.048550409e-05f, -2.717490223e-05f, -2.386674386e-05f, -2.056113750e-05f, -1.725819144e-05f, -1.395801382e-05f, 
-1.066071253e-05f, -7.366395297e-06f, -4.075169605e-06f, -7.871427439e-07f, 2.497578217e-06f, 5.778886429e-06f, 9.056675263e-06f, 1.233083832e-05f, 1.560126942e-05f, 1.886786264e-05f, 
2.213051226e-05f, 2.538911283e-05f, 2.864355912e-05f, 3.189374617e-05f, 3.513956923e-05f, 3.838092384e-05f, 4.161770579e-05f, 4.484981112e-05f, 4.807713613e-05f, 5.129957739e-05f, 
5.451703173e-05f, 5.772939629e-05f, 6.093656843e-05f, 6.413844582e-05f, 6.733492642e-05f, 7.052590845e-05f, 7.371129043e-05f, 7.689097117e-05f, 8.006484978e-05f, 8.323282565e-05f, 
8.639479850e-05f, 8.955066832e-05f, 9.270033544e-05f, 9.584370046e-05f, 9.898066433e-05f, 1.021111283e-04f, 1.052349939e-04f, 1.083521631e-04f, 1.114625380e-04f, 1.145660213e-04f, 
1.176625158e-04f, 1.207519246e-04f, 1.238341514e-04f, 1.269091000e-04f, 1.299766746e-04f, 1.330367798e-04f, 1.360893206e-04f, 1.391342022e-04f, 1.421713301e-04f, 1.452006105e-04f, 
1.482219497e-04f, 1.512352542e-04f, 1.542404313e-04f, 1.572373883e-04f, 1.602260330e-04f, 1.632062737e-04f, 1.661780188e-04f, 1.691411773e-04f, 1.720956585e-04f, 1.750413722e-04f, 
1.779782283e-04f, 1.809061374e-04f, 1.838250103e-04f, 1.867347583e-04f, 1.896352930e-04f, 1.925265265e-04f, 1.954083713e-04f, 1.982807402e-04f, 2.011435464e-04f, 2.039967038e-04f, 
2.068401262e-04f, 2.096737284e-04f, 2.124974251e-04f, 2.153111317e-04f, 2.181147641e-04f, 2.209082383e-04f, 2.236914710e-04f, 2.264643792e-04f, 2.292268805e-04f, 2.319788927e-04f, 
2.347203342e-04f, 2.374511237e-04f, 2.401711806e-04f, 2.428804244e-04f, 2.455787753e-04f, 2.482661538e-04f, 2.509424810e-04f, 2.536076783e-04f, 2.562616677e-04f, 2.589043715e-04f, 
2.615357125e-04f, 2.641556141e-04f, 2.667640000e-04f, 2.693607944e-04f, 2.719459221e-04f, 2.745193082e-04f, 2.770808783e-04f, 2.796305585e-04f, 2.821682754e-04f, 2.846939561e-04f, 
2.872075282e-04f, 2.897089195e-04f, 2.921980586e-04f, 2.946748746e-04f, 2.971392969e-04f, 2.995912554e-04f, 3.020306806e-04f, 3.044575034e-04f, 3.068716553e-04f, 3.092730683e-04f, 
3.116616747e-04f, 3.140374075e-04f, 3.164002002e-04f, 3.187499866e-04f, 3.210867012e-04f, 3.234102790e-04f, 3.257206554e-04f, 3.280177664e-04f, 3.303015484e-04f, 3.325719386e-04f, 
3.348288743e-04f, 3.370722936e-04f, 3.393021350e-04f, 3.415183377e-04f, 3.437208411e-04f, 3.459095854e-04f, 3.480845113e-04f, 3.502455599e-04f, 3.523926728e-04f, 3.545257923e-04f, 
3.566448611e-04f, 3.587498225e-04f, 3.608406204e-04f, 3.629171989e-04f, 3.649795031e-04f, 3.670274783e-04f, 3.690610705e-04f, 3.710802262e-04f, 3.730848923e-04f, 3.750750165e-04f, 
3.770505469e-04f, 3.790114321e-04f, 3.809576214e-04f, 3.828890645e-04f, 3.848057117e-04f, 3.867075137e-04f, 3.885944222e-04f, 3.904663889e-04f, 3.923233664e-04f, 3.941653077e-04f, 
3.959921664e-04f, 3.978038968e-04f, 3.996004534e-04f, 4.013817917e-04f, 4.031478673e-04f, 4.048986368e-04f, 4.066340570e-04f, 4.083540855e-04f, 4.100586803e-04f, 4.117478001e-04f, 
4.134214041e-04f, 4.150794520e-04f, 4.167219042e-04f, 4.183487215e-04f, 4.199598655e-04f, 4.215552980e-04f, 4.231349818e-04f, 4.246988800e-04f, 4.262469563e-04f, 4.277791751e-04f, 
4.292955011e-04f, 4.307958998e-04f, 4.322803373e-04f, 4.337487801e-04f, 4.352011953e-04f, 4.366375508e-04f, 4.380578148e-04f, 4.394619562e-04f, 4.408499444e-04f, 4.422217495e-04f, 
4.435773420e-04f, 4.449166932e-04f, 4.462397748e-04f, 4.475465591e-04f, 4.488370190e-04f, 4.501111281e-04f, 4.513688603e-04f, 4.526101904e-04f, 4.538350935e-04f, 4.550435454e-04f, 
4.562355225e-04f, 4.574110018e-04f, 4.585699608e-04f, 4.597123776e-04f, 4.608382309e-04f, 4.619474999e-04f, 4.630401645e-04f, 4.641162052e-04f, 4.651756030e-04f, 4.662183393e-04f, 
4.672443965e-04f, 4.682537572e-04f, 4.692464048e-04f, 4.702223231e-04f, 4.711814967e-04f, 4.721239107e-04f, 4.730495506e-04f, 4.739584027e-04f, 4.748504539e-04f, 4.757256914e-04f, 
4.765841032e-04f, 4.774256779e-04f, 4.782504047e-04f, 4.790582731e-04f, 4.798492735e-04f, 4.806233968e-04f, 4.813806342e-04f, 4.821209780e-04f, 4.828444206e-04f, 4.835509551e-04f, 
4.842405755e-04f, 4.849132758e-04f, 4.855690512e-04f, 4.862078969e-04f, 4.868298090e-04f, 4.874347842e-04f, 4.880228196e-04f, 4.885939130e-04f, 4.891480628e-04f, 4.896852677e-04f, 
4.902055273e-04f, 4.907088417e-04f, 4.911952114e-04f, 4.916646376e-04f, 4.921171222e-04f, 4.925526673e-04f, 4.929712759e-04f, 4.933729515e-04f, 4.937576980e-04f, 4.941255201e-04f, 
4.944764229e-04f, 4.948104122e-04f, 4.951274942e-04f, 4.954276757e-04f, 4.957109641e-04f, 4.959773675e-04f, 4.962268944e-04f, 4.964595538e-04f, 4.966753553e-04f, 4.968743093e-04f, 
4.970564263e-04f, 4.972217179e-04f, 4.973701957e-04f, 4.975018723e-04f, 4.976167606e-04f, 4.977148741e-04f, 4.977962270e-04f, 4.978608338e-04f, 4.979087097e-04f, 4.979398705e-04f, 
4.979543323e-04f, 4.979521121e-04f, 4.979332272e-04f, 4.978976954e-04f, 4.978455353e-04f, 4.977767658e-04f, 4.976914064e-04f, 4.975894771e-04f, 4.974709987e-04f, 4.973359922e-04f, 
4.971844793e-04f, 4.970164822e-04f, 4.968320236e-04f, 4.966311268e-04f, 4.964138156e-04f, 4.961801142e-04f, 4.959300477e-04f, 4.956636412e-04f, 4.953809208e-04f, 4.950819128e-04f, 
4.947666442e-04f, 4.944351424e-04f, 4.940874355e-04f, 4.937235518e-04f, 4.933435205e-04f, 4.929473710e-04f, 4.925351334e-04f, 4.921068382e-04f, 4.916625165e-04f, 4.912021998e-04f, 
4.907259202e-04f, 4.902337103e-04f, 4.897256032e-04f, 4.892016323e-04f, 4.886618319e-04f, 4.881062364e-04f, 4.875348809e-04f, 4.869478011e-04f, 4.863450328e-04f, 4.857266128e-04f, 
4.850925780e-04f, 4.844429660e-04f, 4.837778146e-04f, 4.830971626e-04f, 4.824010487e-04f, 4.816895125e-04f, 4.809625939e-04f, 4.802203333e-04f, 4.794627715e-04f, 4.786899500e-04f, 
4.779019106e-04f, 4.770986955e-04f, 4.762803475e-04f, 4.754469098e-04f, 4.745984262e-04f, 4.737349407e-04f, 4.728564980e-04f, 4.719631432e-04f, 4.710549217e-04f, 4.701318795e-04f, 
4.691940631e-04f, 4.682415194e-04f, 4.672742956e-04f, 4.662924395e-04f, 4.652959994e-04f, 4.642850239e-04f, 4.632595620e-04f, 4.622196633e-04f, 4.611653778e-04f, 4.600967558e-04f, 
4.590138482e-04f, 4.579167062e-04f, 4.568053816e-04f, 4.556799263e-04f, 4.545403929e-04f, 4.533868345e-04f, 4.522193042e-04f, 4.510378559e-04f, 4.498425438e-04f, 4.486334225e-04f, 
4.474105470e-04f, 4.461739726e-04f, 4.449237553e-04f, 4.436599512e-04f, 4.423826169e-04f, 4.410918094e-04f, 4.397875862e-04f, 4.384700050e-04f, 4.371391241e-04f, 4.357950019e-04f, 
4.344376975e-04f, 4.330672703e-04f, 4.316837798e-04f, 4.302872862e-04f, 4.288778500e-04f, 4.274555321e-04f, 4.260203936e-04f, 4.245724961e-04f, 4.231119016e-04f, 4.216386724e-04f, 
4.201528712e-04f, 4.186545609e-04f, 4.171438050e-04f, 4.156206673e-04f, 4.140852117e-04f, 4.125375028e-04f, 4.109776053e-04f, 4.094055843e-04f, 4.078215054e-04f, 4.062254343e-04f, 
4.046174371e-04f, 4.029975803e-04f, 4.013659308e-04f, 3.997225556e-04f, 3.980675221e-04f, 3.964008983e-04f, 3.947227521e-04f, 3.930331520e-04f, 3.913321667e-04f, 3.896198653e-04f, 
3.878963170e-04f, 3.861615915e-04f, 3.844157588e-04f, 3.826588892e-04f, 3.808910531e-04f, 3.791123215e-04f, 3.773227655e-04f, 3.755224565e-04f, 3.737114662e-04f, 3.718898666e-04f, 
3.700577301e-04f, 3.682151291e-04f, 3.663621366e-04f, 3.644988257e-04f, 3.626252696e-04f, 3.607415421e-04f, 3.588477172e-04f, 3.569438689e-04f, 3.550300717e-04f, 3.531064004e-04f, 
3.511729299e-04f, 3.492297353e-04f, 3.472768922e-04f, 3.453144762e-04f, 3.433425632e-04f, 3.413612296e-04f, 3.393705516e-04f, 3.373706059e-04f, 3.353614695e-04f, 3.333432194e-04f, 
3.313159330e-04f, 3.292796878e-04f, 3.272345616e-04f, 3.251806325e-04f, 3.231179786e-04f, 3.210466784e-04f, 3.189668105e-04f, 3.168784538e-04f, 3.147816872e-04f, 3.126765901e-04f, 
3.105632419e-04f, 3.084417222e-04f, 3.063121109e-04f, 3.041744880e-04f, 3.020289337e-04f, 2.998755283e-04f, 2.977143525e-04f, 2.955454869e-04f, 2.933690126e-04f, 2.911850106e-04f, 
2.889935621e-04f, 2.867947486e-04f, 2.845886517e-04f, 2.823753531e-04f, 2.801549347e-04f, 2.779274786e-04f, 2.756930670e-04f, 2.734517822e-04f, 2.712037067e-04f, 2.689489233e-04f, 
2.666875146e-04f, 2.644195635e-04f, 2.621451532e-04f, 2.598643668e-04f, 2.575772877e-04f, 2.552839992e-04f, 2.529845849e-04f, 2.506791284e-04f, 2.483677137e-04f, 2.460504245e-04f, 
2.437273449e-04f, 2.413985589e-04f, 2.390641509e-04f, 2.367242051e-04f, 2.343788060e-04f, 2.320280381e-04f, 2.296719859e-04f, 2.273107342e-04f, 2.249443677e-04f, 2.225729713e-04f, 
2.201966300e-04f, 2.178154288e-04f, 2.154294527e-04f, 2.130387869e-04f, 2.106435168e-04f, 2.082437275e-04f, 2.058395044e-04f, 2.034309329e-04f, 2.010180986e-04f, 1.986010870e-04f, 
1.961799836e-04f, 1.937548740e-04f, 1.913258440e-04f, 1.888929792e-04f, 1.864563655e-04f, 1.840160885e-04f, 1.815722342e-04f, 1.791248883e-04f, 1.766741368e-04f, 1.742200655e-04f, 
1.717627605e-04f, 1.693023075e-04f, 1.668387927e-04f, 1.643723018e-04f, 1.619029211e-04f, 1.594307363e-04f, 1.569558336e-04f, 1.544782988e-04f, 1.519982181e-04f, 1.495156773e-04f, 
1.470307625e-04f, 1.445435596e-04f, 1.420541546e-04f, 1.395626334e-04f, 1.370690819e-04f, 1.345735860e-04f, 1.320762316e-04f, 1.295771046e-04f, 1.270762906e-04f, 1.245738756e-04f, 
1.220699452e-04f, 1.195645852e-04f, 1.170578812e-04f, 1.145499187e-04f, 1.120407835e-04f, 1.095305609e-04f, 1.070193365e-04f, 1.045071956e-04f, 1.019942237e-04f, 9.948050584e-05f, 
9.696612741e-05f, 9.445117350e-05f, 9.193572920e-05f, 8.941987950e-05f, 8.690370934e-05f, 8.438730356e-05f, 8.187074692e-05f, 7.935412411e-05f, 7.683751971e-05f, 7.432101824e-05f, 
7.180470410e-05f, 6.928866160e-05f, 6.677297496e-05f, 6.425772830e-05f, 6.174300563e-05f, 5.922889084e-05f, 5.671546774e-05f, 5.420282000e-05f, 5.169103120e-05f, 4.918018478e-05f, 
4.667036407e-05f, 4.416165229e-05f, 4.165413251e-05f, 3.914788768e-05f, 3.664300064e-05f, 3.413955405e-05f, 3.163763049e-05f, 2.913731236e-05f, 2.663868193e-05f, 2.414182134e-05f, 
2.164681256e-05f, 1.915373743e-05f, 1.666267762e-05f, 1.417371466e-05f, 1.168692992e-05f, 9.202404611e-06f, 6.720219773e-06f, 4.240456289e-06f, 1.763194873e-06f, -7.114839319e-07f, 
-3.183499753e-06f, -5.652772396e-06f, -8.119221841e-06f, -1.058276825e-05f, -1.304333197e-05f, -1.550083352e-05f, -1.795519363e-05f, -2.040633321e-05f, -2.285417334e-05f, -2.529863533e-05f, 
-2.773964067e-05f, -3.017711105e-05f, -3.261096836e-05f, -3.504113471e-05f, -3.746753239e-05f, -3.989008393e-05f, -4.230871206e-05f, -4.472333971e-05f, -4.713389005e-05f, -4.954028645e-05f, 
-5.194245251e-05f, -5.434031206e-05f, -5.673378915e-05f, -5.912280804e-05f, -6.150729327e-05f, -6.388716955e-05f, -6.626236188e-05f, -6.863279546e-05f, -7.099839576e-05f, -7.335908846e-05f, 
-7.571479952e-05f, -7.806545512e-05f, -8.041098169e-05f, -8.275130592e-05f, -8.508635477e-05f, -8.741605542e-05f, -8.974033532e-05f, -9.205912221e-05f, -9.437234404e-05f, -9.667992907e-05f, 
-9.898180580e-05f, -1.012779030e-04f, -1.035681497e-04f, -1.058524753e-04f, -1.081308093e-04f, -1.104030817e-04f, -1.126692225e-04f, -1.149291621e-04f, -1.171828314e-04f, -1.194301613e-04f, 
-1.216710831e-04f, -1.239055284e-04f, -1.261334290e-04f, -1.283547172e-04f, -1.305693252e-04f, -1.327771860e-04f, -1.349782326e-04f, -1.371723983e-04f, -1.393596167e-04f, -1.415398219e-04f, 
-1.437129481e-04f, -1.458789299e-04f, -1.480377022e-04f, -1.501892001e-04f, -1.523333592e-04f, -1.544701153e-04f, -1.565994046e-04f, -1.587211635e-04f, -1.608353289e-04f, -1.629418378e-04f, 
-1.650406276e-04f, -1.671316363e-04f, -1.692148017e-04f, -1.712900624e-04f, -1.733573572e-04f, -1.754166250e-04f, -1.774678054e-04f, -1.795108381e-04f, -1.815456632e-04f, -1.835722211e-04f, 
-1.855904527e-04f, -1.876002991e-04f, -1.896017016e-04f, -1.915946023e-04f, -1.935789432e-04f, -1.955546668e-04f, -1.975217161e-04f, -1.994800343e-04f, -2.014295648e-04f, -2.033702518e-04f, 
-2.053020395e-04f, -2.072248724e-04f, -2.091386957e-04f, -2.110434548e-04f, -2.129390953e-04f, -2.148255634e-04f, -2.167028056e-04f, -2.185707687e-04f, -2.204293999e-04f, -2.222786468e-04f, 
-2.241184574e-04f, -2.259487799e-04f, -2.277695632e-04f, -2.295807562e-04f, -2.313823085e-04f, -2.331741698e-04f, -2.349562905e-04f, -2.367286211e-04f, -2.384911125e-04f, -2.402437162e-04f, 
-2.419863840e-04f, -2.437190678e-04f, -2.454417204e-04f, -2.471542946e-04f, -2.488567436e-04f, -2.505490213e-04f, -2.522310817e-04f, -2.539028792e-04f, -2.555643688e-04f, -2.572155058e-04f, 
-2.588562458e-04f, -2.604865448e-04f, -2.621063594e-04f, -2.637156464e-04f, -2.653143631e-04f, -2.669024672e-04f, -2.684799168e-04f, -2.700466702e-04f, -2.716026865e-04f, -2.731479248e-04f, 
-2.746823450e-04f, -2.762059070e-04f, -2.777185715e-04f, -2.792202993e-04f, -2.807110519e-04f, -2.821907908e-04f, -2.836594783e-04f, -2.851170770e-04f, -2.865635498e-04f, -2.879988602e-04f, 
-2.894229720e-04f, -2.908358493e-04f, -2.922374569e-04f, -2.936277598e-04f, -2.950067235e-04f, -2.963743139e-04f, -2.977304974e-04f, -2.990752407e-04f, -3.004085108e-04f, -3.017302756e-04f, 
-3.030405029e-04f, -3.043391612e-04f, -3.056262193e-04f, -3.069016466e-04f, -3.081654127e-04f, -3.094174878e-04f, -3.106578424e-04f, -3.118864476e-04f, -3.131032747e-04f, -3.143082956e-04f, 
-3.155014826e-04f, -3.166828084e-04f, -3.178522460e-04f, -3.190097691e-04f, -3.201553516e-04f, -3.212889680e-04f, -3.224105931e-04f, -3.235202022e-04f, -3.246177710e-04f, -3.257032757e-04f, 
-3.267766927e-04f, -3.278379993e-04f, -3.288871727e-04f, -3.299241909e-04f, -3.309490322e-04f, -3.319616752e-04f, -3.329620993e-04f, -3.339502840e-04f, -3.349262094e-04f, -3.358898559e-04f, 
-3.368412044e-04f, -3.377802364e-04f, -3.387069336e-04f, -3.396212782e-04f, -3.405232528e-04f, -3.414128407e-04f, -3.422900253e-04f, -3.431547905e-04f, -3.440071208e-04f, -3.448470010e-04f, 
-3.456744164e-04f, -3.464893527e-04f, -3.472917960e-04f, -3.480817330e-04f, -3.488591506e-04f, -3.496240363e-04f, -3.503763780e-04f, -3.511161640e-04f, -3.518433831e-04f, -3.525580245e-04f, 
-3.532600778e-04f, -3.539495330e-04f, -3.546263807e-04f, -3.552906119e-04f, -3.559422179e-04f, -3.565811904e-04f, -3.572075218e-04f, -3.578212048e-04f, -3.584222323e-04f, -3.590105981e-04f, 
-3.595862961e-04f, -3.601493206e-04f, -3.606996666e-04f, -3.612373293e-04f, -3.617623044e-04f, -3.622745881e-04f, -3.627741769e-04f, -3.632610679e-04f, -3.637352585e-04f, -3.641967466e-04f, 
-3.646455305e-04f, -3.650816089e-04f, -3.655049809e-04f, -3.659156462e-04f, -3.663136048e-04f, -3.666988571e-04f, -3.670714041e-04f, -3.674312469e-04f, -3.677783874e-04f, -3.681128277e-04f, 
-3.684345704e-04f, -3.687436184e-04f, -3.690399753e-04f, -3.693236448e-04f, -3.695946314e-04f, -3.698529395e-04f, -3.700985745e-04f, -3.703315418e-04f, -3.705518474e-04f, -3.707594977e-04f, 
-3.709544994e-04f, -3.711368600e-04f, -3.713065868e-04f, -3.714636881e-04f, -3.716081724e-04f, -3.717400484e-04f, -3.718593255e-04f, -3.719660135e-04f, -3.720601225e-04f, -3.721416630e-04f, 
-3.722106460e-04f, -3.722670829e-04f, -3.723109855e-04f, -3.723423659e-04f, -3.723612368e-04f, -3.723676112e-04f, -3.723615025e-04f, -3.723429245e-04f, -3.723118915e-04f, -3.722684181e-04f, 
-3.722125193e-04f, -3.721442106e-04f, -3.720635078e-04f, -3.719704272e-04f, -3.718649854e-04f, -3.717471995e-04f, -3.716170868e-04f, -3.714746653e-04f, -3.713199532e-04f, -3.711529691e-04f, 
-3.709737320e-04f, -3.707822613e-04f, -3.705785768e-04f, -3.703626988e-04f, -3.701346478e-04f, -3.698944448e-04f, -3.696421112e-04f, -3.693776686e-04f, -3.691011392e-04f, -3.688125456e-04f, 
-3.685119106e-04f, -3.681992575e-04f, -3.678746099e-04f, -3.675379920e-04f, -3.671894280e-04f, -3.668289429e-04f, -3.664565616e-04f, -3.660723099e-04f, -3.656762136e-04f, -3.652682989e-04f, 
-3.648485926e-04f, -3.644171216e-04f, -3.639739133e-04f, -3.635189955e-04f, -3.630523963e-04f, -3.625741441e-04f, -3.620842679e-04f, -3.615827967e-04f, -3.610697603e-04f, -3.605451884e-04f, 
-3.600091114e-04f, -3.594615599e-04f, -3.589025648e-04f, -3.583321575e-04f, -3.577503698e-04f, -3.571572335e-04f, -3.565527811e-04f, -3.559370454e-04f, -3.553100594e-04f, -3.546718565e-04f, 
-3.540224704e-04f, -3.533619353e-04f, -3.526902857e-04f, -3.520075561e-04f, -3.513137819e-04f, -3.506089984e-04f, -3.498932414e-04f, -3.491665470e-04f, -3.484289516e-04f, -3.476804921e-04f, 
-3.469212054e-04f, -3.461511290e-04f, -3.453703007e-04f, -3.445787584e-04f, -3.437765406e-04f, -3.429636860e-04f, -3.421402336e-04f, -3.413062226e-04f, -3.404616928e-04f, -3.396066841e-04f, 
-3.387412367e-04f, -3.378653912e-04f, -3.369791885e-04f, -3.360826698e-04f, -3.351758765e-04f, -3.342588504e-04f, -3.333316336e-04f, -3.323942686e-04f, -3.314467978e-04f, -3.304892644e-04f, 
-3.295217116e-04f, -3.285441829e-04f, -3.275567221e-04f, -3.265593735e-04f, -3.255521814e-04f, -3.245351904e-04f, -3.235084457e-04f, -3.224719924e-04f, -3.214258760e-04f, -3.203701424e-04f, 
-3.193048376e-04f, -3.182300081e-04f, -3.171457004e-04f, -3.160519614e-04f, -3.149488382e-04f, -3.138363784e-04f, -3.127146296e-04f, -3.115836398e-04f, -3.104434570e-04f, -3.092941299e-04f, 
-3.081357071e-04f, -3.069682376e-04f, -3.057917707e-04f, -3.046063557e-04f, -3.034120425e-04f, -3.022088809e-04f, -3.009969212e-04f, -2.997762139e-04f, -2.985468096e-04f, -2.973087593e-04f, 
-2.960621140e-04f, -2.948069253e-04f, -2.935432448e-04f, -2.922711242e-04f, -2.909906158e-04f, -2.897017717e-04f, -2.884046446e-04f, -2.870992871e-04f, -2.857857523e-04f, -2.844640934e-04f, 
-2.831343637e-04f, -2.817966169e-04f, -2.804509069e-04f, -2.790972876e-04f, -2.777358133e-04f, -2.763665384e-04f, -2.749895177e-04f, -2.736048060e-04f, -2.722124582e-04f, -2.708125298e-04f, 
-2.694050761e-04f, -2.679901528e-04f, -2.665678157e-04f, -2.651381209e-04f, -2.637011244e-04f, -2.622568828e-04f, -2.608054526e-04f, -2.593468906e-04f, -2.578812536e-04f, -2.564085988e-04f, 
-2.549289835e-04f, -2.534424651e-04f, -2.519491013e-04f, -2.504489498e-04f, -2.489420686e-04f, -2.474285158e-04f, -2.459083497e-04f, -2.443816286e-04f, -2.428484114e-04f, -2.413087565e-04f, 
-2.397627230e-04f, -2.382103700e-04f, -2.366517565e-04f, -2.350869420e-04f, -2.335159859e-04f, -2.319389479e-04f, -2.303558877e-04f, -2.287668653e-04f, -2.271719406e-04f, -2.255711739e-04f, 
-2.239646254e-04f, -2.223523556e-04f, -2.207344250e-04f, -2.191108944e-04f, -2.174818245e-04f, -2.158472762e-04f, -2.142073106e-04f, -2.125619889e-04f, -2.109113722e-04f, -2.092555220e-04f, 
-2.075944998e-04f, -2.059283672e-04f, -2.042571858e-04f, -2.025810175e-04f, -2.008999242e-04f, -1.992139678e-04f, -1.975232105e-04f, -1.958277144e-04f, -1.941275418e-04f, -1.924227551e-04f, 
-1.907134167e-04f, -1.889995892e-04f, -1.872813352e-04f, -1.855587173e-04f, -1.838317984e-04f, -1.821006413e-04f, -1.803653090e-04f, -1.786258644e-04f, -1.768823706e-04f, -1.751348907e-04f, 
-1.733834879e-04f, -1.716282255e-04f, -1.698691668e-04f, -1.681063752e-04f, -1.663399141e-04f, -1.645698470e-04f, -1.627962374e-04f, -1.610191489e-04f, -1.592386451e-04f, -1.574547898e-04f, 
-1.556676466e-04f, -1.538772793e-04f, -1.520837517e-04f, -1.502871276e-04f, -1.484874709e-04f, -1.466848455e-04f, -1.448793153e-04f, -1.430709442e-04f, -1.412597963e-04f, -1.394459356e-04f, 
-1.376294260e-04f, -1.358103317e-04f, -1.339887166e-04f, -1.321646448e-04f, -1.303381804e-04f, -1.285093876e-04f, -1.266783303e-04f, -1.248450727e-04f, -1.230096790e-04f, -1.211722132e-04f, 
-1.193327393e-04f, -1.174913217e-04f, -1.156480242e-04f, -1.138029110e-04f, -1.119560462e-04f, -1.101074939e-04f, -1.082573180e-04f, -1.064055827e-04f, -1.045523519e-04f, -1.026976897e-04f, 
-1.008416600e-04f, -9.898432676e-05f, -9.712575389e-05f, -9.526600530e-05f, -9.340514484e-05f, -9.154323633e-05f, -8.968034357e-05f, -8.781653031e-05f, -8.595186026e-05f, -8.408639708e-05f, 
-8.222020440e-05f, -8.035334581e-05f, -7.848588483e-05f, -7.661788493e-05f, -7.474940956e-05f, -7.288052208e-05f, -7.101128580e-05f, -6.914176399e-05f, -6.727201984e-05f, -6.540211648e-05f, 
-6.353211698e-05f, -6.166208435e-05f, -5.979208150e-05f, -5.792217131e-05f, -5.605241656e-05f, -5.418287996e-05f, -5.231362414e-05f, -5.044471166e-05f, -4.857620500e-05f, -4.670816655e-05f, 
-4.484065860e-05f, -4.297374337e-05f, -4.110748300e-05f, -3.924193951e-05f, -3.737717486e-05f, -3.551325088e-05f, -3.365022933e-05f, -3.178817186e-05f, -2.992714001e-05f, -2.806719523e-05f, 
-2.620839886e-05f, -2.435081213e-05f, -2.249449617e-05f, -2.063951198e-05f, -1.878592047e-05f, -1.693378242e-05f, -1.508315849e-05f, -1.323410924e-05f, -1.138669508e-05f, -9.540976324e-06f, 
-7.697013152e-06f, -5.854865613e-06f, -4.014593632e-06f, -2.176257002e-06f, -3.399153845e-07f, 1.494371693e-06f, 3.326544840e-06f, 5.156544802e-06f, 6.984312467e-06f, 8.809788862e-06f, 
1.063291516e-05f, 1.245363267e-05f, 1.427188287e-05f, 1.608760736e-05f, 1.790074791e-05f, 1.971124643e-05f, 2.151904500e-05f, 2.332408583e-05f, 2.512631132e-05f, 2.692566401e-05f, 
2.872208659e-05f, 3.051552195e-05f, 3.230591310e-05f, 3.409320326e-05f, 3.587733579e-05f, 3.765825423e-05f, 3.943590228e-05f, 4.121022384e-05f, 4.298116295e-05f, 4.474866386e-05f, 
4.651267098e-05f, 4.827312890e-05f, 5.002998240e-05f, 5.178317645e-05f, 5.353265617e-05f, 5.527836692e-05f, 5.702025421e-05f, 5.875826375e-05f, 6.049234144e-05f, 6.222243338e-05f, 
6.394848587e-05f, 6.567044538e-05f, 6.738825861e-05f, 6.910187245e-05f, 7.081123398e-05f, 7.251629049e-05f, 7.421698948e-05f, 7.591327865e-05f, 7.760510591e-05f, 7.929241938e-05f, 
8.097516739e-05f, 8.265329847e-05f, 8.432676139e-05f, 8.599550511e-05f, 8.765947882e-05f, 8.931863193e-05f, 9.097291407e-05f, 9.262227506e-05f, 9.426666500e-05f, 9.590603416e-05f, 
9.754033307e-05f, 9.916951247e-05f, 1.007935233e-04f, 1.024123169e-04f, 1.040258445e-04f, 1.056340579e-04f, 1.072369090e-04f, 1.088343498e-04f, 1.104263329e-04f, 1.120128107e-04f, 
1.135937362e-04f, 1.151690624e-04f, 1.167387426e-04f, 1.183027305e-04f, 1.198609798e-04f, 1.214134446e-04f, 1.229600793e-04f, 1.245008383e-04f, 1.260356765e-04f, 1.275645490e-04f, 
1.290874111e-04f, 1.306042183e-04f, 1.321149264e-04f, 1.336194916e-04f, 1.351178701e-04f, 1.366100186e-04f, 1.380958939e-04f, 1.395754531e-04f, 1.410486536e-04f, 1.425154530e-04f, 
1.439758093e-04f, 1.454296805e-04f, 1.468770252e-04f, 1.483178019e-04f, 1.497519698e-04f, 1.511794880e-04f, 1.526003160e-04f, 1.540144136e-04f, 1.554217408e-04f, 1.568222581e-04f, 
1.582159259e-04f, 1.596027052e-04f, 1.609825570e-04f, 1.623554429e-04f, 1.637213246e-04f, 1.650801639e-04f, 1.664319233e-04f, 1.677765652e-04f, 1.691140525e-04f, 1.704443483e-04f, 
1.717674159e-04f, 1.730832192e-04f, 1.743917220e-04f, 1.756928886e-04f, 1.769866836e-04f, 1.782730718e-04f, 1.795520184e-04f, 1.808234886e-04f, 1.820874483e-04f, 1.833438635e-04f, 
1.845927004e-04f, 1.858339257e-04f, 1.870675062e-04f, 1.882934091e-04f, 1.895116018e-04f, 1.907220522e-04f, 1.919247284e-04f, 1.931195986e-04f, 1.943066316e-04f, 1.954857963e-04f, 
1.966570620e-04f, 1.978203983e-04f, 1.989757750e-04f, 2.001231623e-04f, 2.012625307e-04f, 2.023938510e-04f, 2.035170943e-04f, 2.046322319e-04f, 2.057392356e-04f, 2.068380774e-04f, 
2.079287296e-04f, 2.090111647e-04f, 2.100853559e-04f, 2.111512761e-04f, 2.122088992e-04f, 2.132581988e-04f, 2.142991491e-04f, 2.153317247e-04f, 2.163559004e-04f, 2.173716511e-04f, 
2.183789525e-04f, 2.193777801e-04f, 2.203681101e-04f, 2.213499187e-04f, 2.223231827e-04f, 2.232878791e-04f, 2.242439852e-04f, 2.251914785e-04f, 2.261303370e-04f, 2.270605391e-04f, 
2.279820631e-04f, 2.288948881e-04f, 2.297989932e-04f, 2.306943580e-04f, 2.315809623e-04f, 2.324587862e-04f, 2.333278103e-04f, 2.341880154e-04f, 2.350393824e-04f, 2.358818930e-04f, 
2.367155289e-04f, 2.375402720e-04f, 2.383561049e-04f, 2.391630103e-04f, 2.399609711e-04f, 2.407499708e-04f, 2.415299931e-04f, 2.423010219e-04f, 2.430630416e-04f, 2.438160368e-04f, 
2.445599925e-04f, 2.452948940e-04f, 2.460207269e-04f, 2.467374772e-04f, 2.474451311e-04f, 2.481436752e-04f, 2.488330964e-04f, 2.495133819e-04f, 2.501845194e-04f, 2.508464966e-04f, 
2.514993018e-04f, 2.521429234e-04f, 2.527773505e-04f, 2.534025720e-04f, 2.540185776e-04f, 2.546253569e-04f, 2.552229003e-04f, 2.558111980e-04f, 2.563902410e-04f, 2.569600203e-04f, 
2.575205274e-04f, 2.580717539e-04f, 2.586136921e-04f, 2.591463342e-04f, 2.596696731e-04f, 2.601837017e-04f, 2.606884134e-04f, 2.611838020e-04f, 2.616698614e-04f, 2.621465859e-04f, 
2.626139702e-04f, 2.630720094e-04f, 2.635206986e-04f, 2.639600336e-04f, 2.643900102e-04f, 2.648106247e-04f, 2.652218737e-04f, 2.656237542e-04f, 2.660162632e-04f, 2.663993984e-04f, 
2.667731576e-04f, 2.671375391e-04f, 2.674925412e-04f, 2.678381628e-04f, 2.681744031e-04f, 2.685012616e-04f, 2.688187378e-04f, 2.691268321e-04f, 2.694255447e-04f, 2.697148765e-04f, 
2.699948283e-04f, 2.702654016e-04f, 2.705265981e-04f, 2.707784197e-04f, 2.710208688e-04f, 2.712539478e-04f, 2.714776599e-04f, 2.716920081e-04f, 2.718969961e-04f, 2.720926277e-04f, 
2.722789071e-04f, 2.724558388e-04f, 2.726234275e-04f, 2.727816784e-04f, 2.729305969e-04f, 2.730701887e-04f, 2.732004598e-04f, 2.733214166e-04f, 2.734330658e-04f, 2.735354142e-04f, 
2.736284692e-04f, 2.737122382e-04f, 2.737867293e-04f, 2.738519505e-04f, 2.739079103e-04f, 2.739546176e-04f, 2.739920813e-04f, 2.740203109e-04f, 2.740393161e-04f, 2.740491069e-04f, 
2.740496935e-04f, 2.740410865e-04f, 2.740232968e-04f, 2.739963357e-04f, 2.739602145e-04f, 2.739149450e-04f, 2.738605394e-04f, 2.737970100e-04f, 2.737243694e-04f, 2.736426307e-04f, 
2.735518069e-04f, 2.734519118e-04f, 2.733429590e-04f, 2.732249628e-04f, 2.730979376e-04f, 2.729618979e-04f, 2.728168589e-04f, 2.726628357e-04f, 2.724998440e-04f, 2.723278996e-04f, 
2.721470185e-04f, 2.719572173e-04f, 2.717585126e-04f, 2.715509213e-04f, 2.713344608e-04f, 2.711091485e-04f, 2.708750023e-04f, 2.706320403e-04f, 2.703802807e-04f, 2.701197424e-04f, 
2.698504441e-04f, 2.695724051e-04f, 2.692856448e-04f, 2.689901830e-04f, 2.686860397e-04f, 2.683732352e-04f, 2.680517899e-04f, 2.677217248e-04f, 2.673830608e-04f, 2.670358195e-04f, 
2.666800223e-04f, 2.663156911e-04f, 2.659428481e-04f, 2.655615157e-04f, 2.651717166e-04f, 2.647734736e-04f, 2.643668099e-04f, 2.639517491e-04f, 2.635283148e-04f, 2.630965309e-04f, 
2.626564216e-04f, 2.622080115e-04f, 2.617513252e-04f, 2.612863877e-04f, 2.608132242e-04f, 2.603318601e-04f, 2.598423212e-04f, 2.593446334e-04f, 2.588388230e-04f, 2.583249163e-04f, 
2.578029401e-04f, 2.572729212e-04f, 2.567348870e-04f, 2.561888647e-04f, 2.556348820e-04f, 2.550729668e-04f, 2.545031472e-04f, 2.539254517e-04f, 2.533399086e-04f, 2.527465470e-04f, 
2.521453958e-04f, 2.515364843e-04f, 2.509198421e-04f, 2.502954988e-04f, 2.496634845e-04f, 2.490238292e-04f, 2.483765635e-04f, 2.477217179e-04f, 2.470593234e-04f, 2.463894109e-04f, 
2.457120118e-04f, 2.450271575e-04f, 2.443348799e-04f, 2.436352108e-04f, 2.429281823e-04f, 2.422138269e-04f, 2.414921771e-04f, 2.407632657e-04f, 2.400271257e-04f, 2.392837902e-04f, 
2.385332927e-04f, 2.377756667e-04f, 2.370109461e-04f, 2.362391649e-04f, 2.354603572e-04f, 2.346745575e-04f, 2.338818004e-04f, 2.330821206e-04f, 2.322755531e-04f, 2.314621332e-04f, 
2.306418961e-04f, 2.298148774e-04f, 2.289811129e-04f, 2.281406386e-04f, 2.272934904e-04f, 2.264397048e-04f, 2.255793181e-04f, 2.247123671e-04f, 2.238388886e-04f, 2.229589197e-04f, 
2.220724974e-04f, 2.211796592e-04f, 2.202804427e-04f, 2.193748855e-04f, 2.184630255e-04f, 2.175449008e-04f, 2.166205496e-04f, 2.156900103e-04f, 2.147533214e-04f, 2.138105217e-04f, 
2.128616500e-04f, 2.119067453e-04f, 2.109458470e-04f, 2.099789942e-04f, 2.090062266e-04f, 2.080275837e-04f, 2.070431055e-04f, 2.060528318e-04f, 2.050568028e-04f, 2.040550587e-04f, 
2.030476399e-04f, 2.020345871e-04f, 2.010159408e-04f, 1.999917419e-04f, 1.989620315e-04f, 1.979268506e-04f, 1.968862404e-04f, 1.958402424e-04f, 1.947888981e-04f, 1.937322491e-04f, 
1.926703373e-04f, 1.916032044e-04f, 1.905308927e-04f, 1.894534442e-04f, 1.883709012e-04f, 1.872833062e-04f, 1.861907016e-04f, 1.850931302e-04f, 1.839906347e-04f, 1.828832580e-04f, 
1.817710431e-04f, 1.806540332e-04f, 1.795322714e-04f, 1.784058011e-04f, 1.772746657e-04f, 1.761389089e-04f, 1.749985742e-04f, 1.738537054e-04f, 1.727043465e-04f, 1.715505413e-04f, 
1.703923339e-04f, 1.692297685e-04f, 1.680628894e-04f, 1.668917409e-04f, 1.657163674e-04f, 1.645368136e-04f, 1.633531239e-04f, 1.621653432e-04f, 1.609735162e-04f, 1.597776878e-04f, 
1.585779030e-04f, 1.573742068e-04f, 1.561666443e-04f, 1.549552609e-04f, 1.537401016e-04f, 1.525212120e-04f, 1.512986374e-04f, 1.500724233e-04f, 1.488426153e-04f, 1.476092591e-04f, 
1.463724002e-04f, 1.451320846e-04f, 1.438883581e-04f, 1.426412665e-04f, 1.413908557e-04f, 1.401371719e-04f, 1.388802611e-04f, 1.376201693e-04f, 1.363569429e-04f, 1.350906279e-04f, 
1.338212707e-04f, 1.325489177e-04f, 1.312736151e-04f, 1.299954095e-04f, 1.287143472e-04f, 1.274304749e-04f, 1.261438389e-04f, 1.248544860e-04f, 1.235624628e-04f, 1.222678158e-04f, 
1.209705918e-04f, 1.196708376e-04f, 1.183685998e-04f, 1.170639254e-04f, 1.157568609e-04f, 1.144474534e-04f, 1.131357497e-04f, 1.118217967e-04f, 1.105056412e-04f, 1.091873302e-04f, 
1.078669107e-04f, 1.065444295e-04f, 1.052199338e-04f, 1.038934704e-04f, 1.025650863e-04f, 1.012348287e-04f, 9.990274439e-05f, 9.856888052e-05f, 9.723328408e-05f, 9.589600210e-05f, 
9.455708163e-05f, 9.321656969e-05f, 9.187451331e-05f, 9.053095953e-05f, 8.918595536e-05f, 8.783954783e-05f, 8.649178393e-05f, 8.514271068e-05f, 8.379237507e-05f, 8.244082405e-05f, 
8.108810461e-05f, 7.973426369e-05f, 7.837934821e-05f, 7.702340508e-05f, 7.566648121e-05f, 7.430862344e-05f, 7.294987863e-05f, 7.159029359e-05f, 7.022991513e-05f, 6.886878999e-05f, 
6.750696492e-05f, 6.614448662e-05f, 6.478140176e-05f, 6.341775696e-05f, 6.205359884e-05f, 6.068897396e-05f, 5.932392883e-05f, 5.795850993e-05f, 5.659276372e-05f, 5.522673658e-05f, 
5.386047486e-05f, 5.249402487e-05f, 5.112743286e-05f, 4.976074504e-05f, 4.839400757e-05f, 4.702726655e-05f, 4.566056801e-05f, 4.429395797e-05f, 4.292748235e-05f, 4.156118702e-05f, 
4.019511780e-05f, 3.882932046e-05f, 3.746384067e-05f, 3.609872406e-05f, 3.473401619e-05f, 3.336976257e-05f, 3.200600859e-05f, 3.064279964e-05f, 2.928018097e-05f, 2.791819780e-05f, 
2.655689526e-05f, 2.519631841e-05f, 2.383651223e-05f, 2.247752160e-05f, 2.111939137e-05f, 1.976216625e-05f, 1.840589090e-05f, 1.705060988e-05f, 1.569636769e-05f, 1.434320872e-05f, 
1.299117726e-05f, 1.164031753e-05f, 1.029067366e-05f, 8.942289673e-06f, 7.595209502e-06f, 6.249476986e-06f, 4.905135866e-06f, 3.562229783e-06f, 2.220802279e-06f, 8.808967941e-07f, 
-4.574433352e-07f, -1.794174876e-06f, -3.129254701e-06f, -4.462639790e-06f, -5.794287231e-06f, -7.124154221e-06f, -8.452198070e-06f, -9.778376197e-06f, -1.110264614e-05f, -1.242496554e-05f, 
-1.374529217e-05f, -1.506358391e-05f, -1.637979877e-05f, -1.769389486e-05f, -1.900583042e-05f, -2.031556383e-05f, -2.162305357e-05f, -2.292825825e-05f, -2.423113662e-05f, -2.553164755e-05f, 
-2.682975003e-05f, -2.812540318e-05f, -2.941856628e-05f, -3.070919871e-05f, -3.199725999e-05f, -3.328270979e-05f, -3.456550790e-05f, -3.584561426e-05f, -3.712298893e-05f, -3.839759213e-05f, 
-3.966938422e-05f, -4.093832568e-05f, -4.220437716e-05f, -4.346749945e-05f, -4.472765346e-05f, -4.598480027e-05f, -4.723890112e-05f, -4.848991736e-05f, -4.973781053e-05f, -5.098254230e-05f, 
-5.222407450e-05f, -5.346236910e-05f, -5.469738824e-05f, -5.592909421e-05f, -5.715744946e-05f, -5.838241660e-05f, -5.960395839e-05f, -6.082203776e-05f, -6.203661779e-05f, -6.324766172e-05f, 
-6.445513299e-05f, -6.565899515e-05f, -6.685921195e-05f, -6.805574730e-05f, -6.924856528e-05f, -7.043763013e-05f, -7.162290626e-05f, -7.280435826e-05f, -7.398195088e-05f, -7.515564906e-05f, 
-7.632541789e-05f, -7.749122265e-05f, -7.865302879e-05f, -7.981080195e-05f, -8.096450792e-05f, -8.211411269e-05f, -8.325958242e-05f, -8.440088347e-05f, -8.553798234e-05f, -8.667084576e-05f, 
-8.779944060e-05f, -8.892373394e-05f, -9.004369305e-05f, -9.115928536e-05f, -9.227047851e-05f, -9.337724031e-05f, -9.447953877e-05f, -9.557734209e-05f, -9.667061865e-05f, -9.775933702e-05f, 
-9.884346598e-05f, -9.992297449e-05f, -1.009978317e-04f, -1.020680070e-04f, -1.031334698e-04f, -1.041941900e-04f, -1.052501374e-04f, -1.063012823e-04f, -1.073475948e-04f, -1.083890457e-04f, 
-1.094256055e-04f, -1.104572453e-04f, -1.114839361e-04f, -1.125056492e-04f, -1.135223563e-04f, -1.145340291e-04f, -1.155406395e-04f, -1.165421596e-04f, -1.175385618e-04f, -1.185298187e-04f, 
-1.195159031e-04f, -1.204967878e-04f, -1.214724461e-04f, -1.224428514e-04f, -1.234079773e-04f, -1.243677976e-04f, -1.253222863e-04f, -1.262714177e-04f, -1.272151661e-04f, -1.281535063e-04f, 
-1.290864132e-04f, -1.300138617e-04f, -1.309358273e-04f, -1.318522853e-04f, -1.327632117e-04f, -1.336685822e-04f, -1.345683732e-04f, -1.354625608e-04f, -1.363511219e-04f, -1.372340331e-04f, 
-1.381112715e-04f, -1.389828143e-04f, -1.398486391e-04f, -1.407087236e-04f, -1.415630456e-04f, -1.424115832e-04f, -1.432543150e-04f, -1.440912193e-04f, -1.449222751e-04f, -1.457474614e-04f, 
-1.465667574e-04f, -1.473801426e-04f, -1.481875967e-04f, -1.489890997e-04f, -1.497846316e-04f, -1.505741729e-04f, -1.513577041e-04f, -1.521352062e-04f, -1.529066601e-04f, -1.536720471e-04f, 
-1.544313488e-04f, -1.551845469e-04f, -1.559316234e-04f, -1.566725604e-04f, -1.574073404e-04f, -1.581359461e-04f, -1.588583603e-04f, -1.595745662e-04f, -1.602845471e-04f, -1.609882865e-04f, 
-1.616857684e-04f, -1.623769767e-04f, -1.630618956e-04f, -1.637405098e-04f, -1.644128040e-04f, -1.650787630e-04f, -1.657383722e-04f, -1.663916169e-04f, -1.670384828e-04f, -1.676789558e-04f, 
-1.683130220e-04f, -1.689406679e-04f, -1.695618800e-04f, -1.701766451e-04f, -1.707849503e-04f, -1.713867829e-04f, -1.719821305e-04f, -1.725709808e-04f, -1.731533218e-04f, -1.737291418e-04f, 
-1.742984292e-04f, -1.748611727e-04f, -1.754173614e-04f, -1.759669843e-04f, -1.765100309e-04f, -1.770464908e-04f, -1.775763539e-04f, -1.780996104e-04f, -1.786162506e-04f, -1.791262650e-04f, 
-1.796296446e-04f, -1.801263803e-04f, -1.806164636e-04f, -1.810998858e-04f, -1.815766388e-04f, -1.820467146e-04f, -1.825101055e-04f, -1.829668038e-04f, -1.834168024e-04f, -1.838600941e-04f, 
-1.842966722e-04f, -1.847265301e-04f, -1.851496613e-04f, -1.855660599e-04f, -1.859757199e-04f, -1.863786358e-04f, -1.867748020e-04f, -1.871642134e-04f, -1.875468651e-04f, -1.879227524e-04f, 
-1.882918709e-04f, -1.886542162e-04f, -1.890097844e-04f, -1.893585717e-04f, -1.897005747e-04f, -1.900357899e-04f, -1.903642144e-04f, -1.906858453e-04f, -1.910006801e-04f, -1.913087163e-04f, 
-1.916099518e-04f, -1.919043848e-04f, -1.921920136e-04f, -1.924728367e-04f, -1.927468529e-04f, -1.930140613e-04f, -1.932744612e-04f, -1.935280520e-04f, -1.937748335e-04f, -1.940148056e-04f, 
-1.942479686e-04f, -1.944743227e-04f, -1.946938688e-04f, -1.949066076e-04f, -1.951125403e-04f, -1.953116681e-04f, -1.955039928e-04f, -1.956895160e-04f, -1.958682398e-04f, -1.960401665e-04f, 
-1.962052985e-04f, -1.963636385e-04f, -1.965151894e-04f, -1.966599544e-04f, -1.967979370e-04f, -1.969291406e-04f, -1.970535692e-04f, -1.971712267e-04f, -1.972821175e-04f, -1.973862461e-04f, 
-1.974836172e-04f, -1.975742358e-04f, -1.976581070e-04f, -1.977352362e-04f, -1.978056291e-04f, -1.978692914e-04f, -1.979262293e-04f, -1.979764491e-04f, -1.980199571e-04f, -1.980567602e-04f, 
-1.980868654e-04f, -1.981102796e-04f, -1.981270104e-04f, -1.981370653e-04f, -1.981404521e-04f, -1.981371788e-04f, -1.981272538e-04f, -1.981106854e-04f, -1.980874823e-04f, -1.980576534e-04f, 
-1.980212078e-04f, -1.979781548e-04f, -1.979285039e-04f, -1.978722649e-04f, -1.978094477e-04f, -1.977400625e-04f, -1.976641196e-04f, -1.975816296e-04f, -1.974926034e-04f, -1.973970518e-04f, 
-1.972949861e-04f, -1.971864177e-04f, -1.970713582e-04f, -1.969498194e-04f, -1.968218134e-04f, -1.966873524e-04f, -1.965464488e-04f, -1.963991152e-04f, -1.962453645e-04f, -1.960852098e-04f, 
-1.959186642e-04f, -1.957457412e-04f, -1.955664545e-04f, -1.953808178e-04f, -1.951888453e-04f, -1.949905511e-04f, -1.947859497e-04f, -1.945750557e-04f, -1.943578839e-04f, -1.941344494e-04f, 
-1.939047674e-04f, -1.936688532e-04f, -1.934267224e-04f, -1.931783909e-04f, -1.929238746e-04f, -1.926631897e-04f, -1.923963525e-04f, -1.921233796e-04f, -1.918442877e-04f, -1.915590938e-04f, 
-1.912678149e-04f, -1.909704683e-04f, -1.906670715e-04f, -1.903576422e-04f, -1.900421982e-04f, -1.897207574e-04f, -1.893933382e-04f, -1.890599589e-04f, -1.887206381e-04f, -1.883753945e-04f, 
-1.880242470e-04f, -1.876672147e-04f, -1.873043169e-04f, -1.869355731e-04f, -1.865610027e-04f, -1.861806258e-04f, -1.857944621e-04f, -1.854025319e-04f, -1.850048555e-04f, -1.846014533e-04f, 
-1.841923460e-04f, -1.837775544e-04f, -1.833570994e-04f, -1.829310023e-04f, -1.824992843e-04f, -1.820619669e-04f, -1.816190717e-04f, -1.811706207e-04f, -1.807166356e-04f, -1.802571387e-04f, 
-1.797921521e-04f, -1.793216985e-04f, -1.788458003e-04f, -1.783644804e-04f, -1.778777615e-04f, -1.773856669e-04f, -1.768882197e-04f, -1.763854432e-04f, -1.758773611e-04f, -1.753639970e-04f, 
-1.748453747e-04f, -1.743215182e-04f, -1.737924515e-04f, -1.732581991e-04f, -1.727187853e-04f, -1.721742346e-04f, -1.716245718e-04f, -1.710698216e-04f, -1.705100092e-04f, -1.699451596e-04f, 
-1.693752981e-04f, -1.688004500e-04f, -1.682206410e-04f, -1.676358967e-04f, -1.670462430e-04f, -1.664517057e-04f, -1.658523110e-04f, -1.652480851e-04f, -1.646390543e-04f, -1.640252451e-04f, 
-1.634066841e-04f, -1.627833981e-04f, -1.621554140e-04f, -1.615227586e-04f, -1.608854591e-04f, -1.602435428e-04f, -1.595970371e-04f, -1.589459693e-04f, -1.582903671e-04f, -1.576302583e-04f, 
-1.569656706e-04f, -1.562966320e-04f, -1.556231707e-04f, -1.549453147e-04f, -1.542630925e-04f, -1.535765323e-04f, -1.528856628e-04f, -1.521905126e-04f, -1.514911104e-04f, -1.507874851e-04f, 
-1.500796656e-04f, -1.493676811e-04f, -1.486515607e-04f, -1.479313336e-04f, -1.472070293e-04f, -1.464786773e-04f, -1.457463071e-04f, -1.450099485e-04f, -1.442696311e-04f, -1.435253849e-04f, 
-1.427772400e-04f, -1.420252262e-04f, -1.412693739e-04f, -1.405097132e-04f, -1.397462745e-04f, -1.389790884e-04f, -1.382081852e-04f, -1.374335956e-04f, -1.366553503e-04f, -1.358734802e-04f, 
-1.350880160e-04f, -1.342989888e-04f, -1.335064296e-04f, -1.327103695e-04f, -1.319108397e-04f, -1.311078715e-04f, -1.303014963e-04f, -1.294917454e-04f, -1.286786505e-04f, -1.278622431e-04f, 
-1.270425549e-04f, -1.262196175e-04f, -1.253934629e-04f, -1.245641228e-04f, -1.237316292e-04f, -1.228960142e-04f, -1.220573097e-04f, -1.212155480e-04f, -1.203707612e-04f, -1.195229816e-04f, 
-1.186722416e-04f, -1.178185734e-04f, -1.169620097e-04f, -1.161025828e-04f, -1.152403253e-04f, -1.143752699e-04f, -1.135074492e-04f, -1.126368959e-04f, -1.117636428e-04f, -1.108877228e-04f, 
-1.100091688e-04f, -1.091280135e-04f, -1.082442901e-04f, -1.073580315e-04f, -1.064692709e-04f, -1.055780412e-04f, -1.046843757e-04f, -1.037883075e-04f, -1.028898699e-04f, -1.019890962e-04f, 
-1.010860196e-04f, -1.001806735e-04f, -9.927309136e-05f, -9.836330646e-05f, -9.745135232e-05f, -9.653726240e-05f, -9.562107021e-05f, -9.470280930e-05f, -9.378251324e-05f, -9.286021561e-05f, 
-9.193595005e-05f, -9.100975019e-05f, -9.008164971e-05f, -8.915168230e-05f, -8.821988167e-05f, -8.728628157e-05f, -8.635091573e-05f, -8.541381794e-05f, -8.447502198e-05f, -8.353456165e-05f, 
-8.259247078e-05f, -8.164878319e-05f, -8.070353272e-05f, -7.975675324e-05f, -7.880847859e-05f, -7.785874266e-05f, -7.690757932e-05f, -7.595502246e-05f, -7.500110597e-05f, -7.404586374e-05f, 
-7.308932967e-05f, -7.213153766e-05f, -7.117252161e-05f, -7.021231541e-05f, -6.925095296e-05f, -6.828846815e-05f, -6.732489488e-05f, -6.636026702e-05f, -6.539461846e-05f, -6.442798305e-05f, 
-6.346039467e-05f, -6.249188716e-05f, -6.152249436e-05f, -6.055225011e-05f, -5.958118820e-05f, -5.860934245e-05f, -5.763674663e-05f, -5.666343452e-05f, -5.568943985e-05f, -5.471479637e-05f, 
-5.373953778e-05f, -5.276369778e-05f, -5.178731001e-05f, -5.081040814e-05f, -4.983302578e-05f, -4.885519651e-05f, -4.787695392e-05f, -4.689833152e-05f, -4.591936284e-05f, -4.494008135e-05f, 
-4.396052049e-05f, -4.298071369e-05f, -4.200069433e-05f, -4.102049574e-05f, -4.004015125e-05f, -3.905969413e-05f, -3.807915761e-05f, -3.709857489e-05f, -3.611797913e-05f, -3.513740345e-05f, 
-3.415688093e-05f, -3.317644458e-05f, -3.219612741e-05f, -3.121596234e-05f, -3.023598229e-05f, -2.925622009e-05f, -2.827670855e-05f, -2.729748042e-05f, -2.631856838e-05f, -2.534000511e-05f, 
-2.436182318e-05f, -2.338405514e-05f, -2.240673347e-05f, -2.142989062e-05f, -2.045355894e-05f, -1.947777075e-05f, -1.850255832e-05f, -1.752795384e-05f, -1.655398945e-05f, -1.558069721e-05f, 
-1.460810915e-05f, -1.363625720e-05f, -1.266517325e-05f, -1.169488912e-05f, -1.072543655e-05f, -9.756847223e-06f, -8.789152753e-06f, -7.822384682e-06f, -6.856574479e-06f, -5.891753543e-06f, 
-4.927953201e-06f, -3.965204704e-06f, -3.003539230e-06f, -2.042987878e-06f, -1.083581674e-06f, -1.253515634e-07f, 8.316715853e-07f, 1.787456984e-06f, 2.741973926e-06f, 3.695191786e-06f, 
4.647080019e-06f, 5.597608166e-06f, 6.546745853e-06f, 7.494462788e-06f, 8.440728768e-06f, 9.385513677e-06f, 1.032878749e-05f, 1.127052026e-05f, 1.221068214e-05f, 1.314924337e-05f, 
1.408617428e-05f, 1.502144531e-05f, 1.595502697e-05f, 1.688688987e-05f, 1.781700472e-05f, 1.874534233e-05f, 1.967187360e-05f, 2.059656953e-05f, 2.151940121e-05f, 2.244033984e-05f, 
2.335935673e-05f, 2.427642328e-05f, 2.519151098e-05f, 2.610459143e-05f, 2.701563636e-05f, 2.792461757e-05f, 2.883150698e-05f, 2.973627662e-05f, 3.063889862e-05f, 3.153934522e-05f, 
3.243758877e-05f, 3.333360172e-05f, 3.422735666e-05f, 3.511882625e-05f, 3.600798329e-05f, 3.689480069e-05f, 3.777925146e-05f, 3.866130873e-05f, 3.954094576e-05f, 4.041813591e-05f, 
4.129285266e-05f, 4.216506960e-05f, 4.303476045e-05f, 4.390189906e-05f, 4.476645936e-05f, 4.562841544e-05f, 4.648774149e-05f, 4.734441183e-05f, 4.819840089e-05f, 4.904968325e-05f, 
4.989823359e-05f, 5.074402672e-05f, 5.158703757e-05f, 5.242724122e-05f, 5.326461284e-05f, 5.409912777e-05f, 5.493076144e-05f, 5.575948942e-05f, 5.658528743e-05f, 5.740813129e-05f, 
5.822799696e-05f, 5.904486056e-05f, 5.985869829e-05f, 6.066948653e-05f, 6.147720176e-05f, 6.228182062e-05f, 6.308331987e-05f, 6.388167640e-05f, 6.467686725e-05f, 6.546886959e-05f, 
6.625766072e-05f, 6.704321809e-05f, 6.782551928e-05f, 6.860454202e-05f, 6.938026416e-05f, 7.015266371e-05f, 7.092171881e-05f, 7.168740774e-05f, 7.244970893e-05f, 7.320860093e-05f, 
7.396406247e-05f, 7.471607239e-05f, 7.546460970e-05f, 7.620965353e-05f, 7.695118316e-05f, 7.768917804e-05f, 7.842361773e-05f, 7.915448197e-05f, 7.988175062e-05f, 8.060540370e-05f, 
8.132542138e-05f, 8.204178397e-05f, 8.275447194e-05f, 8.346346590e-05f, 8.416874662e-05f, 8.487029500e-05f, 8.556809212e-05f, 8.626211918e-05f, 8.695235756e-05f, 8.763878878e-05f, 
8.832139450e-05f, 8.900015656e-05f, 8.967505693e-05f, 9.034607774e-05f, 9.101320129e-05f, 9.167641001e-05f, 9.233568651e-05f, 9.299101352e-05f, 9.364237397e-05f, 9.428975092e-05f, 
9.493312758e-05f, 9.557248734e-05f, 9.620781373e-05f, 9.683909045e-05f, 9.746630134e-05f, 9.808943042e-05f, 9.870846186e-05f, 9.932337998e-05f, 9.993416928e-05f, 1.005408144e-04f, 
1.011433001e-04f, 1.017416115e-04f, 1.023357335e-04f, 1.029256516e-04f, 1.035113511e-04f, 1.040928177e-04f, 1.046700372e-04f, 1.052429955e-04f, 1.058116786e-04f, 1.063760729e-04f, 
1.069361648e-04f, 1.074919408e-04f, 1.080433877e-04f, 1.085904925e-04f, 1.091332422e-04f, 1.096716240e-04f, 1.102056254e-04f, 1.107352340e-04f, 1.112604374e-04f, 1.117812236e-04f, 
1.122975806e-04f, 1.128094967e-04f, 1.133169603e-04f, 1.138199599e-04f, 1.143184843e-04f, 1.148125224e-04f, 1.153020632e-04f, 1.157870960e-04f, 1.162676101e-04f, 1.167435952e-04f, 
1.172150409e-04f, 1.176819372e-04f, 1.181442741e-04f, 1.186020419e-04f, 1.190552309e-04f, 1.195038318e-04f, 1.199478352e-04f, 1.203872320e-04f, 1.208220134e-04f, 1.212521706e-04f, 
1.216776949e-04f, 1.220985780e-04f, 1.225148116e-04f, 1.229263876e-04f, 1.233332982e-04f, 1.237355354e-04f, 1.241330918e-04f, 1.245259600e-04f, 1.249141326e-04f, 1.252976027e-04f, 
1.256763633e-04f, 1.260504076e-04f, 1.264197292e-04f, 1.267843216e-04f, 1.271441785e-04f, 1.274992939e-04f, 1.278496620e-04f, 1.281952769e-04f, 1.285361332e-04f, 1.288722253e-04f, 
1.292035482e-04f, 1.295300968e-04f, 1.298518661e-04f, 1.301688514e-04f, 1.304810483e-04f, 1.307884523e-04f, 1.310910592e-04f, 1.313888650e-04f, 1.316818657e-04f, 1.319700578e-04f, 
1.322534376e-04f, 1.325320018e-04f, 1.328057471e-04f, 1.330746706e-04f, 1.333387694e-04f, 1.335980407e-04f, 1.338524821e-04f, 1.341020911e-04f, 1.343468656e-04f, 1.345868036e-04f, 
1.348219031e-04f, 1.350521625e-04f, 1.352775802e-04f, 1.354981549e-04f, 1.357138853e-04f, 1.359247705e-04f, 1.361308095e-04f, 1.363320018e-04f, 1.365283466e-04f, 1.367198437e-04f, 
1.369064928e-04f, 1.370882939e-04f, 1.372652472e-04f, 1.374373528e-04f, 1.376046114e-04f, 1.377670233e-04f, 1.379245896e-04f, 1.380773110e-04f, 1.382251887e-04f, 1.383682240e-04f, 
1.385064183e-04f, 1.386397731e-04f, 1.387682903e-04f, 1.388919718e-04f, 1.390108195e-04f, 1.391248359e-04f, 1.392340232e-04f, 1.393383841e-04f, 1.394379212e-04f, 1.395326374e-04f, 
1.396225359e-04f, 1.397076197e-04f, 1.397878922e-04f, 1.398633570e-04f, 1.399340178e-04f, 1.399998783e-04f, 1.400609426e-04f, 1.401172149e-04f, 1.401686993e-04f, 1.402154005e-04f, 
1.402573230e-04f, 1.402944716e-04f, 1.403268512e-04f, 1.403544670e-04f, 1.403773241e-04f, 1.403954280e-04f, 1.404087842e-04f, 1.404173985e-04f, 1.404212767e-04f, 1.404204248e-04f, 
1.404148489e-04f, 1.404045555e-04f, 1.403895510e-04f, 1.403698419e-04f, 1.403454352e-04f, 1.403163376e-04f, 1.402825563e-04f, 1.402440985e-04f, 1.402009716e-04f, 1.401531832e-04f, 
1.401007407e-04f, 1.400436522e-04f, 1.399819256e-04f, 1.399155689e-04f, 1.398445905e-04f, 1.397689988e-04f, 1.396888022e-04f, 1.396040096e-04f, 1.395146297e-04f, 1.394206715e-04f, 
1.393221443e-04f, 1.392190571e-04f, 1.391114196e-04f, 1.389992411e-04f, 1.388825315e-04f, 1.387613006e-04f, 1.386355583e-04f, 1.385053149e-04f, 1.383705804e-04f, 1.382313654e-04f, 
1.380876804e-04f, 1.379395361e-04f, 1.377869432e-04f, 1.376299128e-04f, 1.374684559e-04f, 1.373025838e-04f, 1.371323078e-04f, 1.369576395e-04f, 1.367785903e-04f, 1.365951722e-04f, 
1.364073970e-04f, 1.362152768e-04f, 1.360188236e-04f, 1.358180499e-04f, 1.356129679e-04f, 1.354035904e-04f, 1.351899299e-04f, 1.349719993e-04f, 1.347498114e-04f, 1.345233795e-04f, 
1.342927166e-04f, 1.340578362e-04f, 1.338187516e-04f, 1.335754764e-04f, 1.333280243e-04f, 1.330764091e-04f, 1.328206449e-04f, 1.325607456e-04f, 1.322967254e-04f, 1.320285987e-04f, 
1.317563799e-04f, 1.314800835e-04f, 1.311997242e-04f, 1.309153168e-04f, 1.306268763e-04f, 1.303344175e-04f, 1.300379558e-04f, 1.297375063e-04f, 1.294330844e-04f, 1.291247056e-04f, 
1.288123855e-04f, 1.284961398e-04f, 1.281759844e-04f, 1.278519352e-04f, 1.275240082e-04f, 1.271922197e-04f, 1.268565858e-04f, 1.265171230e-04f, 1.261738478e-04f, 1.258267768e-04f, 
1.254759266e-04f, 1.251213141e-04f, 1.247629562e-04f, 1.244008700e-04f, 1.240350725e-04f, 1.236655810e-04f, 1.232924129e-04f, 1.229155855e-04f, 1.225351164e-04f, 1.221510233e-04f, 
1.217633239e-04f, 1.213720360e-04f, 1.209771776e-04f, 1.205787667e-04f, 1.201768214e-04f, 1.197713600e-04f, 1.193624008e-04f, 1.189499621e-04f, 1.185340627e-04f, 1.181147209e-04f, 
1.176919556e-04f, 1.172657856e-04f, 1.168362296e-04f, 1.164033067e-04f, 1.159670360e-04f, 1.155274365e-04f, 1.150845276e-04f, 1.146383286e-04f, 1.141888588e-04f, 1.137361378e-04f, 
1.132801851e-04f, 1.128210205e-04f, 1.123586637e-04f, 1.118931344e-04f, 1.114244527e-04f, 1.109526385e-04f, 1.104777119e-04f, 1.099996931e-04f, 1.095186022e-04f, 1.090344597e-04f, 
1.085472858e-04f, 1.080571010e-04f, 1.075639260e-04f, 1.070677813e-04f, 1.065686876e-04f, 1.060666656e-04f, 1.055617362e-04f, 1.050539203e-04f, 1.045432389e-04f, 1.040297130e-04f, 
1.035133638e-04f, 1.029942124e-04f, 1.024722800e-04f, 1.019475881e-04f, 1.014201579e-04f, 1.008900109e-04f, 1.003571686e-04f, 9.982165271e-05f, 9.928348472e-05f, 9.874268637e-05f, 
9.819927942e-05f, 9.765328570e-05f, 9.710472708e-05f, 9.655362551e-05f, 9.600000297e-05f, 9.544388151e-05f, 9.488528326e-05f, 9.432423036e-05f, 9.376074504e-05f, 9.319484957e-05f, 
9.262656627e-05f, 9.205591751e-05f, 9.148292572e-05f, 9.090761338e-05f, 9.033000301e-05f, 8.975011719e-05f, 8.916797853e-05f, 8.858360970e-05f, 8.799703343e-05f, 8.740827245e-05f, 
8.681734959e-05f, 8.622428769e-05f, 8.562910962e-05f, 8.503183834e-05f, 8.443249680e-05f, 8.383110802e-05f, 8.322769504e-05f, 8.262228097e-05f, 8.201488892e-05f, 8.140554206e-05f, 
8.079426358e-05f, 8.018107673e-05f, 7.956600477e-05f, 7.894907100e-05f, 7.833029876e-05f, 7.770971141e-05f, 7.708733234e-05f, 7.646318500e-05f, 7.583729282e-05f, 7.520967931e-05f, 
7.458036795e-05f, 7.394938231e-05f, 7.331674593e-05f, 7.268248242e-05f, 7.204661537e-05f, 7.140916844e-05f, 7.077016527e-05f, 7.012962955e-05f, 6.948758498e-05f, 6.884405528e-05f, 
6.819906418e-05f, 6.755263546e-05f, 6.690479289e-05f, 6.625556025e-05f, 6.560496136e-05f, 6.495302003e-05f, 6.429976012e-05f, 6.364520546e-05f, 6.298937992e-05f, 6.233230737e-05f, 
6.167401170e-05f, 6.101451681e-05f, 6.035384660e-05f, 5.969202499e-05f, 5.902907588e-05f, 5.836502321e-05f, 5.769989092e-05f, 5.703370293e-05f, 5.636648320e-05f, 5.569825566e-05f, 
5.502904426e-05f, 5.435887296e-05f, 5.368776570e-05f, 5.301574643e-05f, 5.234283911e-05f, 5.166906767e-05f, 5.099445608e-05f, 5.031902825e-05f, 4.964280815e-05f, 4.896581969e-05f, 
4.828808681e-05f, 4.760963343e-05f, 4.693048346e-05f, 4.625066080e-05f, 4.557018936e-05f, 4.488909302e-05f, 4.420739567e-05f, 4.352512115e-05f, 4.284229333e-05f, 4.215893605e-05f, 
4.147507314e-05f, 4.079072840e-05f, 4.010592564e-05f, 3.942068863e-05f, 3.873504114e-05f, 3.804900691e-05f, 3.736260968e-05f, 3.667587316e-05f, 3.598882102e-05f, 3.530147695e-05f, 
3.461386458e-05f, 3.392600754e-05f, 3.323792944e-05f, 3.254965384e-05f, 3.186120430e-05f, 3.117260436e-05f, 3.048387750e-05f, 2.979504720e-05f, 2.910613692e-05f, 2.841717006e-05f, 
2.772817002e-05f, 2.703916015e-05f, 2.635016378e-05f, 2.566120421e-05f, 2.497230470e-05f, 2.428348848e-05f, 2.359477875e-05f, 2.290619867e-05f, 2.221777137e-05f, 2.152951993e-05f, 
2.084146743e-05f, 2.015363686e-05f, 1.946605121e-05f, 1.877873341e-05f, 1.809170638e-05f, 1.740499296e-05f, 1.671861598e-05f, 1.603259821e-05f, 1.534696238e-05f, 1.466173120e-05f, 
1.397692729e-05f, 1.329257326e-05f, 1.260869168e-05f, 1.192530505e-05f, 1.124243583e-05f, 1.056010643e-05f, 9.878339234e-06f, 9.197156549e-06f, 8.516580646e-06f, 7.836633742e-06f, 
7.157338005e-06f, 6.478715549e-06f, 5.800788438e-06f, 5.123578681e-06f, 4.447108233e-06f, 3.771398996e-06f, 3.096472817e-06f, 2.422351484e-06f, 1.749056732e-06f, 1.076610237e-06f, 
4.050336185e-07f, -2.656515642e-07f, -9.354238099e-07f, -1.604261678e-06f, -2.272143786e-06f, -2.939048817e-06f, -3.604955511e-06f, -4.269842674e-06f, -4.933689174e-06f, -5.596473941e-06f, 
-6.258175972e-06f, -6.918774327e-06f, -7.578248133e-06f, -8.236576582e-06f, -8.893738933e-06f, -9.549714513e-06f, -1.020448272e-05f, -1.085802301e-05f, -1.151031492e-05f, -1.216133806e-05f, 
-1.281107209e-05f, -1.345949677e-05f, -1.410659190e-05f, -1.475233738e-05f, -1.539671316e-05f, -1.603969929e-05f, -1.668127587e-05f, -1.732142308e-05f, -1.796012118e-05f, -1.859735052e-05f, 
-1.923309148e-05f, -1.986732458e-05f, -2.050003037e-05f, -2.113118949e-05f, -2.176078267e-05f, -2.238879070e-05f, -2.301519447e-05f, -2.363997495e-05f, -2.426311316e-05f, -2.488459024e-05f, 
-2.550438739e-05f, -2.612248589e-05f, -2.673886713e-05f, -2.735351254e-05f, -2.796640368e-05f, -2.857752215e-05f, -2.918684967e-05f, -2.979436804e-05f, -3.040005913e-05f, -3.100390490e-05f, 
-3.160588742e-05f, -3.220598881e-05f, -3.280419131e-05f, -3.340047723e-05f, -3.399482898e-05f, -3.458722906e-05f, -3.517766005e-05f, -3.576610462e-05f, -3.635254555e-05f, -3.693696569e-05f, 
-3.751934798e-05f, -3.809967548e-05f, -3.867793131e-05f, -3.925409871e-05f, -3.982816099e-05f, -4.040010157e-05f, -4.096990397e-05f, -4.153755178e-05f, -4.210302871e-05f, -4.266631856e-05f, 
-4.322740521e-05f, -4.378627266e-05f, -4.434290499e-05f, -4.489728639e-05f, -4.544940113e-05f, -4.599923361e-05f, -4.654676829e-05f, -4.709198976e-05f, -4.763488270e-05f, -4.817543187e-05f, 
-4.871362217e-05f, -4.924943856e-05f, -4.978286613e-05f, -5.031389006e-05f, -5.084249563e-05f, -5.136866823e-05f, -5.189239334e-05f, -5.241365655e-05f, -5.293244357e-05f, -5.344874018e-05f, 
-5.396253228e-05f, -5.447380589e-05f, -5.498254711e-05f, -5.548874216e-05f, -5.599237735e-05f, -5.649343912e-05f, -5.699191400e-05f, -5.748778862e-05f, -5.798104972e-05f, -5.847168417e-05f, 
-5.895967892e-05f, -5.944502103e-05f, -5.992769768e-05f, -6.040769615e-05f, -6.088500383e-05f, -6.135960822e-05f, -6.183149693e-05f, -6.230065768e-05f, -6.276707828e-05f, -6.323074669e-05f, 
-6.369165094e-05f, -6.414977919e-05f, -6.460511971e-05f, -6.505766088e-05f, -6.550739118e-05f, -6.595429922e-05f, -6.639837370e-05f, -6.683960346e-05f, -6.727797742e-05f, -6.771348463e-05f, 
-6.814611426e-05f, -6.857585557e-05f, -6.900269796e-05f, -6.942663092e-05f, -6.984764405e-05f, -7.026572710e-05f, -7.068086989e-05f, -7.109306238e-05f, -7.150229464e-05f, -7.190855684e-05f, 
-7.231183929e-05f, -7.271213238e-05f, -7.310942666e-05f, -7.350371275e-05f, -7.389498142e-05f, -7.428322352e-05f, -7.466843006e-05f, -7.505059212e-05f, -7.542970093e-05f, -7.580574782e-05f, 
-7.617872423e-05f, -7.654862174e-05f, -7.691543202e-05f, -7.727914687e-05f, -7.763975820e-05f, -7.799725805e-05f, -7.835163856e-05f, -7.870289200e-05f, -7.905101074e-05f, -7.939598729e-05f, 
-7.973781426e-05f, -8.007648439e-05f, -8.041199052e-05f, -8.074432562e-05f, -8.107348278e-05f, -8.139945520e-05f, -8.172223620e-05f, -8.204181921e-05f, -8.235819780e-05f, -8.267136563e-05f, 
-8.298131650e-05f, -8.328804432e-05f, -8.359154311e-05f, -8.389180702e-05f, -8.418883032e-05f, -8.448260738e-05f, -8.477313270e-05f, -8.506040092e-05f, -8.534440675e-05f, -8.562514505e-05f, 
-8.590261080e-05f, -8.617679909e-05f, -8.644770513e-05f, -8.671532424e-05f, -8.697965187e-05f, -8.724068359e-05f, -8.749841507e-05f, -8.775284213e-05f, -8.800396066e-05f, -8.825176673e-05f, 
-8.849625647e-05f, -8.873742616e-05f, -8.897527220e-05f, -8.920979109e-05f, -8.944097946e-05f, -8.966883405e-05f, -8.989335174e-05f, -9.011452950e-05f, -9.033236442e-05f, -9.054685374e-05f, 
-9.075799477e-05f, -9.096578498e-05f, -9.117022194e-05f, -9.137130332e-05f, -9.156902694e-05f, -9.176339072e-05f, -9.195439270e-05f, -9.214203103e-05f, -9.232630399e-05f, -9.250720996e-05f, 
-9.268474746e-05f, -9.285891511e-05f, -9.302971165e-05f, -9.319713593e-05f, -9.336118694e-05f, -9.352186375e-05f, -9.367916558e-05f, -9.383309174e-05f, -9.398364168e-05f, -9.413081495e-05f, 
-9.427461122e-05f, -9.441503027e-05f, -9.455207199e-05f, -9.468573642e-05f, -9.481602367e-05f, -9.494293399e-05f, -9.506646774e-05f, -9.518662539e-05f, -9.530340753e-05f, -9.541681487e-05f, 
-9.552684821e-05f, -9.563350850e-05f, -9.573679676e-05f, -9.583671417e-05f, -9.593326198e-05f, -9.602644159e-05f, -9.611625448e-05f, -9.620270227e-05f, -9.628578667e-05f, -9.636550953e-05f, 
-9.644187278e-05f, -9.651487848e-05f, -9.658452879e-05f, -9.665082601e-05f, -9.671377251e-05f, -9.677337080e-05f, -9.682962350e-05f, -9.688253331e-05f, -9.693210308e-05f, -9.697833575e-05f, 
-9.702123436e-05f, -9.706080208e-05f, -9.709704218e-05f, -9.712995804e-05f, -9.715955315e-05f, -9.718583109e-05f, -9.720879558e-05f, -9.722845042e-05f, -9.724479953e-05f, -9.725784695e-05f, 
-9.726759679e-05f, -9.727405331e-05f, -9.727722085e-05f, -9.727710385e-05f, -9.727370688e-05f, -9.726703460e-05f, -9.725709177e-05f, -9.724388328e-05f, -9.722741409e-05f, -9.720768929e-05f, 
-9.718471406e-05f, -9.715849370e-05f, -9.712903359e-05f, -9.709633923e-05f, -9.706041621e-05f, -9.702127024e-05f, -9.697890712e-05f, -9.693333275e-05f, -9.688455313e-05f, -9.683257438e-05f, 
-9.677740269e-05f, -9.671904437e-05f, -9.665750583e-05f, -9.659279357e-05f, -9.652491419e-05f, -9.645387441e-05f, -9.637968102e-05f, -9.630234092e-05f, -9.622186110e-05f, -9.613824867e-05f, 
-9.605151081e-05f, -9.596165481e-05f, -9.586868805e-05f, -9.577261802e-05f, -9.567345228e-05f, -9.557119851e-05f, -9.546586448e-05f, -9.535745803e-05f, -9.524598713e-05f, -9.513145981e-05f, 
-9.501388423e-05f, -9.489326860e-05f, -9.476962125e-05f, -9.464295060e-05f, -9.451326515e-05f, -9.438057350e-05f, -9.424488433e-05f, -9.410620643e-05f, -9.396454867e-05f, -9.381991999e-05f, 
-9.367232945e-05f, -9.352178617e-05f, -9.336829939e-05f, -9.321187840e-05f, -9.305253261e-05f, -9.289027149e-05f, -9.272510462e-05f, -9.255704166e-05f, -9.238609233e-05f, -9.221226646e-05f, 
-9.203557397e-05f, -9.185602485e-05f, -9.167362917e-05f, -9.148839709e-05f, -9.130033886e-05f, -9.110946479e-05f, -9.091578530e-05f, -9.071931086e-05f, -9.052005205e-05f, -9.031801952e-05f, 
-9.011322398e-05f, -8.990567625e-05f, -8.969538721e-05f, -8.948236783e-05f, -8.926662914e-05f, -8.904818226e-05f, -8.882703840e-05f, -8.860320881e-05f, -8.837670485e-05f, -8.814753794e-05f, 
-8.791571957e-05f, -8.768126132e-05f, -8.744417483e-05f, -8.720447183e-05f, -8.696216409e-05f, -8.671726350e-05f, -8.646978197e-05f, -8.621973153e-05f, -8.596712424e-05f, -8.571197225e-05f, 
-8.545428779e-05f, -8.519408314e-05f, -8.493137065e-05f, -8.466616275e-05f, -8.439847193e-05f, -8.412831074e-05f, -8.385569183e-05f, -8.358062786e-05f, -8.330313162e-05f, -8.302321590e-05f, 
-8.274089361e-05f, -8.245617769e-05f, -8.216908115e-05f, -8.187961708e-05f, -8.158779862e-05f, -8.129363895e-05f, -8.099715136e-05f, -8.069834915e-05f, -8.039724572e-05f, -8.009385451e-05f, 
-7.978818902e-05f, -7.948026281e-05f, -7.917008950e-05f, -7.885768277e-05f, -7.854305635e-05f, -7.822622403e-05f, -7.790719966e-05f, -7.758599714e-05f, -7.726263043e-05f, -7.693711353e-05f, 
-7.660946052e-05f, -7.627968550e-05f, -7.594780265e-05f, -7.561382618e-05f, -7.527777038e-05f, -7.493964957e-05f, -7.459947812e-05f, -7.425727045e-05f, -7.391304104e-05f, -7.356680441e-05f, 
-7.321857513e-05f, -7.286836781e-05f, -7.251619713e-05f, -7.216207779e-05f, -7.180602455e-05f, -7.144805221e-05f, -7.108817562e-05f, -7.072640966e-05f, -7.036276928e-05f, -6.999726944e-05f, 
-6.962992517e-05f, -6.926075153e-05f, -6.888976362e-05f, -6.851697658e-05f, -6.814240560e-05f, -6.776606589e-05f, -6.738797273e-05f, -6.700814140e-05f, -6.662658725e-05f, -6.624332565e-05f, 
-6.585837202e-05f, -6.547174179e-05f, -6.508345045e-05f, -6.469351352e-05f, -6.430194656e-05f, -6.390876514e-05f, -6.351398488e-05f, -6.311762144e-05f, -6.271969049e-05f, -6.232020776e-05f, 
-6.191918899e-05f, -6.151664995e-05f, -6.111260644e-05f, -6.070707431e-05f, -6.030006941e-05f, -5.989160764e-05f, -5.948170491e-05f, -5.907037716e-05f, -5.865764037e-05f, -5.824351053e-05f, 
-5.782800366e-05f, -5.741113582e-05f, -5.699292306e-05f, -5.657338147e-05f, -5.615252718e-05f, -5.573037633e-05f, -5.530694506e-05f, -5.488224956e-05f, -5.445630602e-05f, -5.402913068e-05f, 
-5.360073975e-05f, -5.317114951e-05f, -5.274037623e-05f, -5.230843619e-05f, -5.187534571e-05f, -5.144112111e-05f, -5.100577873e-05f, -5.056933493e-05f, -5.013180608e-05f, -4.969320856e-05f, 
-4.925355877e-05f, -4.881287312e-05f, -4.837116802e-05f, -4.792845993e-05f, -4.748476527e-05f, -4.704010051e-05f, -4.659448210e-05f, -4.614792653e-05f, -4.570045028e-05f, -4.525206983e-05f, 
-4.480280168e-05f, -4.435266235e-05f, -4.390166833e-05f, -4.344983616e-05f, -4.299718234e-05f, -4.254372342e-05f, -4.208947591e-05f, -4.163445636e-05f, -4.117868129e-05f, -4.072216726e-05f, 
-4.026493080e-05f, -3.980698846e-05f, -3.934835678e-05f, -3.888905230e-05f, -3.842909156e-05f, -3.796849112e-05f, -3.750726750e-05f, -3.704543724e-05f, -3.658301689e-05f, -3.612002297e-05f, 
-3.565647202e-05f, -3.519238054e-05f, -3.472776508e-05f, -3.426264213e-05f, -3.379702820e-05f, -3.333093980e-05f, -3.286439341e-05f, -3.239740553e-05f, -3.192999262e-05f, -3.146217117e-05f, 
-3.099395762e-05f, -3.052536842e-05f, -3.005642002e-05f, -2.958712883e-05f, -2.911751128e-05f, -2.864758377e-05f, -2.817736268e-05f, -2.770686440e-05f, -2.723610529e-05f, -2.676510169e-05f, 
-2.629386994e-05f, -2.582242636e-05f, -2.535078725e-05f, -2.487896890e-05f, -2.440698757e-05f, -2.393485952e-05f, -2.346260098e-05f, -2.299022816e-05f, -2.251775726e-05f, -2.204520446e-05f, 
-2.157258591e-05f, -2.109991774e-05f, -2.062721606e-05f, -2.015449698e-05f, -1.968177656e-05f, -1.920907084e-05f, -1.873639584e-05f, -1.826376757e-05f, -1.779120201e-05f, -1.731871509e-05f, 
-1.684632274e-05f, -1.637404087e-05f, -1.590188534e-05f, -1.542987200e-05f, -1.495801667e-05f, -1.448633513e-05f, -1.401484315e-05f, -1.354355646e-05f, -1.307249076e-05f, -1.260166172e-05f, 
-1.213108499e-05f, -1.166077617e-05f, -1.119075085e-05f, -1.072102457e-05f, -1.025161286e-05f, -9.782531181e-06f, -9.313794997e-06f, -8.845419719e-06f, -8.377420727e-06f, -7.909813368e-06f, 
-7.442612953e-06f, -6.975834756e-06f, -6.509494016e-06f, -6.043605935e-06f, -5.578185677e-06f, -5.113248371e-06f, -4.648809104e-06f, -4.184882927e-06f, -3.721484851e-06f, -3.258629848e-06f, 
-2.796332850e-06f, -2.334608748e-06f, -1.873472394e-06f, -1.412938595e-06f, -9.530221191e-07f, -4.937376920e-07f, -3.509999594e-08f, 4.228763297e-07f, 8.801766891e-07f, 1.336786530e-06f, 
1.792691346e-06f, 2.247876674e-06f, 2.702328096e-06f, 3.156031242e-06f, 3.608971785e-06f, 4.061135447e-06f, 4.512507996e-06f, 4.963075248e-06f, 5.412823067e-06f, 5.861737363e-06f, 
6.309804097e-06f, 6.757009280e-06f, 7.203338969e-06f, 7.648779274e-06f, 8.093316354e-06f, 8.536936418e-06f, 8.979625728e-06f, 9.421370597e-06f, 9.862157388e-06f, 1.030197252e-05f, 
1.074080246e-05f, 1.117863373e-05f, 1.161545291e-05f, 1.205124662e-05f, 1.248600156e-05f, 1.291970446e-05f, 1.335234211e-05f, 1.378390136e-05f, 1.421436912e-05f, 1.464373235e-05f, 
1.507197806e-05f, 1.549909334e-05f, 1.592506530e-05f, 1.634988115e-05f, 1.677352812e-05f, 1.719599352e-05f, 1.761726472e-05f, 1.803732914e-05f, 1.845617426e-05f, 1.887378762e-05f, 
1.929015683e-05f, 1.970526954e-05f, 2.011911348e-05f, 2.053167643e-05f, 2.094294624e-05f, 2.135291081e-05f, 2.176155812e-05f, 2.216887619e-05f, 2.257485312e-05f, 2.297947706e-05f, 
2.338273624e-05f, 2.378461894e-05f, 2.418511350e-05f, 2.458420834e-05f, 2.498189194e-05f, 2.537815283e-05f, 2.577297962e-05f, 2.616636098e-05f, 2.655828566e-05f, 2.694874245e-05f, 
2.733772022e-05f, 2.772520791e-05f, 2.811119453e-05f, 2.849566913e-05f, 2.887862087e-05f, 2.926003895e-05f, 2.963991263e-05f, 3.001823127e-05f, 3.039498427e-05f, 3.077016110e-05f, 
3.114375133e-05f, 3.151574456e-05f, 3.188613049e-05f, 3.225489887e-05f, 3.262203952e-05f, 3.298754234e-05f, 3.335139731e-05f, 3.371359445e-05f, 3.407412389e-05f, 3.443297579e-05f, 
3.479014042e-05f, 3.514560809e-05f, 3.549936921e-05f, 3.585141423e-05f, 3.620173371e-05f, 3.655031825e-05f, 3.689715854e-05f, 3.724224534e-05f, 3.758556949e-05f, 3.792712188e-05f, 
3.826689350e-05f, 3.860487540e-05f, 3.894105871e-05f, 3.927543463e-05f, 3.960799444e-05f, 3.993872949e-05f, 4.026763121e-05f, 4.059469109e-05f, 4.091990072e-05f, 4.124325174e-05f, 
4.156473588e-05f, 4.188434495e-05f, 4.220207082e-05f, 4.251790546e-05f, 4.283184088e-05f, 4.314386921e-05f, 4.345398262e-05f, 4.376217338e-05f, 4.406843382e-05f, 4.437275637e-05f, 
4.467513350e-05f, 4.497555780e-05f, 4.527402192e-05f, 4.557051856e-05f, 4.586504055e-05f, 4.615758076e-05f, 4.644813215e-05f, 4.673668776e-05f, 4.702324069e-05f, 4.730778416e-05f, 
4.759031142e-05f, 4.787081584e-05f, 4.814929083e-05f, 4.842572992e-05f, 4.870012668e-05f, 4.897247479e-05f, 4.924276799e-05f, 4.951100011e-05f, 4.977716505e-05f, 5.004125680e-05f, 
5.030326941e-05f, 5.056319705e-05f, 5.082103392e-05f, 5.107677433e-05f, 5.133041267e-05f, 5.158194340e-05f, 5.183136106e-05f, 5.207866028e-05f, 5.232383576e-05f, 5.256688228e-05f, 
5.280779472e-05f, 5.304656801e-05f, 5.328319718e-05f, 5.351767733e-05f, 5.375000366e-05f, 5.398017143e-05f, 5.420817599e-05f, 5.443401277e-05f, 5.465767727e-05f, 5.487916509e-05f, 
5.509847190e-05f, 5.531559344e-05f, 5.553052556e-05f, 5.574326417e-05f, 5.595380526e-05f, 5.616214491e-05f, 5.636827927e-05f, 5.657220458e-05f, 5.677391716e-05f, 5.697341341e-05f, 
5.717068981e-05f, 5.736574292e-05f, 5.755856939e-05f, 5.774916593e-05f, 5.793752936e-05f, 5.812365655e-05f, 5.830754449e-05f, 5.848919020e-05f, 5.866859083e-05f, 5.884574357e-05f, 
5.902064573e-05f, 5.919329467e-05f, 5.936368785e-05f, 5.953182280e-05f, 5.969769713e-05f, 5.986130853e-05f, 6.002265479e-05f, 6.018173375e-05f, 6.033854336e-05f, 6.049308163e-05f, 
6.064534667e-05f, 6.079533664e-05f, 6.094304981e-05f, 6.108848451e-05f, 6.123163917e-05f, 6.137251229e-05f, 6.151110244e-05f, 6.164740829e-05f, 6.178142857e-05f, 6.191316211e-05f, 
6.204260781e-05f, 6.216976464e-05f, 6.229463166e-05f, 6.241720802e-05f, 6.253749294e-05f, 6.265548570e-05f, 6.277118570e-05f, 6.288459238e-05f, 6.299570528e-05f, 6.310452402e-05f, 
6.321104830e-05f, 6.331527787e-05f, 6.341721261e-05f, 6.351685243e-05f, 6.361419735e-05f, 6.370924745e-05f, 6.380200291e-05f, 6.389246395e-05f, 6.398063092e-05f, 6.406650420e-05f, 
6.415008428e-05f, 6.423137170e-05f, 6.431036711e-05f, 6.438707122e-05f, 6.446148481e-05f, 6.453360874e-05f, 6.460344397e-05f, 6.467099150e-05f, 6.473625244e-05f, 6.479922795e-05f, 
6.485991930e-05f, 6.491832779e-05f, 6.497445483e-05f, 6.502830190e-05f, 6.507987056e-05f, 6.512916242e-05f, 6.517617920e-05f, 6.522092267e-05f, 6.526339468e-05f, 6.530359718e-05f, 
6.534153215e-05f, 6.537720168e-05f, 6.541060793e-05f, 6.544175311e-05f, 6.547063953e-05f, 6.549726957e-05f, 6.552164567e-05f, 6.554377036e-05f, 6.556364623e-05f, 6.558127595e-05f, 
6.559666225e-05f, 6.560980797e-05f, 6.562071597e-05f, 6.562938923e-05f, 6.563583076e-05f, 6.564004368e-05f, 6.564203115e-05f, 6.564179643e-05f, 6.563934283e-05f, 6.563467373e-05f, 
6.562779260e-05f, 6.561870297e-05f, 6.560740843e-05f, 6.559391265e-05f, 6.557821938e-05f, 6.556033242e-05f, 6.554025564e-05f, 6.551799301e-05f, 6.549354853e-05f, 6.546692628e-05f, 
6.543813043e-05f, 6.540716520e-05f, 6.537403486e-05f, 6.533874379e-05f, 6.530129640e-05f, 6.526169719e-05f, 6.521995071e-05f, 6.517606160e-05f, 6.513003453e-05f, 6.508187428e-05f, 
6.503158567e-05f, 6.497917358e-05f, 6.492464296e-05f, 6.486799885e-05f, 6.480924632e-05f, 6.474839053e-05f, 6.468543668e-05f, 6.462039006e-05f, 6.455325600e-05f, 6.448403992e-05f, 
6.441274727e-05f, 6.433938360e-05f, 6.426395449e-05f, 6.418646561e-05f, 6.410692266e-05f, 6.402533143e-05f, 6.394169776e-05f, 6.385602755e-05f, 6.376832677e-05f, 6.367860143e-05f, 
6.358685764e-05f, 6.349310151e-05f, 6.339733928e-05f, 6.329957718e-05f, 6.319982155e-05f, 6.309807878e-05f, 6.299435529e-05f, 6.288865758e-05f, 6.278099222e-05f, 6.267136582e-05f, 
6.255978504e-05f, 6.244625661e-05f, 6.233078732e-05f, 6.221338400e-05f, 6.209405356e-05f, 6.197280295e-05f, 6.184963916e-05f, 6.172456927e-05f, 6.159760040e-05f, 6.146873970e-05f, 
6.133799441e-05f, 6.120537181e-05f, 6.107087923e-05f, 6.093452406e-05f, 6.079631372e-05f, 6.065625572e-05f, 6.051435759e-05f, 6.037062693e-05f, 6.022507139e-05f, 6.007769866e-05f, 
5.992851649e-05f, 5.977753267e-05f, 5.962475505e-05f, 5.947019154e-05f, 5.931385007e-05f, 5.915573865e-05f, 5.899586531e-05f, 5.883423815e-05f, 5.867086531e-05f, 5.850575497e-05f, 
5.833891538e-05f, 5.817035480e-05f, 5.800008158e-05f, 5.782810409e-05f, 5.765443074e-05f, 5.747907000e-05f, 5.730203038e-05f, 5.712332044e-05f, 5.694294878e-05f, 5.676092403e-05f, 
5.657725490e-05f, 5.639195010e-05f, 5.620501841e-05f, 5.601646865e-05f, 5.582630968e-05f, 5.563455039e-05f, 5.544119972e-05f, 5.524626667e-05f, 5.504976025e-05f, 5.485168952e-05f, 
5.465206359e-05f, 5.445089160e-05f, 5.424818274e-05f, 5.404394622e-05f, 5.383819130e-05f, 5.363092728e-05f, 5.342216350e-05f, 5.321190932e-05f, 5.300017416e-05f, 5.278696746e-05f, 
5.257229871e-05f, 5.235617742e-05f, 5.213861315e-05f, 5.191961548e-05f, 5.169919403e-05f, 5.147735847e-05f, 5.125411848e-05f, 5.102948379e-05f, 5.080346415e-05f, 5.057606936e-05f, 
5.034730924e-05f, 5.011719364e-05f, 4.988573246e-05f, 4.965293559e-05f, 4.941881301e-05f, 4.918337467e-05f, 4.894663060e-05f, 4.870859082e-05f, 4.846926541e-05f, 4.822866447e-05f, 
4.798679811e-05f, 4.774367649e-05f, 4.749930979e-05f, 4.725370822e-05f, 4.700688201e-05f, 4.675884142e-05f, 4.650959675e-05f, 4.625915829e-05f, 4.600753640e-05f, 4.575474143e-05f, 
4.550078377e-05f, 4.524567383e-05f, 4.498942205e-05f, 4.473203888e-05f, 4.447353482e-05f, 4.421392035e-05f, 4.395320601e-05f, 4.369140235e-05f, 4.342851994e-05f, 4.316456936e-05f, 
4.289956122e-05f, 4.263350617e-05f, 4.236641484e-05f, 4.209829791e-05f, 4.182916606e-05f, 4.155903001e-05f, 4.128790049e-05f, 4.101578822e-05f, 4.074270399e-05f, 4.046865855e-05f, 
4.019366272e-05f, 3.991772729e-05f, 3.964086310e-05f, 3.936308099e-05f, 3.908439181e-05f, 3.880480644e-05f, 3.852433576e-05f, 3.824299067e-05f, 3.796078209e-05f, 3.767772094e-05f, 
3.739381816e-05f, 3.710908470e-05f, 3.682353153e-05f, 3.653716961e-05f, 3.625000994e-05f, 3.596206350e-05f, 3.567334131e-05f, 3.538385439e-05f, 3.509361375e-05f, 3.480263043e-05f, 
3.451091548e-05f, 3.421847995e-05f, 3.392533489e-05f, 3.363149137e-05f, 3.333696047e-05f, 3.304175328e-05f, 3.274588086e-05f, 3.244935433e-05f, 3.215218477e-05f, 3.185438329e-05f, 
3.155596100e-05f, 3.125692902e-05f, 3.095729845e-05f, 3.065708042e-05f, 3.035628606e-05f, 3.005492648e-05f, 2.975301283e-05f, 2.945055622e-05f, 2.914756779e-05f, 2.884405868e-05f, 
2.854004003e-05f, 2.823552295e-05f, 2.793051860e-05f, 2.762503810e-05f, 2.731909260e-05f, 2.701269322e-05f, 2.670585109e-05f, 2.639857735e-05f, 2.609088312e-05f, 2.578277954e-05f, 
2.547427771e-05f, 2.516538877e-05f, 2.485612382e-05f, 2.454649397e-05f, 2.423651035e-05f, 2.392618404e-05f, 2.361552614e-05f, 2.330454774e-05f, 2.299325994e-05f, 2.268167380e-05f, 
2.236980041e-05f, 2.205765082e-05f, 2.174523609e-05f, 2.143256728e-05f, 2.111965543e-05f, 2.080651156e-05f, 2.049314670e-05f, 2.017957188e-05f, 1.986579808e-05f, 1.955183632e-05f, 
1.923769756e-05f, 1.892339280e-05f, 1.860893298e-05f, 1.829432907e-05f, 1.797959200e-05f, 1.766473270e-05f, 1.734976209e-05f, 1.703469106e-05f, 1.671953051e-05f, 1.640429131e-05f, 
1.608898432e-05f, 1.577362039e-05f, 1.545821035e-05f, 1.514276502e-05f, 1.482729521e-05f, 1.451181169e-05f, 1.419632524e-05f, 1.388084661e-05f, 1.356538653e-05f, 1.324995574e-05f, 
1.293456493e-05f, 1.261922478e-05f, 1.230394596e-05f, 1.198873913e-05f, 1.167361490e-05f, 1.135858389e-05f, 1.104365669e-05f, 1.072884387e-05f, 1.041415599e-05f, 1.009960356e-05f, 
9.785197105e-06f, 9.470947108e-06f, 9.156864036e-06f, 8.842958334e-06f, 8.529240424e-06f, 8.215720707e-06f, 7.902409561e-06f, 7.589317339e-06f, 7.276454373e-06f, 6.963830969e-06f, 
6.651457411e-06f, 6.339343958e-06f, 6.027500843e-06f, 5.715938275e-06f, 5.404666439e-06f, 5.093695491e-06f, 4.783035564e-06f, 4.472696764e-06f, 4.162689169e-06f, 3.853022833e-06f, 
3.543707780e-06f, 3.234754007e-06f, 2.926171485e-06f, 2.617970156e-06f, 2.310159931e-06f, 2.002750697e-06f, 1.695752309e-06f, 1.389174592e-06f, 1.083027344e-06f, 7.773203319e-07f, 
4.720632918e-07f, 1.672659301e-07f, -1.370620777e-07f, -4.409110872e-07f, -7.442714852e-07f, -1.047133690e-06f, -1.349488153e-06f, -1.651325355e-06f, -1.952635812e-06f, -2.253410072e-06f, 
-2.553638715e-06f, -2.853312356e-06f, -3.152421641e-06f, -3.450957252e-06f, -3.748909905e-06f, -4.046270349e-06f, -4.343029369e-06f, -4.639177783e-06f, -4.934706447e-06f, -5.229606250e-06f, 
-5.523868118e-06f, -5.817483011e-06f, -6.110441929e-06f, -6.402735904e-06f, -6.694356007e-06f, -6.985293346e-06f, -7.275539067e-06f, -7.565084350e-06f, -7.853920417e-06f, -8.142038525e-06f, 
-8.429429970e-06f, -8.716086087e-06f, -9.001998249e-06f, -9.287157869e-06f, -9.571556396e-06f, -9.855185322e-06f, -1.013803618e-05f, -1.042010053e-05f, -1.070137000e-05f, -1.098183622e-05f, 
-1.126149089e-05f, -1.154032575e-05f, -1.181833256e-05f, -1.209550314e-05f, -1.237182934e-05f, -1.264730306e-05f, -1.292191625e-05f, -1.319566087e-05f, -1.346852895e-05f, -1.374051257e-05f, 
-1.401160382e-05f, -1.428179485e-05f, -1.455107787e-05f, -1.481944511e-05f, -1.508688884e-05f, -1.535340140e-05f, -1.561897516e-05f, -1.588360251e-05f, -1.614727593e-05f, -1.640998792e-05f, 
-1.667173101e-05f, -1.693249780e-05f, -1.719228093e-05f, -1.745107308e-05f, -1.770886696e-05f, -1.796565537e-05f, -1.822143111e-05f, -1.847618704e-05f, -1.872991608e-05f, -1.898261119e-05f, 
-1.923426536e-05f, -1.948487165e-05f, -1.973442315e-05f, -1.998291300e-05f, -2.023033440e-05f, -2.047668057e-05f, -2.072194482e-05f, -2.096612047e-05f, -2.120920089e-05f, -2.145117953e-05f, 
-2.169204984e-05f, -2.193180537e-05f, -2.217043968e-05f, -2.240794639e-05f, -2.264431918e-05f, -2.287955176e-05f, -2.311363789e-05f, -2.334657141e-05f, -2.357834617e-05f, -2.380895609e-05f, 
-2.403839513e-05f, -2.426665731e-05f, -2.449373669e-05f, -2.471962739e-05f, -2.494432358e-05f, -2.516781946e-05f, -2.539010930e-05f, -2.561118741e-05f, -2.583104817e-05f, -2.604968598e-05f, 
-2.626709532e-05f, -2.648327071e-05f, -2.669820670e-05f, -2.691189793e-05f, -2.712433905e-05f, -2.733552481e-05f, -2.754544996e-05f, -2.775410933e-05f, -2.796149780e-05f, -2.816761030e-05f, 
-2.837244181e-05f, -2.857598736e-05f, -2.877824203e-05f, -2.897920096e-05f, -2.917885934e-05f, -2.937721240e-05f, -2.957425545e-05f, -2.976998382e-05f, -2.996439291e-05f, -3.015747818e-05f, 
-3.034923512e-05f, -3.053965929e-05f, -3.072874630e-05f, -3.091649181e-05f, -3.110289153e-05f, -3.128794123e-05f, -3.147163673e-05f, -3.165397389e-05f, -3.183494866e-05f, -3.201455700e-05f, 
-3.219279494e-05f, -3.236965858e-05f, -3.254514406e-05f, -3.271924755e-05f, -3.289196532e-05f, -3.306329365e-05f, -3.323322891e-05f, -3.340176750e-05f, -3.356890587e-05f, -3.373464055e-05f, 
-3.389896810e-05f, -3.406188513e-05f, -3.422338833e-05f, -3.438347443e-05f, -3.454214020e-05f, -3.469938248e-05f, -3.485519817e-05f, -3.500958420e-05f, -3.516253758e-05f, -3.531405536e-05f, 
-3.546413464e-05f, -3.561277258e-05f, -3.575996640e-05f, -3.590571336e-05f, -3.605001079e-05f, -3.619285606e-05f, -3.633424660e-05f, -3.647417990e-05f, -3.661265350e-05f, -3.674966498e-05f, 
-3.688521199e-05f, -3.701929224e-05f, -3.715190347e-05f, -3.728304350e-05f, -3.741271019e-05f, -3.754090145e-05f, -3.766761525e-05f, -3.779284962e-05f, -3.791660264e-05f, -3.803887243e-05f, 
-3.815965719e-05f, -3.827895515e-05f, -3.839676461e-05f, -3.851308392e-05f, -3.862791147e-05f, -3.874124572e-05f, -3.885308518e-05f, -3.896342841e-05f, -3.907227404e-05f, -3.917962072e-05f, 
-3.928546718e-05f, -3.938981221e-05f, -3.949265462e-05f, -3.959399331e-05f, -3.969382722e-05f, -3.979215532e-05f, -3.988897667e-05f, -3.998429037e-05f, -4.007809557e-05f, -4.017039146e-05f, 
-4.026117731e-05f, -4.035045243e-05f, -4.043821618e-05f, -4.052446798e-05f, -4.060920729e-05f, -4.069243364e-05f, -4.077414660e-05f, -4.085434581e-05f, -4.093303093e-05f, -4.101020171e-05f, 
-4.108585792e-05f, -4.115999941e-05f, -4.123262607e-05f, -4.130373783e-05f, -4.137333469e-05f, -4.144141670e-05f, -4.150798395e-05f, -4.157303660e-05f, -4.163657485e-05f, -4.169859895e-05f, 
-4.175910920e-05f, -4.181810597e-05f, -4.187558966e-05f, -4.193156073e-05f, -4.198601970e-05f, -4.203896712e-05f, -4.209040360e-05f, -4.214032982e-05f, -4.218874648e-05f, -4.223565436e-05f, 
-4.228105426e-05f, -4.232494707e-05f, -4.236733368e-05f, -4.240821508e-05f, -4.244759227e-05f, -4.248546633e-05f, -4.252183838e-05f, -4.255670958e-05f, -4.259008114e-05f, -4.262195435e-05f, 
-4.265233051e-05f, -4.268121099e-05f, -4.270859721e-05f, -4.273449062e-05f, -4.275889275e-05f, -4.278180515e-05f, -4.280322944e-05f, -4.282316728e-05f, -4.284162037e-05f, -4.285859047e-05f, 
-4.287407938e-05f, -4.288808897e-05f, -4.290062112e-05f, -4.291167778e-05f, -4.292126096e-05f, -4.292937270e-05f, -4.293601508e-05f, -4.294119024e-05f, -4.294490037e-05f, -4.294714771e-05f, 
-4.294793452e-05f, -4.294726314e-05f, -4.294513593e-05f, -4.294155532e-05f, -4.293652376e-05f, -4.293004378e-05f, -4.292211791e-05f, -4.291274877e-05f, -4.290193900e-05f, -4.288969130e-05f, 
-4.287600839e-05f, -4.286089307e-05f, -4.284434816e-05f, -4.282637652e-05f, -4.280698109e-05f, -4.278616481e-05f, -4.276393070e-05f, -4.274028180e-05f, -4.271522120e-05f, -4.268875204e-05f, 
-4.266087749e-05f, -4.263160079e-05f, -4.260092519e-05f, -4.256885401e-05f, -4.253539059e-05f, -4.250053834e-05f, -4.246430067e-05f, -4.242668108e-05f, -4.238768309e-05f, -4.234731025e-05f, 
-4.230556617e-05f, -4.226245449e-05f, -4.221797890e-05f, -4.217214312e-05f, -4.212495093e-05f, -4.207640613e-05f, -4.202651258e-05f, -4.197527415e-05f, -4.192269478e-05f, -4.186877844e-05f, 
-4.181352913e-05f, -4.175695091e-05f, -4.169904786e-05f, -4.163982410e-05f, -4.157928381e-05f, -4.151743118e-05f, -4.145427045e-05f, -4.138980592e-05f, -4.132404188e-05f, -4.125698271e-05f, 
-4.118863279e-05f, -4.111899656e-05f, -4.104807847e-05f, -4.097588304e-05f, -4.090241481e-05f, -4.082767835e-05f, -4.075167828e-05f, -4.067441925e-05f, -4.059590595e-05f, -4.051614308e-05f, 
-4.043513543e-05f, -4.035288776e-05f, -4.026940492e-05f, -4.018469176e-05f, -4.009875318e-05f, -4.001159411e-05f, -3.992321951e-05f, -3.983363438e-05f, -3.974284376e-05f, -3.965085270e-05f, 
-3.955766631e-05f, -3.946328972e-05f, -3.936772810e-05f, -3.927098662e-05f, -3.917307054e-05f, -3.907398510e-05f, -3.897373560e-05f, -3.887232737e-05f, -3.876976575e-05f, -3.866605613e-05f, 
-3.856120393e-05f, -3.845521460e-05f, -3.834809362e-05f, -3.823984649e-05f, -3.813047874e-05f, -3.801999596e-05f, -3.790840372e-05f, -3.779570767e-05f, -3.768191345e-05f, -3.756702674e-05f, 
-3.745105327e-05f, -3.733399876e-05f, -3.721586899e-05f, -3.709666974e-05f, -3.697640685e-05f, -3.685508616e-05f, -3.673271355e-05f, -3.660929493e-05f, -3.648483621e-05f, -3.635934337e-05f, 
-3.623282237e-05f, -3.610527923e-05f, -3.597671998e-05f, -3.584715068e-05f, -3.571657742e-05f, -3.558500629e-05f, -3.545244343e-05f, -3.531889501e-05f, -3.518436719e-05f, -3.504886618e-05f, 
-3.491239822e-05f, -3.477496954e-05f, -3.463658643e-05f, -3.449725518e-05f, -3.435698210e-05f, -3.421577355e-05f, -3.407363588e-05f, -3.393057547e-05f, -3.378659874e-05f, -3.364171210e-05f, 
-3.349592201e-05f, -3.334923493e-05f, -3.320165736e-05f, -3.305319580e-05f, -3.290385677e-05f, -3.275364683e-05f, -3.260257255e-05f, -3.245064051e-05f, -3.229785731e-05f, -3.214422959e-05f, 
-3.198976397e-05f, -3.183446713e-05f, -3.167834573e-05f, -3.152140649e-05f, -3.136365609e-05f, -3.120510129e-05f, -3.104574882e-05f, -3.088560544e-05f, -3.072467794e-05f, -3.056297310e-05f, 
-3.040049775e-05f, -3.023725870e-05f, -3.007326279e-05f, -2.990851689e-05f, -2.974302786e-05f, -2.957680259e-05f, -2.940984797e-05f, -2.924217092e-05f, -2.907377837e-05f, -2.890467725e-05f, 
-2.873487452e-05f, -2.856437714e-05f, -2.839319209e-05f, -2.822132637e-05f, -2.804878697e-05f, -2.787558090e-05f, -2.770171520e-05f, -2.752719690e-05f, -2.735203304e-05f, -2.717623069e-05f, 
-2.699979692e-05f, -2.682273880e-05f, -2.664506342e-05f, -2.646677788e-05f, -2.628788929e-05f, -2.610840477e-05f, -2.592833143e-05f, -2.574767643e-05f, -2.556644689e-05f, -2.538464997e-05f, 
-2.520229282e-05f, -2.501938263e-05f, -2.483592655e-05f, -2.465193176e-05f, -2.446740547e-05f, -2.428235485e-05f, -2.409678711e-05f, -2.391070945e-05f, -2.372412909e-05f, -2.353705325e-05f, 
-2.334948914e-05f, -2.316144399e-05f, -2.297292504e-05f, -2.278393953e-05f, -2.259449468e-05f, -2.240459775e-05f, -2.221425599e-05f, -2.202347664e-05f, -2.183226696e-05f, -2.164063422e-05f, 
-2.144858566e-05f, -2.125612855e-05f, -2.106327017e-05f, -2.087001776e-05f, -2.067637860e-05f, -2.048235997e-05f, -2.028796913e-05f, -2.009321335e-05f, -1.989809990e-05f, -1.970263606e-05f, 
-1.950682910e-05f, -1.931068630e-05f, -1.911421492e-05f, -1.891742223e-05f, -1.872031550e-05f, -1.852290202e-05f, -1.832518903e-05f, -1.812718381e-05f, -1.792889362e-05f, -1.773032573e-05f, 
-1.753148739e-05f, -1.733238586e-05f, -1.713302839e-05f, -1.693342224e-05f, -1.673357465e-05f, -1.653349287e-05f, -1.633318413e-05f, -1.613265567e-05f, -1.593191472e-05f, -1.573096851e-05f, 
-1.552982426e-05f, -1.532848918e-05f, -1.512697050e-05f, -1.492527540e-05f, -1.472341110e-05f, -1.452138478e-05f, -1.431920364e-05f, -1.411687485e-05f, -1.391440559e-05f, -1.371180303e-05f, 
-1.350907431e-05f, -1.330622661e-05f, -1.310326705e-05f, -1.290020279e-05f, -1.269704093e-05f, -1.249378861e-05f, -1.229045294e-05f, -1.208704101e-05f, -1.188355992e-05f, -1.168001676e-05f, 
-1.147641859e-05f, -1.127277249e-05f, -1.106908549e-05f, -1.086536466e-05f, -1.066161702e-05f, -1.045784959e-05f, -1.025406939e-05f, -1.005028341e-05f, -9.846498650e-06f, -9.642722076e-06f, 
-9.438960659e-06f, -9.235221350e-06f, -9.031511091e-06f, -8.827836809e-06f, -8.624205419e-06f, -8.420623825e-06f, -8.217098915e-06f, -8.013637564e-06f, -7.810246635e-06f, -7.606932977e-06f, 
-7.403703422e-06f, -7.200564792e-06f, -6.997523891e-06f, -6.794587509e-06f, -6.591762424e-06f, -6.389055395e-06f, -6.186473167e-06f, -5.984022470e-06f, -5.781710018e-06f, -5.579542509e-06f, 
-5.377526625e-06f, -5.175669031e-06f, -4.973976375e-06f, -4.772455291e-06f, -4.571112392e-06f, -4.369954277e-06f, -4.168987527e-06f, -3.968218703e-06f, -3.767654351e-06f, -3.567300998e-06f, 
-3.367165153e-06f, -3.167253306e-06f, -2.967571930e-06f, -2.768127476e-06f, -2.568926381e-06f, -2.369975058e-06f, -2.171279903e-06f, -1.972847292e-06f, -1.774683582e-06f, -1.576795109e-06f, 
-1.379188190e-06f, -1.181869120e-06f, -9.848441754e-07f, -7.881196107e-07f, -5.917016601e-07f, -3.955965368e-07f, -1.998104325e-07f, -4.349517704e-09f, 1.907800586e-07f, 3.855721694e-07f, 
5.800207093e-07f, 7.741195952e-07f, 9.678627663e-07f, 1.161244184e-06f, 1.354257833e-06f, 1.546897719e-06f, 1.739157874e-06f, 1.931032349e-06f, 2.122515221e-06f, 2.313600591e-06f, 
2.504282581e-06f, 2.694555339e-06f, 2.884413036e-06f, 3.073849867e-06f, 3.262860051e-06f, 3.451437834e-06f, 3.639577484e-06f, 3.827273293e-06f, 4.014519581e-06f, 4.201310691e-06f, 
4.387640991e-06f, 4.573504875e-06f, 4.758896764e-06f, 4.943811101e-06f, 5.128242359e-06f, 5.312185035e-06f, 5.495633651e-06f, 5.678582757e-06f, 5.861026929e-06f, 6.042960770e-06f, 
6.224378908e-06f, 6.405276000e-06f, 6.585646729e-06f, 6.765485805e-06f, 6.944787965e-06f, 7.123547975e-06f, 7.301760627e-06f, 7.479420740e-06f, 7.656523163e-06f, 7.833062773e-06f, 
8.009034471e-06f, 8.184433192e-06f, 8.359253896e-06f, 8.533491571e-06f, 8.707141235e-06f, 8.880197934e-06f, 9.052656744e-06f, 9.224512769e-06f, 9.395761142e-06f, 9.566397025e-06f, 
9.736415611e-06f, 9.905812120e-06f, 1.007458180e-05f, 1.024271994e-05f, 1.041022184e-05f, 1.057708285e-05f, 1.074329834e-05f, 1.090886370e-05f, 1.107377436e-05f, 1.123802580e-05f, 
1.140161349e-05f, 1.156453296e-05f, 1.172677977e-05f, 1.188834949e-05f, 1.204923775e-05f, 1.220944018e-05f, 1.236895246e-05f, 1.252777031e-05f, 1.268588945e-05f, 1.284330566e-05f, 
1.300001474e-05f, 1.315601253e-05f, 1.331129489e-05f, 1.346585771e-05f, 1.361969692e-05f, 1.377280849e-05f, 1.392518840e-05f, 1.407683269e-05f, 1.422773740e-05f, 1.437789863e-05f, 
1.452731249e-05f, 1.467597515e-05f, 1.482388278e-05f, 1.497103161e-05f, 1.511741788e-05f, 1.526303789e-05f, 1.540788794e-05f, 1.555196439e-05f, 1.569526361e-05f, 1.583778204e-05f, 
1.597951610e-05f, 1.612046229e-05f, 1.626061713e-05f, 1.639997715e-05f, 1.653853894e-05f, 1.667629912e-05f, 1.681325433e-05f, 1.694940126e-05f, 1.708473663e-05f, 1.721925717e-05f, 
1.735295968e-05f, 1.748584097e-05f, 1.761789789e-05f, 1.774912733e-05f, 1.787952621e-05f, 1.800909147e-05f, 1.813782011e-05f, 1.826570914e-05f, 1.839275562e-05f, 1.851895663e-05f, 
1.864430931e-05f, 1.876881081e-05f, 1.889245832e-05f, 1.901524906e-05f, 1.913718029e-05f, 1.925824932e-05f, 1.937845347e-05f, 1.949779010e-05f, 1.961625660e-05f, 1.973385043e-05f, 
1.985056903e-05f, 1.996640991e-05f, 2.008137061e-05f, 2.019544870e-05f, 2.030864179e-05f, 2.042094751e-05f, 2.053236353e-05f, 2.064288758e-05f, 2.075251740e-05f, 2.086125075e-05f, 
2.096908546e-05f, 2.107601938e-05f, 2.118205040e-05f, 2.128717641e-05f, 2.139139540e-05f, 2.149470533e-05f, 2.159710424e-05f, 2.169859018e-05f, 2.179916124e-05f, 2.189881556e-05f, 
2.199755130e-05f, 2.209536665e-05f, 2.219225984e-05f, 2.228822916e-05f, 2.238327288e-05f, 2.247738937e-05f, 2.257057698e-05f, 2.266283413e-05f, 2.275415925e-05f, 2.284455083e-05f, 
2.293400738e-05f, 2.302252744e-05f, 2.311010959e-05f, 2.319675246e-05f, 2.328245470e-05f, 2.336721498e-05f, 2.345103204e-05f, 2.353390463e-05f, 2.361583154e-05f, 2.369681159e-05f, 
2.377684365e-05f, 2.385592661e-05f, 2.393405941e-05f, 2.401124100e-05f, 2.408747039e-05f, 2.416274661e-05f, 2.423706873e-05f, 2.431043585e-05f, 2.438284712e-05f, 2.445430170e-05f, 
2.452479881e-05f, 2.459433767e-05f, 2.466291758e-05f, 2.473053784e-05f, 2.479719779e-05f, 2.486289682e-05f, 2.492763434e-05f, 2.499140980e-05f, 2.505422267e-05f, 2.511607248e-05f, 
2.517695878e-05f, 2.523688114e-05f, 2.529583920e-05f, 2.535383260e-05f, 2.541086103e-05f, 2.546692421e-05f, 2.552202190e-05f, 2.557615388e-05f, 2.562931998e-05f, 2.568152005e-05f, 
2.573275398e-05f, 2.578302170e-05f, 2.583232316e-05f, 2.588065835e-05f, 2.592802730e-05f, 2.597443007e-05f, 2.601986674e-05f, 2.606433745e-05f, 2.610784234e-05f, 2.615038160e-05f, 
2.619195547e-05f, 2.623256420e-05f, 2.627220807e-05f, 2.631088741e-05f, 2.634860258e-05f, 2.638535396e-05f, 2.642114198e-05f, 2.645596708e-05f, 2.648982976e-05f, 2.652273053e-05f, 
2.655466994e-05f, 2.658564858e-05f, 2.661566706e-05f, 2.664472603e-05f, 2.667282617e-05f, 2.669996819e-05f, 2.672615283e-05f, 2.675138087e-05f, 2.677565312e-05f, 2.679897042e-05f, 
2.682133363e-05f, 2.684274367e-05f, 2.686320146e-05f, 2.688270796e-05f, 2.690126418e-05f, 2.691887114e-05f, 2.693552990e-05f, 2.695124156e-05f, 2.696600722e-05f, 2.697982804e-05f, 
2.699270521e-05f, 2.700463994e-05f, 2.701563346e-05f, 2.702568706e-05f, 2.703480204e-05f, 2.704297973e-05f, 2.705022149e-05f, 2.705652872e-05f, 2.706190285e-05f, 2.706634533e-05f, 
2.706985764e-05f, 2.707244130e-05f, 2.707409784e-05f, 2.707482885e-05f, 2.707463593e-05f, 2.707352069e-05f, 2.707148482e-05f, 2.706852999e-05f, 2.706465792e-05f, 2.705987036e-05f, 
2.705416908e-05f, 2.704755590e-05f, 2.704003263e-05f, 2.703160115e-05f, 2.702226334e-05f, 2.701202112e-05f, 2.700087643e-05f, 2.698883125e-05f, 2.697588758e-05f, 2.696204745e-05f, 
2.694731291e-05f, 2.693168604e-05f, 2.691516896e-05f, 2.689776381e-05f, 2.687947274e-05f, 2.686029796e-05f, 2.684024167e-05f, 2.681930613e-05f, 2.679749361e-05f, 2.677480640e-05f, 
2.675124683e-05f, 2.672681725e-05f, 2.670152004e-05f, 2.667535760e-05f, 2.664833235e-05f, 2.662044676e-05f, 2.659170330e-05f, 2.656210447e-05f, 2.653165281e-05f, 2.650035087e-05f, 
2.646820124e-05f, 2.643520651e-05f, 2.640136932e-05f, 2.636669232e-05f, 2.633117820e-05f, 2.629482964e-05f, 2.625764939e-05f, 2.621964019e-05f, 2.618080482e-05f, 2.614114608e-05f, 
2.610066678e-05f, 2.605936979e-05f, 2.601725796e-05f, 2.597433419e-05f, 2.593060139e-05f, 2.588606251e-05f, 2.584072050e-05f, 2.579457835e-05f, 2.574763907e-05f, 2.569990568e-05f, 
2.565138124e-05f, 2.560206882e-05f, 2.555197152e-05f, 2.550109245e-05f, 2.544943475e-05f, 2.539700158e-05f, 2.534379612e-05f, 2.528982158e-05f, 2.523508118e-05f, 2.517957816e-05f, 
2.512331578e-05f, 2.506629735e-05f, 2.500852615e-05f, 2.495000552e-05f, 2.489073881e-05f, 2.483072937e-05f, 2.476998060e-05f, 2.470849591e-05f, 2.464627871e-05f, 2.458333246e-05f, 
2.451966061e-05f, 2.445526666e-05f, 2.439015410e-05f, 2.432432645e-05f, 2.425778726e-05f, 2.419054007e-05f, 2.412258848e-05f, 2.405393607e-05f, 2.398458645e-05f, 2.391454325e-05f, 
2.384381013e-05f, 2.377239074e-05f, 2.370028877e-05f, 2.362750792e-05f, 2.355405191e-05f, 2.347992446e-05f, 2.340512934e-05f, 2.332967029e-05f, 2.325355112e-05f, 2.317677562e-05f, 
2.309934760e-05f, 2.302127089e-05f, 2.294254934e-05f, 2.286318682e-05f, 2.278318720e-05f, 2.270255437e-05f, 2.262129225e-05f, 2.253940475e-05f, 2.245689581e-05f, 2.237376939e-05f, 
2.229002946e-05f, 2.220567998e-05f, 2.212072496e-05f, 2.203516841e-05f, 2.194901436e-05f, 2.186226682e-05f, 2.177492987e-05f, 2.168700755e-05f, 2.159850394e-05f, 2.150942315e-05f, 
2.141976925e-05f, 2.132954638e-05f, 2.123875866e-05f, 2.114741022e-05f, 2.105550521e-05f, 2.096304781e-05f, 2.087004219e-05f, 2.077649252e-05f, 2.068240302e-05f, 2.058777788e-05f, 
2.049262134e-05f, 2.039693761e-05f, 2.030073095e-05f, 2.020400560e-05f, 2.010676583e-05f, 2.000901590e-05f, 1.991076012e-05f, 1.981200276e-05f, 1.971274813e-05f, 1.961300054e-05f, 
1.951276432e-05f, 1.941204380e-05f, 1.931084331e-05f, 1.920916721e-05f, 1.910701985e-05f, 1.900440560e-05f, 1.890132883e-05f, 1.879779394e-05f, 1.869380530e-05f, 1.858936732e-05f, 
1.848448441e-05f, 1.837916098e-05f, 1.827340145e-05f, 1.816721025e-05f, 1.806059182e-05f, 1.795355060e-05f, 1.784609105e-05f, 1.773821760e-05f, 1.762993474e-05f, 1.752124693e-05f, 
1.741215864e-05f, 1.730267435e-05f, 1.719279856e-05f, 1.708253574e-05f, 1.697189041e-05f, 1.686086707e-05f, 1.674947022e-05f, 1.663770437e-05f, 1.652557404e-05f, 1.641308376e-05f, 
1.630023805e-05f, 1.618704144e-05f, 1.607349847e-05f, 1.595961367e-05f, 1.584539159e-05f, 1.573083677e-05f, 1.561595377e-05f, 1.550074713e-05f, 1.538522142e-05f, 1.526938118e-05f, 
1.515323098e-05f, 1.503677539e-05f, 1.492001897e-05f, 1.480296629e-05f, 1.468562191e-05f, 1.456799042e-05f, 1.445007639e-05f, 1.433188439e-05f, 1.421341900e-05f, 1.409468480e-05f, 
1.397568636e-05f, 1.385642827e-05f, 1.373691512e-05f, 1.361715147e-05f, 1.349714192e-05f, 1.337689104e-05f, 1.325640342e-05f, 1.313568365e-05f, 1.301473630e-05f, 1.289356595e-05f, 
1.277217720e-05f, 1.265057461e-05f, 1.252876277e-05f, 1.240674626e-05f, 1.228452966e-05f, 1.216211754e-05f, 1.203951448e-05f, 1.191672505e-05f, 1.179375382e-05f, 1.167060537e-05f, 
1.154728426e-05f, 1.142379506e-05f, 1.130014232e-05f, 1.117633062e-05f, 1.105236450e-05f, 1.092824853e-05f, 1.080398726e-05f, 1.067958522e-05f, 1.055504698e-05f, 1.043037707e-05f, 
1.030558003e-05f, 1.018066039e-05f, 1.005562268e-05f, 9.930471440e-06f, 9.805211180e-06f, 9.679846421e-06f, 9.554381675e-06f, 9.428821452e-06f, 9.303170255e-06f, 9.177432582e-06f, 
9.051612928e-06f, 8.925715780e-06f, 8.799745620e-06f, 8.673706927e-06f, 8.547604172e-06f, 8.421441820e-06f, 8.295224330e-06f, 8.168956155e-06f, 8.042641744e-06f, 7.916285536e-06f, 
7.789891964e-06f, 7.663465457e-06f, 7.537010434e-06f, 7.410531309e-06f, 7.284032488e-06f, 7.157518368e-06f, 7.030993342e-06f, 6.904461792e-06f, 6.777928096e-06f, 6.651396619e-06f, 
6.524871724e-06f, 6.398357761e-06f, 6.271859073e-06f, 6.145379996e-06f, 6.018924856e-06f, 5.892497971e-06f, 5.766103649e-06f, 5.639746191e-06f, 5.513429887e-06f, 5.387159018e-06f, 
5.260937858e-06f, 5.134770667e-06f, 5.008661700e-06f, 4.882615198e-06f, 4.756635397e-06f, 4.630726518e-06f, 4.504892774e-06f, 4.379138369e-06f, 4.253467494e-06f, 4.127884332e-06f, 
4.002393052e-06f, 3.876997816e-06f, 3.751702772e-06f, 3.626512059e-06f, 3.501429803e-06f, 3.376460120e-06f, 3.251607115e-06f, 3.126874879e-06f, 3.002267495e-06f, 2.877789030e-06f, 
2.753443542e-06f, 2.629235076e-06f, 2.505167665e-06f, 2.381245330e-06f, 2.257472078e-06f, 2.133851906e-06f, 2.010388797e-06f, 1.887086720e-06f, 1.763949634e-06f, 1.640981481e-06f, 
1.518186195e-06f, 1.395567692e-06f, 1.273129878e-06f, 1.150876644e-06f, 1.028811866e-06f, 9.069394103e-07f, 7.852631258e-07f, 6.637868489e-07f, 5.425144021e-07f, 4.214495934e-07f, 
3.005962168e-07f, 1.799580519e-07f, 5.953886380e-08f, -6.065759690e-08f, -1.806275942e-07f, -3.003674070e-07f, -4.198733289e-07f, -5.391416686e-07f, -6.581687497e-07f, -7.769509111e-07f, 
-8.954845070e-07f, -1.013765907e-06f, -1.131791496e-06f, -1.249557674e-06f, -1.367060858e-06f, -1.484297480e-06f, -1.601263987e-06f, -1.717956843e-06f, -1.834372529e-06f, -1.950507540e-06f, 
-2.066358388e-06f, -2.181921602e-06f, -2.297193728e-06f, -2.412171325e-06f, -2.526850973e-06f, -2.641229267e-06f, -2.755302817e-06f, -2.869068253e-06f, -2.982522220e-06f, -3.095661380e-06f, 
-3.208482413e-06f, -3.320982016e-06f, -3.433156903e-06f, -3.545003806e-06f, -3.656519473e-06f, -3.767700671e-06f, -3.878544184e-06f, -3.989046814e-06f, -4.099205381e-06f, -4.209016723e-06f, 
-4.318477695e-06f, -4.427585170e-06f, -4.536336041e-06f, -4.644727217e-06f, -4.752755626e-06f, -4.860418215e-06f, -4.967711948e-06f, -5.074633809e-06f, -5.181180801e-06f, -5.287349943e-06f, 
-5.393138274e-06f, -5.498542853e-06f, -5.603560757e-06f, -5.708189081e-06f, -5.812424940e-06f, -5.916265468e-06f, -6.019707817e-06f, -6.122749160e-06f, -6.225386688e-06f, -6.327617612e-06f, 
-6.429439161e-06f, -6.530848584e-06f, -6.631843151e-06f, -6.732420150e-06f, -6.832576889e-06f, -6.932310695e-06f, -7.031618917e-06f, -7.130498920e-06f, -7.228948092e-06f, -7.326963840e-06f, 
-7.424543590e-06f, -7.521684790e-06f, -7.618384906e-06f, -7.714641425e-06f, -7.810451854e-06f, -7.905813721e-06f, -8.000724573e-06f, -8.095181977e-06f, -8.189183523e-06f, -8.282726818e-06f, 
-8.375809492e-06f, -8.468429194e-06f, -8.560583594e-06f, -8.652270384e-06f, -8.743487273e-06f, -8.834231995e-06f, -8.924502301e-06f, -9.014295965e-06f, -9.103610782e-06f, -9.192444566e-06f, 
-9.280795153e-06f, -9.368660400e-06f, -9.456038184e-06f, -9.542926405e-06f, -9.629322982e-06f, -9.715225855e-06f, -9.800632987e-06f, -9.885542361e-06f, -9.969951980e-06f, -1.005385987e-05f, 
-1.013726408e-05f, -1.022016267e-05f, -1.030255374e-05f, -1.038443539e-05f, -1.046580575e-05f, -1.054666299e-05f, -1.062700526e-05f, -1.070683078e-05f, -1.078613775e-05f, -1.086492442e-05f, 
-1.094318904e-05f, -1.102092989e-05f, -1.109814529e-05f, -1.117483354e-05f, -1.125099301e-05f, -1.132662206e-05f, -1.140171907e-05f, -1.147628245e-05f, -1.155031065e-05f, -1.162380211e-05f, 
-1.169675531e-05f, -1.176916874e-05f, -1.184104093e-05f, -1.191237042e-05f, -1.198315577e-05f, -1.205339556e-05f, -1.212308839e-05f, -1.219223291e-05f, -1.226082775e-05f, -1.232887158e-05f, 
-1.239636311e-05f, -1.246330104e-05f, -1.252968410e-05f, -1.259551107e-05f, -1.266078071e-05f, -1.272549184e-05f, -1.278964326e-05f, -1.285323384e-05f, -1.291626243e-05f, -1.297872792e-05f, 
-1.304062922e-05f, -1.310196527e-05f, -1.316273502e-05f, -1.322293745e-05f, -1.328257155e-05f, -1.334163633e-05f, -1.340013086e-05f, -1.345805417e-05f, -1.351540537e-05f, -1.357218355e-05f, 
-1.362838785e-05f, -1.368401741e-05f, -1.373907140e-05f, -1.379354902e-05f, -1.384744948e-05f, -1.390077202e-05f, -1.395351590e-05f, -1.400568039e-05f, -1.405726479e-05f, -1.410826843e-05f, 
-1.415869066e-05f, -1.420853083e-05f, -1.425778834e-05f, -1.430646260e-05f, -1.435455303e-05f, -1.440205908e-05f, -1.444898024e-05f, -1.449531599e-05f, -1.454106585e-05f, -1.458622936e-05f, 
-1.463080608e-05f, -1.467479558e-05f, -1.471819748e-05f, -1.476101138e-05f, -1.480323694e-05f, -1.484487383e-05f, -1.488592172e-05f, -1.492638032e-05f, -1.496624937e-05f, -1.500552862e-05f, 
-1.504421783e-05f, -1.508231680e-05f, -1.511982535e-05f, -1.515674330e-05f, -1.519307050e-05f, -1.522880685e-05f, -1.526395223e-05f, -1.529850656e-05f, -1.533246979e-05f, -1.536584186e-05f, 
-1.539862277e-05f, -1.543081250e-05f, -1.546241109e-05f, -1.549341858e-05f, -1.552383502e-05f, -1.555366051e-05f, -1.558289514e-05f, -1.561153904e-05f, -1.563959236e-05f, -1.566705526e-05f, 
-1.569392792e-05f, -1.572021056e-05f, -1.574590339e-05f, -1.577100667e-05f, -1.579552065e-05f, -1.581944564e-05f, -1.584278193e-05f, -1.586552985e-05f, -1.588768974e-05f, -1.590926198e-05f, 
-1.593024695e-05f, -1.595064506e-05f, -1.597045672e-05f, -1.598968240e-05f, -1.600832255e-05f, -1.602637765e-05f, -1.604384822e-05f, -1.606073477e-05f, -1.607703785e-05f, -1.609275803e-05f, 
-1.610789588e-05f, -1.612245200e-05f, -1.613642702e-05f, -1.614982158e-05f, -1.616263633e-05f, -1.617487195e-05f, -1.618652914e-05f, -1.619760861e-05f, -1.620811111e-05f, -1.621803737e-05f, 
-1.622738819e-05f, -1.623616433e-05f, -1.624436662e-05f, -1.625199588e-05f, -1.625905296e-05f, -1.626553873e-05f, -1.627145406e-05f, -1.627679985e-05f, -1.628157704e-05f, -1.628578655e-05f, 
-1.628942933e-05f, -1.629250638e-05f, -1.629501867e-05f, -1.629696721e-05f, -1.629835303e-05f, -1.629917719e-05f, -1.629944073e-05f, -1.629914475e-05f, -1.629829033e-05f, -1.629687860e-05f, 
-1.629491068e-05f, -1.629238773e-05f, -1.628931091e-05f, -1.628568141e-05f, -1.628150043e-05f, -1.627676919e-05f, -1.627148892e-05f, -1.626566088e-05f, -1.625928633e-05f, -1.625236656e-05f, 
-1.624490287e-05f, -1.623689658e-05f, -1.622834902e-05f, -1.621926156e-05f, -1.620963555e-05f, -1.619947238e-05f, -1.618877344e-05f, -1.617754017e-05f, -1.616577398e-05f, -1.615347633e-05f, 
-1.614064868e-05f, -1.612729251e-05f, -1.611340932e-05f, -1.609900061e-05f, -1.608406792e-05f, -1.606861278e-05f, -1.605263676e-05f, -1.603614142e-05f, -1.601912836e-05f, -1.600159917e-05f, 
-1.598355547e-05f, -1.596499890e-05f, -1.594593110e-05f, -1.592635374e-05f, -1.590626849e-05f, -1.588567705e-05f, -1.586458111e-05f, -1.584298240e-05f, -1.582088266e-05f, -1.579828363e-05f, 
-1.577518708e-05f, -1.575159478e-05f, -1.572750852e-05f, -1.570293011e-05f, -1.567786136e-05f, -1.565230411e-05f, -1.562626021e-05f, -1.559973151e-05f, -1.557271988e-05f, -1.554522721e-05f, 
-1.551725541e-05f, -1.548880637e-05f, -1.545988203e-05f, -1.543048433e-05f, -1.540061521e-05f, -1.537027664e-05f, -1.533947059e-05f, -1.530819906e-05f, -1.527646404e-05f, -1.524426755e-05f, 
-1.521161161e-05f, -1.517849827e-05f, -1.514492956e-05f, -1.511090756e-05f, -1.507643434e-05f, -1.504151198e-05f, -1.500614258e-05f, -1.497032825e-05f, -1.493407111e-05f, -1.489737329e-05f, 
-1.486023694e-05f, -1.482266420e-05f, -1.478465725e-05f, -1.474621826e-05f, -1.470734942e-05f, -1.466805292e-05f, -1.462833098e-05f, -1.458818581e-05f, -1.454761965e-05f, -1.450663473e-05f, 
-1.446523331e-05f, -1.442341764e-05f, -1.438119000e-05f, -1.433855267e-05f, -1.429550794e-05f, -1.425205811e-05f, -1.420820549e-05f, -1.416395240e-05f, -1.411930117e-05f, -1.407425413e-05f, 
-1.402881365e-05f, -1.398298207e-05f, -1.393676176e-05f, -1.389015510e-05f, -1.384316447e-05f, -1.379579226e-05f, -1.374804088e-05f, -1.369991274e-05f, -1.365141025e-05f, -1.360253585e-05f, 
-1.355329197e-05f, -1.350368105e-05f, -1.345370555e-05f, -1.340336792e-05f, -1.335267064e-05f, -1.330161617e-05f, -1.325020701e-05f, -1.319844564e-05f, -1.314633457e-05f, -1.309387629e-05f, 
-1.304107332e-05f, -1.298792819e-05f, -1.293444341e-05f, -1.288062153e-05f, -1.282646508e-05f, -1.277197661e-05f, -1.271715868e-05f, -1.266201384e-05f, -1.260654467e-05f, -1.255075373e-05f, 
-1.249464362e-05f, -1.243821691e-05f, -1.238147619e-05f, -1.232442407e-05f, -1.226706315e-05f, -1.220939604e-05f, -1.215142534e-05f, -1.209315370e-05f, -1.203458372e-05f, -1.197571804e-05f, 
-1.191655930e-05f, -1.185711014e-05f, -1.179737321e-05f, -1.173735115e-05f, -1.167704663e-05f, -1.161646231e-05f, -1.155560084e-05f, -1.149446490e-05f, -1.143305717e-05f, -1.137138032e-05f, 
-1.130943704e-05f, -1.124723001e-05f, -1.118476193e-05f, -1.112203548e-05f, -1.105905337e-05f, -1.099581830e-05f, -1.093233298e-05f, -1.086860011e-05f, -1.080462240e-05f, -1.074040257e-05f, 
-1.067594335e-05f, -1.061124745e-05f, -1.054631759e-05f, -1.048115651e-05f, -1.041576693e-05f, -1.035015158e-05f, -1.028431321e-05f, -1.021825455e-05f, -1.015197834e-05f, -1.008548733e-05f, 
-1.001878424e-05f, -9.951871843e-06f, -9.884752875e-06f, -9.817430087e-06f, -9.749906231e-06f, -9.682184062e-06f, -9.614266333e-06f, -9.546155802e-06f, -9.477855224e-06f, -9.409367360e-06f, 
-9.340694969e-06f, -9.271840811e-06f, -9.202807649e-06f, -9.133598245e-06f, -9.064215362e-06f, -8.994661763e-06f, -8.924940214e-06f, -8.855053478e-06f, -8.785004321e-06f, -8.714795508e-06f, 
-8.644429804e-06f, -8.573909974e-06f, -8.503238784e-06f, -8.432418998e-06f, -8.361453382e-06f, -8.290344698e-06f, -8.219095712e-06f, -8.147709187e-06f, -8.076187884e-06f, -8.004534566e-06f, 
-7.932751994e-06f, -7.860842927e-06f, -7.788810124e-06f, -7.716656344e-06f, -7.644384341e-06f, -7.571996873e-06f, -7.499496691e-06f, -7.426886548e-06f, -7.354169195e-06f, -7.281347380e-06f, 
-7.208423850e-06f, -7.135401350e-06f, -7.062282623e-06f, -6.989070409e-06f, -6.915767448e-06f, -6.842376475e-06f, -6.768900225e-06f, -6.695341429e-06f, -6.621702816e-06f, -6.547987111e-06f, 
-6.474197039e-06f, -6.400335320e-06f, -6.326404671e-06f, -6.252407808e-06f, -6.178347442e-06f, -6.104226280e-06f, -6.030047028e-06f, -5.955812388e-06f, -5.881525058e-06f, -5.807187731e-06f, 
-5.732803100e-06f, -5.658373851e-06f, -5.583902667e-06f, -5.509392228e-06f, -5.434845210e-06f, -5.360264282e-06f, -5.285652113e-06f, -5.211011366e-06f, -5.136344698e-06f, -5.061654764e-06f, 
-4.986944213e-06f, -4.912215690e-06f, -4.837471835e-06f, -4.762715283e-06f, -4.687948666e-06f, -4.613174608e-06f, -4.538395730e-06f, -4.463614648e-06f, -4.388833971e-06f, -4.314056305e-06f, 
-4.239284249e-06f, -4.164520397e-06f, -4.089767337e-06f, -4.015027654e-06f, -3.940303923e-06f, -3.865598716e-06f, -3.790914599e-06f, -3.716254132e-06f, -3.641619869e-06f, -3.567014356e-06f, 
-3.492440135e-06f, -3.417899742e-06f, -3.343395706e-06f, -3.268930548e-06f, -3.194506784e-06f, -3.120126925e-06f, -3.045793473e-06f, -2.971508923e-06f, -2.897275766e-06f, -2.823096483e-06f, 
-2.748973550e-06f, -2.674909436e-06f, -2.600906602e-06f, -2.526967502e-06f, -2.453094583e-06f, -2.379290285e-06f, -2.305557040e-06f, -2.231897273e-06f, -2.158313401e-06f, -2.084807835e-06f, 
-2.011382976e-06f, -1.938041218e-06f, -1.864784949e-06f, -1.791616547e-06f, -1.718538382e-06f, -1.645552818e-06f, -1.572662209e-06f, -1.499868902e-06f, -1.427175235e-06f, -1.354583538e-06f, 
-1.282096133e-06f, -1.209715333e-06f, -1.137443443e-06f, -1.065282760e-06f, -9.932355699e-07f, -9.213041532e-07f, -8.494907798e-07f, -7.777977112e-07f, -7.062272000e-07f, -6.347814899e-07f, 
-5.634628157e-07f, -4.922734030e-07f, -4.212154684e-07f, -3.502912193e-07f, -2.795028539e-07f, -2.088525611e-07f, -1.383425205e-07f, -6.797490212e-08f, 2.248133295e-09f, 7.232443459e-08f, 
1.422518602e-07f, 2.120282782e-07f, 2.816515663e-07f, 3.511196121e-07f, 4.204303128e-07f, 4.895815756e-07f, 5.585713176e-07f, 6.273974659e-07f, 6.960579575e-07f, 7.645507396e-07f, 
8.328737695e-07f, 9.010250146e-07f, 9.690024526e-07f, 1.036804072e-06f, 1.104427870e-06f, 1.171871856e-06f, 1.239134049e-06f, 1.306212480e-06f, 1.373105187e-06f, 1.439810221e-06f, 
1.506325645e-06f, 1.572649530e-06f, 1.638779959e-06f, 1.704715025e-06f, 1.770452834e-06f, 1.835991499e-06f, 1.901329148e-06f, 1.966463917e-06f, 2.031393955e-06f, 2.096117420e-06f, 
2.160632484e-06f, 2.224937327e-06f, 2.289030142e-06f, 2.352909133e-06f, 2.416572514e-06f, 2.480018513e-06f, 2.543245367e-06f, 2.606251324e-06f, 2.669034645e-06f, 2.731593603e-06f, 
2.793926481e-06f, 2.856031573e-06f, 2.917907186e-06f, 2.979551639e-06f, 3.040963260e-06f, 3.102140392e-06f, 3.163081388e-06f, 3.223784612e-06f, 3.284248442e-06f, 3.344471265e-06f, 
3.404451482e-06f, 3.464187506e-06f, 3.523677761e-06f, 3.582920682e-06f, 3.641914718e-06f, 3.700658328e-06f, 3.759149986e-06f, 3.817388176e-06f, 3.875371392e-06f, 3.933098145e-06f, 
3.990566955e-06f, 4.047776354e-06f, 4.104724888e-06f, 4.161411114e-06f, 4.217833601e-06f, 4.273990931e-06f, 4.329881699e-06f, 4.385504511e-06f, 4.440857985e-06f, 4.495940753e-06f, 
4.550751460e-06f, 4.605288760e-06f, 4.659551322e-06f, 4.713537828e-06f, 4.767246972e-06f, 4.820677458e-06f, 4.873828007e-06f, 4.926697348e-06f, 4.979284227e-06f, 5.031587399e-06f, 
5.083605634e-06f, 5.135337713e-06f, 5.186782430e-06f, 5.237938593e-06f, 5.288805021e-06f, 5.339380548e-06f, 5.389664017e-06f, 5.439654288e-06f, 5.489350230e-06f, 5.538750727e-06f, 
5.587854675e-06f, 5.636660985e-06f, 5.685168576e-06f, 5.733376385e-06f, 5.781283358e-06f, 5.828888456e-06f, 5.876190652e-06f, 5.923188933e-06f, 5.969882296e-06f, 6.016269755e-06f, 
6.062350334e-06f, 6.108123071e-06f, 6.153587016e-06f, 6.198741232e-06f, 6.243584797e-06f, 6.288116799e-06f, 6.332336342e-06f, 6.376242539e-06f, 6.419834520e-06f, 6.463111425e-06f, 
6.506072409e-06f, 6.548716638e-06f, 6.591043294e-06f, 6.633051568e-06f, 6.674740667e-06f, 6.716109810e-06f, 6.757158229e-06f, 6.797885168e-06f, 6.838289886e-06f, 6.878371653e-06f, 
6.918129754e-06f, 6.957563485e-06f, 6.996672155e-06f, 7.035455089e-06f, 7.073911621e-06f, 7.112041099e-06f, 7.149842887e-06f, 7.187316358e-06f, 7.224460899e-06f, 7.261275913e-06f, 
7.297760810e-06f, 7.333915020e-06f, 7.369737979e-06f, 7.405229142e-06f, 7.440387972e-06f, 7.475213948e-06f, 7.509706561e-06f, 7.543865315e-06f, 7.577689727e-06f, 7.611179326e-06f, 
7.644333654e-06f, 7.677152267e-06f, 7.709634733e-06f, 7.741780633e-06f, 7.773589561e-06f, 7.805061124e-06f, 7.836194941e-06f, 7.866990643e-06f, 7.897447877e-06f, 7.927566300e-06f, 
7.957345582e-06f, 7.986785406e-06f, 8.015885469e-06f, 8.044645479e-06f, 8.073065157e-06f, 8.101144237e-06f, 8.128882467e-06f, 8.156279604e-06f, 8.183335421e-06f, 8.210049702e-06f, 
8.236422245e-06f, 8.262452859e-06f, 8.288141365e-06f, 8.313487599e-06f, 8.338491408e-06f, 8.363152651e-06f, 8.387471200e-06f, 8.411446940e-06f, 8.435079767e-06f, 8.458369592e-06f, 
8.481316335e-06f, 8.503919930e-06f, 8.526180325e-06f, 8.548097477e-06f, 8.569671357e-06f, 8.590901948e-06f, 8.611789247e-06f, 8.632333260e-06f, 8.652534006e-06f, 8.672391519e-06f, 
8.691905842e-06f, 8.711077030e-06f, 8.729905153e-06f, 8.748390290e-06f, 8.766532534e-06f, 8.784331988e-06f, 8.801788769e-06f, 8.818903004e-06f, 8.835674835e-06f, 8.852104412e-06f, 
8.868191899e-06f, 8.883937472e-06f, 8.899341318e-06f, 8.914403636e-06f, 8.929124636e-06f, 8.943504540e-06f, 8.957543584e-06f, 8.971242012e-06f, 8.984600081e-06f, 8.997618061e-06f, 
9.010296231e-06f, 9.022634883e-06f, 9.034634320e-06f, 9.046294857e-06f, 9.057616820e-06f, 9.068600546e-06f, 9.079246383e-06f, 9.089554691e-06f, 9.099525842e-06f, 9.109160218e-06f, 
9.118458211e-06f, 9.127420226e-06f, 9.136046680e-06f, 9.144337998e-06f, 9.152294619e-06f, 9.159916990e-06f, 9.167205571e-06f, 9.174160833e-06f, 9.180783257e-06f, 9.187073334e-06f, 
9.193031569e-06f, 9.198658473e-06f, 9.203954571e-06f, 9.208920399e-06f, 9.213556501e-06f, 9.217863433e-06f, 9.221841763e-06f, 9.225492066e-06f, 9.228814930e-06f, 9.231810954e-06f, 
9.234480744e-06f, 9.236824920e-06f, 9.238844110e-06f, 9.240538953e-06f, 9.241910097e-06f, 9.242958203e-06f, 9.243683939e-06f, 9.244087985e-06f, 9.244171029e-06f, 9.243933772e-06f, 
9.243376921e-06f, 9.242501196e-06f, 9.241307325e-06f, 9.239796047e-06f, 9.237968110e-06f, 9.235824272e-06f, 9.233365301e-06f, 9.230591972e-06f, 9.227505073e-06f, 9.224105399e-06f, 
9.220393757e-06f, 9.216370960e-06f, 9.212037832e-06f, 9.207395208e-06f, 9.202443928e-06f, 9.197184846e-06f, 9.191618822e-06f, 9.185746725e-06f, 9.179569435e-06f, 9.173087839e-06f, 
9.166302834e-06f, 9.159215326e-06f, 9.151826229e-06f, 9.144136466e-06f, 9.136146969e-06f, 9.127858679e-06f, 9.119272545e-06f, 9.110389524e-06f, 9.101210583e-06f, 9.091736697e-06f, 
9.081968847e-06f, 9.071908026e-06f, 9.061555234e-06f, 9.050911477e-06f, 9.039977773e-06f, 9.028755145e-06f, 9.017244626e-06f, 9.005447255e-06f, 8.993364082e-06f, 8.980996162e-06f, 
8.968344558e-06f, 8.955410344e-06f, 8.942194598e-06f, 8.928698407e-06f, 8.914922867e-06f, 8.900869079e-06f, 8.886538154e-06f, 8.871931209e-06f, 8.857049369e-06f, 8.841893765e-06f, 
8.826465537e-06f, 8.810765832e-06f, 8.794795804e-06f, 8.778556613e-06f, 8.762049428e-06f, 8.745275423e-06f, 8.728235780e-06f, 8.710931688e-06f, 8.693364344e-06f, 8.675534948e-06f, 
8.657444711e-06f, 8.639094848e-06f, 8.620486582e-06f, 8.601621141e-06f, 8.582499762e-06f, 8.563123685e-06f, 8.543494159e-06f, 8.523612439e-06f, 8.503479785e-06f, 8.483097464e-06f, 
8.462466750e-06f, 8.441588921e-06f, 8.420465264e-06f, 8.399097068e-06f, 8.377485631e-06f, 8.355632256e-06f, 8.333538251e-06f, 8.311204931e-06f, 8.288633616e-06f, 8.265825631e-06f, 
8.242782308e-06f, 8.219504983e-06f, 8.195994998e-06f, 8.172253701e-06f, 8.148282444e-06f, 8.124082585e-06f, 8.099655488e-06f, 8.075002519e-06f, 8.050125054e-06f, 8.025024469e-06f, 
7.999702149e-06f, 7.974159481e-06f, 7.948397857e-06f, 7.922418677e-06f, 7.896223341e-06f, 7.869813257e-06f, 7.843189836e-06f, 7.816354495e-06f, 7.789308653e-06f, 7.762053736e-06f, 
7.734591173e-06f, 7.706922397e-06f, 7.679048846e-06f, 7.650971961e-06f, 7.622693188e-06f, 7.594213978e-06f, 7.565535784e-06f, 7.536660063e-06f, 7.507588278e-06f, 7.478321893e-06f, 
7.448862378e-06f, 7.419211205e-06f, 7.389369850e-06f, 7.359339794e-06f, 7.329122519e-06f, 7.298719513e-06f, 7.268132265e-06f, 7.237362268e-06f, 7.206411019e-06f, 7.175280018e-06f, 
7.143970768e-06f, 7.112484773e-06f, 7.080823544e-06f, 7.048988592e-06f, 7.016981431e-06f, 6.984803578e-06f, 6.952456555e-06f, 6.919941883e-06f, 6.887261088e-06f, 6.854415697e-06f, 
6.821407242e-06f, 6.788237255e-06f, 6.754907272e-06f, 6.721418829e-06f, 6.687773467e-06f, 6.653972727e-06f, 6.620018154e-06f, 6.585911294e-06f, 6.551653695e-06f, 6.517246907e-06f, 
6.482692481e-06f, 6.447991973e-06f, 6.413146937e-06f, 6.378158930e-06f, 6.343029512e-06f, 6.307760243e-06f, 6.272352685e-06f, 6.236808401e-06f, 6.201128956e-06f, 6.165315918e-06f, 
6.129370852e-06f, 6.093295328e-06f, 6.057090915e-06f, 6.020759186e-06f, 5.984301711e-06f, 5.947720063e-06f, 5.911015817e-06f, 5.874190548e-06f, 5.837245831e-06f, 5.800183242e-06f, 
5.763004359e-06f, 5.725710759e-06f, 5.688304020e-06f, 5.650785721e-06f, 5.613157442e-06f, 5.575420763e-06f, 5.537577262e-06f, 5.499628520e-06f, 5.461576119e-06f, 5.423421638e-06f, 
5.385166658e-06f, 5.346812760e-06f, 5.308361525e-06f, 5.269814533e-06f, 5.231173366e-06f, 5.192439604e-06f, 5.153614826e-06f, 5.114700613e-06f, 5.075698544e-06f, 5.036610199e-06f, 
4.997437156e-06f, 4.958180993e-06f, 4.918843288e-06f, 4.879425618e-06f, 4.839929559e-06f, 4.800356687e-06f, 4.760708577e-06f, 4.720986802e-06f, 4.681192935e-06f, 4.641328548e-06f, 
4.601395213e-06f, 4.561394500e-06f, 4.521327976e-06f, 4.481197210e-06f, 4.441003768e-06f, 4.400749216e-06f, 4.360435116e-06f, 4.320063032e-06f, 4.279634524e-06f, 4.239151152e-06f, 
4.198614473e-06f, 4.158026044e-06f, 4.117387419e-06f, 4.076700151e-06f, 4.035965791e-06f, 3.995185889e-06f, 3.954361991e-06f, 3.913495644e-06f, 3.872588390e-06f, 3.831641772e-06f, 
3.790657328e-06f, 3.749636595e-06f, 3.708581110e-06f, 3.667492404e-06f, 3.626372008e-06f, 3.585221450e-06f, 3.544042256e-06f, 3.502835950e-06f, 3.461604052e-06f, 3.420348080e-06f, 
3.379069551e-06f, 3.337769977e-06f, 3.296450869e-06f, 3.255113734e-06f, 3.213760078e-06f, 3.172391402e-06f, 3.131009206e-06f, 3.089614986e-06f, 3.048210235e-06f, 3.006796444e-06f, 
2.965375099e-06f, 2.923947685e-06f, 2.882515682e-06f, 2.841080569e-06f, 2.799643820e-06f, 2.758206906e-06f, 2.716771294e-06f, 2.675338449e-06f, 2.633909832e-06f, 2.592486901e-06f, 
2.551071109e-06f, 2.509663907e-06f, 2.468266741e-06f, 2.426881054e-06f, 2.385508287e-06f, 2.344149873e-06f, 2.302807246e-06f, 2.261481833e-06f, 2.220175058e-06f, 2.178888341e-06f, 
2.137623098e-06f, 2.096380742e-06f, 2.055162681e-06f, 2.013970317e-06f, 1.972805053e-06f, 1.931668282e-06f, 1.890561396e-06f, 1.849485783e-06f, 1.808442825e-06f, 1.767433901e-06f, 
1.726460385e-06f, 1.685523646e-06f, 1.644625050e-06f, 1.603765958e-06f, 1.562947725e-06f, 1.522171703e-06f, 1.481439239e-06f, 1.440751675e-06f, 1.400110350e-06f, 1.359516595e-06f, 
1.318971738e-06f, 1.278477103e-06f, 1.238034009e-06f, 1.197643768e-06f, 1.157307689e-06f, 1.117027077e-06f, 1.076803228e-06f, 1.036637438e-06f, 9.965309932e-07f, 9.564851785e-07f, 
9.165012717e-07f, 8.765805457e-07f, 8.367242684e-07f, 7.969337023e-07f, 7.572101047e-07f, 7.175547275e-07f, 6.779688174e-07f, 6.384536155e-07f, 5.990103576e-07f, 5.596402741e-07f, 
5.203445900e-07f, 4.811245244e-07f, 4.419812912e-07f, 4.029160986e-07f, 3.639301494e-07f, 3.250246403e-07f, 2.862007627e-07f, 2.474597022e-07f, 2.088026387e-07f, 1.702307463e-07f, 
1.317451932e-07f, 9.334714202e-08f, 5.503774928e-08f, 1.681816575e-08f, -2.131046372e-08f, -5.934700024e-08f, -9.729031088e-08f, -1.351392687e-07f, -1.728927528e-07f, -2.105496483e-07f, 
-2.481088464e-07f, -2.855692444e-07f, -3.229297458e-07f, -3.601892601e-07f, -3.973467032e-07f, -4.344009971e-07f, -4.713510699e-07f, -5.081958561e-07f, -5.449342965e-07f, -5.815653382e-07f, 
-6.180879345e-07f, -6.545010452e-07f, -6.908036365e-07f, -7.269946808e-07f, -7.630731571e-07f, -7.990380508e-07f, -8.348883537e-07f, -8.706230643e-07f, -9.062411875e-07f, -9.417417345e-07f, 
-9.771237234e-07f, -1.012386179e-06f, -1.047528131e-06f, -1.082548620e-06f, -1.117446687e-06f, -1.152221386e-06f, -1.186871773e-06f, -1.221396913e-06f, -1.255795877e-06f, -1.290067743e-06f, 
-1.324211595e-06f, -1.358226526e-06f, -1.392111632e-06f, -1.425866019e-06f, -1.459488800e-06f, -1.492979092e-06f, -1.526336021e-06f, -1.559558719e-06f, -1.592646326e-06f, -1.625597988e-06f, 
-1.658412858e-06f, -1.691090096e-06f, -1.723628869e-06f, -1.756028351e-06f, -1.788287723e-06f, -1.820406172e-06f, -1.852382894e-06f, -1.884217091e-06f, -1.915907971e-06f, -1.947454750e-06f, 
-1.978856653e-06f, -2.010112908e-06f, -2.041222753e-06f, -2.072185432e-06f, -2.103000197e-06f, -2.133666306e-06f, -2.164183025e-06f, -2.194549627e-06f, -2.224765392e-06f, -2.254829606e-06f, 
-2.284741564e-06f, -2.314500568e-06f, -2.344105926e-06f, -2.373556954e-06f, -2.402852975e-06f, -2.431993319e-06f, -2.460977323e-06f, -2.489804333e-06f, -2.518473701e-06f, -2.546984784e-06f, 
-2.575336951e-06f, -2.603529574e-06f, -2.631562034e-06f, -2.659433720e-06f, -2.687144027e-06f, -2.714692358e-06f, -2.742078123e-06f, -2.769300738e-06f, -2.796359630e-06f, -2.823254229e-06f, 
-2.849983975e-06f, -2.876548314e-06f, -2.902946700e-06f, -2.929178595e-06f, -2.955243466e-06f, -2.981140789e-06f, -3.006870048e-06f, -3.032430732e-06f, -3.057822340e-06f, -3.083044377e-06f, 
-3.108096354e-06f, -3.132977792e-06f, -3.157688217e-06f, -3.182227165e-06f, -3.206594175e-06f, -3.230788798e-06f, -3.254810590e-06f, -3.278659114e-06f, -3.302333941e-06f, -3.325834650e-06f, 
-3.349160826e-06f, -3.372312062e-06f, -3.395287958e-06f, -3.418088122e-06f, -3.440712169e-06f, -3.463159720e-06f, -3.485430405e-06f, -3.507523862e-06f, -3.529439733e-06f, -3.551177671e-06f, 
-3.572737333e-06f, -3.594118387e-06f, -3.615320505e-06f, -3.636343367e-06f, -3.657186662e-06f, -3.677850084e-06f, -3.698333335e-06f, -3.718636126e-06f, -3.738758173e-06f, -3.758699200e-06f, 
-3.778458937e-06f, -3.798037125e-06f, -3.817433508e-06f, -3.836647839e-06f, -3.855679879e-06f, -3.874529394e-06f, -3.893196159e-06f, -3.911679956e-06f, -3.929980574e-06f, -3.948097809e-06f, 
-3.966031463e-06f, -3.983781348e-06f, -4.001347280e-06f, -4.018729084e-06f, -4.035926592e-06f, -4.052939643e-06f, -4.069768082e-06f, -4.086411762e-06f, -4.102870543e-06f, -4.119144293e-06f, 
-4.135232886e-06f, -4.151136202e-06f, -4.166854129e-06f, -4.182386564e-06f, -4.197733408e-06f, -4.212894570e-06f, -4.227869966e-06f, -4.242659520e-06f, -4.257263161e-06f, -4.271680827e-06f, 
-4.285912461e-06f, -4.299958014e-06f, -4.313817444e-06f, -4.327490714e-06f, -4.340977798e-06f, -4.354278672e-06f, -4.367393322e-06f, -4.380321740e-06f, -4.393063923e-06f, -4.405619879e-06f, 
-4.417989619e-06f, -4.430173161e-06f, -4.442170533e-06f, -4.453981765e-06f, -4.465606897e-06f, -4.477045974e-06f, -4.488299050e-06f, -4.499366184e-06f, -4.510247440e-06f, -4.520942891e-06f, 
-4.531452617e-06f, -4.541776702e-06f, -4.551915238e-06f, -4.561868325e-06f, -4.571636067e-06f, -4.581218575e-06f, -4.590615968e-06f, -4.599828370e-06f, -4.608855913e-06f, -4.617698732e-06f, 
-4.626356973e-06f, -4.634830785e-06f, -4.643120324e-06f, -4.651225754e-06f, -4.659147244e-06f, -4.666884968e-06f, -4.674439108e-06f, -4.681809853e-06f, -4.688997397e-06f, -4.696001939e-06f, 
-4.702823687e-06f, -4.709462852e-06f, -4.715919654e-06f, -4.722194318e-06f, -4.728287074e-06f, -4.734198160e-06f, -4.739927819e-06f, -4.745476299e-06f, -4.750843857e-06f, -4.756030753e-06f, 
-4.761037254e-06f, -4.765863633e-06f, -4.770510169e-06f, -4.774977146e-06f, -4.779264856e-06f, -4.783373595e-06f, -4.787303664e-06f, -4.791055373e-06f, -4.794629034e-06f, -4.798024967e-06f, 
-4.801243498e-06f, -4.804284956e-06f, -4.807149680e-06f, -4.809838010e-06f, -4.812350295e-06f, -4.814686887e-06f, -4.816848146e-06f, -4.818834437e-06f, -4.820646127e-06f, -4.822283595e-06f, 
-4.823747218e-06f, -4.825037385e-06f, -4.826154487e-06f, -4.827098920e-06f, -4.827871086e-06f, -4.828471394e-06f, -4.828900255e-06f, -4.829158089e-06f, -4.829245318e-06f, -4.829162370e-06f, 
-4.828909680e-06f, -4.828487685e-06f, -4.827896831e-06f, -4.827137565e-06f, -4.826210341e-06f, -4.825115619e-06f, -4.823853863e-06f, -4.822425541e-06f, -4.820831127e-06f, -4.819071100e-06f, 
-4.817145943e-06f, -4.815056146e-06f, -4.812802200e-06f, -4.810384605e-06f, -4.807803863e-06f, -4.805060481e-06f, -4.802154972e-06f, -4.799087852e-06f, -4.795859643e-06f, -4.792470870e-06f, 
-4.788922066e-06f, -4.785213764e-06f, -4.781346504e-06f, -4.777320831e-06f, -4.773137293e-06f, -4.768796442e-06f, -4.764298838e-06f, -4.759645040e-06f, -4.754835615e-06f, -4.749871134e-06f, 
-4.744752170e-06f, -4.739479304e-06f, -4.734053117e-06f, -4.728474197e-06f, -4.722743135e-06f, -4.716860527e-06f, -4.710826972e-06f, -4.704643073e-06f, -4.698309438e-06f, -4.691826678e-06f, 
-4.685195409e-06f, -4.678416250e-06f, -4.671489823e-06f, -4.664416757e-06f, -4.657197681e-06f, -4.649833231e-06f, -4.642324044e-06f, -4.634670762e-06f, -4.626874032e-06f, -4.618934502e-06f, 
-4.610852825e-06f, -4.602629659e-06f, -4.594265661e-06f, -4.585761498e-06f, -4.577117834e-06f, -4.568335341e-06f, -4.559414693e-06f, -4.550356566e-06f, -4.541161642e-06f, -4.531830604e-06f, 
-4.522364139e-06f, -4.512762937e-06f, -4.503027693e-06f, -4.493159102e-06f, -4.483157866e-06f, -4.473024686e-06f, -4.462760268e-06f, -4.452365323e-06f, -4.441840562e-06f, -4.431186699e-06f, 
-4.420404454e-06f, -4.409494546e-06f, -4.398457700e-06f, -4.387294643e-06f, -4.376006103e-06f, -4.364592812e-06f, -4.353055507e-06f, -4.341394923e-06f, -4.329611802e-06f, -4.317706887e-06f, 
-4.305680922e-06f, -4.293534656e-06f, -4.281268839e-06f, -4.268884225e-06f, -4.256381568e-06f, -4.243761628e-06f, -4.231025163e-06f, -4.218172938e-06f, -4.205205716e-06f, -4.192124265e-06f, 
-4.178929354e-06f, -4.165621756e-06f, -4.152202244e-06f, -4.138671594e-06f, -4.125030585e-06f, -4.111279996e-06f, -4.097420611e-06f, -4.083453212e-06f, -4.069378587e-06f, -4.055197524e-06f, 
-4.040910813e-06f, -4.026519246e-06f, -4.012023617e-06f, -3.997424721e-06f, -3.982723357e-06f, -3.967920322e-06f, -3.953016418e-06f, -3.938012448e-06f, -3.922909215e-06f, -3.907707526e-06f, 
-3.892408188e-06f, -3.877012010e-06f, -3.861519801e-06f, -3.845932374e-06f, -3.830250543e-06f, -3.814475121e-06f, -3.798606926e-06f, -3.782646773e-06f, -3.766595482e-06f, -3.750453873e-06f, 
-3.734222768e-06f, -3.717902987e-06f, -3.701495355e-06f, -3.685000696e-06f, -3.668419837e-06f, -3.651753603e-06f, -3.635002823e-06f, -3.618168325e-06f, -3.601250939e-06f, -3.584251497e-06f, 
-3.567170828e-06f, -3.550009767e-06f, -3.532769145e-06f, -3.515449798e-06f, -3.498052559e-06f, -3.480578264e-06f, -3.463027751e-06f, -3.445401854e-06f, -3.427701412e-06f, -3.409927264e-06f, 
-3.392080247e-06f, -3.374161200e-06f, -3.356170965e-06f, -3.338110379e-06f, -3.319980285e-06f, -3.301781523e-06f, -3.283514934e-06f, -3.265181360e-06f, -3.246781642e-06f, -3.228316624e-06f, 
-3.209787148e-06f, -3.191194055e-06f, -3.172538190e-06f, -3.153820394e-06f, -3.135041512e-06f, -3.116202385e-06f, -3.097303857e-06f, -3.078346772e-06f, -3.059331973e-06f, -3.040260302e-06f, 
-3.021132603e-06f, -3.001949718e-06f, -2.982712490e-06f, -2.963421763e-06f, -2.944078377e-06f, -2.924683176e-06f, -2.905237001e-06f, -2.885740694e-06f, -2.866195095e-06f, -2.846601047e-06f, 
-2.826959388e-06f, -2.807270960e-06f, -2.787536601e-06f, -2.767757151e-06f, -2.747933449e-06f, -2.728066332e-06f, -2.708156638e-06f, -2.688205203e-06f, -2.668212864e-06f, -2.648180457e-06f, 
-2.628108816e-06f, -2.607998775e-06f, -2.587851167e-06f, -2.567666826e-06f, -2.547446582e-06f, -2.527191267e-06f, -2.506901711e-06f, -2.486578743e-06f, -2.466223191e-06f, -2.445835882e-06f, 
-2.425417643e-06f, -2.404969298e-06f, -2.384491673e-06f, -2.363985589e-06f, -2.343451869e-06f, -2.322891334e-06f, -2.302304804e-06f, -2.281693096e-06f, -2.261057029e-06f, -2.240397418e-06f, 
-2.219715078e-06f, -2.199010823e-06f, -2.178285465e-06f, -2.157539814e-06f, -2.136774680e-06f, -2.115990871e-06f, -2.095189194e-06f, -2.074370454e-06f, -2.053535454e-06f, -2.032684997e-06f, 
-2.011819882e-06f, -1.990940910e-06f, -1.970048877e-06f, -1.949144580e-06f, -1.928228812e-06f, -1.907302366e-06f, -1.886366033e-06f, -1.865420601e-06f, -1.844466859e-06f, -1.823505592e-06f, 
-1.802537583e-06f, -1.781563615e-06f, -1.760584467e-06f, -1.739600918e-06f, -1.718613744e-06f, -1.697623720e-06f, -1.676631618e-06f, -1.655638208e-06f, -1.634644259e-06f, -1.613650538e-06f, 
-1.592657808e-06f, -1.571666833e-06f, -1.550678372e-06f, -1.529693184e-06f, -1.508712025e-06f, -1.487735648e-06f, -1.466764806e-06f, -1.445800248e-06f, -1.424842720e-06f, -1.403892969e-06f, 
-1.382951737e-06f, -1.362019765e-06f, -1.341097789e-06f, -1.320186547e-06f, -1.299286772e-06f, -1.278399195e-06f, -1.257524544e-06f, -1.236663546e-06f, -1.215816925e-06f, -1.194985401e-06f, 
-1.174169694e-06f, -1.153370520e-06f, -1.132588593e-06f, -1.111824624e-06f, -1.091079322e-06f, -1.070353393e-06f, -1.049647540e-06f, -1.028962464e-06f, -1.008298864e-06f, -9.876574346e-07f, 
-9.670388691e-07f, -9.464438576e-07f, -9.258730875e-07f, -9.053272434e-07f, -8.848070073e-07f, -8.643130583e-07f, -8.438460726e-07f, -8.234067238e-07f, -8.029956826e-07f, -7.826136166e-07f, 
-7.622611910e-07f, -7.419390677e-07f, -7.216479058e-07f, -7.013883615e-07f, -6.811610881e-07f, -6.609667358e-07f, -6.408059520e-07f, -6.206793811e-07f, -6.005876642e-07f, -5.805314396e-07f, 
-5.605113427e-07f, -5.405280055e-07f, -5.205820572e-07f, -5.006741237e-07f, -4.808048279e-07f, -4.609747896e-07f, -4.411846255e-07f, -4.214349489e-07f, -4.017263702e-07f, -3.820594964e-07f, 
-3.624349315e-07f, -3.428532762e-07f, -3.233151280e-07f, -3.038210810e-07f, -2.843717263e-07f, -2.649676515e-07f, -2.456094409e-07f, -2.262976759e-07f, -2.070329340e-07f, -1.878157899e-07f, 
-1.686468146e-07f, -1.495265759e-07f, -1.304556381e-07f, -1.114345625e-07f, -9.246390654e-08f, -7.354422452e-08f, -5.467606726e-08f, -3.585998217e-08f, -1.709651321e-08f, 1.613799115e-09f, 
2.027041775e-08f, 3.887280911e-08f, 5.742044311e-08f, 7.591279315e-08f, 9.434933614e-08f, 1.127295525e-07f, 1.310529262e-07f, 1.493189447e-07f, 1.675270991e-07f, 1.856768839e-07f, 
2.037677973e-07f, 2.217993411e-07f, 2.397710206e-07f, 2.576823448e-07f, 2.755328260e-07f, 2.933219806e-07f, 3.110493283e-07f, 3.287143924e-07f, 3.463167001e-07f, 3.638557820e-07f, 
3.813311725e-07f, 3.987424096e-07f, 4.160890349e-07f, 4.333705940e-07f, 4.505866358e-07f, 4.677367132e-07f, 4.848203825e-07f, 5.018372040e-07f, 5.187867415e-07f, 5.356685628e-07f, 
5.524822391e-07f, 5.692273455e-07f, 5.859034609e-07f, 6.025101679e-07f, 6.190470529e-07f, 6.355137059e-07f, 6.519097208e-07f, 6.682346952e-07f, 6.844882307e-07f, 7.006699325e-07f, 
7.167794095e-07f, 7.328162745e-07f, 7.487801442e-07f, 7.646706389e-07f, 7.804873829e-07f, 7.962300042e-07f, 8.118981347e-07f, 8.274914100e-07f, 8.430094696e-07f, 8.584519569e-07f, 
8.738185189e-07f, 8.891088067e-07f, 9.043224751e-07f, 9.194591827e-07f, 9.345185921e-07f, 9.495003697e-07f, 9.644041855e-07f, 9.792297138e-07f, 9.939766323e-07f, 1.008644623e-06f, 
1.023233371e-06f, 1.037742567e-06f, 1.052171903e-06f, 1.066521076e-06f, 1.080789789e-06f, 1.094977745e-06f, 1.109084654e-06f, 1.123110228e-06f, 1.137054183e-06f, 1.150916241e-06f, 
1.164696125e-06f, 1.178393564e-06f, 1.192008289e-06f, 1.205540037e-06f, 1.218988547e-06f, 1.232353563e-06f, 1.245634832e-06f, 1.258832105e-06f, 1.271945139e-06f, 1.284973691e-06f, 
1.297917525e-06f, 1.310776408e-06f, 1.323550110e-06f, 1.336238406e-06f, 1.348841074e-06f, 1.361357896e-06f, 1.373788659e-06f, 1.386133153e-06f, 1.398391171e-06f, 1.410562511e-06f, 
1.422646974e-06f, 1.434644366e-06f, 1.446554495e-06f, 1.458377176e-06f, 1.470112224e-06f, 1.481759461e-06f, 1.493318711e-06f, 1.504789802e-06f, 1.516172566e-06f, 1.527466839e-06f, 
1.538672461e-06f, 1.549789276e-06f, 1.560817131e-06f, 1.571755877e-06f, 1.582605369e-06f, 1.593365466e-06f, 1.604036030e-06f, 1.614616928e-06f, 1.625108029e-06f, 1.635509208e-06f, 
1.645820342e-06f, 1.656041312e-06f, 1.666172005e-06f, 1.676212307e-06f, 1.686162113e-06f, 1.696021319e-06f, 1.705789824e-06f, 1.715467532e-06f, 1.725054351e-06f, 1.734550192e-06f, 
1.743954970e-06f, 1.753268604e-06f, 1.762491015e-06f, 1.771622131e-06f, 1.780661880e-06f, 1.789610196e-06f, 1.798467015e-06f, 1.807232280e-06f, 1.815905933e-06f, 1.824487923e-06f, 
1.832978201e-06f, 1.841376722e-06f, 1.849683446e-06f, 1.857898334e-06f, 1.866021354e-06f, 1.874052473e-06f, 1.881991665e-06f, 1.889838908e-06f, 1.897594181e-06f, 1.905257468e-06f, 
1.912828757e-06f, 1.920308038e-06f, 1.927695307e-06f, 1.934990560e-06f, 1.942193799e-06f, 1.949305030e-06f, 1.956324261e-06f, 1.963251503e-06f, 1.970086772e-06f, 1.976830088e-06f, 
1.983481471e-06f, 1.990040949e-06f, 1.996508549e-06f, 2.002884305e-06f, 2.009168253e-06f, 2.015360432e-06f, 2.021460885e-06f, 2.027469657e-06f, 2.033386799e-06f, 2.039212363e-06f, 
2.044946405e-06f, 2.050588986e-06f, 2.056140167e-06f, 2.061600014e-06f, 2.066968598e-06f, 2.072245991e-06f, 2.077432268e-06f, 2.082527510e-06f, 2.087531798e-06f, 2.092445218e-06f, 
2.097267860e-06f, 2.101999814e-06f, 2.106641177e-06f, 2.111192047e-06f, 2.115652526e-06f, 2.120022719e-06f, 2.124302733e-06f, 2.128492679e-06f, 2.132592672e-06f, 2.136602830e-06f, 
2.140523272e-06f, 2.144354122e-06f, 2.148095506e-06f, 2.151747555e-06f, 2.155310401e-06f, 2.158784179e-06f, 2.162169028e-06f, 2.165465091e-06f, 2.168672511e-06f, 2.171791436e-06f, 
2.174822018e-06f, 2.177764408e-06f, 2.180618765e-06f, 2.183385246e-06f, 2.186064016e-06f, 2.188655238e-06f, 2.191159080e-06f, 2.193575715e-06f, 2.195905315e-06f, 2.198148056e-06f, 
2.200304119e-06f, 2.202373686e-06f, 2.204356941e-06f, 2.206254072e-06f, 2.208065270e-06f, 2.209790727e-06f, 2.211430641e-06f, 2.212985209e-06f, 2.214454632e-06f, 2.215839116e-06f, 
2.217138866e-06f, 2.218354091e-06f, 2.219485005e-06f, 2.220531820e-06f, 2.221494755e-06f, 2.222374029e-06f, 2.223169865e-06f, 2.223882487e-06f, 2.224512123e-06f, 2.225059002e-06f, 
2.225523357e-06f, 2.225905423e-06f, 2.226205438e-06f, 2.226423640e-06f, 2.226560273e-06f, 2.226615581e-06f, 2.226589811e-06f, 2.226483213e-06f, 2.226296038e-06f, 2.226028541e-06f, 
2.225680978e-06f, 2.225253609e-06f, 2.224746693e-06f, 2.224160495e-06f, 2.223495281e-06f, 2.222751318e-06f, 2.221928877e-06f, 2.221028229e-06f, 2.220049651e-06f, 2.218993418e-06f, 
2.217859810e-06f, 2.216649108e-06f, 2.215361595e-06f, 2.213997556e-06f, 2.212557279e-06f, 2.211041054e-06f, 2.209449173e-06f, 2.207781928e-06f, 2.206039617e-06f, 2.204222535e-06f, 
2.202330985e-06f, 2.200365266e-06f, 2.198325684e-06f, 2.196212543e-06f, 2.194026151e-06f, 2.191766818e-06f, 2.189434855e-06f, 2.187030575e-06f, 2.184554294e-06f, 2.182006328e-06f, 
2.179386997e-06f, 2.176696620e-06f, 2.173935521e-06f, 2.171104023e-06f, 2.168202452e-06f, 2.165231137e-06f, 2.162190406e-06f, 2.159080590e-06f, 2.155902022e-06f, 2.152655038e-06f, 
2.149339971e-06f, 2.145957161e-06f, 2.142506947e-06f, 2.138989669e-06f, 2.135405670e-06f, 2.131755294e-06f, 2.128038887e-06f, 2.124256795e-06f, 2.120409368e-06f, 2.116496954e-06f, 
2.112519906e-06f, 2.108478577e-06f, 2.104373321e-06f, 2.100204494e-06f, 2.095972452e-06f, 2.091677556e-06f, 2.087320164e-06f, 2.082900638e-06f, 2.078419340e-06f, 2.073876634e-06f, 
2.069272886e-06f, 2.064608461e-06f, 2.059883729e-06f, 2.055099056e-06f, 2.050254815e-06f, 2.045351375e-06f, 2.040389110e-06f, 2.035368392e-06f, 2.030289598e-06f, 2.025153102e-06f, 
2.019959282e-06f, 2.014708516e-06f, 2.009401183e-06f, 2.004037664e-06f, 1.998618338e-06f, 1.993143590e-06f, 1.987613802e-06f, 1.982029358e-06f, 1.976390643e-06f, 1.970698044e-06f, 
1.964951948e-06f, 1.959152742e-06f, 1.953300815e-06f, 1.947396558e-06f, 1.941440361e-06f, 1.935432615e-06f, 1.929373712e-06f, 1.923264045e-06f, 1.917104009e-06f, 1.910893997e-06f, 
1.904634405e-06f, 1.898325629e-06f, 1.891968066e-06f, 1.885562113e-06f, 1.879108169e-06f, 1.872606631e-06f, 1.866057899e-06f, 1.859462375e-06f, 1.852820457e-06f, 1.846132547e-06f, 
1.839399047e-06f, 1.832620359e-06f, 1.825796886e-06f, 1.818929032e-06f, 1.812017200e-06f, 1.805061794e-06f, 1.798063220e-06f, 1.791021882e-06f, 1.783938186e-06f, 1.776812539e-06f, 
1.769645346e-06f, 1.762437015e-06f, 1.755187952e-06f, 1.747898565e-06f, 1.740569263e-06f, 1.733200453e-06f, 1.725792543e-06f, 1.718345943e-06f, 1.710861060e-06f, 1.703338306e-06f, 
1.695778088e-06f, 1.688180816e-06f, 1.680546901e-06f, 1.672876752e-06f, 1.665170780e-06f, 1.657429394e-06f, 1.649653005e-06f, 1.641842023e-06f, 1.633996860e-06f, 1.626117925e-06f, 
1.618205629e-06f, 1.610260384e-06f, 1.602282599e-06f, 1.594272686e-06f, 1.586231055e-06f, 1.578158116e-06f, 1.570054282e-06f, 1.561919961e-06f, 1.553755566e-06f, 1.545561505e-06f, 
1.537338189e-06f, 1.529086029e-06f, 1.520805435e-06f, 1.512496816e-06f, 1.504160582e-06f, 1.495797143e-06f, 1.487406907e-06f, 1.478990285e-06f, 1.470547684e-06f, 1.462079513e-06f, 
1.453586182e-06f, 1.445068096e-06f, 1.436525665e-06f, 1.427959296e-06f, 1.419369396e-06f, 1.410756371e-06f, 1.402120628e-06f, 1.393462573e-06f, 1.384782612e-06f, 1.376081149e-06f, 
1.367358589e-06f, 1.358615337e-06f, 1.349851797e-06f, 1.341068371e-06f, 1.332265464e-06f, 1.323443476e-06f, 1.314602811e-06f, 1.305743869e-06f, 1.296867052e-06f, 1.287972759e-06f, 
1.279061391e-06f, 1.270133346e-06f, 1.261189023e-06f, 1.252228819e-06f, 1.243253133e-06f, 1.234262361e-06f, 1.225256899e-06f, 1.216237141e-06f, 1.207203484e-06f, 1.198156320e-06f, 
1.189096043e-06f, 1.180023045e-06f, 1.170937718e-06f, 1.161840453e-06f, 1.152731641e-06f, 1.143611670e-06f, 1.134480930e-06f, 1.125339809e-06f, 1.116188692e-06f, 1.107027967e-06f, 
1.097858020e-06f, 1.088679233e-06f, 1.079491992e-06f, 1.070296678e-06f, 1.061093674e-06f, 1.051883361e-06f, 1.042666118e-06f, 1.033442325e-06f, 1.024212360e-06f, 1.014976600e-06f, 
1.005735421e-06f, 9.964891985e-07f, 9.872383066e-07f, 9.779831187e-07f, 9.687240068e-07f, 9.594613421e-07f, 9.501954948e-07f, 9.409268339e-07f, 9.316557273e-07f, 9.223825421e-07f, 
9.131076439e-07f, 9.038313976e-07f, 8.945541668e-07f, 8.852763138e-07f, 8.759982000e-07f, 8.667201857e-07f, 8.574426298e-07f, 8.481658902e-07f, 8.388903236e-07f, 8.296162854e-07f, 
8.203441300e-07f, 8.110742104e-07f, 8.018068784e-07f, 7.925424847e-07f, 7.832813785e-07f, 7.740239081e-07f, 7.647704202e-07f, 7.555212603e-07f, 7.462767729e-07f, 7.370373007e-07f, 
7.278031856e-07f, 7.185747678e-07f, 7.093523864e-07f, 7.001363790e-07f, 6.909270820e-07f, 6.817248304e-07f, 6.725299577e-07f, 6.633427963e-07f, 6.541636770e-07f, 6.449929292e-07f, 
6.358308810e-07f, 6.266778591e-07f, 6.175341886e-07f, 6.084001934e-07f, 5.992761959e-07f, 5.901625169e-07f, 5.810594759e-07f, 5.719673908e-07f, 5.628865783e-07f, 5.538173534e-07f, 
5.447600295e-07f, 5.357149188e-07f, 5.266823317e-07f, 5.176625773e-07f, 5.086559632e-07f, 4.996627952e-07f, 4.906833778e-07f, 4.817180140e-07f, 4.727670050e-07f, 4.638306506e-07f, 
4.549092490e-07f, 4.460030969e-07f, 4.371124892e-07f, 4.282377196e-07f, 4.193790797e-07f, 4.105368599e-07f, 4.017113488e-07f, 3.929028335e-07f, 3.841115993e-07f, 3.753379299e-07f, 
3.665821076e-07f, 3.578444129e-07f, 3.491251244e-07f, 3.404245195e-07f, 3.317428736e-07f, 3.230804605e-07f, 3.144375525e-07f, 3.058144200e-07f, 2.972113317e-07f, 2.886285549e-07f, 
2.800663548e-07f, 2.715249952e-07f, 2.630047381e-07f, 2.545058437e-07f, 2.460285706e-07f, 2.375731755e-07f, 2.291399136e-07f, 2.207290383e-07f, 2.123408010e-07f, 2.039754516e-07f, 
1.956332384e-07f, 1.873144075e-07f, 1.790192036e-07f, 1.707478695e-07f, 1.625006462e-07f, 1.542777731e-07f, 1.460794875e-07f, 1.379060253e-07f, 1.297576202e-07f, 1.216345045e-07f, 
1.135369085e-07f, 1.054650606e-07f, 9.741918762e-08f, 8.939951446e-08f, 8.140626423e-08f, 7.343965820e-08f, 6.549991584e-08f, 5.758725479e-08f, 4.970189087e-08f, 4.184403808e-08f, 
3.401390856e-08f, 2.621171265e-08f, 1.843765883e-08f, 1.069195374e-08f, 2.974802179e-09f, -4.713592892e-09f, -1.237303037e-08f, -2.000331100e-08f, -2.760423739e-08f, -3.517561399e-08f, 
-4.271724711e-08f, -5.022894494e-08f, -5.771051751e-08f, -6.516177674e-08f, -7.258253638e-08f, -7.997261208e-08f, -8.733182135e-08f, -9.465998358e-08f, -1.019569200e-07f, -1.092224538e-07f, 
-1.164564100e-07f, -1.236586154e-07f, -1.308288988e-07f, -1.379670909e-07f, -1.450730241e-07f, -1.521465330e-07f, -1.591874538e-07f, -1.661956247e-07f, -1.731708858e-07f, -1.801130790e-07f, 
-1.870220482e-07f, -1.938976390e-07f, -2.007396992e-07f, -2.075480782e-07f, -2.143226275e-07f, -2.210632002e-07f, -2.277696517e-07f, -2.344418388e-07f, -2.410796207e-07f, -2.476828582e-07f, 
-2.542514139e-07f, -2.607851526e-07f, -2.672839406e-07f, -2.737476465e-07f, -2.801761405e-07f, -2.865692947e-07f, -2.929269833e-07f, -2.992490822e-07f, -3.055354692e-07f, -3.117860240e-07f, 
-3.180006282e-07f, -3.241791654e-07f, -3.303215208e-07f, -3.364275817e-07f, -3.424972373e-07f, -3.485303785e-07f, -3.545268982e-07f, -3.604866911e-07f, -3.664096540e-07f, -3.722956852e-07f, 
-3.781446851e-07f, -3.839565560e-07f, -3.897312020e-07f, -3.954685290e-07f, -4.011684448e-07f, -4.068308592e-07f, -4.124556836e-07f, -4.180428315e-07f, -4.235922181e-07f, -4.291037606e-07f, 
-4.345773778e-07f, -4.400129905e-07f, -4.454105215e-07f, -4.507698952e-07f, -4.560910379e-07f, -4.613738777e-07f, -4.666183447e-07f, -4.718243707e-07f, -4.769918893e-07f, -4.821208360e-07f, 
-4.872111481e-07f, -4.922627647e-07f, -4.972756266e-07f, -5.022496767e-07f, -5.071848595e-07f, -5.120811213e-07f, -5.169384103e-07f, -5.217566764e-07f, -5.265358714e-07f, -5.312759487e-07f, 
-5.359768637e-07f, -5.406385735e-07f, -5.452610369e-07f, -5.498442146e-07f, -5.543880690e-07f, -5.588925644e-07f, -5.633576665e-07f, -5.677833432e-07f, -5.721695639e-07f, -5.765162998e-07f, 
-5.808235238e-07f, -5.850912107e-07f, -5.893193368e-07f, -5.935078803e-07f, -5.976568211e-07f, -6.017661408e-07f, -6.058358227e-07f, -6.098658518e-07f, -6.138562149e-07f, -6.178069005e-07f, 
-6.217178986e-07f, -6.255892011e-07f, -6.294208015e-07f, -6.332126950e-07f, -6.369648785e-07f, -6.406773506e-07f, -6.443501113e-07f, -6.479831627e-07f, -6.515765083e-07f, -6.551301531e-07f, 
-6.586441041e-07f, -6.621183697e-07f, -6.655529600e-07f, -6.689478868e-07f, -6.723031632e-07f, -6.756188044e-07f, -6.788948269e-07f, -6.821312489e-07f, -6.853280900e-07f, -6.884853718e-07f, 
-6.916031171e-07f, -6.946813504e-07f, -6.977200978e-07f, -7.007193871e-07f, -7.036792474e-07f, -7.065997096e-07f, -7.094808059e-07f, -7.123225702e-07f, -7.151250379e-07f, -7.178882459e-07f, 
-7.206122328e-07f, -7.232970384e-07f, -7.259427043e-07f, -7.285492735e-07f, -7.311167903e-07f, -7.336453008e-07f, -7.361348525e-07f, -7.385854942e-07f, -7.409972763e-07f, -7.433702507e-07f, 
-7.457044707e-07f, -7.479999910e-07f, -7.502568679e-07f, -7.524751589e-07f, -7.546549231e-07f, -7.567962210e-07f, -7.588991144e-07f, -7.609636667e-07f, -7.629899424e-07f, -7.649780078e-07f, 
-7.669279302e-07f, -7.688397784e-07f, -7.707136227e-07f, -7.725495345e-07f, -7.743475869e-07f, -7.761078540e-07f, -7.778304114e-07f, -7.795153361e-07f, -7.811627062e-07f, -7.827726014e-07f, 
-7.843451024e-07f, -7.858802914e-07f, -7.873782519e-07f, -7.888390686e-07f, -7.902628275e-07f, -7.916496158e-07f, -7.929995221e-07f, -7.943126361e-07f, -7.955890489e-07f, -7.968288526e-07f, 
-7.980321409e-07f, -7.991990084e-07f, -8.003295509e-07f, -8.014238656e-07f, -8.024820509e-07f, -8.035042061e-07f, -8.044904320e-07f, -8.054408303e-07f, -8.063555042e-07f, -8.072345576e-07f, 
-8.080780960e-07f, -8.088862258e-07f, -8.096590544e-07f, -8.103966907e-07f, -8.110992443e-07f, -8.117668262e-07f, -8.123995483e-07f, -8.129975238e-07f, -8.135608667e-07f, -8.140896923e-07f, 
-8.145841168e-07f, -8.150442576e-07f, -8.154702331e-07f, -8.158621626e-07f, -8.162201665e-07f, -8.165443664e-07f, -8.168348847e-07f, -8.170918448e-07f, -8.173153711e-07f, -8.175055892e-07f, 
-8.176626253e-07f, -8.177866069e-07f, -8.178776622e-07f, -8.179359206e-07f, -8.179615122e-07f, -8.179545682e-07f, -8.179152206e-07f, -8.178436024e-07f, -8.177398475e-07f, -8.176040905e-07f, 
-8.174364672e-07f, -8.172371141e-07f, -8.170061686e-07f, -8.167437689e-07f, -8.164500541e-07f, -8.161251642e-07f, -8.157692399e-07f, -8.153824229e-07f, -8.149648554e-07f, -8.145166808e-07f, 
-8.140380430e-07f, -8.135290869e-07f, -8.129899580e-07f, -8.124208026e-07f, -8.118217679e-07f, -8.111930017e-07f, -8.105346526e-07f, -8.098468699e-07f, -8.091298036e-07f, -8.083836046e-07f, 
-8.076084243e-07f, -8.068044148e-07f, -8.059717290e-07f, -8.051105205e-07f, -8.042209435e-07f, -8.033031527e-07f, -8.023573038e-07f, -8.013835528e-07f, -8.003820566e-07f, -7.993529726e-07f, 
-7.982964588e-07f, -7.972126738e-07f, -7.961017768e-07f, -7.949639278e-07f, -7.937992871e-07f, -7.926080156e-07f, -7.913902748e-07f, -7.901462270e-07f, -7.888760346e-07f, -7.875798609e-07f, 
-7.862578695e-07f, -7.849102246e-07f, -7.835370909e-07f, -7.821386337e-07f, -7.807150186e-07f, -7.792664118e-07f, -7.777929799e-07f, -7.762948901e-07f, -7.747723098e-07f, -7.732254072e-07f, 
-7.716543505e-07f, -7.700593088e-07f, -7.684404512e-07f, -7.667979475e-07f, -7.651319677e-07f, -7.634426824e-07f, -7.617302623e-07f, -7.599948787e-07f, -7.582367032e-07f, -7.564559077e-07f, 
-7.546526646e-07f, -7.528271464e-07f, -7.509795262e-07f, -7.491099772e-07f, -7.472186729e-07f, -7.453057873e-07f, -7.433714946e-07f, -7.414159692e-07f, -7.394393859e-07f, -7.374419196e-07f, 
-7.354237457e-07f, -7.333850397e-07f, -7.313259773e-07f, -7.292467344e-07f, -7.271474874e-07f, -7.250284126e-07f, -7.228896867e-07f, -7.207314865e-07f, -7.185539890e-07f, -7.163573714e-07f, 
-7.141418111e-07f, -7.119074856e-07f, -7.096545726e-07f, -7.073832499e-07f, -7.050936956e-07f, -7.027860876e-07f, -7.004606043e-07f, -6.981174239e-07f, -6.957567249e-07f, -6.933786858e-07f, 
-6.909834853e-07f, -6.885713020e-07f, -6.861423147e-07f, -6.836967022e-07f, -6.812346434e-07f, -6.787563173e-07f, -6.762619028e-07f, -6.737515788e-07f, -6.712255245e-07f, -6.686839189e-07f, 
-6.661269409e-07f, -6.635547696e-07f, -6.609675841e-07f, -6.583655633e-07f, -6.557488862e-07f, -6.531177318e-07f, -6.504722789e-07f, -6.478127063e-07f, -6.451391930e-07f, -6.424519175e-07f, 
-6.397510585e-07f, -6.370367946e-07f, -6.343093042e-07f, -6.315687657e-07f, -6.288153575e-07f, -6.260492575e-07f, -6.232706439e-07f, -6.204796946e-07f, -6.176765872e-07f, -6.148614995e-07f, 
-6.120346089e-07f, -6.091960927e-07f, -6.063461280e-07f, -6.034848918e-07f, -6.006125609e-07f, -5.977293119e-07f, -5.948353211e-07f, -5.919307648e-07f, -5.890158190e-07f, -5.860906593e-07f, 
-5.831554614e-07f, -5.802104006e-07f, -5.772556518e-07f, -5.742913900e-07f, -5.713177896e-07f, -5.683350250e-07f, -5.653432703e-07f, -5.623426991e-07f, -5.593334849e-07f, -5.563158009e-07f, 
-5.532898201e-07f, -5.502557149e-07f, -5.472136577e-07f, -5.441638203e-07f, -5.411063745e-07f, -5.380414916e-07f, -5.349693424e-07f, -5.318900976e-07f, -5.288039276e-07f, -5.257110021e-07f, 
-5.226114907e-07f, -5.195055627e-07f, -5.163933868e-07f, -5.132751313e-07f, -5.101509645e-07f, -5.070210538e-07f, -5.038855665e-07f, -5.007446695e-07f, -4.975985291e-07f, -4.944473113e-07f, 
-4.912911816e-07f, -4.881303053e-07f, -4.849648469e-07f, -4.817949708e-07f, -4.786208406e-07f, -4.754426198e-07f, -4.722604712e-07f, -4.690745571e-07f, -4.658850396e-07f, -4.626920800e-07f, 
-4.594958393e-07f, -4.562964779e-07f, -4.530941559e-07f, -4.498890326e-07f, -4.466812671e-07f, -4.434710177e-07f, -4.402584424e-07f, -4.370436985e-07f, -4.338269430e-07f, -4.306083320e-07f, 
-4.273880215e-07f, -4.241661666e-07f, -4.209429220e-07f, -4.177184418e-07f, -4.144928796e-07f, -4.112663883e-07f, -4.080391204e-07f, -4.048112277e-07f, -4.015828614e-07f, -3.983541722e-07f, 
-3.951253102e-07f, -3.918964248e-07f, -3.886676649e-07f, -3.854391787e-07f, -3.822111140e-07f, -3.789836176e-07f, -3.757568361e-07f, -3.725309151e-07f, -3.693059999e-07f, -3.660822349e-07f, 
-3.628597640e-07f, -3.596387304e-07f, -3.564192767e-07f, -3.532015448e-07f, -3.499856760e-07f, -3.467718108e-07f, -3.435600892e-07f, -3.403506505e-07f, -3.371436331e-07f, -3.339391751e-07f, 
-3.307374136e-07f, -3.275384852e-07f, -3.243425257e-07f, -3.211496702e-07f, -3.179600533e-07f, -3.147738085e-07f, -3.115910691e-07f, -3.084119672e-07f, -3.052366345e-07f, -3.020652019e-07f, 
-2.988977996e-07f, -2.957345570e-07f, -2.925756028e-07f, -2.894210650e-07f, -2.862710708e-07f, -2.831257468e-07f, -2.799852187e-07f, -2.768496115e-07f, -2.737190496e-07f, -2.705936563e-07f, 
-2.674735546e-07f, -2.643588663e-07f, -2.612497127e-07f, -2.581462144e-07f, -2.550484909e-07f, -2.519566613e-07f, -2.488708437e-07f, -2.457911555e-07f, -2.427177133e-07f, -2.396506330e-07f, 
-2.365900295e-07f, -2.335360171e-07f, -2.304887094e-07f, -2.274482188e-07f, -2.244146575e-07f, -2.213881363e-07f, -2.183687656e-07f, -2.153566550e-07f, -2.123519129e-07f, -2.093546474e-07f, 
-2.063649654e-07f, -2.033829732e-07f, -2.004087762e-07f, -1.974424791e-07f, -1.944841856e-07f, -1.915339987e-07f, -1.885920206e-07f, -1.856583526e-07f, -1.827330952e-07f, -1.798163480e-07f, 
-1.769082100e-07f, -1.740087790e-07f, -1.711181524e-07f, -1.682364264e-07f, -1.653636966e-07f, -1.625000576e-07f, -1.596456033e-07f, -1.568004266e-07f, -1.539646197e-07f, -1.511382740e-07f, 
-1.483214797e-07f, -1.455143267e-07f, -1.427169036e-07f, -1.399292983e-07f, -1.371515979e-07f, -1.343838887e-07f, -1.316262559e-07f, -1.288787842e-07f, -1.261415570e-07f, -1.234146573e-07f, 
-1.206981670e-07f, -1.179921671e-07f, -1.152967379e-07f, -1.126119587e-07f, -1.099379081e-07f, -1.072746636e-07f, -1.046223022e-07f, -1.019808996e-07f, -9.935053091e-08f, -9.673127039e-08f, 
-9.412319134e-08f, -9.152636622e-08f, -8.894086663e-08f, -8.636676331e-08f, -8.380412613e-08f, -8.125302410e-08f, -7.871352535e-08f, -7.618569717e-08f, -7.366960596e-08f, -7.116531726e-08f, 
-6.867289576e-08f, -6.619240525e-08f, -6.372390868e-08f, -6.126746813e-08f, -5.882314482e-08f, -5.639099908e-08f, -5.397109039e-08f, -5.156347737e-08f, -4.916821777e-08f, -4.678536846e-08f, 
-4.441498547e-08f, -4.205712396e-08f, -3.971183820e-08f, -3.737918163e-08f, -3.505920681e-08f, -3.275196544e-08f, -3.045750835e-08f, -2.817588554e-08f, -2.590714610e-08f, -2.365133831e-08f, 
-2.140850955e-08f, -1.917870637e-08f, -1.696197444e-08f, -1.475835859e-08f, -1.256790279e-08f, -1.039065015e-08f, -8.226642938e-09f, -6.075922549e-09f, -3.938529540e-09f, -1.814503616e-09f
};

AUD_NAMESPACE_END
