﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime/model/PhoneNumberCapabilities.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Chime
{
namespace Model
{

PhoneNumberCapabilities::PhoneNumberCapabilities(JsonView jsonValue)
{
  *this = jsonValue;
}

PhoneNumberCapabilities& PhoneNumberCapabilities::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("InboundCall"))
  {
    m_inboundCall = jsonValue.GetBool("InboundCall");
    m_inboundCallHasBeenSet = true;
  }
  if(jsonValue.ValueExists("OutboundCall"))
  {
    m_outboundCall = jsonValue.GetBool("OutboundCall");
    m_outboundCallHasBeenSet = true;
  }
  if(jsonValue.ValueExists("InboundSMS"))
  {
    m_inboundSMS = jsonValue.GetBool("InboundSMS");
    m_inboundSMSHasBeenSet = true;
  }
  if(jsonValue.ValueExists("OutboundSMS"))
  {
    m_outboundSMS = jsonValue.GetBool("OutboundSMS");
    m_outboundSMSHasBeenSet = true;
  }
  if(jsonValue.ValueExists("InboundMMS"))
  {
    m_inboundMMS = jsonValue.GetBool("InboundMMS");
    m_inboundMMSHasBeenSet = true;
  }
  if(jsonValue.ValueExists("OutboundMMS"))
  {
    m_outboundMMS = jsonValue.GetBool("OutboundMMS");
    m_outboundMMSHasBeenSet = true;
  }
  return *this;
}

JsonValue PhoneNumberCapabilities::Jsonize() const
{
  JsonValue payload;

  if(m_inboundCallHasBeenSet)
  {
   payload.WithBool("InboundCall", m_inboundCall);

  }

  if(m_outboundCallHasBeenSet)
  {
   payload.WithBool("OutboundCall", m_outboundCall);

  }

  if(m_inboundSMSHasBeenSet)
  {
   payload.WithBool("InboundSMS", m_inboundSMS);

  }

  if(m_outboundSMSHasBeenSet)
  {
   payload.WithBool("OutboundSMS", m_outboundSMS);

  }

  if(m_inboundMMSHasBeenSet)
  {
   payload.WithBool("InboundMMS", m_inboundMMS);

  }

  if(m_outboundMMSHasBeenSet)
  {
   payload.WithBool("OutboundMMS", m_outboundMMS);

  }

  return payload;
}

} // namespace Model
} // namespace Chime
} // namespace Aws
